"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformReportCodeToLocalizedMessages = exports.transformNotificationHistoryActionsLocalizedMessages = exports.transformAuditMainActionItemsLocalizedMessages = exports.transformMainActionItemsLocalizedMessages = exports.handleUserMainActionTypeChangeTranslations = void 0;
const i18n_1 = __importDefault(require("i18n"));
const app_enums_1 = require("../app.enums");
const app_util_1 = require("../app.util");
const dal_constants_1 = require("../dal/dal.constants");
const report_util_1 = require("./report/report.util");
function handleUserMainActionTypeChangeTranslations(actionType, changes, locale, userFullname, roles) {
    let result = {
        message: null,
        changes: [],
    };
    switch (actionType) {
        case app_enums_1.enums.UserMainActionType.UpdateIdentity:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEIDENTITY", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.InsertIdentity:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.INSERTIDENTITY", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.AddAccessRight:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.ADDRIGHT", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.RemoveAccessRight:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.REMOVERIGHT", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.AddCredential:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.ADDCREDENTIAL", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    let res = report_util_1.ReportConstants.CredentialTypes.find((f) => f.type == v.field);
                    if (res && res.description) {
                        item.field = i18n_1.default.__({ phrase: "PDF-REPORT." + res.description, locale });
                    }
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.RemoveCredential:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.REMOVECREDENTIAL", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    let res = report_util_1.ReportConstants.CredentialTypes.find((f) => f.type == v.field);
                    if (res && res.description) {
                        item.field = i18n_1.default.__({ phrase: "PDF-REPORT." + res.description, locale });
                    }
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.AssignUserToUserGroup:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.ADDUSERGROUP", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    item.field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + v.field.toUpperCase(), locale: locale });
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.RemoveUserFromUserGroup:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.REMOVEUSERGROUP", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    item.field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + v.field.toUpperCase(), locale: locale });
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.AssignUserToOrganizationUnit:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.ADDORGANIZATIONUNIT", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    item.field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + v.field.toUpperCase(), locale: locale });
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.RemoveUserFromOrganizationUnit:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.REMOVEORGANIZATIONUNIT", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    item.field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + v.field.toUpperCase(), locale: locale });
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.UpdateUserOrganizationUnitRole:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEORGANIZATIONUNITROLE", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY.ORGANIZATIONUNITROLE", locale: locale }),
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    let oldRole = roles.find((r) => r.name === v.oldValue);
                    let newRole = roles.find((r) => r.name === v.newValue);
                    item.oldValue = v.field + " / " + (oldRole?.typeId ? i18n_1.default.__({ phrase: v.oldValue.toUpperCase(), locale: locale }) : v.oldValue);
                    item.newValue = v.field + " / " + (newRole?.typeId ? i18n_1.default.__({ phrase: v.newValue.toUpperCase(), locale: locale }) : v.newValue);
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.UpdateProfile:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEPROFILE", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    item.field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + v.field.toUpperCase(), locale: locale });
                    if (v.field === "roleId") {
                        let oldRole = roles.find((r) => r.name === v.oldValue);
                        let newRole = roles.find((r) => r.name === v.newValue);
                        item.oldValue = oldRole.typeId ? i18n_1.default.__({ phrase: v.oldValue.toUpperCase(), locale: locale }) : v.oldValue;
                        item.newValue = newRole.typeId ? i18n_1.default.__({ phrase: v.newValue.toUpperCase(), locale: locale }) : v.newValue;
                    }
                    if (v.field === "isDisabled") {
                        item.oldValue = item.oldValue ? i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: locale }) : i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: locale });
                        item.newValue = item.newValue ? i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: locale }) : i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: locale });
                    }
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.AddForbiddenState:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.ADDFORBIDDEN", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateForbiddenState:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEFORBIDDEN", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.RemoveForbiddenState:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.REMOVEFORBIDDEN", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateCredential:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATECREDENTIAL", locale: locale }), [userFullname]);
            for (const v of changes) {
                let item = {
                    field: v.field,
                    oldValue: v.oldValue,
                    newValue: v.newValue,
                };
                if (v.needTranslate) {
                    let res = report_util_1.ReportConstants.CredentialTypes.find((f) => f.type == v.field);
                    if (res && res.description) {
                        item.field = i18n_1.default.__({ phrase: "PDF-REPORT." + res.description, locale });
                    }
                }
                result.changes.push(item);
            }
            break;
        case app_enums_1.enums.UserMainActionType.InsertAccessControlPoint:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.INSERTACCESSCONTROLPOINT", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateAccessControlPoint:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEACCESSCONTROLPOINT", locale: locale }), [userFullname]);
            for (const v of changes) {
                if (v.field === "states") {
                    let oldValue = v.oldValue;
                    let newValue = v.newValue;
                    let oldMessage = oldValue && oldValue.state === app_enums_1.enums.AccessControlPointState.Disabled
                        ? i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_DISABLED", locale: locale })
                        : oldValue && oldValue.state === app_enums_1.enums.AccessControlPointState.StayOpened
                            ? i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_STAYOPENED", locale: locale })
                            : i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_NORMAL", locale: locale });
                    let newMessage = newValue && newValue.state === app_enums_1.enums.AccessControlPointState.Disabled
                        ? i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_DISABLED", locale: locale })
                        : newValue && newValue.state === app_enums_1.enums.AccessControlPointState.StayOpened
                            ? i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_STAYOPENED", locale: locale })
                            : i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT.STATE_NORMAL", locale: locale });
                    let item = {
                        field: v.field,
                        oldValue: oldMessage,
                        newValue: newMessage,
                    };
                    if (v.needTranslate) {
                        item.field = i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT." + v.field.toUpperCase(), locale: locale });
                    }
                    result.changes.push(item);
                }
                else if (v.field === "authenticationFactors") {
                    let oldValue = v.oldValue;
                    let newValue = v.newValue;
                    let oldValueMessage = "";
                    let newValueMessage = "";
                    if (oldValue) {
                        oldValue.forEach((and) => {
                            let credType = report_util_1.ReportConstants.CredentialTypesByAuthenticationFactor.find((e) => e.type === and.factor);
                            oldValueMessage += i18n_1.default.__({ phrase: "EXCEL-REPORT." + credType.description, locale: locale });
                            oldValueMessage +=
                                and.authenticatorType === dal_constants_1.DalConstants.AuthenticatorTypeV3.User
                                    ? " (" + i18n_1.default.__({ phrase: "EXCEL-REPORT.USER", locale: locale }) + ") + "
                                    : " (" + i18n_1.default.__({ phrase: "EXCEL-REPORT.VISITOR", locale: locale }) + ") + ";
                        });
                    }
                    if (newValue) {
                        newValue.forEach((and) => {
                            let credType = report_util_1.ReportConstants.CredentialTypesByAuthenticationFactor.find((e) => e.type === and.factor);
                            newValueMessage += i18n_1.default.__({ phrase: "EXCEL-REPORT." + credType.description, locale: locale });
                            newValueMessage +=
                                and.authenticatorType === dal_constants_1.DalConstants.AuthenticatorTypeV3.User
                                    ? " (" + i18n_1.default.__({ phrase: "EXCEL-REPORT.USER", locale: locale }) + ") + "
                                    : " (" + i18n_1.default.__({ phrase: "EXCEL-REPORT.VISITOR", locale: locale }) + ") + ";
                        });
                    }
                    let item = {
                        field: v.field,
                        oldValue: oldValueMessage === "" ? null : oldValueMessage.substr(0, oldValueMessage.length - 2),
                        newValue: newValueMessage === "" ? null : newValueMessage.substr(0, newValueMessage.length - 2),
                    };
                    if (v.needTranslate) {
                        item.field = i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT." + v.field.toUpperCase(), locale: locale });
                    }
                    result.changes.push(item);
                }
                else {
                    let item = {
                        field: v.field,
                        oldValue: JSON.stringify(v.oldValue),
                        newValue: JSON.stringify(v.newValue),
                    };
                    if (v.needTranslate) {
                        item.field = i18n_1.default.__({ phrase: "UIFIELDS.ACCESSCONTROLPOINT." + v.field.toUpperCase(), locale: locale });
                    }
                    result.changes.push(item);
                }
            }
            break;
        case app_enums_1.enums.UserMainActionType.UpdateRelay:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATERELAY", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateStatusSensor:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATESTATUSSENSOR", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateCounterSensor:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATECOUNTERSENSOR", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.UpdateReader:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.UPDATEREADER", locale: locale }), [userFullname]);
            break;
        case app_enums_1.enums.UserMainActionType.AccountDeleted:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.USERACCOUNTDELETED", locale: locale }), [userFullname]);
            for (const change of changes) {
                const field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + change.field.toUpperCase(), locale: locale });
                result.changes.push({
                    field: field,
                    oldValue: change.oldValue,
                    newValue: change.newValue,
                });
            }
            break;
        case app_enums_1.enums.UserMainActionType.UsernameUpdated:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.USERNAMEUPDATE", locale: locale }), [userFullname]);
            for (const change of changes) {
                const field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + change.field.toUpperCase(), locale: locale });
                result.changes.push({
                    field: field,
                    oldValue: change.oldValue,
                    newValue: change.newValue,
                });
            }
            break;
        case app_enums_1.enums.UserMainActionType.AccountCreated:
            result.message = (0, app_util_1.stringFormat)(i18n_1.default.__({ phrase: "BASEAPI.ACTIONHISTORY.USERACCOUNTCREATED", locale: locale }), [userFullname]);
            for (const change of changes) {
                const field = i18n_1.default.__({ phrase: "UIFIELDS.IDENTITY." + change.field.toUpperCase(), locale: locale });
                result.changes.push({
                    field: field,
                    oldValue: change.oldValue,
                    newValue: change.newValue,
                });
            }
            break;
        default:
            break;
    }
    return result;
}
exports.handleUserMainActionTypeChangeTranslations = handleUserMainActionTypeChangeTranslations;
function transformMainActionItemsLocalizedMessages(items, locale, roles) {
    let result = [];
    for (const item of items) {
        let userFullname = item.actionUser.fullname;
        let translationResult = handleUserMainActionTypeChangeTranslations(item.action, item.changes || [], locale, userFullname, roles);
        result.push({
            action: item.action,
            actionUser: item.actionUser,
            actionUtc: item.actionUtc,
            message: translationResult.message,
            changes: translationResult.changes,
        });
    }
    return result;
}
exports.transformMainActionItemsLocalizedMessages = transformMainActionItemsLocalizedMessages;
function transformAuditMainActionItemsLocalizedMessages(items, locale, roles) {
    let results = [];
    for (const item of items) {
        let userFullname = item.actionUserCaptions[0].text[0];
        let translationResult = handleUserMainActionTypeChangeTranslations(item.action, item.changes || [], locale, userFullname, roles);
        let obj = {
            actionUserId: item.actionUserId,
            action: item.action,
            actionUserCaptions: item.actionUserCaptions,
            actionUtc: item.actionUtc,
            message: translationResult.message,
            changes: translationResult.changes,
            category: item.category,
        };
        obj = item.modifiedUserCaptions ? Object.assign({ modifiedUserCaptions: item.modifiedUserCaptions }, obj) : obj;
        obj = item.modifiedUserId ? Object.assign({ modifiedUserId: item.modifiedUserId }, obj) : obj;
        obj = item.accessControlPointName ? Object.assign({ accessControlPointName: item.accessControlPointName }, obj) : obj;
        obj = item.accessControlPointId ? Object.assign({ accessControlPointId: item.accessControlPointId }, obj) : obj;
        obj = item.terminalId ? Object.assign({ terminalId: item.terminalId }, obj) : obj;
        obj = item.terminalName ? Object.assign({ terminalName: item.terminalName }, obj) : obj;
        results.push(obj);
    }
    return results;
}
exports.transformAuditMainActionItemsLocalizedMessages = transformAuditMainActionItemsLocalizedMessages;
function transformNotificationHistoryActionsLocalizedMessages(locale, medium, state, notes) {
    let message;
    switch (state) {
        case 1:
            message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.PENDING", locale });
            break;
        case 2:
            message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.SENDING", locale });
            break;
        case 3:
            switch (notes[notes.length - 1].errorCode) {
                case app_enums_1.enums.ErrorCode.UserhasNoEmailAddress:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.USERHASNOEMAILADDRESS", locale });
                    break;
                case app_enums_1.enums.ErrorCode.NoOrganizaitionSmtpSettings:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.ORGANIZATIONHASNOSMTPSETTINGS", locale });
                    break;
                case app_enums_1.enums.ErrorCode.SmtpServerFailed:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.SMTPSERVERFAILED", locale });
                    break;
                case app_enums_1.enums.ErrorCode.UserHasNoNotificationToken:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.USERHASNONOTIFICATIONTOKEN", locale });
                    break;
                case app_enums_1.enums.ErrorCode.NoFirebasePrivateKey:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.ORGANIZATIONHASNOFIREBASEPRIVATEKEY", locale });
                    break;
                case app_enums_1.enums.ErrorCode.MissingReceiver:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.USERHASNONOTIFICATIONTOKEN", locale });
                    break;
                case app_enums_1.enums.ErrorCode.PushNotificationServerFailed:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.PUSHNOTIFICATIONSERVERFAILED", locale });
                    break;
                case app_enums_1.enums.ErrorCode.UserHasNoPhoneNumber:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.USERHASNOPHONENUMBER", locale });
                    break;
                case app_enums_1.enums.ErrorCode.NoOrganizaitionSmsSettings:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.ORGANIZATIONHASNOSMSSETTINGS", locale });
                    break;
                case app_enums_1.enums.ErrorCode.NoAmqpConnectionOrChannel:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.NOAMQPCONNECTIONORCHANNEL", locale });
                case app_enums_1.enums.ErrorCode.Unknown:
                default:
                    message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.UNKNOWNERROR", locale });
                    break;
            }
            break;
        case 4:
            message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.RECEIVED", locale });
            break;
        case 5:
            message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.READ", locale });
            break;
        case 6:
            message = i18n_1.default.__({ phrase: "NOTIFICATIONHISTORY.USERMEDIUMNOTALLOWED", locale }, { medium: "NOTIFICATION.MEDIUM." + i18n_1.default.__({ phrase: dal_constants_1.DalConstants.NotificationMedium[medium].toUpperCase(), locale }) });
            break;
    }
    return message;
}
exports.transformNotificationHistoryActionsLocalizedMessages = transformNotificationHistoryActionsLocalizedMessages;
function transformReportCodeToLocalizedMessages(reportCode, locale, customReportName) {
    let message;
    switch (reportCode) {
        case app_enums_1.enums.ReportCode.AccessLogs:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsFirstInLastOut:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.DAILY_FIRST_IN_LAST_OUT", locale: this._locale });
            break;
        case app_enums_1.enums.ReportCode.RegionState:
            message = i18n_1.default.__({ phrase: "PDF-REPORT.REGION_STATE", locale });
            break;
        case app_enums_1.enums.ReportCode.DurationInRegionReportOverview:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.SPENT_DURATION_IN_REGION", locale });
            break;
        case app_enums_1.enums.ReportCode.EntryByUnit:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ENTRY_BY_UNIT_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.SensorEvents:
            message = i18n_1.default.__({ phrase: "PDF-REPORT.SENSOR_EVENTS", locale });
            break;
        case app_enums_1.enums.ReportCode.Identity:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_LIST", locale });
            break;
        case app_enums_1.enums.ReportCode.Credential:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.CREDENTIALS", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsDailyWorkingHours:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.DAILY_WORKING_DETAILS_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.PermissionManagement:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.PERMISSION_MANAGEMENT", locale });
            break;
        case app_enums_1.enums.ReportCode.VisitorReport:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.VISITORS", locale });
            break;
        case app_enums_1.enums.ReportCode.TerminatedVisits:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.VISIT_RECORDS_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.RegionTicketUserUnits:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.CREDIT_MANAGEMENT", locale });
            break;
        case app_enums_1.enums.ReportCode.RegionTicketTransactions:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.UPLOAD_HISTORY", locale });
            break;
        case app_enums_1.enums.ReportCode.UserTicketUsage:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.UPLOAD_HISTORY", locale });
            break;
        case app_enums_1.enums.ReportCode.EmployeePermissionUsage:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.EMPLOYEE_PERMISSION_USAGE_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.FirstAndLastAccessLogs:
            message = i18n_1.default.__({ phrase: "PDF-REPORT.first_in_last_out", locale });
            break;
        case app_enums_1.enums.ReportCode.FirstAndLastAccessLogsForSingleUser:
            message = i18n_1.default.__({ phrase: "PDF-REPORT.first_in_last_out", locale });
            break;
        case app_enums_1.enums.ReportCode.EntryByUnit:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ENTRY_BY_UNIT_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.ForbiddenUsers:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.FORBIDDEN_USERS", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsMonthlyWorkingHoursSummary:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.WORK_SUMMARY_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsEmployeeWorkingHoursSummary:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.WORKING_DURATION_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.TerminalList:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.TERMINALS", locale });
            break;
        case app_enums_1.enums.ReportCode.VisitorCountReport:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.VISITOR_LIST", locale });
            break;
        case app_enums_1.enums.ReportCode.AnalysisVisitorsReport:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ANALYSIS_VISITORS", locale });
            break;
        case app_enums_1.enums.ReportCode.ArventoAccessLogsReport:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ARVENTO_ACCESS_LOGS", locale });
            break;
        case app_enums_1.enums.ReportCode.InstantAttendanceStatus:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.EMPLOYEE_INSTANT_ATTENDANCE_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsFirstInLastOutSummaryMultipleUsers:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.DAILY_FIRST_IN_LAST_OUT_SUMMARY", locale });
            break;
        case app_enums_1.enums.ReportCode.AuditLogsIdentity:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.AUDIT_IDENTITY_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.AuditLogsAccessControlPoint:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.AUDIT_ACCESS_CONTROL_POINT_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.AuditLogsTerminal:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.AUDIT_TERMINAL_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.AccessControlPointUsers:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_CONTROL_POINT_USERS_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.SystemFeedback:
            message = i18n_1.default.__({ phrase: "EXCEL-REPORT.FEEDBACK_REPORT", locale });
            break;
        case app_enums_1.enums.ReportCode.PacsMonthlyWorkingHoursSummaryExtraWork:
            message = i18n_1.default.__({ phrase: "REPORT.PACS_EXCEL_MONTHLY_EXTRA_HOURS", locale });
            break;
        case app_enums_1.enums.ReportCode.CustomReport:
            message = customReportName ?? i18n_1.default.__({ phrase: "EXCEL-REPORT.CUSTOM_REPORT", locale });
            break;
        default:
            message = "Report";
            break;
    }
    return message;
}
exports.transformReportCodeToLocalizedMessages = transformReportCodeToLocalizedMessages;
