"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.armonHookManager = exports.OrganizationHookModels = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const app_config_1 = require("../app.config");
const app_logs_1 = require("../app.logs");
const dal_utils_1 = require("../dal/dal.utils");
var OrganizationHookModels;
(function (OrganizationHookModels) {
    class IArmonHook {
        constructor() {
            this.customVisitorGenericSearch = null;
            this.customVisitGenericSearch = null;
            this.beforeVisitorSave = null;
            this.afterVisitorSave = null;
            this.afterTerminateVisit = null;
            this.validate = null;
            this.requestPPermissionNotificationList = null;
            this.requestDeputyInfo = null;
            this.moduleStatusChange = null;
            this.beforeAssingUserRegionTicketUnits = null;
            this.beforeUserInsert = null;
            this.beforeUserUpdate = null;
            this.monthlyReportSingleUser = null;
            this.monthlyReport = null;
            this.scheduledJobRoutine = null;
            this.onPrepareVisitorCameEmailNotification = null;
            this.onPrepareAccountCreatedEmailNotification = null;
            this.onPACSSelfAbsentEmployeeSMSNotification = null;
            this.onPACSSelfAbsentEmployeeEmailNotification = null;
            this.onPACSSelfOverworkedEmployeeSMSNotification = null;
            this.onPACSSelfOverworkedEmployeeEmailNotification = null;
            this.onPACSSelfMissingWorkEmailNotification = null;
            this.beforeSendEmergencyNotification = null;
            this.beforePreregisterVisit = null;
            this.afterPreregisterVisit = null;
            this.organizationCustomNotification = null;
            this.getPPermissionsClaimWindowRanges = null;
            this.getPPermissionsClaimWindowRangesBulk = null;
            this.afterIdentityUpsert = null;
            this.afterUserGroupSessionApply = null;
            this.permissionApprovementLevel = null;
            this.changePermissionApprovementLevel = null;
            this.beforeUpsertVisitor = null;
            this.afterSearchVisitorProfileForm = null;
            this.beforeUpdateOrganizationSettings = null;
            this.afterGetOrganizationSettings = null;
            this.sendNotificationOverride = null;
        }
    }
    OrganizationHookModels.IArmonHook = IArmonHook;
})(OrganizationHookModels = exports.OrganizationHookModels || (exports.OrganizationHookModels = {}));
class ArmonHookManager {
    constructor() {
        this._organizationHooks = {};
    }
    init() {
        try {
            app_logs_1.logger.info("starting armon hook manager");
            let extensionPath = path_1.default.resolve(".", app_config_1.appConfig.organizationBasedHookDirectory);
            if (fs_1.default.existsSync(extensionPath)) {
                let files = fs_1.default.readdirSync(extensionPath);
                for (const file of files) {
                    let fileName = file.replace(".js", "");
                    if (file.endsWith(".js") && (0, dal_utils_1.isUUID)(fileName)) {
                        let organizationHookPath = path_1.default.resolve(extensionPath, fileName);
                        let hook = require(organizationHookPath);
                        this._organizationHooks[fileName] = hook.CreateHook();
                    }
                }
            }
        }
        catch (error) {
            app_logs_1.logger.error("Organization based scripts has encountered error while loading %s", error);
            process.exit(1);
        }
    }
    getValidateHook(organizationId) {
        return this._organizationHooks[organizationId]?.validate;
    }
    getRequestDeputyInfoHook(organizationId) {
        return this._organizationHooks[organizationId]?.requestDeputyInfo;
    }
    getModuleStatusChangeHook(organizationId) {
        return this._organizationHooks[organizationId]?.moduleStatusChange;
    }
    getRequestPPermissionNotificationListHook(organizationId) {
        return this._organizationHooks[organizationId]?.requestPPermissionNotificationList;
    }
    getBeforeVisitorSaveHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforeVisitorSave;
    }
    getAfterVisitorSaveHook(organizationId) {
        return this._organizationHooks[organizationId]?.afterVisitorSave;
    }
    getAfterTerminateVisitHook(organizationId) {
        return this._organizationHooks[organizationId]?.afterTerminateVisit;
    }
    getCustomVisitorGenericSearchHook(organizationId) {
        return this._organizationHooks[organizationId]?.customVisitorGenericSearch;
    }
    getCustomVisitGenericSearchHook(organizationId) {
        return this._organizationHooks[organizationId]?.customVisitGenericSearch;
    }
    getBeforeAssingUserRegionTicketUnitsHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforeAssingUserRegionTicketUnits;
    }
    getBeforeUserInsertHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforeUserInsert;
    }
    getBeforeUserUpdateHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforeUserUpdate;
    }
    getMonthlyReportSingleUserHook(organizationId) {
        return this._organizationHooks[organizationId]?.monthlyReportSingleUser;
    }
    getMonthlyReportHook(organizationId) {
        return this._organizationHooks[organizationId]?.monthlyReport;
    }
    getScheduledJobRoutineHook(organizationId) {
        return this._organizationHooks[organizationId]?.scheduledJobRoutine;
    }
    getOnPrepareVisitorCameEmailNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPrepareVisitorCameEmailNotification;
    }
    getOnPrepareAccountCreatedEmailNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPrepareAccountCreatedEmailNotification;
    }
    getOnPACSSelfAbsentEmployeeSMSNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPACSSelfAbsentEmployeeSMSNotification;
    }
    getOnPACSSelfOverworkedEmployeeSMSNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPACSSelfOverworkedEmployeeSMSNotification;
    }
    getOnPACSSelfAbsentEmployeeEmailNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPACSSelfAbsentEmployeeEmailNotification;
    }
    getOnPACSSelfOverworkedEmployeeEmailNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPACSSelfOverworkedEmployeeEmailNotification;
    }
    getOnPACSSelfMissingWorkEmailNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.onPACSSelfMissingWorkEmailNotification;
    }
    getBeforeSendEmergencyNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforeSendEmergencyNotification;
    }
    getBeforePreregisterVisitHook(organizationId) {
        return this._organizationHooks[organizationId]?.beforePreregisterVisit;
    }
    getAfterPreregisterVisitHook(organizationId) {
        return this._organizationHooks[organizationId]?.afterPreregisterVisit;
    }
    getOrganizationCustomNotificationHook(organizationId) {
        return this._organizationHooks[organizationId]?.organizationCustomNotification;
    }
    getPPermissionsClaimWindowRangesHook(organizationId) {
        return this._organizationHooks[organizationId]?.getPPermissionsClaimWindowRanges;
    }
    getPPermissionsClaimWindowRangesBulkHook(organizationId) {
        return this._organizationHooks[organizationId]?.getPPermissionsClaimWindowRangesBulk;
    }
    getAfterIdentityUpsertHook(organizationId) {
        return this._organizationHooks[organizationId]?.afterIdentityUpsert;
    }
    getAfterUserGroupSessionApplyHook(organizationId) {
        return this._organizationHooks[organizationId]?.afterUserGroupSessionApply;
    }
    getPermissionApprovementLevelHook(organizationId) {
        return this._organizationHooks[organizationId]?.permissionApprovementLevel;
    }
    getChangePermissionApprovementOrderHook(organizationId) {
        return this._organizationHooks[organizationId]?.changePermissionApprovementLevel;
    }
    getAfterSearchVisitorProfileForm(organizationId) {
        return this._organizationHooks[organizationId]?.afterSearchVisitorProfileForm;
    }
    getBeforeVisitorUpsert(organizationId) {
        return this._organizationHooks[organizationId]?.beforeUpsertVisitor;
    }
    getBeforeUpdateOrganizationSettings(organizationId) {
        return this._organizationHooks[organizationId]?.beforeUpdateOrganizationSettings;
    }
    getAfterGetOrganizationSettings(organizationId) {
        return this._organizationHooks[organizationId]?.afterGetOrganizationSettings;
    }
    getSendNotificationOverride(organizationId) {
        return this._organizationHooks[organizationId]?.sendNotificationOverride;
    }
}
exports.armonHookManager = new ArmonHookManager();
