--
-- PostgreSQL database dump
--

-- Dumped from database version 13.3 (Debian 13.3-1.pgdg100+1)
-- Dumped by pg_dump version 13.3 (Debian 13.3-1.pgdg100+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: organization; Type: SCHEMA; Schema: -; Owner: armonsuper
--

CREATE SCHEMA organization;


ALTER SCHEMA organization OWNER TO armonsuper;

--
-- Name: public; Type: SCHEMA; Schema: -; Owner: armonsuper
--


CREATE SCHEMA IF NOT EXISTS public;

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;
COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';

CREATE EXTENSION IF NOT EXISTS unaccent WITH SCHEMA public;
COMMENT ON EXTENSION unaccent IS 'text search dictionary that removes accents';

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;
COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';



ALTER SCHEMA public OWNER TO armonsuper;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: armonsuper
--

COMMENT ON SCHEMA public IS 'standard public schema';


--
-- Name: add_recalculate_records_for_ppermission_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_ppermission_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    IF (TG_OP = 'INSERT') THEN

        RETURN NEW;
    ELSIF (TG_OP = 'UPDATE') THEN
        IF ( tstzRange(OLD."startDateTime", OLD."endDateTime") = tstzRange(NEW."startDateTime", NEW."endDateTime") AND OLD."status" = NEW."status") THEN
            RETURN NEW;
        ELSE
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization."userPPermissions" upp
            WHERE upp."ppermissionId" = NEW."id" AND eld."userId" = upp."userId" AND eld."organizationId" = NEW."organizationId"
            AND (NEW."startDateTime"::date <= now()::date OR OLD."startDateTime"::date <= now()::date)
            -- Make sure that status is newly approved or taken out from approved
            AND (((NEW."status" = 1 OR OLD."status" = 1) AND NEW."status" <> OLD."status")
                -- If the status did not change but is approved, check if the dates changed
                OR ((tstzRange(NEW."startDateTime", NEW."endDateTime") <> tstzRange(OLD."startDateTime", OLD."endDateTime"))AND NEW."status" = 1));

            INSERT INTO organization."recalculateWorkQueue"
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
            INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE
            -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.
                NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                -- Make sure that status is newly approved or taken out from approved
                AND (NEW."status" = 1 OR OLD."status" = 1);

            IF tstzRange(OLD."startDateTime", OLD."endDateTime") <> tstzRange(NEW."startDateTime", NEW."endDateTime") THEN
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16,
                    LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE 
                -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
                    NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                    -- Make sure that status is newly approved or taken out from approved
                    AND (NEW."status" = 1 OR OLD."status" = 1);
            END IF;
        END IF;
        RETURN NEW;
    ELSIF (TG_OP = 'DELETE') THEN
        UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
        FROM organization."userPPermissions" upp
        WHERE upp."ppermissionId" = OLD."id" AND eld."userId" = upp."userId" AND eld."organizationId" = OLD."organizationId"
        AND OLD."startDateTime"::date <= now()::date
        -- Make sure that status is newly approved or taken out from approved
        AND OLD."status" = 1;

        INSERT INTO organization."recalculateWorkQueue"
        (id, "userId", "organizationId", reason, "startDate")
        SELECT uuid_generate_v4(), upp."userId", OLD."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
        FROM organization."userWorkPlans" uwp
        INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
        INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
        INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = OLD."id" AND uwp."userId" = upp."userId"
        INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
            AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
        WHERE 
        -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
            NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
            -- Make sure that status is newly approved or taken out from approved
            AND OLD."status" = 1;

        RETURN OLD;
    END IF;
    END;
    $$;


ALTER FUNCTION organization.add_recalculate_records_for_ppermission_change() OWNER TO armonsuper;

--
-- Name: add_recalculate_records_for_user_ppermission_add_delete(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization.ppermissions pp
            WHERE pp."id" = NEW."ppermissionId" AND eld."userId" = NEW."userId" AND eld."organizationId" = pp."organizationId"
            AND pp."status" = 1 AND tstzRange(pp."startDateTime", pp."endDateTime") && tstzRange(eld."startAt", eld."expiredAt");
            
            INSERT INTO organization."recalculateWorkQueue" 
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), NEW."userId", pp."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization.ppermissions pp ON pp.id = NEW."ppermissionId" AND wp."organizationId" = pp."organizationId"
			INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND wp."organizationId" = uo."organizationId"
				AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE uwp."userId" = NEW."userId" AND pp."status" = 1
            AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"));
            
            RETURN NEW;
        ELSIF (TG_OP = 'DELETE') THEN
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization.ppermissions pp
            WHERE pp."id" = OLD."ppermissionId" AND eld."userId" = OLD."userId" AND eld."organizationId" = pp."organizationId"
            AND pp."status" = 1 AND tstzRange(pp."startDateTime", pp."endDateTime") && tstzRange(eld."startAt", eld."expiredAt");
            
            INSERT INTO organization."recalculateWorkQueue" 
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), OLD."userId", pp."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization.ppermissions pp ON pp.id = OLD."ppermissionId" AND wp."organizationId" = pp."organizationId"
			INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND wp."organizationId" = uo."organizationId"
				AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE uwp."userId" = OLD."userId" AND pp."status" = 1
            AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"));
            
            RETURN OLD;
        END IF;
        END;
        $$;


ALTER FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() OWNER TO armonsuper;

--
-- Name: add_recalculate_records_for_vacation_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_vacation_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
            IF(TG_OP = 'UPDATE' AND OLD."startDateTime" = NEW."startDateTime" AND OLD."endDateTime" = NEW."endDateTime") THEN
                RETURN NEW;
            END IF;
            
            IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
                UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 256, "updateRequiredRaisedAt" = now()
                FROM
                (SELECT "organizationId", "userId", "startAt", "expiredAt", (wpid.value->>0)::uuid AS "workPlanId"
                FROM
                organization."employeeLiveDay", jsonb_array_elements("workPlanIds") as wpid) T1
                INNER JOIN organization."workPlans" wp ON (wp."id"= T1."workPlanId")
                AND (wp."ignoreHolidays" is NULL OR wp."ignoreHolidays" is false) AND wp."deletedAt" IS NULL
                AND wp."organizationId" = T1."organizationId" AND wp."organizationId" = NEW."organizationId"
                AND T1."organizationId" = NEW."organizationId"
                WHERE eld."organizationId" = NEW."organizationId";
                
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), uwp."userId", NEW."organizationId", 256, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId" AND wp."organizationId" = NEW."organizationId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"));
                -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.	

            END IF;
            IF (TG_OP = 'UPDATE' OR TG_OP = 'DELETE') THEN
                UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 256, "updateRequiredRaisedAt" = now()
                FROM
                (SELECT "organizationId", "userId", "startAt", "expiredAt", (wpid.value->>0)::uuid AS "workPlanId"
                FROM
                organization."employeeLiveDay", jsonb_array_elements("workPlanIds") as wpid) T1
                INNER JOIN organization."workPlans" wp ON (wp."id"= T1."workPlanId")
                AND (wp."ignoreHolidays" is NULL OR wp."ignoreHolidays" is false) AND wp."deletedAt" IS NULL
                AND wp."organizationId" = T1."organizationId" AND wp."organizationId" = OLD."organizationId"
                AND T1."organizationId" = OLD."organizationId"
                WHERE eld."organizationId" = OLD."organizationId";
                
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), uwp."userId", OLD."organizationId", 256, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId" AND wp."organizationId" = OLD."organizationId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"));
            END IF;
            IF TG_OP = 'INSERT' OR TG_OP = 'UPDATE' THEN
                RETURN NEW;
            ELSE
                RETURN OLD;
            END IF;
        END;
        $$;


ALTER FUNCTION organization.add_recalculate_records_for_vacation_change() OWNER TO armonsuper;

--
-- Name: after_in_up_del_anti_passback_state(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_in_up_del_anti_passback_state() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			data_object		 	json;
			related_device_ids 	uuid[];
			res					text;
			region_id			uuid;
		BEGIN
			IF (TG_OP = 'DELETE') THEN
				region_id := OLD."regionId";
			ELSIF (TG_OP = 'INSERT') THEN
				region_id := NEW."regionId";
			ELSIF (TG_OP = 'UPDATE') THEN
				region_id := NEW."regionId";
			END IF;
			
			IF ((SELECT "antiPassback" FROM organization."regions" WHERE id = region_id) != TRUE) THEN
				RETURN NULL;
			END IF;
			IF (TG_OP = 'DELETE') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM organization."userAccessRights" as uar
						INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = OLD."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = OLD."userId" AND
							uar."deletedAt" IS NULL 
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', OLD."userId",
					'regionId', OLD."regionId",
					'state', 0,
					'actionDateISO', now());
			ELSIF (TG_OP = 'INSERT') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM organization."userAccessRights" as uar
						INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND	acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', NEW."userId",
					'regionId', NEW."regionId",
					'state', NEW."state",
					'actionDateISO', NEW."actionUtc",
					'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
					'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			ELSIF (TG_OP = 'UPDATE') THEN
				IF (OLD."userId" != NEW."userId" OR OLD."regionId" != NEW."regionId") THEN
					RETURN NULL;
				END IF;
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM organization."userAccessRights" as uar
						INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND
							acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
	
				data_object := JSON_BUILD_OBJECT(
						'userId', NEW."userId",
						'regionId', NEW."regionId",
						'state', NEW."state",
						'actionDateISO', NEW."actionUtc",
						'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
						'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			END IF;
			res :=JSON_BUILD_OBJECT(
						'data', data_object,
						'relatedDeviceIds', related_device_ids,
						'organizationId', TG_TABLE_SCHEMA)::text;
			PERFORM PG_NOTIFY('region_state_changes', res);
			RETURN NULL;
		END;
	$$;


ALTER FUNCTION organization.after_in_up_del_anti_passback_state() OWNER TO armonsuper;

--
-- Name: after_insert_terminal_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_insert_terminal_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
        INSERT INTO organization."terminalChangeTransactions"
        ("transactionId", "deviceId", "createdAt")
        VALUES (NEW."transactionId", NEW."deviceId", now())
        ON CONFLICT ON CONSTRAINT "terminalChangeTransactions_pkey" DO NOTHING;

        RETURN NULL;
    END;
$$;


ALTER FUNCTION organization.after_insert_terminal_change() OWNER TO armonsuper;

--
-- Name: after_insert_terminal_transaction(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_insert_terminal_transaction() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

    DECLARE
        device_id 	text;
    BEGIN
        device_id:= NEW."deviceId"::text;
        PERFORM PG_NOTIFY('terminal_changes', device_id);
        RETURN NULL;
    END;
$$;


ALTER FUNCTION organization.after_insert_terminal_transaction() OWNER TO armonsuper;

--
-- Name: after_update_organization_settings(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_update_organization_settings() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            organization_id 	text;
        BEGIN
            organization_id:= NEW.id:: text;
            PERFORM PG_NOTIFY('organization_settings_changed', organization_id);
            RETURN NULL;
        END;
    $$;


ALTER FUNCTION organization.after_update_organization_settings() OWNER TO armonsuper;

--
-- Name: before_insert_terminal_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_insert_terminal_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            config_change_count 	int;
        BEGIN
            IF (NEW."deviceId" IS NULL OR (SELECT COUNT(*) FROM organization."devices" WHERE id = NEW."deviceId") = 0) THEN
                RETURN NULL;
            END IF;
            IF (NEW."type" = 3)
            THEN
                SELECT COUNT(*) AS "count"
                FROM organization."terminalChanges"
                WHERE "sessionId" IS NULL AND 
                    "deviceId" = NEW."deviceId" AND
                    "type" = NEW."type"
                INTO config_change_count;
                IF (config_change_count != 0)
                    THEN
                    RETURN NULL;
                ELSE
                    RETURN NEW;
                END IF;
            END IF;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.before_insert_terminal_change() OWNER TO armonsuper;

--
-- Name: before_up_del_regions(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_regions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list	uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
			
			SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
			FROM organization."accessControlPoints" AS acp
			INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
			WHERE acp."deletedAt" IS NULL AND
				racp."regionId" = OLD."id"
			INTO device_id_list;
			
			IF (device_id_list IS NOT NULL) THEN
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
			END IF;
			RETURN OLD;
		ELSE
			IF (OLD."organizationId" != NEW."organizationId") THEN
				RAISE EXCEPTION 'Organization ID of region cannot be changed!';
			END IF;
			SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
			FROM organization."accessControlPoints" AS acp
			INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
			WHERE acp."deletedAt" IS NULL AND
				racp."regionId" = OLD."id"
			INTO device_id_list;
			
			IF (device_id_list IS NOT NULL) THEN
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
			END IF;
			RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_del_regions() OWNER TO armonsuper;

--
-- Name: before_up_del_user(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_user() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."id";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
            FROM
            (
                SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE u."id" = user_id
                -- GROUP BY acp."deviceId", u."id"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (NEW."publicKey" = OLD."publicKey")
            THEN
                RETURN NEW;
            ELSE
                    user_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                FROM
                (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'id', u."id",
                    'roleId', uo."roleId",
                    'isDisabled', uo."isDisabled",
                    'publicKey', NEW."publicKey",
                    'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                ) AS "data" FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."roles" AS r ON uo."roleId" = r."id"
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE u."id" = user_id
                --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_del_user() OWNER TO armonsuper;

--
-- Name: before_up_del_user_organizations(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_user_organizations() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_organization_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_organization_id:= OLD."id";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
            FROM
            (
                SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId", u."id"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_organization_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (NEW."roleId" != OLD."roleId" OR NEW."isDisabled" != OLD."isDisabled")
            THEN
                user_organization_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                FROM
                (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'id', u."id",
                    'roleId', NEW."roleId",
                    'isDisabled', NEW."isDisabled",
                    'publicKey', u."publicKey",
                    'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                ) AS "data" FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."roles" AS r ON uo."roleId" = r."id"
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_del_user_organizations() OWNER TO armonsuper;

--
-- Name: before_up_in_del_access_control_point(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_access_control_point() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            DECLARE
                transaction_id			uuid;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                new_available_factors		jsonb;
                factors_in_other_acps		jsonb;
                old_available_factors		jsonb;
                new_added_factors			jsonb;
                removed_factors				jsonb;
                factors_to_send_to_device		jsonb;
                t1					jsonb;
            BEGIN
        
                transaction_id := uuid_generate_v4();
                new_available_factors := '[]'::jsonb;
                factors_in_other_acps := '[]'::jsonb;
                old_available_factors := '[]'::jsonb;
                new_added_factors := '[]'::jsonb;
                removed_factors := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                
                 IF (TG_OP = 'DELETE') THEN
                 
                     INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                
                    IF NEW."organizationId" != OLD."organizationId" THEN
                        RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                    END IF;
    
                    IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF NEW."deviceId" != OLD."deviceId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                    END IF;
    
                    IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                        RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                    END IF;
                    -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            new_available_factors:= new_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            old_available_factors:= old_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                    FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                        FROM organization."accessControlPoints" AS acp
                        WHERE acp."deletedAt" IS NULL
                        AND acp."deviceId" = NEW."deviceId"
                        AND acp."id" != NEW."id"
                        AND acp."authenticationFactors" IS NOT NULL))
                    LOOP
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            j := j->'and';
                            FOR l IN SELECT * FROM jsonb_array_elements(j)
                            LOOP
                                t1:= jsonb_build_object(
                                    'authenticatorType', "l"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                THEN
                                    factors_in_other_acps:= factors_in_other_acps || t1;
                                END IF;
                            END LOOP;
                        END LOOP;
                    END LOOP;
    
                    -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (new_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                        LOOP
                            IF (POSITION (i::text IN old_available_factors::text) < 1)
                            THEN
                                new_added_factors:= new_added_factors || i;
                            END IF;
                        END LOOP;
                    END IF;
    
                    -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (old_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                        LOOP
                            IF (POSITION (i::text IN new_available_factors::text) < 1)
                            THEN
                                removed_factors:= removed_factors || i;
                            END IF;
                        END LOOP; 
                    END IF;
    
                    -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                    IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                 AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                           OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                        OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
    
                       )
                    THEN
                        INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
    
                    -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                    IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                    THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                        LOOP
                            IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionDateISO", 1 as "type",
                        json_build_object(
                            'id', T."id",
                            'userId', T."userId",
                            'type', T."type",
                            'data', T."data",
                            'groupNumber', T."groupNumber",
                            'specialData', T."specialData",
                            'specialDataSecondary', T."specialDataSecondary",
                            'expiresOnISO', T."expiresOn",
                            'extensionFields', T."extensionFields"
                        ) AS "data" FROM
                        (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                            uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                        FROM organization."userAccessRights" AS uar
                        INNER JOIN organization."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                        INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                        INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                        WHERE uar."accessControlPointId" = NEW."id"
                        AND uar."deletedAt" IS NULL 
                        AND uoc."deletedAt" IS NULL
                        AND uoc."organizationId" = NEW."organizationId"
                        AND uar."access" = TRUE
                        AND POSITION(jsonb_build_object(
                            'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                            'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_del_access_control_point() OWNER TO armonsuper;

--
-- Name: before_up_in_del_camera(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_camera() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    camera_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            camera_id:= OLD."id";
        ELSE
            camera_id:= NEW."id";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."cameras" AS c
        INNER JOIN organization."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
        INNER JOIN organization."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_camera() OWNER TO armonsuper;

--
-- Name: before_up_in_del_camera_actions(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_camera_actions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    camera_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            camera_id:= OLD."cameraId";
        ELSE
            camera_id:= NEW."cameraId";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."cameras" AS c
        INNER JOIN organization."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
        INNER JOIN organization."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_camera_actions() OWNER TO armonsuper;

--
-- Name: before_up_in_del_device_dry_contact_inputs(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_dry_contact_inputs() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
        transaction_id	uuid;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
            INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
            INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "integratedDeviceId" INTO main_device_id FROM organization."deviceIntegrations" WHERE "integratingDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
    
            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;
    
        END;
    $$;


ALTER FUNCTION organization.before_up_in_del_device_dry_contact_inputs() OWNER TO armonsuper;

--
-- Name: before_up_in_del_device_readers(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_readers() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id 		uuid;
    main_device_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            device_id:= OLD."deviceId";
        ELSE
            device_id:= NEW."deviceId";
        END IF;
        
        SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
                
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_device_readers() OWNER TO armonsuper;

--
-- Name: before_up_in_del_device_relays(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_relays() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id 		uuid;
    main_device_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            device_id:= OLD."deviceId";
        ELSE
            device_id:= NEW."deviceId";
        END IF;
        
        SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
                
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_device_relays() OWNER TO armonsuper;

--
-- Name: before_up_in_del_notification_access(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_notification_access() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id 	uuid;
			res 			text;
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					IF (OLD."targetUserId" IS NOT NULL) THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', OLD."id"
							) AS "data"
							FROM organization."userOrganizations" AS uo
							INNER JOIN organization."users" AS u ON uo."userId" = u."id"
							INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
							INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
							INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
							WHERE uo."userId" = OLD."targetUserId"
								AND uo."deletedAt" IS NULL
								AND u."deletedAt" IS NULL
								AND uar."deletedAt" IS NULL
								AND acp."deletedAt" IS NULL
								AND racp."regionId" = OLD."regionId"
						) AS T
						WHERE T."row_num" = 1;
					ELSE
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', OLD."id"
							) AS "data"
							FROM organization."accessControlPoints" AS acp
							INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = OLD."regionId"
								AND  acp."deletedAt" IS NULL
						) AS T
						WHERE T."row_num" = 1;
					END IF;
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', to_jsonb(row_to_json(OLD)),
						'new', null
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_access', res);                
					RETURN OLD;
				ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
					-- access notification for single user
					IF (NEW."targetUserId" IS NOT NULL) THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', NEW."id",
								't', NEW."targetUserId",
								'r', NEW."regionId",
								's', NEW.options->'success',
								'd', NEW.options->'direction'
							) AS "data"
							FROM organization."userOrganizations" AS uo
							INNER JOIN organization."users" AS u ON uo."userId" = u."id"
							INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
							INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
							INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
							WHERE uo."userId" = NEW."targetUserId"
								AND uo."deletedAt" IS NULL
								AND u."deletedAt" IS NULL
								AND uar."deletedAt" IS NULL
								AND acp."deletedAt" IS NULL
								AND racp."regionId" = NEW."regionId"
						) AS T
						WHERE T."row_num" = 1;
					-- access notification all users
					ELSE
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', NEW."id",
								't', NEW."targetUserId",
								'r', NEW."regionId",
								's', NEW.options->'success',
								'd', NEW.options->'direction'
							) AS "data"
							FROM organization."accessControlPoints" AS acp
							INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = NEW."regionId"
								AND  acp."deletedAt" IS NULL
						) AS T
						WHERE T."row_num" = 1;
					END IF;
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
						'new', to_jsonb(row_to_json(NEW))
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_access', res);
					RETURN NEW;
				END IF;
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_notification_access() OWNER TO armonsuper;

--
-- Name: before_up_in_del_notification_sensor(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_notification_sensor() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id	uuid;
			access_control_point_id uuid;
				res	text;
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					access_control_point_id:= OLD."accessControlPointId";
				ELSE
					access_control_point_id:= NEW."accessControlPointId";
				END IF;
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
				FROM organization."accessControlPoints" AS acp
				WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;
				
				IF (TG_OP = 'DELETE') THEN
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', to_jsonb(row_to_json(OLD)),
						'new', null
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_sensor', res);
					RETURN OLD;
				ELSE
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
						'new', to_jsonb(row_to_json(NEW))
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_sensor',res);            
					RETURN NEW;
				END IF;    
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_notification_sensor() OWNER TO armonsuper;

--
-- Name: before_up_in_del_o_auth_tokens(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_o_auth_tokens() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
		transaction_id	uuid;
		credential_exists	boolean;
		BEGIN
			transaction_id := uuid_generate_v4();
			IF (TG_OP = 'DELETE') THEN
				IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
					DELETE FROM organization."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					-- 2 for BLE, 8 for NFC, 12 for QR
				END IF;
				RETURN OLD;
			ELSIF (TG_OP = 'UPDATE') THEN
				SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
					organization."userOrganizationCredentials" AS uoc
					WHERE uoc."deletedAt" IS NULL AND
							uoc."userId" = NEW."userId" AND
							(uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
				INTO credential_exists;
				IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
				-- delete credentials
					DELETE FROM organization."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					RETURN NEW;
				ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
					   (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR
					   credential_exists = false AND NEW."oAuthClientId" IS NOT NULL AND NEW."deletedAt" IS NULL) THEN
				-- delete old credentials
				-- insert new credentials
					DELETE FROM organization."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
	
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
	
					RETURN NEW;
				ELSE
	
				END IF;
			ELSIF (TG_OP = 'INSERT') THEN
				-- check existing credentials
				SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
					organization."userOrganizationCredentials" AS uoc
					WHERE uoc."deletedAt" IS NULL AND
							uoc."userId" = NEW."userId" AND
							(uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
				INTO credential_exists;
				-- if no credentials present, then create 2 credentials for BLE and NFC
				IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
				
				
					INSERT INTO organization."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
	
				END IF;
			END IF;
			RETURN NEW;
		END;
	$$;


ALTER FUNCTION organization.before_up_in_del_o_auth_tokens() OWNER TO armonsuper;

--
-- Name: before_up_in_del_region_access_control_points(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_region_access_control_points() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
			SELECT "deviceId" 
			FROM organization."accessControlPoints"
			WHERE "deletedAt" IS NULL AND "id" = OLD."accessControlPointId"
			INTO device_id;
		ELSIF (TG_OP = 'UPDATE') THEN
			RAISE EXCEPTION 'Illegal operation to update region/accessControlPoint mapping';
        ELSE
			SELECT "deviceId" 
			FROM organization."accessControlPoints"
			WHERE "deletedAt" IS NULL AND "id" = NEW."accessControlPointId"
			INTO device_id;
		END IF;
		
		IF (device_id IS NOT NULL) THEN
			INSERT INTO organization."terminalChanges"
			("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
			VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
		END IF;
		
		IF (TG_OP = 'DELETE') THEN
			RETURN OLD;
        ELSE
			RETURN NEW;
		END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_region_access_control_points() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_access_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_access_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        transaction_id				uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            IF (OLD."targetUserId" IS NOT NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id"
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE uo."userId" = OLD."targetUserId"
                        AND uo."organizationId" = OLD."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND u."deletedAt" IS NULL
                        AND uar."deletedAt" IS NULL
                        AND acp."deletedAt" IS NULL
                        AND racp."regionId" = OLD."regionId"
                ) AS T
                WHERE T."row_num" = 1;
            ELSE
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                    WHERE acp."organizationId" = OLD."organizationId"
                        AND racp."regionId" = OLD."regionId"
                        AND  acp."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
            -- access notification for single user
            IF (NEW."targetUserId" IS NOT NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        't', NEW."targetUserId",
                        'r', NEW."regionId",
                        's', NEW."success",
                        'd', NEW."direction"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id"
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE uo."userId" = NEW."targetUserId"
                        AND uo."organizationId" = NEW."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND u."deletedAt" IS NULL
                        AND uar."deletedAt" IS NULL
                        AND acp."deletedAt" IS NULL
                        AND racp."regionId" = NEW."regionId"
                ) AS T
                WHERE T."row_num" = 1;
            -- access notification all users
            ELSE
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        't', NEW."targetUserId",
                        'r', NEW."regionId",
                        's', NEW."success",
                        'd', NEW."direction"
                    ) AS "data"
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                    WHERE acp."organizationId" = NEW."organizationId"
                        AND racp."regionId" = NEW."regionId"
                        AND  acp."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_access_notification() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_access_rights(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_access_rights() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            DECLARE
            transaction_id		uuid;
            device_id			uuid;
            organization_id		uuid;
            factors_of_acp		jsonb;
            factors_of_other_acps		jsonb;
            factors_to_send_to_device		jsonb;
            i 						jsonb;
            j 						jsonb;
            l 						jsonb;
            t1 						jsonb;
        
            BEGIN
                transaction_id := uuid_generate_v4();
                factors_of_acp := '[]'::jsonb;
                factors_of_other_acps := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                IF (TG_OP = 'DELETE') THEN
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=OLD."accessControlPointId";
                    INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM organization."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                        RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                    END IF;
        
                    IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                        (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                    THEN
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    END IF;
                    IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                        (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM organization."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM organization."accessControlPoints" AS acp
                            INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM organization."userOrganizationCredentials" AS uoc
                            INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM organization."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM organization."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM organization."userAccessRights" AS uar
                                            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM organization."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM organization."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM organization."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM organization."accessRuleHistory" AS arh
                            INNER JOIN organization."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN organization."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            organization."users" AS u
                            INNER JOIN organization."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                        END IF;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    IF EXISTS(SELECT 1 FROM organization."userAccessRights"
                        WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                        AND "deletedAt" IS NULL) THEN
                        RAISE EXCEPTION 'User access right  already exists';
                    END IF;
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM organization."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM organization."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM organization."accessControlPoints" AS acp
                            INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM organization."userOrganizationCredentials" AS uoc
                            INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM organization."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM organization."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM organization."userAccessRights" AS uar
                                            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM organization."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM organization."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM organization."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM organization."accessRuleHistory" AS arh
                            INNER JOIN organization."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN organization."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            organization."users" AS u
                            INNER JOIN organization."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                            ) AS T;
                        END IF;
                    END IF;
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_del_user_access_rights() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_forbiddances(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_forbiddances() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
				DECLARE
				transaction_id		uuid;
				user_id				uuid;
				BEGIN
					transaction_id := uuid_generate_v4();
					IF (TG_OP = 'DELETE') THEN
						user_id:= OLD."userId";
							INSERT INTO organization."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
									JSON_BUILD_OBJECT(
									'id', OLD."id"
								) AS "data"
									FROM organization."userOrganizations" AS uo
								INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						RETURN OLD;
					ELSIF (TG_OP = 'INSERT') THEN
						user_id:= NEW."userId";
							INSERT INTO organization."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
									JSON_BUILD_OBJECT(
									'id', NEW."id",
									'userId', user_id,
									'regionId', NEW."regionId",
									'credentialIds', NEW."credentialIds",
									'startDateISO', NEW."startUtc",
									'endDateISO', NEW."endUtc"
								) AS "data"
								FROM organization."userOrganizations" AS uo
								INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						RETURN NEW;
					ELSIF (TG_OP = 'UPDATE') THEN
						user_id:= NEW."userId";
						IF (NEW."startUtc" != OLD."startUtc" OR 
							NEW."endUtc" != OLD."endUtc" OR
							NEW."regionId" != OLD."regionId" OR 
							(NEW."credentialIds" IS NULL AND OLD."credentialIds" IS NOT NULL) OR
							(OLD."credentialIds" IS NULL AND NEW."credentialIds" IS NOT NULL) OR
							(SELECT array_agg(d) !=  (
								SELECT array_agg(d) AS list
								FROM json_array_elements_text(NEW."credentialIds") AS d
							) 
							FROM json_array_elements_text(OLD."credentialIds") AS d)
						)
						THEN
							--first remove old forbiddance
							INSERT INTO organization."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
								JSON_BUILD_OBJECT(
									'id', OLD."id"
								) AS "data"
								FROM organization."userOrganizations" AS uo
								INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
							) AS T
							WHERE T."row_num" = 1;
							--then add new forbiddance
							INSERT INTO organization."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() + interval '500 milliseconds' , 17, T."data"
							FROM
							(
								SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
								JSON_BUILD_OBJECT(
									'id', NEW."id",
									'userId', user_id,
									'regionId', NEW."regionId",
									'credentialIds', NEW."credentialIds",
									'startDateISO', NEW."startUtc",
									'endDateISO', NEW."endUtc"
								) AS "data"
								FROM organization."userOrganizations" AS uo
								INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
								INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
								INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
								INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
								-- if region id is null, apply for all regions
								AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
								WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
							) AS T
							WHERE T."row_num" = 1;
						END IF;
						RETURN NEW;
					END IF;
				END;
			$$;


ALTER FUNCTION organization.before_up_in_del_user_forbiddances() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_group_mapping(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_group_mapping() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_organization_id	uuid;
    group_id				uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_organization_id:= OLD."userOrganizationId";
            group_id:= OLD."userGroupId";
            IF (OLD."deletedAt" IS NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', ('["' || u."id" || '"]')::json,
                        'addedUserIds', '[]'::json
                    ) AS "data"
                        FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_organization_id:= NEW."userOrganizationId";
            group_id:= NEW."userGroupId";

            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'userGroupId', group_id,
                    'removedUserIds', '[]'::json,
                    'addedUserIds',  ('["' || u."id" || '"]')::json
                ) AS "data"
                FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
            THEN
                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', ('["' || u."id" || '"]')::json,
                        'addedUserIds', '[]'::json
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_group_mapping() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_organization_credentials(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_organization_credentials() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id	uuid;
			t_factors		text;
			factors 		text[];
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					INSERT INTO organization."terminalChanges"
					("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
					SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
					WHERE T."row_num" = 1;
					RETURN OLD;
				ELSIF (TG_OP = 'UPDATE') THEN
					IF NEW."userId" != OLD."userId"
					OR NEW."organizationId" != OLD."organizationId"
					OR NEW."type" != OLD."type"
					OR NEW."data" != OLD."data"
					OR NEW."specialData" != OLD."specialData"
					OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
					THEN
						RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
					END IF;
		
					IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
					THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
		
					IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
						OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
						NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
								AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
					THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
							JSON_BUILD_OBJECT(	'id', OLD."id", 
													'expiresOnISO', NEW."expiresOn",
													'groupNumber', NEW."groupNumber",
													'extensionFields', NEW."extensionFields")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
				ELSIF (TG_OP = 'INSERT') THEN
					IF (NEW."deletedAt" IS NULL)
					THEN
						IF EXISTS(SELECT FROM organization."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL
							AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
							RAISE EXCEPTION 'Credential is already exists';
						END IF;
						
						IF EXISTS(SELECT FROM organization."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
							UPDATE organization."userOrganizationCredentials" SET "deletedAt" = now()
							WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
								AND "type" = NEW."type" AND "deletedAt" IS NULL;
						END IF;
		
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
						json_build_object(
							'id', T."id",
							'userId', T."userId",
							'type', T."type",
							'data', T."data",
							'groupNumber', T."groupNumber",
							'specialData', T."specialData",
							'specialDataSecondary', T."specialDataSecondary",
							'expiresOnISO', T."expiresOn",
							'extensionFields', T."extensionFields"
						) AS "data" FROM
						(SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
						NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
						FROM
							(SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM organization."userAccessRights" AS uar
								INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
								AND NEW."organizationId" = acp."organizationId"
								WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
								) AS T2
							WHERE T2.row_num=1
							) AS T;
					END IF;
				END IF;
				RETURN NEW;
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_user_organization_credentials() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_organization_sensor_notifications(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    access_control_point_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            access_control_point_id:= OLD."accessControlPointId";
        ELSE
            access_control_point_id:= NEW."accessControlPointId";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."accessControlPoints" AS acp
		WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() OWNER TO armonsuper;

--
-- Name: before_up_in_del_user_region_ticket_unit(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_region_ticket_unit() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id		uuid;
    user_id				uuid;
    region_ticket_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."userId";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', 0
                ) AS "data"
				FROM organization."regionTickets" AS rt
				INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = OLD."organizationId" AND
					uar."userId" = OLD."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_id:= NEW."userId";

            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', NEW."remainingUnits"
                ) AS "data"
				FROM organization."regionTickets" AS rt
				INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = NEW."organizationId" AND
					uar."userId" = NEW."userId"
				--FROM organization."userOrganizations" AS uo
                --INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                --INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                --INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --INNER JOIN organization."regionTickets" AS rt ON rt."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --WHERE uo."organizationId" = NEW."organizationId" AND u."id" = NEW."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            user_id:= NEW."userId";

            IF (NEW."remainingUnits" != OLD."remainingUnits" AND NEW."totalSpentUnits" = OLD."totalSpentUnits")
            THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', NEW."lastUpdateAmount"
                    ) AS "data"
					FROM organization."regionTickets" AS rt
					INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId"
                ) AS T
            	WHERE T."row_num" = 1;
            ELSIF (NEW."totalSpentUnits" != OLD."totalSpentUnits"
                    AND NEW."lastUpdateAccessControlPointId" IS NOT NULL)
            THEN
                SELECT rt."id" INTO region_ticket_id
                FROM organization."regionTickets" AS rt
                INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = NEW."lastUpdateAccessControlPointId"
                INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id" AND racp."regionId" = rt."regionId"
                WHERE rt."deletedAt" IS NULL AND acp."deletedAt" IS NULL;

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 13, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userId', user_id,
                        'ticketId', region_ticket_id,
                        'amount', (OLD."remainingUnits" - NEW."remainingUnits")
                    ) AS "data"
                    FROM organization."regionTickets" AS rt
					INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId" AND
						acp."id" != NEW."lastUpdateAccessControlPointId"
                ) AS T
				WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_region_ticket_unit() OWNER TO armonsuper;

--
-- Name: before_up_in_delete_access_rule_sets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_access_rule_sets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT T."deviceId"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE racp."regionId" = OLD."regionId"
                        AND acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSIF (TG_OP = 'UPDATE') THEN
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM organization."accessControlPoints" AS acp
                        INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId" OR racp."regionId" = OLD."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM organization."accessControlPoints" AS acp
                        INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_access_rule_sets() OWNER TO armonsuper;

--
-- Name: before_up_in_delete_access_rules(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_access_rules() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_access_rules() OWNER TO armonsuper;

--
-- Name: before_up_in_delete_region_tickets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_region_tickets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND racp."regionId" = OLD."regionId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = NEW."organizationId"
                        AND racp."regionId" = NEW."regionId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_region_tickets() OWNER TO armonsuper;

--
-- Name: before_up_in_delete_user_group_access_rule_sets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() OWNER TO armonsuper;

--
-- Name: before_up_in_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            BEGIN
                IF(NEW.type IN (32, 31, 19, 3, 2, 1) AND NEW."receiverFilterId" IS NULL) THEN
                    RAISE EXCEPTION 'You Should Set receiverFilter For This Notification Type';
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_notification() OWNER TO armonsuper;

--
-- Name: before_up_in_user_rule_history(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_user_rule_history() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
  data_object		 	json;
  related_device_ids 	uuid[];
  res					text;
    BEGIN
    SELECT ARRAY_AGG(T."deviceId") FROM (
      SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
      FROM organization."accessControlPoints" AS acp
      INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
      INNER JOIN organization."accessRuleSets" AS ars ON ars."regionId" = racp."regionId"
      INNER JOIN organization."accessRules" AS ar ON ar."accessRuleSetId" = ars."id"
      WHERE ar."id" = NEW."accessRuleId" AND
        ar."deletedAt" IS NULL AND
        ars."deletedAt" IS NULL AND
        acp."deletedAt" IS NULL AND
        acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."lastUpdateAccessControlPointId")
    ) AS T INTO related_device_ids
    WHERE T.row_num = 1;
    data_object := JSON_BUILD_OBJECT(
      'ruleId', NEW."accessRuleId",
      'userId', NEW."userId",
      'count', NEW."count",
      'actionDateISO', NEW."lastActionDateISO");
    res :=JSON_BUILD_OBJECT(
        'data', data_object,
        'relatedDeviceIds', related_device_ids,
        'organizationId', TG_TABLE_SCHEMA)::text;
    PERFORM PG_NOTIFY('access_rule_applied', res);

        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_in_user_rule_history() OWNER TO armonsuper;

--
-- Name: before_update_devices(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_update_devices() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (NEW."name" != OLD."name" OR NEW."location" != OLD."location")
        THEN
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, NEW."id", now(), 3, '{}'::json);
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_update_devices() OWNER TO armonsuper;

--
-- Name: fauthorizeuserfor(uuid, uuid, uuid[], uuid[], uuid[], uuid[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) RETURNS json
    LANGUAGE plpgsql
    AS $$
DECLARE 
	authorized_organization_unit_ids uuid[];
    authorized_access_control_point_ids uuid[];
    authorized_user_ids uuid[];
    authorized_user_group_ids uuid[];
    tmp_uuid uuid;
    is_admin bool;
    user_organization_id uuid;
BEGIN

SELECT "id" into user_organization_id FROM organization."userOrganizations" 
    WHERE "organizationId" = organization_id AND "userId" = user_id AND "deletedAt" IS NULL AND "isDisabled" = false;
    
SELECT CASE WHEN count(*) > 0 THEN true ELSE false END into is_admin 
FROM organization."userOrganizations"  as uo
INNER JOIN organization."roles" as r
ON r.id = uo."roleId"
WHERE uo."organizationId" = organization_id AND uo."userId" = user_id AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
and r."typeId" = '52a088f3-4b54-4c60-b204-b8ec3dfe794a';
    
IF is_admin THEN
	RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
END IF;

IF array_length(organization_unit_ids, 1) > 0 OR array_length(user_ids, 1) > 0 OR array_length(user_group_ids, 1) > 0 THEN
    SELECT array_agg(uoou."organizationUnitId") INTO authorized_organization_unit_ids 
    FROM organization."userOrganizationOrganizationUnits" AS uoou    
    WHERE uoou."userOrganizationId" = user_organization_id AND uoou."deletedAt" IS NULL;

    SELECT array_agg(ou.id) INTO authorized_organization_unit_ids FROM organization."organizationUnits" AS ou WHERE 
    ou."deletedAt" IS NULL AND
    (ou.id = ANY(authorized_organization_unit_ids) OR
    ou."ancestorIds" ~ ANY(authorized_organization_unit_ids::text[]));

    RAISE NOTICE 'Authorized unit_ids: %', authorized_organization_unit_ids;
    IF array_length(organization_unit_ids, 1) > 0 AND (authorized_organization_unit_ids IS NULL OR arraycontained(organization_unit_ids, authorized_organization_unit_ids) = FALSE) THEN    	
        RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'organization_unit_ids');        
    END IF;    
    
    IF array_length(user_ids, 1) > 0 THEN
    	SELECT array_agg(uo."userId") INTO authorized_user_ids FROM organization."userOrganizationOrganizationUnits" AS uoou
        INNER JOIN organization."userOrganizations" AS uo ON uo."id" = uoou."userOrganizationId" AND uo."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
        WHERE uoou."organizationUnitId" = ANY(authorized_organization_unit_ids) AND uo."userId" = ANY(user_ids);
        RAISE NOTICE 'Authorized user_ids: %', authorized_user_ids;
        IF authorized_user_ids IS NULL OR arraycontained(user_ids, authorized_user_ids) = FALSE THEN
        	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_ids');                	
        END IF;
    END IF;

    IF array_length(user_group_ids, 1) > 0 THEN	
    	SELECT array_agg(ug.id) INTO authorized_user_group_ids FROM organization."userGroups" AS ug
        WHERE ug."organizationId" = organization_id AND ug."deletedAt" IS NULL AND (ug."organizationUnitId" IS NULL OR ug."organizationUnitId" = ANY(authorized_organization_unit_ids));
    	IF authorized_user_group_ids IS NULL OR arraycontained(user_group_ids, authorized_user_group_ids) = FALSE THEN    	    
        	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_group_ids');                	            
        END IF;
    END IF;
END IF;

IF array_length(access_control_point_ids, 1) > 0 THEN
	SELECT array_agg(uar."accessControlPointId") INTO authorized_access_control_point_ids FROM organization."userAccessRights" AS uar WHERE uar."userId" = user_id;
    IF authorized_access_control_point_ids IS NULL OR arraycontained(access_control_point_ids, authorized_access_control_point_ids) = FALSE THEN
    	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'access_control_point_ids');                	                    
    END IF;   
END IF;

RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
END;

$$;


ALTER FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) OWNER TO armonsuper;

--
-- Name: fcollectusersforaccessreportfilter(uuid, uuid[], boolean, uuid[], uuid[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) RETURNS json
    LANGUAGE plpgsql
    AS $$
DECLARE 
    _users JSON;
    _organization_unit_ids uuid[];    
    _user_organization_ids_for_organization_units uuid[];    
    _user_organization_ids_for_user_groups uuid[];
    _user_organization_ids_for_users uuid[];
BEGIN

IF array_length(organization_unit_ids, 1) > 0 THEN
	IF filter_organization_unit_members_hierarchically = TRUE THEN
    	SELECT array_agg(oh."id") INTO _organization_unit_ids FROM 
        (SELECT 
        ou."id", CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END as "ancestorIds" 
        FROM organization."organizationUnits" as ou WHERE ou."deletedAt" IS NULL AND ou."organizationId" = organization_id) as oh
        WHERE oh."id" = ANY(organization_unit_ids)
        OR oh."ancestorIds" && organization_unit_ids;
    ELSE
    	SELECT array_agg(ou."id") INTO _organization_unit_ids 
        FROM organization."organizationUnits" as ou WHERE ou."deletedAt" IS NULL AND ou."organizationId" = organization_id
        AND ou."id"=ANY(organization_unit_ids);
    END IF;
    
    SELECT array_agg(uoou."userOrganizationId") INTO _user_organization_ids_for_organization_units 
    FROM organization."userOrganizationOrganizationUnits" uoou WHERE uoou."deletedAt" IS NULL AND "organizationUnitId" = ANY(_organization_unit_ids);
END IF;

IF array_length(user_group_ids, 1) > 0 THEN
	SELECT array_agg(uguo."userOrganizationId") INTO _user_organization_ids_for_user_groups FROM organization."userGroupUserOrganizations" AS uguo
    WHERE uguo."deletedAt" IS NULL AND "userGroupId" = ANY(user_group_ids);
END IF;

IF array_length(user_ids, 1) > 0 THEN
	SELECT array_agg(uo."id") INTO _user_organization_ids_for_users FROM organization."userOrganizations" AS uo WHERE uo."organizationId" = organization_id AND uo."deletedAt" IS NULL AND uo."userId" = ANY(user_ids);
END IF;

SELECT json_agg(json_build_object('userId', uop."userId", 'userOrganizationId', uop."userOrganizationId")) INTO _users FROM organization."userOrganizationProfiles" AS uop WHERE 
uop."deletedAt" IS NULL AND
CASE WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_user_groups, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    (uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
 	AND
	uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups))
    OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_user_groups, 1) > 0 THEN
(
    uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
 	AND
	uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups)
) WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units) 	
	OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) WHEN array_length(_user_organization_ids_for_user_groups, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups) 	
	OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) 
WHEN array_length(_user_organization_ids_for_users, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
WHEN array_length(_user_organization_ids_for_user_groups, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups)
ELSE FALSE END;
       
IF _users IS NULL THEN 
	SELECT '[]'::JSON INTO _users;
END IF;
RETURN _users;
END;

$$;


ALTER FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) OWNER TO armonsuper;

--
-- Name: fgetorganizationunitdetailed(uuid, uuid, boolean, uuid); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) RETURNS json
    LANGUAGE plpgsql
    AS $$
        DECLARE 
            _ri RECORD;
            _ji JSON;
            _result JSON;
            _parent JSON;
            _defaultAccessControlPoints JSON[];
        BEGIN	
            _result = null;
            _defaultAccessControlPoints = ARRAY[]::JSON[];
            
            SELECT json_build_object(
            'id', ou."id",
            'name', ou."name",
            'typeId', ou."typeId",
            'typeDefinition', oud.value,
            'ancestorIds', CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END,
            'shortCode', ou."shortCode",
			'dynamicFormData', ou.settings->'dynamicFormData',
            'parent', CASE WHEN ou."parentId" IS NULL THEN NULL ELSE ( 
                SELECT json_build_object('id', pou."id", 'name', pou."name",
                'typeId', pou."typeId", 
                'typeDefinition', poud.value,
                'ancestorIds', CASE WHEN pou."ancestorIds" = '[]' OR pou."ancestorIds" = '' OR pou."ancestorIds" IS NULL THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(pou."ancestorIds", E',')::uuid[] END,
                        'shortCode', pou."shortCode",
                        'parentId', pou."parentId",
						'dynamicFormData', ou.settings->'dynamicFormData'
                ) FROM organization."organizationUnits" AS pou
                INNER JOIN organization."organizationUserDefinedListValues" AS poud ON pou."typeId" = poud.id
                WHERE pou."id" = ou."parentId" AND pou."deletedAt" IS NULL) END,
                'defaultAccessControlPoints', ARRAY[]::JSON[]	
            )
            INTO _result 
            FROM organization."organizationUnits" AS ou 
            INNER JOIN organization."organizationUserDefinedListValues" AS oud ON ou."typeId" = oud.id
            WHERE ou."organizationId" = organization_id AND ou."id" = organization_unit_id AND ou."deletedAt" IS NULL;
            
            FOR _ri IN
            SELECT 
                acp."id", acp."name", acp."location", acp."remoteAvailable", acp."isRemoteDefault", acp."accessControlPointType" AS "type",
                (CASE WHEN uar."id" IS NULL AND is_system_administrator = FALSE THEN FALSE ELSE TRUE END) AS "managable", oudacp."defaultPrivileges"
            FROM organization."organizationUnitDefaultAccessControlPoints" AS oudacp
            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = oudacp."accessControlPointId"
            LEFT OUTER JOIN organization."userAccessRights" AS uar ON uar."userId" = user_id AND uar."accessControlPointId" = acp."id" AND uar."deletedAt" IS NULL
            WHERE oudacp."deletedAt" IS NULL AND oudacp."organizationUnitId" = organization_unit_id AND acp."deletedAt" IS NULL
            ORDER BY acp."name"
            LOOP
                _defaultAccessControlPoints = _defaultAccessControlPoints || to_json(_ri);
            END LOOP;
            
            IF _result IS NULL
            THEN
                RAISE EXCEPTION '%', json_build_object('code', 404, 'message', 'The organization unit is not found!');
            END IF;
            
            SELECT json_append(_result, json_build_object('defaultAccessControlPoints', _defaultAccessControlPoints)) INTO _result;
                
            RETURN _result;
            END;
    $$;


ALTER FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) OWNER TO armonsuper;

--
-- Name: gen_profile_text(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.gen_profile_text() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            profile_text TEXT;
            field record;
        BEGIN
            profile_text := NEW."name";        
            IF NEW."surname" IS NOT NULL AND NEW."surname" <> '' THEN
                profile_text := profile_text || NEW."surname";  
            END IF;
            
            IF NEW."uniqueId" IS NOT NULL AND NEW."uniqueId" <> '' THEN
                profile_text := profile_text || NEW."uniqueId";        
            END IF;
            
            IF NEW."address" IS NOT NULL AND NEW."address" <> '' THEN
                profile_text := profile_text || NEW."address";        
            END IF;
            
            IF NEW."phoneNumber" IS NOT NULL AND NEW."phoneNumber" <> '' THEN
                profile_text := profile_text || NEW."phoneNumber";        
            END IF;
            
            IF NEW."email" IS NOT NULL AND NEW."email" <> '' THEN
                profile_text := profile_text || NEW."email";        
            END IF;
                    
            FOR field IN SELECT d.value FROM json_each_text(NEW."extensionFields") d WHERE d.value IS NOT NULL and d.value <> ''
            LOOP
                profile_text := profile_text || field.value;    
            END LOOP;
            
            NEW."profileText" := profile_text;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.gen_profile_text() OWNER TO armonsuper;

--
-- Name: json_append(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_append(data json, insert_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        UNION ALL
        SELECT * FROM json_each(insert_data)
    ) t;
$$;


ALTER FUNCTION organization.json_append(data json, insert_data json) OWNER TO armonsuper;

--
-- Name: json_delete(json, text[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_delete(data json, keys text[]) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        WHERE key <>ALL(keys)
    ) t;
$$;


ALTER FUNCTION organization.json_delete(data json, keys text[]) OWNER TO armonsuper;

--
-- Name: json_merge(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_merge(data json, merge_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH to_merge AS (
            SELECT * FROM json_each(merge_data)
        )
        SELECT *
        FROM json_each(data)
        WHERE key NOT IN (SELECT key FROM to_merge)
        UNION ALL
        SELECT * FROM to_merge
    ) t;
$$;


ALTER FUNCTION organization.json_merge(data json, merge_data json) OWNER TO armonsuper;

--
-- Name: json_update(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_update(data json, update_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH old_data AS (
            SELECT * FROM json_each(data)
        ), to_update AS (
            SELECT * FROM json_each(update_data)
            WHERE key IN (SELECT key FROM old_data)
        )
    SELECT * FROM old_data
    WHERE key NOT IN (SELECT key FROM to_update)
    UNION ALL
    SELECT * FROM to_update
) t;
$$;


ALTER FUNCTION organization.json_update(data json, update_data json) OWNER TO armonsuper;

--
-- Name: notify_pacs_live_recalculation(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.notify_pacs_live_recalculation() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            DECLARE
            recalculate_required_count		integer;
            BEGIN
                SELECT COUNT(*) INTO recalculate_required_count
                FROM newtab
                LEFT OUTER JOIN oldtab ON newtab.id = oldtab.id 
                WHERE (oldtab."updateRequiredReason" = 1 AND newtab."updateRequiredReason" <> 1) OR oldtab.id IS NULL;

                IF(recalculate_required_count > 0)
                THEN
                    PERFORM PG_NOTIFY('pacs_live_recalculation', 'organization');
                END IF;
                RETURN NULL;
            END;
        $$;


ALTER FUNCTION organization.notify_pacs_live_recalculation() OWNER TO armonsuper;

--
-- Name: process_recalculate_work_queue_start_date_time(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.process_recalculate_work_queue_start_date_time() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		BEGIN
			DELETE FROM organization."recalculateWorkQueue" 
			WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" >= NEW."startDate";
			
			IF EXISTS(SELECT  FROM organization."recalculateWorkQueue" 
				WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" < NEW."startDate")
			THEN
				RETURN NULL; 
			ELSE
				NEW."startDate" = (NEW."startDate" - INTERVAL '1 day')::date;
				RETURN NEW;
			END IF;
		END;
		$$;


ALTER FUNCTION organization.process_recalculate_work_queue_start_date_time() OWNER TO armonsuper;

--
-- Name: update_terminaladmins(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.update_terminaladmins() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
        old_permissions		character varying(512);
        new_permissions		character varying(512);
        BEGIN
            IF (TG_OP = 'DELETE') THEN
                DELETE FROM organization."terminalAdministrators" ta
                USING organization."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."roleId" <> OLD."roleId")
                THEN
                    SELECT r.permissions INTO old_permissions FROM organization.roles r WHERE r.id = OLD."roleId";
                    SELECT r.permissions INTO new_permissions FROM organization.roles r WHERE r.id = NEW."roleId";
                    
                    IF(POSITION('s:r' IN old_permissions) > 0 AND POSITION('s:r' IN new_permissions) = 0)
                    THEN
                        DELETE FROM organization."terminalAdministrators" ta
                        USING organization."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                    END IF;
                    
                    IF(POSITION('s:w' IN old_permissions) > 0 AND POSITION('s:w' IN new_permissions) = 0)
                    THEN
                        UPDATE organization."terminalAdministrators" ta SET write = false
                        FROM organization."devices" d WHERE d.id = ta."terminalId" AND d."organizationId" = NEW."organizationId" AND ta."userId" = NEW."userId";
                    END IF;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.update_terminaladmins() OWNER TO armonsuper;

--
-- Name: zz_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    _now timestamp without time zone;
    BEGIN
    _now:= now();
    IF(TG_OP = 'INSERT') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            NEW.id,
            1,
            _now,
            txid_current(),
            NEW."createdT",
            NEW.type,
            NEW."createdByUserId",
            NEW."receiverFilterId",
            NEW."settings",
            NEW.email,
            NEW.sms,
            NEW.web,
            NEW."pushNotification"
        );
    ELSIF(TG_OP = 'UPDATE') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            NEW.id,
            2,
            _now,
            txid_current(),
            NEW."createdT",
            NEW.type,
            NEW."createdByUserId",
            NEW."receiverFilterId",
            NEW."settings",
            NEW.email,
            NEW.sms,
            NEW.web,
            NEW."pushNotification"
        );
    ELSIF(TG_OP = 'DELETE') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            OLD.id,
            3,
            _now,
            txid_current(),
            OLD."createdT",
            OLD.type,
            OLD."createdByUserId",
            OLD."receiverFilterId",
            OLD."settings",
            OLD.email,
            OLD.sms,
            OLD.web,
            OLD."pushNotification"
        );
    END IF;
    RETURN NULL;
    END;
    $$;


ALTER FUNCTION organization.zz_notification() OWNER TO armonsuper;

--
-- Name: zz_notification_access(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification_access() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options 
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);
			ELSIF (TG_OP = 'UPDATE') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."targetUserId",
					OLD."regionId",
					OLD.options
				);       
			END IF;    
			RETURN NULL;
		END;
		$$;


ALTER FUNCTION organization.zz_notification_access() OWNER TO armonsuper;

--
-- Name: zz_notification_sensor(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification_sensor() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _now timestamp without time zone;
    BEGIN   
        _now := now();
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                1,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );
        ELSIF (TG_OP = 'UPDATE') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                2,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );    
        ELSIF (TG_OP = 'DELETE') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                OLD.id,
                3,
                _now,
                txid_current(),
                OLD."accessControlPointId",
                OLD."sensorType",
                OLD."deviceDryContactInputId",
                OLD.options
            );       
        END IF;    
        RETURN NULL;
    END;
    $$;


ALTER FUNCTION organization.zz_notification_sensor() OWNER TO armonsuper;

--
-- Name: zz_pacs_notification_scheduled_job(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_pacs_notification_scheduled_job() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);
			ELSIF (TG_OP = 'UPDATE') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."subjectedEmployeesFilterId"
				);       
			END IF;    
			RETURN NULL;
		END;
		$$;


ALTER FUNCTION organization.zz_pacs_notification_scheduled_job() OWNER TO armonsuper;

--
-- Name: zz_user_organization_forbiddances(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_user_organization_forbiddances() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
			DECLARE
				_now timestamp without time zone;
			BEGIN   
				_now := now();
				IF (TG_OP = 'INSERT') THEN
					INSERT INTO organization.zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						1,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);
				ELSIF (TG_OP = 'UPDATE') THEN
					INSERT INTO organization.zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note ,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						2,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);    
				ELSIF (TG_OP = 'DELETE') THEN
					INSERT INTO organization.zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						OLD.id,
						3,
						_now,
						txid_current(),
						OLD."userId",
						OLD."createdAt",
						OLD."updatedAt",
						OLD."deletedAt",
						OLD."startUtc",
						OLD."endUtc",
						OLD."regionId",
						OLD.note,
						OLD."credentialIds"
					);       
				END IF;    
				RETURN NULL;
				END;
				$$;


ALTER FUNCTION organization.zz_user_organization_forbiddances() OWNER TO armonsuper;

--
-- Name: after_insert_default(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.after_insert_default() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    res text;
    t_name text;
        BEGIN
        t_name := REPLACE (TG_TABLE_NAME, '_default', '');
        res := jsonb_build_object(
            'tName', t_name,
            'sName', TG_TABLE_SCHEMA,
            'key', (SELECT col.column_name FROM
                (SELECT partrelid, partnatts, case partstrat when 'l' then 'list'
                                        when 'r' then 'range' end as partition_strategy,
                    UNNEST (partattrs) column_index FROM pg_partitioned_table) pt 
                JOIN pg_class par ON par.oid = pt.partrelid
                JOIN information_schema.columns col ON quote_ident(col.table_schema) = par.relnamespace::regnamespace::text
                AND col.table_name = par.relname
                AND ordinal_position = pt.column_index
                WHERE par.relnamespace::regnamespace::text = quote_ident(TG_TABLE_SCHEMA) 
                AND par.relname = t_name
                )
        )::text;
        PERFORM PG_NOTIFY('partition', res);
        RAISE NOTICE  'partition for: %', res;
        RETURN null;
        END;
    $$;


ALTER FUNCTION public.after_insert_default() OWNER TO armonsuper;

--
-- Name: after_up_in_scheduled_job(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.after_up_in_scheduled_job() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
				scheduled_job_id 	text;
			BEGIN
				scheduled_job_id:= NEW.id::text;
				IF(TG_OP = 'INSERT' OR 
					(TG_OP = 'UPDATE' AND
						NEW.enabled IS TRUE AND  
						(NEW."nextExecutionDate" <> OLD."nextExecutionDate" 
						OR NEW."firstExecutionDate" <> OLD."firstExecutionDate" 
						OR NEW."interval" <> OLD."interval"
						OR OLD.enabled IS FALSE)
					)) THEN
					PERFORM PG_NOTIFY('scheduled_job_upsert', scheduled_job_id);            
				END IF;
				RETURN NEW;
			END;
	$$;


ALTER FUNCTION public.after_up_in_scheduled_job() OWNER TO armonsuper;

--
-- Name: clone_schema(text, text, boolean); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) RETURNS void
    LANGUAGE plpgsql
    AS $$
	--  This function will clone all sequences, tables, data, views & functions from any existing schema to a new one
	-- SAMPLE CALL:
	-- SELECT clone_schema('public', 'new_schema', TRUE);
	
	DECLARE
	src_oid          oid;
	tbl_oid          oid;
	func_oid         oid;
	object           text;
	v_rec            record;
	buffer           text;
	srctbl           text;
	default_         text;
	column_          text;
	qry              text;
	dest_qry         text;
	is_partition     boolean;
	partition_col_name     text;
	partition_range_cond     text;
	parent_rel_table text;
	fk_query text;
	trigger_name_ text;
	trigger_timing_ text;
	trigger_events_ text;
	trigger_orientation_ text;
	trigger_action_ text;
	
	BEGIN
	
	-- Check that source_schema exists
	SELECT oid INTO src_oid
	  FROM pg_namespace
	 WHERE nspname = quote_ident(source_schema);
	IF NOT FOUND
	  THEN 
	  RAISE NOTICE 'source schema % does not exist!', source_schema;
	  RETURN ;
	END IF;
	/*
	-- Check that dest_schema does not yet exist
	PERFORM nspname 
	  FROM pg_namespace
	 WHERE nspname = quote_ident(dest_schema);
	IF NOT FOUND
	  THEN 
	  EXECUTE 'CREATE SCHEMA ' || quote_ident(dest_schema) ;
	  -- RAISE NOTICE 'dest schema % already exists!', dest_schema;
	  RETURN ;
	END IF;
	*/
	
	EXECUTE 'CREATE SCHEMA IF NOT EXISTS ' || quote_ident(dest_schema) ;
	
	-- Create sequences
	-- TODO: Find a way to make this sequence's owner is the correct table.
	FOR object IN
	  SELECT sequence_name::text 
		FROM information_schema.sequences
	   WHERE sequence_schema = quote_ident(source_schema)
	LOOP
	  EXECUTE 'CREATE SEQUENCE ' || quote_ident(dest_schema) || '.' || quote_ident(object);
	  srctbl := quote_ident(source_schema) || '.' || quote_ident(object);
	END LOOP;
	
	-- Create functions 
	FOR func_oid IN
	  SELECT oid
		FROM pg_proc 
	   WHERE pronamespace = src_oid
	
	LOOP      
	  SELECT pg_get_functiondef(func_oid) INTO qry;
	  SELECT replace(qry, quote_ident(source_schema) || '.', quote_ident(dest_schema) || '.') INTO dest_qry;
	  EXECUTE dest_qry;
	
	END LOOP;
	
	-- Create tables 
	FOR object IN
	  SELECT TABLE_NAME::text as tx 
		FROM information_schema.tables 
	   WHERE table_schema = quote_ident(source_schema)
		 AND table_type = 'BASE TABLE'
		ORDER BY tx  asc
	LOOP
	
	   SELECT relispartition INTO is_partition
		FROM pg_catalog.pg_class
		WHERE relname = object;
		
		IF NOT is_partition THEN
		
			  select 
				col.column_name into partition_col_name
			from   
				(select
					 partrelid,
					 partnatts,
					 case partstrat 
						  when 'l' then 'list' 
						  when 'r' then 'range' end as partition_strategy,
					 unnest(partattrs) column_index
				 from
					 pg_partitioned_table) pt 
			join   
				pg_class par 
			on     
				par.oid = pt.partrelid
			join
				information_schema.columns col
			on  
		quote_ident(col.table_schema) = par.relnamespace::regnamespace::text
				and col.table_name = par.relname
				and ordinal_position = pt.column_index
			WHERE par.relnamespace::regnamespace::text = quote_ident(source_schema) AND par.relname = object;
			
		
		  buffer := quote_ident(dest_schema) || '.' || quote_ident(object);
		  EXECUTE 'CREATE TABLE ' || buffer || ' (LIKE ' || quote_ident(source_schema) || '.' || quote_ident(object) 
			  || ' INCLUDING ALL)' || (CASE WHEN partition_col_name IS NOT NULL THEN ' PARTITION BY RANGE ('|| quote_ident(partition_col_name)||')' ELSE '' END);
	
		  FOR column_, default_ IN
			SELECT column_name::text, 
				   REPLACE(column_default::text, source_schema, quote_ident(dest_schema)) 
			  FROM information_schema.COLUMNS 
			 WHERE table_schema =  quote_ident(dest_schema)
			   AND TABLE_NAME = object 
			   AND column_default LIKE 'nextval(%' || quote_ident(source_schema) || '%::regclass)'
		  LOOP
			  EXECUTE 'ALTER TABLE ' || buffer || ' ALTER COLUMN ' || column_ || ' SET DEFAULT ' || default_;
		  END LOOP;
			
		  IF include_recs 
			THEN 
			-- Insert records from source table
			  EXECUTE 'INSERT INTO ' || buffer || ' SELECT * FROM ' || quote_ident(source_schema) || '.' || quote_ident(object) || ';';
		  END IF;
		  
		ELSE
			SELECT pg_get_expr(p.relpartbound, p.oid) into partition_range_cond from pg_class as p
				JOIN pg_namespace as ns ON (ns.oid = p.relnamespace)
				where relname = object AND ns.nspname = source_schema;
			--select pg_get_expr(relpartbound, oid) into partition_range_cond from pg_class where relispartition and relname = object;
			RAISE NOTICE 'partition_range_cond %', partition_range_cond;
			SELECT REPLACE (REPLACE(partrelid::regclass::text, 'notification.', ''), 'organization.', '')
			INTO parent_rel_table from pg_partitioned_table WHERE partdefid::regclass::text  = quote_ident(source_schema) || '.' || quote_ident(object);
			--select partrelid::regclass::text, partdefid::regclass::text, * from pg_partitioned_table  --where  (partrelid::regclass::text) like quote_ident(source_schema) || '.%'
			IF parent_rel_table IS NULL THEN
				SELECT p.relname into parent_rel_table FROM pg_inherits
					JOIN pg_class as p ON (inhparent=p.oid)
					JOIN pg_namespace as ns ON (ns.oid = p.relnamespace)
					WHERE ((inhrelid::regclass::text ilike '%.' || object) OR 
					(inhrelid::regclass::text = object)) AND ns.nspname = source_schema;
			END IF;
			RAISE NOTICE 'parent_rel_table % of %', parent_rel_table, object;
			EXECUTE 'CREATE TABLE '|| quote_ident(dest_schema) || '.' || quote_ident(object) ||' PARTITION OF '|| quote_ident(dest_schema) 
			|| '.' ||quote_ident(parent_rel_table)||' ' ||partition_range_cond || ';';
		END IF;
		
	  FOR trigger_name_ IN
	  SELECT trigger_name::text FROM information_schema.TRIGGERS 
	  WHERE event_object_schema=source_schema and event_object_table=object 
	  GROUP BY trigger_name
	  LOOP
		buffer := quote_ident(dest_schema) || '.' || quote_ident(object);
		EXECUTE (SELECT 
		  REPLACE (
			REPLACE (
			  REPLACE(
				REPLACE (
				  REPLACE (
					REPLACE (pg_get_triggerdef(oid), 'public.', ''), 
				  'notification.', ''), 
				'organization.', ''), 
			  'EXECUTE PROCEDURE', 'EXECUTE FUNCTION'),
			'EXECUTE FUNCTION ', CASE WHEN POSITION ('after_insert_default' IN pg_get_triggerdef(oid)) > 0
				THEN 'EXECUTE FUNCTION public.' ELSE 'EXECUTE FUNCTION '|| quote_ident(dest_schema) ||'.' END), 
		  ' ON ', ' ON '|| quote_ident(dest_schema) ||'.') 
		  FROM pg_trigger
		  WHERE tgname = trigger_name_
          AND ( CASE WHEN substr((SELECT current_setting('server_version_num')), 1, 2)::integer >= 15 THEN tgparentid=0 ELSE true END)
		  AND ( CASE WHEN source_schema = 'public' THEN 
			tgrelid::regclass::text = quote_ident(object) ELSE 
			tgrelid::regclass::text = quote_ident(source_schema) || '.' ||quote_ident(object) END)
		  );
	  END LOOP;
	END LOOP;
	
	--  add FK constraint
	FOR qry IN
		SELECT 'ALTER TABLE ' || quote_ident(dest_schema) || '.' || quote_ident(rn.relname) 
		|| ' ADD CONSTRAINT ' || quote_ident(ct.conname) || ' ' || 
		  REPLACE( REPLACE (REPLACE (pg_get_constraintdef(ct.oid),'notification.', ''), 'organization.', ''),
		'REFERENCES ', CASE WHEN  POSITION( '.' IN pg_get_constraintdef(ct.oid))> 0 THEN 'REFERENCES '||quote_ident(dest_schema) ||'.'  ELSE 'REFERENCES public.' END) || ';'
		FROM pg_constraint ct
		JOIN pg_class rn ON rn.oid = ct.conrelid
		JOIN pg_namespace ns ON ns.oid = connamespace
	   WHERE connamespace = ns.oid
		 --AND rn.relkind = 'r'
		 AND rn.relispartition = false
		 AND ct.contype = 'f'
		 AND ct.conparentid = 0
		 AND ns.nspname = quote_ident(source_schema)
	  LOOP
		  RAISE NOTICE 'query for foreign key %',qry;
		EXECUTE qry;
	
	  END LOOP;
	
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."organizationList" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userList" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userOrganizationMapping" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."things" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."scheduledJobs" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."scheduledJobHistoryLogs" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."migrations" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."migrations_lock" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."emailTemplates" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."oAuthRevokedTokens" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."organizationAuthenticationMethods" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userAuthenticationMethods" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."reportTemplates" CASCADE;';
	
	EXECUTE 'DROP FUNCTION IF EXISTS ' || quote_ident(dest_schema) || '."clone_schema" CASCADE;';
	EXECUTE 'DROP FUNCTION IF EXISTS ' || quote_ident(dest_schema) || '."disable_trigger" CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."oAuthRevokedTokens" 
		DROP CONSTRAINT IF EXISTS "oAuthRevokedTokens_userId_fkey",
		DROP CONSTRAINT IF EXISTS "oAuthRevokedTokens_userListId_fkey",
		ADD CONSTRAINT "oAuthRevokedTokens_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."emailTemplates" 
		DROP CONSTRAINT IF EXISTS "emailTemplates_organizationId_fkey",
		DROP CONSTRAINT IF EXISTS "emailTemplates_organizationListId_fkey",
		ADD CONSTRAINT "emailTemplates_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."scheduledJobs" 
		DROP CONSTRAINT IF EXISTS "scheduledJobs_organizationId_fkey",
		DROP CONSTRAINT IF EXISTS "scheduledJobs_organizationListId_fkey",
		ADD CONSTRAINT "scheduledJobs_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."organizationAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "organizationauthenticationmethods_organizationid_foreign",
		DROP CONSTRAINT IF EXISTS "organizationAuthenticationMethods_organizationListId_fkey",
		ADD CONSTRAINT "organizationAuthenticationMethods_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."userAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "userauthenticationmethods_organizationid_foreign",
		DROP CONSTRAINT IF EXISTS "userAuthenticationMethods_userListId_fkey",
		ADD CONSTRAINT "userAuthenticationMethods_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."userAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "userauthenticationmethods_authmethodid_foreign",
		DROP CONSTRAINT IF EXISTS "userAuthenticationMethods_organizationAuthenticationMethodsId_fkey",
		ADD CONSTRAINT "userAuthenticationMethods_organizationAuthenticationMethodsId_fkey" 
		FOREIGN KEY ("authenticationMethodId") REFERENCES public."organizationAuthenticationMethods"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."reportTemplates" 
		DROP CONSTRAINT IF EXISTS "reportTemplates_organizationListId_fkey",
		ADD CONSTRAINT "reportTemplates_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."reportTemplates" 
		DROP CONSTRAINT IF EXISTS "reportTemplates_userListId_fkey",
		ADD CONSTRAINT "reportTemplates_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	RETURN; 
	
	END;
	$$;


ALTER FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) OWNER TO armonsuper;

--
-- Name: fpartitioncreator(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
		DECLARE 
						def_partition	text;
						i	timestamp with time zone;
						partition_to_create	text;
						previous_partition	text;
						next_partition	text;
						start_of_partition 	timestamp with time zone;
						end_of_partition 	timestamp with time zone;
					BEGIN
						IF (org_id = 'public' AND table_name = 'notification_instance') THEN
							PERFORM public.fpartitioncretor_for_public_notification_instance(org_id, table_name, partition_key);
							RETURN;
						ELSIF (table_name = 'notification_event') THEN
							PERFORM public.fpartitioncretor_for_schema_notification_event(org_id, table_name, partition_key);
							RETURN;
						ELSE
							def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
						
							EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DETACH PARTITION ' || def_partition || ';';
							FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
								SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
								' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || def_partition || ') AS T WHERE T.row_num = 1;'
							LOOP
								partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
								previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
								next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
			
								IF NOT EXISTS(
									SELECT relname FROM pg_class 
									WHERE relname = previous_partition AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									start_of_partition := date_trunc('month', i);
								ELSE
									start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
										from pg_class c
										where relname = previous_partition and 
										(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\((.+)\)');
								END IF;
			
								IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									end_of_partition := date_trunc('month', i) + interval '1 month';
								ELSE
									end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
										from pg_class c
										where relname = next_partition and 
										(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\((.+)\)');
								END IF;
			
								IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
									relnamespace::regnamespace::text = quote_ident(org_id)) THEN
									EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
										|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
										|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
								END IF;
			
								EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
								|| ' SELECT * FROM '|| def_partition ||' WHERE '|| 
								quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
								quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
			
								EXECUTE 'DELETE FROM ' || def_partition || ' WHERE '|| 
								quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
								quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
			
							END LOOP;
			
							EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ATTACH PARTITION ' || def_partition || ' DEFAULT;';
							RETURN;
						END IF;
					END;
		$$;


ALTER FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- Name: fpartitioncretor_for_public_notification_instance(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE 
            def_partition	text;
            i	timestamp without time zone;
            partition_to_create	text;
            previous_partition	text;
            next_partition	text;
            start_of_partition 	timestamp without time zone;
            end_of_partition 	timestamp without time zone;
            schema_name_to_process 	uuid;
        BEGIN
            def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
            
			EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
				|| def_partition || ';';
				
			FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || def_partition || ' GROUP BY "organizationId";'
			LOOP
				EXECUTE 'CREATE TEMPORARY TABLE "' || schema_name_to_process || '" ON COMMIT DROP AS SELECT * FROM "'
				|| schema_name_to_process || '".notification_instance WHERE id IN (SELECT id FROM '|| 
				quote_ident('temp_' || table_name || '_default') ||');';
			END LOOP;
			
			EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
			
            FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
                SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
                ' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
            LOOP
                partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
                previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
                next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
        
                IF NOT EXISTS(
                    SELECT relname FROM pg_class 
                    WHERE relname = previous_partition AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    start_of_partition := date_trunc('month', i);
                ELSE
                    start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                        from pg_class c
                        where relname = previous_partition and 
                        (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
                END IF;
                
                IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    end_of_partition := date_trunc('month', i) + interval '1 month';
                ELSE
                    end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                        from pg_class c
                        where relname = next_partition and 
                        (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
                END IF;
                
                IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                        || ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
                        || ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
                END IF;
                
                EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                || ' SELECT * FROM '|| quote_ident('temp_' || table_name || '_default') ||' WHERE '|| 
                quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
                
            END LOOP;
            
			FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || 
			quote_ident('temp_' || table_name || '_default') || ' GROUP BY "organizationId";'
			LOOP
				EXECUTE 'INSERT INTO "' || schema_name_to_process || '".notification_instance SELECT * FROM "'
				|| schema_name_to_process || '" ON CONFLICT DO NOTHING;';
			END LOOP;
			
        RETURN;
        END;
	$$;


ALTER FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- Name: fpartitioncretor_for_schema_notification_event(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
		DECLARE 
						def_partition	text;
						i	timestamp without time zone;
						partition_to_create	text;
						previous_partition	text;
						next_partition	text;
						start_of_partition 	timestamp without time zone;
						end_of_partition 	timestamp without time zone;
					BEGIN
						def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
						
						EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || org_id || '_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
							|| def_partition || ';';
			
						EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || org_id || '_notification_instance') || ' ON COMMIT DROP AS SELECT * FROM '
							|| quote_ident(org_id) || '.notification_instance'||' WHERE "eventId" IN (SELECT id FROM '|| 
							quote_ident('temp_' || org_id || '_' || table_name || '_default') ||');';
						
						EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
						
						FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
							SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
							' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || org_id || '_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
						LOOP
							partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
							previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
							next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
					
							IF NOT EXISTS(
								SELECT relname FROM pg_class 
								WHERE relname = previous_partition AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								start_of_partition := date_trunc('month', i);
							ELSE
								start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
									from pg_class c
									where relname = previous_partition and 
									(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\((.+)\)');
							END IF;
							
							IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								end_of_partition := date_trunc('month', i) + interval '1 month';
							ELSE
								end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
									from pg_class c
									where relname = next_partition and 
									(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\((.+)\)');
							END IF;
							
							IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
								relnamespace::regnamespace::text = quote_ident(org_id)) THEN
								EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
									|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
									|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
							END IF;
							
							EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
							|| ' SELECT * FROM '|| quote_ident('temp_' || org_id || '_' || table_name || '_default') ||' WHERE '|| 
							quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
							quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
							
						END LOOP;
			
						EXECUTE 'INSERT INTO ' || quote_ident(org_id) ||'.notification_instance SELECT * FROM '
						|| quote_ident('temp_' || org_id || '_notification_instance') || ' ON CONFLICT DO NOTHING;';
						
					RETURN;
					END;
		$$;


ALTER FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- Name: json_append(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_append(data json, insert_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        UNION ALL
        SELECT * FROM json_each(insert_data)
    ) t;
$$;


ALTER FUNCTION public.json_append(data json, insert_data json) OWNER TO armonsuper;

--
-- Name: json_delete(json, text[]); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_delete(data json, keys text[]) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        WHERE key <>ALL(keys)
    ) t;
$$;


ALTER FUNCTION public.json_delete(data json, keys text[]) OWNER TO armonsuper;

--
-- Name: json_merge(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_merge(data json, merge_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH to_merge AS (
            SELECT * FROM json_each(merge_data)
        )
        SELECT *
        FROM json_each(data)
        WHERE key NOT IN (SELECT key FROM to_merge)
        UNION ALL
        SELECT * FROM to_merge
    ) t;
$$;


ALTER FUNCTION public.json_merge(data json, merge_data json) OWNER TO armonsuper;

--
-- Name: json_update(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_update(data json, update_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH old_data AS (
            SELECT * FROM json_each(data)
        ), to_update AS (
            SELECT * FROM json_each(update_data)
            WHERE key IN (SELECT key FROM old_data)
        )
    SELECT * FROM old_data
    WHERE key NOT IN (SELECT key FROM to_update)
    UNION ALL
    SELECT * FROM to_update
) t;
$$;


ALTER FUNCTION public.json_update(data json, update_data json) OWNER TO armonsuper;

--
-- Name: run_for_all_schemas(character varying); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.run_for_all_schemas(query_str character varying) RETURNS TABLE(schema_id text, organization_name text, affected text)
    LANGUAGE plpgsql
    AS $$
    DECLARE
    var_r record;
    affcount integer;
    afftotal integer;
    BEGIN
        affcount := 0;
        afftotal := 0;
        FOR var_r IN( SELECT id, name FROM public."organizationList" )
        LOOP
            EXECUTE REPLACE(query_str, '__TBLSCHM__'::text, quote_ident(var_r.id::text));
            GET DIAGNOSTICS affcount = ROW_COUNT;
            afftotal := afftotal + affcount;
            RETURN QUERY EXECUTE 'SELECT ''' || var_r.id || ''', ''' || var_r.name || ''', ''' || affcount::text || ' rows affected.''';
        END LOOP;
        RETURN QUERY SELECT NULL::text, 'TUM ORGANIZASYONLAR', afftotal::text || ' rows affected.';
    END;
    $$;


ALTER FUNCTION public.run_for_all_schemas(query_str character varying) OWNER TO armonsuper;

--
-- Name: select_for_all_schemas(character varying); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.select_for_all_schemas(query_string character varying) RETURNS TABLE(schema_id text, organization_name text, query_result json)
    LANGUAGE plpgsql
    AS $$
    DECLARE
    var_r record;
    BEGIN
        FOR var_r IN( SELECT id, name FROM public."organizationList" )
        LOOP
            RETURN QUERY EXECUTE 'SELECT ''' || var_r.id || ''', ''' || var_r.name || ''', row_to_json(___sq___.*) FROM ( ' || REPLACE(query_string, '__TBLSCHM__'::text, quote_ident(var_r.id::text)) || ') ___sq___';
        END LOOP;
    END;
    $$;


ALTER FUNCTION public.select_for_all_schemas(query_string character varying) OWNER TO armonsuper;

--
-- Name: zz_notification_instance(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.zz_notification_instance() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'INSERT') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				NEW.id,
				1,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."organizationId",
				NEW.state,
				NEW.note
			);
		ELSIF (TG_OP = 'UPDATE') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				NEW.id,
				2,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."organizationId",
				NEW.state,
				NEW.note
			);    
		ELSIF (TG_OP = 'DELETE') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				OLD.id,
				3,
				_now,
				txid_current(),
				OLD."createdT",
				OLD."organizationId",
				OLD.state,
				OLD.note
			);       
		END IF;    
		RETURN NULL;
	END;
	$$;


ALTER FUNCTION public.zz_notification_instance() OWNER TO armonsuper;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: accessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    location character varying(255),
    "remoteAvailable" boolean DEFAULT false NOT NULL,
    "isRemoteDefault" boolean,
    "organizationId" uuid NOT NULL,
    "accessControlPointType" integer NOT NULL,
    "authenticationFactors" json,
    "deviceId" uuid,
    states json,
    "defaultPrivileges" json,
    "geoLocation" jsonb
);


ALTER TABLE organization."accessControlPoints" OWNER TO armonsuper;

--
-- Name: accessRuleHistory; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRuleHistory" (
    id uuid NOT NULL,
    "createdDate" date NOT NULL,
    "accessRuleId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    count smallint NOT NULL,
    "lastUpdateAccessControlPointId" uuid,
    "lastActionDateISO" timestamp with time zone
);


ALTER TABLE organization."accessRuleHistory" OWNER TO armonsuper;

--
-- Name: accessRuleSets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRuleSets" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "regionId" uuid,
    name character varying(255) NOT NULL,
    "isActive" boolean NOT NULL,
    "uncoveredAccessStatus" integer DEFAULT 1 NOT NULL,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "createdAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    note character varying(512)
);


ALTER TABLE organization."accessRuleSets" OWNER TO armonsuper;

--
-- Name: accessRules; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRules" (
    id uuid NOT NULL,
    "accessRuleSetId" uuid,
    direction integer NOT NULL,
    "acceptStatus" integer NOT NULL,
    type integer NOT NULL,
    parameters json NOT NULL,
    "createdAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "updatedAt" timestamp with time zone
);


ALTER TABLE organization."accessRules" OWNER TO armonsuper;

--
-- Name: access_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    log jsonb NOT NULL,
    "credentialData" jsonb
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.access_logs OWNER TO armonsuper;

--
-- Name: access_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    log jsonb NOT NULL,
    "credentialData" jsonb
);
ALTER TABLE ONLY organization.access_logs ATTACH PARTITION organization.access_logs_default DEFAULT;


ALTER TABLE organization.access_logs_default OWNER TO armonsuper;

--
-- Name: access_point_qr_code; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_point_qr_code (
    id uuid NOT NULL,
    "accessPointId" uuid NOT NULL,
    "qrCodeData" character varying(255) NOT NULL,
    config jsonb NOT NULL,
    "remoteRelayId" uuid
);


ALTER TABLE organization.access_point_qr_code OWNER TO armonsuper;

--
-- Name: access_snapshots; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_snapshots (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.access_snapshots OWNER TO armonsuper;

--
-- Name: access_snapshots_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_snapshots_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.access_snapshots ATTACH PARTITION organization.access_snapshots_default DEFAULT;


ALTER TABLE organization.access_snapshots_default OWNER TO armonsuper;

--
-- Name: adapters; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.adapters (
    id uuid NOT NULL,
    "organizationId" uuid,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    number integer,
    type integer,
    ip character varying(255),
    name character varying(255),
    "certBeginDate" timestamp with time zone,
    "certExpDate" timestamp with time zone,
    "certFiles" bytea,
    "publicKey" character varying(2048) DEFAULT 'KEY'::character varying,
    token character varying(255)
);


ALTER TABLE organization.adapters OWNER TO armonsuper;

--
-- Name: antiPassbackStates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."antiPassbackStates" (
    id uuid NOT NULL,
    "regionId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "actionUtc" timestamp with time zone,
    state integer,
    "accessControlPointId" uuid NOT NULL,
    "entranceLockExpirationUtc" timestamp with time zone,
    "exitLockExpirationUtc" timestamp with time zone
);


ALTER TABLE organization."antiPassbackStates" OWNER TO armonsuper;

--
-- Name: aperioLocks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."aperioLocks" (
    "hubDeviceId" uuid NOT NULL,
    "lockDeviceId" uuid NOT NULL
);


ALTER TABLE organization."aperioLocks" OWNER TO armonsuper;

--
-- Name: attendanceAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."attendanceAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "workingHoursScheduleId" uuid,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."attendanceAccessControlPoints" OWNER TO armonsuper;

--
-- Name: cameraActions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."cameraActions" (
    "cameraId" uuid,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    type integer NOT NULL,
    settings json
);


ALTER TABLE organization."cameraActions" OWNER TO armonsuper;

--
-- Name: cameras; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.cameras (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    "streamUrl" character varying(255),
    "userName" character varying(255),
    password character varying(255),
    "snapshotUrl" character varying(255),
    "accessControlPointId" uuid,
    "remoteAccess" boolean,
    "wiegandReaderIds" json,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "exitButtonIds" json,
    "proxyUrl" character varying(255) DEFAULT NULL::character varying,
    "hikVisionLicensePlateCameraLaneIds" json,
    "impinjSpeedWayGateWayAntennaIds" json
);


ALTER TABLE organization.cameras OWNER TO armonsuper;

--
-- Name: controlPanelESeriesSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelESeriesSettings" (
    "deviceId" uuid NOT NULL,
    "mainControlPanelId" uuid,
    number integer
);


ALTER TABLE organization."controlPanelESeriesSettings" OWNER TO armonsuper;

--
-- Name: controlPanelMSeriesAnalogInputs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelMSeriesAnalogInputs" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    threshold real,
    description character varying(255)
);


ALTER TABLE organization."controlPanelMSeriesAnalogInputs" OWNER TO armonsuper;

--
-- Name: controlPanelMSeriesSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelMSeriesSettings" (
    "deviceId" uuid NOT NULL,
    "batteryPlugged" boolean,
    "emergencyPlugged" boolean,
    extensions json,
    "onBoardComputerModel" character varying(255),
    "onBoardComputerVersion" character varying(255),
    "onBoardComputerOs" character varying(255),
    "onBoardComputerTotalStorage" real,
    "onBoardComputerFreeStorage" real,
    "armonCpServerVersion" character varying(255),
    caption character varying(255)
);


ALTER TABLE organization."controlPanelMSeriesSettings" OWNER TO armonsuper;

--
-- Name: counter_sensor_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.counter_sensor_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.counter_sensor_logs OWNER TO armonsuper;

--
-- Name: counter_sensor_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.counter_sensor_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.counter_sensor_logs ATTACH PARTITION organization.counter_sensor_logs_default DEFAULT;


ALTER TABLE organization.counter_sensor_logs_default OWNER TO armonsuper;

--
-- Name: customReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."customReports" (
    id uuid NOT NULL,
    name character varying(511) NOT NULL,
    filters jsonb NOT NULL,
    description character varying(1023),
    formats smallint[] NOT NULL,
    "minPermissions" jsonb NOT NULL,
    "userFilterId" uuid
);


ALTER TABLE organization."customReports" OWNER TO armonsuper;

--
-- Name: deviceCurrentVersions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceCurrentVersions" (
    brand integer NOT NULL,
    model character varying(255) NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    version character varying(255) NOT NULL,
    "updateFilePath" character varying(255) NOT NULL,
    encoding character varying(255) NOT NULL,
    md5 character varying(255) NOT NULL,
    "forBeta" boolean,
    "specificDeviceIds" text
);


ALTER TABLE organization."deviceCurrentVersions" OWNER TO armonsuper;

--
-- Name: deviceDryContactInputs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceDryContactInputs" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    name character varying(255),
    number integer,
    nc boolean NOT NULL,
    type integer NOT NULL,
    settings json
);


ALTER TABLE organization."deviceDryContactInputs" OWNER TO armonsuper;

--
-- Name: deviceIntegrations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceIntegrations" (
    "integratedDeviceId" uuid NOT NULL,
    "integratingDeviceId" uuid NOT NULL,
    type integer NOT NULL,
    "extensionFields" text
);


ALTER TABLE organization."deviceIntegrations" OWNER TO armonsuper;

--
-- Name: deviceReaders; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceReaders" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    location character varying(255),
    name character varying(255),
    model character varying(255),
    number integer,
    direction integer,
    "readerOutputType" integer,
    "dataFormat" integer,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "credentialType" integer
);


ALTER TABLE organization."deviceReaders" OWNER TO armonsuper;

--
-- Name: deviceRelays; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceRelays" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    name character varying(255),
    direction integer,
    "driveDuration" integer NOT NULL,
    number integer NOT NULL,
    location character varying(255)
);


ALTER TABLE organization."deviceRelays" OWNER TO armonsuper;

--
-- Name: deviceUpdateStatus; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceUpdateStatus" (
    "deviceId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    attempt integer NOT NULL,
    version character varying(255) NOT NULL
);


ALTER TABLE organization."deviceUpdateStatus" OWNER TO armonsuper;

--
-- Name: deviceWiegandReaders; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceWiegandReaders" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    location character varying(255),
    name character varying(255),
    model character varying(255),
    number integer,
    direction integer,
    "dataFormat" integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "authenticationFactor" integer
);


ALTER TABLE organization."deviceWiegandReaders" OWNER TO armonsuper;

--
-- Name: devices; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.devices (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    "adapterId" uuid,
    brand integer NOT NULL,
    "serialNumber" character varying(255) NOT NULL,
    model character varying(255) NOT NULL,
    name character varying(255),
    location character varying(255),
    ip character varying(255),
    port integer,
    "lastSyncISO" timestamp with time zone,
    "isBeta" boolean,
    "amqpUsername" character varying(255),
    "amqpPassword" character varying(255),
    "publicKey" character varying(2048) DEFAULT 'KEY'::character varying,
    "swVersion" character varying(255),
    "hwVersion" character varying(255),
    health json,
    timezone character varying(40),
    caption character varying(63) DEFAULT NULL::character varying,
    "certBeginDate" timestamp with time zone,
    "certExpDate" timestamp with time zone,
    "certFiles" bytea,
    token character varying(255),
    "privateKey" character varying(2048) DEFAULT 'PRIVATE_KEY'::character varying
);


ALTER TABLE organization.devices OWNER TO armonsuper;

--
-- Name: dynamicForms; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."dynamicForms" (
    id uuid NOT NULL,
    form jsonb NOT NULL
);


ALTER TABLE organization."dynamicForms" OWNER TO armonsuper;

--
-- Name: employeeDays; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeDays" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    date date NOT NULL,
    "organizationId" uuid NOT NULL,
    data jsonb NOT NULL
);


ALTER TABLE organization."employeeDays" OWNER TO armonsuper;

--
-- Name: employeeLiveDay; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeLiveDay" (
    id uuid NOT NULL,
    "startAt" timestamp with time zone NOT NULL,
    "expiredAt" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "workPlanIds" jsonb,
    "updatedAt" timestamp with time zone,
    "updateRequiredRaisedAt" timestamp with time zone NOT NULL,
    "updateRequiredReason" smallint,
    data jsonb,
    "sessionId" uuid
);


ALTER TABLE organization."employeeLiveDay" OWNER TO armonsuper;

--
-- Name: employeeMonths; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeMonths" (
    id uuid NOT NULL,
    date date NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    data jsonb NOT NULL,
    note text,
    "monthlyReportId" uuid NOT NULL,
    "updatedByUserId" uuid,
    "isChecked" boolean NOT NULL
);


ALTER TABLE organization."employeeMonths" OWNER TO armonsuper;

--
-- Name: employee_day_segments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.employee_day_segments (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone NOT NULL,
    "endDateTime" timestamp with time zone NOT NULL,
    "workPlanId" uuid,
    data jsonb NOT NULL
)
PARTITION BY RANGE ("startDateTime");


ALTER TABLE organization.employee_day_segments OWNER TO armonsuper;

--
-- Name: employee_day_segments_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.employee_day_segments_default (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone NOT NULL,
    "endDateTime" timestamp with time zone NOT NULL,
    "workPlanId" uuid,
    data jsonb NOT NULL
);
ALTER TABLE ONLY organization.employee_day_segments ATTACH PARTITION organization.employee_day_segments_default DEFAULT;


ALTER TABLE organization.employee_day_segments_default OWNER TO armonsuper;

--
-- Name: floorPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."floorPlans" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    svg text NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE organization."floorPlans" OWNER TO armonsuper;

--
-- Name: hikVisionLicencePlateCameraLanes; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."hikVisionLicencePlateCameraLanes" (
    id uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    number integer NOT NULL,
    name character varying(255) NOT NULL,
    direction integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "accessControlPointId" uuid
);


ALTER TABLE organization."hikVisionLicencePlateCameraLanes" OWNER TO armonsuper;

--
-- Name: impinjSpeedWayGateWayAntennas; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."impinjSpeedWayGateWayAntennas" (
    id uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    number integer NOT NULL,
    name character varying(255) NOT NULL,
    direction integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "accessControlPointId" uuid
);


ALTER TABLE organization."impinjSpeedWayGateWayAntennas" OWNER TO armonsuper;

--
-- Name: log_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_history (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "insertionUtc" timestamp with time zone NOT NULL,
    type integer,
    data jsonb
)
PARTITION BY RANGE ("insertionUtc");


ALTER TABLE organization.log_history OWNER TO armonsuper;

--
-- Name: log_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_history_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "insertionUtc" timestamp with time zone NOT NULL,
    type integer,
    data jsonb
);
ALTER TABLE ONLY organization.log_history ATTACH PARTITION organization.log_history_default DEFAULT;


ALTER TABLE organization.log_history_default OWNER TO armonsuper;

--
-- Name: log_process_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_process_history (
    "startUtc" timestamp with time zone NOT NULL,
    "firstInsertionUtc" timestamp with time zone NOT NULL,
    "lastInsertionUtc" timestamp with time zone NOT NULL,
    "processDuration" integer,
    "processedItemCount" integer,
    error character varying(256)
)
PARTITION BY RANGE ("startUtc");


ALTER TABLE organization.log_process_history OWNER TO armonsuper;

--
-- Name: log_process_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_process_history_default (
    "startUtc" timestamp with time zone NOT NULL,
    "firstInsertionUtc" timestamp with time zone NOT NULL,
    "lastInsertionUtc" timestamp with time zone NOT NULL,
    "processDuration" integer,
    "processedItemCount" integer,
    error character varying(256)
);
ALTER TABLE ONLY organization.log_process_history ATTACH PARTITION organization.log_process_history_default DEFAULT;


ALTER TABLE organization.log_process_history_default OWNER TO armonsuper;

--
-- Name: mVW_SearchUsers; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."mVW_SearchUsers" AS
SELECT
    NULL::uuid AS id,
    NULL::boolean AS "isDisabledForUserOrganization",
    NULL::uuid AS "userId",
    NULL::uuid AS "organizationId",
    NULL::text AS "userOrganizationProfileNameForOrder",
    NULL::text AS "userOrganizationProfileSurnameForOrder",
    NULL::text AS "userOrganizationProfileUniqueIdForOrder",
    NULL::json AS "user",
    NULL::json AS "userOrganizationProfile",
    NULL::text AS "userGroupIds",
    NULL::json AS "userGroups",
    NULL::text AS "organizationUnitIds",
    NULL::text AS "organizationUnitHierarchies",
    NULL::json AS "organizationUnits",
    NULL::tsvector AS "searchDocument";


ALTER TABLE organization."mVW_SearchUsers" OWNER TO armonsuper;

--
-- Name: medium_sms; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.medium_sms (
    id uuid NOT NULL,
    "organizationId" uuid,
    "smsProvider" smallint NOT NULL,
    info jsonb NOT NULL
);


ALTER TABLE organization.medium_sms OWNER TO armonsuper;

--
-- Name: medium_smtp; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.medium_smtp (
    id uuid NOT NULL,
    "organizationId" uuid,
    info jsonb NOT NULL
);


ALTER TABLE organization.medium_smtp OWNER TO armonsuper;

--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: organization; Owner: armonsuper
--

CREATE SEQUENCE organization.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE organization.migrations_id_seq OWNER TO armonsuper;

--
-- Name: monthlySummaryReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."monthlySummaryReports" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "runDateTime" timestamp with time zone,
    "isFinalized" boolean,
    year integer,
    month integer,
    note character varying(255),
    "updatedDate" timestamp with time zone,
    "updatedById" uuid
);


ALTER TABLE organization."monthlySummaryReports" OWNER TO armonsuper;

--
-- Name: monthly_summary_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.monthly_summary_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.monthly_summary_history OWNER TO armonsuper;

--
-- Name: monthly_summary_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.monthly_summary_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.monthly_summary_history ATTACH PARTITION organization.monthly_summary_history_default DEFAULT;


ALTER TABLE organization.monthly_summary_history_default OWNER TO armonsuper;

--
-- Name: notification; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "createdByUserId" uuid,
    type smallint NOT NULL,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL
);


ALTER TABLE organization.notification OWNER TO armonsuper;

--
-- Name: notificationAttachments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."notificationAttachments" (
    id uuid NOT NULL,
    name character varying(255),
    "actionUtc" timestamp with time zone
);


ALTER TABLE organization."notificationAttachments" OWNER TO armonsuper;

--
-- Name: notification_access; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_access (
    id uuid NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL
);


ALTER TABLE organization.notification_access OWNER TO armonsuper;

--
-- Name: notification_event; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
)
PARTITION BY RANGE ("createdT");


ALTER TABLE organization.notification_event OWNER TO armonsuper;

--
-- Name: notification_event_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
);
ALTER TABLE ONLY organization.notification_event ATTACH PARTITION organization.notification_event_default DEFAULT;


ALTER TABLE organization.notification_event_default OWNER TO armonsuper;

--
-- Name: notification_instance; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_instance (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "mediumGroupId" uuid NOT NULL,
    medium smallint NOT NULL,
    "notificationId" uuid NOT NULL,
    "receiverUserId" uuid NOT NULL,
    content jsonb,
    "eventId" uuid NOT NULL,
    CONSTRAINT notification_instance_medium_check CHECK ((medium = ANY ('{1,2,3,4}'::smallint[])))
)
PARTITION BY RANGE ("createdT");


ALTER TABLE organization.notification_instance OWNER TO armonsuper;

--
-- Name: notification_instance_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_instance_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "mediumGroupId" uuid NOT NULL,
    medium smallint NOT NULL,
    "notificationId" uuid NOT NULL,
    "receiverUserId" uuid NOT NULL,
    content jsonb,
    "eventId" uuid NOT NULL,
    CONSTRAINT notification_instance_medium_check CHECK ((medium = ANY ('{1,2,3,4}'::smallint[])))
);
ALTER TABLE ONLY organization.notification_instance ATTACH PARTITION organization.notification_instance_default DEFAULT;


ALTER TABLE organization.notification_instance_default OWNER TO armonsuper;

--
-- Name: notification_sensor; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_sensor (
    id uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT "notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
);


ALTER TABLE organization.notification_sensor OWNER TO armonsuper;

--
-- Name: oAuthClients; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."oAuthClients" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    profile integer NOT NULL,
    "clientSecret" character varying(511),
    "redirectUris" character varying(1023)
);


ALTER TABLE organization."oAuthClients" OWNER TO armonsuper;

--
-- Name: oAuthTokens; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."oAuthTokens" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "accessTokenExpiresOn" timestamp with time zone NOT NULL,
    "refreshToken" uuid,
    "refreshTokenExpiresOn" timestamp with time zone,
    "userId" uuid NOT NULL,
    "grantedAt" timestamp with time zone NOT NULL,
    "refreshedAt" timestamp with time zone,
    ip character varying(63) NOT NULL,
    "userAgent" character varying(255) NOT NULL,
    "organizationAuths" character varying(8092) NOT NULL,
    scopes character varying(255),
    "oAuthClientId" uuid
);


ALTER TABLE organization."oAuthTokens" OWNER TO armonsuper;

--
-- Name: organizationActiveVisits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationActiveVisits" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone,
    "organizationVisitorProfileId" uuid NOT NULL,
    "visitedOrganizationUnitId" uuid,
    "visitedUserOrganizationId" uuid,
    "escortUserOrganizationId" uuid,
    "extensionFields" json NOT NULL,
    "expectedStartUtc" timestamp with time zone,
    "expectedEndUtc" timestamp with time zone,
    state integer,
    "visitorRegistrationPointId" uuid,
    "processTime" double precision
);


ALTER TABLE organization."organizationActiveVisits" OWNER TO armonsuper;

--
-- Name: organizationEmailTemplates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationEmailTemplates" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer NOT NULL,
    "bodyTemplate" character varying(32768) NOT NULL,
    "subjectTemplate" character varying(1024) NOT NULL,
    configuration text,
    locale character varying(255) NOT NULL,
    "attachmentTemplate" character varying(32768)
);


ALTER TABLE organization."organizationEmailTemplates" OWNER TO armonsuper;

--
-- Name: organizationFeedbacks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationFeedbacks" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "createdBy" uuid,
    "createdAt" timestamp with time zone NOT NULL,
    caption character varying(255) NOT NULL,
    status integer NOT NULL,
    type integer NOT NULL
);


ALTER TABLE organization."organizationFeedbacks" OWNER TO armonsuper;

--
-- Name: organizationForms; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationForms" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    type integer NOT NULL,
    "organizationId" uuid NOT NULL,
    fields json NOT NULL
);


ALTER TABLE organization."organizationForms" OWNER TO armonsuper;

--
-- Name: organizationModules; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationModules" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    module integer NOT NULL,
    "enableUtc" timestamp with time zone,
    "disableUtc" timestamp with time zone,
    status integer DEFAULT 1 NOT NULL,
    "maxCredentialCount" integer
);


ALTER TABLE organization."organizationModules" OWNER TO armonsuper;

--
-- Name: organizationPACSModuleSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationPACSModuleSettings" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "annualLeavePPermissionTypeId" uuid,
    "casualLeavePPermissionTypeId" uuid,
    "canUseSystemPPermissionPrint" boolean DEFAULT false,
    "deputySelectionEnabled" boolean DEFAULT false,
    "annualPPermissionAgeLimits" json,
    "ppermissionClaimProfile" integer NOT NULL
);


ALTER TABLE organization."organizationPACSModuleSettings" OWNER TO armonsuper;

--
-- Name: organizationUnitDefaultAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUnitDefaultAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationUnitId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "defaultPrivileges" json
);


ALTER TABLE organization."organizationUnitDefaultAccessControlPoints" OWNER TO armonsuper;

--
-- Name: organizationUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    name character varying(255) NOT NULL,
    "parentId" uuid,
    "ancestorIds" character varying(2047),
    "shortCode" character varying(255),
    "managerUserId" uuid,
    "managerUserOrganizationId" uuid,
    "typeId" uuid NOT NULL,
    settings jsonb
);


ALTER TABLE organization."organizationUnits" OWNER TO armonsuper;

--
-- Name: organizationUserDefinedListValues; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserDefinedListValues" (
    id uuid NOT NULL,
    "userDefinedListId" uuid,
    value character varying(255),
    "relatedValueId" uuid
);


ALTER TABLE organization."organizationUserDefinedListValues" OWNER TO armonsuper;

--
-- Name: organizationUserDefinedLists; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserDefinedLists" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer,
    caption character varying(255),
    "valueType" integer
);


ALTER TABLE organization."organizationUserDefinedLists" OWNER TO armonsuper;

--
-- Name: organizationUserSync; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserSync" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    type integer,
    config json
);


ALTER TABLE organization."organizationUserSync" OWNER TO armonsuper;

--
-- Name: organizationVisitorDefaultAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorDefaultAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."organizationVisitorDefaultAccessControlPoints" OWNER TO armonsuper;

--
-- Name: organizationVisitorModuleSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorModuleSettings" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "visitorProfileFormFields" json NOT NULL,
    "availableCredentials" json NOT NULL,
    "visitFormFields" json NOT NULL,
    "visitorProfileFormFieldSearchEndPoint" character varying(511) NOT NULL,
    "visitorProfileFormSearchEndPoint" character varying(511) NOT NULL,
    "visitFormFieldSearchEndPoint" character varying(511) NOT NULL,
    "preRegistrationAvailable" boolean DEFAULT true NOT NULL,
    "visitorStates" json,
    "forceToSelectRegistrationPoint" boolean DEFAULT false NOT NULL,
    "maxExpectedDayCount" integer,
    "visitFormFinalizedEndPoints" json,
    settings json,
    "settingsVersion" character varying(3)
);


ALTER TABLE organization."organizationVisitorModuleSettings" OWNER TO armonsuper;

--
-- Name: organizationVisitorProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255),
    "uniqueId" character varying(255),
    "extensionFields" json NOT NULL,
    "isAnonym" boolean DEFAULT false,
    "approvedGDPR" boolean DEFAULT false,
    thumbnail bytea
);


ALTER TABLE organization."organizationVisitorProfiles" OWNER TO armonsuper;

--
-- Name: organizationVisitorStates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorStates" (
    id uuid NOT NULL,
    "organizationVisitorProfileId" uuid,
    state integer NOT NULL,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    note character varying(255),
    "createdBy" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "deletedBy" uuid,
    "deletedAt" timestamp with time zone
);


ALTER TABLE organization."organizationVisitorStates" OWNER TO armonsuper;

--
-- Name: organization_feedback_updates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedback_updates (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.organization_feedback_updates OWNER TO armonsuper;

--
-- Name: organization_feedback_updates_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedback_updates_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.organization_feedback_updates ATTACH PARTITION organization.organization_feedback_updates_default DEFAULT;


ALTER TABLE organization.organization_feedback_updates_default OWNER TO armonsuper;

--
-- Name: organization_feedbacks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedbacks (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.organization_feedbacks OWNER TO armonsuper;

--
-- Name: organization_feedbacks_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedbacks_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.organization_feedbacks ATTACH PARTITION organization.organization_feedbacks_default DEFAULT;


ALTER TABLE organization.organization_feedbacks_default OWNER TO armonsuper;

--
-- Name: organizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organizations (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    "hasEmergencyManagement" boolean DEFAULT false,
    "availableCredentialTypes" json DEFAULT '[0,3,2]'::json NOT NULL,
    "emergencyState" integer DEFAULT 0 NOT NULL,
    "usernamePolicy" integer DEFAULT 2,
    "uniqueIdFieldCaption" character varying(255),
    "credentialTypes" json NOT NULL,
    "publicKey" character varying(511) NOT NULL,
    "privateKey" character varying(511) NOT NULL,
    "annualPPermissionUpdateIntervals" character varying(512),
    "userOrganizationProfileSettings" json,
    "customCredentialTypes" json,
    "mobileCreditApplicationSettings" json,
    code character varying(5),
    alias character varying(32),
    "contactInfo" json,
    settings jsonb NOT NULL,
    "smsBalance" integer DEFAULT 0,
    "organizationUnitDynamicFormId" uuid
);


ALTER TABLE organization.organizations OWNER TO armonsuper;

--
-- Name: pacs_notification_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.pacs_notification_scheduled_job (
    id uuid NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL
);


ALTER TABLE organization.pacs_notification_scheduled_job OWNER TO armonsuper;

--
-- Name: ppermissionAttachments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionAttachments" (
    id uuid NOT NULL,
    "ppermissionId" uuid,
    name character varying(255)
);


ALTER TABLE organization."ppermissionAttachments" OWNER TO armonsuper;

--
-- Name: ppermissionClaims; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionClaims" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "ppermissionTypeId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "dueDate" timestamp with time zone,
    used integer,
    total integer
);


ALTER TABLE organization."ppermissionClaims" OWNER TO armonsuper;

--
-- Name: ppermissionTypeApprovements; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionTypeApprovements" (
    id uuid NOT NULL,
    "ppermissionTypeId" uuid,
    "rootOrganizationUnitId" uuid,
    "order" integer
);


ALTER TABLE organization."ppermissionTypeApprovements" OWNER TO armonsuper;

--
-- Name: ppermissionTypes; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionTypes" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    description character varying(255),
    "isPassive" boolean,
    "hrCanInit" boolean,
    "personnelCanInit" boolean,
    "ignoreInCalculations" boolean,
    "trustDeclaration" boolean,
    "isDailyScheduled" boolean,
    "minValue" integer,
    "maxValue" integer,
    "maxValueBoundaryInterval" integer,
    "outOfWorkHours" boolean,
    "sendNotification" boolean,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "needsManagerDeputy" boolean DEFAULT false,
    "userMustSign" boolean DEFAULT false,
    type integer,
    "showRemainingCount" boolean DEFAULT false,
    "isUnpaidLeave" boolean DEFAULT false NOT NULL,
    "notifyHR" boolean,
    "noteIsMandatory" boolean NOT NULL,
    "needsUserDeputy" boolean NOT NULL,
    "dynamicFormId" uuid
);


ALTER TABLE organization."ppermissionTypes" OWNER TO armonsuper;

--
-- Name: ppermission_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermission_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.ppermission_history OWNER TO armonsuper;

--
-- Name: ppermission_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermission_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.ppermission_history ATTACH PARTITION organization.ppermission_history_default DEFAULT;


ALTER TABLE organization.ppermission_history_default OWNER TO armonsuper;

--
-- Name: ppermissions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermissions (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "ppermissionTypeId" uuid,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    "requestDateTime" timestamp with time zone,
    note character varying(512),
    status integer,
    "requestUserId" uuid,
    "fromIntegration" boolean,
    "requestRole" integer NOT NULL,
    "dynamicFormId" uuid,
    "dynamicFormData" jsonb
);


ALTER TABLE organization.ppermissions OWNER TO armonsuper;

--
-- Name: preparedReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."preparedReports" (
    id uuid NOT NULL,
    "createdDt" timestamp with time zone NOT NULL,
    "expirationDt" timestamp with time zone NOT NULL,
    "userFilterId" uuid,
    format smallint NOT NULL,
    CONSTRAINT "preparedReports_format_check" CHECK ((format = ANY ('{1,2}'::smallint[])))
);


ALTER TABLE organization."preparedReports" OWNER TO armonsuper;

--
-- Name: preregisterDailySummaries; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."preregisterDailySummaries" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "selfPreregisterCount" integer,
    "totalCount" integer,
    "totaltoVisitCount" integer,
    "selftoVisitCount" integer,
    date timestamp with time zone
);


ALTER TABLE organization."preregisterDailySummaries" OWNER TO armonsuper;

--
-- Name: recalculateWorkQueue; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."recalculateWorkQueue" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDate" date NOT NULL,
    "createdAt" timestamp with time zone DEFAULT now() NOT NULL,
    reason smallint NOT NULL,
    note text
);


ALTER TABLE organization."recalculateWorkQueue" OWNER TO armonsuper;

--
-- Name: regionAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."regionAccessControlPoints" (
    id uuid NOT NULL,
    "regionId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."regionAccessControlPoints" OWNER TO armonsuper;

--
-- Name: regionTickets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."regionTickets" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    "deletedAt" timestamp with time zone,
    "regionId" uuid,
    "organizationId" uuid,
    name character varying(255) NOT NULL,
    "requiredUnits" integer NOT NULL
);


ALTER TABLE organization."regionTickets" OWNER TO armonsuper;

--
-- Name: regions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.regions (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    "antiPassback" boolean NOT NULL,
    "organizationId" uuid NOT NULL,
    "antiPassbackLockDuration" integer,
    "visitorAccess" boolean,
    "terminateVisitOnExit" boolean,
    "emergencyState" integer DEFAULT 1
);


ALTER TABLE organization.regions OWNER TO armonsuper;

--
-- Name: report_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.report_scheduled_job (
    id uuid NOT NULL,
    "reportTemplateId" uuid NOT NULL,
    format jsonb NOT NULL,
    "sendWhenEmpty" boolean NOT NULL
);


ALTER TABLE organization.report_scheduled_job OWNER TO armonsuper;

--
-- Name: report_templates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.report_templates (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    name character varying(511) NOT NULL,
    "userId" uuid NOT NULL,
    type smallint NOT NULL,
    filter jsonb NOT NULL,
    "customReportId" uuid
);


ALTER TABLE organization.report_templates OWNER TO armonsuper;

--
-- Name: roles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.roles (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    permissions character varying(512) NOT NULL,
    "organizationId" uuid,
    "isOrganizationWide" boolean DEFAULT false NOT NULL,
    "typeId" uuid,
    "minPermissions" json
);


ALTER TABLE organization.roles OWNER TO armonsuper;

--
-- Name: softwares; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.softwares (
    id uuid NOT NULL,
    "deviceModel" character varying(255) NOT NULL,
    "environmentModel" character varying(255),
    "environmentOs" character varying(255),
    type integer NOT NULL,
    "fileFullPath" character varying(1023) NOT NULL,
    version character varying(255) NOT NULL,
    "isBeta" boolean DEFAULT true NOT NULL
);


ALTER TABLE organization.softwares OWNER TO armonsuper;

--
-- Name: status_sensor_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.status_sensor_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.status_sensor_logs OWNER TO armonsuper;

--
-- Name: status_sensor_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.status_sensor_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.status_sensor_logs ATTACH PARTITION organization.status_sensor_logs_default DEFAULT;


ALTER TABLE organization.status_sensor_logs_default OWNER TO armonsuper;

--
-- Name: stickerAccessControlPointMappings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."stickerAccessControlPointMappings" (
    "stickerId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "accessDirection" integer NOT NULL,
    CONSTRAINT "stickerAccessControlPointMappings_accessDirection_check" CHECK (("accessDirection" = ANY (ARRAY[0, 1, 2])))
);


ALTER TABLE organization."stickerAccessControlPointMappings" OWNER TO armonsuper;

--
-- Name: system_status_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.system_status_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.system_status_logs OWNER TO armonsuper;

--
-- Name: system_status_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.system_status_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.system_status_logs ATTACH PARTITION organization.system_status_logs_default DEFAULT;


ALTER TABLE organization.system_status_logs_default OWNER TO armonsuper;

--
-- Name: tamper_switch_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.tamper_switch_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.tamper_switch_logs OWNER TO armonsuper;

--
-- Name: tamper_switch_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.tamper_switch_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.tamper_switch_logs ATTACH PARTITION organization.tamper_switch_logs_default DEFAULT;


ALTER TABLE organization.tamper_switch_logs_default OWNER TO armonsuper;

--
-- Name: terminalAdministrators; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalAdministrators" (
    id uuid NOT NULL,
    "terminalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    read boolean DEFAULT false NOT NULL,
    write boolean DEFAULT false NOT NULL,
    notify boolean DEFAULT false NOT NULL
);


ALTER TABLE organization."terminalAdministrators" OWNER TO armonsuper;

--
-- Name: terminalChangeTransactions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalChangeTransactions" (
    "transactionId" uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL
);


ALTER TABLE organization."terminalChangeTransactions" OWNER TO armonsuper;

--
-- Name: terminalChanges; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalChanges" (
    id uuid NOT NULL,
    "transactionId" uuid NOT NULL,
    "actionDateISO" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    "sessionId" uuid,
    data json NOT NULL,
    "deviceId" uuid NOT NULL,
    "sessionExpirationISO" timestamp with time zone
);


ALTER TABLE organization."terminalChanges" OWNER TO armonsuper;

--
-- Name: transaction; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.transaction (
    id bigint NOT NULL,
    "userId" uuid,
    "actionT" timestamp without time zone DEFAULT now() NOT NULL
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.transaction OWNER TO armonsuper;

--
-- Name: transaction_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.transaction_default (
    id bigint NOT NULL,
    "userId" uuid,
    "actionT" timestamp without time zone DEFAULT now() NOT NULL
);
ALTER TABLE ONLY organization.transaction ATTACH PARTITION organization.transaction_default DEFAULT;


ALTER TABLE organization.transaction_default OWNER TO armonsuper;

--
-- Name: unhandled_device_log; Type: TABLE; Schema: organization; Owner: armonapi
--

CREATE TABLE organization.unhandled_device_log (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "logReceiveMethod" smallint NOT NULL,
    "deviceId" uuid NOT NULL,
    type smallint NOT NULL,
    log jsonb NOT NULL,
    note jsonb
);


ALTER TABLE organization.unhandled_device_log OWNER TO armonapi;

--
-- Name: upload_log_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.upload_log_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "uploadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.upload_log_history OWNER TO armonsuper;

--
-- Name: upload_log_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.upload_log_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "uploadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.upload_log_history ATTACH PARTITION organization.upload_log_history_default DEFAULT;


ALTER TABLE organization.upload_log_history_default OWNER TO armonsuper;

--
-- Name: userAccessRights; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userAccessRights" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "remoteAccess" boolean,
    "markedAsFavorite" boolean,
    read boolean DEFAULT false,
    access boolean DEFAULT true,
    config boolean DEFAULT false,
    "grant" boolean DEFAULT false,
    snapshot boolean DEFAULT false
);


ALTER TABLE organization."userAccessRights" OWNER TO armonsuper;

--
-- Name: userGroupAccessRuleSets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroupAccessRuleSets" (
    id uuid NOT NULL,
    "userGroupId" uuid,
    "accessRuleSetId" uuid
);


ALTER TABLE organization."userGroupAccessRuleSets" OWNER TO armonsuper;

--
-- Name: userGroupUserOrganizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroupUserOrganizations" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "userGroupId" uuid
);


ALTER TABLE organization."userGroupUserOrganizations" OWNER TO armonsuper;

--
-- Name: userGroups; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroups" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    "colorCode" character varying(8) NOT NULL,
    "organizationUnitId" uuid
);


ALTER TABLE organization."userGroups" OWNER TO armonsuper;

--
-- Name: userOrganizationCredentials; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationCredentials" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "expiresOn" timestamp with time zone,
    type integer NOT NULL,
    data character varying(4096) NOT NULL,
    "credentialNumber" character varying(31),
    "extensionFields" json,
    "specialData" text,
    "specialDataSecondary" text,
    "customFields" json,
    note character varying(512),
    "groupNumber" integer
);


ALTER TABLE organization."userOrganizationCredentials" OWNER TO armonsuper;

--
-- Name: userOrganizationDeputies; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationDeputies" (
    id uuid NOT NULL,
    "organizationUnitId" uuid,
    "ppermissionId" uuid,
    "userOrganizationId" uuid NOT NULL,
    "deputyUserOrganizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    type integer
);


ALTER TABLE organization."userOrganizationDeputies" OWNER TO armonsuper;

--
-- Name: userOrganizationForbiddances; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationForbiddances" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "regionId" uuid,
    note character varying(255),
    "credentialIds" json
);


ALTER TABLE organization."userOrganizationForbiddances" OWNER TO armonsuper;

--
-- Name: userOrganizationLeaves; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationLeaves" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "organizationLeaveTypeId" uuid NOT NULL,
    "startDate" date NOT NULL,
    "endDate" date NOT NULL,
    "startTime" time without time zone NOT NULL,
    "endTime" time without time zone NOT NULL,
    status integer NOT NULL,
    "statusCaption" character varying(255) NOT NULL,
    "updatedByUserOrganizationId" uuid NOT NULL,
    comments character varying(511)
);


ALTER TABLE organization."userOrganizationLeaves" OWNER TO armonsuper;

--
-- Name: userOrganizationOrganizationUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationOrganizationUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "organizationUnitId" uuid NOT NULL,
    "roleId" uuid DEFAULT '62dc8044-0311-429b-805e-c86b91343c5b'::uuid NOT NULL,
    "extraPermissions" character varying(511)
);


ALTER TABLE organization."userOrganizationOrganizationUnits" OWNER TO armonsuper;

--
-- Name: userOrganizationProfilePhotos; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationProfilePhotos" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    "imageType" character varying(255) DEFAULT 'PNG'::character varying NOT NULL
);


ALTER TABLE organization."userOrganizationProfilePhotos" OWNER TO armonsuper;

--
-- Name: userOrganizationProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127) NOT NULL,
    address character varying(511),
    "phoneNumber" character varying(127),
    email character varying(127),
    "uniqueId" character varying(63) NOT NULL,
    "extensionFields" json,
    thumbnail bytea,
    "profileText" text,
    "employmentStartUtc" timestamp with time zone,
    "previousServiceDuration" integer,
    notifications json,
    "pacsEnabledRemainedAnnualPPermission" integer,
    "birthDateUtc" timestamp with time zone,
    "previousAnnualVacationRight" integer DEFAULT 0,
    "employmentEndUtc" timestamp with time zone,
    "manuallyRemainedAnnualPermission" double precision
);


ALTER TABLE organization."userOrganizationProfiles" OWNER TO armonsuper;

--
-- Name: userOrganizationSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationSettings" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "dashboardCards" character varying(255)
);


ALTER TABLE organization."userOrganizationSettings" OWNER TO armonsuper;

--
-- Name: userOrganizationVisitorProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationVisitorProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127) NOT NULL,
    address character varying(511),
    "phoneNumber" character varying(127),
    email character varying(127),
    "uniqueId" character varying(63) NOT NULL,
    company character varying(255)
);


ALTER TABLE organization."userOrganizationVisitorProfiles" OWNER TO armonsuper;

--
-- Name: userOrganizationVisits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationVisits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationVisitorProfileId" uuid NOT NULL,
    "visitingOrganizationUnitId" uuid,
    "visitingUserOrganizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone,
    reason character varying(255) NOT NULL,
    "visitSupervised" boolean DEFAULT false NOT NULL,
    "visitSupervisedByUserOrganizationId" uuid,
    "extensionFields" json
);


ALTER TABLE organization."userOrganizationVisits" OWNER TO armonsuper;

--
-- Name: userOrganizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizations" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "roleId" uuid DEFAULT '28f5672e-cda7-4cd0-bbb4-82f2ee4b7ec3'::uuid NOT NULL,
    "isDisabled" boolean DEFAULT false NOT NULL,
    "extraPermissions" character varying(511),
    applicationprofile json,
    settings jsonb NOT NULL
);


ALTER TABLE organization."userOrganizations" OWNER TO armonsuper;

--
-- Name: userPPermissionApprovements; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userPPermissionApprovements" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "ppermissionId" uuid NOT NULL,
    "order" integer,
    "approverUserId" uuid,
    "approvementDate" timestamp with time zone,
    note character varying(255),
    status boolean,
    "organizationUnitId" uuid
);


ALTER TABLE organization."userPPermissionApprovements" OWNER TO armonsuper;

--
-- Name: userPPermissions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userPPermissions" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "ppermissionId" uuid NOT NULL,
    note character varying(512),
    approvement character varying(255),
    "signedByUser" boolean DEFAULT false,
    "currentApprovementOrder" integer
);


ALTER TABLE organization."userPPermissions" OWNER TO armonsuper;

--
-- Name: userProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127),
    email character varying(127),
    "phoneNumber" character varying(63),
    thumbnail bytea
);


ALTER TABLE organization."userProfiles" OWNER TO armonsuper;

--
-- Name: userRegionTicketUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userRegionTicketUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    "organizationId" uuid,
    "userId" uuid,
    "remainingUnits" integer NOT NULL,
    "lastUpdateAccessControlPointId" uuid,
    "lastUpdateUserId" uuid,
    "lastUpdateAmount" integer,
    "totalSpentUnits" integer
);


ALTER TABLE organization."userRegionTicketUnits" OWNER TO armonsuper;

--
-- Name: userSelectionSessionActions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userSelectionSessionActions" (
    id uuid NOT NULL,
    "sessionId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "originalMappingId" uuid,
    "generatedMappingId" uuid,
    action integer NOT NULL
);


ALTER TABLE organization."userSelectionSessionActions" OWNER TO armonsuper;

--
-- Name: userSelectionSessions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userSelectionSessions" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "relatedItemId" uuid NOT NULL,
    "expirationUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL
);


ALTER TABLE organization."userSelectionSessions" OWNER TO armonsuper;

--
-- Name: userWorkPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userWorkPlans" (
    id uuid NOT NULL,
    "workPlanId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    "createdAt" timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE organization."userWorkPlans" OWNER TO armonsuper;

--
-- Name: user_action_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_action_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    category integer NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_action_history OWNER TO armonsuper;

--
-- Name: user_action_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_action_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    category integer NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_action_history ATTACH PARTITION organization.user_action_history_default DEFAULT;


ALTER TABLE organization.user_action_history_default OWNER TO armonsuper;

--
-- Name: user_filter; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter (
    id uuid NOT NULL
);


ALTER TABLE organization.user_filter OWNER TO armonsuper;

--
-- Name: user_filter_group; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_group (
    "filterId" uuid NOT NULL,
    "groupId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_group OWNER TO armonsuper;

--
-- Name: user_filter_organization_role; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_organization_role (
    "filterId" uuid NOT NULL,
    "roleId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_organization_role OWNER TO armonsuper;

--
-- Name: user_filter_unit; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_unit (
    "filterId" uuid NOT NULL,
    "unitId" uuid NOT NULL,
    hierarchically boolean
);


ALTER TABLE organization.user_filter_unit OWNER TO armonsuper;

--
-- Name: user_filter_unit_role; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_unit_role (
    "filterId" uuid NOT NULL,
    "unitId" uuid NOT NULL,
    "roleId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_unit_role OWNER TO armonsuper;

--
-- Name: user_filter_user; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_user (
    "filterId" uuid NOT NULL,
    "userId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_user OWNER TO armonsuper;

--
-- Name: user_filter_work_plan; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_work_plan (
    "filterId" uuid NOT NULL,
    "workPlanId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_work_plan OWNER TO armonsuper;

--
-- Name: user_monthly_summary_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_monthly_summary_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_monthly_summary_history OWNER TO armonsuper;

--
-- Name: user_monthly_summary_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_monthly_summary_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_monthly_summary_history ATTACH PARTITION organization.user_monthly_summary_history_default DEFAULT;


ALTER TABLE organization.user_monthly_summary_history_default OWNER TO armonsuper;

--
-- Name: user_ticket_transaction_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_ticket_transaction_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "actionUserId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_ticket_transaction_history OWNER TO armonsuper;

--
-- Name: user_ticket_transaction_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_ticket_transaction_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "actionUserId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_ticket_transaction_history ATTACH PARTITION organization.user_ticket_transaction_history_default DEFAULT;


ALTER TABLE organization.user_ticket_transaction_history_default OWNER TO armonsuper;

--
-- Name: users; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.users (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "accountEnabled" boolean DEFAULT false NOT NULL,
    username character varying(127),
    salt character varying(63),
    "hashedPassword" character varying(255),
    "notificationToken" character varying(1024),
    "notificationTokenType" integer,
    "publicKey" character varying(2048),
    "fromLDAP" boolean DEFAULT false NOT NULL,
    settings jsonb NOT NULL
);


ALTER TABLE organization.users OWNER TO armonsuper;

--
-- Name: vW_CredentialUserProfiles; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE OR REPLACE VIEW organization."vW_CredentialUserProfiles" AS
        SELECT uoc.id,
            uoc.id AS "credentialId",
            uop.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uop.name)::text || ' '::text) || (uop.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
        FROM organization."userOrganizationCredentials" uoc
            JOIN organization."userOrganizations" uo 
                ON uo."userId" = uoc."userId"
                    AND uo."organizationId" = uoc."organizationId"
                    AND uo."deletedAt" IS NULL 
                    AND uoc."deletedAt" IS NULL
            JOIN organization.roles r 
                ON r."organizationId" = uo."organizationId" 
                    AND uo."roleId" = r.id 
                    AND (
                        r."typeId" IS NULL OR
                        r."typeId" <> ALL (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
                    
                    )
            JOIN organization."userOrganizationProfiles" uop 
            ON uoc."userId" = uop."userId" 
                AND uop."deletedAt" IS NULL 
                AND uoc."deletedAt" IS NULL
        UNION ALL
            SELECT uoc.id,
            uoc.id AS "credentialId",
            uovp.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uovp.name)::text || ' '::text) || (uovp.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
            FROM organization."userOrganizationCredentials" uoc
                JOIN organization."userOrganizations" uo 
                    ON uo."userId" = uoc."userId" 
                        AND uo."organizationId" = uoc."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND uoc."deletedAt" IS NULL
                JOIN organization.roles r 
                    ON r."organizationId" = uo."organizationId" 
                        AND uo."roleId" = r.id
                        AND r."typeId" = ANY (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
                JOIN organization."userOrganizationVisitorProfiles" uovp 
                    ON uovp."userOrganizationId" = uo.id 
                    AND uovp."deletedAt" IS NULL 
                    AND uovp."deletedAt" IS NULL;

ALTER TABLE organization."vW_CredentialUserProfiles" OWNER TO armonsuper;

--
-- Name: vW_SearchPPermissions; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_SearchPPermissions" AS
SELECT
    NULL::uuid AS id,
    NULL::uuid AS "organizationId",
    NULL::jsonb AS "dynamicFormData",
    NULL::uuid AS "dynamicFormId",
    NULL::timestamp with time zone AS "startDateTime",
    NULL::timestamp with time zone AS "endDateTime",
    NULL::integer AS status,
    NULL::timestamp with time zone AS "requestDateTime",
    NULL::character varying(512) AS note,
    NULL::uuid AS "requestUserId",
    NULL::json AS "userPPermissions",
    NULL::json AS "userPPermissionApprovements",
    NULL::json AS "userAndDeputies",
    NULL::json AS "ppermissionType",
    NULL::json AS "nextApproverOrganizationUnitIds",
    NULL::json AS "approvedOrganizationUnitIds",
    NULL::json AS "approvementWaitingOrganizationUnitIds",
    NULL::bigint AS "userCount";


ALTER TABLE organization."vW_SearchPPermissions" OWNER TO armonsuper;

--
-- Name: vW_UserOrganizationUnitHierarchys; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_UserOrganizationUnitHierarchys" AS
 SELECT uo."organizationId" AS id,
    uo."organizationId",
    uo."userId",
    cou.id AS "ancestorOrganizationUnitId",
    ou.id AS "descenderOrganizationUnitId"
   FROM (((organization."userOrganizationOrganizationUnits" uoou
     JOIN organization."userOrganizations" uo ON (((uoou."userOrganizationId" = uo.id) AND (uoou."deletedAt" IS NULL) AND (uo."deletedAt" IS NULL))))
     JOIN organization."organizationUnits" ou ON (((ou.id = uoou."organizationUnitId") AND (ou."deletedAt" IS NULL) AND (uoou."deletedAt" IS NULL))))
     JOIN organization."organizationUnits" cou ON ((((ou.id = cou.id) OR ((ou."ancestorIds")::text ~~ (('%'::text || cou.id) || '%'::text))) AND (uoou."deletedAt" IS NULL) AND (ou."deletedAt" IS NULL) AND (cou."deletedAt" IS NULL))));


ALTER TABLE organization."vW_UserOrganizationUnitHierarchys" OWNER TO armonsuper;

--
-- Name: vW_UserHierarchys; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_UserHierarchys" AS
 SELECT mu."organizationId" AS id,
    mu."organizationId",
    uo."userId",
    mu."ancestorOrganizationUnitId",
    mu."descenderOrganizationUnitId",
    mu."userId" AS "userIdUnderAuthority"
   FROM ((organization."userOrganizationOrganizationUnits" uoou
     JOIN organization."userOrganizations" uo ON (((uoou."userOrganizationId" = uo.id) AND (uoou."deletedAt" IS NULL) AND (uo."deletedAt" IS NULL))))
     JOIN organization."vW_UserOrganizationUnitHierarchys" mu ON ((((mu."descenderOrganizationUnitId" = uoou."organizationUnitId") OR (mu."ancestorOrganizationUnitId" = uoou."organizationUnitId")) AND (uoou."deletedAt" IS NULL))));


ALTER TABLE organization."vW_UserHierarchys" OWNER TO armonsuper;

--
-- Name: workPlanPeriods; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlanPeriods" (
    id uuid NOT NULL,
    "workPlanId" uuid,
    "periodStartDateTime" timestamp with time zone,
    details json,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone
);


ALTER TABLE organization."workPlanPeriods" OWNER TO armonsuper;

--
-- Name: workPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlans" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    type integer,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "regionId" uuid,
    "accessCheckType" integer DEFAULT 1,
    "ignoreHolidays" boolean,
    timezone character(6) NOT NULL,
    "allowMobileCheckins" boolean NOT NULL,
    "allowUnreliableCheckins" boolean NOT NULL,
    "mobileCheckinRequiresLocation" boolean NOT NULL,
    "permissionRequiredForExtraWorking" boolean NOT NULL,
    "geoLocations" jsonb,
    "offset" integer DEFAULT 0 NOT NULL
);


ALTER TABLE organization."workPlans" OWNER TO armonsuper;

--
-- Name: vW_WorkPlanPeriodTstzrange; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_WorkPlanPeriodTstzrange" AS
 SELECT "workPlanPeriods".id,
    "workPlanPeriods"."workPlanId",
    "workPlanPeriods".details,
    tstzrange("workPlanPeriods"."periodStartDateTime", lead("workPlanPeriods"."periodStartDateTime") OVER (PARTITION BY "workPlanPeriods"."workPlanId" ORDER BY "workPlanPeriods"."periodStartDateTime")) AS range,
    "workPlans"."organizationId"
   FROM (organization."workPlanPeriods"
     JOIN organization."workPlans" ON (("workPlans".id = "workPlanPeriods"."workPlanId")))
  WHERE (("workPlanPeriods"."deletedAt" IS NULL) AND ("workPlans"."deletedAt" IS NULL));


ALTER TABLE organization."vW_WorkPlanPeriodTstzrange" OWNER TO armonsuper;

--
-- Name: vacations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.vacations (
    id uuid NOT NULL,
    "organizationId" uuid,
    title character varying(255),
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone
);


ALTER TABLE organization.vacations OWNER TO armonsuper;

--
-- Name: visit_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visit_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    "visitedUserId" uuid,
    "visitorRegistrationPointId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("startUtc");


ALTER TABLE organization.visit_history OWNER TO armonsuper;

--
-- Name: visit_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visit_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    "visitedUserId" uuid,
    "visitorRegistrationPointId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.visit_history ATTACH PARTITION organization.visit_history_default DEFAULT;


ALTER TABLE organization.visit_history_default OWNER TO armonsuper;

--
-- Name: visitorDailySummaries; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorDailySummaries" (
    id uuid,
    "organizationId" uuid NOT NULL,
    "visitorRegistrationPointId" uuid NOT NULL,
    reason integer NOT NULL,
    count integer NOT NULL,
    date timestamp with time zone NOT NULL,
    "averageProcessTime" double precision DEFAULT 0
);


ALTER TABLE organization."visitorDailySummaries" OWNER TO armonsuper;

--
-- Name: visitorRegistrationPointAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorRegistrationPointAccessControlPoints" (
    id uuid NOT NULL,
    "accessControlPointId" uuid,
    "visitorRegistrationPointId" uuid
);


ALTER TABLE organization."visitorRegistrationPointAccessControlPoints" OWNER TO armonsuper;

--
-- Name: visitorRegistrationPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorRegistrationPoints" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "tabletDeviceId" uuid
);


ALTER TABLE organization."visitorRegistrationPoints" OWNER TO armonsuper;

--
-- Name: visitor_preregistration_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visitor_preregistration_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.visitor_preregistration_history OWNER TO armonsuper;

--
-- Name: visitor_preregistration_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visitor_preregistration_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.visitor_preregistration_history ATTACH PARTITION organization.visitor_preregistration_history_default DEFAULT;


ALTER TABLE organization.visitor_preregistration_history_default OWNER TO armonsuper;

--
-- Name: vw_user_filter; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization.vw_user_filter AS
 SELECT uf.id,
    json_build_object('id', uf.id, 'groupIds', COALESCE(jsonb_agg(ufg."groupId") FILTER (WHERE (ufg."groupId" IS NOT NULL)), NULL::jsonb), 'roleIds', COALESCE(jsonb_agg(ufor."roleId") FILTER (WHERE (ufor."roleId" IS NOT NULL)), NULL::jsonb), 'userIds', COALESCE(jsonb_agg(ufu."userId") FILTER (WHERE (ufu."userId" IS NOT NULL)), NULL::jsonb), 'workPlanIds', COALESCE(jsonb_agg(ufw."workPlanId") FILTER (WHERE (ufw."workPlanId" IS NOT NULL)), NULL::jsonb), 'units', COALESCE(jsonb_agg(jsonb_build_object('unitId', ufn."unitId", 'hierarchically', ufn.hierarchically, 'roleIds', ufuragg."roleIds")) FILTER (WHERE (ufn."unitId" IS NOT NULL)), NULL::jsonb)) AS filter
   FROM ((((((organization.user_filter uf
     LEFT JOIN organization.user_filter_group ufg ON ((uf.id = ufg."filterId")))
     LEFT JOIN organization.user_filter_organization_role ufor ON ((uf.id = ufor."filterId")))
     LEFT JOIN organization.user_filter_user ufu ON ((uf.id = ufu."filterId")))
     LEFT JOIN organization.user_filter_work_plan ufw ON ((uf.id = ufw."filterId")))
     LEFT JOIN organization.user_filter_unit ufn ON ((uf.id = ufn."filterId")))
     LEFT JOIN ( SELECT ufur."filterId",
            ufur."unitId",
            COALESCE(json_agg(ufur."roleId") FILTER (WHERE (ufur."roleId" IS NOT NULL)), NULL::json) AS "roleIds"
           FROM organization.user_filter_unit_role ufur
          GROUP BY ufur."filterId", ufur."unitId") ufuragg ON (((ufuragg."unitId" = ufn."unitId") AND (ufn."filterId" = ufuragg."filterId"))))
  GROUP BY uf.id;


ALTER TABLE organization.vw_user_filter OWNER TO armonsuper;

--
-- Name: workPlanNotifications; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlanNotifications" (
    id uuid NOT NULL,
    "workPlanId" uuid NOT NULL,
    type smallint NOT NULL,
    "scheduleSettings" jsonb NOT NULL
);


ALTER TABLE organization."workPlanNotifications" OWNER TO armonsuper;

--
-- Name: workingHoursScheduleUnrestricteds; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workingHoursScheduleUnrestricteds" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "workingHoursScheduleId" uuid NOT NULL,
    "expectedDailyWorkInMinutes" integer NOT NULL,
    sunday boolean DEFAULT false NOT NULL,
    monday boolean DEFAULT false NOT NULL,
    tuesday boolean DEFAULT false NOT NULL,
    wednesday boolean DEFAULT false NOT NULL,
    thursday boolean DEFAULT false NOT NULL,
    friday boolean DEFAULT false NOT NULL,
    saturday boolean DEFAULT false NOT NULL
);


ALTER TABLE organization."workingHoursScheduleUnrestricteds" OWNER TO armonsuper;

--
-- Name: zz_notification; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL,
    CONSTRAINT zz_notification_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification OWNER TO armonsuper;

--
-- Name: zz_notification_access; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_access (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_access_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification_access OWNER TO armonsuper;

--
-- Name: zz_notification_access_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_access_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_access_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification_access ATTACH PARTITION organization.zz_notification_access_default DEFAULT;


ALTER TABLE organization.zz_notification_access_default OWNER TO armonsuper;

--
-- Name: zz_notification_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL,
    CONSTRAINT zz_notification_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification ATTACH PARTITION organization.zz_notification_default DEFAULT;


ALTER TABLE organization.zz_notification_default OWNER TO armonsuper;

--
-- Name: zz_notification_sensor; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_sensor (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_sensor_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[]))),
    CONSTRAINT "zz_notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification_sensor OWNER TO armonsuper;

--
-- Name: zz_notification_sensor_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_sensor_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_sensor_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[]))),
    CONSTRAINT "zz_notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification_sensor ATTACH PARTITION organization.zz_notification_sensor_default DEFAULT;


ALTER TABLE organization.zz_notification_sensor_default OWNER TO armonsuper;

--
-- Name: zz_pacs_notification_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_pacs_notification_scheduled_job (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL,
    CONSTRAINT zz_pacs_notification_scheduled_job_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_pacs_notification_scheduled_job OWNER TO armonsuper;

--
-- Name: zz_pacs_notification_scheduled_job_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_pacs_notification_scheduled_job_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL,
    CONSTRAINT zz_pacs_notification_scheduled_job_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_pacs_notification_scheduled_job ATTACH PARTITION organization.zz_pacs_notification_scheduled_job_default DEFAULT;


ALTER TABLE organization.zz_pacs_notification_scheduled_job_default OWNER TO armonsuper;

--
-- Name: zz_user_organization_forbiddances; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_user_organization_forbiddances (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "userId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "regionId" uuid,
    note character varying(255),
    "credentialIds" json
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_user_organization_forbiddances OWNER TO armonsuper;

--
-- Name: zz_user_organization_forbiddances_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_user_organization_forbiddances_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "userId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "regionId" uuid,
    note character varying(255),
    "credentialIds" json
);
ALTER TABLE ONLY organization.zz_user_organization_forbiddances ATTACH PARTITION organization.zz_user_organization_forbiddances_default DEFAULT;


ALTER TABLE organization.zz_user_organization_forbiddances_default OWNER TO armonsuper;

--
-- Name: audit_logs; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.audit_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE public.audit_logs OWNER TO armonsuper;

--
-- Name: audit_logs_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.audit_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY public.audit_logs ATTACH PARTITION public.audit_logs_default DEFAULT;


ALTER TABLE public.audit_logs_default OWNER TO armonsuper;

--
-- Name: emailTemplates; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."emailTemplates" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer NOT NULL,
    template text NOT NULL,
    "languageCode" integer DEFAULT 1 NOT NULL
);


ALTER TABLE public."emailTemplates" OWNER TO armonsuper;

--
-- Name: migration; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.migration (
    name character varying(255) NOT NULL,
    "migratedAt" timestamp without time zone NOT NULL
);


ALTER TABLE public.migration OWNER TO armonsuper;

--
-- Name: notification_instance; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7,8}'::smallint[])))
)
PARTITION BY RANGE ("createdT");


ALTER TABLE public.notification_instance OWNER TO armonsuper;

--
-- Name: notification_instance_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7,8}'::smallint[])))
);
ALTER TABLE ONLY public.notification_instance ATTACH PARTITION public.notification_instance_default DEFAULT;


ALTER TABLE public.notification_instance_default OWNER TO armonsuper;

--
-- Name: oAuthRevokedTokens; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."oAuthRevokedTokens" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    reason character varying(255),
    "tokenId" uuid
);


ALTER TABLE public."oAuthRevokedTokens" OWNER TO armonsuper;

--
-- Name: organizationAuthenticationMethods; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."organizationAuthenticationMethods" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    "authenticationMethod" integer,
    "grantType" integer,
    name character varying(128),
    config json,
    "isDefault" boolean,
    "isHidden" boolean DEFAULT false
);


ALTER TABLE public."organizationAuthenticationMethods" OWNER TO armonsuper;

--
-- Name: organizationList; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."organizationList" (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    code character varying(5),
    logo bytea,
    alias character varying(32)
);


ALTER TABLE public."organizationList" OWNER TO armonsuper;

--
-- Name: scheduledJobHistoryLogs; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."scheduledJobHistoryLogs" (
    id uuid NOT NULL,
    "jobId" uuid,
    name character varying(255),
    "startDate" timestamp with time zone,
    "endDate" timestamp with time zone,
    message character varying(1024),
    success boolean,
    "tryCount" integer,
    "executionDate" timestamp with time zone
);


ALTER TABLE public."scheduledJobHistoryLogs" OWNER TO armonsuper;

--
-- Name: scheduled_job; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.scheduled_job (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    enabled boolean NOT NULL,
    "interval" smallint NOT NULL,
    "firstExecutionDate" timestamp without time zone NOT NULL,
    "nextExecutionDate" timestamp without time zone NOT NULL,
    note character varying(511),
    "notificationId" uuid,
    CONSTRAINT scheduled_job_interval_check CHECK (("interval" = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
);


ALTER TABLE public.scheduled_job OWNER TO armonsuper;

--
-- Name: things; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.things (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    token character varying(255)
);


ALTER TABLE public.things OWNER TO armonsuper;

--
-- Name: userAuthenticationMethods; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userAuthenticationMethods" (
    "userId" uuid NOT NULL,
    "authenticationMethodId" uuid
);


ALTER TABLE public."userAuthenticationMethods" OWNER TO armonsuper;

--
-- Name: userList; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userList" (
    id uuid NOT NULL,
    username character varying(127)
);


ALTER TABLE public."userList" OWNER TO armonsuper;

--
-- Name: userOrganizationMapping; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userOrganizationMapping" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL
);


ALTER TABLE public."userOrganizationMapping" OWNER TO armonsuper;

--
-- Name: zz_notification_instance; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.zz_notification_instance (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT zz_notification_instance_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE public.zz_notification_instance OWNER TO armonsuper;

--
-- Name: zz_notification_instance_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.zz_notification_instance_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT zz_notification_instance_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY public.zz_notification_instance ATTACH PARTITION public.zz_notification_instance_default DEFAULT;


ALTER TABLE public.zz_notification_instance_default OWNER TO armonsuper;

--
-- Name: accessControlPoints accessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT "accessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: accessRuleHistory accessRuleHistory_createdDate_accessRuleId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_createdDate_accessRuleId_userId_key" UNIQUE ("createdDate", "accessRuleId", "userId");


--
-- Name: accessRuleHistory accessRuleHistory_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_pkey" PRIMARY KEY (id);


--
-- Name: accessRuleSets accessRuleSets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT "accessRuleSets_pkey" PRIMARY KEY (id);


--
-- Name: accessRules accessRules_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRules"
    ADD CONSTRAINT "accessRules_pkey" PRIMARY KEY (id);


--
-- Name: access_logs access_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_logs
    ADD CONSTRAINT access_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: access_logs_default access_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_logs_default
    ADD CONSTRAINT access_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: access_point_qr_code access_point_qr_code_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT access_point_qr_code_pkey PRIMARY KEY (id);


--
-- Name: access_point_qr_code access_point_qr_code_qrCodeData_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT "access_point_qr_code_qrCodeData_key" UNIQUE ("qrCodeData");


--
-- Name: access_snapshots access_snapshots_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_snapshots
    ADD CONSTRAINT access_snapshots_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: access_snapshots_default access_snapshots_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_snapshots_default
    ADD CONSTRAINT access_snapshots_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: adapters adapters_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_pkey PRIMARY KEY (id);


--
-- Name: antiPassbackStates antiPassbackStates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_pkey" PRIMARY KEY (id);


--
-- Name: aperioLocks aperioLocks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT "aperioLocks_pkey" PRIMARY KEY ("hubDeviceId", "lockDeviceId");


--
-- Name: attendanceAccessControlPoints attendanceAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "attendanceAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: cameras cameras_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT cameras_pkey PRIMARY KEY (id);


--
-- Name: controlPanelESeriesSettings controlPanelESeriesSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT "controlPanelESeriesSettings_pkey" PRIMARY KEY ("deviceId");


--
-- Name: controlPanelMSeriesAnalogInputs controlPanelMSeriesAnalogInputs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesAnalogInputs"
    ADD CONSTRAINT "controlPanelMSeriesAnalogInputs_pkey" PRIMARY KEY (id);


--
-- Name: controlPanelMSeriesSettings controlPanelMSeriesSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesSettings"
    ADD CONSTRAINT "controlPanelMSeriesSettings_pkey" PRIMARY KEY ("deviceId");


--
-- Name: counter_sensor_logs counter_sensor_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.counter_sensor_logs
    ADD CONSTRAINT counter_sensor_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: counter_sensor_logs_default counter_sensor_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.counter_sensor_logs_default
    ADD CONSTRAINT counter_sensor_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: customReports customReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."customReports"
    ADD CONSTRAINT "customReports_pkey" PRIMARY KEY (id);


--
-- Name: deviceCurrentVersions deviceCurrentVersions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceCurrentVersions"
    ADD CONSTRAINT "deviceCurrentVersions_pkey" PRIMARY KEY (brand, model);


--
-- Name: deviceDryContactInputs deviceDryContactInputs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT "deviceDryContactInputs_pkey" PRIMARY KEY (id);


--
-- Name: deviceIntegrations deviceIntegrations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT "deviceIntegrations_pkey" PRIMARY KEY ("integratedDeviceId", "integratingDeviceId");


--
-- Name: deviceReaders deviceReaders_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT "deviceReaders_pkey" PRIMARY KEY (id);


--
-- Name: deviceRelays deviceRelays_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT "deviceRelays_pkey" PRIMARY KEY (id);


--
-- Name: deviceUpdateStatus deviceUpdateStatus_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceUpdateStatus"
    ADD CONSTRAINT "deviceUpdateStatus_pkey" PRIMARY KEY ("deviceId", version);


--
-- Name: deviceWiegandReaders deviceWiegandReaders_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT "deviceWiegandReaders_pkey" PRIMARY KEY (id);


--
-- Name: devices devices_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_pkey PRIMARY KEY (id);


--
-- Name: dynamicForms dynamicForms_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."dynamicForms"
    ADD CONSTRAINT "dynamicForms_pkey" PRIMARY KEY (id);


--
-- Name: employeeDays employeeDays_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT "employeeDays_pkey" PRIMARY KEY (id);


--
-- Name: employeeDays employeeDays_userId_date_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT "employeeDays_userId_date_organizationId_key" UNIQUE ("userId", date, "organizationId");


--
-- Name: employeeLiveDay employeeLiveDay_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_pkey" PRIMARY KEY (id);


--
-- Name: employeeLiveDay employeeLiveDay_userId_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_userId_organizationId_key" UNIQUE ("userId", "organizationId");


--
-- Name: employeeMonths employeeMonths_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_pkey" PRIMARY KEY (id);


--
-- Name: employeeMonths employeeMonths_userId_organizationId_date_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_userId_organizationId_date_key" UNIQUE ("userId", "organizationId", date);


--
-- Name: floorPlans floorPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."floorPlans"
    ADD CONSTRAINT "floorPlans_pkey" PRIMARY KEY (id);


--
-- Name: hikVisionLicencePlateCameraLanes hikVisionLicencePlateCameraLanes_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT "hikVisionLicencePlateCameraLanes_pkey" PRIMARY KEY (id);


--
-- Name: impinjSpeedWayGateWayAntennas impinjSpeedWayGateWayAntennas_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT "impinjSpeedWayGateWayAntennas_pkey" PRIMARY KEY (id);


--
-- Name: log_history log_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_history
    ADD CONSTRAINT log_history_pkey PRIMARY KEY (id, "insertionUtc");


--
-- Name: log_history_default log_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_history_default
    ADD CONSTRAINT log_history_default_pkey PRIMARY KEY (id, "insertionUtc");


--
-- Name: log_process_history log_process_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_process_history
    ADD CONSTRAINT log_process_history_pkey PRIMARY KEY ("startUtc");


--
-- Name: log_process_history_default log_process_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_process_history_default
    ADD CONSTRAINT log_process_history_default_pkey PRIMARY KEY ("startUtc");


--
-- Name: medium_sms medium_sms_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.medium_sms
    ADD CONSTRAINT medium_sms_pkey PRIMARY KEY (id);


--
-- Name: medium_smtp medium_smtp_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.medium_smtp
    ADD CONSTRAINT medium_smtp_pkey PRIMARY KEY (id);


--
-- Name: monthlySummaryReports monthlySummaryReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."monthlySummaryReports"
    ADD CONSTRAINT "monthlySummaryReports_pkey" PRIMARY KEY (id);


--
-- Name: monthly_summary_history monthly_summary_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.monthly_summary_history
    ADD CONSTRAINT monthly_summary_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: monthly_summary_history_default monthly_summary_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.monthly_summary_history_default
    ADD CONSTRAINT monthly_summary_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: notificationAttachments notificationAttachments_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."notificationAttachments"
    ADD CONSTRAINT "notificationAttachments_pkey" PRIMARY KEY (id);


--
-- Name: notification_access notification_access_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_pkey PRIMARY KEY (id);


--
-- Name: notification_event notification_event_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event
    ADD CONSTRAINT notification_event_pkey PRIMARY KEY (id, "createdT");


--
-- Name: notification_event_default notification_event_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event_default
    ADD CONSTRAINT notification_event_default_pkey PRIMARY KEY (id, "createdT");


--
-- Name: notification_instance notification_instance_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_instance
    ADD CONSTRAINT notification_instance_pkey PRIMARY KEY (id, "createdT");


--
-- Name: notification_instance_default notification_instance_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_instance_default
    ADD CONSTRAINT notification_instance_default_pkey PRIMARY KEY (id, "createdT");


--
-- Name: notification notification_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT notification_pkey PRIMARY KEY (id);


--
-- Name: notification_sensor notification_sensor_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_pkey PRIMARY KEY (id);


--
-- Name: oAuthClients oAuthClients_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthClients"
    ADD CONSTRAINT "oAuthClients_pkey" PRIMARY KEY (id);


--
-- Name: oAuthTokens oAuthTokens_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_pkey" PRIMARY KEY (id);


--
-- Name: organizationActiveVisits organizationActiveVisits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_pkey" PRIMARY KEY (id);


--
-- Name: organizationEmailTemplates organizationEmailTemplates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationEmailTemplates"
    ADD CONSTRAINT "organizationEmailTemplates_pkey" PRIMARY KEY (id);


--
-- Name: organizationFeedbacks organizationFeedbacks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT "organizationFeedbacks_pkey" PRIMARY KEY (id);


--
-- Name: organizationForms organizationForms_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationForms"
    ADD CONSTRAINT "organizationForms_pkey" PRIMARY KEY (id);


--
-- Name: organizationModules organizationModules_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationModules"
    ADD CONSTRAINT "organizationModules_pkey" PRIMARY KEY (id);


--
-- Name: organizationPACSModuleSettings organizationPACSModuleSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationPACSModuleSettings"
    ADD CONSTRAINT "organizationPACSModuleSettings_pkey" PRIMARY KEY (id);


--
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: organizationUnits organizationUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_pkey" PRIMARY KEY (id);


--
-- Name: organizationUserDefinedListValues organizationUserDefinedListValues_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedListValues"
    ADD CONSTRAINT "organizationUserDefinedListValues_pkey" PRIMARY KEY (id);


--
-- Name: organizationUserDefinedLists organizationUserDefinedLists_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedLists"
    ADD CONSTRAINT "organizationUserDefinedLists_pkey" PRIMARY KEY (id);


--
-- Name: organizationUserSync organizationUserSync_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserSync"
    ADD CONSTRAINT "organizationUserSync_pkey" PRIMARY KEY (id);


--
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: organizationVisitorModuleSettings organizationVisitorModuleSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorModuleSettings"
    ADD CONSTRAINT "organizationVisitorModuleSettings_pkey" PRIMARY KEY (id);


--
-- Name: organizationVisitorProfiles organizationVisitorProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorProfiles"
    ADD CONSTRAINT "organizationVisitorProfiles_pkey" PRIMARY KEY (id);


--
-- Name: organizationVisitorStates organizationVisitorStates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT "organizationVisitorStates_pkey" PRIMARY KEY (id);


--
-- Name: organization_feedback_updates organization_feedback_updates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedback_updates
    ADD CONSTRAINT organization_feedback_updates_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: organization_feedback_updates_default organization_feedback_updates_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedback_updates_default
    ADD CONSTRAINT organization_feedback_updates_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: organization_feedbacks organization_feedbacks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedbacks
    ADD CONSTRAINT organization_feedbacks_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: organization_feedbacks_default organization_feedbacks_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedbacks_default
    ADD CONSTRAINT organization_feedbacks_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: organizations organizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organizations
    ADD CONSTRAINT organizations_pkey PRIMARY KEY (id);


--
-- Name: pacs_notification_scheduled_job pacs_notification_scheduled_job_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT pacs_notification_scheduled_job_pkey PRIMARY KEY (id);


--
-- Name: ppermissionAttachments ppermissionAttachments_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionAttachments"
    ADD CONSTRAINT "ppermissionAttachments_pkey" PRIMARY KEY (id);


--
-- Name: ppermissionClaims ppermissionClaims_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_pkey" PRIMARY KEY (id);


--
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_pkey" PRIMARY KEY (id);


--
-- Name: ppermissionTypes ppermissionTypes_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypes"
    ADD CONSTRAINT "ppermissionTypes_pkey" PRIMARY KEY (id);


--
-- Name: ppermission_history ppermission_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermission_history
    ADD CONSTRAINT ppermission_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: ppermission_history_default ppermission_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermission_history_default
    ADD CONSTRAINT ppermission_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: ppermissions ppermissions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT ppermissions_pkey PRIMARY KEY (id);


--
-- Name: preparedReports preparedReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preparedReports"
    ADD CONSTRAINT "preparedReports_pkey" PRIMARY KEY (id);


--
-- Name: preregisterDailySummaries preregisterDailySummaries_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preregisterDailySummaries"
    ADD CONSTRAINT "preregisterDailySummaries_pkey" PRIMARY KEY (id);


--
-- Name: recalculateWorkQueue recalculateWorkQueue_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT "recalculateWorkQueue_pkey" PRIMARY KEY (id);


--
-- Name: recalculateWorkQueue recalculateWorkQueue_userId_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT "recalculateWorkQueue_userId_organizationId_key" UNIQUE ("userId", "organizationId");


--
-- Name: regionAccessControlPoints regionAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: regionTickets regionTickets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT "regionTickets_pkey" PRIMARY KEY (id);


--
-- Name: regions regions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.regions
    ADD CONSTRAINT regions_pkey PRIMARY KEY (id);


--
-- Name: report_scheduled_job report_scheduled_job_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_scheduled_job
    ADD CONSTRAINT report_scheduled_job_pkey PRIMARY KEY (id);


--
-- Name: report_templates report_template_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT report_template_pkey PRIMARY KEY (id);


--
-- Name: roles roles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: softwares softwares_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.softwares
    ADD CONSTRAINT softwares_pkey PRIMARY KEY (id);


--
-- Name: status_sensor_logs status_sensor_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.status_sensor_logs
    ADD CONSTRAINT status_sensor_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: status_sensor_logs_default status_sensor_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.status_sensor_logs_default
    ADD CONSTRAINT status_sensor_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: stickerAccessControlPointMappings stickerAccessControlPointMappings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."stickerAccessControlPointMappings"
    ADD CONSTRAINT "stickerAccessControlPointMappings_pkey" PRIMARY KEY ("stickerId");


--
-- Name: system_status_logs system_status_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.system_status_logs
    ADD CONSTRAINT system_status_logs_pkey PRIMARY KEY (id, type, "actionUtc");


--
-- Name: system_status_logs_default system_status_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.system_status_logs_default
    ADD CONSTRAINT system_status_logs_default_pkey PRIMARY KEY (id, type, "actionUtc");


--
-- Name: tamper_switch_logs tamper_switch_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.tamper_switch_logs
    ADD CONSTRAINT tamper_switch_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: tamper_switch_logs_default tamper_switch_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.tamper_switch_logs_default
    ADD CONSTRAINT tamper_switch_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: terminalAdministrators terminalAdministrators_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_pkey" PRIMARY KEY (id);


--
-- Name: terminalAdministrators terminalAdministrators_terminalId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_terminalId_userId_key" UNIQUE ("terminalId", "userId");


--
-- Name: terminalChangeTransactions terminalChangeTransactions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChangeTransactions"
    ADD CONSTRAINT "terminalChangeTransactions_pkey" PRIMARY KEY ("transactionId", "deviceId");


--
-- Name: terminalChanges terminalChanges_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChanges"
    ADD CONSTRAINT "terminalChanges_pkey" PRIMARY KEY (id);


--
-- Name: unhandled_device_log unhandled_device_log_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonapi
--

ALTER TABLE ONLY organization.unhandled_device_log
    ADD CONSTRAINT unhandled_device_log_pkey PRIMARY KEY (id);


--
-- Name: upload_log_history upload_log_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.upload_log_history
    ADD CONSTRAINT upload_log_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: upload_log_history_default upload_log_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.upload_log_history_default
    ADD CONSTRAINT upload_log_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: userAccessRights userAccessRights_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_pkey" PRIMARY KEY (id);


--
-- Name: userAccessRights userAccessRights_userId_accessControlPointId_deletedAt_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_userId_accessControlPointId_deletedAt_key" UNIQUE ("userId", "accessControlPointId", "deletedAt");


--
-- Name: userGroupAccessRuleSets userGroupAccessRuleSets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT "userGroupAccessRuleSets_pkey" PRIMARY KEY (id);


--
-- Name: userGroupUserOrganizations userGroupUserOrganizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_pkey" PRIMARY KEY (id);


--
-- Name: userGroups userGroups_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationCredentials userOrganizationCredentials_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationDeputies userOrganizationDeputies_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationForbiddances userOrganizationForbiddances_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT "userOrganizationForbiddances_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationLeaves userOrganizationLeaves_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationProfiles userOrganizationProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationSettings userOrganizationSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationSettings"
    ADD CONSTRAINT "userOrganizationSettings_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationVisits userOrganizationVisits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizations userOrganizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_pkey" PRIMARY KEY (id);


--
-- Name: userPPermissionApprovements userPPermissionApprovements_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_pkey" PRIMARY KEY (id);


--
-- Name: userPPermissions userPPermissions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissions"
    ADD CONSTRAINT "userPPermissions_pkey" PRIMARY KEY (id);


--
-- Name: userProfiles userProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userProfiles"
    ADD CONSTRAINT "userProfiles_pkey" PRIMARY KEY (id);


--
-- Name: userRegionTicketUnits userRegionTicketUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT "userRegionTicketUnits_pkey" PRIMARY KEY (id);


--
-- Name: userSelectionSessionActions userSelectionSessionActions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_pkey" PRIMARY KEY (id);


--
-- Name: userSelectionSessionActions userSelectionSessionActions_sessionId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_sessionId_userId_key" UNIQUE ("sessionId", "userId");


--
-- Name: userSelectionSessions userSelectionSessions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_pkey" PRIMARY KEY (id);


--
-- Name: userWorkPlans userWorkPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_pkey" PRIMARY KEY (id);


--
-- Name: user_action_history user_action_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_action_history
    ADD CONSTRAINT user_action_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: user_action_history_default user_action_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_action_history_default
    ADD CONSTRAINT user_action_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: user_filter_group user_filter_group_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_pkey PRIMARY KEY ("filterId", "groupId");


--
-- Name: user_filter_organization_role user_filter_organization_role_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_pkey PRIMARY KEY ("filterId", "roleId");


--
-- Name: user_filter user_filter_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter
    ADD CONSTRAINT user_filter_pkey PRIMARY KEY (id);


--
-- Name: user_filter_unit user_filter_unit_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_pkey PRIMARY KEY ("filterId", "unitId");


--
-- Name: user_filter_unit_role user_filter_unit_role_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_pkey PRIMARY KEY ("filterId", "unitId", "roleId");


--
-- Name: user_filter_user user_filter_user_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_pkey PRIMARY KEY ("filterId", "userId");


--
-- Name: user_filter_work_plan user_filter_work_plan_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_pkey PRIMARY KEY ("filterId", "workPlanId");


--
-- Name: user_monthly_summary_history user_monthly_summary_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_monthly_summary_history
    ADD CONSTRAINT user_monthly_summary_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: user_monthly_summary_history_default user_monthly_summary_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_monthly_summary_history_default
    ADD CONSTRAINT user_monthly_summary_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: user_ticket_transaction_history user_ticket_transaction_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_ticket_transaction_history
    ADD CONSTRAINT user_ticket_transaction_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: user_ticket_transaction_history_default user_ticket_transaction_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_ticket_transaction_history_default
    ADD CONSTRAINT user_ticket_transaction_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: users users_username_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT users_username_key UNIQUE (username);


--
-- Name: vacations vacations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.vacations
    ADD CONSTRAINT vacations_pkey PRIMARY KEY (id);


--
-- Name: visit_history visit_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visit_history
    ADD CONSTRAINT visit_history_pkey PRIMARY KEY (id, "startUtc");


--
-- Name: visit_history_default visit_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visit_history_default
    ADD CONSTRAINT visit_history_default_pkey PRIMARY KEY (id, "startUtc");


--
-- Name: visitorRegistrationPointAccessControlPoints visitorRegistrationPointAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT "visitorRegistrationPointAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- Name: visitorRegistrationPoints visitorRegistrationPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT "visitorRegistrationPoints_pkey" PRIMARY KEY (id);


--
-- Name: visitor_preregistration_history visitor_preregistration_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visitor_preregistration_history
    ADD CONSTRAINT visitor_preregistration_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: visitor_preregistration_history_default visitor_preregistration_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visitor_preregistration_history_default
    ADD CONSTRAINT visitor_preregistration_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: workPlanNotifications workPlanNotifications_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanNotifications"
    ADD CONSTRAINT "workPlanNotifications_pkey" PRIMARY KEY (id);


--
-- Name: workPlanPeriods workPlanPeriods_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanPeriods"
    ADD CONSTRAINT "workPlanPeriods_pkey" PRIMARY KEY (id);


--
-- Name: workPlans workPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlans"
    ADD CONSTRAINT "workPlans_pkey" PRIMARY KEY (id);


--
-- Name: workingHoursScheduleUnrestricteds workingHoursScheduleUnrestricteds_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workingHoursScheduleUnrestricteds"
    ADD CONSTRAINT "workingHoursScheduleUnrestricteds_pkey" PRIMARY KEY (id);


--
-- Name: audit_logs audit_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.audit_logs
    ADD CONSTRAINT audit_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: audit_logs_default audit_logs_default_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.audit_logs_default
    ADD CONSTRAINT audit_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- Name: emailTemplates emailTemplates_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."emailTemplates"
    ADD CONSTRAINT "emailTemplates_pkey" PRIMARY KEY (id);


--
-- Name: migration migration_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.migration
    ADD CONSTRAINT migration_pkey PRIMARY KEY (name);


--
-- Name: notification_instance notification_instance_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance
    ADD CONSTRAINT notification_instance_pkey PRIMARY KEY (id, "createdT");


--
-- Name: notification_instance_default notification_instance_default_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance_default
    ADD CONSTRAINT notification_instance_default_pkey PRIMARY KEY (id, "createdT");


--
-- Name: oAuthRevokedTokens oAuthRevokedTokens_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."oAuthRevokedTokens"
    ADD CONSTRAINT "oAuthRevokedTokens_pkey" PRIMARY KEY (id);


--
-- Name: organizationAuthenticationMethods organizationAuthenticationMethods_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationAuthenticationMethods"
    ADD CONSTRAINT "organizationAuthenticationMethods_pkey" PRIMARY KEY (id);


--
-- Name: organizationList organizationList_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationList"
    ADD CONSTRAINT "organizationList_pkey" PRIMARY KEY (id);


--
-- Name: scheduledJobHistoryLogs scheduledJobHistoryLogs_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."scheduledJobHistoryLogs"
    ADD CONSTRAINT "scheduledJobHistoryLogs_pkey" PRIMARY KEY (id);


--
-- Name: scheduled_job scheduled_job_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_pkey PRIMARY KEY (id);


--
-- Name: things things_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.things
    ADD CONSTRAINT things_pkey PRIMARY KEY (id);


--
-- Name: userOrganizationMapping userIdOrganizationId; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userIdOrganizationId" UNIQUE ("userId", "organizationId");


--
-- Name: userList userList_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userList"
    ADD CONSTRAINT "userList_pkey" PRIMARY KEY (id);


--
-- Name: userOrganizationMapping userOrganizationId_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationId_pkey" PRIMARY KEY (id);


--
-- Name: access_logs_credentialData_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "access_logs_credentialData_idx" ON ONLY organization.access_logs USING gin ("credentialData");


--
-- Name: access_logs_default_credentialData_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "access_logs_default_credentialData_idx" ON organization.access_logs_default USING gin ("credentialData");


--
-- Name: access_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX access_logs_log_idx ON ONLY organization.access_logs USING gin (log);


--
-- Name: access_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX access_logs_default_log_idx ON organization.access_logs_default USING gin (log);


--
-- Name: bx_organization_transaction_id; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_organization_transaction_id ON ONLY organization.transaction USING btree (id DESC NULLS LAST);


--
-- Name: bx_zz_notification; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification ON ONLY organization.zz_notification USING btree (id DESC NULLS LAST);


--
-- Name: bx_zz_notification_access; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_access ON ONLY organization.zz_notification_access USING btree (id DESC NULLS LAST);


--
-- Name: bx_zz_notification_sensor; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_sensor ON ONLY organization.zz_notification_sensor USING btree (id DESC NULLS LAST);


--
-- Name: bx_zz_pacs_notification_scheduled_job; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_pacs_notification_scheduled_job ON ONLY organization.zz_pacs_notification_scheduled_job USING btree (id DESC NULLS LAST);


--
-- Name: bx_zz_user_organization_forbiddances; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_user_organization_forbiddances ON ONLY organization.zz_user_organization_forbiddances USING btree (id DESC NULLS LAST);


--
-- Name: counter_sensor_logs_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_accessControlPointId_idx" ON ONLY organization.counter_sensor_logs USING btree ("accessControlPointId");


--
-- Name: counter_sensor_logs_default_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_default_accessControlPointId_idx" ON organization.counter_sensor_logs_default USING btree ("accessControlPointId");


--
-- Name: counter_sensor_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX counter_sensor_logs_log_idx ON ONLY organization.counter_sensor_logs USING gin (log);


--
-- Name: counter_sensor_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX counter_sensor_logs_default_log_idx ON organization.counter_sensor_logs_default USING gin (log);


--
-- Name: counter_sensor_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_organizationId_idx" ON ONLY organization.counter_sensor_logs USING btree ("organizationId");


--
-- Name: counter_sensor_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_default_organizationId_idx" ON organization.counter_sensor_logs_default USING btree ("organizationId");


--
-- Name: employee_day_segments_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_userId_idx" ON ONLY organization.employee_day_segments USING btree ("userId");


--
-- Name: employee_day_segments_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_default_userId_idx" ON organization.employee_day_segments_default USING btree ("userId");


--
-- Name: employee_day_segments_workPlanId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_workPlanId_idx" ON ONLY organization.employee_day_segments USING btree ("workPlanId");


--
-- Name: employee_day_segments_default_workPlanId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_default_workPlanId_idx" ON organization.employee_day_segments_default USING btree ("workPlanId");


--
-- Name: log_history_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX log_history_data_idx ON ONLY organization.log_history USING gin (data);


--
-- Name: log_history_default_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX log_history_default_data_idx ON organization.log_history_default USING gin (data);


--
-- Name: monthly_summary_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX monthly_summary_history_log_idx ON ONLY organization.monthly_summary_history USING gin (log);


--
-- Name: monthly_summary_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX monthly_summary_history_default_log_idx ON organization.monthly_summary_history_default USING gin (log);


--
-- Name: monthly_summary_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_organizationId_idx" ON ONLY organization.monthly_summary_history USING btree ("organizationId");


--
-- Name: monthly_summary_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_default_organizationId_idx" ON organization.monthly_summary_history_default USING btree ("organizationId");


--
-- Name: monthly_summary_history_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_originalId_idx" ON ONLY organization.monthly_summary_history USING btree ("originalId");


--
-- Name: monthly_summary_history_default_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_default_originalId_idx" ON organization.monthly_summary_history_default USING btree ("originalId");


--
-- Name: organization_feedback_updates_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedback_updates_log_idx ON ONLY organization.organization_feedback_updates USING gin (log);


--
-- Name: organization_feedback_updates_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedback_updates_default_log_idx ON organization.organization_feedback_updates_default USING gin (log);


--
-- Name: organization_feedback_updates_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_organizationId_idx" ON ONLY organization.organization_feedback_updates USING btree ("organizationId");


--
-- Name: organization_feedback_updates_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_default_organizationId_idx" ON organization.organization_feedback_updates_default USING btree ("organizationId");


--
-- Name: organization_feedback_updates_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_threadId_idx" ON ONLY organization.organization_feedback_updates USING btree ("threadId");


--
-- Name: organization_feedback_updates_default_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_default_threadId_idx" ON organization.organization_feedback_updates_default USING btree ("threadId");


--
-- Name: organization_feedbacks_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedbacks_log_idx ON ONLY organization.organization_feedbacks USING gin (log);


--
-- Name: organization_feedbacks_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedbacks_default_log_idx ON organization.organization_feedbacks_default USING gin (log);


--
-- Name: organization_feedbacks_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_organizationId_idx" ON ONLY organization.organization_feedbacks USING btree ("organizationId");


--
-- Name: organization_feedbacks_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_default_organizationId_idx" ON organization.organization_feedbacks_default USING btree ("organizationId");


--
-- Name: organization_feedbacks_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_threadId_idx" ON ONLY organization.organization_feedbacks USING btree ("threadId");


--
-- Name: organization_feedbacks_default_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_default_threadId_idx" ON organization.organization_feedbacks_default USING btree ("threadId");


--
-- Name: ppermissionTypes_id_name_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermissionTypes_id_name_type_idx" ON organization."ppermissionTypes" USING btree (id, name, type);


--
-- Name: ppermission_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX ppermission_history_log_idx ON ONLY organization.ppermission_history USING gin (log);


--
-- Name: ppermission_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX ppermission_history_default_log_idx ON organization.ppermission_history_default USING gin (log);


--
-- Name: ppermission_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermission_history_organizationId_idx" ON ONLY organization.ppermission_history USING btree ("organizationId");


--
-- Name: ppermission_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermission_history_default_organizationId_idx" ON organization.ppermission_history_default USING btree ("organizationId");


--
-- Name: ppermissions_startDateTime_endDateTime_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermissions_startDateTime_endDateTime_idx" ON organization.ppermissions USING btree ("startDateTime", "endDateTime");


--
-- Name: status_sensor_logs_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_accessControlPointId_idx" ON ONLY organization.status_sensor_logs USING btree ("accessControlPointId");


--
-- Name: status_sensor_logs_default_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_default_accessControlPointId_idx" ON organization.status_sensor_logs_default USING btree ("accessControlPointId");


--
-- Name: status_sensor_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX status_sensor_logs_log_idx ON ONLY organization.status_sensor_logs USING gin (log);


--
-- Name: status_sensor_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX status_sensor_logs_default_log_idx ON organization.status_sensor_logs_default USING gin (log);


--
-- Name: status_sensor_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_organizationId_idx" ON ONLY organization.status_sensor_logs USING btree ("organizationId");


--
-- Name: status_sensor_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_default_organizationId_idx" ON organization.status_sensor_logs_default USING btree ("organizationId");


--
-- Name: system_status_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX system_status_logs_log_idx ON ONLY organization.system_status_logs USING gin (log);


--
-- Name: system_status_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX system_status_logs_default_log_idx ON organization.system_status_logs_default USING gin (log);


--
-- Name: tamper_switch_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX tamper_switch_logs_log_idx ON ONLY organization.tamper_switch_logs USING gin (log);


--
-- Name: tamper_switch_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX tamper_switch_logs_default_log_idx ON organization.tamper_switch_logs_default USING gin (log);


--
-- Name: tamper_switch_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "tamper_switch_logs_organizationId_idx" ON ONLY organization.tamper_switch_logs USING btree ("organizationId");


--
-- Name: tamper_switch_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "tamper_switch_logs_default_organizationId_idx" ON organization.tamper_switch_logs_default USING btree ("organizationId");


--
-- Name: transaction_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX transaction_default_id_idx ON organization.transaction_default USING btree (id DESC NULLS LAST);


--
-- Name: upload_log_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX upload_log_history_log_idx ON ONLY organization.upload_log_history USING gin (log);


--
-- Name: upload_log_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX upload_log_history_default_log_idx ON organization.upload_log_history_default USING gin (log);


--
-- Name: upload_log_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_organizationId_idx" ON ONLY organization.upload_log_history USING btree ("organizationId");


--
-- Name: upload_log_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_default_organizationId_idx" ON organization.upload_log_history_default USING btree ("organizationId");


--
-- Name: upload_log_history_uploadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_uploadId_idx" ON ONLY organization.upload_log_history USING btree ("uploadId");


--
-- Name: upload_log_history_default_uploadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_default_uploadId_idx" ON organization.upload_log_history_default USING btree ("uploadId");


--
-- Name: userOrganizationCredentials_userId_type_organizationId_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizationCredentials_userId_type_organizationId_data_idx" ON organization."userOrganizationCredentials" USING btree ("userId", type, "organizationId", data) WHERE ("deletedAt" IS NULL);


--
-- Name: userOrganizationProfiles_profileText_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "userOrganizationProfiles_profileText_idx" ON organization."userOrganizationProfiles" USING gin ("profileText" public.gin_trgm_ops);


--
-- Name: userOrganizationProfiles_userId_userOrganizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizationProfiles_userId_userOrganizationId_idx" ON organization."userOrganizationProfiles" USING btree ("userId", "userOrganizationId");


--
-- Name: userOrganizations_userId_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizations_userId_organizationId_idx" ON organization."userOrganizations" USING btree ("userId", "organizationId");


--
-- Name: userPPermissions_ppermissionId_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "userPPermissions_ppermissionId_userId_idx" ON organization."userPPermissions" USING btree ("ppermissionId", "userId");


--
-- Name: userProfiles_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userProfiles_userId_idx" ON organization."userProfiles" USING btree ("userId");


--
-- Name: user_action_history_category_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_category_type_idx ON ONLY organization.user_action_history USING btree (category, type);


--
-- Name: user_action_history_default_category_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_default_category_type_idx ON organization.user_action_history_default USING btree (category, type);


--
-- Name: user_action_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_log_idx ON ONLY organization.user_action_history USING gin (log);


--
-- Name: user_action_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_default_log_idx ON organization.user_action_history_default USING gin (log);


--
-- Name: user_action_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_organizationId_idx" ON ONLY organization.user_action_history USING btree ("organizationId");


--
-- Name: user_action_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_default_organizationId_idx" ON organization.user_action_history_default USING btree ("organizationId");


--
-- Name: user_action_history_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_userId_idx" ON ONLY organization.user_action_history USING btree ("userId");


--
-- Name: user_action_history_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_default_userId_idx" ON organization.user_action_history_default USING btree ("userId");


--
-- Name: user_monthly_summary_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_monthly_summary_history_log_idx ON ONLY organization.user_monthly_summary_history USING gin (log);


--
-- Name: user_monthly_summary_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_monthly_summary_history_default_log_idx ON organization.user_monthly_summary_history_default USING gin (log);


--
-- Name: user_monthly_summary_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_organizationId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("organizationId");


--
-- Name: user_monthly_summary_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_organizationId_idx" ON organization.user_monthly_summary_history_default USING btree ("organizationId");


--
-- Name: user_monthly_summary_history_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_originalId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("originalId");


--
-- Name: user_monthly_summary_history_default_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_originalId_idx" ON organization.user_monthly_summary_history_default USING btree ("originalId");


--
-- Name: user_monthly_summary_history_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_userId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("userId");


--
-- Name: user_monthly_summary_history_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_userId_idx" ON organization.user_monthly_summary_history_default USING btree ("userId");


--
-- Name: user_ticket_transaction_history_actionUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_actionUserId_idx" ON ONLY organization.user_ticket_transaction_history USING btree ("actionUserId");


--
-- Name: user_ticket_transaction_history_default_actionUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_default_actionUserId_idx" ON organization.user_ticket_transaction_history_default USING btree ("actionUserId");


--
-- Name: user_ticket_transaction_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_ticket_transaction_history_log_idx ON ONLY organization.user_ticket_transaction_history USING gin (log);


--
-- Name: user_ticket_transaction_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_ticket_transaction_history_default_log_idx ON organization.user_ticket_transaction_history_default USING gin (log);


--
-- Name: user_ticket_transaction_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_organizationId_idx" ON ONLY organization.user_ticket_transaction_history USING btree ("organizationId");


--
-- Name: user_ticket_transaction_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_default_organizationId_idx" ON organization.user_ticket_transaction_history_default USING btree ("organizationId");


--
-- Name: users_unique_lower_username_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX users_unique_lower_username_idx ON organization.users USING btree (lower((username)::text));


--
-- Name: visit_history_endUtc_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_endUtc_idx" ON ONLY organization.visit_history USING btree ("endUtc");


--
-- Name: visit_history_default_endUtc_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_endUtc_idx" ON organization.visit_history_default USING btree ("endUtc");


--
-- Name: visit_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visit_history_log_idx ON ONLY organization.visit_history USING gin (log);


--
-- Name: visit_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visit_history_default_log_idx ON organization.visit_history_default USING gin (log);


--
-- Name: visit_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_organizationId_idx" ON ONLY organization.visit_history USING btree ("organizationId");


--
-- Name: visit_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_organizationId_idx" ON organization.visit_history_default USING btree ("organizationId");


--
-- Name: visit_history_visitedUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitedUserId_idx" ON ONLY organization.visit_history USING btree ("visitedUserId");


--
-- Name: visit_history_default_visitedUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitedUserId_idx" ON organization.visit_history_default USING btree ("visitedUserId");


--
-- Name: visit_history_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitorProfileId_idx" ON ONLY organization.visit_history USING btree ("visitorProfileId");


--
-- Name: visit_history_default_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitorProfileId_idx" ON organization.visit_history_default USING btree ("visitorProfileId");


--
-- Name: visit_history_visitorRegistrationPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitorRegistrationPointId_idx" ON ONLY organization.visit_history USING btree ("visitorRegistrationPointId");


--
-- Name: visit_history_default_visitorRegistrationPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitorRegistrationPointId_idx" ON organization.visit_history_default USING btree ("visitorRegistrationPointId");


--
-- Name: visitorDailySummaries_visitorRegistrationPointId_reason_dat_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitorDailySummaries_visitorRegistrationPointId_reason_dat_idx" ON organization."visitorDailySummaries" USING btree ("visitorRegistrationPointId", reason, date);


--
-- Name: visitor_preregistration_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visitor_preregistration_history_log_idx ON ONLY organization.visitor_preregistration_history USING gin (log);


--
-- Name: visitor_preregistration_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visitor_preregistration_history_default_log_idx ON organization.visitor_preregistration_history_default USING gin (log);


--
-- Name: visitor_preregistration_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_organizationId_idx" ON ONLY organization.visitor_preregistration_history USING btree ("organizationId");


--
-- Name: visitor_preregistration_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_default_organizationId_idx" ON organization.visitor_preregistration_history_default USING btree ("organizationId");


--
-- Name: visitor_preregistration_history_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_visitorProfileId_idx" ON ONLY organization.visitor_preregistration_history USING btree ("visitorProfileId");


--
-- Name: visitor_preregistration_history_default_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_default_visitorProfileId_idx" ON organization.visitor_preregistration_history_default USING btree ("visitorProfileId");


--
-- Name: zz_notification_access_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_access_default_id_idx ON organization.zz_notification_access_default USING btree (id DESC NULLS LAST);


--
-- Name: zz_notification_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_default_id_idx ON organization.zz_notification_default USING btree (id DESC NULLS LAST);


--
-- Name: zz_notification_sensor_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_sensor_default_id_idx ON organization.zz_notification_sensor_default USING btree (id DESC NULLS LAST);


--
-- Name: zz_pacs_notification_scheduled_job_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_pacs_notification_scheduled_job_default_id_idx ON organization.zz_pacs_notification_scheduled_job_default USING btree (id DESC NULLS LAST);


--
-- Name: zz_user_organization_forbiddances_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_user_organization_forbiddances_default_id_idx ON organization.zz_user_organization_forbiddances_default USING btree (id DESC NULLS LAST);


--
-- Name: idx_gin_log_audit_logs; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX idx_gin_log_audit_logs ON ONLY public.audit_logs USING gin (log);


--
-- Name: audit_logs_default_log_idx; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX audit_logs_default_log_idx ON public.audit_logs_default USING gin (log);


--
-- Name: bx_zz_notification_instance; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_instance ON ONLY public.zz_notification_instance USING btree (id DESC NULLS LAST);


--
-- Name: zz_notification_instance_default_id_idx; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX zz_notification_instance_default_id_idx ON public.zz_notification_instance_default USING btree (id DESC NULLS LAST);


--
-- Name: access_logs_default_credentialData_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."access_logs_credentialData_idx" ATTACH PARTITION organization."access_logs_default_credentialData_idx";


--
-- Name: access_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.access_logs_log_idx ATTACH PARTITION organization.access_logs_default_log_idx;


--
-- Name: access_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.access_logs_pkey ATTACH PARTITION organization.access_logs_default_pkey;


--
-- Name: access_snapshots_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.access_snapshots_pkey ATTACH PARTITION organization.access_snapshots_default_pkey;


--
-- Name: counter_sensor_logs_default_accessControlPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."counter_sensor_logs_accessControlPointId_idx" ATTACH PARTITION organization."counter_sensor_logs_default_accessControlPointId_idx";


--
-- Name: counter_sensor_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.counter_sensor_logs_log_idx ATTACH PARTITION organization.counter_sensor_logs_default_log_idx;


--
-- Name: counter_sensor_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."counter_sensor_logs_organizationId_idx" ATTACH PARTITION organization."counter_sensor_logs_default_organizationId_idx";


--
-- Name: counter_sensor_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.counter_sensor_logs_pkey ATTACH PARTITION organization.counter_sensor_logs_default_pkey;


--
-- Name: employee_day_segments_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."employee_day_segments_userId_idx" ATTACH PARTITION organization."employee_day_segments_default_userId_idx";


--
-- Name: employee_day_segments_default_workPlanId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."employee_day_segments_workPlanId_idx" ATTACH PARTITION organization."employee_day_segments_default_workPlanId_idx";


--
-- Name: log_history_default_data_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.log_history_data_idx ATTACH PARTITION organization.log_history_default_data_idx;


--
-- Name: log_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.log_history_pkey ATTACH PARTITION organization.log_history_default_pkey;


--
-- Name: log_process_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.log_process_history_pkey ATTACH PARTITION organization.log_process_history_default_pkey;


--
-- Name: monthly_summary_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.monthly_summary_history_log_idx ATTACH PARTITION organization.monthly_summary_history_default_log_idx;


--
-- Name: monthly_summary_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."monthly_summary_history_organizationId_idx" ATTACH PARTITION organization."monthly_summary_history_default_organizationId_idx";


--
-- Name: monthly_summary_history_default_originalId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."monthly_summary_history_originalId_idx" ATTACH PARTITION organization."monthly_summary_history_default_originalId_idx";


--
-- Name: monthly_summary_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.monthly_summary_history_pkey ATTACH PARTITION organization.monthly_summary_history_default_pkey;


--
-- Name: notification_event_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.notification_event_pkey ATTACH PARTITION organization.notification_event_default_pkey;


--
-- Name: notification_instance_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.notification_instance_pkey ATTACH PARTITION organization.notification_instance_default_pkey;


--
-- Name: organization_feedback_updates_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.organization_feedback_updates_log_idx ATTACH PARTITION organization.organization_feedback_updates_default_log_idx;


--
-- Name: organization_feedback_updates_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."organization_feedback_updates_organizationId_idx" ATTACH PARTITION organization."organization_feedback_updates_default_organizationId_idx";


--
-- Name: organization_feedback_updates_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.organization_feedback_updates_pkey ATTACH PARTITION organization.organization_feedback_updates_default_pkey;


--
-- Name: organization_feedback_updates_default_threadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."organization_feedback_updates_threadId_idx" ATTACH PARTITION organization."organization_feedback_updates_default_threadId_idx";


--
-- Name: organization_feedbacks_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.organization_feedbacks_log_idx ATTACH PARTITION organization.organization_feedbacks_default_log_idx;


--
-- Name: organization_feedbacks_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."organization_feedbacks_organizationId_idx" ATTACH PARTITION organization."organization_feedbacks_default_organizationId_idx";


--
-- Name: organization_feedbacks_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.organization_feedbacks_pkey ATTACH PARTITION organization.organization_feedbacks_default_pkey;


--
-- Name: organization_feedbacks_default_threadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."organization_feedbacks_threadId_idx" ATTACH PARTITION organization."organization_feedbacks_default_threadId_idx";


--
-- Name: ppermission_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.ppermission_history_log_idx ATTACH PARTITION organization.ppermission_history_default_log_idx;


--
-- Name: ppermission_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."ppermission_history_organizationId_idx" ATTACH PARTITION organization."ppermission_history_default_organizationId_idx";


--
-- Name: ppermission_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.ppermission_history_pkey ATTACH PARTITION organization.ppermission_history_default_pkey;


--
-- Name: status_sensor_logs_default_accessControlPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."status_sensor_logs_accessControlPointId_idx" ATTACH PARTITION organization."status_sensor_logs_default_accessControlPointId_idx";


--
-- Name: status_sensor_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.status_sensor_logs_log_idx ATTACH PARTITION organization.status_sensor_logs_default_log_idx;


--
-- Name: status_sensor_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."status_sensor_logs_organizationId_idx" ATTACH PARTITION organization."status_sensor_logs_default_organizationId_idx";


--
-- Name: status_sensor_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.status_sensor_logs_pkey ATTACH PARTITION organization.status_sensor_logs_default_pkey;


--
-- Name: system_status_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.system_status_logs_log_idx ATTACH PARTITION organization.system_status_logs_default_log_idx;


--
-- Name: system_status_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.system_status_logs_pkey ATTACH PARTITION organization.system_status_logs_default_pkey;


--
-- Name: tamper_switch_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.tamper_switch_logs_log_idx ATTACH PARTITION organization.tamper_switch_logs_default_log_idx;


--
-- Name: tamper_switch_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."tamper_switch_logs_organizationId_idx" ATTACH PARTITION organization."tamper_switch_logs_default_organizationId_idx";


--
-- Name: tamper_switch_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.tamper_switch_logs_pkey ATTACH PARTITION organization.tamper_switch_logs_default_pkey;


--
-- Name: transaction_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_organization_transaction_id ATTACH PARTITION organization.transaction_default_id_idx;


--
-- Name: upload_log_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.upload_log_history_log_idx ATTACH PARTITION organization.upload_log_history_default_log_idx;


--
-- Name: upload_log_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."upload_log_history_organizationId_idx" ATTACH PARTITION organization."upload_log_history_default_organizationId_idx";


--
-- Name: upload_log_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.upload_log_history_pkey ATTACH PARTITION organization.upload_log_history_default_pkey;


--
-- Name: upload_log_history_default_uploadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."upload_log_history_uploadId_idx" ATTACH PARTITION organization."upload_log_history_default_uploadId_idx";


--
-- Name: user_action_history_default_category_type_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_action_history_category_type_idx ATTACH PARTITION organization.user_action_history_default_category_type_idx;


--
-- Name: user_action_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_action_history_log_idx ATTACH PARTITION organization.user_action_history_default_log_idx;


--
-- Name: user_action_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_action_history_organizationId_idx" ATTACH PARTITION organization."user_action_history_default_organizationId_idx";


--
-- Name: user_action_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_action_history_pkey ATTACH PARTITION organization.user_action_history_default_pkey;


--
-- Name: user_action_history_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_action_history_userId_idx" ATTACH PARTITION organization."user_action_history_default_userId_idx";


--
-- Name: user_monthly_summary_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_monthly_summary_history_log_idx ATTACH PARTITION organization.user_monthly_summary_history_default_log_idx;


--
-- Name: user_monthly_summary_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_monthly_summary_history_organizationId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_organizationId_idx";


--
-- Name: user_monthly_summary_history_default_originalId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_monthly_summary_history_originalId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_originalId_idx";


--
-- Name: user_monthly_summary_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_monthly_summary_history_pkey ATTACH PARTITION organization.user_monthly_summary_history_default_pkey;


--
-- Name: user_monthly_summary_history_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_monthly_summary_history_userId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_userId_idx";


--
-- Name: user_ticket_transaction_history_default_actionUserId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_ticket_transaction_history_actionUserId_idx" ATTACH PARTITION organization."user_ticket_transaction_history_default_actionUserId_idx";


--
-- Name: user_ticket_transaction_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_ticket_transaction_history_log_idx ATTACH PARTITION organization.user_ticket_transaction_history_default_log_idx;


--
-- Name: user_ticket_transaction_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."user_ticket_transaction_history_organizationId_idx" ATTACH PARTITION organization."user_ticket_transaction_history_default_organizationId_idx";


--
-- Name: user_ticket_transaction_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.user_ticket_transaction_history_pkey ATTACH PARTITION organization.user_ticket_transaction_history_default_pkey;


--
-- Name: visit_history_default_endUtc_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visit_history_endUtc_idx" ATTACH PARTITION organization."visit_history_default_endUtc_idx";


--
-- Name: visit_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.visit_history_log_idx ATTACH PARTITION organization.visit_history_default_log_idx;


--
-- Name: visit_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visit_history_organizationId_idx" ATTACH PARTITION organization."visit_history_default_organizationId_idx";


--
-- Name: visit_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.visit_history_pkey ATTACH PARTITION organization.visit_history_default_pkey;


--
-- Name: visit_history_default_visitedUserId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visit_history_visitedUserId_idx" ATTACH PARTITION organization."visit_history_default_visitedUserId_idx";


--
-- Name: visit_history_default_visitorProfileId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visit_history_visitorProfileId_idx" ATTACH PARTITION organization."visit_history_default_visitorProfileId_idx";


--
-- Name: visit_history_default_visitorRegistrationPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visit_history_visitorRegistrationPointId_idx" ATTACH PARTITION organization."visit_history_default_visitorRegistrationPointId_idx";


--
-- Name: visitor_preregistration_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.visitor_preregistration_history_log_idx ATTACH PARTITION organization.visitor_preregistration_history_default_log_idx;


--
-- Name: visitor_preregistration_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visitor_preregistration_history_organizationId_idx" ATTACH PARTITION organization."visitor_preregistration_history_default_organizationId_idx";


--
-- Name: visitor_preregistration_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.visitor_preregistration_history_pkey ATTACH PARTITION organization.visitor_preregistration_history_default_pkey;


--
-- Name: visitor_preregistration_history_default_visitorProfileId_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization."visitor_preregistration_history_visitorProfileId_idx" ATTACH PARTITION organization."visitor_preregistration_history_default_visitorProfileId_idx";


--
-- Name: zz_notification_access_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_zz_notification_access ATTACH PARTITION organization.zz_notification_access_default_id_idx;


--
-- Name: zz_notification_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_zz_notification ATTACH PARTITION organization.zz_notification_default_id_idx;


--
-- Name: zz_notification_sensor_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_zz_notification_sensor ATTACH PARTITION organization.zz_notification_sensor_default_id_idx;


--
-- Name: zz_pacs_notification_scheduled_job_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_zz_pacs_notification_scheduled_job ATTACH PARTITION organization.zz_pacs_notification_scheduled_job_default_id_idx;


--
-- Name: zz_user_organization_forbiddances_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: armonsuper
--

ALTER INDEX organization.bx_zz_user_organization_forbiddances ATTACH PARTITION organization.zz_user_organization_forbiddances_default_id_idx;


--
-- Name: audit_logs_default_log_idx; Type: INDEX ATTACH; Schema: public; Owner: armonsuper
--

ALTER INDEX public.idx_gin_log_audit_logs ATTACH PARTITION public.audit_logs_default_log_idx;


--
-- Name: audit_logs_default_pkey; Type: INDEX ATTACH; Schema: public; Owner: armonsuper
--

ALTER INDEX public.audit_logs_pkey ATTACH PARTITION public.audit_logs_default_pkey;


--
-- Name: notification_instance_default_pkey; Type: INDEX ATTACH; Schema: public; Owner: armonsuper
--

ALTER INDEX public.notification_instance_pkey ATTACH PARTITION public.notification_instance_default_pkey;


--
-- Name: zz_notification_instance_default_id_idx; Type: INDEX ATTACH; Schema: public; Owner: armonsuper
--

ALTER INDEX public.bx_zz_notification_instance ATTACH PARTITION public.zz_notification_instance_default_id_idx;


--
-- Name: mVW_SearchUsers _RETURN; Type: RULE; Schema: organization; Owner: armonsuper
--

CREATE OR REPLACE VIEW organization."mVW_SearchUsers" AS
 SELECT uo.id,
    uo."isDisabled" AS "isDisabledForUserOrganization",
    uo."userId",
    uo."organizationId",
    COALESCE(string_agg(DISTINCT (uop.name)::text, ' '::text)) AS "userOrganizationProfileNameForOrder",
    COALESCE(string_agg(DISTINCT (uop.surname)::text, ' '::text)) AS "userOrganizationProfileSurnameForOrder",
    COALESCE(string_agg(DISTINCT (uop."uniqueId")::text, ' '::text)) AS "userOrganizationProfileUniqueIdForOrder",
    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
           FROM ( SELECT u.username) x)) FILTER (WHERE (u.id IS NOT NULL)), '[]'::json) AS "user",
    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
           FROM ( SELECT uop."uniqueId",
                    uop.name,
                    uop.surname,
                    uop.email) x)) FILTER (WHERE (uop.id IS NOT NULL)), '[]'::json) AS "userOrganizationProfile",
    COALESCE(string_agg(DISTINCT ((ug.id)::character varying)::text, ' '::text)) AS "userGroupIds",
    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
           FROM ( SELECT ug.id,
                    ug.name,
                    ug."colorCode") x)) FILTER (WHERE (ug.id IS NOT NULL)), '[]'::json) AS "userGroups",
    COALESCE(string_agg(DISTINCT ((ou.id)::character varying)::text, ' '::text)) AS "organizationUnitIds",
    COALESCE(string_agg((((ou."ancestorIds")::text || ','::text) || ou.id), ' '::text)) AS "organizationUnitHierarchies",
    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
           FROM ( SELECT ou.id,
                    ou.name,
                    ou."typeId",
                    ou."ancestorIds") x)) FILTER (WHERE (ou.id IS NOT NULL)), '[]'::json) AS "organizationUnits",
    ((((((((setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((uop.name)::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text))), 'A'::"char") || setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((uop.surname)::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text))), 'A'::"char")) || setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((uop.address)::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text))), 'D'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg((uop."phoneNumber")::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text)), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg((uop.email)::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text)), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, COALESCE(string_agg((uop."uniqueId")::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text)), 'A'::"char")) || setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((uop."extensionFields")::text, ' '::text) FILTER (WHERE (uop.id IS NOT NULL)), ''::text))), 'B'::"char")) || setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((ug.name)::text, ' '::text) FILTER (WHERE (ug.id IS NOT NULL)), ''::text))), 'C'::"char")) || setweight(to_tsvector('simple'::regconfig, public.unaccent(COALESCE(string_agg((ou.name)::text, ' '::text) FILTER (WHERE (ou.id IS NOT NULL)), ''::text))), 'C'::"char")) AS "searchDocument"
   FROM ((((((organization."userOrganizations" uo
     JOIN organization.users u ON (((uo."userId" = u.id) AND (uo."deletedAt" IS NULL) AND (u."deletedAt" IS NULL))))
     JOIN organization."userOrganizationProfiles" uop ON (((uo.id = uop."userOrganizationId") AND (uo."deletedAt" IS NULL) AND (uop."deletedAt" IS NULL))))
     LEFT JOIN organization."userOrganizationOrganizationUnits" uoou ON (((uo.id = uoou."userOrganizationId") AND (uo."deletedAt" IS NULL) AND (uoou."deletedAt" IS NULL))))
     LEFT JOIN organization."organizationUnits" ou ON (((ou.id = uoou."organizationUnitId") AND (ou."deletedAt" IS NULL) AND (uoou."deletedAt" IS NULL))))
     LEFT JOIN organization."userGroupUserOrganizations" uguo ON (((uo.id = uguo."userOrganizationId") AND (uo."deletedAt" IS NULL) AND (uguo."deletedAt" IS NULL))))
     LEFT JOIN organization."userGroups" ug ON (((ug.id = uguo."userGroupId") AND (ug."deletedAt" IS NULL) AND (uguo."deletedAt" IS NULL))))
  GROUP BY uo.id;


--
-- Name: vW_SearchPPermissions _RETURN; Type: RULE; Schema: organization; Owner: armonsuper
--

CREATE OR REPLACE VIEW organization."vW_SearchPPermissions" AS
 SELECT p.id,
    p."organizationId",
    p."dynamicFormData",
    p."dynamicFormId",
    p."startDateTime",
    p."endDateTime",
    p.status,
    p."requestDateTime",
    p.note,
    p."requestUserId",
    up."userPPermissions",
    upa."userPPermissionApprovements",
    useranddeputy2."userAndDeputies",
    pt."ppermissionType",
    upa."nextApproverOrganizationUnitIds",
    upa."approvedOrganizationUnitIds",
    upa."approvementWaitingOrganizationUnitIds",
    up."userCount"
   FROM (((((organization.ppermissions p
     JOIN ( SELECT pt_1.id,
            COALESCE(json_agg(( SELECT x.*::record AS x
                   FROM ( SELECT pt_1.id,
                            pt_1."organizationId",
                            pt_1.name,
                            pt_1.description,
                            pt_1."isPassive",
                            pt_1."hrCanInit",
                            pt_1."personnelCanInit",
                            pt_1."ignoreInCalculations",
                            pt_1."trustDeclaration",
                            pt_1."isDailyScheduled",
                            pt_1."minValue",
                            pt_1."maxValue",
                            pt_1."maxValueBoundaryInterval",
                            pt_1."outOfWorkHours",
                            pt_1."sendNotification",
                            pt_1."createdAt",
                            pt_1."updatedAt",
                            pt_1."deletedAt",
                            pt_1."needsManagerDeputy",
                            pt_1."needsUserDeputy",
                            pt_1."userMustSign",
                            pt_1.type,
                            pt_1."showRemainingCount",
                            pt_1."isUnpaidLeave",
                            pt_1."notifyHR",
                            pt_1."dynamicFormId",
                            pt_1.approvements) x)) FILTER (WHERE (pt_1.id IS NOT NULL)), '[]'::json) AS "ppermissionType"
           FROM ( SELECT pt_2.id,
                    pt_2."organizationId",
                    pt_2.name,
                    pt_2.description,
                    pt_2."isPassive",
                    pt_2."hrCanInit",
                    pt_2."personnelCanInit",
                    pt_2."ignoreInCalculations",
                    pt_2."trustDeclaration",
                    pt_2."isDailyScheduled",
                    pt_2."minValue",
                    pt_2."maxValue",
                    pt_2."maxValueBoundaryInterval",
                    pt_2."outOfWorkHours",
                    pt_2."sendNotification",
                    pt_2."createdAt",
                    pt_2."updatedAt",
                    pt_2."deletedAt",
                    pt_2."needsManagerDeputy",
                    pt_2."needsUserDeputy",
                    pt_2."userMustSign",
                    pt_2.type,
                    pt_2."showRemainingCount",
                    pt_2."isUnpaidLeave",
                    pt_2."notifyHR",
                    pt_2."dynamicFormId",
                    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                           FROM ( SELECT pta."rootOrganizationUnitId",
                                    pta."order") x)) FILTER (WHERE (pta.id IS NOT NULL)), '[]'::json) AS approvements
                   FROM (organization."ppermissionTypes" pt_2
                     LEFT JOIN organization."ppermissionTypeApprovements" pta ON ((pt_2.id = pta."ppermissionTypeId")))
                  GROUP BY pt_2.id) pt_1
          GROUP BY pt_1.id) pt ON ((pt.id = p."ppermissionTypeId")))
     LEFT JOIN ( SELECT p_1.id,
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT pa_1.id,
                            pa_1."ppermissionId",
                            pa_1.name) x)) FILTER (WHERE (pa_1.id IS NOT NULL)), '[]'::json) AS "ppermissionAttachments"
           FROM (organization."ppermissionAttachments" pa_1
             JOIN organization.ppermissions p_1 ON ((p_1.id = pa_1."ppermissionId")))
          GROUP BY p_1.id) pa ON ((pa.id = p.id)))
     LEFT JOIN ( SELECT up_1."ppermissionId",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT up_1.id,
                            up_1."userId",
                            up_1."ppermissionId",
                            up_1.note,
                            up_1.approvement,
                            up_1."signedByUser",
                            up_1."currentApprovementOrder") x)) FILTER (WHERE (up_1.id IS NOT NULL)), '[]'::json) AS "userPPermissions",
            count(*) AS "userCount"
           FROM organization."userPPermissions" up_1
          GROUP BY up_1."ppermissionId") up ON ((p.id = up."ppermissionId")))
     LEFT JOIN ( SELECT upa_1."ppermissionId",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE (upa_1.id IS NOT NULL)), '[]'::json) AS "userPPermissionApprovements",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NULL))), '[]'::json) AS "approvementWaitingOrganizationUnitIds",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NOT NULL))), '[]'::json) AS "approvedOrganizationUnitIds",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."order" = up_1."currentApprovementOrder") AND (upa_1."approverUserId" IS NULL))), '[]'::json) AS "nextApproverOrganizationUnitIds"
           FROM (organization."userPPermissionApprovements" upa_1
             JOIN organization."userPPermissions" up_1 ON (((up_1."ppermissionId" = upa_1."ppermissionId") AND (up_1."userId" = upa_1."userId"))))
          GROUP BY upa_1."ppermissionId") upa ON ((p.id = upa."ppermissionId")))
     LEFT JOIN ( SELECT useranddeputy."ppermissionId",
            COALESCE(json_agg(( SELECT x.*::record AS x
                   FROM ( SELECT useranddeputy."user",
                            useranddeputy."deputyUser") x)), '[]'::json) AS "userAndDeputies"
           FROM ( SELECT p_1.id AS "ppermissionId",
                    p_1."organizationId",
                    json_build_object('id', uop."userId", 'fullname', (((uop.name)::text || ' '::text) || (uop.surname)::text), 'uniqueId', uop."uniqueId") AS "user",
                        CASE
                            WHEN (uop2."userId" IS NOT NULL) THEN json_build_object('id', uop2."userId", 'fullname', (((uop2.name)::text || ' '::text) || (uop2.surname)::text), 'uniqueId', uop2."uniqueId")
                            ELSE NULL::json
                        END AS "deputyUser"
                   FROM ((((((organization.ppermissions p_1
                     JOIN organization."userPPermissions" up_1 ON ((up_1."ppermissionId" = p_1.id)))
                     JOIN organization."userOrganizations" uo ON (((uo."userId" = up_1."userId") AND (uo."organizationId" = p_1."organizationId"))))
                     JOIN organization."userOrganizationProfiles" uop ON ((uop."userOrganizationId" = uo.id)))
                     LEFT JOIN organization."userOrganizationDeputies" uod ON (((uod."ppermissionId" = p_1.id) AND (uod."userOrganizationId" = uo.id))))
                     LEFT JOIN organization."userOrganizations" uo2 ON ((uo2.id = uod."deputyUserOrganizationId")))
                     LEFT JOIN organization."userOrganizationProfiles" uop2 ON ((uop2."userOrganizationId" = uo2.id)))
                  WHERE ((uo."deletedAt" IS NULL) AND (uop."deletedAt" IS NULL) AND (uo2."deletedAt" IS NULL) AND (uop2."deletedAt" IS NULL))) useranddeputy
          GROUP BY useranddeputy."ppermissionId") useranddeputy2 ON ((useranddeputy2."ppermissionId" = p.id)));


--
-- Name: ppermissions add_recalculate_records_for_ppermission_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_ppermission_change BEFORE DELETE OR UPDATE ON organization.ppermissions FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_ppermission_change();


--
-- Name: userPPermissions add_recalculate_records_for_user_ppermission_add_delete; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_user_ppermission_add_delete BEFORE INSERT OR DELETE ON organization."userPPermissions" FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete();


--
-- Name: vacations add_recalculate_records_for_vacation_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_vacation_change BEFORE INSERT OR DELETE OR UPDATE ON organization.vacations FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_vacation_change();


--
-- Name: antiPassbackStates after_in_up_del_anti_passback_state; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_in_up_del_anti_passback_state AFTER INSERT OR DELETE OR UPDATE ON organization."antiPassbackStates" FOR EACH ROW EXECUTE FUNCTION organization.after_in_up_del_anti_passback_state();


--
-- Name: access_logs_default after_insert_access_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_access_logs_default AFTER INSERT ON organization.access_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: access_snapshots_default after_insert_access_snapshots_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_access_snapshots_default AFTER INSERT ON organization.access_snapshots_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: counter_sensor_logs_default after_insert_counter_sensor_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_counter_sensor_logs_default AFTER INSERT ON organization.counter_sensor_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: employee_day_segments_default after_insert_employee_day_segments_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_employee_day_segments_default AFTER INSERT ON organization.employee_day_segments_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: log_history_default after_insert_log_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_log_history_default AFTER INSERT ON organization.log_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: log_process_history_default after_insert_log_process_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_log_process_history_default AFTER INSERT ON organization.log_process_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: monthly_summary_history_default after_insert_monthly_summary_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_monthly_summary_history_default AFTER INSERT ON organization.monthly_summary_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: organization_feedback_updates_default after_insert_organization_feedback_updates_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_organization_feedback_updates_default AFTER INSERT ON organization.organization_feedback_updates_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: organization_feedbacks_default after_insert_organization_feedbacks_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_organization_feedbacks_default AFTER INSERT ON organization.organization_feedbacks_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: ppermission_history_default after_insert_ppermission_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_ppermission_history_default AFTER INSERT ON organization.ppermission_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: status_sensor_logs_default after_insert_status_sensor_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_status_sensor_logs_default AFTER INSERT ON organization.status_sensor_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: system_status_logs_default after_insert_system_status_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_system_status_logs_default AFTER INSERT ON organization.system_status_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: tamper_switch_logs_default after_insert_tamper_switch_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_tamper_switch_logs_default AFTER INSERT ON organization.tamper_switch_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: terminalChanges after_insert_terminal_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_terminal_change AFTER INSERT ON organization."terminalChanges" FOR EACH ROW EXECUTE FUNCTION organization.after_insert_terminal_change();


--
-- Name: terminalChangeTransactions after_insert_terminal_transaction; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_terminal_transaction AFTER INSERT ON organization."terminalChangeTransactions" FOR EACH ROW EXECUTE FUNCTION organization.after_insert_terminal_transaction();


--
-- Name: transaction_default after_insert_transaction_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_transaction_default AFTER INSERT ON organization.transaction_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: upload_log_history_default after_insert_upload_log_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_upload_log_history_default AFTER INSERT ON organization.upload_log_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: user_action_history_default after_insert_user_action_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_action_history_default AFTER INSERT ON organization.user_action_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: user_monthly_summary_history_default after_insert_user_monthly_summary_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_monthly_summary_history_default AFTER INSERT ON organization.user_monthly_summary_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: user_ticket_transaction_history_default after_insert_user_ticket_transaction_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_ticket_transaction_history_default AFTER INSERT ON organization.user_ticket_transaction_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: visit_history_default after_insert_visit_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_visit_history_default AFTER INSERT ON organization.visit_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: visitor_preregistration_history_default after_insert_visitor_preregistration_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_visitor_preregistration_history_default AFTER INSERT ON organization.visitor_preregistration_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_notification_access_default after_insert_zz_notification_access_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_access_default AFTER INSERT ON organization.zz_notification_access_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_notification_default after_insert_zz_notification_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_default AFTER INSERT ON organization.zz_notification_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_notification_sensor_default after_insert_zz_notification_sensor_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_sensor_default AFTER INSERT ON organization.zz_notification_sensor_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_pacs_notification_scheduled_job_default after_insert_zz_pacs_notification_scheduled_job_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_pacs_notification_scheduled_job_default AFTER INSERT ON organization.zz_pacs_notification_scheduled_job_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_user_organization_forbiddances_default after_insert_zz_user_organization_forbiddances_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_user_organization_forbiddances_default AFTER INSERT ON organization.zz_user_organization_forbiddances_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: organizations after_up_organization_settings; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_up_organization_settings AFTER UPDATE OF settings ON organization.organizations FOR EACH ROW EXECUTE FUNCTION organization.after_update_organization_settings();


--
-- Name: terminalChanges before_insert_terminal_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_insert_terminal_change BEFORE INSERT ON organization."terminalChanges" FOR EACH ROW EXECUTE FUNCTION organization.before_insert_terminal_change();


--
-- Name: regions before_up_del_regions; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_regions BEFORE DELETE OR UPDATE ON organization.regions FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_regions();


--
-- Name: users before_up_del_user; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_user BEFORE DELETE OR UPDATE ON organization.users FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_user();


--
-- Name: userOrganizations before_up_del_user_organizations; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_user_organizations BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_user_organizations();


--
-- Name: accessControlPoints before_up_in_del_access_control_point; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_access_control_point BEFORE INSERT OR DELETE OR UPDATE ON organization."accessControlPoints" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_access_control_point();


--
-- Name: cameras before_up_in_del_camera; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_camera BEFORE INSERT OR DELETE OR UPDATE ON organization.cameras FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_camera();


--
-- Name: cameraActions before_up_in_del_camera_actions; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_camera_actions BEFORE INSERT OR DELETE OR UPDATE ON organization."cameraActions" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_camera_actions();


--
-- Name: deviceDryContactInputs before_up_in_del_device_dry_contact_inputs; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_dry_contact_inputs BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceDryContactInputs" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_dry_contact_inputs();


--
-- Name: deviceReaders before_up_in_del_device_readers; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_readers BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceReaders" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_readers();


--
-- Name: deviceRelays before_up_in_del_device_relays; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_relays BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceRelays" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_relays();


--
-- Name: notification_access before_up_in_del_notification_access; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_notification_access BEFORE INSERT OR DELETE OR UPDATE ON organization.notification_access FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_notification_access();


--
-- Name: notification_sensor before_up_in_del_notification_sensor; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_notification_sensor BEFORE INSERT OR DELETE OR UPDATE ON organization.notification_sensor FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_notification_sensor();


--
-- Name: oAuthTokens before_up_in_del_o_auth_tokens; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_o_auth_tokens BEFORE INSERT OR DELETE OR UPDATE ON organization."oAuthTokens" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_o_auth_tokens();


--
-- Name: regionAccessControlPoints before_up_in_del_region_access_control_points; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_region_access_control_points BEFORE INSERT OR DELETE OR UPDATE ON organization."regionAccessControlPoints" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_region_access_control_points();


--
-- Name: userAccessRights before_up_in_del_user_access_rights; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_access_rights BEFORE INSERT OR DELETE OR UPDATE ON organization."userAccessRights" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_access_rights();


--
-- Name: userOrganizationForbiddances before_up_in_del_user_forbiddances; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_forbiddances BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizationForbiddances" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_forbiddances();


--
-- Name: userGroupUserOrganizations before_up_in_del_user_group_mapping; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_group_mapping BEFORE INSERT OR DELETE OR UPDATE ON organization."userGroupUserOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_group_mapping();


--
-- Name: userOrganizationCredentials before_up_in_del_user_organization_credentials; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_organization_credentials BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizationCredentials" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_organization_credentials();


--
-- Name: userRegionTicketUnits before_up_in_del_user_region_ticket_unit; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_region_ticket_unit BEFORE INSERT OR DELETE OR UPDATE ON organization."userRegionTicketUnits" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_region_ticket_unit();


--
-- Name: accessRuleSets before_up_in_delete_access_rule_sets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_access_rule_sets BEFORE INSERT OR DELETE OR UPDATE ON organization."accessRuleSets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_access_rule_sets();


--
-- Name: accessRules before_up_in_delete_access_rules; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_access_rules BEFORE INSERT OR DELETE OR UPDATE ON organization."accessRules" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_access_rules();


--
-- Name: regionTickets before_up_in_delete_region_tickets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_region_tickets BEFORE INSERT OR DELETE OR UPDATE ON organization."regionTickets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_region_tickets();


--
-- Name: userGroupAccessRuleSets before_up_in_delete_user_group_access_rule_sets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_user_group_access_rule_sets BEFORE INSERT OR DELETE OR UPDATE ON organization."userGroupAccessRuleSets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_user_group_access_rule_sets();


--
-- Name: accessRuleHistory before_up_in_user_rule_history; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_user_rule_history BEFORE INSERT OR UPDATE ON organization."accessRuleHistory" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_user_rule_history();


--
-- Name: devices before_update_devices; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_update_devices BEFORE UPDATE ON organization.devices FOR EACH ROW EXECUTE FUNCTION organization.before_update_devices();


--
-- Name: userOrganizationProfiles gen_profile_text; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER gen_profile_text BEFORE INSERT OR UPDATE ON organization."userOrganizationProfiles" FOR EACH ROW EXECUTE FUNCTION organization.gen_profile_text();


--
-- Name: employeeLiveDay notify_pacs_live_recalculation_trigger; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER notify_pacs_live_recalculation_trigger AFTER UPDATE ON organization."employeeLiveDay" REFERENCING OLD TABLE AS oldtab NEW TABLE AS newtab FOR EACH STATEMENT EXECUTE FUNCTION organization.notify_pacs_live_recalculation();


--
-- Name: recalculateWorkQueue process_recalculate_work_queue_start_date_time; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER process_recalculate_work_queue_start_date_time BEFORE INSERT OR UPDATE ON organization."recalculateWorkQueue" FOR EACH ROW EXECUTE FUNCTION organization.process_recalculate_work_queue_start_date_time();


--
-- Name: notification trg_99_zz_notification; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification AFTER INSERT OR DELETE OR UPDATE ON organization.notification FOR EACH ROW EXECUTE FUNCTION organization.zz_notification();


--
-- Name: notification_access trg_99_zz_notification_access; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_access AFTER INSERT OR DELETE OR UPDATE ON organization.notification_access FOR EACH ROW EXECUTE FUNCTION organization.zz_notification_access();


--
-- Name: notification_sensor trg_99_zz_notification_sensor; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_sensor AFTER INSERT OR DELETE OR UPDATE ON organization.notification_sensor FOR EACH ROW EXECUTE FUNCTION organization.zz_notification_sensor();


--
-- Name: pacs_notification_scheduled_job trg_99_zz_pacs_notification_scheduled_job; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_pacs_notification_scheduled_job AFTER INSERT OR DELETE OR UPDATE ON organization.pacs_notification_scheduled_job FOR EACH ROW EXECUTE FUNCTION organization.zz_pacs_notification_scheduled_job();


--
-- Name: userOrganizationForbiddances trg_99_zz_user_organization_forbiddances; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_user_organization_forbiddances AFTER INSERT OR DELETE OR UPDATE ON organization."userOrganizationForbiddances" FOR EACH ROW EXECUTE FUNCTION organization.zz_user_organization_forbiddances();


--
-- Name: notification trg_before_up_in_notification; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_before_up_in_notification BEFORE INSERT OR UPDATE ON organization.notification FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_notification();


--
-- Name: userOrganizations update_terminaladmins_trigger; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER update_terminaladmins_trigger BEFORE DELETE OR UPDATE ON organization."userOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.update_terminaladmins();


--
-- Name: audit_logs_default after_insert_audit_logs_default; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_insert_audit_logs_default AFTER INSERT ON public.audit_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: zz_notification_instance_default after_insert_zz_notification_instance_default; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_instance_default AFTER INSERT ON public.zz_notification_instance_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- Name: scheduled_job after_up_in_scheduled_job; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_up_in_scheduled_job AFTER INSERT OR UPDATE ON public.scheduled_job FOR EACH ROW EXECUTE FUNCTION public.after_up_in_scheduled_job();


--
-- Name: notification_instance trg_99_zz_notification_instance; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_instance AFTER INSERT OR DELETE OR UPDATE ON public.notification_instance FOR EACH ROW EXECUTE FUNCTION public.zz_notification_instance();


--
-- Name: accessControlPoints accessControlPoints_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT "accessControlPoints_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: accessRuleHistory accessRuleHistory_accessRuleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_accessRuleId_fkey" FOREIGN KEY ("accessRuleId") REFERENCES organization."accessRules"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: accessRuleHistory accessRuleHistory_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: accessControlPoints accesscontrolpoints_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT accesscontrolpoints_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id);


--
-- Name: accessRules accessrules_accessrulesetid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRules"
    ADD CONSTRAINT accessrules_accessrulesetid_foreign FOREIGN KEY ("accessRuleSetId") REFERENCES organization."accessRuleSets"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: accessRuleSets accessrulesets_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT accessrulesets_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: accessRuleSets accessrulesets_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT accessrulesets_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: adapters adapters_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: adapters adapters_things_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_things_fkey FOREIGN KEY (id) REFERENCES public.things(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: attendanceAccessControlPoints antiPassbackStates_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "antiPassbackStates_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON DELETE CASCADE;


--
-- Name: antiPassbackStates antiPassbackStates_regionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_regionId_fkey" FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: antiPassbackStates antiPassbackStates_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: access_point_qr_code ap_qr_code_ap_id_aps_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT ap_qr_code_ap_id_aps_id_fkey FOREIGN KEY ("accessPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: access_point_qr_code ap_qr_code_remote_relay_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT ap_qr_code_remote_relay_id_fkey FOREIGN KEY ("remoteRelayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: aperioLocks aperiolocks_hubdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT aperiolocks_hubdeviceid_foreign FOREIGN KEY ("hubDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: aperioLocks aperiolocks_lockdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT aperiolocks_lockdeviceid_foreign FOREIGN KEY ("lockDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: attendanceAccessControlPoints attendanceAccessControlPoints_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "attendanceAccessControlPoints_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- Name: cameraActions cameraactions_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: cameraActions cameraactions_cameraid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_cameraid_foreign FOREIGN KEY ("cameraId") REFERENCES organization.cameras(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: cameraActions cameraactions_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: cameras cameras_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT "cameras_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- Name: cameras cameras_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT "cameras_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: controlPanelESeriesSettings controlpaneleseriessettings_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT controlpaneleseriessettings_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: controlPanelESeriesSettings controlpaneleseriessettings_maincontrolpanelid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT controlpaneleseriessettings_maincontrolpanelid_foreign FOREIGN KEY ("mainControlPanelId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: controlPanelMSeriesAnalogInputs controlpanelmseriesanaloginputs_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesAnalogInputs"
    ADD CONSTRAINT controlpanelmseriesanaloginputs_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: controlPanelMSeriesSettings controlpanelmseriesextensionsettings_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesSettings"
    ADD CONSTRAINT controlpanelmseriesextensionsettings_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification created_by_user_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT created_by_user_id_fk FOREIGN KEY ("createdByUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: customReports custom_reports_user_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."customReports"
    ADD CONSTRAINT custom_reports_user_filter_id_user_filter_id_fk FOREIGN KEY ("userFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceDryContactInputs devicedrycontactinputs_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT devicedrycontactinputs_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceDryContactInputs devicedrycontactinputs_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT devicedrycontactinputs_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceIntegrations deviceintegrations_integrateddeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT deviceintegrations_integrateddeviceid_foreign FOREIGN KEY ("integratedDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceIntegrations deviceintegrations_integratingdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT deviceintegrations_integratingdeviceid_foreign FOREIGN KEY ("integratingDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceReaders devicereaders_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceReaders devicereaders_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceReaders devicereaders_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceRelays devicerelays_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT devicerelays_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceRelays devicerelays_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT devicerelays_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: devices devices_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: devices devices_things_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_things_fkey FOREIGN KEY (id) REFERENCES public.things(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceUpdateStatus deviceupdatestatus_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceUpdateStatus"
    ADD CONSTRAINT deviceupdatestatus_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceWiegandReaders devicewiegandreaders_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceWiegandReaders devicewiegandreaders_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: deviceWiegandReaders devicewiegandreaders_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeLiveDay employeeLiveDay_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeLiveDay employeeLiveDay_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeMonths employeeMonths_UpdatedByUserId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_UpdatedByUserId_fkey" FOREIGN KEY ("updatedByUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeMonths employeeMonths_monthlyReportId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_monthlyReportId_fkey" FOREIGN KEY ("monthlyReportId") REFERENCES organization."monthlySummaryReports"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeMonths employeeMonths_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeMonths employeeMonths_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: recalculateWorkQueue fk_organization_id_organization_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT fk_organization_id_organization_id FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: recalculateWorkQueue fk_user_id_user_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT fk_user_id_user_id FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: floorPlans floorplans_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."floorPlans"
    ADD CONSTRAINT floorplans_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: monthlySummaryReports monthlySummaryReports_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."monthlySummaryReports"
    ADD CONSTRAINT "monthlySummaryReports_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_access notification_access_region_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_region_id_fkey FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_access notification_access_target_user_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_target_user_id_fkey FOREIGN KEY ("targetUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_event notification_event_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_event
    ADD CONSTRAINT notification_event_filter_id_user_filter_id_fk FOREIGN KEY ("receiverFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_event notification_event_notification_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_event
    ADD CONSTRAINT notification_event_notification_id_fk FOREIGN KEY ("notificationId") REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_sensor notification_fk_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_fk_id FOREIGN KEY (id) REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_access notification_fk_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_fk_id FOREIGN KEY (id) REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_instance notification_instance_event_id_notification_event_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_event_id_notification_event_id_fk FOREIGN KEY ("eventId", "createdT") REFERENCES organization.notification_event(id, "createdT") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_instance notification_instance_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_id_fk FOREIGN KEY (id, "createdT") REFERENCES public.notification_instance(id, "createdT") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_instance notification_instance_notification_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_notification_id_fk FOREIGN KEY ("notificationId") REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification notification_receiver_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT notification_receiver_filter_id_user_filter_id_fk FOREIGN KEY ("receiverFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_sensor notification_sensor_access_control_point_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_access_control_point_id_fkey FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_sensor notification_sensor_device_dry_contact_input_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_device_dry_contact_input_id_fkey FOREIGN KEY ("deviceDryContactInputId") REFERENCES organization."deviceDryContactInputs"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: oAuthTokens oAuthTokens_oAuthClientId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_oAuthClientId_fkey" FOREIGN KEY ("oAuthClientId") REFERENCES organization."oAuthClients"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: oAuthTokens oAuthTokens_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationActiveVisits organizationActiveVisits_escortUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey" FOREIGN KEY ("escortUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- Name: organizationActiveVisits organizationActiveVisits_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationActiveVisits organizationActiveVisits_organizationVisitorProfileId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_organizationVisitorProfileId_fkey" FOREIGN KEY ("organizationVisitorProfileId") REFERENCES organization."organizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationActiveVisits organizationActiveVisits_visitedOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey" FOREIGN KEY ("visitedOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- Name: organizationActiveVisits organizationActiveVisits_visitedUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey" FOREIGN KEY ("visitedUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- Name: organizationForms organizationForms_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationForms"
    ADD CONSTRAINT "organizationForms_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationModules organizationModules_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationModules"
    ADD CONSTRAINT "organizationModules_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationPACSModuleSettings organizationPACSModuleSettings_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationPACSModuleSettings"
    ADD CONSTRAINT "organizationPACSModuleSettings_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlP_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlPoi_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlPoi_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationUnits organizationUnits_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_id_fkey" FOREIGN KEY (id) REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE;


--
-- Name: organizationUnits organizationUnits_managerUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_managerUserOrganizationId_fkey" FOREIGN KEY ("managerUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- Name: organizationUnits organizationUnits_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: organizationUnits organizationUnits_parentId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_parentId_fkey" FOREIGN KEY ("parentId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: organizationUnits organizationUnits_users_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_users_fkey" FOREIGN KEY ("managerUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessContr_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessContr_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessControlPoin_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessControlPoin_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorModuleSettings organizationVisitorModuleSettings_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorModuleSettings"
    ADD CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: organizationVisitorProfiles organizationVisitorProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorProfiles"
    ADD CONSTRAINT "organizationVisitorProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeDays organization_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT organization_id FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationActiveVisits organizationactivevisits_visitorregistrationpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT organizationactivevisits_visitorregistrationpointid_foreign FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationEmailTemplates organizationemailtemplates_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationEmailTemplates"
    ADD CONSTRAINT organizationemailtemplates_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationFeedbacks organizationfeedbacks_createdby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT organizationfeedbacks_createdby_foreign FOREIGN KEY ("createdBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationFeedbacks organizationfeedbacks_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT organizationfeedbacks_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizations organizations_organizationList_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organizations
    ADD CONSTRAINT "organizations_organizationList_fkey" FOREIGN KEY (id) REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizations organizations_organizationUnitDynamicFormId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organizations
    ADD CONSTRAINT "organizations_organizationUnitDynamicFormId_fkey" FOREIGN KEY ("organizationUnitDynamicFormId") REFERENCES organization."dynamicForms"(id);


--
-- Name: organizationUserDefinedLists organizationuserdefinedlists_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedLists"
    ADD CONSTRAINT organizationuserdefinedlists_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationUserDefinedListValues organizationuserdefinedlistvalues_userdefinedlistid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedListValues"
    ADD CONSTRAINT organizationuserdefinedlistvalues_userdefinedlistid_foreign FOREIGN KEY ("userDefinedListId") REFERENCES organization."organizationUserDefinedLists"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationUserSync organizationusersync_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserSync"
    ADD CONSTRAINT organizationusersync_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorStates organizationvisitorstates_createdby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_createdby_foreign FOREIGN KEY ("createdBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorStates organizationvisitorstates_deletedby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_deletedby_foreign FOREIGN KEY ("deletedBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationVisitorStates organizationvisitorstates_organizationvisitorprofileid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_organizationvisitorprofileid_foreign FOREIGN KEY ("organizationVisitorProfileId") REFERENCES organization."organizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: organizationUnits orgunit_type_id_orguserdefinedlistvalues_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT orgunit_type_id_orguserdefinedlistvalues_id FOREIGN KEY ("typeId") REFERENCES organization."organizationUserDefinedListValues"(id);


--
-- Name: pacs_notification_scheduled_job pacs_notification_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT pacs_notification_user_filter_id_fk FOREIGN KEY ("subjectedEmployeesFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissionAttachments ppermissionAttachments_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionAttachments"
    ADD CONSTRAINT "ppermissionAttachments_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissionClaims ppermissionClaims_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: ppermissionClaims ppermissionClaims_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissionClaims ppermissionClaims_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_rootOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey" FOREIGN KEY ("rootOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- Name: ppermissionTypes ppermissionTypes_dynamicFormId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypes"
    ADD CONSTRAINT "ppermissionTypes_dynamicFormId_fkey" FOREIGN KEY ("dynamicFormId") REFERENCES organization."dynamicForms"(id) ON DELETE SET NULL;


--
-- Name: ppermissionTypes ppermissionTypes_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypes"
    ADD CONSTRAINT "ppermissionTypes_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ppermissions ppermissions_dynamicFormId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT "ppermissions_dynamicFormId_fkey" FOREIGN KEY ("dynamicFormId") REFERENCES organization."dynamicForms"(id) ON DELETE SET NULL;


--
-- Name: ppermissions ppermissions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT "ppermissions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: ppermissions ppermissions_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT "ppermissions_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: preparedReports prepared_reports_filter_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preparedReports"
    ADD CONSTRAINT prepared_reports_filter_user_filter_id_fk FOREIGN KEY ("userFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: preregisterDailySummaries preregisterdailysummaries_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preregisterDailySummaries"
    ADD CONSTRAINT preregisterdailysummaries_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: regionAccessControlPoints regionAccessControlPoints_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: regionAccessControlPoints regionAccessControlPoints_regionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_regionId_fkey" FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: regions regions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.regions
    ADD CONSTRAINT "regions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: regionTickets regiontickets_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT regiontickets_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: regionTickets regiontickets_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT regiontickets_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: report_scheduled_job report_scheduled_job_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_scheduled_job
    ADD CONSTRAINT report_scheduled_job_id_fk FOREIGN KEY (id) REFERENCES public.scheduled_job(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: pacs_notification_scheduled_job report_scheduled_job_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT report_scheduled_job_id_fk FOREIGN KEY (id) REFERENCES public.scheduled_job(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: report_templates report_templates_custom_report_id_custom_reports_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT report_templates_custom_report_id_custom_reports_id FOREIGN KEY ("customReportId") REFERENCES organization."customReports"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: roles roles_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.roles
    ADD CONSTRAINT "roles_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: stickerAccessControlPointMappings stickerAccessControlPointMappings_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."stickerAccessControlPointMappings"
    ADD CONSTRAINT "stickerAccessControlPointMappings_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: terminalAdministrators terminalAdministrators_terminalId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_terminalId_fkey" FOREIGN KEY ("terminalId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: terminalAdministrators terminalAdministrators_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: terminalChangeTransactions terminalChangeTransactions_deviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChangeTransactions"
    ADD CONSTRAINT "terminalChangeTransactions_deviceId_fkey" FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: terminalChanges terminalChanges_deviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChanges"
    ADD CONSTRAINT "terminalChanges_deviceId_fkey" FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userAccessRights userAccessRights_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userAccessRights userAccessRights_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userGroupUserOrganizations userGroupUserOrganizations_userGroupId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey" FOREIGN KEY ("userGroupId") REFERENCES organization."userGroups"(id);


--
-- Name: userGroupUserOrganizations userGroupUserOrganizations_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userGroups userGroups_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userGroups userGroups_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationCredentials userOrganizationCredentials_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationCredentials userOrganizationCredentials_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationDeputies userOrganizationDeputies_deputyUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_deputyUserOrganizationId_fkey" FOREIGN KEY ("deputyUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationDeputies userOrganizationDeputies_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- Name: userOrganizationDeputies userOrganizationDeputies_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id);


--
-- Name: userOrganizationDeputies userOrganizationDeputies_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationLeaves userOrganizationLeaves_updatedByUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_updatedByUserOrganizationId_fkey" FOREIGN KEY ("updatedByUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationLeaves userOrganizationLeaves_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_roleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey" FOREIGN KEY ("roleId") REFERENCES organization.roles(id);


--
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationProfiles userOrganizationProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationProfiles userOrganizationProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationSettings userOrganizationSettings_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationSettings"
    ADD CONSTRAINT "userOrganizationSettings_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationVisits userOrganizationVisits_userOrganizationVisitorProfileId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_userOrganizationVisitorProfileId_fkey" FOREIGN KEY ("userOrganizationVisitorProfileId") REFERENCES organization."userOrganizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationVisits userOrganizationVisits_visitSupervisedByUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitSupervisedByUserOrganizationId_fkey" FOREIGN KEY ("visitSupervisedByUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationVisits userOrganizationVisits_visitingOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitingOrganizationUnitId_fkey" FOREIGN KEY ("visitingOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- Name: userOrganizationVisits userOrganizationVisits_visitingUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitingUserOrganizationId_fkey" FOREIGN KEY ("visitingUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizations userOrganizations_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizations userOrganizations_roleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_roleId_fkey" FOREIGN KEY ("roleId") REFERENCES organization.roles(id);


--
-- Name: userOrganizations userOrganizations_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizations userOrganizations_userOrganizationMapping_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_userOrganizationMapping_fkey" FOREIGN KEY (id) REFERENCES public."userOrganizationMapping"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userPPermissionApprovements userPPermissionApprovements_approverUserId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_approverUserId_fkey" FOREIGN KEY ("approverUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userPPermissionApprovements userPPermissionApprovements_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- Name: userPPermissionApprovements userPPermissionApprovements_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userPPermissionApprovements userPPermissionApprovements_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userPPermissions userPPermissions_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissions"
    ADD CONSTRAINT "userPPermissions_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userProfiles userProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userProfiles"
    ADD CONSTRAINT "userProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userSelectionSessionActions userSelectionSessionActions_sessionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_sessionId_fkey" FOREIGN KEY ("sessionId") REFERENCES organization."userSelectionSessions"(id) ON DELETE CASCADE;


--
-- Name: userSelectionSessionActions userSelectionSessionActions_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userSelectionSessions userSelectionSessions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userSelectionSessions userSelectionSessions_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userWorkPlans userWorkPlans_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userWorkPlans userWorkPlans_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_group user_filter_group_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_group user_filter_group_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_id_fkey FOREIGN KEY ("groupId") REFERENCES organization."userGroups"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_organization_role user_filter_organization_role_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_organization_role user_filter_organization_role_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_id_fkey FOREIGN KEY ("roleId") REFERENCES organization.roles(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_unit user_filter_unit_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_unit_role user_filter_unit_role_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_unit_role user_filter_unit_role_role_id_role_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_role_id_role_id_fkey FOREIGN KEY ("roleId") REFERENCES organization.roles(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_unit_role user_filter_unit_role_unit_id_organization_unit_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_unit_id_organization_unit_id_fkey FOREIGN KEY ("unitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_unit user_filter_unit_unit_id_organization_unit_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_unit_id_organization_unit_id_fkey FOREIGN KEY ("unitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_user user_filter_user_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_user user_filter_user_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_id_fkey FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_work_plan user_filter_work_plan_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_filter_work_plan user_filter_work_plan_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_id_fkey FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: employeeDays user_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT user_id FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: report_templates user_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT user_id_fk FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userGroupAccessRuleSets usergroupaccessrulesets_accessrulesetid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT usergroupaccessrulesets_accessrulesetid_foreign FOREIGN KEY ("accessRuleSetId") REFERENCES organization."accessRuleSets"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userGroupAccessRuleSets usergroupaccessrulesets_usergroupid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT usergroupaccessrulesets_usergroupid_foreign FOREIGN KEY ("userGroupId") REFERENCES organization."userGroups"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationForbiddances userorganizationforbiddances_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationForbiddances userorganizationforbiddances_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationForbiddances userorganizationforbiddances_userid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_userid_foreign FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userRegionTicketUnits userregionticketunits_lastupdateaccesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_lastupdateaccesscontrolpointid_foreign FOREIGN KEY ("lastUpdateAccessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- Name: userRegionTicketUnits userregionticketunits_lastupdateuserid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_lastupdateuserid_foreign FOREIGN KEY ("lastUpdateUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userRegionTicketUnits userregionticketunits_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userRegionTicketUnits userregionticketunits_userid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_userid_foreign FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: users users_userList_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT "users_userList_fkey" FOREIGN KEY (id) REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: vacations vacations_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.vacations
    ADD CONSTRAINT "vacations_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: visitorRegistrationPoints visitorRegistrationPoints_tabletDeviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey" FOREIGN KEY ("tabletDeviceId") REFERENCES organization.devices(id);


--
-- Name: visitorDailySummaries visitordailysummaries_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorDailySummaries"
    ADD CONSTRAINT visitordailysummaries_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- Name: visitorDailySummaries visitordailysummaries_visitorregistrationpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorDailySummaries"
    ADD CONSTRAINT visitordailysummaries_visitorregistrationpointid_foreign FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id);


--
-- Name: visitorRegistrationPointAccessControlPoints visitorregistrationpointaccesscontrolpoints_accesscontrolpointi; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT visitorregistrationpointaccesscontrolpoints_accesscontrolpointi FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: visitorRegistrationPointAccessControlPoints visitorregistrationpointaccesscontrolpoints_visitorregistration; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT visitorregistrationpointaccesscontrolpoints_visitorregistration FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: visitorRegistrationPoints visitorregistrationpoints_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT visitorregistrationpoints_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: workPlanNotifications workPlanNotifications_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanNotifications"
    ADD CONSTRAINT "workPlanNotifications_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: workPlanPeriods workPlanPeriods_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanPeriods"
    ADD CONSTRAINT "workPlanPeriods_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: workPlans workPlans_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlans"
    ADD CONSTRAINT "workPlans_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: emailTemplates emailTemplates_organizationListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."emailTemplates"
    ADD CONSTRAINT "emailTemplates_organizationListId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;


--
-- Name: notification_instance notification_instance_organizationId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE public.notification_instance
    ADD CONSTRAINT "notification_instance_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: oAuthRevokedTokens oAuthRevokedTokens_userListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."oAuthRevokedTokens"
    ADD CONSTRAINT "oAuthRevokedTokens_userListId_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;


--
-- Name: organizationAuthenticationMethods organizationAuthenticationMethods_organizationListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationAuthenticationMethods"
    ADD CONSTRAINT "organizationAuthenticationMethods_organizationListId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;


--
-- Name: scheduled_job scheduled_job_created_by_user_id_user_list_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_created_by_user_id_user_list_id_fk FOREIGN KEY ("createdByUserId") REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: scheduled_job scheduled_job_organization_id_organization_list_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_organization_id_organization_list_id_fk FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: things things_organizationid_foreign; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.things
    ADD CONSTRAINT things_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userAuthenticationMethods userAuthenticationMethods_organizationAuthenticationMethodsId_f; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userAuthenticationMethods"
    ADD CONSTRAINT "userAuthenticationMethods_organizationAuthenticationMethodsId_f" FOREIGN KEY ("authenticationMethodId") REFERENCES public."organizationAuthenticationMethods"(id) ON DELETE CASCADE;


--
-- Name: userAuthenticationMethods userAuthenticationMethods_userListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userAuthenticationMethods"
    ADD CONSTRAINT "userAuthenticationMethods_userListId_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;


--
-- Name: userOrganizationMapping userOrganizationMapping_organizationList_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationMapping_organizationList_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: userOrganizationMapping userOrganizationMapping_userList_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationMapping_userList_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: SCHEMA organization; Type: ACL; Schema: -; Owner: armonsuper
--

GRANT USAGE ON SCHEMA organization TO armonapi;


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: armonsuper
--

GRANT USAGE ON SCHEMA public TO armonapi;


--
-- Name: FUNCTION add_recalculate_records_for_ppermission_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_ppermission_change() TO armonapi;


--
-- Name: FUNCTION add_recalculate_records_for_user_ppermission_add_delete(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() TO armonapi;


--
-- Name: FUNCTION add_recalculate_records_for_vacation_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_vacation_change() TO armonapi;


--
-- Name: FUNCTION after_in_up_del_anti_passback_state(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_in_up_del_anti_passback_state() TO armonapi;


--
-- Name: FUNCTION after_insert_terminal_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_insert_terminal_change() TO armonapi;


--
-- Name: FUNCTION after_insert_terminal_transaction(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_insert_terminal_transaction() TO armonapi;


--
-- Name: FUNCTION after_update_organization_settings(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_update_organization_settings() TO armonapi;


--
-- Name: FUNCTION before_insert_terminal_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_insert_terminal_change() TO armonapi;


--
-- Name: FUNCTION before_up_del_regions(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_regions() TO armonapi;


--
-- Name: FUNCTION before_up_del_user(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_user() TO armonapi;


--
-- Name: FUNCTION before_up_del_user_organizations(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_user_organizations() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_access_control_point(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_access_control_point() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_camera(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_camera() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_camera_actions(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_camera_actions() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_device_dry_contact_inputs(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_dry_contact_inputs() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_device_readers(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_readers() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_device_relays(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_relays() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_notification_access(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_notification_access() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_notification_sensor(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_notification_sensor() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_o_auth_tokens(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_o_auth_tokens() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_region_access_control_points(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_region_access_control_points() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_access_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_access_notification() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_access_rights(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_access_rights() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_forbiddances(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_forbiddances() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_group_mapping(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_group_mapping() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_organization_credentials(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_organization_credentials() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_organization_sensor_notifications(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() TO armonapi;


--
-- Name: FUNCTION before_up_in_del_user_region_ticket_unit(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_region_ticket_unit() TO armonapi;


--
-- Name: FUNCTION before_up_in_delete_access_rule_sets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_access_rule_sets() TO armonapi;


--
-- Name: FUNCTION before_up_in_delete_access_rules(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_access_rules() TO armonapi;


--
-- Name: FUNCTION before_up_in_delete_region_tickets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_region_tickets() TO armonapi;


--
-- Name: FUNCTION before_up_in_delete_user_group_access_rule_sets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() TO armonapi;


--
-- Name: FUNCTION before_up_in_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_notification() TO armonapi;


--
-- Name: FUNCTION before_up_in_user_rule_history(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_user_rule_history() TO armonapi;


--
-- Name: FUNCTION before_update_devices(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_update_devices() TO armonapi;


--
-- Name: FUNCTION fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) TO armonapi;


--
-- Name: FUNCTION fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) TO armonapi;


--
-- Name: FUNCTION fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) TO armonapi;


--
-- Name: FUNCTION gen_profile_text(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.gen_profile_text() TO armonapi;


--
-- Name: FUNCTION json_append(data json, insert_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_append(data json, insert_data json) TO armonapi;


--
-- Name: FUNCTION json_delete(data json, keys text[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_delete(data json, keys text[]) TO armonapi;


--
-- Name: FUNCTION json_merge(data json, merge_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_merge(data json, merge_data json) TO armonapi;


--
-- Name: FUNCTION json_update(data json, update_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_update(data json, update_data json) TO armonapi;


--
-- Name: FUNCTION notify_pacs_live_recalculation(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.notify_pacs_live_recalculation() TO armonapi;


--
-- Name: FUNCTION process_recalculate_work_queue_start_date_time(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.process_recalculate_work_queue_start_date_time() TO armonapi;


--
-- Name: FUNCTION update_terminaladmins(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.update_terminaladmins() TO armonapi;


--
-- Name: FUNCTION zz_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification() TO armonapi;


--
-- Name: FUNCTION zz_notification_access(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification_access() TO armonapi;


--
-- Name: FUNCTION zz_notification_sensor(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification_sensor() TO armonapi;


--
-- Name: FUNCTION zz_pacs_notification_scheduled_job(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_pacs_notification_scheduled_job() TO armonapi;


--
-- Name: FUNCTION zz_user_organization_forbiddances(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_user_organization_forbiddances() TO armonapi;


--
-- Name: FUNCTION after_insert_default(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.after_insert_default() TO armonapi;


--
-- Name: FUNCTION after_up_in_scheduled_job(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.after_up_in_scheduled_job() TO armonapi;


--
-- Name: FUNCTION clone_schema(source_schema text, dest_schema text, include_recs boolean); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) TO armonapi;


--
-- Name: FUNCTION fpartitioncreator(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) TO armonapi;


--
-- Name: FUNCTION fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) TO armonapi;


--
-- Name: FUNCTION fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) TO armonapi;


--
-- Name: FUNCTION json_append(data json, insert_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_append(data json, insert_data json) TO armonapi;


--
-- Name: FUNCTION json_delete(data json, keys text[]); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_delete(data json, keys text[]) TO armonapi;


--
-- Name: FUNCTION json_merge(data json, merge_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_merge(data json, merge_data json) TO armonapi;


--
-- Name: FUNCTION json_update(data json, update_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_update(data json, update_data json) TO armonapi;


--
-- Name: FUNCTION run_for_all_schemas(query_str character varying); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.run_for_all_schemas(query_str character varying) TO armonapi;


--
-- Name: FUNCTION select_for_all_schemas(query_string character varying); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.select_for_all_schemas(query_string character varying) TO armonapi;


--
-- Name: FUNCTION zz_notification_instance(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.zz_notification_instance() TO armonapi;


--
-- Name: TABLE "accessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessControlPoints" TO armonapi;


--
-- Name: TABLE "accessRuleHistory"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRuleHistory" TO armonapi;


--
-- Name: TABLE "accessRuleSets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRuleSets" TO armonapi;


--
-- Name: TABLE "accessRules"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRules" TO armonapi;


--
-- Name: TABLE access_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_logs TO armonapi;


--
-- Name: TABLE access_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_logs_default TO armonapi;


--
-- Name: TABLE access_point_qr_code; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_point_qr_code TO armonapi;


--
-- Name: TABLE access_snapshots; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_snapshots TO armonapi;


--
-- Name: TABLE access_snapshots_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_snapshots_default TO armonapi;


--
-- Name: TABLE adapters; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.adapters TO armonapi;


--
-- Name: TABLE "antiPassbackStates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."antiPassbackStates" TO armonapi;


--
-- Name: TABLE "aperioLocks"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."aperioLocks" TO armonapi;


--
-- Name: TABLE "attendanceAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."attendanceAccessControlPoints" TO armonapi;


--
-- Name: TABLE "cameraActions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."cameraActions" TO armonapi;


--
-- Name: TABLE cameras; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.cameras TO armonapi;


--
-- Name: TABLE "controlPanelESeriesSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelESeriesSettings" TO armonapi;


--
-- Name: TABLE "controlPanelMSeriesAnalogInputs"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelMSeriesAnalogInputs" TO armonapi;


--
-- Name: TABLE "controlPanelMSeriesSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelMSeriesSettings" TO armonapi;


--
-- Name: TABLE counter_sensor_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.counter_sensor_logs TO armonapi;


--
-- Name: TABLE counter_sensor_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.counter_sensor_logs_default TO armonapi;


--
-- Name: TABLE "customReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."customReports" TO armonapi;


--
-- Name: TABLE "deviceCurrentVersions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceCurrentVersions" TO armonapi;


--
-- Name: TABLE "deviceDryContactInputs"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceDryContactInputs" TO armonapi;


--
-- Name: TABLE "deviceIntegrations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceIntegrations" TO armonapi;


--
-- Name: TABLE "deviceReaders"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceReaders" TO armonapi;


--
-- Name: TABLE "deviceRelays"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceRelays" TO armonapi;


--
-- Name: TABLE "deviceUpdateStatus"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceUpdateStatus" TO armonapi;


--
-- Name: TABLE "deviceWiegandReaders"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceWiegandReaders" TO armonapi;


--
-- Name: TABLE devices; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.devices TO armonapi;


--
-- Name: TABLE "dynamicForms"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."dynamicForms" TO armonapi;


--
-- Name: TABLE "employeeDays"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeDays" TO armonapi;


--
-- Name: TABLE "employeeLiveDay"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeLiveDay" TO armonapi;


--
-- Name: TABLE "employeeMonths"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeMonths" TO armonapi;


--
-- Name: TABLE employee_day_segments; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.employee_day_segments TO armonapi;


--
-- Name: TABLE employee_day_segments_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.employee_day_segments_default TO armonapi;


--
-- Name: TABLE "floorPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."floorPlans" TO armonapi;


--
-- Name: TABLE "hikVisionLicencePlateCameraLanes"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."hikVisionLicencePlateCameraLanes" TO armonapi;


--
-- Name: TABLE "impinjSpeedWayGateWayAntennas"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."impinjSpeedWayGateWayAntennas" TO armonapi;


--
-- Name: TABLE log_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_history TO armonapi;


--
-- Name: TABLE log_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_history_default TO armonapi;


--
-- Name: TABLE log_process_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_process_history TO armonapi;


--
-- Name: TABLE log_process_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_process_history_default TO armonapi;


--
-- Name: TABLE "mVW_SearchUsers"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."mVW_SearchUsers" TO armonapi;


--
-- Name: TABLE medium_sms; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.medium_sms TO armonapi;


--
-- Name: TABLE medium_smtp; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.medium_smtp TO armonapi;


--
-- Name: SEQUENCE migrations_id_seq; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT ON SEQUENCE organization.migrations_id_seq TO armonapi;


--
-- Name: TABLE "monthlySummaryReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."monthlySummaryReports" TO armonapi;


--
-- Name: TABLE monthly_summary_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.monthly_summary_history TO armonapi;


--
-- Name: TABLE monthly_summary_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.monthly_summary_history_default TO armonapi;


--
-- Name: TABLE notification; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification TO armonapi;


--
-- Name: TABLE "notificationAttachments"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."notificationAttachments" TO armonapi;


--
-- Name: TABLE notification_access; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_access TO armonapi;


--
-- Name: TABLE notification_event; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event TO armonapi;


--
-- Name: TABLE notification_event_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event_default TO armonapi;


--
-- Name: TABLE notification_instance; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_instance TO armonapi;


--
-- Name: TABLE notification_instance_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_instance_default TO armonapi;


--
-- Name: TABLE notification_sensor; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_sensor TO armonapi;


--
-- Name: TABLE "oAuthClients"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."oAuthClients" TO armonapi;


--
-- Name: TABLE "oAuthTokens"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."oAuthTokens" TO armonapi;


--
-- Name: TABLE "organizationActiveVisits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationActiveVisits" TO armonapi;


--
-- Name: TABLE "organizationEmailTemplates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationEmailTemplates" TO armonapi;


--
-- Name: TABLE "organizationFeedbacks"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationFeedbacks" TO armonapi;


--
-- Name: TABLE "organizationForms"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationForms" TO armonapi;


--
-- Name: TABLE "organizationModules"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationModules" TO armonapi;


--
-- Name: TABLE "organizationPACSModuleSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationPACSModuleSettings" TO armonapi;


--
-- Name: TABLE "organizationUnitDefaultAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUnitDefaultAccessControlPoints" TO armonapi;


--
-- Name: TABLE "organizationUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUnits" TO armonapi;


--
-- Name: TABLE "organizationUserDefinedListValues"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserDefinedListValues" TO armonapi;


--
-- Name: TABLE "organizationUserDefinedLists"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserDefinedLists" TO armonapi;


--
-- Name: TABLE "organizationUserSync"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserSync" TO armonapi;


--
-- Name: TABLE "organizationVisitorDefaultAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorDefaultAccessControlPoints" TO armonapi;


--
-- Name: TABLE "organizationVisitorModuleSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorModuleSettings" TO armonapi;


--
-- Name: TABLE "organizationVisitorProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorProfiles" TO armonapi;


--
-- Name: TABLE "organizationVisitorStates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorStates" TO armonapi;


--
-- Name: TABLE organization_feedback_updates; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedback_updates TO armonapi;


--
-- Name: TABLE organization_feedback_updates_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedback_updates_default TO armonapi;


--
-- Name: TABLE organization_feedbacks; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedbacks TO armonapi;


--
-- Name: TABLE organization_feedbacks_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedbacks_default TO armonapi;


--
-- Name: TABLE organizations; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organizations TO armonapi;


--
-- Name: TABLE pacs_notification_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.pacs_notification_scheduled_job TO armonapi;


--
-- Name: TABLE "ppermissionAttachments"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionAttachments" TO armonapi;


--
-- Name: TABLE "ppermissionClaims"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionClaims" TO armonapi;


--
-- Name: TABLE "ppermissionTypeApprovements"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionTypeApprovements" TO armonapi;


--
-- Name: TABLE "ppermissionTypes"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionTypes" TO armonapi;


--
-- Name: TABLE ppermission_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermission_history TO armonapi;


--
-- Name: TABLE ppermission_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermission_history_default TO armonapi;


--
-- Name: TABLE ppermissions; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermissions TO armonapi;


--
-- Name: TABLE "preparedReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."preparedReports" TO armonapi;


--
-- Name: TABLE "preregisterDailySummaries"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."preregisterDailySummaries" TO armonapi;


--
-- Name: TABLE "recalculateWorkQueue"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."recalculateWorkQueue" TO armonapi;


--
-- Name: TABLE "regionAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."regionAccessControlPoints" TO armonapi;


--
-- Name: TABLE "regionTickets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."regionTickets" TO armonapi;


--
-- Name: TABLE regions; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.regions TO armonapi;


--
-- Name: TABLE report_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.report_scheduled_job TO armonapi;


--
-- Name: TABLE report_templates; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.report_templates TO armonapi;


--
-- Name: TABLE roles; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.roles TO armonapi;


--
-- Name: TABLE softwares; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.softwares TO armonapi;


--
-- Name: TABLE status_sensor_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.status_sensor_logs TO armonapi;


--
-- Name: TABLE status_sensor_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.status_sensor_logs_default TO armonapi;


--
-- Name: TABLE "stickerAccessControlPointMappings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."stickerAccessControlPointMappings" TO armonapi;


--
-- Name: TABLE system_status_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.system_status_logs TO armonapi;


--
-- Name: TABLE system_status_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.system_status_logs_default TO armonapi;


--
-- Name: TABLE tamper_switch_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.tamper_switch_logs TO armonapi;


--
-- Name: TABLE tamper_switch_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.tamper_switch_logs_default TO armonapi;


--
-- Name: TABLE "terminalAdministrators"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalAdministrators" TO armonapi;


--
-- Name: TABLE "terminalChangeTransactions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalChangeTransactions" TO armonapi;


--
-- Name: TABLE "terminalChanges"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalChanges" TO armonapi;


--
-- Name: TABLE transaction; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.transaction TO armonapi;


--
-- Name: TABLE transaction_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.transaction_default TO armonapi;


--
-- Name: TABLE upload_log_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.upload_log_history TO armonapi;


--
-- Name: TABLE upload_log_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.upload_log_history_default TO armonapi;


--
-- Name: TABLE "userAccessRights"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userAccessRights" TO armonapi;


--
-- Name: TABLE "userGroupAccessRuleSets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroupAccessRuleSets" TO armonapi;


--
-- Name: TABLE "userGroupUserOrganizations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroupUserOrganizations" TO armonapi;


--
-- Name: TABLE "userGroups"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroups" TO armonapi;


--
-- Name: TABLE "userOrganizationCredentials"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationCredentials" TO armonapi;


--
-- Name: TABLE "userOrganizationDeputies"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationDeputies" TO armonapi;


--
-- Name: TABLE "userOrganizationForbiddances"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationForbiddances" TO armonapi;


--
-- Name: TABLE "userOrganizationLeaves"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationLeaves" TO armonapi;


--
-- Name: TABLE "userOrganizationOrganizationUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationOrganizationUnits" TO armonapi;


--
-- Name: TABLE "userOrganizationProfilePhotos"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationProfilePhotos" TO armonapi;


--
-- Name: TABLE "userOrganizationProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationProfiles" TO armonapi;


--
-- Name: TABLE "userOrganizationSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationSettings" TO armonapi;


--
-- Name: TABLE "userOrganizationVisitorProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationVisitorProfiles" TO armonapi;


--
-- Name: TABLE "userOrganizationVisits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationVisits" TO armonapi;


--
-- Name: TABLE "userOrganizations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizations" TO armonapi;


--
-- Name: TABLE "userPPermissionApprovements"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userPPermissionApprovements" TO armonapi;


--
-- Name: TABLE "userPPermissions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userPPermissions" TO armonapi;


--
-- Name: TABLE "userProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userProfiles" TO armonapi;


--
-- Name: TABLE "userRegionTicketUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userRegionTicketUnits" TO armonapi;


--
-- Name: TABLE "userSelectionSessionActions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userSelectionSessionActions" TO armonapi;


--
-- Name: TABLE "userSelectionSessions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userSelectionSessions" TO armonapi;


--
-- Name: TABLE "userWorkPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userWorkPlans" TO armonapi;


--
-- Name: TABLE user_action_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_action_history TO armonapi;


--
-- Name: TABLE user_action_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_action_history_default TO armonapi;


--
-- Name: TABLE user_filter; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter TO armonapi;


--
-- Name: TABLE user_filter_group; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_group TO armonapi;


--
-- Name: TABLE user_filter_organization_role; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_organization_role TO armonapi;


--
-- Name: TABLE user_filter_unit; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_unit TO armonapi;


--
-- Name: TABLE user_filter_unit_role; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_unit_role TO armonapi;


--
-- Name: TABLE user_filter_user; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_user TO armonapi;


--
-- Name: TABLE user_filter_work_plan; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_work_plan TO armonapi;


--
-- Name: TABLE user_monthly_summary_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_monthly_summary_history TO armonapi;


--
-- Name: TABLE user_monthly_summary_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_monthly_summary_history_default TO armonapi;


--
-- Name: TABLE user_ticket_transaction_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_ticket_transaction_history TO armonapi;


--
-- Name: TABLE user_ticket_transaction_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_ticket_transaction_history_default TO armonapi;


--
-- Name: TABLE users; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.users TO armonapi;


--
-- Name: TABLE "vW_CredentialUserProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_CredentialUserProfiles" TO armonapi;


--
-- Name: TABLE "vW_SearchPPermissions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_SearchPPermissions" TO armonapi;


--
-- Name: TABLE "vW_UserOrganizationUnitHierarchys"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_UserOrganizationUnitHierarchys" TO armonapi;


--
-- Name: TABLE "vW_UserHierarchys"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_UserHierarchys" TO armonapi;


--
-- Name: TABLE "workPlanPeriods"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlanPeriods" TO armonapi;


--
-- Name: TABLE "workPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlans" TO armonapi;


--
-- Name: TABLE "vW_WorkPlanPeriodTstzrange"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_WorkPlanPeriodTstzrange" TO armonapi;


--
-- Name: TABLE vacations; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.vacations TO armonapi;


--
-- Name: TABLE visit_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visit_history TO armonapi;


--
-- Name: TABLE visit_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visit_history_default TO armonapi;


--
-- Name: TABLE "visitorDailySummaries"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorDailySummaries" TO armonapi;


--
-- Name: TABLE "visitorRegistrationPointAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorRegistrationPointAccessControlPoints" TO armonapi;


--
-- Name: TABLE "visitorRegistrationPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorRegistrationPoints" TO armonapi;


--
-- Name: TABLE visitor_preregistration_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visitor_preregistration_history TO armonapi;


--
-- Name: TABLE visitor_preregistration_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visitor_preregistration_history_default TO armonapi;


--
-- Name: TABLE vw_user_filter; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.vw_user_filter TO armonapi;


--
-- Name: TABLE "workPlanNotifications"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlanNotifications" TO armonapi;


--
-- Name: TABLE "workingHoursScheduleUnrestricteds"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workingHoursScheduleUnrestricteds" TO armonapi;


--
-- Name: TABLE zz_notification; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification TO armonapi;


--
-- Name: TABLE zz_notification_access; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_access TO armonapi;


--
-- Name: TABLE zz_notification_access_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_access_default TO armonapi;


--
-- Name: TABLE zz_notification_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_default TO armonapi;


--
-- Name: TABLE zz_notification_sensor; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_sensor TO armonapi;


--
-- Name: TABLE zz_notification_sensor_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_sensor_default TO armonapi;


--
-- Name: TABLE zz_pacs_notification_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_pacs_notification_scheduled_job TO armonapi;


--
-- Name: TABLE zz_pacs_notification_scheduled_job_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_pacs_notification_scheduled_job_default TO armonapi;


--
-- Name: TABLE zz_user_organization_forbiddances; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_user_organization_forbiddances TO armonapi;


--
-- Name: TABLE zz_user_organization_forbiddances_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_user_organization_forbiddances_default TO armonapi;


--
-- Name: TABLE audit_logs; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.audit_logs TO armonapi;


--
-- Name: TABLE audit_logs_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.audit_logs_default TO armonapi;


--
-- Name: TABLE "emailTemplates"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."emailTemplates" TO armonapi;


--
-- Name: TABLE migration; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.migration TO armonapi;


--
-- Name: TABLE notification_instance; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance TO armonapi;


--
-- Name: TABLE notification_instance_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance_default TO armonapi;


--
-- Name: TABLE "oAuthRevokedTokens"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."oAuthRevokedTokens" TO armonapi;


--
-- Name: TABLE "organizationAuthenticationMethods"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."organizationAuthenticationMethods" TO armonapi;


--
-- Name: TABLE "organizationList"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."organizationList" TO armonapi;


--
-- Name: TABLE "scheduledJobHistoryLogs"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."scheduledJobHistoryLogs" TO armonapi;


--
-- Name: TABLE scheduled_job; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.scheduled_job TO armonapi;


--
-- Name: TABLE things; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.things TO armonapi;


--
-- Name: TABLE "userAuthenticationMethods"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userAuthenticationMethods" TO armonapi;


--
-- Name: TABLE "userList"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userList" TO armonapi;


--
-- Name: TABLE "userOrganizationMapping"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userOrganizationMapping" TO armonapi;


--
-- Name: TABLE zz_notification_instance; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.zz_notification_instance TO armonapi;


--
-- Name: TABLE zz_notification_instance_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.zz_notification_instance_default TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON SEQUENCES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT SELECT ON SEQUENCES  TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON FUNCTIONS  FROM PUBLIC;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON FUNCTIONS  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT ALL ON FUNCTIONS  TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON TABLES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES  TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON SEQUENCES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT SELECT ON SEQUENCES  TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON FUNCTIONS  FROM PUBLIC;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON FUNCTIONS  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT ALL ON FUNCTIONS  TO armonapi;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON TABLES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES  TO armonapi;


--
-- PostgreSQL database dump complete
--
--
-- PostgreSQL database dump
--

-- Dumped from database version 13.3 (Debian 13.3-1.pgdg100+1)
-- Dumped by pg_dump version 13.3 (Debian 13.3-1.pgdg100+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Data for Name: migration; Type: TABLE DATA; Schema: public; Owner: armonsuper
--

INSERT INTO public.migration VALUES ('20210101.js', '2021-05-25 11:13:20.739548');
INSERT INTO public.migration VALUES ('20210121.js', '2021-05-25 11:13:20.740634');
INSERT INTO public.migration VALUES ('20210125.js', '2021-05-25 11:13:20.7412');
INSERT INTO public.migration VALUES ('20210203.js', '2021-05-25 11:13:20.741712');
INSERT INTO public.migration VALUES ('20210210.js', '2021-05-25 11:13:20.742249');
INSERT INTO public.migration VALUES ('20210211.js', '2021-05-25 11:13:20.742748');
INSERT INTO public.migration VALUES ('20210212.js', '2021-05-25 11:13:20.743224');
INSERT INTO public.migration VALUES ('20210213.js', '2021-05-25 11:13:20.743728');
INSERT INTO public.migration VALUES ('20210216.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210217.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210223.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210302.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210304.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210308.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210309.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210310.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210311.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210312.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210322.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210324.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210330.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210401.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210407.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210408.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210412.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210420.js', '2021-05-25 11:13:54.586021');
INSERT INTO public.migration VALUES ('20210430.js', '2021-05-25 11:13:54.586021');


--
-- PostgreSQL database dump complete
--

