dbexists=$(psql -tqw -U $PGSUPERUSER $PGDATABASE -c "SELECT 1" 2>/dev/null)

if [ $? == '0' ]; then
    echo "Database $PGDATABASE already exists, skipping scaffolding"
else
    PGPASSWORD=$PGPOSTGRES_PASSWORD createdb -U $PGPOSTGRES_USER -w -O $PGSUPERUSER -l "tr_TR.UTF-8" -E UTF8 -T template0 $PGDATABASE

    psql -U $PGSUPERUSER -q $PGDATABASE -c "ALTER DEFAULT PRIVILEGES FOR ROLE $PGSUPERUSER GRANT USAGE ON SCHEMAS TO $PGUSER;"
    psql -U $PGSUPERUSER -q $PGDATABASE -c "ALTER DEFAULT PRIVILEGES FOR ROLE $PGSUPERUSER GRANT SELECT, UPDATE, USAGE ON SEQUENCES TO $PGUSER;"
    psql -U $PGSUPERUSER -q $PGDATABASE -c "ALTER DEFAULT PRIVILEGES FOR ROLE $PGSUPERUSER GRANT EXECUTE ON FUNCTIONS TO $PGUSER;"
    psql -U $PGSUPERUSER -q $PGDATABASE -c "ALTER DEFAULT PRIVILEGES FOR ROLE $PGSUPERUSER GRANT SELECT, INSERT, UPDATE, DELETE ON TABLES TO $PGUSER;"
    psql -U $PGSUPERUSER -q $PGDATABASE -c "GRANT TEMPORARY ON DATABASE $PGDATABASE TO $PGUSER;"

    psql -U $PGSUPERUSER -q $PGDATABASE -c 'CREATE EXTENSION "uuid-ossp";'
    psql -U $PGSUPERUSER -q $PGDATABASE -c 'CREATE EXTENSION "unaccent";'
    psql -U $PGSUPERUSER -q $PGDATABASE -c 'CREATE EXTENSION "pg_trgm";'
    psql -U $PGSUPERUSER -q $PGDATABASE -c 'CREATE EXTENSION "btree_gist";'

    if [ -f "/etc/armon/webapp/config/postgresql/scaffold.sql" ]; then
        cp /etc/armon/webapp/config/postgresql/scaffold.sql /tmp/scaffold_replaced.sql
        sed -i 's/armonapi/'"$PGUSER"'/g' /tmp/scaffold_replaced.sql
        sed -i 's/armonsuper/'"$PGSUPERUSER"'/g' /tmp/scaffold_replaced.sql
        sed -i 's/public/'"$PGCOMMONSCHEMA"'/g' /tmp/scaffold_replaced.sql
        sed -i 's/'"$PGCOMMONSCHEMA"'.gin_trgm_ops/public.gin_trgm_ops/g' /tmp/scaffold_replaced.sql
        sed -i 's/'"$PGCOMMONSCHEMA"'.unaccent/public.unaccent/g' /tmp/scaffold_replaced.sql
        psql -U $PGSUPERUSER -q $PGDATABASE -f /tmp/scaffold_replaced.sql
        rm /tmp/scaffold_replaced.sql
    fi
fi