--
-- PostgreSQL database dump
--

-- Dumped from database version 12.4 (Debian 12.4-1.pgdg100+1)
-- Dumped by pg_dump version 13.0

-- Started on 2021-02-17 13:29:13

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 6 (class 2615 OID 2200)
-- Name: public; Type: SCHEMA; Schema: -; Owner: armonsuper
--


CREATE SCHEMA IF NOT EXISTS public;


ALTER SCHEMA public OWNER TO armonsuper;

--
-- TOC entry 4646 (class 0 OID 0)
-- Dependencies: 6
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: armonsuper
--

COMMENT ON SCHEMA public IS 'standard public schema';
	
CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;
COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';

CREATE EXTENSION IF NOT EXISTS unaccent WITH SCHEMA public;
COMMENT ON EXTENSION unaccent IS 'text search dictionary that removes accents';

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;
COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';

--
-- TOC entry 677 (class 1255 OID 12185937)
-- Name: after_insert_default(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.after_insert_default() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    res text;
    t_name text;
        BEGIN
        t_name := REPLACE (TG_TABLE_NAME, '_default', '');
        res := jsonb_build_object(
            'tName', t_name,
            'sName', TG_TABLE_SCHEMA,
            'key', (SELECT col.column_name FROM
                (SELECT partrelid, partnatts, case partstrat when 'l' then 'list'
                                        when 'r' then 'range' end as partition_strategy,
                    UNNEST (partattrs) column_index FROM pg_partitioned_table) pt 
                JOIN pg_class par ON par.oid = pt.partrelid
                JOIN information_schema.columns col ON quote_ident(col.table_schema) = par.relnamespace::regnamespace::text
                AND col.table_name = par.relname
                AND ordinal_position = pt.column_index
                WHERE par.relnamespace::regnamespace::text = quote_ident(TG_TABLE_SCHEMA) 
                AND par.relname = t_name
                )
        )::text;
        PERFORM PG_NOTIFY('partition', res);
        RAISE NOTICE  'partition for: %', res;
        RETURN null;
        END;
    $$;


ALTER FUNCTION public.after_insert_default() OWNER TO armonsuper;

--
-- TOC entry 678 (class 1255 OID 12185938)
-- Name: after_up_in_scheduled_job(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.after_up_in_scheduled_job() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
				scheduled_job_id 	text;
			BEGIN
				scheduled_job_id:= NEW.id::text;
				IF(TG_OP = 'INSERT' OR 
					(TG_OP = 'UPDATE' AND
						NEW.enabled IS TRUE AND  
						(NEW."nextExecutionDate" <> OLD."nextExecutionDate" 
						OR NEW."firstExecutionDate" <> OLD."firstExecutionDate" 
						OR NEW."interval" <> OLD."interval"
						OR OLD.enabled IS FALSE)
					)) THEN
					PERFORM PG_NOTIFY('scheduled_job_upsert', scheduled_job_id);            
				END IF;
				RETURN NEW;
			END;
	$$;


ALTER FUNCTION public.after_up_in_scheduled_job() OWNER TO armonsuper;

--
-- TOC entry 679 (class 1255 OID 12185939)
-- Name: clone_schema(text, text, boolean); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) RETURNS void
    LANGUAGE plpgsql
    AS $$
	--  This function will clone all sequences, tables, data, views & functions from any existing schema to a new one
	-- SAMPLE CALL:
	-- SELECT clone_schema('public', 'new_schema', TRUE);
	
	DECLARE
	src_oid          oid;
	tbl_oid          oid;
	func_oid         oid;
	object           text;
	v_rec            record;
	buffer           text;
	srctbl           text;
	default_         text;
	column_          text;
	qry              text;
	dest_qry         text;
	is_partition     boolean;
	partition_col_name     text;
	partition_range_cond     text;
	parent_rel_table text;
	fk_query text;
	trigger_name_ text;
	trigger_timing_ text;
	trigger_events_ text;
	trigger_orientation_ text;
	trigger_action_ text;
	
	BEGIN
	
	-- Check that source_schema exists
	SELECT oid INTO src_oid
	  FROM pg_namespace
	 WHERE nspname = quote_ident(source_schema);
	IF NOT FOUND
	  THEN 
	  RAISE NOTICE 'source schema % does not exist!', source_schema;
	  RETURN ;
	END IF;
	/*
	-- Check that dest_schema does not yet exist
	PERFORM nspname 
	  FROM pg_namespace
	 WHERE nspname = quote_ident(dest_schema);
	IF NOT FOUND
	  THEN 
	  EXECUTE 'CREATE SCHEMA ' || quote_ident(dest_schema) ;
	  -- RAISE NOTICE 'dest schema % already exists!', dest_schema;
	  RETURN ;
	END IF;
	*/
	
	EXECUTE 'CREATE SCHEMA IF NOT EXISTS ' || quote_ident(dest_schema) ;
	
	-- Create sequences
	-- TODO: Find a way to make this sequence's owner is the correct table.
	FOR object IN
	  SELECT sequence_name::text 
		FROM information_schema.sequences
	   WHERE sequence_schema = quote_ident(source_schema)
	LOOP
	  EXECUTE 'CREATE SEQUENCE ' || quote_ident(dest_schema) || '.' || quote_ident(object);
	  srctbl := quote_ident(source_schema) || '.' || quote_ident(object);
	END LOOP;
	
	-- Create functions 
	FOR func_oid IN
	  SELECT oid
		FROM pg_proc 
	   WHERE pronamespace = src_oid
	
	LOOP      
	  SELECT pg_get_functiondef(func_oid) INTO qry;
	  SELECT replace(qry, quote_ident(source_schema) || '.', quote_ident(dest_schema) || '.') INTO dest_qry;
	  EXECUTE dest_qry;
	
	END LOOP;
	
	-- Create tables 
	FOR object IN
	  SELECT TABLE_NAME::text as tx 
		FROM information_schema.tables 
	   WHERE table_schema = quote_ident(source_schema)
		 AND table_type = 'BASE TABLE'
		ORDER BY tx  asc
	LOOP
	
	   SELECT relispartition INTO is_partition
		FROM pg_catalog.pg_class
		WHERE relname = object;
		
		IF NOT is_partition THEN
		
			  select 
				col.column_name into partition_col_name
			from   
				(select
					 partrelid,
					 partnatts,
					 case partstrat 
						  when 'l' then 'list' 
						  when 'r' then 'range' end as partition_strategy,
					 unnest(partattrs) column_index
				 from
					 pg_partitioned_table) pt 
			join   
				pg_class par 
			on     
				par.oid = pt.partrelid
			join
				information_schema.columns col
			on  
		quote_ident(col.table_schema) = par.relnamespace::regnamespace::text
				and col.table_name = par.relname
				and ordinal_position = pt.column_index
			WHERE par.relnamespace::regnamespace::text = quote_ident(source_schema) AND par.relname = object;
			
		
		  buffer := quote_ident(dest_schema) || '.' || quote_ident(object);
		  EXECUTE 'CREATE TABLE ' || buffer || ' (LIKE ' || quote_ident(source_schema) || '.' || quote_ident(object) 
			  || ' INCLUDING ALL)' || (CASE WHEN partition_col_name IS NOT NULL THEN ' PARTITION BY RANGE ('|| quote_ident(partition_col_name)||')' ELSE '' END);
	
		  FOR column_, default_ IN
			SELECT column_name::text, 
				   REPLACE(column_default::text, source_schema, quote_ident(dest_schema)) 
			  FROM information_schema.COLUMNS 
			 WHERE table_schema =  quote_ident(dest_schema)
			   AND TABLE_NAME = object 
			   AND column_default LIKE 'nextval(%' || quote_ident(source_schema) || '%::regclass)'
		  LOOP
			  EXECUTE 'ALTER TABLE ' || buffer || ' ALTER COLUMN ' || column_ || ' SET DEFAULT ' || default_;
		  END LOOP;
			
		  IF include_recs 
			THEN 
			-- Insert records from source table
			  EXECUTE 'INSERT INTO ' || buffer || ' SELECT * FROM ' || quote_ident(source_schema) || '.' || quote_ident(object) || ';';
		  END IF;
		  
		ELSE
			SELECT pg_get_expr(p.relpartbound, p.oid) into partition_range_cond from pg_class as p
				JOIN pg_namespace as ns ON (ns.oid = p.relnamespace)
				where relname = object AND ns.nspname = source_schema;
			--select pg_get_expr(relpartbound, oid) into partition_range_cond from pg_class where relispartition and relname = object;
			RAISE NOTICE 'partition_range_cond %', partition_range_cond;
			SELECT REPLACE (REPLACE(partrelid::regclass::text, 'notification.', ''), 'organization.', '')
			INTO parent_rel_table from pg_partitioned_table WHERE partdefid::regclass::text  = quote_ident(source_schema) || '.' || quote_ident(object);
			--select partrelid::regclass::text, partdefid::regclass::text, * from pg_partitioned_table  --where  (partrelid::regclass::text) like quote_ident(source_schema) || '.%'
			IF parent_rel_table IS NULL THEN
				SELECT p.relname into parent_rel_table FROM pg_inherits
					JOIN pg_class as p ON (inhparent=p.oid)
					JOIN pg_namespace as ns ON (ns.oid = p.relnamespace)
					WHERE ((inhrelid::regclass::text ilike '%.' || object) OR 
					(inhrelid::regclass::text = object)) AND ns.nspname = source_schema;
			END IF;
			RAISE NOTICE 'parent_rel_table % of %', parent_rel_table, object;
			EXECUTE 'CREATE TABLE '|| quote_ident(dest_schema) || '.' || quote_ident(object) ||' PARTITION OF '|| quote_ident(dest_schema) 
			|| '.' ||quote_ident(parent_rel_table)||' ' ||partition_range_cond || ';';
		END IF;
		
	  FOR trigger_name_ IN
	  SELECT trigger_name::text FROM information_schema.TRIGGERS 
	  WHERE event_object_schema=source_schema and event_object_table=object 
	  GROUP BY trigger_name
	  LOOP
		buffer := quote_ident(dest_schema) || '.' || quote_ident(object);
		EXECUTE (SELECT 
		  REPLACE (
			REPLACE (
			  REPLACE(
				REPLACE (
				  REPLACE (
					REPLACE (pg_get_triggerdef(oid), 'public.', ''), 
				  'notification.', ''), 
				'organization.', ''), 
			  'EXECUTE PROCEDURE', 'EXECUTE FUNCTION'),
			'EXECUTE FUNCTION ', CASE WHEN POSITION ('after_insert_default' IN pg_get_triggerdef(oid)) > 0
				THEN 'EXECUTE FUNCTION public.' ELSE 'EXECUTE FUNCTION '|| quote_ident(dest_schema) ||'.' END), 
		  ' ON ', ' ON '|| quote_ident(dest_schema) ||'.') 
		  FROM pg_trigger
		  WHERE tgname = trigger_name_
          AND ( CASE WHEN substr((SELECT current_setting('server_version_num')), 1, 2)::integer >= 15 THEN tgparentid=0 ELSE true END)
		  AND ( CASE WHEN source_schema = 'public' THEN 
			tgrelid::regclass::text = quote_ident(object) ELSE 
			tgrelid::regclass::text = quote_ident(source_schema) || '.' ||quote_ident(object) END)
		  );
	  END LOOP;
	END LOOP;
	
	--  add FK constraint
	FOR qry IN
		SELECT 'ALTER TABLE ' || quote_ident(dest_schema) || '.' || quote_ident(rn.relname) 
		|| ' ADD CONSTRAINT ' || quote_ident(ct.conname) || ' ' || 
		  REPLACE( REPLACE (REPLACE (pg_get_constraintdef(ct.oid),'notification.', ''), 'organization.', ''),
		'REFERENCES ', CASE WHEN  POSITION( '.' IN pg_get_constraintdef(ct.oid))> 0 THEN 'REFERENCES '||quote_ident(dest_schema) ||'.'  ELSE 'REFERENCES public.' END) || ';'
		FROM pg_constraint ct
		JOIN pg_class rn ON rn.oid = ct.conrelid
		JOIN pg_namespace ns ON ns.oid = connamespace
	   WHERE connamespace = ns.oid
		 --AND rn.relkind = 'r'
		 AND rn.relispartition = false
		 AND ct.contype = 'f'
		 AND ct.conparentid = 0
		 AND ns.nspname = quote_ident(source_schema)
	  LOOP
		  RAISE NOTICE 'query for foreign key %',qry;
		EXECUTE qry;
	
	  END LOOP;
	
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."organizationList" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userList" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userOrganizationMapping" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."things" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."scheduledJobs" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."scheduledJobHistoryLogs" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."migrations" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."migrations_lock" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."emailTemplates" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."oAuthRevokedTokens" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."organizationAuthenticationMethods" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."userAuthenticationMethods" CASCADE;';
	EXECUTE 'DROP TABLE IF EXISTS ' || quote_ident(dest_schema) || '."reportTemplates" CASCADE;';
	
	EXECUTE 'DROP FUNCTION IF EXISTS ' || quote_ident(dest_schema) || '."clone_schema" CASCADE;';
	EXECUTE 'DROP FUNCTION IF EXISTS ' || quote_ident(dest_schema) || '."disable_trigger" CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."oAuthRevokedTokens" 
		DROP CONSTRAINT IF EXISTS "oAuthRevokedTokens_userId_fkey",
		DROP CONSTRAINT IF EXISTS "oAuthRevokedTokens_userListId_fkey",
		ADD CONSTRAINT "oAuthRevokedTokens_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."emailTemplates" 
		DROP CONSTRAINT IF EXISTS "emailTemplates_organizationId_fkey",
		DROP CONSTRAINT IF EXISTS "emailTemplates_organizationListId_fkey",
		ADD CONSTRAINT "emailTemplates_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."scheduledJobs" 
		DROP CONSTRAINT IF EXISTS "scheduledJobs_organizationId_fkey",
		DROP CONSTRAINT IF EXISTS "scheduledJobs_organizationListId_fkey",
		ADD CONSTRAINT "scheduledJobs_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."organizationAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "organizationauthenticationmethods_organizationid_foreign",
		DROP CONSTRAINT IF EXISTS "organizationAuthenticationMethods_organizationListId_fkey",
		ADD CONSTRAINT "organizationAuthenticationMethods_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."userAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "userauthenticationmethods_organizationid_foreign",
		DROP CONSTRAINT IF EXISTS "userAuthenticationMethods_userListId_fkey",
		ADD CONSTRAINT "userAuthenticationMethods_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."userAuthenticationMethods" 
		DROP CONSTRAINT IF EXISTS "userauthenticationmethods_authmethodid_foreign",
		DROP CONSTRAINT IF EXISTS "userAuthenticationMethods_organizationAuthenticationMethodsId_fkey",
		ADD CONSTRAINT "userAuthenticationMethods_organizationAuthenticationMethodsId_fkey" 
		FOREIGN KEY ("authenticationMethodId") REFERENCES public."organizationAuthenticationMethods"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."reportTemplates" 
		DROP CONSTRAINT IF EXISTS "reportTemplates_organizationListId_fkey",
		ADD CONSTRAINT "reportTemplates_organizationListId_fkey" 
		FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;';
	
	EXECUTE 'ALTER TABLE IF EXISTS ' || quote_ident(source_schema)|| '."reportTemplates" 
		DROP CONSTRAINT IF EXISTS "reportTemplates_userListId_fkey",
		ADD CONSTRAINT "reportTemplates_userListId_fkey" 
		FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;';
	
	RETURN; 
	
	END;
	$$;


ALTER FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) OWNER TO armonsuper;

--
-- TOC entry 692 (class 1255 OID 12185941)
-- Name: fpartitioncreator(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE 
				def_partition	text;
				i	timestamp with time zone;
				partition_to_create	text;
				previous_partition	text;
				next_partition	text;
				start_of_partition 	timestamp with time zone;
				end_of_partition 	timestamp with time zone;
			BEGIN
				IF (org_id = 'public' AND table_name = 'notification_instance') THEN
					-- PERFORM public.fpartitioncretor_for_public_notification_instance(org_id, table_name, partition_key);
					RETURN;
				ELSIF (table_name = 'notification_event') THEN
					-- PERFORM public.fpartitioncretor_for_schema_notification_event(org_id, table_name, partition_key);
					RETURN;
				ELSE
					def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
				
					EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' DETACH PARTITION ' || def_partition || ';';
					FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
						SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
						' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || def_partition || ') AS T WHERE T.row_num = 1;'
					LOOP
						partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
						previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
						next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
	
						IF NOT EXISTS(
							SELECT relname FROM pg_class 
							WHERE relname = previous_partition AND 
							relnamespace::regnamespace::text = quote_ident(org_id)) THEN
							start_of_partition := date_trunc('month', i);
						ELSE
							start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
								from pg_class c
								where relname = previous_partition and 
								(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
						END IF;
	
						IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
							relnamespace::regnamespace::text = quote_ident(org_id)) THEN
							end_of_partition := date_trunc('month', i) + interval '1 month';
						ELSE
							end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
								from pg_class c
								where relname = next_partition and 
								(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
						END IF;
	
						IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
							relnamespace::regnamespace::text = quote_ident(org_id)) THEN
							EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
								|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
								|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
						END IF;
	
						EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
						|| ' SELECT * FROM '|| def_partition ||' WHERE '|| 
						quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
						quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
	
						EXECUTE 'DELETE FROM ' || def_partition || ' WHERE '|| 
						quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
						quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ';';
	
					END LOOP;
	
					EXECUTE 'ALTER TABLE '|| quote_ident (org_id) || '.' || quote_ident(table_name) || ' ATTACH PARTITION ' || def_partition || ' DEFAULT;';
					RETURN;
				END IF;
			END;
	$$;


ALTER FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- TOC entry 693 (class 1255 OID 12185942)
-- Name: fpartitioncretor_for_public_notification_instance(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE 
            def_partition	text;
            i	timestamp without time zone;
            partition_to_create	text;
            previous_partition	text;
            next_partition	text;
            start_of_partition 	timestamp without time zone;
            end_of_partition 	timestamp without time zone;
            schema_name_to_process 	uuid;
        BEGIN
            def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
            
			EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
				|| def_partition || ';';
				
			FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || def_partition || ' GROUP BY "organizationId";'
			LOOP
				EXECUTE 'CREATE TEMPORARY TABLE "' || schema_name_to_process || '" ON COMMIT DROP AS SELECT * FROM "'
				|| schema_name_to_process || '".notification_instance WHERE id IN (SELECT id FROM '|| 
				quote_ident('temp_' || table_name || '_default') ||');';
			END LOOP;
			
			EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
			
            FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
                SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
                ' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
            LOOP
                partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
                previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
                next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
        
                IF NOT EXISTS(
                    SELECT relname FROM pg_class 
                    WHERE relname = previous_partition AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    start_of_partition := date_trunc('month', i);
                ELSE
                    start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                        from pg_class c
                        where relname = previous_partition and 
                        (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
                END IF;
                
                IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    end_of_partition := date_trunc('month', i) + interval '1 month';
                ELSE
                    end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
                        from pg_class c
                        where relname = next_partition and 
                        (relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
                END IF;
                
                IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
                    relnamespace::regnamespace::text = quote_ident(org_id)) THEN
                    EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                        || ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
                        || ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
                END IF;
                
                EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
                || ' SELECT * FROM '|| quote_ident('temp_' || table_name || '_default') ||' WHERE '|| 
                quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
                quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
                
            END LOOP;
            
			FOR schema_name_to_process IN EXECUTE 'SELECT "organizationId" FROM ' || 
			quote_ident('temp_' || table_name || '_default') || ' GROUP BY "organizationId";'
			LOOP
				EXECUTE 'INSERT INTO "' || schema_name_to_process || '".notification_instance SELECT * FROM "'
				|| schema_name_to_process || '" ON CONFLICT DO NOTHING;';
			END LOOP;
			
        RETURN;
        END;
	$$;


ALTER FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- TOC entry 694 (class 1255 OID 12185943)
-- Name: fpartitioncretor_for_schema_notification_event(text, text, text); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE 
				def_partition	text;
				i	timestamp without time zone;
				partition_to_create	text;
				previous_partition	text;
				next_partition	text;
				start_of_partition 	timestamp without time zone;
				end_of_partition 	timestamp without time zone;
			BEGIN
				def_partition := quote_ident(org_id)|| '.' || quote_ident(table_name)|| '_default';
				
				EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || table_name || '_default') || ' ON COMMIT DROP AS SELECT * FROM '
					|| def_partition || ';';
	
				EXECUTE 'CREATE TEMPORARY TABLE ' || quote_ident('temp_' || org_id || '_notification_instance') || ' ON COMMIT DROP AS SELECT * FROM '
					|| quote_ident(org_id) || '.notification_instance'||' WHERE "eventId" IN (SELECT id FROM '|| 
					quote_ident('temp_' || table_name || '_default') ||');';
				
				EXECUTE 'TRUNCATE ' || def_partition || ' CASCADE;';
				
				FOR i IN EXECUTE 'SELECT T.' || quote_ident(partition_key) || ' FROM ( 
					SELECT '|| quote_ident(partition_key)||', ROW_NUMBER() OVER (PARTITION BY date_trunc('|| quote_literal ('month') || 
					' , '|| quote_ident(partition_key) || ')) AS row_num FROM ' || quote_ident('temp_' || table_name || '_default') || ') AS T WHERE T.row_num = 1;'
				LOOP
					partition_to_create := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM i) || lpad ( (EXTRACT (MONTH FROM i))::text, 2 , '0'));
					previous_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '-1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '-1 month')))::text, 2 , '0'));
					next_partition := quote_ident(table_name || '_p' || EXTRACT (YEAR FROM (i + interval '1 month')) || lpad ( (EXTRACT (MONTH FROM (i + interval '1 month')))::text, 2 , '0'));
			
					IF NOT EXISTS(
						SELECT relname FROM pg_class 
						WHERE relname = previous_partition AND 
						relnamespace::regnamespace::text = quote_ident(org_id)) THEN
						start_of_partition := date_trunc('month', i);
					ELSE
						start_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
							from pg_class c
							where relname = previous_partition and 
							(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 2 ) from '\\((.+)\\)');
					END IF;
					
					IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = next_partition AND 
						relnamespace::regnamespace::text = quote_ident(org_id)) THEN
						end_of_partition := date_trunc('month', i) + interval '1 month';
					ELSE
						end_of_partition := substring (split_part((select pg_get_expr (c.relpartbound, c.oid, true)
							from pg_class c
							where relname = next_partition and 
							(relnamespace::regnamespace::text = quote_ident(org_id))), 'TO', 1 ) from '\\((.+)\\)');
					END IF;
					
					IF NOT EXISTS(SELECT relname FROM pg_class WHERE relname = partition_to_create AND 
						relnamespace::regnamespace::text = quote_ident(org_id)) THEN
						EXECUTE 'CREATE TABLE IF NOT EXISTS ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
							|| ' PARTITION OF ' || quote_ident (org_id) || '.' || quote_ident(table_name)
							|| ' FOR VALUES FROM (' || quote_literal (start_of_partition) ||') TO (' || quote_literal(end_of_partition) ||');';
					END IF;
					
					EXECUTE 'INSERT INTO ' || quote_ident(org_id) || '.' || quote_ident(partition_to_create)
					|| ' SELECT * FROM '|| quote_ident('temp_' || table_name || '_default') ||' WHERE '|| 
					quote_ident(partition_key) || ' >= ' || quote_literal(start_of_partition) || ' AND ' || 
					quote_ident(partition_key) || ' < ' || quote_literal(end_of_partition) || ' ON CONFLICT DO NOTHING;';
					
				END LOOP;
	
				EXECUTE 'INSERT INTO ' || quote_ident(org_id) ||'.notification_instance SELECT * FROM '
				|| quote_ident('temp_' || org_id || '_notification_instance') || ' ON CONFLICT DO NOTHING;';
				
			RETURN;
			END;
	$$;


ALTER FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) OWNER TO armonsuper;

--
-- TOC entry 695 (class 1255 OID 12185944)
-- Name: json_append(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_append(data json, insert_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        UNION ALL
        SELECT * FROM json_each(insert_data)
    ) t;
$$;


ALTER FUNCTION public.json_append(data json, insert_data json) OWNER TO armonsuper;

--
-- TOC entry 696 (class 1255 OID 12185945)
-- Name: json_delete(json, text[]); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_delete(data json, keys text[]) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        WHERE key <>ALL(keys)
    ) t;
$$;


ALTER FUNCTION public.json_delete(data json, keys text[]) OWNER TO armonsuper;

--
-- TOC entry 697 (class 1255 OID 12185946)
-- Name: json_merge(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_merge(data json, merge_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH to_merge AS (
            SELECT * FROM json_each(merge_data)
        )
        SELECT *
        FROM json_each(data)
        WHERE key NOT IN (SELECT key FROM to_merge)
        UNION ALL
        SELECT * FROM to_merge
    ) t;
$$;


ALTER FUNCTION public.json_merge(data json, merge_data json) OWNER TO armonsuper;

--
-- TOC entry 676 (class 1255 OID 12185947)
-- Name: json_update(json, json); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.json_update(data json, update_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH old_data AS (
            SELECT * FROM json_each(data)
        ), to_update AS (
            SELECT * FROM json_each(update_data)
            WHERE key IN (SELECT key FROM old_data)
        )
    SELECT * FROM old_data
    WHERE key NOT IN (SELECT key FROM to_update)
    UNION ALL
    SELECT * FROM to_update
) t;
$$;


ALTER FUNCTION public.json_update(data json, update_data json) OWNER TO armonsuper;

--
-- TOC entry 689 (class 1255 OID 12185948)
-- Name: run_for_all_schemas(character varying); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.run_for_all_schemas(query_str character varying) RETURNS TABLE(schema_id text, organization_name text, affected text)
    LANGUAGE plpgsql
    AS $$
    DECLARE
    var_r record;
    affcount integer;
    afftotal integer;
    BEGIN
        affcount := 0;
        afftotal := 0;
        FOR var_r IN( SELECT id, name FROM public."organizationList" )
        LOOP
            EXECUTE REPLACE(query_str, '__TBLSCHM__'::text, quote_ident(var_r.id::text));
            GET DIAGNOSTICS affcount = ROW_COUNT;
            afftotal := afftotal + affcount;
            RETURN QUERY EXECUTE 'SELECT ''' || var_r.id || ''', ''' || var_r.name || ''', ''' || affcount::text || ' rows affected.''';
        END LOOP;
        RETURN QUERY SELECT NULL::text, 'TUM ORGANIZASYONLAR', afftotal::text || ' rows affected.';
    END;
    $$;


ALTER FUNCTION public.run_for_all_schemas(query_str character varying) OWNER TO armonsuper;

--
-- TOC entry 690 (class 1255 OID 12185949)
-- Name: select_for_all_schemas(character varying); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.select_for_all_schemas(query_string character varying) RETURNS TABLE(schema_id text, organization_name text, query_result json)
    LANGUAGE plpgsql
    AS $$
    DECLARE
    var_r record;
    BEGIN
        FOR var_r IN( SELECT id, name FROM public."organizationList" )
        LOOP
            RETURN QUERY EXECUTE 'SELECT ''' || var_r.id || ''', ''' || var_r.name || ''', row_to_json(___sq___.*) FROM ( ' || REPLACE(query_string, '__TBLSCHM__'::text, quote_ident(var_r.id::text)) || ') ___sq___';
        END LOOP;
    END;
    $$;


ALTER FUNCTION public.select_for_all_schemas(query_string character varying) OWNER TO armonsuper;

--
-- TOC entry 691 (class 1255 OID 12185950)
-- Name: zz_notification_instance(); Type: FUNCTION; Schema: public; Owner: armonsuper
--

CREATE FUNCTION public.zz_notification_instance() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'INSERT') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				NEW.id,
				1,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."organizationId",
				NEW.state,
				NEW.note
			);
		ELSIF (TG_OP = 'UPDATE') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				NEW.id,
				2,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."organizationId",
				NEW.state,
				NEW.note
			);    
		ELSIF (TG_OP = 'DELETE') THEN
			INSERT INTO public.zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"organizationId",
				state,
				note
			)
			VALUES(
				OLD.id,
				3,
				_now,
				txid_current(),
				OLD."createdT",
				OLD."organizationId",
				OLD.state,
				OLD.note
			);       
		END IF;    
		RETURN NULL;
	END;
	$$;


ALTER FUNCTION public.zz_notification_instance() OWNER TO armonsuper;

SET default_tablespace = '';

--
-- TOC entry 600 (class 1259 OID 12190182)
-- Name: audit_logs; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.audit_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE public.audit_logs OWNER TO armonsuper;

SET default_table_access_method = heap;

--
-- TOC entry 601 (class 1259 OID 12190185)
-- Name: audit_logs_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.audit_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY public.audit_logs ATTACH PARTITION public.audit_logs_default DEFAULT;


ALTER TABLE public.audit_logs_default OWNER TO armonsuper;

--
-- TOC entry 602 (class 1259 OID 12190323)
-- Name: emailTemplates; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."emailTemplates" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer NOT NULL,
    template text NOT NULL,
    "languageCode" integer DEFAULT 1 NOT NULL
);


ALTER TABLE public."emailTemplates" OWNER TO armonsuper;

--
-- TOC entry 603 (class 1259 OID 12190330)
-- Name: migration; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.migration (
    name character varying(255) NOT NULL,
    "migratedAt" timestamp without time zone NOT NULL
);


ALTER TABLE public.migration OWNER TO armonsuper;

--
-- TOC entry 604 (class 1259 OID 12190333)
-- Name: notification_instance; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
)
PARTITION BY RANGE ("createdT");


ALTER TABLE public.notification_instance OWNER TO armonsuper;

--
-- TOC entry 605 (class 1259 OID 12190337)
-- Name: notification_instance_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
);
ALTER TABLE ONLY public.notification_instance ATTACH PARTITION public.notification_instance_default DEFAULT;


ALTER TABLE public.notification_instance_default OWNER TO armonsuper;

--
-- TOC entry 606 (class 1259 OID 12190344)
-- Name: notification_instance_p202101; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance_p202101 (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
);
ALTER TABLE ONLY public.notification_instance ATTACH PARTITION public.notification_instance_p202101 FOR VALUES FROM ('2021-01-01 00:00:00') TO ('2021-02-01 00:00:00');


ALTER TABLE public.notification_instance_p202101 OWNER TO armonsuper;

--
-- TOC entry 607 (class 1259 OID 12190351)
-- Name: notification_instance_p202102; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.notification_instance_p202102 (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT notification_instance_state_check CHECK ((state = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
);
ALTER TABLE ONLY public.notification_instance ATTACH PARTITION public.notification_instance_p202102 FOR VALUES FROM ('2021-02-01 00:00:00') TO ('2021-03-01 00:00:00');


ALTER TABLE public.notification_instance_p202102 OWNER TO armonsuper;

--
-- TOC entry 608 (class 1259 OID 12190358)
-- Name: oAuthRevokedTokens; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."oAuthRevokedTokens" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    reason character varying(255),
    "tokenId" uuid
);


ALTER TABLE public."oAuthRevokedTokens" OWNER TO armonsuper;

--
-- TOC entry 609 (class 1259 OID 12190361)
-- Name: organizationAuthenticationMethods; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."organizationAuthenticationMethods" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    "authenticationMethod" integer,
    "grantType" integer,
    name character varying(128),
    config json,
    "isDefault" boolean,
    "isHidden" boolean DEFAULT false
);


ALTER TABLE public."organizationAuthenticationMethods" OWNER TO armonsuper;

--
-- TOC entry 610 (class 1259 OID 12190368)
-- Name: organizationList; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."organizationList" (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    code character varying(5),
    logo bytea,
    alias character varying(32)
);


ALTER TABLE public."organizationList" OWNER TO armonsuper;

--
-- TOC entry 611 (class 1259 OID 12190374)
-- Name: scheduledJobHistoryLogs; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."scheduledJobHistoryLogs" (
    id uuid NOT NULL,
    "jobId" uuid,
    name character varying(255),
    "startDate" timestamp with time zone,
    "endDate" timestamp with time zone,
    message character varying(1024),
    success boolean,
    "tryCount" integer,
    "executionDate" timestamp with time zone
);


ALTER TABLE public."scheduledJobHistoryLogs" OWNER TO armonsuper;

--
-- TOC entry 612 (class 1259 OID 12190380)
-- Name: scheduled_job; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.scheduled_job (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    enabled boolean NOT NULL,
    "interval" smallint NOT NULL,
    "firstExecutionDate" timestamp without time zone NOT NULL,
    "nextExecutionDate" timestamp without time zone NOT NULL,
    note character varying(511),
    "notificationId" uuid,
    CONSTRAINT scheduled_job_interval_check CHECK (("interval" = ANY ('{1,2,3,4,5,6,7}'::smallint[])))
);


ALTER TABLE public.scheduled_job OWNER TO armonsuper;

--
-- TOC entry 613 (class 1259 OID 12190387)
-- Name: things; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.things (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    token character varying(255)
);


ALTER TABLE public.things OWNER TO armonsuper;

--
-- TOC entry 614 (class 1259 OID 12190390)
-- Name: userAuthenticationMethods; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userAuthenticationMethods" (
    "userId" uuid NOT NULL,
    "authenticationMethodId" uuid
);


ALTER TABLE public."userAuthenticationMethods" OWNER TO armonsuper;

--
-- TOC entry 615 (class 1259 OID 12190393)
-- Name: userList; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userList" (
    id uuid NOT NULL,
    username character varying(127)
);


ALTER TABLE public."userList" OWNER TO armonsuper;

--
-- TOC entry 616 (class 1259 OID 12190396)
-- Name: userOrganizationMapping; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public."userOrganizationMapping" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL
);


ALTER TABLE public."userOrganizationMapping" OWNER TO armonsuper;

--
-- TOC entry 617 (class 1259 OID 12190399)
-- Name: zz_notification_instance; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.zz_notification_instance (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT zz_notification_instance_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE public.zz_notification_instance OWNER TO armonsuper;

--
-- TOC entry 618 (class 1259 OID 12190403)
-- Name: zz_notification_instance_default; Type: TABLE; Schema: public; Owner: armonsuper
--

CREATE TABLE public.zz_notification_instance_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    state smallint NOT NULL,
    note jsonb,
    CONSTRAINT zz_notification_instance_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY public.zz_notification_instance ATTACH PARTITION public.zz_notification_instance_default DEFAULT;


ALTER TABLE public.zz_notification_instance_default OWNER TO armonsuper;

--
-- TOC entry 4444 (class 2606 OID 12191863)
-- Name: audit_logs audit_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.audit_logs
    ADD CONSTRAINT audit_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4448 (class 2606 OID 12191865)
-- Name: audit_logs_default audit_logs_default_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.audit_logs_default
    ADD CONSTRAINT audit_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4450 (class 2606 OID 12191911)
-- Name: emailTemplates emailTemplates_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."emailTemplates"
    ADD CONSTRAINT "emailTemplates_pkey" PRIMARY KEY (id);


--
-- TOC entry 4452 (class 2606 OID 12191913)
-- Name: migration migration_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.migration
    ADD CONSTRAINT migration_pkey PRIMARY KEY (name);


--
-- TOC entry 4454 (class 2606 OID 12191915)
-- Name: notification_instance notification_instance_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance
    ADD CONSTRAINT notification_instance_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4456 (class 2606 OID 12191917)
-- Name: notification_instance_default notification_instance_default_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance_default
    ADD CONSTRAINT notification_instance_default_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4458 (class 2606 OID 12191919)
-- Name: notification_instance_p202101 notification_instance_p202101_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance_p202101
    ADD CONSTRAINT notification_instance_p202101_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4460 (class 2606 OID 12191921)
-- Name: notification_instance_p202102 notification_instance_p202102_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.notification_instance_p202102
    ADD CONSTRAINT notification_instance_p202102_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4462 (class 2606 OID 12191923)
-- Name: oAuthRevokedTokens oAuthRevokedTokens_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."oAuthRevokedTokens"
    ADD CONSTRAINT "oAuthRevokedTokens_pkey" PRIMARY KEY (id);


--
-- TOC entry 4464 (class 2606 OID 12191925)
-- Name: organizationAuthenticationMethods organizationAuthenticationMethods_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationAuthenticationMethods"
    ADD CONSTRAINT "organizationAuthenticationMethods_pkey" PRIMARY KEY (id);


--
-- TOC entry 4466 (class 2606 OID 12191927)
-- Name: organizationList organizationList_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationList"
    ADD CONSTRAINT "organizationList_pkey" PRIMARY KEY (id);


--
-- TOC entry 4468 (class 2606 OID 12191929)
-- Name: scheduledJobHistoryLogs scheduledJobHistoryLogs_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."scheduledJobHistoryLogs"
    ADD CONSTRAINT "scheduledJobHistoryLogs_pkey" PRIMARY KEY (id);


--
-- TOC entry 4470 (class 2606 OID 12191931)
-- Name: scheduled_job scheduled_job_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_pkey PRIMARY KEY (id);


--
-- TOC entry 4472 (class 2606 OID 12191933)
-- Name: things things_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.things
    ADD CONSTRAINT things_pkey PRIMARY KEY (id);


--
-- TOC entry 4476 (class 2606 OID 12191935)
-- Name: userOrganizationMapping userIdOrganizationId; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userIdOrganizationId" UNIQUE ("userId", "organizationId");


--
-- TOC entry 4474 (class 2606 OID 12191937)
-- Name: userList userList_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userList"
    ADD CONSTRAINT "userList_pkey" PRIMARY KEY (id);


--
-- TOC entry 4478 (class 2606 OID 12191939)
-- Name: userOrganizationMapping userOrganizationId_pkey; Type: CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationId_pkey" PRIMARY KEY (id);


--
-- TOC entry 4445 (class 1259 OID 12193248)
-- Name: idx_gin_log_audit_logs; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX idx_gin_log_audit_logs ON ONLY public.audit_logs USING gin (log);


--
-- TOC entry 4446 (class 1259 OID 12193249)
-- Name: audit_logs_default_log_idx; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX audit_logs_default_log_idx ON public.audit_logs_default USING gin (log);


--
-- TOC entry 4479 (class 1259 OID 12193272)
-- Name: bx_zz_notification_instance; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_instance ON ONLY public.zz_notification_instance USING btree (id DESC NULLS LAST);


--
-- TOC entry 4480 (class 1259 OID 12193274)
-- Name: zz_notification_instance_default_id_idx; Type: INDEX; Schema: public; Owner: armonsuper
--

CREATE INDEX zz_notification_instance_default_id_idx ON public.zz_notification_instance_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 4481 (class 0 OID 0)
-- Name: audit_logs_default_log_idx; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.idx_gin_log_audit_logs ATTACH PARTITION public.audit_logs_default_log_idx;


--
-- TOC entry 4482 (class 0 OID 0)
-- Name: audit_logs_default_pkey; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.audit_logs_pkey ATTACH PARTITION public.audit_logs_default_pkey;


--
-- TOC entry 4483 (class 0 OID 0)
-- Name: notification_instance_default_pkey; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.notification_instance_pkey ATTACH PARTITION public.notification_instance_default_pkey;


--
-- TOC entry 4484 (class 0 OID 0)
-- Name: notification_instance_p202101_pkey; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.notification_instance_pkey ATTACH PARTITION public.notification_instance_p202101_pkey;


--
-- TOC entry 4485 (class 0 OID 0)
-- Name: notification_instance_p202102_pkey; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.notification_instance_pkey ATTACH PARTITION public.notification_instance_p202102_pkey;


--
-- TOC entry 4486 (class 0 OID 0)
-- Name: zz_notification_instance_default_id_idx; Type: INDEX ATTACH; Schema: public; Owner: -
--

ALTER INDEX public.bx_zz_notification_instance ATTACH PARTITION public.zz_notification_instance_default_id_idx;


--
-- TOC entry 4498 (class 2620 OID 12193412)
-- Name: audit_logs_default after_insert_audit_logs_default; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_insert_audit_logs_default AFTER INSERT ON public.audit_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 4500 (class 2620 OID 12193413)
-- Name: notification_instance_default after_insert_notification_instance_default; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_insert_notification_instance_default AFTER INSERT ON public.notification_instance_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 4502 (class 2620 OID 12193414)
-- Name: zz_notification_instance_default after_insert_zz_notification_instance_default; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_instance_default AFTER INSERT ON public.zz_notification_instance_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 4501 (class 2620 OID 12193415)
-- Name: scheduled_job after_up_in_scheduled_job; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER after_up_in_scheduled_job AFTER INSERT OR UPDATE ON public.scheduled_job FOR EACH ROW EXECUTE FUNCTION public.after_up_in_scheduled_job();


--
-- TOC entry 4499 (class 2620 OID 12193416)
-- Name: notification_instance trg_99_zz_notification_instance; Type: TRIGGER; Schema: public; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_instance AFTER INSERT OR DELETE OR UPDATE ON public.notification_instance FOR EACH ROW EXECUTE FUNCTION public.zz_notification_instance();


--
-- TOC entry 4487 (class 2606 OID 12195595)
-- Name: emailTemplates emailTemplates_organizationListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."emailTemplates"
    ADD CONSTRAINT "emailTemplates_organizationListId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;


--
-- TOC entry 4488 (class 2606 OID 12195600)
-- Name: notification_instance notification_instance_organizationId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE public.notification_instance
    ADD CONSTRAINT "notification_instance_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4489 (class 2606 OID 12195612)
-- Name: oAuthRevokedTokens oAuthRevokedTokens_userListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."oAuthRevokedTokens"
    ADD CONSTRAINT "oAuthRevokedTokens_userListId_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;


--
-- TOC entry 4490 (class 2606 OID 12195617)
-- Name: organizationAuthenticationMethods organizationAuthenticationMethods_organizationListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."organizationAuthenticationMethods"
    ADD CONSTRAINT "organizationAuthenticationMethods_organizationListId_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON DELETE CASCADE;


--
-- TOC entry 4491 (class 2606 OID 12195622)
-- Name: scheduled_job scheduled_job_created_by_user_id_user_list_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_created_by_user_id_user_list_id_fk FOREIGN KEY ("createdByUserId") REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4492 (class 2606 OID 12195627)
-- Name: scheduled_job scheduled_job_organization_id_organization_list_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.scheduled_job
    ADD CONSTRAINT scheduled_job_organization_id_organization_list_id_fk FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4493 (class 2606 OID 12195632)
-- Name: things things_organizationid_foreign; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public.things
    ADD CONSTRAINT things_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4494 (class 2606 OID 12195637)
-- Name: userAuthenticationMethods userAuthenticationMethods_organizationAuthenticationMethodsId_f; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userAuthenticationMethods"
    ADD CONSTRAINT "userAuthenticationMethods_organizationAuthenticationMethodsId_f" FOREIGN KEY ("authenticationMethodId") REFERENCES public."organizationAuthenticationMethods"(id) ON DELETE CASCADE;


--
-- TOC entry 4495 (class 2606 OID 12195642)
-- Name: userAuthenticationMethods userAuthenticationMethods_userListId_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userAuthenticationMethods"
    ADD CONSTRAINT "userAuthenticationMethods_userListId_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON DELETE CASCADE;


--
-- TOC entry 4496 (class 2606 OID 12195647)
-- Name: userOrganizationMapping userOrganizationMapping_organizationList_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationMapping_organizationList_fkey" FOREIGN KEY ("organizationId") REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4497 (class 2606 OID 12195652)
-- Name: userOrganizationMapping userOrganizationMapping_userList_fkey; Type: FK CONSTRAINT; Schema: public; Owner: armonsuper
--

ALTER TABLE ONLY public."userOrganizationMapping"
    ADD CONSTRAINT "userOrganizationMapping_userList_fkey" FOREIGN KEY ("userId") REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4647 (class 0 OID 0)
-- Dependencies: 6
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: armonsuper
--
CREATE USER armonapi;
-- REVOKE ALL ON SCHEMA public FROM postgres;
REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO armonsuper;
GRANT ALL ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA public TO armonapi;


--
-- TOC entry 4648 (class 0 OID 0)
-- Dependencies: 677
-- Name: FUNCTION after_insert_default(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.after_insert_default() TO armonapi;


--
-- TOC entry 4649 (class 0 OID 0)
-- Dependencies: 678
-- Name: FUNCTION after_up_in_scheduled_job(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.after_up_in_scheduled_job() TO armonapi;


--
-- TOC entry 4650 (class 0 OID 0)
-- Dependencies: 679
-- Name: FUNCTION clone_schema(source_schema text, dest_schema text, include_recs boolean); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.clone_schema(source_schema text, dest_schema text, include_recs boolean) TO armonapi;


--
-- TOC entry 4651 (class 0 OID 0)
-- Dependencies: 692
-- Name: FUNCTION fpartitioncreator(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncreator(org_id text, table_name text, partition_key text) TO armonapi;


--
-- TOC entry 4652 (class 0 OID 0)
-- Dependencies: 693
-- Name: FUNCTION fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncretor_for_public_notification_instance(org_id text, table_name text, partition_key text) TO armonapi;


--
-- TOC entry 4653 (class 0 OID 0)
-- Dependencies: 694
-- Name: FUNCTION fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.fpartitioncretor_for_schema_notification_event(org_id text, table_name text, partition_key text) TO armonapi;


--
-- TOC entry 4654 (class 0 OID 0)
-- Dependencies: 695
-- Name: FUNCTION json_append(data json, insert_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_append(data json, insert_data json) TO armonapi;


--
-- TOC entry 4655 (class 0 OID 0)
-- Dependencies: 696
-- Name: FUNCTION json_delete(data json, keys text[]); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_delete(data json, keys text[]) TO armonapi;


--
-- TOC entry 4656 (class 0 OID 0)
-- Dependencies: 697
-- Name: FUNCTION json_merge(data json, merge_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_merge(data json, merge_data json) TO armonapi;


--
-- TOC entry 4657 (class 0 OID 0)
-- Dependencies: 676
-- Name: FUNCTION json_update(data json, update_data json); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.json_update(data json, update_data json) TO armonapi;


--
-- TOC entry 4658 (class 0 OID 0)
-- Dependencies: 689
-- Name: FUNCTION run_for_all_schemas(query_str character varying); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.run_for_all_schemas(query_str character varying) TO armonapi;


--
-- TOC entry 4659 (class 0 OID 0)
-- Dependencies: 690
-- Name: FUNCTION select_for_all_schemas(query_string character varying); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.select_for_all_schemas(query_string character varying) TO armonapi;


--
-- TOC entry 4660 (class 0 OID 0)
-- Dependencies: 691
-- Name: FUNCTION zz_notification_instance(); Type: ACL; Schema: public; Owner: armonsuper
--

GRANT ALL ON FUNCTION public.zz_notification_instance() TO armonapi;


--
-- TOC entry 4661 (class 0 OID 0)
-- Dependencies: 600
-- Name: TABLE audit_logs; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.audit_logs TO armonapi;


--
-- TOC entry 4662 (class 0 OID 0)
-- Dependencies: 601
-- Name: TABLE audit_logs_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.audit_logs_default TO armonapi;


--
-- TOC entry 4663 (class 0 OID 0)
-- Dependencies: 602
-- Name: TABLE "emailTemplates"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."emailTemplates" TO armonapi;


--
-- TOC entry 4664 (class 0 OID 0)
-- Dependencies: 603
-- Name: TABLE migration; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.migration TO armonapi;


--
-- TOC entry 4665 (class 0 OID 0)
-- Dependencies: 604
-- Name: TABLE notification_instance; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance TO armonapi;


--
-- TOC entry 4666 (class 0 OID 0)
-- Dependencies: 605
-- Name: TABLE notification_instance_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance_default TO armonapi;


--
-- TOC entry 4667 (class 0 OID 0)
-- Dependencies: 606
-- Name: TABLE notification_instance_p202101; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance_p202101 TO armonapi;


--
-- TOC entry 4668 (class 0 OID 0)
-- Dependencies: 607
-- Name: TABLE notification_instance_p202102; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.notification_instance_p202102 TO armonapi;


--
-- TOC entry 4669 (class 0 OID 0)
-- Dependencies: 608
-- Name: TABLE "oAuthRevokedTokens"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."oAuthRevokedTokens" TO armonapi;


--
-- TOC entry 4670 (class 0 OID 0)
-- Dependencies: 609
-- Name: TABLE "organizationAuthenticationMethods"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."organizationAuthenticationMethods" TO armonapi;


--
-- TOC entry 4671 (class 0 OID 0)
-- Dependencies: 610
-- Name: TABLE "organizationList"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."organizationList" TO armonapi;


--
-- TOC entry 4672 (class 0 OID 0)
-- Dependencies: 611
-- Name: TABLE "scheduledJobHistoryLogs"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."scheduledJobHistoryLogs" TO armonapi;


--
-- TOC entry 4673 (class 0 OID 0)
-- Dependencies: 612
-- Name: TABLE scheduled_job; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.scheduled_job TO armonapi;


--
-- TOC entry 4674 (class 0 OID 0)
-- Dependencies: 613
-- Name: TABLE things; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.things TO armonapi;


--
-- TOC entry 4675 (class 0 OID 0)
-- Dependencies: 614
-- Name: TABLE "userAuthenticationMethods"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userAuthenticationMethods" TO armonapi;


--
-- TOC entry 4676 (class 0 OID 0)
-- Dependencies: 615
-- Name: TABLE "userList"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userList" TO armonapi;


--
-- TOC entry 4677 (class 0 OID 0)
-- Dependencies: 616
-- Name: TABLE "userOrganizationMapping"; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public."userOrganizationMapping" TO armonapi;


--
-- TOC entry 4678 (class 0 OID 0)
-- Dependencies: 617
-- Name: TABLE zz_notification_instance; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.zz_notification_instance TO armonapi;


--
-- TOC entry 4679 (class 0 OID 0)
-- Dependencies: 618
-- Name: TABLE zz_notification_instance_default; Type: ACL; Schema: public; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.zz_notification_instance_default TO armonapi;


--
-- TOC entry 3336 (class 826 OID 12265814)
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON SEQUENCES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT SELECT ON SEQUENCES  TO armonapi;


--
-- TOC entry 3337 (class 826 OID 12265815)
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON FUNCTIONS  FROM PUBLIC;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON FUNCTIONS  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT ALL ON FUNCTIONS  TO armonapi;


--
-- TOC entry 3335 (class 826 OID 12265813)
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: public; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public REVOKE ALL ON TABLES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA public GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES  TO armonapi;


CREATE SCHEMA IF NOT EXISTS  organization;


ALTER SCHEMA organization OWNER TO armonsuper;

--
-- TOC entry 787 (class 1255 OID 12265839)
-- Name: add_recalculate_records_for_ppermission_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_ppermission_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
    IF (TG_OP = 'INSERT') THEN

        RETURN NEW;
    ELSIF (TG_OP = 'UPDATE') THEN
        IF ( tstzRange(OLD."startDateTime", OLD."endDateTime") = tstzRange(NEW."startDateTime", NEW."endDateTime") AND OLD."status" = NEW."status") THEN
            RETURN NEW;
        ELSE
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization."userPPermissions" upp
            WHERE upp."ppermissionId" = NEW."id" AND eld."userId" = upp."userId" AND eld."organizationId" = NEW."organizationId"
            AND (NEW."startDateTime"::date <= now()::date OR OLD."startDateTime"::date <= now()::date)
            -- Make sure that status is newly approved or taken out from approved
            AND (((NEW."status" = 1 OR OLD."status" = 1) AND NEW."status" <> OLD."status")
                -- If the status did not change but is approved, check if the dates changed
                OR ((tstzRange(NEW."startDateTime", NEW."endDateTime") <> tstzRange(OLD."startDateTime", OLD."endDateTime"))AND NEW."status" = 1));

            INSERT INTO organization."recalculateWorkQueue"
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
            INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE
            -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.
                NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                -- Make sure that status is newly approved or taken out from approved
                AND (NEW."status" = 1 OR OLD."status" = 1);

            IF tstzRange(OLD."startDateTime", OLD."endDateTime") <> tstzRange(NEW."startDateTime", NEW."endDateTime") THEN
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16,
                    LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE 
                -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
                    NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                    -- Make sure that status is newly approved or taken out from approved
                    AND (NEW."status" = 1 OR OLD."status" = 1);
            END IF;
        END IF;
        RETURN NEW;
    ELSIF (TG_OP = 'DELETE') THEN
        UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
        FROM organization."userPPermissions" upp
        WHERE upp."ppermissionId" = OLD."id" AND eld."userId" = upp."userId" AND eld."organizationId" = OLD."organizationId"
        AND OLD."startDateTime"::date <= now()::date
        -- Make sure that status is newly approved or taken out from approved
        AND OLD."status" = 1;

        INSERT INTO organization."recalculateWorkQueue"
        (id, "userId", "organizationId", reason, "startDate")
        SELECT uuid_generate_v4(), upp."userId", OLD."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
        FROM organization."userWorkPlans" uwp
        INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
        INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
        INNER JOIN organization."userPPermissions" upp ON upp."ppermissionId" = OLD."id" AND uwp."userId" = upp."userId"
        INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
            AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
        WHERE 
        -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
            NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
            -- Make sure that status is newly approved or taken out from approved
            AND OLD."status" = 1;

        RETURN OLD;
    END IF;
    END;
    $$;


ALTER FUNCTION organization.add_recalculate_records_for_ppermission_change() OWNER TO armonsuper;

--
-- TOC entry 686 (class 1255 OID 12185886)
-- Name: add_recalculate_records_for_user_ppermission_add_delete(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization.ppermissions pp
            WHERE pp."id" = NEW."ppermissionId" AND eld."userId" = NEW."userId" AND eld."organizationId" = pp."organizationId"
            AND pp."status" = 1 AND tstzRange(pp."startDateTime", pp."endDateTime") && tstzRange(eld."startAt", eld."expiredAt");
            
            INSERT INTO organization."recalculateWorkQueue" 
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), NEW."userId", pp."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization.ppermissions pp ON pp.id = NEW."ppermissionId" AND wp."organizationId" = pp."organizationId"
			INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND wp."organizationId" = uo."organizationId"
				AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE uwp."userId" = NEW."userId" AND pp."status" = 1
            AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"));
            
            RETURN NEW;
        ELSIF (TG_OP = 'DELETE') THEN
            UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM organization.ppermissions pp
            WHERE pp."id" = OLD."ppermissionId" AND eld."userId" = OLD."userId" AND eld."organizationId" = pp."organizationId"
            AND pp."status" = 1 AND tstzRange(pp."startDateTime", pp."endDateTime") && tstzRange(eld."startAt", eld."expiredAt");
            
            INSERT INTO organization."recalculateWorkQueue" 
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), OLD."userId", pp."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
            FROM organization."userWorkPlans" uwp
            INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN organization.ppermissions pp ON pp.id = OLD."ppermissionId" AND wp."organizationId" = pp."organizationId"
			INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND wp."organizationId" = uo."organizationId"
				AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE uwp."userId" = OLD."userId" AND pp."status" = 1
            AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"));
            
            RETURN OLD;
        END IF;
        END;
        $$;


ALTER FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() OWNER TO armonsuper;

--
-- TOC entry 745 (class 1255 OID 12185887)
-- Name: add_recalculate_records_for_vacation_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.add_recalculate_records_for_vacation_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
            IF(TG_OP = 'UPDATE' AND OLD."startDateTime" = NEW."startDateTime" AND OLD."endDateTime" = NEW."endDateTime") THEN
                RETURN NEW;
            END IF;
            
            IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
                UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 256, "updateRequiredRaisedAt" = now()
                FROM
                (SELECT "organizationId", "userId", "startAt", "expiredAt", (wpid.value->>0)::uuid AS "workPlanId"
                FROM
                organization."employeeLiveDay", jsonb_array_elements("workPlanIds") as wpid) T1
                INNER JOIN organization."workPlans" wp ON (wp."id"= T1."workPlanId")
                AND (wp."ignoreHolidays" is NULL OR wp."ignoreHolidays" is false) AND wp."deletedAt" IS NULL
                AND wp."organizationId" = T1."organizationId" AND wp."organizationId" = NEW."organizationId"
                AND T1."organizationId" = NEW."organizationId"
                WHERE eld."organizationId" = NEW."organizationId";
                
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), uwp."userId", NEW."organizationId", 256, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId" AND wp."organizationId" = NEW."organizationId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"));
                -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.	

            END IF;
            IF (TG_OP = 'UPDATE' OR TG_OP = 'DELETE') THEN
                UPDATE organization."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 256, "updateRequiredRaisedAt" = now()
                FROM
                (SELECT "organizationId", "userId", "startAt", "expiredAt", (wpid.value->>0)::uuid AS "workPlanId"
                FROM
                organization."employeeLiveDay", jsonb_array_elements("workPlanIds") as wpid) T1
                INNER JOIN organization."workPlans" wp ON (wp."id"= T1."workPlanId")
                AND (wp."ignoreHolidays" is NULL OR wp."ignoreHolidays" is false) AND wp."deletedAt" IS NULL
                AND wp."organizationId" = T1."organizationId" AND wp."organizationId" = OLD."organizationId"
                AND T1."organizationId" = OLD."organizationId"
                WHERE eld."organizationId" = OLD."organizationId";
                
                INSERT INTO organization."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), uwp."userId", OLD."organizationId", 256, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
                FROM organization."userWorkPlans" uwp
                INNER JOIN organization."workPlans" wp ON wp."id" = uwp."workPlanId" AND wp."organizationId" = OLD."organizationId"
                INNER JOIN organization."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN organization."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"));
            END IF;
            IF TG_OP = 'INSERT' OR TG_OP = 'UPDATE' THEN
                RETURN NEW;
            ELSE
                RETURN OLD;
            END IF;
        END;
        $$;


ALTER FUNCTION organization.add_recalculate_records_for_vacation_change() OWNER TO armonsuper;

--
-- TOC entry 746 (class 1255 OID 12185888)
-- Name: after_in_up_del_anti_passback_state(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_in_up_del_anti_passback_state() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

    DECLARE
        data_object		 	json;
        related_device_ids 	uuid[];
        res					text;
        region_id			uuid;
    BEGIN
		IF (TG_OP = 'DELETE') THEN
			region_id := OLD."regionId";
        ELSIF (TG_OP = 'INSERT') THEN
			region_id := NEW."regionId";
        ELSIF (TG_OP = 'UPDATE') THEN
			region_id := NEW."regionId";
        END IF;
		
		IF ((SELECT "antiPassback" FROM organization."regions" WHERE id = region_id) != TRUE) THEN
			RETURN NULL;
		END IF;
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId") FROM (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."userAccessRights" as uar
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE racp."regionId" = OLD."regionId" AND
                        acp."deletedAt" IS NULL AND
                        uar."userId" = OLD."userId" AND
                        uar."deletedAt" IS NULL AND
						acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = OLD."accessControlPointId")
            ) AS T INTO related_device_ids
            WHERE T.row_num = 1;
            data_object := JSON_BUILD_OBJECT(
                'userId', OLD."userId",
                'regionId', OLD."regionId",
                'state', 0,
                'actionDateISO', now());
        ELSIF (TG_OP = 'INSERT') THEN
            SELECT ARRAY_AGG(T."deviceId") FROM (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."userAccessRights" as uar
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE racp."regionId" = NEW."regionId" AND
                        acp."deletedAt" IS NULL AND
                        uar."userId" = NEW."userId" AND
                        uar."deletedAt" IS NULL AND
						acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."accessControlPointId")
            ) AS T INTO related_device_ids
            WHERE T.row_num = 1;
            data_object := JSON_BUILD_OBJECT(
                'userId', NEW."userId",
                'regionId', NEW."regionId",
                'state', NEW."state",
                'actionDateISO', NEW."actionUtc",
                'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
                'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (OLD."userId" != NEW."userId" OR OLD."regionId" != NEW."regionId") THEN
                RETURN NULL;
            END IF;
            SELECT ARRAY_AGG(T."deviceId") FROM (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."userAccessRights" as uar
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE racp."regionId" = NEW."regionId" AND
                        acp."deletedAt" IS NULL AND
                        uar."userId" = NEW."userId" AND
                        uar."deletedAt" IS NULL AND
						acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."accessControlPointId")
            ) AS T INTO related_device_ids
            WHERE T.row_num = 1;

            data_object := JSON_BUILD_OBJECT(
                    'userId', NEW."userId",
                    'regionId', NEW."regionId",
                    'state', NEW."state",
                    'actionDateISO', NEW."actionUtc",
                    'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
                    'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
        END IF;
        res :=JSON_BUILD_OBJECT(
                    'data', data_object,
                    'relatedDeviceIds', related_device_ids,
					'organizationId', TG_TABLE_SCHEMA)::text;
        PERFORM PG_NOTIFY('region_state_changes', res);
        RETURN NULL;
    END;
$$;


ALTER FUNCTION organization.after_in_up_del_anti_passback_state() OWNER TO armonsuper;

--
-- TOC entry 747 (class 1255 OID 12185889)
-- Name: after_insert_terminal_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_insert_terminal_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
        INSERT INTO organization."terminalChangeTransactions"
        ("transactionId", "deviceId", "createdAt")
        VALUES (NEW."transactionId", NEW."deviceId", now())
        ON CONFLICT ON CONSTRAINT "terminalChangeTransactions_pkey" DO NOTHING;

        RETURN NULL;
    END;
$$;


ALTER FUNCTION organization.after_insert_terminal_change() OWNER TO armonsuper;

--
-- TOC entry 748 (class 1255 OID 12185890)
-- Name: after_insert_terminal_transaction(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_insert_terminal_transaction() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

    DECLARE
        device_id 	text;
    BEGIN
        device_id:= NEW."deviceId"::text;
        PERFORM PG_NOTIFY('terminal_changes', device_id);
        RETURN NULL;
    END;
$$;


ALTER FUNCTION organization.after_insert_terminal_transaction() OWNER TO armonsuper;

--
-- TOC entry 749 (class 1255 OID 12185891)
-- Name: after_update_organization_settings(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.after_update_organization_settings() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            organization_id 	text;
        BEGIN
            organization_id:= NEW.id:: text;
            PERFORM PG_NOTIFY('organization_settings_changed', organization_id);
            RETURN NULL;
        END;
    $$;


ALTER FUNCTION organization.after_update_organization_settings() OWNER TO armonsuper;

--
-- TOC entry 731 (class 1255 OID 12185892)
-- Name: before_insert_terminal_change(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_insert_terminal_change() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            config_change_count 	int;
        BEGIN
            IF (NEW."deviceId" IS NULL OR (SELECT COUNT(*) FROM organization."devices" WHERE id = NEW."deviceId") = 0) THEN
                RETURN NULL;
            END IF;
            IF (NEW."type" = 3)
            THEN
                SELECT COUNT(*) AS "count"
                FROM organization."terminalChanges"
                WHERE "sessionId" IS NULL AND 
                    "deviceId" = NEW."deviceId" AND
                    "type" = NEW."type"
                INTO config_change_count;
                IF (config_change_count != 0)
                    THEN
                    RETURN NULL;
                ELSE
                    RETURN NEW;
                END IF;
            END IF;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.before_insert_terminal_change() OWNER TO armonsuper;

--
-- TOC entry 751 (class 1255 OID 12185893)
-- Name: before_up_del_regions(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_regions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list	uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
			
			SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
			FROM organization."accessControlPoints" AS acp
			INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
			WHERE acp."deletedAt" IS NULL AND
				racp."regionId" = OLD."id"
			INTO device_id_list;
			
			IF (device_id_list IS NOT NULL) THEN
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
			END IF;
			RETURN OLD;
		ELSE
			IF (OLD."organizationId" != NEW."organizationId") THEN
				RAISE EXCEPTION 'Organization ID of region cannot be changed!';
			END IF;
			SELECT ARRAY_AGG(DISTINCT(acp."deviceId")) 
			FROM organization."accessControlPoints" AS acp
			INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
			WHERE acp."deletedAt" IS NULL AND
				racp."regionId" = OLD."id"
			INTO device_id_list;
			
			IF (device_id_list IS NOT NULL) THEN
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);
			END IF;
			RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_del_regions() OWNER TO armonsuper;

--
-- TOC entry 752 (class 1255 OID 12185894)
-- Name: before_up_del_user(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_user() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."id";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
            FROM
            (
                SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE u."id" = user_id
                -- GROUP BY acp."deviceId", u."id"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE u."id" = user_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (NEW."publicKey" = OLD."publicKey")
            THEN
                RETURN NEW;
            ELSE
                    user_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                FROM
                (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'id', u."id",
                    'roleId', uo."roleId",
                    'isDisabled', uo."isDisabled",
                    'publicKey', NEW."publicKey",
                    'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                ) AS "data" FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."roles" AS r ON uo."roleId" = r."id"
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE u."id" = user_id
                --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_del_user() OWNER TO armonsuper;

--
-- TOC entry 754 (class 1255 OID 12185895)
-- Name: before_up_del_user_organizations(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_del_user_organizations() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_organization_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_organization_id:= OLD."id";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
            FROM
            (
                SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId", u."id"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_organization_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 6, T."data"
                FROM
                (
                    SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT('id', u."id") AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (NEW."roleId" != OLD."roleId" OR NEW."isDisabled" != OLD."isDisabled")
            THEN
                user_organization_id:= NEW."id";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 9, T."data"
                FROM
                (SELECT acp."deviceId", u."id" AS "userId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'id', u."id",
                    'roleId', NEW."roleId",
                    'isDisabled', NEW."isDisabled",
                    'publicKey', u."publicKey",
                    'isVisitor', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END)
                ) AS "data" FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."roles" AS r ON uo."roleId" = r."id"
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId", u."id"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_del_user_organizations() OWNER TO armonsuper;

--
-- TOC entry 755 (class 1255 OID 12185896)
-- Name: before_up_in_del_access_control_point(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_access_control_point() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            DECLARE
                transaction_id			uuid;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                new_available_factors		jsonb;
                factors_in_other_acps		jsonb;
                old_available_factors		jsonb;
                new_added_factors			jsonb;
                removed_factors				jsonb;
                factors_to_send_to_device		jsonb;
                t1					jsonb;
            BEGIN
        
                transaction_id := uuid_generate_v4();
                new_available_factors := '[]'::jsonb;
                factors_in_other_acps := '[]'::jsonb;
                old_available_factors := '[]'::jsonb;
                new_added_factors := '[]'::jsonb;
                removed_factors := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                
                 IF (TG_OP = 'DELETE') THEN
                 
                     INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                
                    IF NEW."organizationId" != OLD."organizationId" THEN
                        RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                    END IF;
    
                    IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF NEW."deviceId" != OLD."deviceId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                    END IF;
    
                    IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                        RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                    END IF;
                    -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            new_available_factors:= new_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            old_available_factors:= old_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                    FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                        FROM organization."accessControlPoints" AS acp
                        WHERE acp."deletedAt" IS NULL
                        AND acp."deviceId" = NEW."deviceId"
                        AND acp."id" != NEW."id"
                        AND acp."authenticationFactors" IS NOT NULL))
                    LOOP
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            j := j->'and';
                            FOR l IN SELECT * FROM jsonb_array_elements(j)
                            LOOP
                                t1:= jsonb_build_object(
                                    'authenticatorType', "l"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                THEN
                                    factors_in_other_acps:= factors_in_other_acps || t1;
                                END IF;
                            END LOOP;
                        END LOOP;
                    END LOOP;
    
                    -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (new_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                        LOOP
                            IF (POSITION (i::text IN old_available_factors::text) < 1)
                            THEN
                                new_added_factors:= new_added_factors || i;
                            END IF;
                        END LOOP;
                    END IF;
    
                    -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (old_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                        LOOP
                            IF (POSITION (i::text IN new_available_factors::text) < 1)
                            THEN
                                removed_factors:= removed_factors || i;
                            END IF;
                        END LOOP; 
                    END IF;
    
                    -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                    IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                 AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                           OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                        OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
    
                       )
                    THEN
                        INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
    
                    -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                    IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                    THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                        LOOP
                            IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionDateISO", 1 as "type",
                        json_build_object(
                            'id', T."id",
                            'userId', T."userId",
                            'type', T."type",
                            'data', T."data",
                            'groupNumber', T."groupNumber",
                            'specialData', T."specialData",
                            'specialDataSecondary', T."specialDataSecondary",
                            'expiresOnISO', T."expiresOn",
                            'extensionFields', T."extensionFields"
                        ) AS "data" FROM
                        (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                            uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                        FROM organization."userAccessRights" AS uar
                        INNER JOIN organization."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                        INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                        INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                        WHERE uar."accessControlPointId" = NEW."id"
                        AND uar."deletedAt" IS NULL 
                        AND uoc."deletedAt" IS NULL
                        AND uoc."organizationId" = NEW."organizationId"
                        AND uar."access" = TRUE
                        AND POSITION(jsonb_build_object(
                            'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                            'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_del_access_control_point() OWNER TO armonsuper;

--
-- TOC entry 756 (class 1255 OID 12185898)
-- Name: before_up_in_del_camera(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_camera() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    camera_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            camera_id:= OLD."id";
        ELSE
            camera_id:= NEW."id";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."cameras" AS c
        INNER JOIN organization."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
        INNER JOIN organization."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_camera() OWNER TO armonsuper;

--
-- TOC entry 757 (class 1255 OID 12185899)
-- Name: before_up_in_del_camera_actions(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_camera_actions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    camera_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            camera_id:= OLD."cameraId";
        ELSE
            camera_id:= NEW."cameraId";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."cameras" AS c
        INNER JOIN organization."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
        INNER JOIN organization."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_camera_actions() OWNER TO armonsuper;

--
-- TOC entry 758 (class 1255 OID 12185900)
-- Name: before_up_in_del_device_dry_contact_inputs(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_dry_contact_inputs() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
        transaction_id	uuid;
        device_id 		uuid;
        main_device_id 		uuid;
        BEGIN
            transaction_id := uuid_generate_v4();
            IF (TG_OP = 'DELETE') THEN
                device_id:= OLD."deviceId";
            ELSE
                device_id:= NEW."deviceId";
            END IF;
            
            SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
            INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
                    
            SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
            INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
            WHERE h."deviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            SELECT "integratedDeviceId" INTO main_device_id FROM organization."deviceIntegrations" WHERE "integratingDeviceId" = device_id;
            IF (main_device_id IS NOT NULL) THEN
                device_id := main_device_id;
            END IF;
            
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
    
            IF (TG_OP = 'DELETE') THEN
                RETURN OLD;
            ELSE
                RETURN NEW;
            END IF;
    
        END;
    $$;


ALTER FUNCTION organization.before_up_in_del_device_dry_contact_inputs() OWNER TO armonsuper;

--
-- TOC entry 741 (class 1255 OID 12185901)
-- Name: before_up_in_del_device_readers(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_readers() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id 		uuid;
    main_device_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            device_id:= OLD."deviceId";
        ELSE
            device_id:= NEW."deviceId";
        END IF;
        
        SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
                
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_device_readers() OWNER TO armonsuper;

--
-- TOC entry 761 (class 1255 OID 12185902)
-- Name: before_up_in_del_device_relays(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_device_relays() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id 		uuid;
    main_device_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            device_id:= OLD."deviceId";
        ELSE
            device_id:= NEW."deviceId";
        END IF;
        
        SELECT "mainControlPanelId" INTO main_device_id FROM organization."controlPanelESeriesSettings" WHERE "deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT "hubDeviceId" INTO main_device_id FROM organization."aperioLocks" WHERE "lockDeviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."hikVisionLicencePlateCameraLanes" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
                
        SELECT acp."deviceId" INTO main_device_id FROM organization."accessControlPoints" AS acp
        INNER JOIN organization."impinjSpeedWayGateWayAntennas" AS h ON h."accessControlPointId" = acp.id
        WHERE h."deviceId" = device_id;
        IF (main_device_id IS NOT NULL) THEN
            device_id := main_device_id;
        END IF;
        
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_device_relays() OWNER TO armonsuper;

--
-- TOC entry 762 (class 1255 OID 12185903)
-- Name: before_up_in_del_notification_access(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_notification_access() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id 	uuid;
			res 			text;
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					IF (OLD."targetUserId" IS NOT NULL) THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', OLD."id"
							) AS "data"
							FROM organization."userOrganizations" AS uo
							INNER JOIN organization."users" AS u ON uo."userId" = u."id"
							INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
							INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
							INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
							WHERE uo."userId" = OLD."targetUserId"
								AND uo."deletedAt" IS NULL
								AND u."deletedAt" IS NULL
								AND uar."deletedAt" IS NULL
								AND acp."deletedAt" IS NULL
								AND racp."regionId" = OLD."regionId"
						) AS T
						WHERE T."row_num" = 1;
					ELSE
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', OLD."id"
							) AS "data"
							FROM organization."accessControlPoints" AS acp
							INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = OLD."regionId"
								AND  acp."deletedAt" IS NULL
						) AS T
						WHERE T."row_num" = 1;
					END IF;
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', to_jsonb(row_to_json(OLD)),
						'new', null
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_access', res);                
					RETURN OLD;
				ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
					-- access notification for single user
					IF (NEW."targetUserId" IS NOT NULL) THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', NEW."id",
								't', NEW."targetUserId",
								'r', NEW."regionId",
								's', NEW.options->'success',
								'd', NEW.options->'direction'
							) AS "data"
							FROM organization."userOrganizations" AS uo
							INNER JOIN organization."users" AS u ON uo."userId" = u."id"
							INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
							INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
							INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
							WHERE uo."userId" = NEW."targetUserId"
								AND uo."deletedAt" IS NULL
								AND u."deletedAt" IS NULL
								AND uar."deletedAt" IS NULL
								AND acp."deletedAt" IS NULL
								AND racp."regionId" = NEW."regionId"
						) AS T
						WHERE T."row_num" = 1;
					-- access notification all users
					ELSE
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
						FROM
						(
							SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
							JSON_BUILD_OBJECT(
								'id', NEW."id",
								't', NEW."targetUserId",
								'r', NEW."regionId",
								's', NEW.options->'success',
								'd', NEW.options->'direction'
							) AS "data"
							FROM organization."accessControlPoints" AS acp
							INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = NEW."regionId"
								AND  acp."deletedAt" IS NULL
						) AS T
						WHERE T."row_num" = 1;
					END IF;
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
						'new', to_jsonb(row_to_json(NEW))
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_access', res);
					RETURN NEW;
				END IF;
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_notification_access() OWNER TO armonsuper;

--
-- TOC entry 763 (class 1255 OID 12185904)
-- Name: before_up_in_del_notification_sensor(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_notification_sensor() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id	uuid;
			access_control_point_id uuid;
				res	text;
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					access_control_point_id:= OLD."accessControlPointId";
				ELSE
					access_control_point_id:= NEW."accessControlPointId";
				END IF;
				INSERT INTO organization."terminalChanges"
				("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
				SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
				FROM organization."accessControlPoints" AS acp
				WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;
				
				IF (TG_OP = 'DELETE') THEN
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', to_jsonb(row_to_json(OLD)),
						'new', null
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_sensor', res);
					RETURN OLD;
				ELSE
					res := JSONB_BUILD_OBJECT(
						'oid', TG_TABLE_SCHEMA::text,
						'old', CASE WHEN TG_OP = 'INSERT' THEN null ELSE to_jsonb(row_to_json(OLD)) END,
						'new', to_jsonb(row_to_json(NEW))
					)::text;
					PERFORM PG_NOTIFY('terminal_notification_sensor',res);            
					RETURN NEW;
				END IF;    
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_notification_sensor() OWNER TO armonsuper;

--
-- TOC entry 764 (class 1255 OID 12185905)
-- Name: before_up_in_del_o_auth_tokens(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_o_auth_tokens() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
    transaction_id	uuid;
    credential_exists	boolean;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
                DELETE FROM organization."userOrganizationCredentials" AS uoc
                WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                -- 2 for BLE, 8 for NFC, 12 for QR
            END IF;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
            -- delete credentials
                DELETE FROM organization."userOrganizationCredentials" AS uoc
                WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
                RETURN NEW;
            ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
				   (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL)) THEN
            -- delete old credentials
            -- insert new credentials
                DELETE FROM organization."userOrganizationCredentials" AS uoc
                WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);

                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);

                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);

                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);

                RETURN NEW;
            ELSE

            END IF;
        ELSIF (TG_OP = 'INSERT') THEN
            -- check existing credentials
            SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
                organization."userOrganizationCredentials" AS uoc
                WHERE uoc."deletedAt" IS NULL AND
                        uoc."userId" = NEW."userId" AND
                        (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
            INTO credential_exists;
            -- if no credentials present, then create 2 credentials for BLE and NFC
            IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);

                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
            
			
                INSERT INTO organization."userOrganizationCredentials"
                VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);

			END IF;
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_o_auth_tokens() OWNER TO armonsuper;

--
-- TOC entry 765 (class 1255 OID 12185906)
-- Name: before_up_in_del_region_access_control_points(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_region_access_control_points() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
			SELECT "deviceId" 
			FROM organization."accessControlPoints"
			WHERE "deletedAt" IS NULL AND "id" = OLD."accessControlPointId"
			INTO device_id;
		ELSIF (TG_OP = 'UPDATE') THEN
			RAISE EXCEPTION 'Illegal operation to update region/accessControlPoint mapping';
        ELSE
			SELECT "deviceId" 
			FROM organization."accessControlPoints"
			WHERE "deletedAt" IS NULL AND "id" = NEW."accessControlPointId"
			INTO device_id;
		END IF;
		
		IF (device_id IS NOT NULL) THEN
			INSERT INTO organization."terminalChanges"
			("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
			VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);
		END IF;
		
		IF (TG_OP = 'DELETE') THEN
			RETURN OLD;
        ELSE
			RETURN NEW;
		END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_region_access_control_points() OWNER TO armonsuper;

--
-- TOC entry 766 (class 1255 OID 12185907)
-- Name: before_up_in_del_user_access_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_access_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        transaction_id				uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            IF (OLD."targetUserId" IS NOT NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id"
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE uo."userId" = OLD."targetUserId"
                        AND uo."organizationId" = OLD."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND u."deletedAt" IS NULL
                        AND uar."deletedAt" IS NULL
                        AND acp."deletedAt" IS NULL
                        AND racp."regionId" = OLD."regionId"
                ) AS T
                WHERE T."row_num" = 1;
            ELSE
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 21, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                    WHERE acp."organizationId" = OLD."organizationId"
                        AND racp."regionId" = OLD."regionId"
                        AND  acp."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN OLD;
        ELSIF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
            -- access notification for single user
            IF (NEW."targetUserId" IS NOT NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        't', NEW."targetUserId",
                        'r', NEW."regionId",
                        's', NEW."success",
                        'd', NEW."direction"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id"
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId"
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id"
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE uo."userId" = NEW."targetUserId"
                        AND uo."organizationId" = NEW."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND u."deletedAt" IS NULL
                        AND uar."deletedAt" IS NULL
                        AND acp."deletedAt" IS NULL
                        AND racp."regionId" = NEW."regionId"
                ) AS T
                WHERE T."row_num" = 1;
            -- access notification all users
            ELSE
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 20, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        't', NEW."targetUserId",
                        'r', NEW."regionId",
                        's', NEW."success",
                        'd', NEW."direction"
                    ) AS "data"
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id"
                    WHERE acp."organizationId" = NEW."organizationId"
                        AND racp."regionId" = NEW."regionId"
                        AND  acp."deletedAt" IS NULL
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_access_notification() OWNER TO armonsuper;

--
-- TOC entry 767 (class 1255 OID 12185908)
-- Name: before_up_in_del_user_access_rights(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_access_rights() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            DECLARE
            transaction_id		uuid;
            device_id			uuid;
            organization_id		uuid;
            factors_of_acp		jsonb;
            factors_of_other_acps		jsonb;
            factors_to_send_to_device		jsonb;
            i 						jsonb;
            j 						jsonb;
            l 						jsonb;
            t1 						jsonb;
        
            BEGIN
                transaction_id := uuid_generate_v4();
                factors_of_acp := '[]'::jsonb;
                factors_of_other_acps := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                IF (TG_OP = 'DELETE') THEN
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=OLD."accessControlPointId";
                    INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM organization."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                        RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                    END IF;
        
                    IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                        (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                    THEN
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    END IF;
                    IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                        (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM organization."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM organization."accessControlPoints" AS acp
                            INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM organization."userOrganizationCredentials" AS uoc
                            INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM organization."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM organization."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM organization."userAccessRights" AS uar
                                            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM organization."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM organization."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM organization."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM organization."accessRuleHistory" AS arh
                            INNER JOIN organization."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN organization."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            organization."users" AS u
                            INNER JOIN organization."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                        END IF;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    IF EXISTS(SELECT 1 FROM organization."userAccessRights"
                        WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                        AND "deletedAt" IS NULL) THEN
                        RAISE EXCEPTION 'User access right  already exists';
                    END IF;
                    SELECT "deviceId" INTO device_id FROM organization."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM organization."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO organization."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM organization."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM organization."accessControlPoints" AS acp
                            INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM organization."userOrganizationCredentials" AS uoc
                            INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO organization."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM organization."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM organization."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM organization."userAccessRights" AS uar
                                            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM organization."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM organization."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM organization."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM organization."accessRuleHistory" AS arh
                            INNER JOIN organization."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN organization."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            organization."users" AS u
                            INNER JOIN organization."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN organization."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                            ) AS T;
                        END IF;
                    END IF;
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_del_user_access_rights() OWNER TO armonsuper;

--
-- TOC entry 759 (class 1255 OID 12185910)
-- Name: before_up_in_del_user_forbiddances(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_forbiddances() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id		uuid;
    user_id				uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."userId";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                        FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    -- if region id is null, apply for all regions
                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                ) AS T
                WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_id:= NEW."userId";
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        'userId', user_id,
                        'regionId', NEW."regionId",
                        'credentialIds', NEW."credentialIds",
                        'startDateISO', NEW."startUtc",
                        'endDateISO', NEW."endUtc"
                    ) AS "data"
                        FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    -- if region id is null, apply for all regions
                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            user_id:= NEW."userId";

            IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
            THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 17, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', NEW."id",
                        'userId', user_id,
                        'regionId', NEW."regionId",
                        'credentialIds', NEW."credentialIds",
                        'startDateISO', NEW."startUtc",
                        'endDateISO', NEW."endUtc"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    -- if region id is null, apply for all regions
                    AND racp."regionId" = (CASE WHEN NEW."regionId" IS NOT NULL THEN NEW."regionId" ELSE racp."regionId" END)
                    WHERE uo."userId" = user_id AND uo."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1;
            ELSIF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
            THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 18, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'id', OLD."id"
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    -- if region id is null, apply for all regions
                    AND racp."regionId" = (CASE WHEN OLD."regionId" IS NOT NULL THEN OLD."regionId" ELSE racp."regionId" END)
                    WHERE uo."userId" = user_id AND uo."organizationId" = OLD."organizationId"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_forbiddances() OWNER TO armonsuper;

--
-- TOC entry 768 (class 1255 OID 12185911)
-- Name: before_up_in_del_user_group_mapping(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_group_mapping() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id			uuid;
    user_organization_id	uuid;
    group_id				uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_organization_id:= OLD."userOrganizationId";
            group_id:= OLD."userGroupId";
            IF (OLD."deletedAt" IS NULL) THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', ('["' || u."id" || '"]')::json,
                        'addedUserIds', '[]'::json
                    ) AS "data"
                        FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_organization_id:= NEW."userOrganizationId";
            group_id:= NEW."userGroupId";

            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                JSON_BUILD_OBJECT(
                    'userGroupId', group_id,
                    'removedUserIds', '[]'::json,
                    'addedUserIds',  ('["' || u."id" || '"]')::json
                ) AS "data"
                FROM organization."userOrganizations" AS uo
                INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                WHERE uo."id" = user_organization_id
                --GROUP BY acp."deviceId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
            THEN
                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
            THEN
                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', ('["' || u."id" || '"]')::json,
                        'addedUserIds', '[]'::json
                    ) AS "data"
                    FROM organization."userOrganizations" AS uo
                    INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_group_mapping() OWNER TO armonsuper;

--
-- TOC entry 769 (class 1255 OID 12185912)
-- Name: before_up_in_del_user_organization_credentials(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_organization_credentials() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
	DECLARE
			transaction_id	uuid;
			t_factors		text;
			factors 		text[];
			BEGIN
				transaction_id := uuid_generate_v4();
				IF (TG_OP = 'DELETE') THEN
					INSERT INTO organization."terminalChanges"
					("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
					SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
					WHERE T."row_num" = 1;
					RETURN OLD;
				ELSIF (TG_OP = 'UPDATE') THEN
					IF NEW."userId" != OLD."userId"
					OR NEW."organizationId" != OLD."organizationId"
					OR NEW."type" != OLD."type"
					OR NEW."data" != OLD."data"
					OR NEW."specialData" != OLD."specialData"
					OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
					THEN
						RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
					END IF;
		
					IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
					THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
						JSON_BUILD_OBJECT('id', OLD."id")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
		
					IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
						OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
						NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
								AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
					THEN
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
							JSON_BUILD_OBJECT(	'id', OLD."id", 
													'expiresOnISO', NEW."expiresOn",
													'groupNumber', NEW."groupNumber",
													'extensionFields', NEW."extensionFields")
						FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
							FROM organization."userOrganizationCredentials" AS uoc
							INNER JOIN organization."userAccessRights" AS uar ON uoc."userId" = uar."userId"
							AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL
							INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
							AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
							AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
						AS T
						WHERE T."row_num" = 1;
					END IF;
				ELSIF (TG_OP = 'INSERT') THEN
					IF (NEW."deletedAt" IS NULL)
					THEN
						IF EXISTS(SELECT FROM organization."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL
							AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
							RAISE EXCEPTION 'Credential is already exists';
						END IF;
						
						IF EXISTS(SELECT FROM organization."userOrganizationCredentials"
							WHERE "type" = NEW."type" AND "data" = NEW."data"
							AND "organizationId" = NEW."organizationId"
							AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
							UPDATE organization."userOrganizationCredentials" SET "deletedAt" = now()
							WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
								AND "type" = NEW."type" AND "deletedAt" IS NULL;
						END IF;
		
						INSERT INTO organization."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
						json_build_object(
							'id', T."id",
							'userId', T."userId",
							'type', T."type",
							'data', T."data",
							'groupNumber', T."groupNumber",
							'specialData', T."specialData",
							'specialDataSecondary', T."specialDataSecondary",
							'expiresOnISO', T."expiresOn",
							'extensionFields', T."extensionFields"
						) AS "data" FROM
						(SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
						NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
						FROM
							(SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM organization."userAccessRights" AS uar
								INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
								AND NEW."organizationId" = acp."organizationId"
								WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
								) AS T2
							WHERE T2.row_num=1
							) AS T;
					END IF;
				END IF;
				RETURN NEW;
			END;
	$$;


ALTER FUNCTION organization.before_up_in_del_user_organization_credentials() OWNER TO armonsuper;

--
-- TOC entry 770 (class 1255 OID 12185913)
-- Name: before_up_in_del_user_organization_sensor_notifications(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    access_control_point_id 		uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            access_control_point_id:= OLD."accessControlPointId";
        ELSE
            access_control_point_id:= NEW."accessControlPointId";
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
        FROM organization."accessControlPoints" AS acp
		WHERE acp.id = access_control_point_id AND acp."deletedAt" IS NULL;

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() OWNER TO armonsuper;

--
-- TOC entry 771 (class 1255 OID 12185914)
-- Name: before_up_in_del_user_region_ticket_unit(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_del_user_region_ticket_unit() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id		uuid;
    user_id				uuid;
    region_ticket_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."userId";
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', 0
                ) AS "data"
				FROM organization."regionTickets" AS rt
				INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = OLD."organizationId" AND
					uar."userId" = OLD."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_id:= NEW."userId";

            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', NEW."remainingUnits"
                ) AS "data"
				FROM organization."regionTickets" AS rt
				INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = NEW."organizationId" AND
					uar."userId" = NEW."userId"
				--FROM organization."userOrganizations" AS uo
                --INNER JOIN organization."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                --INNER JOIN organization."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                --INNER JOIN organization."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --INNER JOIN organization."regionTickets" AS rt ON rt."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --WHERE uo."organizationId" = NEW."organizationId" AND u."id" = NEW."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            user_id:= NEW."userId";

            IF (NEW."remainingUnits" != OLD."remainingUnits" AND NEW."totalSpentUnits" = OLD."totalSpentUnits")
            THEN
                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', NEW."lastUpdateAmount"
                    ) AS "data"
					FROM organization."regionTickets" AS rt
					INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId"
                ) AS T
            	WHERE T."row_num" = 1;
            ELSIF (NEW."totalSpentUnits" != OLD."totalSpentUnits"
                    AND NEW."lastUpdateAccessControlPointId" IS NOT NULL)
            THEN
                SELECT rt."id" INTO region_ticket_id
                FROM organization."regionTickets" AS rt
                INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = NEW."lastUpdateAccessControlPointId"
                INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id" AND racp."regionId" = rt."regionId"
                WHERE rt."deletedAt" IS NULL AND acp."deletedAt" IS NULL;

                INSERT INTO organization."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 13, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userId', user_id,
                        'ticketId', region_ticket_id,
                        'amount', (OLD."remainingUnits" - NEW."remainingUnits")
                    ) AS "data"
                    FROM organization."regionTickets" AS rt
					INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN organization."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN organization."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId" AND
						acp."id" != NEW."lastUpdateAccessControlPointId"
                ) AS T
				WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$$;


ALTER FUNCTION organization.before_up_in_del_user_region_ticket_unit() OWNER TO armonsuper;

--
-- TOC entry 772 (class 1255 OID 12185915)
-- Name: before_up_in_delete_access_rule_sets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_access_rule_sets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT T."deviceId"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                    WHERE racp."regionId" = OLD."regionId"
                        AND acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSIF (TG_OP = 'UPDATE') THEN
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM organization."accessControlPoints" AS acp
                        INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId" OR racp."regionId" = OLD."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM organization."accessControlPoints" AS acp
                        INNER JOIN organization."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
                        WHERE racp."regionId" = NEW."regionId"
                            AND acp."deletedAt" IS NULL
                            AND acp."organizationId" = NEW."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_access_rule_sets() OWNER TO armonsuper;

--
-- TOC entry 773 (class 1255 OID 12185916)
-- Name: before_up_in_delete_access_rules(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_access_rules() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_access_rules() OWNER TO armonsuper;

--
-- TOC entry 774 (class 1255 OID 12185917)
-- Name: before_up_in_delete_region_tickets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_region_tickets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = OLD."organizationId"
                        AND racp."regionId" = OLD."regionId"
                        AND OLD."deletedAt" IS NULL
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    WHERE acp."deletedAt" IS NULL
                        AND acp."organizationId" = NEW."organizationId"
                        AND racp."regionId" = NEW."regionId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_region_tickets() OWNER TO armonsuper;

--
-- TOC entry 687 (class 1255 OID 12185918)
-- Name: before_up_in_delete_user_group_access_rule_sets(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    device_id_list  uuid[];
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            SELECT ARRAY_AGG(T."deviceId")
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  OLD."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
            ) AS T
            WHERE T."row_num" = 1
            INTO device_id_list;
        ELSE
            SELECT ARRAY_AGG(T."deviceId")
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                    FROM organization."accessControlPoints" AS acp
                    INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
                    INNER JOIN organization."accessRuleSets" AS ars ON ars."id" =  NEW."accessRuleSetId" AND racp."regionId" = ars."regionId"
                    WHERE acp."deletedAt" IS NULL
                        AND ars."deletedAt" IS NULL
                        AND acp."organizationId" = ars."organizationId"
                ) AS T
                WHERE T."row_num" = 1
            INTO device_id_list;
        END IF;
        INSERT INTO organization."terminalChanges"
        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;
$$;


ALTER FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() OWNER TO armonsuper;

--
-- TOC entry 753 (class 1255 OID 12185919)
-- Name: before_up_in_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            BEGIN
                IF(NEW.type IN (32, 31, 19, 3, 2, 1) AND NEW."receiverFilterId" IS NULL) THEN
                    RAISE EXCEPTION 'You Should Set receiverFilter For This Notification Type';
                END IF;
                RETURN NEW;
            END;
        $$;


ALTER FUNCTION organization.before_up_in_notification() OWNER TO armonsuper;

--
-- TOC entry 775 (class 1255 OID 12185920)
-- Name: before_up_in_user_rule_history(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_up_in_user_rule_history() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
  data_object		 	json;
  related_device_ids 	uuid[];
  res					text;
    BEGIN
    SELECT ARRAY_AGG(T."deviceId") FROM (
      SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
      FROM organization."accessControlPoints" AS acp
      INNER JOIN organization."regionAccessControlPoints" AS racp ON racp."accessControlPointId" = acp."id"
      INNER JOIN organization."accessRuleSets" AS ars ON ars."regionId" = racp."regionId"
      INNER JOIN organization."accessRules" AS ar ON ar."accessRuleSetId" = ars."id"
      WHERE ar."id" = NEW."accessRuleId" AND
        ar."deletedAt" IS NULL AND
        ars."deletedAt" IS NULL AND
        acp."deletedAt" IS NULL AND
        acp."deviceId" != (SELECT "deviceId" FROM organization."accessControlPoints" WHERE "id" = NEW."lastUpdateAccessControlPointId")
    ) AS T INTO related_device_ids
    WHERE T.row_num = 1;
    data_object := JSON_BUILD_OBJECT(
      'ruleId', NEW."accessRuleId",
      'userId', NEW."userId",
      'count', NEW."count",
      'actionDateISO', NEW."lastActionDateISO");
    res :=JSON_BUILD_OBJECT(
        'data', data_object,
        'relatedDeviceIds', related_device_ids,
        'organizationId', TG_TABLE_SCHEMA)::text;
    PERFORM PG_NOTIFY('access_rule_applied', res);

        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_up_in_user_rule_history() OWNER TO armonsuper;

--
-- TOC entry 776 (class 1255 OID 12185921)
-- Name: before_update_devices(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.before_update_devices() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    transaction_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (NEW."name" != OLD."name" OR NEW."location" != OLD."location")
        THEN
            INSERT INTO organization."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            VALUES(uuid_generate_v4(), transaction_id, NEW."id", now(), 3, '{}'::json);
        END IF;
        RETURN NEW;
    END;
$$;


ALTER FUNCTION organization.before_update_devices() OWNER TO armonsuper;

--
-- TOC entry 777 (class 1255 OID 12185922)
-- Name: fauthorizeuserfor(uuid, uuid, uuid[], uuid[], uuid[], uuid[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) RETURNS json
    LANGUAGE plpgsql
    AS $$
DECLARE 
	authorized_organization_unit_ids uuid[];
    authorized_access_control_point_ids uuid[];
    authorized_user_ids uuid[];
    authorized_user_group_ids uuid[];
    tmp_uuid uuid;
    is_admin bool;
    user_organization_id uuid;
BEGIN

SELECT "id" into user_organization_id FROM organization."userOrganizations" 
    WHERE "organizationId" = organization_id AND "userId" = user_id AND "deletedAt" IS NULL AND "isDisabled" = false;
    
SELECT CASE WHEN count(*) > 0 THEN true ELSE false END into is_admin 
FROM organization."userOrganizations"  as uo
INNER JOIN organization."roles" as r
ON r.id = uo."roleId"
WHERE uo."organizationId" = organization_id AND uo."userId" = user_id AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
and r."typeId" = '52a088f3-4b54-4c60-b204-b8ec3dfe794a';
    
IF is_admin THEN
	RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
END IF;

IF array_length(organization_unit_ids, 1) > 0 OR array_length(user_ids, 1) > 0 OR array_length(user_group_ids, 1) > 0 THEN
    SELECT array_agg(uoou."organizationUnitId") INTO authorized_organization_unit_ids 
    FROM organization."userOrganizationOrganizationUnits" AS uoou    
    WHERE uoou."userOrganizationId" = user_organization_id AND uoou."deletedAt" IS NULL;

    SELECT array_agg(ou.id) INTO authorized_organization_unit_ids FROM organization."organizationUnits" AS ou WHERE 
    ou."deletedAt" IS NULL AND
    (ou.id = ANY(authorized_organization_unit_ids) OR
    ou."ancestorIds" ~ ANY(authorized_organization_unit_ids::text[]));

    RAISE NOTICE 'Authorized unit_ids: %', authorized_organization_unit_ids;
    IF array_length(organization_unit_ids, 1) > 0 AND (authorized_organization_unit_ids IS NULL OR arraycontained(organization_unit_ids, authorized_organization_unit_ids) = FALSE) THEN    	
        RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'organization_unit_ids');        
    END IF;    
    
    IF array_length(user_ids, 1) > 0 THEN
    	SELECT array_agg(uo."userId") INTO authorized_user_ids FROM organization."userOrganizationOrganizationUnits" AS uoou
        INNER JOIN organization."userOrganizations" AS uo ON uo."id" = uoou."userOrganizationId" AND uo."deletedAt" IS NULL AND uoou."deletedAt" IS NULL
        WHERE uoou."organizationUnitId" = ANY(authorized_organization_unit_ids) AND uo."userId" = ANY(user_ids);
        RAISE NOTICE 'Authorized user_ids: %', authorized_user_ids;
        IF authorized_user_ids IS NULL OR arraycontained(user_ids, authorized_user_ids) = FALSE THEN
        	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_ids');                	
        END IF;
    END IF;

    IF array_length(user_group_ids, 1) > 0 THEN	
    	SELECT array_agg(ug.id) INTO authorized_user_group_ids FROM organization."userGroups" AS ug
        WHERE ug."organizationId" = organization_id AND ug."deletedAt" IS NULL AND (ug."organizationUnitId" IS NULL OR ug."organizationUnitId" = ANY(authorized_organization_unit_ids));
    	IF authorized_user_group_ids IS NULL OR arraycontained(user_group_ids, authorized_user_group_ids) = FALSE THEN    	    
        	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'user_group_ids');                	            
        END IF;
    END IF;
END IF;

IF array_length(access_control_point_ids, 1) > 0 THEN
	SELECT array_agg(uar."accessControlPointId") INTO authorized_access_control_point_ids FROM organization."userAccessRights" AS uar WHERE uar."userId" = user_id;
    IF authorized_access_control_point_ids IS NULL OR arraycontained(access_control_point_ids, authorized_access_control_point_ids) = FALSE THEN
    	RETURN json_build_object('result', false, 'userOrganizationId', user_organization_id, 'reason', 'access_control_point_ids');                	                    
    END IF;   
END IF;

RETURN json_build_object('result', true, 'userOrganizationId', user_organization_id);
END;

$$;


ALTER FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) OWNER TO armonsuper;

--
-- TOC entry 778 (class 1255 OID 12185923)
-- Name: fcollectusersforaccessreportfilter(uuid, uuid[], boolean, uuid[], uuid[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) RETURNS json
    LANGUAGE plpgsql
    AS $$
DECLARE 
    _users JSON;
    _organization_unit_ids uuid[];    
    _user_organization_ids_for_organization_units uuid[];    
    _user_organization_ids_for_user_groups uuid[];
    _user_organization_ids_for_users uuid[];
BEGIN

IF array_length(organization_unit_ids, 1) > 0 THEN
	IF filter_organization_unit_members_hierarchically = TRUE THEN
    	SELECT array_agg(oh."id") INTO _organization_unit_ids FROM 
        (SELECT 
        ou."id", CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END as "ancestorIds" 
        FROM organization."organizationUnits" as ou WHERE ou."deletedAt" IS NULL AND ou."organizationId" = organization_id) as oh
        WHERE oh."id" = ANY(organization_unit_ids)
        OR oh."ancestorIds" && organization_unit_ids;
    ELSE
    	SELECT array_agg(ou."id") INTO _organization_unit_ids 
        FROM organization."organizationUnits" as ou WHERE ou."deletedAt" IS NULL AND ou."organizationId" = organization_id
        AND ou."id"=ANY(organization_unit_ids);
    END IF;
    
    SELECT array_agg(uoou."userOrganizationId") INTO _user_organization_ids_for_organization_units 
    FROM organization."userOrganizationOrganizationUnits" uoou WHERE uoou."deletedAt" IS NULL AND "organizationUnitId" = ANY(_organization_unit_ids);
END IF;

IF array_length(user_group_ids, 1) > 0 THEN
	SELECT array_agg(uguo."userOrganizationId") INTO _user_organization_ids_for_user_groups FROM organization."userGroupUserOrganizations" AS uguo
    WHERE uguo."deletedAt" IS NULL AND "userGroupId" = ANY(user_group_ids);
END IF;

IF array_length(user_ids, 1) > 0 THEN
	SELECT array_agg(uo."id") INTO _user_organization_ids_for_users FROM organization."userOrganizations" AS uo WHERE uo."organizationId" = organization_id AND uo."deletedAt" IS NULL AND uo."userId" = ANY(user_ids);
END IF;

SELECT json_agg(json_build_object('userId', uop."userId", 'userOrganizationId', uop."userOrganizationId")) INTO _users FROM organization."userOrganizationProfiles" AS uop WHERE 
uop."deletedAt" IS NULL AND
CASE WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_user_groups, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    (uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
 	AND
	uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups))
    OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_user_groups, 1) > 0 THEN
(
    uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
 	AND
	uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups)
) WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units) 	
	OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) WHEN array_length(_user_organization_ids_for_user_groups, 1) > 0 AND array_length(_user_organization_ids_for_users, 1) > 0 THEN
(    
    uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups) 	
	OR uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
) 
WHEN array_length(_user_organization_ids_for_users, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_users)
WHEN array_length(_user_organization_ids_for_organization_units, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_organization_units)
WHEN array_length(_user_organization_ids_for_user_groups, 1) > 0 THEN uop."userOrganizationId" = ANY(_user_organization_ids_for_user_groups)
ELSE FALSE END;
       
IF _users IS NULL THEN 
	SELECT '[]'::JSON INTO _users;
END IF;
RETURN _users;
END;

$$;


ALTER FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) OWNER TO armonsuper;

--
-- TOC entry 779 (class 1255 OID 12185924)
-- Name: fgetorganizationunitdetailed(uuid, uuid, boolean, uuid); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) RETURNS json
    LANGUAGE plpgsql
    AS $$
        DECLARE 
                _ri RECORD;
                _ji JSON;
                _result JSON;
                _parent JSON;
                _defaultAccessControlPoints JSON[];
            BEGIN	
            _result = null;
            _defaultAccessControlPoints = ARRAY[]::JSON[];
            
            SELECT json_build_object(
            'id', ou."id",
            'name', ou."name",
            'typeId', ou."typeId",
            'typeDefinition', oud.value,
            'ancestorIds', CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END,
            'shortCode', ou."shortCode",
            'parent', CASE WHEN ou."parentId" IS NULL THEN NULL ELSE ( 
                SELECT json_build_object('id', pou."id", 'name', pou."name",
                'typeId', pou."typeId", 
                'typeDefinition', poud.value,
                'ancestorIds', CASE WHEN pou."ancestorIds" = '[]' OR pou."ancestorIds" = '' OR pou."ancestorIds" IS NULL THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(pou."ancestorIds", E',')::uuid[] END,
                        'shortCode', pou."shortCode",
                        'parentId', pou."parentId"
                ) FROM organization."organizationUnits" AS pou
                INNER JOIN organization."organizationUserDefinedListValues" AS poud ON pou."typeId" = poud.id
                WHERE pou."id" = ou."parentId" AND pou."deletedAt" IS NULL) END,
                'defaultAccessControlPoints', ARRAY[]::JSON[]	
            )
            INTO _result 
            FROM organization."organizationUnits" AS ou 
            INNER JOIN organization."organizationUserDefinedListValues" AS oud ON ou."typeId" = oud.id
            WHERE ou."organizationId" = organization_id AND ou."id" = organization_unit_id AND ou."deletedAt" IS NULL;
            
            FOR _ri IN
            SELECT 
                acp."id", acp."name", acp."location", acp."remoteAvailable", acp."isRemoteDefault", acp."accessControlPointType" AS "type",
                (CASE WHEN uar."id" IS NULL AND is_system_administrator = FALSE THEN FALSE ELSE TRUE END) AS "managable", oudacp."defaultPrivileges"
            FROM organization."organizationUnitDefaultAccessControlPoints" AS oudacp
            INNER JOIN organization."accessControlPoints" AS acp ON acp."id" = oudacp."accessControlPointId"
            LEFT OUTER JOIN organization."userAccessRights" AS uar ON uar."userId" = user_id AND uar."accessControlPointId" = acp."id" AND uar."deletedAt" IS NULL
            WHERE oudacp."deletedAt" IS NULL AND oudacp."organizationUnitId" = organization_unit_id AND acp."deletedAt" IS NULL
            ORDER BY acp."name"
            LOOP
                _defaultAccessControlPoints = _defaultAccessControlPoints || to_json(_ri);
            END LOOP;
            
            IF _result IS NULL
            THEN
                RAISE EXCEPTION '%', json_build_object('code', 404, 'message', 'The organization unit is not found!');
            END IF;
            
            SELECT json_append(_result, json_build_object('defaultAccessControlPoints', _defaultAccessControlPoints)) INTO _result;
                
            RETURN _result;
            END;
    $$;


ALTER FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) OWNER TO armonsuper;

--
-- TOC entry 780 (class 1255 OID 12185925)
-- Name: gen_profile_text(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.gen_profile_text() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
            profile_text TEXT;
            field record;
        BEGIN
            profile_text := NEW."name";        
            IF NEW."surname" IS NOT NULL AND NEW."surname" <> '' THEN
                profile_text := profile_text || NEW."surname";  
            END IF;
            
            IF NEW."uniqueId" IS NOT NULL AND NEW."uniqueId" <> '' THEN
                profile_text := profile_text || NEW."uniqueId";        
            END IF;
            
            IF NEW."address" IS NOT NULL AND NEW."address" <> '' THEN
                profile_text := profile_text || NEW."address";        
            END IF;
            
            IF NEW."phoneNumber" IS NOT NULL AND NEW."phoneNumber" <> '' THEN
                profile_text := profile_text || NEW."phoneNumber";        
            END IF;
            
            IF NEW."email" IS NOT NULL AND NEW."email" <> '' THEN
                profile_text := profile_text || NEW."email";        
            END IF;
                    
            FOR field IN SELECT d.value FROM json_each_text(NEW."extensionFields") d WHERE d.value IS NOT NULL and d.value <> ''
            LOOP
                profile_text := profile_text || field.value;    
            END LOOP;
            
            NEW."profileText" := profile_text;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.gen_profile_text() OWNER TO armonsuper;

--
-- TOC entry 760 (class 1255 OID 12185926)
-- Name: json_append(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_append(data json, insert_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        UNION ALL
        SELECT * FROM json_each(insert_data)
    ) t;
$$;


ALTER FUNCTION organization.json_append(data json, insert_data json) OWNER TO armonsuper;

--
-- TOC entry 681 (class 1255 OID 12185927)
-- Name: json_delete(json, text[]); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_delete(data json, keys text[]) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        SELECT * FROM json_each(data)
        WHERE key <>ALL(keys)
    ) t;
$$;


ALTER FUNCTION organization.json_delete(data json, keys text[]) OWNER TO armonsuper;

--
-- TOC entry 682 (class 1255 OID 12185928)
-- Name: json_merge(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_merge(data json, merge_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH to_merge AS (
            SELECT * FROM json_each(merge_data)
        )
        SELECT *
        FROM json_each(data)
        WHERE key NOT IN (SELECT key FROM to_merge)
        UNION ALL
        SELECT * FROM to_merge
    ) t;
$$;


ALTER FUNCTION organization.json_merge(data json, merge_data json) OWNER TO armonsuper;

--
-- TOC entry 685 (class 1255 OID 12185929)
-- Name: json_update(json, json); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.json_update(data json, update_data json) RETURNS json
    LANGUAGE sql IMMUTABLE
    AS $$
    SELECT ('{'||string_agg(to_json(key)||':'||value, ',')||'}')::json
    FROM (
        WITH old_data AS (
            SELECT * FROM json_each(data)
        ), to_update AS (
            SELECT * FROM json_each(update_data)
            WHERE key IN (SELECT key FROM old_data)
        )
    SELECT * FROM old_data
    WHERE key NOT IN (SELECT key FROM to_update)
    UNION ALL
    SELECT * FROM to_update
) t;
$$;


ALTER FUNCTION organization.json_update(data json, update_data json) OWNER TO armonsuper;

--
-- TOC entry 688 (class 1255 OID 12185930)
-- Name: notify_pacs_live_recalculation(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.notify_pacs_live_recalculation() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
        recalculate_required_count		integer;
        BEGIN
            SELECT COUNT(*) INTO recalculate_required_count
            FROM newtab
            LEFT OUTER JOIN oldtab ON newtab.id = oldtab.id 
            WHERE (oldtab."updateRequiredReason" = 1 AND newtab."updateRequiredReason" <> 1) OR oldtab.id IS NULL;

            IF(recalculate_required_count > 0)
            THEN
                PERFORM PG_NOTIFY('pacs_live_recalculation', recalculate_required_count::text);
            END IF;
            RETURN NULL;
        END;
    $$;


ALTER FUNCTION organization.notify_pacs_live_recalculation() OWNER TO armonsuper;

--
-- TOC entry 781 (class 1255 OID 12185931)
-- Name: process_recalculate_work_queue_start_date_time(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.process_recalculate_work_queue_start_date_time() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    BEGIN
        DELETE FROM organization."recalculateWorkQueue" 
        WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
            AND "startDate" >= NEW."startDate";
        
        IF EXISTS(SELECT  FROM organization."recalculateWorkQueue" 
            WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
            AND "startDate" < NEW."startDate")
        THEN
            RETURN NULL; 
        ELSE
            RETURN NEW;
        END IF;
    END;
    $$;


ALTER FUNCTION organization.process_recalculate_work_queue_start_date_time() OWNER TO armonsuper;

--
-- TOC entry 782 (class 1255 OID 12185932)
-- Name: update_terminaladmins(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.update_terminaladmins() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        DECLARE
        old_permissions		character varying(512);
        new_permissions		character varying(512);
        BEGIN
            IF (TG_OP = 'DELETE') THEN
                DELETE FROM organization."terminalAdministrators" ta
                USING organization."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."roleId" <> OLD."roleId")
                THEN
                    SELECT r.permissions INTO old_permissions FROM organization.roles r WHERE r.id = OLD."roleId";
                    SELECT r.permissions INTO new_permissions FROM organization.roles r WHERE r.id = NEW."roleId";
                    
                    IF(POSITION('s:r' IN old_permissions) > 0 AND POSITION('s:r' IN new_permissions) = 0)
                    THEN
                        DELETE FROM organization."terminalAdministrators" ta
                        USING organization."devices" dev WHERE dev.id = ta."terminalId" AND dev."organizationId" = OLD."organizationId" AND ta."userId" = OLD."userId";
                    END IF;
                    
                    IF(POSITION('s:w' IN old_permissions) > 0 AND POSITION('s:w' IN new_permissions) = 0)
                    THEN
                        UPDATE organization."terminalAdministrators" ta SET write = false
                        FROM organization."devices" d WHERE d.id = ta."terminalId" AND d."organizationId" = NEW."organizationId" AND ta."userId" = NEW."userId";
                    END IF;
                END IF;
                RETURN NEW;
            END IF;
            RETURN NEW;
        END;
    $$;


ALTER FUNCTION organization.update_terminaladmins() OWNER TO armonsuper;

--
-- TOC entry 783 (class 1255 OID 12185933)
-- Name: zz_notification(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    _now timestamp without time zone;
    BEGIN
    _now:= now();
    IF(TG_OP = 'INSERT') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            NEW.id,
            1,
            _now,
            txid_current(),
            NEW."createdT",
            NEW.type,
            NEW."createdByUserId",
            NEW."receiverFilterId",
            NEW."settings",
            NEW.email,
            NEW.sms,
            NEW.web,
            NEW."pushNotification"
        );
    ELSIF(TG_OP = 'UPDATE') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            NEW.id,
            2,
            _now,
            txid_current(),
            NEW."createdT",
            NEW.type,
            NEW."createdByUserId",
            NEW."receiverFilterId",
            NEW."settings",
            NEW.email,
            NEW.sms,
            NEW.web,
            NEW."pushNotification"
        );
    ELSIF(TG_OP = 'DELETE') THEN
    INSERT INTO organization.zz_notification
        (
            id,
            action,
            "actionT",
            "transactionId",
            "createdT",
            type,
            "createdByUserId",
            "receiverFilterId",
            "settings",
            email,
            sms,
            web,
            "pushNotification"
        )
        VALUES(
            OLD.id,
            3,
            _now,
            txid_current(),
            OLD."createdT",
            OLD.type,
            OLD."createdByUserId",
            OLD."receiverFilterId",
            OLD."settings",
            OLD.email,
            OLD.sms,
            OLD.web,
            OLD."pushNotification"
        );
    END IF;
    RETURN NULL;
    END;
    $$;


ALTER FUNCTION organization.zz_notification() OWNER TO armonsuper;

--
-- TOC entry 784 (class 1255 OID 12185934)
-- Name: zz_notification_access(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification_access() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options 
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);
			ELSIF (TG_OP = 'UPDATE') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO organization.zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."targetUserId",
					OLD."regionId",
					OLD.options
				);       
			END IF;    
			RETURN NULL;
		END;
		$$;


ALTER FUNCTION organization.zz_notification_access() OWNER TO armonsuper;

--
-- TOC entry 750 (class 1255 OID 12185935)
-- Name: zz_notification_sensor(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_notification_sensor() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _now timestamp without time zone;
    BEGIN   
        _now := now();
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                1,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );
        ELSIF (TG_OP = 'UPDATE') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                2,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );    
        ELSIF (TG_OP = 'DELETE') THEN
            INSERT INTO organization.zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                OLD.id,
                3,
                _now,
                txid_current(),
                OLD."accessControlPointId",
                OLD."sensorType",
                OLD."deviceDryContactInputId",
                OLD.options
            );       
        END IF;    
        RETURN NULL;
    END;
    $$;


ALTER FUNCTION organization.zz_notification_sensor() OWNER TO armonsuper;

--
-- TOC entry 785 (class 1255 OID 12185936)
-- Name: zz_pacs_notification_scheduled_job(); Type: FUNCTION; Schema: organization; Owner: armonsuper
--

CREATE FUNCTION organization.zz_pacs_notification_scheduled_job() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);
			ELSIF (TG_OP = 'UPDATE') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO organization.zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."subjectedEmployeesFilterId"
				);       
			END IF;    
			RETURN NULL;
		END;
		$$;


ALTER FUNCTION organization.zz_pacs_notification_scheduled_job() OWNER TO armonsuper;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 427 (class 1259 OID 12189324)
-- Name: accessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    location character varying(255),
    "remoteAvailable" boolean DEFAULT false NOT NULL,
    "isRemoteDefault" boolean,
    "organizationId" uuid NOT NULL,
    "accessControlPointType" integer NOT NULL,
    "authenticationFactors" json,
    "deviceId" uuid,
    states json,
    "defaultPrivileges" json,
    "geoLocation" jsonb
);


ALTER TABLE organization."accessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 428 (class 1259 OID 12189331)
-- Name: accessRuleHistory; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRuleHistory" (
    id uuid NOT NULL,
    "createdDate" date NOT NULL,
    "accessRuleId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    count smallint NOT NULL,
    "lastUpdateAccessControlPointId" uuid,
    "lastActionDateISO" timestamp with time zone
);


ALTER TABLE organization."accessRuleHistory" OWNER TO armonsuper;

--
-- TOC entry 429 (class 1259 OID 12189334)
-- Name: accessRuleSets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRuleSets" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "regionId" uuid,
    name character varying(255) NOT NULL,
    "isActive" boolean NOT NULL,
    "uncoveredAccessStatus" integer DEFAULT 1 NOT NULL,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "createdAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    note character varying(512)
);


ALTER TABLE organization."accessRuleSets" OWNER TO armonsuper;

--
-- TOC entry 430 (class 1259 OID 12189341)
-- Name: accessRules; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."accessRules" (
    id uuid NOT NULL,
    "accessRuleSetId" uuid,
    direction integer NOT NULL,
    "acceptStatus" integer NOT NULL,
    type integer NOT NULL,
    parameters json NOT NULL,
    "createdAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "updatedAt" timestamp with time zone
);


ALTER TABLE organization."accessRules" OWNER TO armonsuper;

--
-- TOC entry 431 (class 1259 OID 12189347)
-- Name: access_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    log jsonb NOT NULL,
    "credentialData" jsonb,
    location point
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.access_logs OWNER TO armonsuper;

--
-- TOC entry 432 (class 1259 OID 12189350)
-- Name: access_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "organizationId" uuid NOT NULL,
    log jsonb NOT NULL,
    "credentialData" jsonb,
    location point
);
ALTER TABLE ONLY organization.access_logs ATTACH PARTITION organization.access_logs_default DEFAULT;


ALTER TABLE organization.access_logs_default OWNER TO armonsuper;

--
-- TOC entry 433 (class 1259 OID 12189356)
-- Name: access_point_qr_code; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_point_qr_code (
    id uuid NOT NULL,
    "accessPointId" uuid NOT NULL,
    "qrCodeData" character varying(255) NOT NULL,
    config jsonb NOT NULL,
    "remoteRelayId" uuid
);


ALTER TABLE organization.access_point_qr_code OWNER TO armonsuper;

--
-- TOC entry 434 (class 1259 OID 12189362)
-- Name: access_snapshots; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_snapshots (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.access_snapshots OWNER TO armonsuper;

--
-- TOC entry 435 (class 1259 OID 12189365)
-- Name: access_snapshots_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.access_snapshots_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.access_snapshots ATTACH PARTITION organization.access_snapshots_default DEFAULT;


ALTER TABLE organization.access_snapshots_default OWNER TO armonsuper;

--
-- TOC entry 436 (class 1259 OID 12189371)
-- Name: adapters; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.adapters (
    id uuid NOT NULL,
    "organizationId" uuid,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    number integer,
    type integer,
    ip character varying(255),
    name character varying(255),
    "certBeginDate" timestamp with time zone,
    "certExpDate" timestamp with time zone,
    "certFiles" bytea,
    "publicKey" character varying(2048) DEFAULT 'KEY'::character varying,
    token character varying(255)
);


ALTER TABLE organization.adapters OWNER TO armonsuper;

--
-- TOC entry 437 (class 1259 OID 12189378)
-- Name: antiPassbackStates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."antiPassbackStates" (
    id uuid NOT NULL,
    "regionId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "actionUtc" timestamp with time zone,
    state integer,
    "accessControlPointId" uuid NOT NULL,
    "entranceLockExpirationUtc" timestamp with time zone,
    "exitLockExpirationUtc" timestamp with time zone
);


ALTER TABLE organization."antiPassbackStates" OWNER TO armonsuper;

--
-- TOC entry 438 (class 1259 OID 12189381)
-- Name: aperioLocks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."aperioLocks" (
    "hubDeviceId" uuid NOT NULL,
    "lockDeviceId" uuid NOT NULL
);


ALTER TABLE organization."aperioLocks" OWNER TO armonsuper;

--
-- TOC entry 439 (class 1259 OID 12189384)
-- Name: attendanceAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."attendanceAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "workingHoursScheduleId" uuid,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."attendanceAccessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 440 (class 1259 OID 12189387)
-- Name: cameraActions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."cameraActions" (
    "cameraId" uuid,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    type integer NOT NULL,
    settings json
);


ALTER TABLE organization."cameraActions" OWNER TO armonsuper;

--
-- TOC entry 441 (class 1259 OID 12189393)
-- Name: cameras; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.cameras (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    "streamUrl" character varying(255),
    "userName" character varying(255),
    password character varying(255),
    "snapshotUrl" character varying(255),
    "accessControlPointId" uuid,
    "remoteAccess" boolean,
    "wiegandReaderIds" json,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "exitButtonIds" json,
    "proxyUrl" character varying(255) DEFAULT NULL::character varying,
    "hikVisionLicensePlateCameraLaneIds" json,
    "impinjSpeedWayGateWayAntennaIds" json
);


ALTER TABLE organization.cameras OWNER TO armonsuper;

--
-- TOC entry 442 (class 1259 OID 12189400)
-- Name: controlPanelESeriesSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelESeriesSettings" (
    "deviceId" uuid NOT NULL,
    "mainControlPanelId" uuid,
    number integer
);


ALTER TABLE organization."controlPanelESeriesSettings" OWNER TO armonsuper;

--
-- TOC entry 443 (class 1259 OID 12189403)
-- Name: controlPanelMSeriesAnalogInputs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelMSeriesAnalogInputs" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    threshold real,
    description character varying(255)
);


ALTER TABLE organization."controlPanelMSeriesAnalogInputs" OWNER TO armonsuper;

--
-- TOC entry 444 (class 1259 OID 12189406)
-- Name: controlPanelMSeriesSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."controlPanelMSeriesSettings" (
    "deviceId" uuid NOT NULL,
    "batteryPlugged" boolean,
    "emergencyPlugged" boolean,
    extensions json,
    "onBoardComputerModel" character varying(255),
    "onBoardComputerVersion" character varying(255),
    "onBoardComputerOs" character varying(255),
    "onBoardComputerTotalStorage" real,
    "onBoardComputerFreeStorage" real,
    "armonCpServerVersion" character varying(255),
    caption character varying(255)
);


ALTER TABLE organization."controlPanelMSeriesSettings" OWNER TO armonsuper;

--
-- TOC entry 445 (class 1259 OID 12189412)
-- Name: counter_sensor_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.counter_sensor_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.counter_sensor_logs OWNER TO armonsuper;

--
-- TOC entry 446 (class 1259 OID 12189415)
-- Name: counter_sensor_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.counter_sensor_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.counter_sensor_logs ATTACH PARTITION organization.counter_sensor_logs_default DEFAULT;


ALTER TABLE organization.counter_sensor_logs_default OWNER TO armonsuper;

--
-- TOC entry 447 (class 1259 OID 12189421)
-- Name: customReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."customReports" (
    id uuid NOT NULL,
    name character varying(511) NOT NULL,
    filters jsonb NOT NULL,
    description character varying(1023),
    formats smallint[] NOT NULL,
    "minPermissions" jsonb NOT NULL,
    "userFilterId" uuid
);


ALTER TABLE organization."customReports" OWNER TO armonsuper;

--
-- TOC entry 448 (class 1259 OID 12189427)
-- Name: deviceCurrentVersions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceCurrentVersions" (
    brand integer NOT NULL,
    model character varying(255) NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    version character varying(255) NOT NULL,
    "updateFilePath" character varying(255) NOT NULL,
    encoding character varying(255) NOT NULL,
    md5 character varying(255) NOT NULL,
    "forBeta" boolean,
    "specificDeviceIds" text
);


ALTER TABLE organization."deviceCurrentVersions" OWNER TO armonsuper;

--
-- TOC entry 449 (class 1259 OID 12189433)
-- Name: deviceDryContactInputs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceDryContactInputs" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    name character varying(255),
    number integer,
    nc boolean NOT NULL,
    type integer NOT NULL,
    settings json
);


ALTER TABLE organization."deviceDryContactInputs" OWNER TO armonsuper;

--
-- TOC entry 450 (class 1259 OID 12189439)
-- Name: deviceIntegrations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceIntegrations" (
    "integratedDeviceId" uuid NOT NULL,
    "integratingDeviceId" uuid NOT NULL,
    type integer NOT NULL,
    "extensionFields" text
);


ALTER TABLE organization."deviceIntegrations" OWNER TO armonsuper;

--
-- TOC entry 451 (class 1259 OID 12189445)
-- Name: deviceReaders; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceReaders" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    location character varying(255),
    name character varying(255),
    model character varying(255),
    number integer,
    direction integer,
    "readerOutputType" integer,
    "dataFormat" integer,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "credentialType" integer
);


ALTER TABLE organization."deviceReaders" OWNER TO armonsuper;

--
-- TOC entry 452 (class 1259 OID 12189451)
-- Name: deviceRelays; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceRelays" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    name character varying(255),
    direction integer,
    "driveDuration" integer NOT NULL,
    number integer NOT NULL,
    location character varying(255)
);


ALTER TABLE organization."deviceRelays" OWNER TO armonsuper;

--
-- TOC entry 453 (class 1259 OID 12189457)
-- Name: deviceUpdateStatus; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceUpdateStatus" (
    "deviceId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    attempt integer NOT NULL,
    version character varying(255) NOT NULL
);


ALTER TABLE organization."deviceUpdateStatus" OWNER TO armonsuper;

--
-- TOC entry 454 (class 1259 OID 12189460)
-- Name: deviceWiegandReaders; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."deviceWiegandReaders" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "deviceId" uuid,
    "accessControlPointId" uuid,
    location character varying(255),
    name character varying(255),
    model character varying(255),
    number integer,
    direction integer,
    "dataFormat" integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "authenticationFactor" integer
);


ALTER TABLE organization."deviceWiegandReaders" OWNER TO armonsuper;

--
-- TOC entry 455 (class 1259 OID 12189466)
-- Name: devices; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.devices (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    "adapterId" uuid,
    brand integer NOT NULL,
    "serialNumber" character varying(255) NOT NULL,
    model character varying(255) NOT NULL,
    name character varying(255),
    location character varying(255),
    ip character varying(255),
    port integer,
    "lastSyncISO" timestamp with time zone,
    "isBeta" boolean,
    "amqpUsername" character varying(255),
    "amqpPassword" character varying(255),
    "publicKey" character varying(2048) DEFAULT 'KEY'::character varying,
    "swVersion" character varying(255),
    "hwVersion" character varying(255),
    health json,
    timezone character varying(40),
    caption character varying(63) DEFAULT NULL::character varying,
    "certBeginDate" timestamp with time zone,
    "certExpDate" timestamp with time zone,
    "certFiles" bytea,
    token character varying(255)
);


ALTER TABLE organization.devices OWNER TO armonsuper;

--
-- TOC entry 456 (class 1259 OID 12189474)
-- Name: employeeDays; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeDays" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    date date NOT NULL,
    "organizationId" uuid NOT NULL,
    data jsonb NOT NULL
);


ALTER TABLE organization."employeeDays" OWNER TO armonsuper;

--
-- TOC entry 457 (class 1259 OID 12189480)
-- Name: employeeLiveDay; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeLiveDay" (
    id uuid NOT NULL,
    "startAt" timestamp with time zone NOT NULL,
    "expiredAt" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "workPlanIds" jsonb,
    "updatedAt" timestamp with time zone,
    "updateRequiredRaisedAt" timestamp with time zone NOT NULL,
    "updateRequiredReason" smallint,
    data jsonb,
    "sessionId" uuid
);


ALTER TABLE organization."employeeLiveDay" OWNER TO armonsuper;

--
-- TOC entry 458 (class 1259 OID 12189486)
-- Name: employeeMonths; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."employeeMonths" (
    id uuid NOT NULL,
    date date NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    data jsonb NOT NULL,
    note text,
    "monthlyReportId" uuid NOT NULL,
    "updatedByUserId" uuid,
    "isChecked" boolean NOT NULL
);


ALTER TABLE organization."employeeMonths" OWNER TO armonsuper;

--
-- TOC entry 459 (class 1259 OID 12189492)
-- Name: employee_day_segments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.employee_day_segments (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone NOT NULL,
    "endDateTime" timestamp with time zone NOT NULL,
    "workPlanId" uuid,
    data jsonb NOT NULL
)
PARTITION BY RANGE ("startDateTime");


ALTER TABLE organization.employee_day_segments OWNER TO armonsuper;

--
-- TOC entry 460 (class 1259 OID 12189495)
-- Name: employee_day_segments_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.employee_day_segments_default (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone NOT NULL,
    "endDateTime" timestamp with time zone NOT NULL,
    "workPlanId" uuid,
    data jsonb NOT NULL
);
ALTER TABLE ONLY organization.employee_day_segments ATTACH PARTITION organization.employee_day_segments_default DEFAULT;


ALTER TABLE organization.employee_day_segments_default OWNER TO armonsuper;

--
-- TOC entry 461 (class 1259 OID 12189501)
-- Name: floorPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."floorPlans" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    svg text NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE organization."floorPlans" OWNER TO armonsuper;

--
-- TOC entry 462 (class 1259 OID 12189507)
-- Name: hikVisionLicencePlateCameraLanes; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."hikVisionLicencePlateCameraLanes" (
    id uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    number integer NOT NULL,
    name character varying(255) NOT NULL,
    direction integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "accessControlPointId" uuid
);


ALTER TABLE organization."hikVisionLicencePlateCameraLanes" OWNER TO armonsuper;

--
-- TOC entry 463 (class 1259 OID 12189510)
-- Name: impinjSpeedWayGateWayAntennas; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."impinjSpeedWayGateWayAntennas" (
    id uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    number integer NOT NULL,
    name character varying(255) NOT NULL,
    direction integer NOT NULL,
    "relayId" uuid,
    "recurrentAttemptTimeout" integer,
    "accessControlPointId" uuid
);


ALTER TABLE organization."impinjSpeedWayGateWayAntennas" OWNER TO armonsuper;

--
-- TOC entry 464 (class 1259 OID 12189513)
-- Name: log_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_history (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "insertionUtc" timestamp with time zone NOT NULL,
    type integer,
    data jsonb
)
PARTITION BY RANGE ("insertionUtc");


ALTER TABLE organization.log_history OWNER TO armonsuper;

--
-- TOC entry 465 (class 1259 OID 12189516)
-- Name: log_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_history_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "insertionUtc" timestamp with time zone NOT NULL,
    type integer,
    data jsonb
);
ALTER TABLE ONLY organization.log_history ATTACH PARTITION organization.log_history_default DEFAULT;


ALTER TABLE organization.log_history_default OWNER TO armonsuper;

--
-- TOC entry 466 (class 1259 OID 12189522)
-- Name: log_process_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_process_history (
    "startUtc" timestamp with time zone NOT NULL,
    "firstInsertionUtc" timestamp with time zone NOT NULL,
    "lastInsertionUtc" timestamp with time zone NOT NULL,
    "processDuration" integer,
    "processedItemCount" integer,
    error character varying(256)
)
PARTITION BY RANGE ("startUtc");


ALTER TABLE organization.log_process_history OWNER TO armonsuper;

--
-- TOC entry 467 (class 1259 OID 12189525)
-- Name: log_process_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.log_process_history_default (
    "startUtc" timestamp with time zone NOT NULL,
    "firstInsertionUtc" timestamp with time zone NOT NULL,
    "lastInsertionUtc" timestamp with time zone NOT NULL,
    "processDuration" integer,
    "processedItemCount" integer,
    error character varying(256)
);
ALTER TABLE ONLY organization.log_process_history ATTACH PARTITION organization.log_process_history_default DEFAULT;


ALTER TABLE organization.log_process_history_default OWNER TO armonsuper;

--
-- TOC entry 468 (class 1259 OID 12189528)
-- Name: medium_sms; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.medium_sms (
    id uuid NOT NULL,
    "organizationId" uuid,
    "smsProvider" smallint NOT NULL,
    info jsonb NOT NULL
);


ALTER TABLE organization.medium_sms OWNER TO armonsuper;

--
-- TOC entry 469 (class 1259 OID 12189534)
-- Name: medium_smtp; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.medium_smtp (
    id uuid NOT NULL,
    "organizationId" uuid,
    info jsonb NOT NULL
);


ALTER TABLE organization.medium_smtp OWNER TO armonsuper;

--
-- TOC entry 470 (class 1259 OID 12189540)
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: organization; Owner: armonsuper
--

CREATE SEQUENCE organization.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE organization.migrations_id_seq OWNER TO armonsuper;

--
-- TOC entry 471 (class 1259 OID 12189542)
-- Name: monthlySummaryReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."monthlySummaryReports" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "runDateTime" timestamp with time zone,
    "isFinalized" boolean,
    year integer,
    month integer,
    note character varying(255),
    "updatedDate" timestamp with time zone,
    "updatedById" uuid
);


ALTER TABLE organization."monthlySummaryReports" OWNER TO armonsuper;

--
-- TOC entry 472 (class 1259 OID 12189545)
-- Name: monthly_summary_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.monthly_summary_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.monthly_summary_history OWNER TO armonsuper;

--
-- TOC entry 473 (class 1259 OID 12189548)
-- Name: monthly_summary_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.monthly_summary_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.monthly_summary_history ATTACH PARTITION organization.monthly_summary_history_default DEFAULT;


ALTER TABLE organization.monthly_summary_history_default OWNER TO armonsuper;

--
-- TOC entry 474 (class 1259 OID 12189554)
-- Name: notification; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "createdByUserId" uuid,
    type smallint NOT NULL,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL
);


ALTER TABLE organization.notification OWNER TO armonsuper;

--
-- TOC entry 475 (class 1259 OID 12189560)
-- Name: notificationAttachments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."notificationAttachments" (
    id uuid NOT NULL,
    name character varying(255),
    "actionUtc" timestamp with time zone
);


ALTER TABLE organization."notificationAttachments" OWNER TO armonsuper;

--
-- TOC entry 476 (class 1259 OID 12189563)
-- Name: notification_access; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_access (
    id uuid NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL
);


ALTER TABLE organization.notification_access OWNER TO armonsuper;

--
-- TOC entry 477 (class 1259 OID 12189569)
-- Name: notification_event; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
)
PARTITION BY RANGE ("createdT");


ALTER TABLE organization.notification_event OWNER TO armonsuper;

--
-- TOC entry 478 (class 1259 OID 12189572)
-- Name: notification_event_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
);
ALTER TABLE ONLY organization.notification_event ATTACH PARTITION organization.notification_event_default DEFAULT;


ALTER TABLE organization.notification_event_default OWNER TO armonsuper;

--
-- TOC entry 479 (class 1259 OID 12189578)
-- Name: notification_event_p202101; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event_p202101 (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
);
ALTER TABLE ONLY organization.notification_event ATTACH PARTITION organization.notification_event_p202101 FOR VALUES FROM ('2021-01-01 00:00:00') TO ('2021-02-01 00:00:00');


ALTER TABLE organization.notification_event_p202101 OWNER TO armonsuper;

--
-- TOC entry 480 (class 1259 OID 12189584)
-- Name: notification_event_p202102; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_event_p202102 (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "receiverFilterId" uuid NOT NULL,
    "notificationId" uuid NOT NULL,
    "instanceData" jsonb
);
ALTER TABLE ONLY organization.notification_event ATTACH PARTITION organization.notification_event_p202102 FOR VALUES FROM ('2021-02-01 00:00:00') TO ('2021-03-01 00:00:00');


ALTER TABLE organization.notification_event_p202102 OWNER TO armonsuper;

--
-- TOC entry 481 (class 1259 OID 12189590)
-- Name: notification_instance; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_instance (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "mediumGroupId" uuid NOT NULL,
    medium smallint NOT NULL,
    "notificationId" uuid NOT NULL,
    "receiverUserId" uuid NOT NULL,
    content jsonb,
    "eventId" uuid NOT NULL,
    CONSTRAINT notification_instance_medium_check CHECK ((medium = ANY ('{1,2,3,4}'::smallint[])))
)
PARTITION BY RANGE ("createdT");


ALTER TABLE organization.notification_instance OWNER TO armonsuper;

--
-- TOC entry 482 (class 1259 OID 12189594)
-- Name: notification_instance_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_instance_default (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    "mediumGroupId" uuid NOT NULL,
    medium smallint NOT NULL,
    "notificationId" uuid NOT NULL,
    "receiverUserId" uuid NOT NULL,
    content jsonb,
    "eventId" uuid NOT NULL,
    CONSTRAINT notification_instance_medium_check CHECK ((medium = ANY ('{1,2,3,4}'::smallint[])))
);
ALTER TABLE ONLY organization.notification_instance ATTACH PARTITION organization.notification_instance_default DEFAULT;


ALTER TABLE organization.notification_instance_default OWNER TO armonsuper;

--
-- TOC entry 483 (class 1259 OID 12189601)
-- Name: notification_sensor; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.notification_sensor (
    id uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT "notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
);


ALTER TABLE organization.notification_sensor OWNER TO armonsuper;

--
-- TOC entry 484 (class 1259 OID 12189608)
-- Name: oAuthClients; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."oAuthClients" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    profile integer NOT NULL,
    "clientSecret" character varying(511),
    "redirectUris" character varying(1023)
);


ALTER TABLE organization."oAuthClients" OWNER TO armonsuper;

--
-- TOC entry 485 (class 1259 OID 12189614)
-- Name: oAuthTokens; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."oAuthTokens" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "accessTokenExpiresOn" timestamp with time zone NOT NULL,
    "refreshToken" uuid,
    "refreshTokenExpiresOn" timestamp with time zone,
    "userId" uuid NOT NULL,
    "grantedAt" timestamp with time zone NOT NULL,
    "refreshedAt" timestamp with time zone,
    ip character varying(63) NOT NULL,
    "userAgent" character varying(255) NOT NULL,
    "organizationAuths" character varying(8092) NOT NULL,
    scopes character varying(255),
    "oAuthClientId" uuid
);


ALTER TABLE organization."oAuthTokens" OWNER TO armonsuper;

--
-- TOC entry 486 (class 1259 OID 12189620)
-- Name: organizationActiveVisits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationActiveVisits" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone,
    "organizationVisitorProfileId" uuid NOT NULL,
    "visitedOrganizationUnitId" uuid,
    "visitedUserOrganizationId" uuid,
    "escortUserOrganizationId" uuid,
    "extensionFields" json NOT NULL,
    "expectedStartUtc" timestamp with time zone,
    "expectedEndUtc" timestamp with time zone,
    state integer,
    "visitorRegistrationPointId" uuid,
    "processTime" double precision
);


ALTER TABLE organization."organizationActiveVisits" OWNER TO armonsuper;

--
-- TOC entry 487 (class 1259 OID 12189626)
-- Name: organizationEmailTemplates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationEmailTemplates" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer NOT NULL,
    "bodyTemplate" character varying(32768) NOT NULL,
    "subjectTemplate" character varying(1024) NOT NULL,
    configuration text,
    locale character varying(255) NOT NULL,
    "attachmentTemplate" character varying(32768)
);


ALTER TABLE organization."organizationEmailTemplates" OWNER TO armonsuper;

--
-- TOC entry 488 (class 1259 OID 12189632)
-- Name: organizationFeedbacks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationFeedbacks" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "createdBy" uuid,
    "createdAt" timestamp with time zone NOT NULL,
    caption character varying(255) NOT NULL,
    status integer NOT NULL,
    type integer NOT NULL
);


ALTER TABLE organization."organizationFeedbacks" OWNER TO armonsuper;

--
-- TOC entry 489 (class 1259 OID 12189635)
-- Name: organizationForms; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationForms" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    type integer NOT NULL,
    "organizationId" uuid NOT NULL,
    fields json NOT NULL
);


ALTER TABLE organization."organizationForms" OWNER TO armonsuper;

--
-- TOC entry 490 (class 1259 OID 12189641)
-- Name: organizationModules; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationModules" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    module integer NOT NULL,
    "enableUtc" timestamp with time zone,
    "disableUtc" timestamp with time zone,
    status integer DEFAULT 1 NOT NULL,
    "maxCredentialCount" integer
);


ALTER TABLE organization."organizationModules" OWNER TO armonsuper;

--
-- TOC entry 491 (class 1259 OID 12189645)
-- Name: organizationPACSModuleSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationPACSModuleSettings" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "annualLeavePPermissionTypeId" uuid,
    "casualLeavePPermissionTypeId" uuid,
    "canUseSystemPPermissionPrint" boolean DEFAULT false,
    "deputySelectionEnabled" boolean DEFAULT false,
    "annualPPermissionAgeLimits" json,
    "ppermissionClaimProfile" integer NOT NULL
);


ALTER TABLE organization."organizationPACSModuleSettings" OWNER TO armonsuper;

--
-- TOC entry 492 (class 1259 OID 12189653)
-- Name: organizationUnitDefaultAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUnitDefaultAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationUnitId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "defaultPrivileges" json
);


ALTER TABLE organization."organizationUnitDefaultAccessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 493 (class 1259 OID 12189659)
-- Name: organizationUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    name character varying(255) NOT NULL,
    "parentId" uuid,
    "ancestorIds" character varying(2047),
    "shortCode" character varying(255),
    "managerUserId" uuid,
    "managerUserOrganizationId" uuid,
    "typeId" uuid NOT NULL
);


ALTER TABLE organization."organizationUnits" OWNER TO armonsuper;

--
-- TOC entry 494 (class 1259 OID 12189665)
-- Name: organizationUserDefinedListValues; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserDefinedListValues" (
    id uuid NOT NULL,
    "userDefinedListId" uuid,
    value character varying(255),
    "relatedValueId" uuid
);


ALTER TABLE organization."organizationUserDefinedListValues" OWNER TO armonsuper;

--
-- TOC entry 495 (class 1259 OID 12189668)
-- Name: organizationUserDefinedLists; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserDefinedLists" (
    id uuid NOT NULL,
    "organizationId" uuid,
    type integer,
    caption character varying(255),
    "valueType" integer
);


ALTER TABLE organization."organizationUserDefinedLists" OWNER TO armonsuper;

--
-- TOC entry 496 (class 1259 OID 12189671)
-- Name: organizationUserSync; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationUserSync" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid,
    type integer,
    config json
);


ALTER TABLE organization."organizationUserSync" OWNER TO armonsuper;

--
-- TOC entry 497 (class 1259 OID 12189677)
-- Name: organizationVisitorDefaultAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorDefaultAccessControlPoints" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."organizationVisitorDefaultAccessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 498 (class 1259 OID 12189680)
-- Name: organizationVisitorModuleSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorModuleSettings" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "visitorProfileFormFields" json NOT NULL,
    "availableCredentials" json NOT NULL,
    "visitFormFields" json NOT NULL,
    "visitorProfileFormFieldSearchEndPoint" character varying(511) NOT NULL,
    "visitorProfileFormSearchEndPoint" character varying(511) NOT NULL,
    "visitFormFieldSearchEndPoint" character varying(511) NOT NULL,
    "preRegistrationAvailable" boolean DEFAULT true NOT NULL,
    "visitorStates" json,
    "forceToSelectRegistrationPoint" boolean DEFAULT false NOT NULL,
    "maxExpectedDayCount" integer,
    "visitFormFinalizedEndPoints" json,
    settings json,
    "settingsVersion" character varying(3)
);


ALTER TABLE organization."organizationVisitorModuleSettings" OWNER TO armonsuper;

--
-- TOC entry 499 (class 1259 OID 12189688)
-- Name: organizationVisitorProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255),
    "uniqueId" character varying(255),
    "extensionFields" json NOT NULL,
    "isAnonym" boolean DEFAULT false,
    "approvedGDPR" boolean DEFAULT false,
    thumbnail bytea
);


ALTER TABLE organization."organizationVisitorProfiles" OWNER TO armonsuper;

--
-- TOC entry 500 (class 1259 OID 12189696)
-- Name: organizationVisitorStates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."organizationVisitorStates" (
    id uuid NOT NULL,
    "organizationVisitorProfileId" uuid,
    state integer NOT NULL,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    note character varying(255),
    "createdBy" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "deletedBy" uuid,
    "deletedAt" timestamp with time zone
);


ALTER TABLE organization."organizationVisitorStates" OWNER TO armonsuper;

--
-- TOC entry 501 (class 1259 OID 12189699)
-- Name: organization_feedback_updates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedback_updates (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.organization_feedback_updates OWNER TO armonsuper;

--
-- TOC entry 502 (class 1259 OID 12189702)
-- Name: organization_feedback_updates_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedback_updates_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.organization_feedback_updates ATTACH PARTITION organization.organization_feedback_updates_default DEFAULT;


ALTER TABLE organization.organization_feedback_updates_default OWNER TO armonsuper;

--
-- TOC entry 503 (class 1259 OID 12189708)
-- Name: organization_feedbacks; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedbacks (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.organization_feedbacks OWNER TO armonsuper;

--
-- TOC entry 504 (class 1259 OID 12189711)
-- Name: organization_feedbacks_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organization_feedbacks_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "threadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.organization_feedbacks ATTACH PARTITION organization.organization_feedbacks_default DEFAULT;


ALTER TABLE organization.organization_feedbacks_default OWNER TO armonsuper;

--
-- TOC entry 505 (class 1259 OID 12189717)
-- Name: organizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.organizations (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    "hasEmergencyManagement" boolean DEFAULT false,
    "availableCredentialTypes" json DEFAULT '[0,3,2]'::json NOT NULL,
    "emergencyState" integer DEFAULT 0 NOT NULL,
    "usernamePolicy" integer DEFAULT 2,
    "uniqueIdFieldCaption" character varying(255),
    "credentialTypes" json NOT NULL,
    "publicKey" character varying(511) NOT NULL,
    "privateKey" character varying(511) NOT NULL,
    "annualPPermissionUpdateIntervals" character varying(512),
    "userOrganizationProfileSettings" json,
    "customCredentialTypes" json,
    "mobileCreditApplicationSettings" json,
    code character varying(5),
    alias character varying(32),
    "contactInfo" json,
    settings jsonb NOT NULL,
    "smsBalance" integer DEFAULT 0
);


ALTER TABLE organization.organizations OWNER TO armonsuper;

--
-- TOC entry 506 (class 1259 OID 12189728)
-- Name: pacs_notification_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.pacs_notification_scheduled_job (
    id uuid NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL
);


ALTER TABLE organization.pacs_notification_scheduled_job OWNER TO armonsuper;

--
-- TOC entry 507 (class 1259 OID 12189731)
-- Name: ppermissionAttachments; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionAttachments" (
    id uuid NOT NULL,
    "ppermissionId" uuid,
    name character varying(255)
);


ALTER TABLE organization."ppermissionAttachments" OWNER TO armonsuper;

--
-- TOC entry 508 (class 1259 OID 12189734)
-- Name: ppermissionClaims; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionClaims" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "ppermissionTypeId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "dueDate" timestamp with time zone,
    used integer,
    total integer
);


ALTER TABLE organization."ppermissionClaims" OWNER TO armonsuper;

--
-- TOC entry 509 (class 1259 OID 12189737)
-- Name: ppermissionTypeApprovements; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionTypeApprovements" (
    id uuid NOT NULL,
    "ppermissionTypeId" uuid,
    "rootOrganizationUnitId" uuid,
    "order" integer
);


ALTER TABLE organization."ppermissionTypeApprovements" OWNER TO armonsuper;

--
-- TOC entry 510 (class 1259 OID 12189740)
-- Name: ppermissionTypes; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."ppermissionTypes" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    description character varying(255),
    "isPassive" boolean,
    "hrCanInit" boolean,
    "personnelCanInit" boolean,
    "ignoreInCalculations" boolean,
    "trustDeclaration" boolean,
    "isDailyScheduled" boolean,
    "minValue" integer,
    "maxValue" integer,
    "maxValueBoundaryInterval" integer,
    "outOfWorkHours" boolean,
    "sendNotification" boolean,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "needsManagerDeputy" boolean DEFAULT false,
    "userMustSign" boolean DEFAULT false,
    type integer,
    "showRemainingCount" boolean DEFAULT false,
    "isUnpaidLeave" boolean DEFAULT false NOT NULL,
    "notifyHR" boolean,
    "noteIsMandatory" boolean NOT NULL,
    "needsUserDeputy" boolean NOT NULL
);


ALTER TABLE organization."ppermissionTypes" OWNER TO armonsuper;

--
-- TOC entry 511 (class 1259 OID 12189750)
-- Name: ppermission_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermission_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.ppermission_history OWNER TO armonsuper;

--
-- TOC entry 512 (class 1259 OID 12189753)
-- Name: ppermission_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermission_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.ppermission_history ATTACH PARTITION organization.ppermission_history_default DEFAULT;


ALTER TABLE organization.ppermission_history_default OWNER TO armonsuper;

--
-- TOC entry 513 (class 1259 OID 12189759)
-- Name: ppermissions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.ppermissions (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "ppermissionTypeId" uuid,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    "requestDateTime" timestamp with time zone,
    note character varying(512),
    status integer,
    "requestUserId" uuid,
    "fromIntegration" boolean,
    "requestRole" integer NOT NULL
);


ALTER TABLE organization.ppermissions OWNER TO armonsuper;

--
-- TOC entry 514 (class 1259 OID 12189765)
-- Name: preparedReports; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."preparedReports" (
    id uuid NOT NULL,
    "createdDt" timestamp with time zone NOT NULL,
    "expirationDt" timestamp with time zone NOT NULL,
    "userFilterId" uuid,
    format smallint NOT NULL,
    CONSTRAINT "preparedReports_format_check" CHECK ((format = ANY ('{1,2}'::smallint[])))
);


ALTER TABLE organization."preparedReports" OWNER TO armonsuper;

--
-- TOC entry 515 (class 1259 OID 12189769)
-- Name: preregisterDailySummaries; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."preregisterDailySummaries" (
    id uuid NOT NULL,
    "organizationId" uuid,
    "selfPreregisterCount" integer,
    "totalCount" integer,
    "totaltoVisitCount" integer,
    "selftoVisitCount" integer,
    date timestamp with time zone
);


ALTER TABLE organization."preregisterDailySummaries" OWNER TO armonsuper;

--
-- TOC entry 516 (class 1259 OID 12189772)
-- Name: recalculateWorkQueue; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."recalculateWorkQueue" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startDate" date NOT NULL,
    "createdAt" timestamp with time zone DEFAULT now() NOT NULL,
    reason smallint NOT NULL,
    note text
);


ALTER TABLE organization."recalculateWorkQueue" OWNER TO armonsuper;

--
-- TOC entry 517 (class 1259 OID 12189779)
-- Name: regionAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."regionAccessControlPoints" (
    id uuid NOT NULL,
    "regionId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL
);


ALTER TABLE organization."regionAccessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 518 (class 1259 OID 12189782)
-- Name: regionTickets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."regionTickets" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    "deletedAt" timestamp with time zone,
    "regionId" uuid,
    "organizationId" uuid,
    name character varying(255) NOT NULL,
    "requiredUnits" integer NOT NULL
);


ALTER TABLE organization."regionTickets" OWNER TO armonsuper;

--
-- TOC entry 519 (class 1259 OID 12189785)
-- Name: regions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.regions (
    id uuid NOT NULL,
    name character varying(255) NOT NULL,
    "antiPassback" boolean NOT NULL,
    "organizationId" uuid NOT NULL,
    "antiPassbackLockDuration" integer,
    "visitorAccess" boolean,
    "terminateVisitOnExit" boolean,
    "emergencyState" integer DEFAULT 1
);


ALTER TABLE organization.regions OWNER TO armonsuper;

--
-- TOC entry 520 (class 1259 OID 12189789)
-- Name: report_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.report_scheduled_job (
    id uuid NOT NULL,
    "reportTemplateId" uuid NOT NULL,
    format jsonb NOT NULL,
    "sendWhenEmpty" boolean NOT NULL
);


ALTER TABLE organization.report_scheduled_job OWNER TO armonsuper;

--
-- TOC entry 521 (class 1259 OID 12189795)
-- Name: report_templates; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.report_templates (
    id uuid NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    name character varying(511) NOT NULL,
    "userId" uuid NOT NULL,
    type smallint NOT NULL,
    filter jsonb NOT NULL,
    "customReportId" uuid
);


ALTER TABLE organization.report_templates OWNER TO armonsuper;

--
-- TOC entry 522 (class 1259 OID 12189801)
-- Name: roles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.roles (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    name character varying(255) NOT NULL,
    permissions character varying(512) NOT NULL,
    "organizationId" uuid,
    "isOrganizationWide" boolean DEFAULT false NOT NULL,
    "typeId" uuid,
    "minPermissions" json
);


ALTER TABLE organization.roles OWNER TO armonsuper;

--
-- TOC entry 523 (class 1259 OID 12189808)
-- Name: softwares; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.softwares (
    id uuid NOT NULL,
    "deviceModel" character varying(255) NOT NULL,
    "environmentModel" character varying(255),
    "environmentOs" character varying(255),
    type integer NOT NULL,
    "fileFullPath" character varying(1023) NOT NULL,
    version character varying(255) NOT NULL,
    "isBeta" boolean DEFAULT true NOT NULL
);


ALTER TABLE organization.softwares OWNER TO armonsuper;

--
-- TOC entry 524 (class 1259 OID 12189815)
-- Name: status_sensor_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.status_sensor_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.status_sensor_logs OWNER TO armonsuper;

--
-- TOC entry 525 (class 1259 OID 12189818)
-- Name: status_sensor_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.status_sensor_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "accessControlPointId" uuid,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.status_sensor_logs ATTACH PARTITION organization.status_sensor_logs_default DEFAULT;


ALTER TABLE organization.status_sensor_logs_default OWNER TO armonsuper;

--
-- TOC entry 526 (class 1259 OID 12189824)
-- Name: stickerAccessControlPointMappings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."stickerAccessControlPointMappings" (
    "stickerId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "accessDirection" integer NOT NULL,
    CONSTRAINT "stickerAccessControlPointMappings_accessDirection_check" CHECK (("accessDirection" = ANY (ARRAY[0, 1, 2])))
);


ALTER TABLE organization."stickerAccessControlPointMappings" OWNER TO armonsuper;

--
-- TOC entry 527 (class 1259 OID 12189828)
-- Name: system_status_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.system_status_logs (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.system_status_logs OWNER TO armonsuper;

--
-- TOC entry 528 (class 1259 OID 12189831)
-- Name: system_status_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.system_status_logs_default (
    id uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.system_status_logs ATTACH PARTITION organization.system_status_logs_default DEFAULT;


ALTER TABLE organization.system_status_logs_default OWNER TO armonsuper;

--
-- TOC entry 529 (class 1259 OID 12189837)
-- Name: tamper_switch_logs; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.tamper_switch_logs (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.tamper_switch_logs OWNER TO armonsuper;

--
-- TOC entry 530 (class 1259 OID 12189840)
-- Name: tamper_switch_logs_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.tamper_switch_logs_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.tamper_switch_logs ATTACH PARTITION organization.tamper_switch_logs_default DEFAULT;


ALTER TABLE organization.tamper_switch_logs_default OWNER TO armonsuper;

--
-- TOC entry 531 (class 1259 OID 12189846)
-- Name: terminalAdministrators; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalAdministrators" (
    id uuid NOT NULL,
    "terminalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    read boolean DEFAULT false NOT NULL,
    write boolean DEFAULT false NOT NULL,
    notify boolean DEFAULT false NOT NULL
);


ALTER TABLE organization."terminalAdministrators" OWNER TO armonsuper;

--
-- TOC entry 532 (class 1259 OID 12189852)
-- Name: terminalChangeTransactions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalChangeTransactions" (
    "transactionId" uuid NOT NULL,
    "deviceId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL
);


ALTER TABLE organization."terminalChangeTransactions" OWNER TO armonsuper;

--
-- TOC entry 533 (class 1259 OID 12189855)
-- Name: terminalChanges; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."terminalChanges" (
    id uuid NOT NULL,
    "transactionId" uuid NOT NULL,
    "actionDateISO" timestamp with time zone NOT NULL,
    type integer NOT NULL,
    "sessionId" uuid,
    data json NOT NULL,
    "deviceId" uuid NOT NULL,
    "sessionExpirationISO" timestamp with time zone
);


ALTER TABLE organization."terminalChanges" OWNER TO armonsuper;

--
-- TOC entry 534 (class 1259 OID 12189861)
-- Name: transaction; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.transaction (
    id bigint NOT NULL,
    "userId" uuid,
    "actionT" timestamp without time zone DEFAULT now() NOT NULL
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.transaction OWNER TO armonsuper;

--
-- TOC entry 535 (class 1259 OID 12189865)
-- Name: transaction_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.transaction_default (
    id bigint NOT NULL,
    "userId" uuid,
    "actionT" timestamp without time zone DEFAULT now() NOT NULL
);
ALTER TABLE ONLY organization.transaction ATTACH PARTITION organization.transaction_default DEFAULT;


ALTER TABLE organization.transaction_default OWNER TO armonsuper;

--
-- TOC entry 536 (class 1259 OID 12189869)
-- Name: upload_log_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.upload_log_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "uploadId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.upload_log_history OWNER TO armonsuper;

--
-- TOC entry 537 (class 1259 OID 12189872)
-- Name: upload_log_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.upload_log_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "uploadId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.upload_log_history ATTACH PARTITION organization.upload_log_history_default DEFAULT;


ALTER TABLE organization.upload_log_history_default OWNER TO armonsuper;

--
-- TOC entry 538 (class 1259 OID 12189878)
-- Name: userAccessRights; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userAccessRights" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "remoteAccess" boolean,
    "markedAsFavorite" boolean,
    read boolean DEFAULT false,
    access boolean DEFAULT true,
    config boolean DEFAULT false,
    "grant" boolean DEFAULT false,
    snapshot boolean DEFAULT false
);


ALTER TABLE organization."userAccessRights" OWNER TO armonsuper;

--
-- TOC entry 539 (class 1259 OID 12189886)
-- Name: userGroupAccessRuleSets; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroupAccessRuleSets" (
    id uuid NOT NULL,
    "userGroupId" uuid,
    "accessRuleSetId" uuid
);


ALTER TABLE organization."userGroupAccessRuleSets" OWNER TO armonsuper;

--
-- TOC entry 540 (class 1259 OID 12189889)
-- Name: userGroupUserOrganizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroupUserOrganizations" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "userGroupId" uuid
);


ALTER TABLE organization."userGroupUserOrganizations" OWNER TO armonsuper;

--
-- TOC entry 541 (class 1259 OID 12189892)
-- Name: userGroups; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userGroups" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "organizationId" uuid NOT NULL,
    name character varying(255) NOT NULL,
    "colorCode" character varying(8) NOT NULL,
    "organizationUnitId" uuid
);


ALTER TABLE organization."userGroups" OWNER TO armonsuper;

--
-- TOC entry 542 (class 1259 OID 12189895)
-- Name: userOrganizationCredentials; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationCredentials" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "expiresOn" timestamp with time zone,
    type integer NOT NULL,
    data character varying(4096) NOT NULL,
    "credentialNumber" character varying(31),
    "extensionFields" json,
    "specialData" text,
    "specialDataSecondary" text,
    "customFields" json,
    note character varying(512),
    "groupNumber" integer
);


ALTER TABLE organization."userOrganizationCredentials" OWNER TO armonsuper;

--
-- TOC entry 543 (class 1259 OID 12189901)
-- Name: userOrganizationDeputies; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationDeputies" (
    id uuid NOT NULL,
    "organizationUnitId" uuid,
    "ppermissionId" uuid,
    "userOrganizationId" uuid NOT NULL,
    "deputyUserOrganizationId" uuid NOT NULL,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    type integer
);


ALTER TABLE organization."userOrganizationDeputies" OWNER TO armonsuper;

--
-- TOC entry 544 (class 1259 OID 12189904)
-- Name: userOrganizationForbiddances; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationForbiddances" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "startUtc" timestamp with time zone,
    "endUtc" timestamp with time zone,
    "regionId" uuid,
    note character varying(255),
    "credentialIds" json
);


ALTER TABLE organization."userOrganizationForbiddances" OWNER TO armonsuper;

--
-- TOC entry 545 (class 1259 OID 12189910)
-- Name: userOrganizationLeaves; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationLeaves" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "organizationLeaveTypeId" uuid NOT NULL,
    "startDate" date NOT NULL,
    "endDate" date NOT NULL,
    "startTime" time without time zone NOT NULL,
    "endTime" time without time zone NOT NULL,
    status integer NOT NULL,
    "statusCaption" character varying(255) NOT NULL,
    "updatedByUserOrganizationId" uuid NOT NULL,
    comments character varying(511)
);


ALTER TABLE organization."userOrganizationLeaves" OWNER TO armonsuper;

--
-- TOC entry 546 (class 1259 OID 12189916)
-- Name: userOrganizationOrganizationUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationOrganizationUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "organizationUnitId" uuid NOT NULL,
    "roleId" uuid DEFAULT '62dc8044-0311-429b-805e-c86b91343c5b'::uuid NOT NULL,
    "extraPermissions" character varying(511)
);


ALTER TABLE organization."userOrganizationOrganizationUnits" OWNER TO armonsuper;

--
-- TOC entry 547 (class 1259 OID 12189923)
-- Name: userOrganizationProfilePhotos; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationProfilePhotos" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    "imageType" character varying(255) DEFAULT 'PNG'::character varying NOT NULL
);


ALTER TABLE organization."userOrganizationProfilePhotos" OWNER TO armonsuper;

--
-- TOC entry 548 (class 1259 OID 12189927)
-- Name: userOrganizationProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127) NOT NULL,
    address character varying(511),
    "phoneNumber" character varying(127),
    email character varying(127),
    "uniqueId" character varying(63) NOT NULL,
    "extensionFields" json,
    thumbnail bytea,
    "profileText" text,
    "employmentStartUtc" timestamp with time zone,
    "previousServiceDuration" integer,
    notifications json,
    "notificationPreferences" json,
    "pacsEnabledRemainedAnnualPPermission" integer,
    "birthDateUtc" timestamp with time zone,
    "previousAnnualVacationRight" integer DEFAULT 0,
    "employmentEndUtc" timestamp with time zone,
    "manuallyRemainedAnnualPermission" double precision
);


ALTER TABLE organization."userOrganizationProfiles" OWNER TO armonsuper;

--
-- TOC entry 549 (class 1259 OID 12189934)
-- Name: userOrganizationSettings; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationSettings" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationId" uuid NOT NULL,
    "dashboardCards" character varying(255)
);


ALTER TABLE organization."userOrganizationSettings" OWNER TO armonsuper;

--
-- TOC entry 550 (class 1259 OID 12189937)
-- Name: userOrganizationVisitorProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationVisitorProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "userOrganizationId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127) NOT NULL,
    address character varying(511),
    "phoneNumber" character varying(127),
    email character varying(127),
    "uniqueId" character varying(63) NOT NULL,
    company character varying(255)
);


ALTER TABLE organization."userOrganizationVisitorProfiles" OWNER TO armonsuper;

--
-- TOC entry 551 (class 1259 OID 12189943)
-- Name: userOrganizationVisits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizationVisits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userOrganizationVisitorProfileId" uuid NOT NULL,
    "visitingOrganizationUnitId" uuid,
    "visitingUserOrganizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone,
    reason character varying(255) NOT NULL,
    "visitSupervised" boolean DEFAULT false NOT NULL,
    "visitSupervisedByUserOrganizationId" uuid,
    "extensionFields" json
);


ALTER TABLE organization."userOrganizationVisits" OWNER TO armonsuper;

--
-- TOC entry 552 (class 1259 OID 12189950)
-- Name: userOrganizations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userOrganizations" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "roleId" uuid DEFAULT '28f5672e-cda7-4cd0-bbb4-82f2ee4b7ec3'::uuid NOT NULL,
    "isDisabled" boolean DEFAULT false NOT NULL,
    "extraPermissions" character varying(511),
    applicationprofile json,
    settings jsonb NOT NULL
);


ALTER TABLE organization."userOrganizations" OWNER TO armonsuper;

--
-- TOC entry 553 (class 1259 OID 12189958)
-- Name: userPPermissionApprovements; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userPPermissionApprovements" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "ppermissionId" uuid NOT NULL,
    "order" integer,
    "approverUserId" uuid,
    "approvementDate" timestamp with time zone,
    note character varying(255),
    status boolean,
    "organizationUnitId" uuid
);


ALTER TABLE organization."userPPermissionApprovements" OWNER TO armonsuper;

--
-- TOC entry 554 (class 1259 OID 12189961)
-- Name: userPPermissions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userPPermissions" (
    id uuid NOT NULL,
    "userId" uuid NOT NULL,
    "ppermissionId" uuid NOT NULL,
    note character varying(512),
    approvement character varying(255),
    "signedByUser" boolean DEFAULT false,
    "currentApprovementOrder" integer
);


ALTER TABLE organization."userPPermissions" OWNER TO armonsuper;

--
-- TOC entry 555 (class 1259 OID 12189968)
-- Name: userProfiles; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userProfiles" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "userId" uuid NOT NULL,
    name character varying(127) NOT NULL,
    surname character varying(127),
    email character varying(127),
    "phoneNumber" character varying(63),
    thumbnail bytea
);


ALTER TABLE organization."userProfiles" OWNER TO armonsuper;

--
-- TOC entry 556 (class 1259 OID 12189974)
-- Name: userRegionTicketUnits; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userRegionTicketUnits" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone NOT NULL,
    "organizationId" uuid,
    "userId" uuid,
    "remainingUnits" integer NOT NULL,
    "lastUpdateAccessControlPointId" uuid,
    "lastUpdateUserId" uuid,
    "lastUpdateAmount" integer,
    "totalSpentUnits" integer
);


ALTER TABLE organization."userRegionTicketUnits" OWNER TO armonsuper;

--
-- TOC entry 557 (class 1259 OID 12189977)
-- Name: userSelectionSessionActions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userSelectionSessionActions" (
    id uuid NOT NULL,
    "sessionId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "originalMappingId" uuid,
    "generatedMappingId" uuid,
    action integer NOT NULL
);


ALTER TABLE organization."userSelectionSessionActions" OWNER TO armonsuper;

--
-- TOC entry 558 (class 1259 OID 12189980)
-- Name: userSelectionSessions; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userSelectionSessions" (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "relatedItemId" uuid NOT NULL,
    "expirationUtc" timestamp with time zone NOT NULL,
    type integer NOT NULL
);


ALTER TABLE organization."userSelectionSessions" OWNER TO armonsuper;

--
-- TOC entry 559 (class 1259 OID 12189983)
-- Name: userWorkPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."userWorkPlans" (
    id uuid NOT NULL,
    "workPlanId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone,
    "createdAt" timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE organization."userWorkPlans" OWNER TO armonsuper;

--
-- TOC entry 560 (class 1259 OID 12189987)
-- Name: user_action_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_action_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    category integer NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_action_history OWNER TO armonsuper;

--
-- TOC entry 561 (class 1259 OID 12189990)
-- Name: user_action_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_action_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "userId" uuid NOT NULL,
    category integer NOT NULL,
    type integer NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_action_history ATTACH PARTITION organization.user_action_history_default DEFAULT;


ALTER TABLE organization.user_action_history_default OWNER TO armonsuper;

--
-- TOC entry 562 (class 1259 OID 12189996)
-- Name: user_filter; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter (
    id uuid NOT NULL
);


ALTER TABLE organization.user_filter OWNER TO armonsuper;

--
-- TOC entry 563 (class 1259 OID 12189999)
-- Name: user_filter_group; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_group (
    "filterId" uuid NOT NULL,
    "groupId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_group OWNER TO armonsuper;

--
-- TOC entry 564 (class 1259 OID 12190002)
-- Name: user_filter_organization_role; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_organization_role (
    "filterId" uuid NOT NULL,
    "roleId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_organization_role OWNER TO armonsuper;

--
-- TOC entry 565 (class 1259 OID 12190005)
-- Name: user_filter_unit; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_unit (
    "filterId" uuid NOT NULL,
    "unitId" uuid NOT NULL,
    hierarchically boolean
);


ALTER TABLE organization.user_filter_unit OWNER TO armonsuper;

--
-- TOC entry 566 (class 1259 OID 12190008)
-- Name: user_filter_unit_role; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_unit_role (
    "filterId" uuid NOT NULL,
    "unitId" uuid NOT NULL,
    "roleId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_unit_role OWNER TO armonsuper;

--
-- TOC entry 567 (class 1259 OID 12190011)
-- Name: user_filter_user; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_user (
    "filterId" uuid NOT NULL,
    "userId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_user OWNER TO armonsuper;

--
-- TOC entry 568 (class 1259 OID 12190014)
-- Name: user_filter_work_plan; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_filter_work_plan (
    "filterId" uuid NOT NULL,
    "workPlanId" uuid NOT NULL
);


ALTER TABLE organization.user_filter_work_plan OWNER TO armonsuper;

--
-- TOC entry 569 (class 1259 OID 12190017)
-- Name: user_monthly_summary_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_monthly_summary_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_monthly_summary_history OWNER TO armonsuper;

--
-- TOC entry 570 (class 1259 OID 12190020)
-- Name: user_monthly_summary_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_monthly_summary_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "originalId" uuid NOT NULL,
    "userId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_monthly_summary_history ATTACH PARTITION organization.user_monthly_summary_history_default DEFAULT;


ALTER TABLE organization.user_monthly_summary_history_default OWNER TO armonsuper;

--
-- TOC entry 571 (class 1259 OID 12190026)
-- Name: user_ticket_transaction_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_ticket_transaction_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "actionUserId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.user_ticket_transaction_history OWNER TO armonsuper;

--
-- TOC entry 572 (class 1259 OID 12190029)
-- Name: user_ticket_transaction_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.user_ticket_transaction_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "actionUserId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.user_ticket_transaction_history ATTACH PARTITION organization.user_ticket_transaction_history_default DEFAULT;


ALTER TABLE organization.user_ticket_transaction_history_default OWNER TO armonsuper;

--
-- TOC entry 573 (class 1259 OID 12190035)
-- Name: users; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.users (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "accountEnabled" boolean DEFAULT false NOT NULL,
    username character varying(127),
    salt character varying(63),
    "hashedPassword" character varying(255),
    "notificationToken" character varying(1024),
    "notificationTokenType" integer,
    "publicKey" character varying(2048),
    "fromLDAP" boolean DEFAULT false NOT NULL,
    settings jsonb NOT NULL
);


ALTER TABLE organization.users OWNER TO armonsuper;

--
-- TOC entry 574 (class 1259 OID 12190043)
-- Name: vW_CredentialUserProfiles; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_CredentialUserProfiles" AS
 SELECT uoc.id,
    uoc.id AS "credentialId",
    uop.id AS "profileId",
    uoc.data,
    uoc."userId",
    (((uop.name)::text || ' '::text) || (uop.surname)::text) AS "fullName",
    uoc."organizationId",
    uo."roleId"
   FROM (((organization."userOrganizationCredentials" uoc
     JOIN organization."userOrganizations" uo ON (((uo."userId" = uoc."userId") AND (uo."organizationId" = uoc."organizationId") AND (uo."deletedAt" IS NULL) AND (uoc."deletedAt" IS NULL))))
     JOIN organization.roles r ON (((r."organizationId" = uo."organizationId") AND (uo."roleId" = r.id) AND (r."typeId" <> ALL (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])))))
     JOIN organization."userOrganizationProfiles" uop ON (((uoc."userId" = uop."userId") AND (uop."deletedAt" IS NULL) AND (uoc."deletedAt" IS NULL))))
UNION ALL
 SELECT uoc.id,
    uoc.id AS "credentialId",
    uovp.id AS "profileId",
    uoc.data,
    uoc."userId",
    (((uovp.name)::text || ' '::text) || (uovp.surname)::text) AS "fullName",
    uoc."organizationId",
    uo."roleId"
   FROM (((organization."userOrganizationCredentials" uoc
     JOIN organization."userOrganizations" uo ON (((uo."userId" = uoc."userId") AND (uo."organizationId" = uoc."organizationId") AND (uo."deletedAt" IS NULL) AND (uoc."deletedAt" IS NULL))))
     JOIN organization.roles r ON (((r."organizationId" = uo."organizationId") AND (uo."roleId" = r.id) AND (r."typeId" = ANY (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])))))
     JOIN organization."userOrganizationVisitorProfiles" uovp ON (((uovp."userOrganizationId" = uo.id) AND (uovp."deletedAt" IS NULL) AND (uovp."deletedAt" IS NULL))));


ALTER TABLE organization."vW_CredentialUserProfiles" OWNER TO armonsuper;

--
-- TOC entry 575 (class 1259 OID 12190048)
-- Name: vW_SearchPPermissions; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_SearchPPermissions" AS
SELECT
    NULL::uuid AS id,
    NULL::uuid AS "organizationId",
    NULL::timestamp with time zone AS "startDateTime",
    NULL::timestamp with time zone AS "endDateTime",
    NULL::integer AS status,
    NULL::timestamp with time zone AS "requestDateTime",
    NULL::character varying(512) AS note,
    NULL::uuid AS "requestUserId",
    NULL::json AS "userPPermissions",
    NULL::json AS "userPPermissionApprovements",
    NULL::json AS "userAndDeputies",
    NULL::json AS "ppermissionType",
    NULL::json AS "nextApproverOrganizationUnitIds",
    NULL::json AS "approvedOrganizationUnitIds",
    NULL::json AS "approvementWaitingOrganizationUnitIds",
    NULL::bigint AS "userCount";


ALTER TABLE organization."vW_SearchPPermissions" OWNER TO armonsuper;

--
-- TOC entry 576 (class 1259 OID 12190052)
-- Name: vW_UserOrganizationUnitHierarchys; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_UserOrganizationUnitHierarchys" AS
 SELECT uo."organizationId" AS id,
    uo."organizationId",
    uo."userId",
    cou.id AS "ancestorOrganizationUnitId",
    ou.id AS "descenderOrganizationUnitId"
   FROM (((organization."userOrganizationOrganizationUnits" uoou
     JOIN organization."userOrganizations" uo ON (((uoou."userOrganizationId" = uo.id) AND (uoou."deletedAt" IS NULL) AND (uo."deletedAt" IS NULL))))
     JOIN organization."organizationUnits" ou ON (((ou.id = uoou."organizationUnitId") AND (ou."deletedAt" IS NULL) AND (uoou."deletedAt" IS NULL))))
     JOIN organization."organizationUnits" cou ON ((((ou.id = cou.id) OR ((ou."ancestorIds")::text ~~ (('%'::text || cou.id) || '%'::text))) AND (uoou."deletedAt" IS NULL) AND (ou."deletedAt" IS NULL) AND (cou."deletedAt" IS NULL))));


ALTER TABLE organization."vW_UserOrganizationUnitHierarchys" OWNER TO armonsuper;

--
-- TOC entry 577 (class 1259 OID 12190057)
-- Name: vW_UserHierarchys; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_UserHierarchys" AS
 SELECT mu."organizationId" AS id,
    mu."organizationId",
    uo."userId",
    mu."ancestorOrganizationUnitId",
    mu."descenderOrganizationUnitId",
    mu."userId" AS "userIdUnderAuthority"
   FROM ((organization."userOrganizationOrganizationUnits" uoou
     JOIN organization."userOrganizations" uo ON (((uoou."userOrganizationId" = uo.id) AND (uoou."deletedAt" IS NULL) AND (uo."deletedAt" IS NULL))))
     JOIN organization."vW_UserOrganizationUnitHierarchys" mu ON ((((mu."descenderOrganizationUnitId" = uoou."organizationUnitId") OR (mu."ancestorOrganizationUnitId" = uoou."organizationUnitId")) AND (uoou."deletedAt" IS NULL))));


ALTER TABLE organization."vW_UserHierarchys" OWNER TO armonsuper;

--
-- TOC entry 578 (class 1259 OID 12190062)
-- Name: workPlanPeriods; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlanPeriods" (
    id uuid NOT NULL,
    "workPlanId" uuid,
    "periodStartDateTime" timestamp with time zone,
    details json,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone
);


ALTER TABLE organization."workPlanPeriods" OWNER TO armonsuper;

--
-- TOC entry 579 (class 1259 OID 12190068)
-- Name: workPlans; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlans" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    type integer,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "regionId" uuid,
    "accessCheckType" integer DEFAULT 1,
    "endOfDayHour" character varying(8),
    "ignoreHolidays" boolean,
    timezone character(6) NOT NULL,
    "allowMobileCheckins" boolean NOT NULL,
    "allowUnreliableCheckins" boolean NOT NULL,
    "mobileCheckinRequiresLocation" boolean NOT NULL,
    "permissionRequiredForExtraWorking" boolean NOT NULL,
    "geoLocations" jsonb
);


ALTER TABLE organization."workPlans" OWNER TO armonsuper;

--
-- TOC entry 580 (class 1259 OID 12190075)
-- Name: vW_WorkPlanPeriodTstzrange; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization."vW_WorkPlanPeriodTstzrange" AS
 SELECT "workPlanPeriods".id,
    "workPlanPeriods"."workPlanId",
    "workPlanPeriods".details,
    tstzrange("workPlanPeriods"."periodStartDateTime", lead("workPlanPeriods"."periodStartDateTime") OVER (PARTITION BY "workPlanPeriods"."workPlanId" ORDER BY "workPlanPeriods"."periodStartDateTime")) AS range,
    "workPlans"."organizationId"
   FROM (organization."workPlanPeriods"
     JOIN organization."workPlans" ON (("workPlans".id = "workPlanPeriods"."workPlanId")))
  WHERE (("workPlanPeriods"."deletedAt" IS NULL) AND ("workPlans"."deletedAt" IS NULL));


ALTER TABLE organization."vW_WorkPlanPeriodTstzrange" OWNER TO armonsuper;

--
-- TOC entry 581 (class 1259 OID 12190080)
-- Name: vacations; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.vacations (
    id uuid NOT NULL,
    "organizationId" uuid,
    title character varying(255),
    "startDateTime" timestamp with time zone,
    "endDateTime" timestamp with time zone
);


ALTER TABLE organization.vacations OWNER TO armonsuper;

--
-- TOC entry 582 (class 1259 OID 12190083)
-- Name: visit_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visit_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    "visitedUserId" uuid,
    "visitorRegistrationPointId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("startUtc");


ALTER TABLE organization.visit_history OWNER TO armonsuper;

--
-- TOC entry 583 (class 1259 OID 12190086)
-- Name: visit_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visit_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "startUtc" timestamp with time zone NOT NULL,
    "endUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    "visitedUserId" uuid,
    "visitorRegistrationPointId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.visit_history ATTACH PARTITION organization.visit_history_default DEFAULT;


ALTER TABLE organization.visit_history_default OWNER TO armonsuper;

--
-- TOC entry 584 (class 1259 OID 12190092)
-- Name: visitorDailySummaries; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorDailySummaries" (
    id uuid,
    "organizationId" uuid NOT NULL,
    "visitorRegistrationPointId" uuid NOT NULL,
    reason integer NOT NULL,
    count integer NOT NULL,
    date timestamp with time zone NOT NULL,
    "averageProcessTime" double precision DEFAULT 0
);


ALTER TABLE organization."visitorDailySummaries" OWNER TO armonsuper;

--
-- TOC entry 585 (class 1259 OID 12190096)
-- Name: visitorRegistrationPointAccessControlPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorRegistrationPointAccessControlPoints" (
    id uuid NOT NULL,
    "accessControlPointId" uuid,
    "visitorRegistrationPointId" uuid
);


ALTER TABLE organization."visitorRegistrationPointAccessControlPoints" OWNER TO armonsuper;

--
-- TOC entry 586 (class 1259 OID 12190099)
-- Name: visitorRegistrationPoints; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."visitorRegistrationPoints" (
    id uuid NOT NULL,
    "organizationId" uuid,
    name character varying(255),
    "createdAt" timestamp with time zone NOT NULL,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "tabletDeviceId" uuid
);


ALTER TABLE organization."visitorRegistrationPoints" OWNER TO armonsuper;

--
-- TOC entry 587 (class 1259 OID 12190102)
-- Name: visitor_preregistration_history; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visitor_preregistration_history (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    log jsonb NOT NULL
)
PARTITION BY RANGE ("actionUtc");


ALTER TABLE organization.visitor_preregistration_history OWNER TO armonsuper;

--
-- TOC entry 588 (class 1259 OID 12190105)
-- Name: visitor_preregistration_history_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.visitor_preregistration_history_default (
    id uuid NOT NULL,
    "organizationId" uuid NOT NULL,
    "actionUtc" timestamp with time zone NOT NULL,
    "visitorProfileId" uuid NOT NULL,
    log jsonb NOT NULL
);
ALTER TABLE ONLY organization.visitor_preregistration_history ATTACH PARTITION organization.visitor_preregistration_history_default DEFAULT;


ALTER TABLE organization.visitor_preregistration_history_default OWNER TO armonsuper;

--
-- TOC entry 589 (class 1259 OID 12190111)
-- Name: vw_user_filter; Type: VIEW; Schema: organization; Owner: armonsuper
--

CREATE VIEW organization.vw_user_filter AS
 SELECT uf.id,
    json_build_object('id', uf.id, 'groupIds', COALESCE(jsonb_agg(ufg."groupId") FILTER (WHERE (ufg."groupId" IS NOT NULL)), NULL::jsonb), 'roleIds', COALESCE(jsonb_agg(ufor."roleId") FILTER (WHERE (ufor."roleId" IS NOT NULL)), NULL::jsonb), 'userIds', COALESCE(jsonb_agg(ufu."userId") FILTER (WHERE (ufu."userId" IS NOT NULL)), NULL::jsonb), 'workPlanIds', COALESCE(jsonb_agg(ufw."workPlanId") FILTER (WHERE (ufw."workPlanId" IS NOT NULL)), NULL::jsonb), 'units', COALESCE(jsonb_agg(jsonb_build_object('unitId', ufn."unitId", 'hierarchically', ufn.hierarchically, 'roleIds', ufuragg."roleIds")) FILTER (WHERE (ufn."unitId" IS NOT NULL)), NULL::jsonb)) AS filter
   FROM ((((((organization.user_filter uf
     LEFT JOIN organization.user_filter_group ufg ON ((uf.id = ufg."filterId")))
     LEFT JOIN organization.user_filter_organization_role ufor ON ((uf.id = ufor."filterId")))
     LEFT JOIN organization.user_filter_user ufu ON ((uf.id = ufu."filterId")))
     LEFT JOIN organization.user_filter_work_plan ufw ON ((uf.id = ufw."filterId")))
     LEFT JOIN organization.user_filter_unit ufn ON ((uf.id = ufn."filterId")))
     LEFT JOIN ( SELECT ufur."filterId",
            ufur."unitId",
            COALESCE(json_agg(ufur."roleId") FILTER (WHERE (ufur."roleId" IS NOT NULL)), NULL::json) AS "roleIds"
           FROM organization.user_filter_unit_role ufur
          GROUP BY ufur."filterId", ufur."unitId") ufuragg ON (((ufuragg."unitId" = ufn."unitId") AND (ufn."filterId" = ufuragg."filterId"))))
  GROUP BY uf.id;


ALTER TABLE organization.vw_user_filter OWNER TO armonsuper;

--
-- TOC entry 590 (class 1259 OID 12190116)
-- Name: workPlanNotifications; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workPlanNotifications" (
    id uuid NOT NULL,
    "workPlanId" uuid NOT NULL,
    type smallint NOT NULL,
    "scheduleSettings" jsonb NOT NULL
);


ALTER TABLE organization."workPlanNotifications" OWNER TO armonsuper;

--
-- TOC entry 591 (class 1259 OID 12190122)
-- Name: workingHoursScheduleUnrestricteds; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization."workingHoursScheduleUnrestricteds" (
    id uuid NOT NULL,
    "createdAt" timestamp with time zone,
    "updatedAt" timestamp with time zone,
    "deletedAt" timestamp with time zone,
    "workingHoursScheduleId" uuid NOT NULL,
    "expectedDailyWorkInMinutes" integer NOT NULL,
    sunday boolean DEFAULT false NOT NULL,
    monday boolean DEFAULT false NOT NULL,
    tuesday boolean DEFAULT false NOT NULL,
    wednesday boolean DEFAULT false NOT NULL,
    thursday boolean DEFAULT false NOT NULL,
    friday boolean DEFAULT false NOT NULL,
    saturday boolean DEFAULT false NOT NULL
);


ALTER TABLE organization."workingHoursScheduleUnrestricteds" OWNER TO armonsuper;

--
-- TOC entry 592 (class 1259 OID 12190132)
-- Name: zz_notification; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL,
    CONSTRAINT zz_notification_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification OWNER TO armonsuper;

--
-- TOC entry 593 (class 1259 OID 12190136)
-- Name: zz_notification_access; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_access (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_access_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification_access OWNER TO armonsuper;

--
-- TOC entry 594 (class 1259 OID 12190140)
-- Name: zz_notification_access_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_access_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "targetUserId" uuid,
    "regionId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_access_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification_access ATTACH PARTITION organization.zz_notification_access_default DEFAULT;


ALTER TABLE organization.zz_notification_access_default OWNER TO armonsuper;

--
-- TOC entry 595 (class 1259 OID 12190147)
-- Name: zz_notification_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "createdT" timestamp without time zone NOT NULL,
    type smallint NOT NULL,
    "createdByUserId" uuid,
    "receiverFilterId" uuid,
    settings jsonb,
    email boolean NOT NULL,
    sms boolean NOT NULL,
    web boolean NOT NULL,
    "pushNotification" boolean NOT NULL,
    CONSTRAINT zz_notification_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification ATTACH PARTITION organization.zz_notification_default DEFAULT;


ALTER TABLE organization.zz_notification_default OWNER TO armonsuper;

--
-- TOC entry 596 (class 1259 OID 12190161)
-- Name: zz_notification_sensor; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_sensor (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_sensor_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[]))),
    CONSTRAINT "zz_notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_notification_sensor OWNER TO armonsuper;

--
-- TOC entry 597 (class 1259 OID 12190166)
-- Name: zz_notification_sensor_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_notification_sensor_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "accessControlPointId" uuid NOT NULL,
    "sensorType" smallint NOT NULL,
    "deviceDryContactInputId" uuid NOT NULL,
    options jsonb NOT NULL,
    CONSTRAINT zz_notification_sensor_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[]))),
    CONSTRAINT "zz_notification_sensor_sensorType_check" CHECK (("sensorType" = ANY ('{1,2}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_notification_sensor ATTACH PARTITION organization.zz_notification_sensor_default DEFAULT;


ALTER TABLE organization.zz_notification_sensor_default OWNER TO armonsuper;

--
-- TOC entry 598 (class 1259 OID 12190174)
-- Name: zz_pacs_notification_scheduled_job; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_pacs_notification_scheduled_job (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL,
    CONSTRAINT zz_pacs_notification_scheduled_job_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
)
PARTITION BY RANGE ("actionT");


ALTER TABLE organization.zz_pacs_notification_scheduled_job OWNER TO armonsuper;

--
-- TOC entry 599 (class 1259 OID 12190178)
-- Name: zz_pacs_notification_scheduled_job_default; Type: TABLE; Schema: organization; Owner: armonsuper
--

CREATE TABLE organization.zz_pacs_notification_scheduled_job_default (
    id uuid NOT NULL,
    action smallint NOT NULL,
    "actionT" timestamp without time zone NOT NULL,
    "transactionId" bigint NOT NULL,
    "subjectedEmployeesFilterId" uuid NOT NULL,
    CONSTRAINT zz_pacs_notification_scheduled_job_action_check CHECK ((action = ANY ('{1,2,3}'::smallint[])))
);
ALTER TABLE ONLY organization.zz_pacs_notification_scheduled_job ATTACH PARTITION organization.zz_pacs_notification_scheduled_job_default DEFAULT;


ALTER TABLE organization.zz_pacs_notification_scheduled_job_default OWNER TO armonsuper;

--
-- TOC entry 4657 (class 2606 OID 12191539)
-- Name: accessControlPoints accessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT "accessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 4659 (class 2606 OID 12191541)
-- Name: accessRuleHistory accessRuleHistory_createdDate_accessRuleId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_createdDate_accessRuleId_userId_key" UNIQUE ("createdDate", "accessRuleId", "userId");


--
-- TOC entry 4661 (class 2606 OID 12191543)
-- Name: accessRuleHistory accessRuleHistory_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_pkey" PRIMARY KEY (id);


--
-- TOC entry 4663 (class 2606 OID 12191545)
-- Name: accessRuleSets accessRuleSets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT "accessRuleSets_pkey" PRIMARY KEY (id);


--
-- TOC entry 4665 (class 2606 OID 12191547)
-- Name: accessRules accessRules_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRules"
    ADD CONSTRAINT "accessRules_pkey" PRIMARY KEY (id);


--
-- TOC entry 4669 (class 2606 OID 12191549)
-- Name: access_logs access_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_logs
    ADD CONSTRAINT access_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4673 (class 2606 OID 12191551)
-- Name: access_logs_default access_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_logs_default
    ADD CONSTRAINT access_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4675 (class 2606 OID 12191553)
-- Name: access_point_qr_code access_point_qr_code_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT access_point_qr_code_pkey PRIMARY KEY (id);


--
-- TOC entry 4677 (class 2606 OID 12191555)
-- Name: access_point_qr_code access_point_qr_code_qrCodeData_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT "access_point_qr_code_qrCodeData_key" UNIQUE ("qrCodeData");


--
-- TOC entry 4679 (class 2606 OID 12191557)
-- Name: access_snapshots access_snapshots_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_snapshots
    ADD CONSTRAINT access_snapshots_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4681 (class 2606 OID 12191559)
-- Name: access_snapshots_default access_snapshots_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_snapshots_default
    ADD CONSTRAINT access_snapshots_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4683 (class 2606 OID 12191561)
-- Name: adapters adapters_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_pkey PRIMARY KEY (id);


--
-- TOC entry 4685 (class 2606 OID 12191563)
-- Name: antiPassbackStates antiPassbackStates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_pkey" PRIMARY KEY (id);


--
-- TOC entry 4687 (class 2606 OID 12191565)
-- Name: aperioLocks aperioLocks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT "aperioLocks_pkey" PRIMARY KEY ("hubDeviceId", "lockDeviceId");


--
-- TOC entry 4689 (class 2606 OID 12191567)
-- Name: attendanceAccessControlPoints attendanceAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "attendanceAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 4691 (class 2606 OID 12191569)
-- Name: cameras cameras_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT cameras_pkey PRIMARY KEY (id);


--
-- TOC entry 4693 (class 2606 OID 12191571)
-- Name: controlPanelESeriesSettings controlPanelESeriesSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT "controlPanelESeriesSettings_pkey" PRIMARY KEY ("deviceId");


--
-- TOC entry 4695 (class 2606 OID 12191573)
-- Name: controlPanelMSeriesAnalogInputs controlPanelMSeriesAnalogInputs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesAnalogInputs"
    ADD CONSTRAINT "controlPanelMSeriesAnalogInputs_pkey" PRIMARY KEY (id);


--
-- TOC entry 4697 (class 2606 OID 12191575)
-- Name: controlPanelMSeriesSettings controlPanelMSeriesSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesSettings"
    ADD CONSTRAINT "controlPanelMSeriesSettings_pkey" PRIMARY KEY ("deviceId");


--
-- TOC entry 4702 (class 2606 OID 12191577)
-- Name: counter_sensor_logs counter_sensor_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.counter_sensor_logs
    ADD CONSTRAINT counter_sensor_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4707 (class 2606 OID 12191579)
-- Name: counter_sensor_logs_default counter_sensor_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.counter_sensor_logs_default
    ADD CONSTRAINT counter_sensor_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4709 (class 2606 OID 12191581)
-- Name: customReports customReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."customReports"
    ADD CONSTRAINT "customReports_pkey" PRIMARY KEY (id);


--
-- TOC entry 4711 (class 2606 OID 12191583)
-- Name: deviceCurrentVersions deviceCurrentVersions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceCurrentVersions"
    ADD CONSTRAINT "deviceCurrentVersions_pkey" PRIMARY KEY (brand, model);


--
-- TOC entry 4713 (class 2606 OID 12191585)
-- Name: deviceDryContactInputs deviceDryContactInputs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT "deviceDryContactInputs_pkey" PRIMARY KEY (id);


--
-- TOC entry 4715 (class 2606 OID 12191587)
-- Name: deviceIntegrations deviceIntegrations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT "deviceIntegrations_pkey" PRIMARY KEY ("integratedDeviceId", "integratingDeviceId");


--
-- TOC entry 4717 (class 2606 OID 12191589)
-- Name: deviceReaders deviceReaders_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT "deviceReaders_pkey" PRIMARY KEY (id);


--
-- TOC entry 4719 (class 2606 OID 12191591)
-- Name: deviceRelays deviceRelays_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT "deviceRelays_pkey" PRIMARY KEY (id);


--
-- TOC entry 4721 (class 2606 OID 12191593)
-- Name: deviceUpdateStatus deviceUpdateStatus_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceUpdateStatus"
    ADD CONSTRAINT "deviceUpdateStatus_pkey" PRIMARY KEY ("deviceId", version);


--
-- TOC entry 4723 (class 2606 OID 12191595)
-- Name: deviceWiegandReaders deviceWiegandReaders_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT "deviceWiegandReaders_pkey" PRIMARY KEY (id);


--
-- TOC entry 4725 (class 2606 OID 12191597)
-- Name: devices devices_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_pkey PRIMARY KEY (id);


--
-- TOC entry 4727 (class 2606 OID 12191599)
-- Name: employeeDays employeeDays_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT "employeeDays_pkey" PRIMARY KEY (id);


--
-- TOC entry 4729 (class 2606 OID 12191601)
-- Name: employeeDays employeeDays_userId_date_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT "employeeDays_userId_date_organizationId_key" UNIQUE ("userId", date, "organizationId");


--
-- TOC entry 4731 (class 2606 OID 12191603)
-- Name: employeeLiveDay employeeLiveDay_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_pkey" PRIMARY KEY (id);


--
-- TOC entry 4733 (class 2606 OID 12191605)
-- Name: employeeLiveDay employeeLiveDay_userId_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_userId_organizationId_key" UNIQUE ("userId", "organizationId");


--
-- TOC entry 4735 (class 2606 OID 12191607)
-- Name: employeeMonths employeeMonths_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_pkey" PRIMARY KEY (id);


--
-- TOC entry 4737 (class 2606 OID 12191609)
-- Name: employeeMonths employeeMonths_userId_organizationId_date_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_userId_organizationId_date_key" UNIQUE ("userId", "organizationId", date);


--
-- TOC entry 4743 (class 2606 OID 12191611)
-- Name: floorPlans floorPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."floorPlans"
    ADD CONSTRAINT "floorPlans_pkey" PRIMARY KEY (id);


--
-- TOC entry 4745 (class 2606 OID 12191613)
-- Name: hikVisionLicencePlateCameraLanes hikVisionLicencePlateCameraLanes_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT "hikVisionLicencePlateCameraLanes_pkey" PRIMARY KEY (id);


--
-- TOC entry 4747 (class 2606 OID 12191615)
-- Name: impinjSpeedWayGateWayAntennas impinjSpeedWayGateWayAntennas_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT "impinjSpeedWayGateWayAntennas_pkey" PRIMARY KEY (id);


--
-- TOC entry 4750 (class 2606 OID 12191617)
-- Name: log_history log_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_history
    ADD CONSTRAINT log_history_pkey PRIMARY KEY (id, "insertionUtc");


--
-- TOC entry 4753 (class 2606 OID 12191619)
-- Name: log_history_default log_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_history_default
    ADD CONSTRAINT log_history_default_pkey PRIMARY KEY (id, "insertionUtc");


--
-- TOC entry 4755 (class 2606 OID 12191621)
-- Name: log_process_history log_process_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_process_history
    ADD CONSTRAINT log_process_history_pkey PRIMARY KEY ("startUtc");


--
-- TOC entry 4757 (class 2606 OID 12191623)
-- Name: log_process_history_default log_process_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.log_process_history_default
    ADD CONSTRAINT log_process_history_default_pkey PRIMARY KEY ("startUtc");


--
-- TOC entry 4759 (class 2606 OID 12191625)
-- Name: medium_sms medium_sms_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.medium_sms
    ADD CONSTRAINT medium_sms_pkey PRIMARY KEY (id);


--
-- TOC entry 4761 (class 2606 OID 12191627)
-- Name: medium_smtp medium_smtp_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.medium_smtp
    ADD CONSTRAINT medium_smtp_pkey PRIMARY KEY (id);


--
-- TOC entry 4763 (class 2606 OID 12191629)
-- Name: monthlySummaryReports monthlySummaryReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."monthlySummaryReports"
    ADD CONSTRAINT "monthlySummaryReports_pkey" PRIMARY KEY (id);


--
-- TOC entry 4768 (class 2606 OID 12191631)
-- Name: monthly_summary_history monthly_summary_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.monthly_summary_history
    ADD CONSTRAINT monthly_summary_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4773 (class 2606 OID 12191633)
-- Name: monthly_summary_history_default monthly_summary_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.monthly_summary_history_default
    ADD CONSTRAINT monthly_summary_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4777 (class 2606 OID 12191635)
-- Name: notificationAttachments notificationAttachments_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."notificationAttachments"
    ADD CONSTRAINT "notificationAttachments_pkey" PRIMARY KEY (id);


--
-- TOC entry 4779 (class 2606 OID 12191637)
-- Name: notification_access notification_access_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_pkey PRIMARY KEY (id);


--
-- TOC entry 4781 (class 2606 OID 12191639)
-- Name: notification_event notification_event_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event
    ADD CONSTRAINT notification_event_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4783 (class 2606 OID 12191641)
-- Name: notification_event_default notification_event_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event_default
    ADD CONSTRAINT notification_event_default_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4785 (class 2606 OID 12191643)
-- Name: notification_event_p202101 notification_event_p202101_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event_p202101
    ADD CONSTRAINT notification_event_p202101_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4787 (class 2606 OID 12191645)
-- Name: notification_event_p202102 notification_event_p202102_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_event_p202102
    ADD CONSTRAINT notification_event_p202102_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4789 (class 2606 OID 12191647)
-- Name: notification_instance notification_instance_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_instance
    ADD CONSTRAINT notification_instance_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4791 (class 2606 OID 12191649)
-- Name: notification_instance_default notification_instance_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_instance_default
    ADD CONSTRAINT notification_instance_default_pkey PRIMARY KEY (id, "createdT");


--
-- TOC entry 4775 (class 2606 OID 12191651)
-- Name: notification notification_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT notification_pkey PRIMARY KEY (id);


--
-- TOC entry 4793 (class 2606 OID 12191653)
-- Name: notification_sensor notification_sensor_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_pkey PRIMARY KEY (id);


--
-- TOC entry 4795 (class 2606 OID 12191655)
-- Name: oAuthClients oAuthClients_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthClients"
    ADD CONSTRAINT "oAuthClients_pkey" PRIMARY KEY (id);


--
-- TOC entry 4797 (class 2606 OID 12191657)
-- Name: oAuthTokens oAuthTokens_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_pkey" PRIMARY KEY (id);


--
-- TOC entry 4799 (class 2606 OID 12191659)
-- Name: organizationActiveVisits organizationActiveVisits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_pkey" PRIMARY KEY (id);


--
-- TOC entry 4801 (class 2606 OID 12191661)
-- Name: organizationEmailTemplates organizationEmailTemplates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationEmailTemplates"
    ADD CONSTRAINT "organizationEmailTemplates_pkey" PRIMARY KEY (id);


--
-- TOC entry 4803 (class 2606 OID 12191663)
-- Name: organizationFeedbacks organizationFeedbacks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT "organizationFeedbacks_pkey" PRIMARY KEY (id);


--
-- TOC entry 4805 (class 2606 OID 12191665)
-- Name: organizationForms organizationForms_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationForms"
    ADD CONSTRAINT "organizationForms_pkey" PRIMARY KEY (id);


--
-- TOC entry 4807 (class 2606 OID 12191667)
-- Name: organizationModules organizationModules_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationModules"
    ADD CONSTRAINT "organizationModules_pkey" PRIMARY KEY (id);


--
-- TOC entry 4809 (class 2606 OID 12191669)
-- Name: organizationPACSModuleSettings organizationPACSModuleSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationPACSModuleSettings"
    ADD CONSTRAINT "organizationPACSModuleSettings_pkey" PRIMARY KEY (id);


--
-- TOC entry 4811 (class 2606 OID 12191671)
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 4813 (class 2606 OID 12191673)
-- Name: organizationUnits organizationUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_pkey" PRIMARY KEY (id);


--
-- TOC entry 4815 (class 2606 OID 12191675)
-- Name: organizationUserDefinedListValues organizationUserDefinedListValues_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedListValues"
    ADD CONSTRAINT "organizationUserDefinedListValues_pkey" PRIMARY KEY (id);


--
-- TOC entry 4817 (class 2606 OID 12191677)
-- Name: organizationUserDefinedLists organizationUserDefinedLists_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedLists"
    ADD CONSTRAINT "organizationUserDefinedLists_pkey" PRIMARY KEY (id);


--
-- TOC entry 4819 (class 2606 OID 12191679)
-- Name: organizationUserSync organizationUserSync_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserSync"
    ADD CONSTRAINT "organizationUserSync_pkey" PRIMARY KEY (id);


--
-- TOC entry 4821 (class 2606 OID 12191681)
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 4823 (class 2606 OID 12191683)
-- Name: organizationVisitorModuleSettings organizationVisitorModuleSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorModuleSettings"
    ADD CONSTRAINT "organizationVisitorModuleSettings_pkey" PRIMARY KEY (id);


--
-- TOC entry 4825 (class 2606 OID 12191685)
-- Name: organizationVisitorProfiles organizationVisitorProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorProfiles"
    ADD CONSTRAINT "organizationVisitorProfiles_pkey" PRIMARY KEY (id);


--
-- TOC entry 4827 (class 2606 OID 12191687)
-- Name: organizationVisitorStates organizationVisitorStates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT "organizationVisitorStates_pkey" PRIMARY KEY (id);


--
-- TOC entry 4831 (class 2606 OID 12191689)
-- Name: organization_feedback_updates organization_feedback_updates_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedback_updates
    ADD CONSTRAINT organization_feedback_updates_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4836 (class 2606 OID 12191691)
-- Name: organization_feedback_updates_default organization_feedback_updates_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedback_updates_default
    ADD CONSTRAINT organization_feedback_updates_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4841 (class 2606 OID 12191693)
-- Name: organization_feedbacks organization_feedbacks_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedbacks
    ADD CONSTRAINT organization_feedbacks_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4846 (class 2606 OID 12191695)
-- Name: organization_feedbacks_default organization_feedbacks_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organization_feedbacks_default
    ADD CONSTRAINT organization_feedbacks_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4849 (class 2606 OID 12191697)
-- Name: organizations organizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organizations
    ADD CONSTRAINT organizations_pkey PRIMARY KEY (id);


--
-- TOC entry 4851 (class 2606 OID 12191699)
-- Name: pacs_notification_scheduled_job pacs_notification_scheduled_job_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT pacs_notification_scheduled_job_pkey PRIMARY KEY (id);


--
-- TOC entry 4853 (class 2606 OID 12191701)
-- Name: ppermissionAttachments ppermissionAttachments_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionAttachments"
    ADD CONSTRAINT "ppermissionAttachments_pkey" PRIMARY KEY (id);


--
-- TOC entry 4855 (class 2606 OID 12191703)
-- Name: ppermissionClaims ppermissionClaims_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_pkey" PRIMARY KEY (id);


--
-- TOC entry 4857 (class 2606 OID 12191705)
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_pkey" PRIMARY KEY (id);


--
-- TOC entry 4860 (class 2606 OID 12191707)
-- Name: ppermissionTypes ppermissionTypes_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypes"
    ADD CONSTRAINT "ppermissionTypes_pkey" PRIMARY KEY (id);


--
-- TOC entry 4864 (class 2606 OID 12191709)
-- Name: ppermission_history ppermission_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermission_history
    ADD CONSTRAINT ppermission_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4868 (class 2606 OID 12191711)
-- Name: ppermission_history_default ppermission_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermission_history_default
    ADD CONSTRAINT ppermission_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4870 (class 2606 OID 12191713)
-- Name: ppermissions ppermissions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT ppermissions_pkey PRIMARY KEY (id);


--
-- TOC entry 4873 (class 2606 OID 12191715)
-- Name: preparedReports preparedReports_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preparedReports"
    ADD CONSTRAINT "preparedReports_pkey" PRIMARY KEY (id);


--
-- TOC entry 4875 (class 2606 OID 12191717)
-- Name: preregisterDailySummaries preregisterDailySummaries_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preregisterDailySummaries"
    ADD CONSTRAINT "preregisterDailySummaries_pkey" PRIMARY KEY (id);


--
-- TOC entry 4877 (class 2606 OID 12191719)
-- Name: recalculateWorkQueue recalculateWorkQueue_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT "recalculateWorkQueue_pkey" PRIMARY KEY (id);


--
-- TOC entry 4879 (class 2606 OID 12191721)
-- Name: recalculateWorkQueue recalculateWorkQueue_userId_organizationId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT "recalculateWorkQueue_userId_organizationId_key" UNIQUE ("userId", "organizationId");


--
-- TOC entry 4881 (class 2606 OID 12191723)
-- Name: regionAccessControlPoints regionAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 4883 (class 2606 OID 12191725)
-- Name: regionTickets regionTickets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT "regionTickets_pkey" PRIMARY KEY (id);


--
-- TOC entry 4885 (class 2606 OID 12191727)
-- Name: regions regions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.regions
    ADD CONSTRAINT regions_pkey PRIMARY KEY (id);


--
-- TOC entry 4887 (class 2606 OID 12191729)
-- Name: report_scheduled_job report_scheduled_job_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_scheduled_job
    ADD CONSTRAINT report_scheduled_job_pkey PRIMARY KEY (id);


--
-- TOC entry 4889 (class 2606 OID 12191731)
-- Name: report_templates report_template_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT report_template_pkey PRIMARY KEY (id);


--
-- TOC entry 4891 (class 2606 OID 12191733)
-- Name: roles roles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- TOC entry 4893 (class 2606 OID 12191735)
-- Name: softwares softwares_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.softwares
    ADD CONSTRAINT softwares_pkey PRIMARY KEY (id);


--
-- TOC entry 4898 (class 2606 OID 12191737)
-- Name: status_sensor_logs status_sensor_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.status_sensor_logs
    ADD CONSTRAINT status_sensor_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4903 (class 2606 OID 12191739)
-- Name: status_sensor_logs_default status_sensor_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.status_sensor_logs_default
    ADD CONSTRAINT status_sensor_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4905 (class 2606 OID 12191741)
-- Name: stickerAccessControlPointMappings stickerAccessControlPointMappings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."stickerAccessControlPointMappings"
    ADD CONSTRAINT "stickerAccessControlPointMappings_pkey" PRIMARY KEY ("stickerId");


--
-- TOC entry 4908 (class 2606 OID 12191743)
-- Name: system_status_logs system_status_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.system_status_logs
    ADD CONSTRAINT system_status_logs_pkey PRIMARY KEY (id, type, "actionUtc");


--
-- TOC entry 4911 (class 2606 OID 12191745)
-- Name: system_status_logs_default system_status_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.system_status_logs_default
    ADD CONSTRAINT system_status_logs_default_pkey PRIMARY KEY (id, type, "actionUtc");


--
-- TOC entry 4915 (class 2606 OID 12191747)
-- Name: tamper_switch_logs tamper_switch_logs_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.tamper_switch_logs
    ADD CONSTRAINT tamper_switch_logs_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4919 (class 2606 OID 12191749)
-- Name: tamper_switch_logs_default tamper_switch_logs_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.tamper_switch_logs_default
    ADD CONSTRAINT tamper_switch_logs_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4921 (class 2606 OID 12191751)
-- Name: terminalAdministrators terminalAdministrators_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_pkey" PRIMARY KEY (id);


--
-- TOC entry 4923 (class 2606 OID 12191753)
-- Name: terminalAdministrators terminalAdministrators_terminalId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_terminalId_userId_key" UNIQUE ("terminalId", "userId");


--
-- TOC entry 4925 (class 2606 OID 12191755)
-- Name: terminalChangeTransactions terminalChangeTransactions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChangeTransactions"
    ADD CONSTRAINT "terminalChangeTransactions_pkey" PRIMARY KEY ("transactionId", "deviceId");


--
-- TOC entry 4927 (class 2606 OID 12191757)
-- Name: terminalChanges terminalChanges_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChanges"
    ADD CONSTRAINT "terminalChanges_pkey" PRIMARY KEY (id);


--
-- TOC entry 4933 (class 2606 OID 12191759)
-- Name: upload_log_history upload_log_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.upload_log_history
    ADD CONSTRAINT upload_log_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4938 (class 2606 OID 12191761)
-- Name: upload_log_history_default upload_log_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.upload_log_history_default
    ADD CONSTRAINT upload_log_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 4941 (class 2606 OID 12191763)
-- Name: userAccessRights userAccessRights_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_pkey" PRIMARY KEY (id);


--
-- TOC entry 4943 (class 2606 OID 12191765)
-- Name: userAccessRights userAccessRights_userId_accessControlPointId_deletedAt_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_userId_accessControlPointId_deletedAt_key" UNIQUE ("userId", "accessControlPointId", "deletedAt");


--
-- TOC entry 4945 (class 2606 OID 12191767)
-- Name: userGroupAccessRuleSets userGroupAccessRuleSets_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT "userGroupAccessRuleSets_pkey" PRIMARY KEY (id);


--
-- TOC entry 4947 (class 2606 OID 12191769)
-- Name: userGroupUserOrganizations userGroupUserOrganizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_pkey" PRIMARY KEY (id);


--
-- TOC entry 4949 (class 2606 OID 12191771)
-- Name: userGroups userGroups_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_pkey" PRIMARY KEY (id);


--
-- TOC entry 4951 (class 2606 OID 12191773)
-- Name: userOrganizationCredentials userOrganizationCredentials_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_pkey" PRIMARY KEY (id);


--
-- TOC entry 4954 (class 2606 OID 12191775)
-- Name: userOrganizationDeputies userOrganizationDeputies_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_pkey" PRIMARY KEY (id);


--
-- TOC entry 4956 (class 2606 OID 12191777)
-- Name: userOrganizationForbiddances userOrganizationForbiddances_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT "userOrganizationForbiddances_pkey" PRIMARY KEY (id);


--
-- TOC entry 4958 (class 2606 OID 12191779)
-- Name: userOrganizationLeaves userOrganizationLeaves_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_pkey" PRIMARY KEY (id);


--
-- TOC entry 4960 (class 2606 OID 12191781)
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_pkey" PRIMARY KEY (id);


--
-- TOC entry 4962 (class 2606 OID 12191783)
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_pkey" PRIMARY KEY (id);


--
-- TOC entry 4964 (class 2606 OID 12191785)
-- Name: userOrganizationProfiles userOrganizationProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_pkey" PRIMARY KEY (id);


--
-- TOC entry 4968 (class 2606 OID 12191787)
-- Name: userOrganizationSettings userOrganizationSettings_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationSettings"
    ADD CONSTRAINT "userOrganizationSettings_pkey" PRIMARY KEY (id);


--
-- TOC entry 4970 (class 2606 OID 12191789)
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_pkey" PRIMARY KEY (id);


--
-- TOC entry 4972 (class 2606 OID 12191791)
-- Name: userOrganizationVisits userOrganizationVisits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_pkey" PRIMARY KEY (id);


--
-- TOC entry 4974 (class 2606 OID 12191793)
-- Name: userOrganizations userOrganizations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_pkey" PRIMARY KEY (id);


--
-- TOC entry 4977 (class 2606 OID 12191795)
-- Name: userPPermissionApprovements userPPermissionApprovements_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_pkey" PRIMARY KEY (id);


--
-- TOC entry 4979 (class 2606 OID 12191797)
-- Name: userPPermissions userPPermissions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissions"
    ADD CONSTRAINT "userPPermissions_pkey" PRIMARY KEY (id);


--
-- TOC entry 4982 (class 2606 OID 12191799)
-- Name: userProfiles userProfiles_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userProfiles"
    ADD CONSTRAINT "userProfiles_pkey" PRIMARY KEY (id);


--
-- TOC entry 4985 (class 2606 OID 12191801)
-- Name: userRegionTicketUnits userRegionTicketUnits_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT "userRegionTicketUnits_pkey" PRIMARY KEY (id);


--
-- TOC entry 4987 (class 2606 OID 12191803)
-- Name: userSelectionSessionActions userSelectionSessionActions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_pkey" PRIMARY KEY (id);


--
-- TOC entry 4989 (class 2606 OID 12191805)
-- Name: userSelectionSessionActions userSelectionSessionActions_sessionId_userId_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_sessionId_userId_key" UNIQUE ("sessionId", "userId");


--
-- TOC entry 4991 (class 2606 OID 12191807)
-- Name: userSelectionSessions userSelectionSessions_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_pkey" PRIMARY KEY (id);


--
-- TOC entry 4993 (class 2606 OID 12191809)
-- Name: userWorkPlans userWorkPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_pkey" PRIMARY KEY (id);


--
-- TOC entry 4998 (class 2606 OID 12191811)
-- Name: user_action_history user_action_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_action_history
    ADD CONSTRAINT user_action_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5004 (class 2606 OID 12191813)
-- Name: user_action_history_default user_action_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_action_history_default
    ADD CONSTRAINT user_action_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5009 (class 2606 OID 12191815)
-- Name: user_filter_group user_filter_group_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_pkey PRIMARY KEY ("filterId", "groupId");


--
-- TOC entry 5011 (class 2606 OID 12191817)
-- Name: user_filter_organization_role user_filter_organization_role_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_pkey PRIMARY KEY ("filterId", "roleId");


--
-- TOC entry 5007 (class 2606 OID 12191819)
-- Name: user_filter user_filter_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter
    ADD CONSTRAINT user_filter_pkey PRIMARY KEY (id);


--
-- TOC entry 5013 (class 2606 OID 12191821)
-- Name: user_filter_unit user_filter_unit_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_pkey PRIMARY KEY ("filterId", "unitId");


--
-- TOC entry 5015 (class 2606 OID 12191823)
-- Name: user_filter_unit_role user_filter_unit_role_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_pkey PRIMARY KEY ("filterId", "unitId", "roleId");


--
-- TOC entry 5017 (class 2606 OID 12191825)
-- Name: user_filter_user user_filter_user_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_pkey PRIMARY KEY ("filterId", "userId");


--
-- TOC entry 5019 (class 2606 OID 12191827)
-- Name: user_filter_work_plan user_filter_work_plan_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_pkey PRIMARY KEY ("filterId", "workPlanId");


--
-- TOC entry 5024 (class 2606 OID 12191829)
-- Name: user_monthly_summary_history user_monthly_summary_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_monthly_summary_history
    ADD CONSTRAINT user_monthly_summary_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5030 (class 2606 OID 12191831)
-- Name: user_monthly_summary_history_default user_monthly_summary_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_monthly_summary_history_default
    ADD CONSTRAINT user_monthly_summary_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5036 (class 2606 OID 12191833)
-- Name: user_ticket_transaction_history user_ticket_transaction_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_ticket_transaction_history
    ADD CONSTRAINT user_ticket_transaction_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5041 (class 2606 OID 12191835)
-- Name: user_ticket_transaction_history_default user_ticket_transaction_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_ticket_transaction_history_default
    ADD CONSTRAINT user_ticket_transaction_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5043 (class 2606 OID 12191837)
-- Name: users users_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- TOC entry 5046 (class 2606 OID 12191839)
-- Name: users users_username_key; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT users_username_key UNIQUE (username);


--
-- TOC entry 5052 (class 2606 OID 12191841)
-- Name: vacations vacations_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.vacations
    ADD CONSTRAINT vacations_pkey PRIMARY KEY (id);


--
-- TOC entry 5057 (class 2606 OID 12191843)
-- Name: visit_history visit_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visit_history
    ADD CONSTRAINT visit_history_pkey PRIMARY KEY (id, "startUtc");


--
-- TOC entry 5065 (class 2606 OID 12191845)
-- Name: visit_history_default visit_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visit_history_default
    ADD CONSTRAINT visit_history_default_pkey PRIMARY KEY (id, "startUtc");


--
-- TOC entry 5071 (class 2606 OID 12191847)
-- Name: visitorRegistrationPointAccessControlPoints visitorRegistrationPointAccessControlPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT "visitorRegistrationPointAccessControlPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 5073 (class 2606 OID 12191849)
-- Name: visitorRegistrationPoints visitorRegistrationPoints_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT "visitorRegistrationPoints_pkey" PRIMARY KEY (id);


--
-- TOC entry 5077 (class 2606 OID 12191851)
-- Name: visitor_preregistration_history visitor_preregistration_history_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visitor_preregistration_history
    ADD CONSTRAINT visitor_preregistration_history_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5082 (class 2606 OID 12191853)
-- Name: visitor_preregistration_history_default visitor_preregistration_history_default_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.visitor_preregistration_history_default
    ADD CONSTRAINT visitor_preregistration_history_default_pkey PRIMARY KEY (id, "actionUtc");


--
-- TOC entry 5085 (class 2606 OID 12191855)
-- Name: workPlanNotifications workPlanNotifications_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanNotifications"
    ADD CONSTRAINT "workPlanNotifications_pkey" PRIMARY KEY (id);


--
-- TOC entry 5048 (class 2606 OID 12191857)
-- Name: workPlanPeriods workPlanPeriods_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanPeriods"
    ADD CONSTRAINT "workPlanPeriods_pkey" PRIMARY KEY (id);


--
-- TOC entry 5050 (class 2606 OID 12191859)
-- Name: workPlans workPlans_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlans"
    ADD CONSTRAINT "workPlans_pkey" PRIMARY KEY (id);


--
-- TOC entry 5087 (class 2606 OID 12191861)
-- Name: workingHoursScheduleUnrestricteds workingHoursScheduleUnrestricteds_pkey; Type: CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workingHoursScheduleUnrestricteds"
    ADD CONSTRAINT "workingHoursScheduleUnrestricteds_pkey" PRIMARY KEY (id);


--
-- TOC entry 4666 (class 1259 OID 12193131)
-- Name: access_logs_credentialData_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "access_logs_credentialData_idx" ON ONLY organization.access_logs USING gin ("credentialData");


--
-- TOC entry 4670 (class 1259 OID 12193132)
-- Name: access_logs_default_credentialData_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "access_logs_default_credentialData_idx" ON organization.access_logs_default USING gin ("credentialData");


--
-- TOC entry 4667 (class 1259 OID 12193133)
-- Name: access_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX access_logs_log_idx ON ONLY organization.access_logs USING gin (log);


--
-- TOC entry 4671 (class 1259 OID 12193134)
-- Name: access_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX access_logs_default_log_idx ON organization.access_logs_default USING gin (log);


--
-- TOC entry 4928 (class 1259 OID 12193135)
-- Name: bx_organization_transaction_id; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_organization_transaction_id ON ONLY organization.transaction USING btree (id DESC NULLS LAST);


--
-- TOC entry 5088 (class 1259 OID 12193136)
-- Name: bx_zz_notification; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification ON ONLY organization.zz_notification USING btree (id DESC NULLS LAST);


--
-- TOC entry 5089 (class 1259 OID 12193137)
-- Name: bx_zz_notification_access; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_access ON ONLY organization.zz_notification_access USING btree (id DESC NULLS LAST);


--
-- TOC entry 5092 (class 1259 OID 12193138)
-- Name: bx_zz_notification_sensor; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_notification_sensor ON ONLY organization.zz_notification_sensor USING btree (id DESC NULLS LAST);


--
-- TOC entry 5094 (class 1259 OID 12193139)
-- Name: bx_zz_pacs_notification_scheduled_job; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX bx_zz_pacs_notification_scheduled_job ON ONLY organization.zz_pacs_notification_scheduled_job USING btree (id DESC NULLS LAST);


--
-- TOC entry 4698 (class 1259 OID 12193140)
-- Name: counter_sensor_logs_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_accessControlPointId_idx" ON ONLY organization.counter_sensor_logs USING btree ("accessControlPointId");


--
-- TOC entry 4703 (class 1259 OID 12193141)
-- Name: counter_sensor_logs_default_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_default_accessControlPointId_idx" ON organization.counter_sensor_logs_default USING btree ("accessControlPointId");


--
-- TOC entry 4699 (class 1259 OID 12193142)
-- Name: counter_sensor_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX counter_sensor_logs_log_idx ON ONLY organization.counter_sensor_logs USING gin (log);


--
-- TOC entry 4704 (class 1259 OID 12193143)
-- Name: counter_sensor_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX counter_sensor_logs_default_log_idx ON organization.counter_sensor_logs_default USING gin (log);


--
-- TOC entry 4700 (class 1259 OID 12193144)
-- Name: counter_sensor_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_organizationId_idx" ON ONLY organization.counter_sensor_logs USING btree ("organizationId");


--
-- TOC entry 4705 (class 1259 OID 12193145)
-- Name: counter_sensor_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "counter_sensor_logs_default_organizationId_idx" ON organization.counter_sensor_logs_default USING btree ("organizationId");


--
-- TOC entry 4738 (class 1259 OID 12193146)
-- Name: employee_day_segments_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_userId_idx" ON ONLY organization.employee_day_segments USING btree ("userId");


--
-- TOC entry 4740 (class 1259 OID 12193147)
-- Name: employee_day_segments_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_default_userId_idx" ON organization.employee_day_segments_default USING btree ("userId");


--
-- TOC entry 4739 (class 1259 OID 12193148)
-- Name: employee_day_segments_workPlanId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_workPlanId_idx" ON ONLY organization.employee_day_segments USING btree ("workPlanId");


--
-- TOC entry 4741 (class 1259 OID 12193149)
-- Name: employee_day_segments_default_workPlanId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "employee_day_segments_default_workPlanId_idx" ON organization.employee_day_segments_default USING btree ("workPlanId");


--
-- TOC entry 4748 (class 1259 OID 12193150)
-- Name: log_history_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX log_history_data_idx ON ONLY organization.log_history USING gin (data);


--
-- TOC entry 4751 (class 1259 OID 12193151)
-- Name: log_history_default_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX log_history_default_data_idx ON organization.log_history_default USING gin (data);


--
-- TOC entry 4764 (class 1259 OID 12193152)
-- Name: monthly_summary_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX monthly_summary_history_log_idx ON ONLY organization.monthly_summary_history USING gin (log);


--
-- TOC entry 4769 (class 1259 OID 12193153)
-- Name: monthly_summary_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX monthly_summary_history_default_log_idx ON organization.monthly_summary_history_default USING gin (log);


--
-- TOC entry 4765 (class 1259 OID 12193154)
-- Name: monthly_summary_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_organizationId_idx" ON ONLY organization.monthly_summary_history USING btree ("organizationId");


--
-- TOC entry 4770 (class 1259 OID 12193155)
-- Name: monthly_summary_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_default_organizationId_idx" ON organization.monthly_summary_history_default USING btree ("organizationId");


--
-- TOC entry 4766 (class 1259 OID 12193156)
-- Name: monthly_summary_history_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_originalId_idx" ON ONLY organization.monthly_summary_history USING btree ("originalId");


--
-- TOC entry 4771 (class 1259 OID 12193157)
-- Name: monthly_summary_history_default_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "monthly_summary_history_default_originalId_idx" ON organization.monthly_summary_history_default USING btree ("originalId");


--
-- TOC entry 4828 (class 1259 OID 12193158)
-- Name: organization_feedback_updates_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedback_updates_log_idx ON ONLY organization.organization_feedback_updates USING gin (log);


--
-- TOC entry 4833 (class 1259 OID 12193159)
-- Name: organization_feedback_updates_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedback_updates_default_log_idx ON organization.organization_feedback_updates_default USING gin (log);


--
-- TOC entry 4829 (class 1259 OID 12193160)
-- Name: organization_feedback_updates_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_organizationId_idx" ON ONLY organization.organization_feedback_updates USING btree ("organizationId");


--
-- TOC entry 4834 (class 1259 OID 12193161)
-- Name: organization_feedback_updates_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_default_organizationId_idx" ON organization.organization_feedback_updates_default USING btree ("organizationId");


--
-- TOC entry 4832 (class 1259 OID 12193162)
-- Name: organization_feedback_updates_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_threadId_idx" ON ONLY organization.organization_feedback_updates USING btree ("threadId");


--
-- TOC entry 4837 (class 1259 OID 12193163)
-- Name: organization_feedback_updates_default_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedback_updates_default_threadId_idx" ON organization.organization_feedback_updates_default USING btree ("threadId");


--
-- TOC entry 4838 (class 1259 OID 12193164)
-- Name: organization_feedbacks_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedbacks_log_idx ON ONLY organization.organization_feedbacks USING gin (log);


--
-- TOC entry 4843 (class 1259 OID 12193165)
-- Name: organization_feedbacks_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX organization_feedbacks_default_log_idx ON organization.organization_feedbacks_default USING gin (log);


--
-- TOC entry 4839 (class 1259 OID 12193166)
-- Name: organization_feedbacks_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_organizationId_idx" ON ONLY organization.organization_feedbacks USING btree ("organizationId");


--
-- TOC entry 4844 (class 1259 OID 12193167)
-- Name: organization_feedbacks_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_default_organizationId_idx" ON organization.organization_feedbacks_default USING btree ("organizationId");


--
-- TOC entry 4842 (class 1259 OID 12193168)
-- Name: organization_feedbacks_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_threadId_idx" ON ONLY organization.organization_feedbacks USING btree ("threadId");


--
-- TOC entry 4847 (class 1259 OID 12193169)
-- Name: organization_feedbacks_default_threadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "organization_feedbacks_default_threadId_idx" ON organization.organization_feedbacks_default USING btree ("threadId");


--
-- TOC entry 4858 (class 1259 OID 12193170)
-- Name: ppermissionTypes_id_name_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermissionTypes_id_name_type_idx" ON organization."ppermissionTypes" USING btree (id, name, type);


--
-- TOC entry 4861 (class 1259 OID 12193171)
-- Name: ppermission_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX ppermission_history_log_idx ON ONLY organization.ppermission_history USING gin (log);


--
-- TOC entry 4865 (class 1259 OID 12193172)
-- Name: ppermission_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX ppermission_history_default_log_idx ON organization.ppermission_history_default USING gin (log);


--
-- TOC entry 4862 (class 1259 OID 12193173)
-- Name: ppermission_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermission_history_organizationId_idx" ON ONLY organization.ppermission_history USING btree ("organizationId");


--
-- TOC entry 4866 (class 1259 OID 12193174)
-- Name: ppermission_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermission_history_default_organizationId_idx" ON organization.ppermission_history_default USING btree ("organizationId");


--
-- TOC entry 4871 (class 1259 OID 12193175)
-- Name: ppermissions_startDateTime_endDateTime_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "ppermissions_startDateTime_endDateTime_idx" ON organization.ppermissions USING btree ("startDateTime", "endDateTime");


--
-- TOC entry 4894 (class 1259 OID 12193176)
-- Name: status_sensor_logs_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_accessControlPointId_idx" ON ONLY organization.status_sensor_logs USING btree ("accessControlPointId");


--
-- TOC entry 4899 (class 1259 OID 12193177)
-- Name: status_sensor_logs_default_accessControlPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_default_accessControlPointId_idx" ON organization.status_sensor_logs_default USING btree ("accessControlPointId");


--
-- TOC entry 4895 (class 1259 OID 12193178)
-- Name: status_sensor_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX status_sensor_logs_log_idx ON ONLY organization.status_sensor_logs USING gin (log);


--
-- TOC entry 4900 (class 1259 OID 12193179)
-- Name: status_sensor_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX status_sensor_logs_default_log_idx ON organization.status_sensor_logs_default USING gin (log);


--
-- TOC entry 4896 (class 1259 OID 12193180)
-- Name: status_sensor_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_organizationId_idx" ON ONLY organization.status_sensor_logs USING btree ("organizationId");


--
-- TOC entry 4901 (class 1259 OID 12193181)
-- Name: status_sensor_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "status_sensor_logs_default_organizationId_idx" ON organization.status_sensor_logs_default USING btree ("organizationId");


--
-- TOC entry 4906 (class 1259 OID 12193182)
-- Name: system_status_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX system_status_logs_log_idx ON ONLY organization.system_status_logs USING gin (log);


--
-- TOC entry 4909 (class 1259 OID 12193183)
-- Name: system_status_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX system_status_logs_default_log_idx ON organization.system_status_logs_default USING gin (log);


--
-- TOC entry 4912 (class 1259 OID 12193184)
-- Name: tamper_switch_logs_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX tamper_switch_logs_log_idx ON ONLY organization.tamper_switch_logs USING gin (log);


--
-- TOC entry 4916 (class 1259 OID 12193185)
-- Name: tamper_switch_logs_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX tamper_switch_logs_default_log_idx ON organization.tamper_switch_logs_default USING gin (log);


--
-- TOC entry 4913 (class 1259 OID 12193186)
-- Name: tamper_switch_logs_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "tamper_switch_logs_organizationId_idx" ON ONLY organization.tamper_switch_logs USING btree ("organizationId");


--
-- TOC entry 4917 (class 1259 OID 12193187)
-- Name: tamper_switch_logs_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "tamper_switch_logs_default_organizationId_idx" ON organization.tamper_switch_logs_default USING btree ("organizationId");


--
-- TOC entry 4929 (class 1259 OID 12193188)
-- Name: transaction_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX transaction_default_id_idx ON organization.transaction_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 4930 (class 1259 OID 12193189)
-- Name: upload_log_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX upload_log_history_log_idx ON ONLY organization.upload_log_history USING gin (log);


--
-- TOC entry 4935 (class 1259 OID 12193190)
-- Name: upload_log_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX upload_log_history_default_log_idx ON organization.upload_log_history_default USING gin (log);


--
-- TOC entry 4931 (class 1259 OID 12193191)
-- Name: upload_log_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_organizationId_idx" ON ONLY organization.upload_log_history USING btree ("organizationId");


--
-- TOC entry 4936 (class 1259 OID 12193192)
-- Name: upload_log_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_default_organizationId_idx" ON organization.upload_log_history_default USING btree ("organizationId");


--
-- TOC entry 4934 (class 1259 OID 12193193)
-- Name: upload_log_history_uploadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_uploadId_idx" ON ONLY organization.upload_log_history USING btree ("uploadId");


--
-- TOC entry 4939 (class 1259 OID 12193194)
-- Name: upload_log_history_default_uploadId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "upload_log_history_default_uploadId_idx" ON organization.upload_log_history_default USING btree ("uploadId");


--
-- TOC entry 4952 (class 1259 OID 12193195)
-- Name: userOrganizationCredentials_userId_type_organizationId_data_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizationCredentials_userId_type_organizationId_data_idx" ON organization."userOrganizationCredentials" USING btree ("userId", type, "organizationId", data) WHERE ("deletedAt" IS NULL);


--
-- TOC entry 4965 (class 1259 OID 12193196)
-- Name: userOrganizationProfiles_profileText_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "userOrganizationProfiles_profileText_idx" ON organization."userOrganizationProfiles" USING gin ("profileText" public.gin_trgm_ops);


--
-- TOC entry 4966 (class 1259 OID 12193197)
-- Name: userOrganizationProfiles_userId_userOrganizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizationProfiles_userId_userOrganizationId_idx" ON organization."userOrganizationProfiles" USING btree ("userId", "userOrganizationId");


--
-- TOC entry 4975 (class 1259 OID 12193198)
-- Name: userOrganizations_userId_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userOrganizations_userId_organizationId_idx" ON organization."userOrganizations" USING btree ("userId", "organizationId");


--
-- TOC entry 4980 (class 1259 OID 12193199)
-- Name: userPPermissions_ppermissionId_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "userPPermissions_ppermissionId_userId_idx" ON organization."userPPermissions" USING btree ("ppermissionId", "userId");


--
-- TOC entry 4983 (class 1259 OID 12193200)
-- Name: userProfiles_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX "userProfiles_userId_idx" ON organization."userProfiles" USING btree ("userId");


--
-- TOC entry 4994 (class 1259 OID 12193201)
-- Name: user_action_history_category_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_category_type_idx ON ONLY organization.user_action_history USING btree (category, type);


--
-- TOC entry 5000 (class 1259 OID 12193202)
-- Name: user_action_history_default_category_type_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_default_category_type_idx ON organization.user_action_history_default USING btree (category, type);


--
-- TOC entry 4995 (class 1259 OID 12193203)
-- Name: user_action_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_log_idx ON ONLY organization.user_action_history USING gin (log);


--
-- TOC entry 5001 (class 1259 OID 12193204)
-- Name: user_action_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_action_history_default_log_idx ON organization.user_action_history_default USING gin (log);


--
-- TOC entry 4996 (class 1259 OID 12193205)
-- Name: user_action_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_organizationId_idx" ON ONLY organization.user_action_history USING btree ("organizationId");


--
-- TOC entry 5002 (class 1259 OID 12193206)
-- Name: user_action_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_default_organizationId_idx" ON organization.user_action_history_default USING btree ("organizationId");


--
-- TOC entry 4999 (class 1259 OID 12193207)
-- Name: user_action_history_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_userId_idx" ON ONLY organization.user_action_history USING btree ("userId");


--
-- TOC entry 5005 (class 1259 OID 12193208)
-- Name: user_action_history_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_action_history_default_userId_idx" ON organization.user_action_history_default USING btree ("userId");


--
-- TOC entry 5020 (class 1259 OID 12193209)
-- Name: user_monthly_summary_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_monthly_summary_history_log_idx ON ONLY organization.user_monthly_summary_history USING gin (log);


--
-- TOC entry 5026 (class 1259 OID 12193210)
-- Name: user_monthly_summary_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_monthly_summary_history_default_log_idx ON organization.user_monthly_summary_history_default USING gin (log);


--
-- TOC entry 5021 (class 1259 OID 12193211)
-- Name: user_monthly_summary_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_organizationId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("organizationId");


--
-- TOC entry 5027 (class 1259 OID 12193212)
-- Name: user_monthly_summary_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_organizationId_idx" ON organization.user_monthly_summary_history_default USING btree ("organizationId");


--
-- TOC entry 5022 (class 1259 OID 12193213)
-- Name: user_monthly_summary_history_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_originalId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("originalId");


--
-- TOC entry 5028 (class 1259 OID 12193214)
-- Name: user_monthly_summary_history_default_originalId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_originalId_idx" ON organization.user_monthly_summary_history_default USING btree ("originalId");


--
-- TOC entry 5025 (class 1259 OID 12193215)
-- Name: user_monthly_summary_history_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_userId_idx" ON ONLY organization.user_monthly_summary_history USING btree ("userId");


--
-- TOC entry 5031 (class 1259 OID 12193216)
-- Name: user_monthly_summary_history_default_userId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_monthly_summary_history_default_userId_idx" ON organization.user_monthly_summary_history_default USING btree ("userId");


--
-- TOC entry 5032 (class 1259 OID 12193217)
-- Name: user_ticket_transaction_history_actionUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_actionUserId_idx" ON ONLY organization.user_ticket_transaction_history USING btree ("actionUserId");


--
-- TOC entry 5037 (class 1259 OID 12193218)
-- Name: user_ticket_transaction_history_default_actionUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_default_actionUserId_idx" ON organization.user_ticket_transaction_history_default USING btree ("actionUserId");


--
-- TOC entry 5033 (class 1259 OID 12193219)
-- Name: user_ticket_transaction_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_ticket_transaction_history_log_idx ON ONLY organization.user_ticket_transaction_history USING gin (log);


--
-- TOC entry 5038 (class 1259 OID 12193220)
-- Name: user_ticket_transaction_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX user_ticket_transaction_history_default_log_idx ON organization.user_ticket_transaction_history_default USING gin (log);


--
-- TOC entry 5034 (class 1259 OID 12193221)
-- Name: user_ticket_transaction_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_organizationId_idx" ON ONLY organization.user_ticket_transaction_history USING btree ("organizationId");


--
-- TOC entry 5039 (class 1259 OID 12193222)
-- Name: user_ticket_transaction_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "user_ticket_transaction_history_default_organizationId_idx" ON organization.user_ticket_transaction_history_default USING btree ("organizationId");


--
-- TOC entry 5044 (class 1259 OID 12193223)
-- Name: users_unique_lower_username_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE UNIQUE INDEX users_unique_lower_username_idx ON organization.users USING btree (lower((username)::text));


--
-- TOC entry 5053 (class 1259 OID 12193224)
-- Name: visit_history_endUtc_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_endUtc_idx" ON ONLY organization.visit_history USING btree ("endUtc");


--
-- TOC entry 5061 (class 1259 OID 12193225)
-- Name: visit_history_default_endUtc_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_endUtc_idx" ON organization.visit_history_default USING btree ("endUtc");


--
-- TOC entry 5054 (class 1259 OID 12193226)
-- Name: visit_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visit_history_log_idx ON ONLY organization.visit_history USING gin (log);


--
-- TOC entry 5062 (class 1259 OID 12193227)
-- Name: visit_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visit_history_default_log_idx ON organization.visit_history_default USING gin (log);


--
-- TOC entry 5055 (class 1259 OID 12193228)
-- Name: visit_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_organizationId_idx" ON ONLY organization.visit_history USING btree ("organizationId");


--
-- TOC entry 5063 (class 1259 OID 12193229)
-- Name: visit_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_organizationId_idx" ON organization.visit_history_default USING btree ("organizationId");


--
-- TOC entry 5058 (class 1259 OID 12193230)
-- Name: visit_history_visitedUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitedUserId_idx" ON ONLY organization.visit_history USING btree ("visitedUserId");


--
-- TOC entry 5066 (class 1259 OID 12193231)
-- Name: visit_history_default_visitedUserId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitedUserId_idx" ON organization.visit_history_default USING btree ("visitedUserId");


--
-- TOC entry 5059 (class 1259 OID 12193232)
-- Name: visit_history_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitorProfileId_idx" ON ONLY organization.visit_history USING btree ("visitorProfileId");


--
-- TOC entry 5067 (class 1259 OID 12193233)
-- Name: visit_history_default_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitorProfileId_idx" ON organization.visit_history_default USING btree ("visitorProfileId");


--
-- TOC entry 5060 (class 1259 OID 12193234)
-- Name: visit_history_visitorRegistrationPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_visitorRegistrationPointId_idx" ON ONLY organization.visit_history USING btree ("visitorRegistrationPointId");


--
-- TOC entry 5068 (class 1259 OID 12193235)
-- Name: visit_history_default_visitorRegistrationPointId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visit_history_default_visitorRegistrationPointId_idx" ON organization.visit_history_default USING btree ("visitorRegistrationPointId");


--
-- TOC entry 5069 (class 1259 OID 12193236)
-- Name: visitorDailySummaries_visitorRegistrationPointId_reason_dat_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitorDailySummaries_visitorRegistrationPointId_reason_dat_idx" ON organization."visitorDailySummaries" USING btree ("visitorRegistrationPointId", reason, date);


--
-- TOC entry 5074 (class 1259 OID 12193237)
-- Name: visitor_preregistration_history_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visitor_preregistration_history_log_idx ON ONLY organization.visitor_preregistration_history USING gin (log);


--
-- TOC entry 5079 (class 1259 OID 12193238)
-- Name: visitor_preregistration_history_default_log_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX visitor_preregistration_history_default_log_idx ON organization.visitor_preregistration_history_default USING gin (log);


--
-- TOC entry 5075 (class 1259 OID 12193239)
-- Name: visitor_preregistration_history_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_organizationId_idx" ON ONLY organization.visitor_preregistration_history USING btree ("organizationId");


--
-- TOC entry 5080 (class 1259 OID 12193240)
-- Name: visitor_preregistration_history_default_organizationId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_default_organizationId_idx" ON organization.visitor_preregistration_history_default USING btree ("organizationId");


--
-- TOC entry 5078 (class 1259 OID 12193241)
-- Name: visitor_preregistration_history_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_visitorProfileId_idx" ON ONLY organization.visitor_preregistration_history USING btree ("visitorProfileId");


--
-- TOC entry 5083 (class 1259 OID 12193242)
-- Name: visitor_preregistration_history_default_visitorProfileId_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX "visitor_preregistration_history_default_visitorProfileId_idx" ON organization.visitor_preregistration_history_default USING btree ("visitorProfileId");


--
-- TOC entry 5090 (class 1259 OID 12193243)
-- Name: zz_notification_access_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_access_default_id_idx ON organization.zz_notification_access_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 5091 (class 1259 OID 12193244)
-- Name: zz_notification_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_default_id_idx ON organization.zz_notification_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 5093 (class 1259 OID 12193246)
-- Name: zz_notification_sensor_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_notification_sensor_default_id_idx ON organization.zz_notification_sensor_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 5095 (class 1259 OID 12193247)
-- Name: zz_pacs_notification_scheduled_job_default_id_idx; Type: INDEX; Schema: organization; Owner: armonsuper
--

CREATE INDEX zz_pacs_notification_scheduled_job_default_id_idx ON organization.zz_pacs_notification_scheduled_job_default USING btree (id DESC NULLS LAST);


--
-- TOC entry 5096 (class 0 OID 0)
-- Name: access_logs_default_credentialData_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."access_logs_credentialData_idx" ATTACH PARTITION organization."access_logs_default_credentialData_idx";


--
-- TOC entry 5097 (class 0 OID 0)
-- Name: access_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.access_logs_log_idx ATTACH PARTITION organization.access_logs_default_log_idx;


--
-- TOC entry 5098 (class 0 OID 0)
-- Name: access_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.access_logs_pkey ATTACH PARTITION organization.access_logs_default_pkey;


--
-- TOC entry 5099 (class 0 OID 0)
-- Name: access_snapshots_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.access_snapshots_pkey ATTACH PARTITION organization.access_snapshots_default_pkey;


--
-- TOC entry 5100 (class 0 OID 0)
-- Name: counter_sensor_logs_default_accessControlPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."counter_sensor_logs_accessControlPointId_idx" ATTACH PARTITION organization."counter_sensor_logs_default_accessControlPointId_idx";


--
-- TOC entry 5101 (class 0 OID 0)
-- Name: counter_sensor_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.counter_sensor_logs_log_idx ATTACH PARTITION organization.counter_sensor_logs_default_log_idx;


--
-- TOC entry 5102 (class 0 OID 0)
-- Name: counter_sensor_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."counter_sensor_logs_organizationId_idx" ATTACH PARTITION organization."counter_sensor_logs_default_organizationId_idx";


--
-- TOC entry 5103 (class 0 OID 0)
-- Name: counter_sensor_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.counter_sensor_logs_pkey ATTACH PARTITION organization.counter_sensor_logs_default_pkey;


--
-- TOC entry 5104 (class 0 OID 0)
-- Name: employee_day_segments_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."employee_day_segments_userId_idx" ATTACH PARTITION organization."employee_day_segments_default_userId_idx";


--
-- TOC entry 5105 (class 0 OID 0)
-- Name: employee_day_segments_default_workPlanId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."employee_day_segments_workPlanId_idx" ATTACH PARTITION organization."employee_day_segments_default_workPlanId_idx";


--
-- TOC entry 5106 (class 0 OID 0)
-- Name: log_history_default_data_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.log_history_data_idx ATTACH PARTITION organization.log_history_default_data_idx;


--
-- TOC entry 5107 (class 0 OID 0)
-- Name: log_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.log_history_pkey ATTACH PARTITION organization.log_history_default_pkey;


--
-- TOC entry 5108 (class 0 OID 0)
-- Name: log_process_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.log_process_history_pkey ATTACH PARTITION organization.log_process_history_default_pkey;


--
-- TOC entry 5109 (class 0 OID 0)
-- Name: monthly_summary_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.monthly_summary_history_log_idx ATTACH PARTITION organization.monthly_summary_history_default_log_idx;


--
-- TOC entry 5110 (class 0 OID 0)
-- Name: monthly_summary_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."monthly_summary_history_organizationId_idx" ATTACH PARTITION organization."monthly_summary_history_default_organizationId_idx";


--
-- TOC entry 5111 (class 0 OID 0)
-- Name: monthly_summary_history_default_originalId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."monthly_summary_history_originalId_idx" ATTACH PARTITION organization."monthly_summary_history_default_originalId_idx";


--
-- TOC entry 5112 (class 0 OID 0)
-- Name: monthly_summary_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.monthly_summary_history_pkey ATTACH PARTITION organization.monthly_summary_history_default_pkey;


--
-- TOC entry 5113 (class 0 OID 0)
-- Name: notification_event_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.notification_event_pkey ATTACH PARTITION organization.notification_event_default_pkey;


--
-- TOC entry 5114 (class 0 OID 0)
-- Name: notification_event_p202101_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.notification_event_pkey ATTACH PARTITION organization.notification_event_p202101_pkey;


--
-- TOC entry 5115 (class 0 OID 0)
-- Name: notification_event_p202102_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.notification_event_pkey ATTACH PARTITION organization.notification_event_p202102_pkey;


--
-- TOC entry 5116 (class 0 OID 0)
-- Name: notification_instance_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.notification_instance_pkey ATTACH PARTITION organization.notification_instance_default_pkey;


--
-- TOC entry 5117 (class 0 OID 0)
-- Name: organization_feedback_updates_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.organization_feedback_updates_log_idx ATTACH PARTITION organization.organization_feedback_updates_default_log_idx;


--
-- TOC entry 5118 (class 0 OID 0)
-- Name: organization_feedback_updates_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."organization_feedback_updates_organizationId_idx" ATTACH PARTITION organization."organization_feedback_updates_default_organizationId_idx";


--
-- TOC entry 5119 (class 0 OID 0)
-- Name: organization_feedback_updates_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.organization_feedback_updates_pkey ATTACH PARTITION organization.organization_feedback_updates_default_pkey;


--
-- TOC entry 5120 (class 0 OID 0)
-- Name: organization_feedback_updates_default_threadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."organization_feedback_updates_threadId_idx" ATTACH PARTITION organization."organization_feedback_updates_default_threadId_idx";


--
-- TOC entry 5121 (class 0 OID 0)
-- Name: organization_feedbacks_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.organization_feedbacks_log_idx ATTACH PARTITION organization.organization_feedbacks_default_log_idx;


--
-- TOC entry 5122 (class 0 OID 0)
-- Name: organization_feedbacks_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."organization_feedbacks_organizationId_idx" ATTACH PARTITION organization."organization_feedbacks_default_organizationId_idx";


--
-- TOC entry 5123 (class 0 OID 0)
-- Name: organization_feedbacks_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.organization_feedbacks_pkey ATTACH PARTITION organization.organization_feedbacks_default_pkey;


--
-- TOC entry 5124 (class 0 OID 0)
-- Name: organization_feedbacks_default_threadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."organization_feedbacks_threadId_idx" ATTACH PARTITION organization."organization_feedbacks_default_threadId_idx";


--
-- TOC entry 5125 (class 0 OID 0)
-- Name: ppermission_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.ppermission_history_log_idx ATTACH PARTITION organization.ppermission_history_default_log_idx;


--
-- TOC entry 5126 (class 0 OID 0)
-- Name: ppermission_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."ppermission_history_organizationId_idx" ATTACH PARTITION organization."ppermission_history_default_organizationId_idx";


--
-- TOC entry 5127 (class 0 OID 0)
-- Name: ppermission_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.ppermission_history_pkey ATTACH PARTITION organization.ppermission_history_default_pkey;


--
-- TOC entry 5128 (class 0 OID 0)
-- Name: status_sensor_logs_default_accessControlPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."status_sensor_logs_accessControlPointId_idx" ATTACH PARTITION organization."status_sensor_logs_default_accessControlPointId_idx";


--
-- TOC entry 5129 (class 0 OID 0)
-- Name: status_sensor_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.status_sensor_logs_log_idx ATTACH PARTITION organization.status_sensor_logs_default_log_idx;


--
-- TOC entry 5130 (class 0 OID 0)
-- Name: status_sensor_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."status_sensor_logs_organizationId_idx" ATTACH PARTITION organization."status_sensor_logs_default_organizationId_idx";


--
-- TOC entry 5131 (class 0 OID 0)
-- Name: status_sensor_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.status_sensor_logs_pkey ATTACH PARTITION organization.status_sensor_logs_default_pkey;


--
-- TOC entry 5132 (class 0 OID 0)
-- Name: system_status_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.system_status_logs_log_idx ATTACH PARTITION organization.system_status_logs_default_log_idx;


--
-- TOC entry 5133 (class 0 OID 0)
-- Name: system_status_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.system_status_logs_pkey ATTACH PARTITION organization.system_status_logs_default_pkey;


--
-- TOC entry 5134 (class 0 OID 0)
-- Name: tamper_switch_logs_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.tamper_switch_logs_log_idx ATTACH PARTITION organization.tamper_switch_logs_default_log_idx;


--
-- TOC entry 5135 (class 0 OID 0)
-- Name: tamper_switch_logs_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."tamper_switch_logs_organizationId_idx" ATTACH PARTITION organization."tamper_switch_logs_default_organizationId_idx";


--
-- TOC entry 5136 (class 0 OID 0)
-- Name: tamper_switch_logs_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.tamper_switch_logs_pkey ATTACH PARTITION organization.tamper_switch_logs_default_pkey;


--
-- TOC entry 5137 (class 0 OID 0)
-- Name: transaction_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.bx_organization_transaction_id ATTACH PARTITION organization.transaction_default_id_idx;


--
-- TOC entry 5138 (class 0 OID 0)
-- Name: upload_log_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.upload_log_history_log_idx ATTACH PARTITION organization.upload_log_history_default_log_idx;


--
-- TOC entry 5139 (class 0 OID 0)
-- Name: upload_log_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."upload_log_history_organizationId_idx" ATTACH PARTITION organization."upload_log_history_default_organizationId_idx";


--
-- TOC entry 5140 (class 0 OID 0)
-- Name: upload_log_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.upload_log_history_pkey ATTACH PARTITION organization.upload_log_history_default_pkey;


--
-- TOC entry 5141 (class 0 OID 0)
-- Name: upload_log_history_default_uploadId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."upload_log_history_uploadId_idx" ATTACH PARTITION organization."upload_log_history_default_uploadId_idx";


--
-- TOC entry 5142 (class 0 OID 0)
-- Name: user_action_history_default_category_type_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_action_history_category_type_idx ATTACH PARTITION organization.user_action_history_default_category_type_idx;


--
-- TOC entry 5143 (class 0 OID 0)
-- Name: user_action_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_action_history_log_idx ATTACH PARTITION organization.user_action_history_default_log_idx;


--
-- TOC entry 5144 (class 0 OID 0)
-- Name: user_action_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_action_history_organizationId_idx" ATTACH PARTITION organization."user_action_history_default_organizationId_idx";


--
-- TOC entry 5145 (class 0 OID 0)
-- Name: user_action_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_action_history_pkey ATTACH PARTITION organization.user_action_history_default_pkey;


--
-- TOC entry 5146 (class 0 OID 0)
-- Name: user_action_history_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_action_history_userId_idx" ATTACH PARTITION organization."user_action_history_default_userId_idx";


--
-- TOC entry 5147 (class 0 OID 0)
-- Name: user_monthly_summary_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_monthly_summary_history_log_idx ATTACH PARTITION organization.user_monthly_summary_history_default_log_idx;


--
-- TOC entry 5148 (class 0 OID 0)
-- Name: user_monthly_summary_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_monthly_summary_history_organizationId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_organizationId_idx";


--
-- TOC entry 5149 (class 0 OID 0)
-- Name: user_monthly_summary_history_default_originalId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_monthly_summary_history_originalId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_originalId_idx";


--
-- TOC entry 5150 (class 0 OID 0)
-- Name: user_monthly_summary_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_monthly_summary_history_pkey ATTACH PARTITION organization.user_monthly_summary_history_default_pkey;


--
-- TOC entry 5151 (class 0 OID 0)
-- Name: user_monthly_summary_history_default_userId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_monthly_summary_history_userId_idx" ATTACH PARTITION organization."user_monthly_summary_history_default_userId_idx";


--
-- TOC entry 5152 (class 0 OID 0)
-- Name: user_ticket_transaction_history_default_actionUserId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_ticket_transaction_history_actionUserId_idx" ATTACH PARTITION organization."user_ticket_transaction_history_default_actionUserId_idx";


--
-- TOC entry 5153 (class 0 OID 0)
-- Name: user_ticket_transaction_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_ticket_transaction_history_log_idx ATTACH PARTITION organization.user_ticket_transaction_history_default_log_idx;


--
-- TOC entry 5154 (class 0 OID 0)
-- Name: user_ticket_transaction_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."user_ticket_transaction_history_organizationId_idx" ATTACH PARTITION organization."user_ticket_transaction_history_default_organizationId_idx";


--
-- TOC entry 5155 (class 0 OID 0)
-- Name: user_ticket_transaction_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.user_ticket_transaction_history_pkey ATTACH PARTITION organization.user_ticket_transaction_history_default_pkey;


--
-- TOC entry 5156 (class 0 OID 0)
-- Name: visit_history_default_endUtc_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visit_history_endUtc_idx" ATTACH PARTITION organization."visit_history_default_endUtc_idx";


--
-- TOC entry 5157 (class 0 OID 0)
-- Name: visit_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.visit_history_log_idx ATTACH PARTITION organization.visit_history_default_log_idx;


--
-- TOC entry 5158 (class 0 OID 0)
-- Name: visit_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visit_history_organizationId_idx" ATTACH PARTITION organization."visit_history_default_organizationId_idx";


--
-- TOC entry 5159 (class 0 OID 0)
-- Name: visit_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.visit_history_pkey ATTACH PARTITION organization.visit_history_default_pkey;


--
-- TOC entry 5160 (class 0 OID 0)
-- Name: visit_history_default_visitedUserId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visit_history_visitedUserId_idx" ATTACH PARTITION organization."visit_history_default_visitedUserId_idx";


--
-- TOC entry 5161 (class 0 OID 0)
-- Name: visit_history_default_visitorProfileId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visit_history_visitorProfileId_idx" ATTACH PARTITION organization."visit_history_default_visitorProfileId_idx";


--
-- TOC entry 5162 (class 0 OID 0)
-- Name: visit_history_default_visitorRegistrationPointId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visit_history_visitorRegistrationPointId_idx" ATTACH PARTITION organization."visit_history_default_visitorRegistrationPointId_idx";


--
-- TOC entry 5163 (class 0 OID 0)
-- Name: visitor_preregistration_history_default_log_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.visitor_preregistration_history_log_idx ATTACH PARTITION organization.visitor_preregistration_history_default_log_idx;


--
-- TOC entry 5164 (class 0 OID 0)
-- Name: visitor_preregistration_history_default_organizationId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visitor_preregistration_history_organizationId_idx" ATTACH PARTITION organization."visitor_preregistration_history_default_organizationId_idx";


--
-- TOC entry 5165 (class 0 OID 0)
-- Name: visitor_preregistration_history_default_pkey; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.visitor_preregistration_history_pkey ATTACH PARTITION organization.visitor_preregistration_history_default_pkey;


--
-- TOC entry 5166 (class 0 OID 0)
-- Name: visitor_preregistration_history_default_visitorProfileId_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization."visitor_preregistration_history_visitorProfileId_idx" ATTACH PARTITION organization."visitor_preregistration_history_default_visitorProfileId_idx";


--
-- TOC entry 5167 (class 0 OID 0)
-- Name: zz_notification_access_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.bx_zz_notification_access ATTACH PARTITION organization.zz_notification_access_default_id_idx;


--
-- TOC entry 5168 (class 0 OID 0)
-- Name: zz_notification_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.bx_zz_notification ATTACH PARTITION organization.zz_notification_default_id_idx;


--
-- TOC entry 5169 (class 0 OID 0)
-- Name: zz_notification_sensor_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.bx_zz_notification_sensor ATTACH PARTITION organization.zz_notification_sensor_default_id_idx;


--
-- TOC entry 5170 (class 0 OID 0)
-- Name: zz_pacs_notification_scheduled_job_default_id_idx; Type: INDEX ATTACH; Schema: organization; Owner: -
--

ALTER INDEX organization.bx_zz_pacs_notification_scheduled_job ATTACH PARTITION organization.zz_pacs_notification_scheduled_job_default_id_idx;


--
-- TOC entry 5581 (class 2618 OID 12190051)
-- Name: vW_SearchPPermissions _RETURN; Type: RULE; Schema: organization; Owner: armonsuper
--

CREATE OR REPLACE VIEW organization."vW_SearchPPermissions" AS
 SELECT p.id,
    p."organizationId",
    p."startDateTime",
    p."endDateTime",
    p.status,
    p."requestDateTime",
    p.note,
    p."requestUserId",
    up."userPPermissions",
    upa."userPPermissionApprovements",
    useranddeputy2."userAndDeputies",
    pt."ppermissionType",
    upa."nextApproverOrganizationUnitIds",
    upa."approvedOrganizationUnitIds",
    upa."approvementWaitingOrganizationUnitIds",
    up."userCount"
   FROM (((((organization.ppermissions p
     JOIN ( SELECT pt_1.id,
            COALESCE(json_agg(( SELECT x.*::record AS x
                   FROM ( SELECT pt_1.id,
                            pt_1."organizationId",
                            pt_1.name,
                            pt_1.description,
                            pt_1."isPassive",
                            pt_1."hrCanInit",
                            pt_1."personnelCanInit",
                            pt_1."ignoreInCalculations",
                            pt_1."trustDeclaration",
                            pt_1."isDailyScheduled",
                            pt_1."minValue",
                            pt_1."maxValue",
                            pt_1."maxValueBoundaryInterval",
                            pt_1."outOfWorkHours",
                            pt_1."sendNotification",
                            pt_1."createdAt",
                            pt_1."updatedAt",
                            pt_1."deletedAt",
                            pt_1."needsManagerDeputy",
                            pt_1."needsUserDeputy",
                            pt_1."userMustSign",
                            pt_1.type,
                            pt_1."showRemainingCount",
                            pt_1."isUnpaidLeave",
                            pt_1."notifyHR",
                            pt_1.approvements) x)) FILTER (WHERE (pt_1.id IS NOT NULL)), '[]'::json) AS "ppermissionType"
           FROM ( SELECT pt_2.id,
                    pt_2."organizationId",
                    pt_2.name,
                    pt_2.description,
                    pt_2."isPassive",
                    pt_2."hrCanInit",
                    pt_2."personnelCanInit",
                    pt_2."ignoreInCalculations",
                    pt_2."trustDeclaration",
                    pt_2."isDailyScheduled",
                    pt_2."minValue",
                    pt_2."maxValue",
                    pt_2."maxValueBoundaryInterval",
                    pt_2."outOfWorkHours",
                    pt_2."sendNotification",
                    pt_2."createdAt",
                    pt_2."updatedAt",
                    pt_2."deletedAt",
                    pt_2."needsManagerDeputy",
                    pt_2."needsUserDeputy",
                    pt_2."userMustSign",
                    pt_2.type,
                    pt_2."showRemainingCount",
                    pt_2."isUnpaidLeave",
                    pt_2."notifyHR",
                    COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                           FROM ( SELECT pta."rootOrganizationUnitId",
                                    pta."order") x)) FILTER (WHERE (pta.id IS NOT NULL)), '[]'::json) AS approvements
                   FROM (organization."ppermissionTypes" pt_2
                     LEFT JOIN organization."ppermissionTypeApprovements" pta ON ((pt_2.id = pta."ppermissionTypeId")))
                  GROUP BY pt_2.id) pt_1
          GROUP BY pt_1.id) pt ON ((pt.id = p."ppermissionTypeId")))
     LEFT JOIN ( SELECT p_1.id,
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT pa_1.id,
                            pa_1."ppermissionId",
                            pa_1.name) x)) FILTER (WHERE (pa_1.id IS NOT NULL)), '[]'::json) AS "ppermissionAttachments"
           FROM (organization."ppermissionAttachments" pa_1
             JOIN organization.ppermissions p_1 ON ((p_1.id = pa_1."ppermissionId")))
          GROUP BY p_1.id) pa ON ((pa.id = p.id)))
     LEFT JOIN ( SELECT up_1."ppermissionId",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT up_1.id,
                            up_1."userId",
                            up_1."ppermissionId",
                            up_1.note,
                            up_1.approvement,
                            up_1."signedByUser",
                            up_1."currentApprovementOrder") x)) FILTER (WHERE (up_1.id IS NOT NULL)), '[]'::json) AS "userPPermissions",
            count(*) AS "userCount"
           FROM organization."userPPermissions" up_1
          GROUP BY up_1."ppermissionId") up ON ((p.id = up."ppermissionId")))
     LEFT JOIN ( SELECT upa_1."ppermissionId",
            COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE (upa_1.id IS NOT NULL)), '[]'::json) AS "userPPermissionApprovements",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NULL))), '[]'::json) AS "approvementWaitingOrganizationUnitIds",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NOT NULL))), '[]'::json) AS "approvedOrganizationUnitIds",
            COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                   FROM ( SELECT upa_1.id,
                            upa_1."userId",
                            upa_1."ppermissionId",
                            upa_1."order",
                            upa_1."approverUserId",
                            upa_1."approvementDate",
                            upa_1.note,
                            upa_1.status,
                            upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."order" = up_1."currentApprovementOrder") AND (upa_1."approverUserId" IS NULL))), '[]'::json) AS "nextApproverOrganizationUnitIds"
           FROM (organization."userPPermissionApprovements" upa_1
             JOIN organization."userPPermissions" up_1 ON (((up_1."ppermissionId" = upa_1."ppermissionId") AND (up_1."userId" = upa_1."userId"))))
          GROUP BY upa_1."ppermissionId") upa ON ((p.id = upa."ppermissionId")))
     LEFT JOIN ( SELECT useranddeputy."ppermissionId",
            COALESCE(json_agg(( SELECT x.*::record AS x
                   FROM ( SELECT useranddeputy."user",
                            useranddeputy."deputyUser") x)), '[]'::json) AS "userAndDeputies"
           FROM ( SELECT p_1.id AS "ppermissionId",
                    p_1."organizationId",
                    json_build_object('id', uop."userId", 'fullname', (((uop.name)::text || ' '::text) || (uop.surname)::text), 'uniqueId', uop."uniqueId") AS "user",
                        CASE
                            WHEN (uop2."userId" IS NOT NULL) THEN json_build_object('id', uop2."userId", 'fullname', (((uop2.name)::text || ' '::text) || (uop2.surname)::text), 'uniqueId', uop2."uniqueId")
                            ELSE NULL::json
                        END AS "deputyUser"
                   FROM ((((((organization.ppermissions p_1
                     JOIN organization."userPPermissions" up_1 ON ((up_1."ppermissionId" = p_1.id)))
                     JOIN organization."userOrganizations" uo ON (((uo."userId" = up_1."userId") AND (uo."organizationId" = p_1."organizationId"))))
                     JOIN organization."userOrganizationProfiles" uop ON ((uop."userOrganizationId" = uo.id)))
                     LEFT JOIN organization."userOrganizationDeputies" uod ON (((uod."ppermissionId" = p_1.id) AND (uod."userOrganizationId" = uo.id))))
                     LEFT JOIN organization."userOrganizations" uo2 ON ((uo2.id = uod."deputyUserOrganizationId")))
                     LEFT JOIN organization."userOrganizationProfiles" uop2 ON ((uop2."userOrganizationId" = uo2.id)))
                  WHERE ((uo."deletedAt" IS NULL) AND (uop."deletedAt" IS NULL) AND (uo2."deletedAt" IS NULL) AND (uop2."deletedAt" IS NULL))) useranddeputy
          GROUP BY useranddeputy."ppermissionId") useranddeputy2 ON ((useranddeputy2."ppermissionId" = p.id)));


--
-- TOC entry 5414 (class 2620 OID 12265840)
-- Name: ppermissions add_recalculate_records_for_ppermission_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_ppermission_change BEFORE DELETE OR UPDATE ON organization.ppermissions FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_ppermission_change();


--
-- TOC entry 5435 (class 2620 OID 12193346)
-- Name: userPPermissions add_recalculate_records_for_user_ppermission_add_delete; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_user_ppermission_add_delete BEFORE INSERT OR DELETE ON organization."userPPermissions" FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete();


--
-- TOC entry 5441 (class 2620 OID 12193347)
-- Name: vacations add_recalculate_records_for_vacation_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER add_recalculate_records_for_vacation_change BEFORE INSERT OR DELETE OR UPDATE ON organization.vacations FOR EACH ROW EXECUTE FUNCTION organization.add_recalculate_records_for_vacation_change();


--
-- TOC entry 5387 (class 2620 OID 12193348)
-- Name: antiPassbackStates after_in_up_del_anti_passback_state; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_in_up_del_anti_passback_state AFTER INSERT OR DELETE OR UPDATE ON organization."antiPassbackStates" FOR EACH ROW EXECUTE FUNCTION organization.after_in_up_del_anti_passback_state();


--
-- TOC entry 5385 (class 2620 OID 12193349)
-- Name: access_logs_default after_insert_access_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_access_logs_default AFTER INSERT ON organization.access_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5386 (class 2620 OID 12193350)
-- Name: access_snapshots_default after_insert_access_snapshots_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_access_snapshots_default AFTER INSERT ON organization.access_snapshots_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5390 (class 2620 OID 12193351)
-- Name: counter_sensor_logs_default after_insert_counter_sensor_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_counter_sensor_logs_default AFTER INSERT ON organization.counter_sensor_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5396 (class 2620 OID 12193352)
-- Name: employee_day_segments_default after_insert_employee_day_segments_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_employee_day_segments_default AFTER INSERT ON organization.employee_day_segments_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5397 (class 2620 OID 12193353)
-- Name: log_history_default after_insert_log_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_log_history_default AFTER INSERT ON organization.log_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5398 (class 2620 OID 12193354)
-- Name: log_process_history_default after_insert_log_process_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_log_process_history_default AFTER INSERT ON organization.log_process_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5399 (class 2620 OID 12193355)
-- Name: monthly_summary_history_default after_insert_monthly_summary_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_monthly_summary_history_default AFTER INSERT ON organization.monthly_summary_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5404 (class 2620 OID 12193356)
-- Name: notification_event_default after_insert_notification_event_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_notification_event_default AFTER INSERT ON organization.notification_event_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5405 (class 2620 OID 12193357)
-- Name: notification_instance_default after_insert_notification_instance_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_notification_instance_default AFTER INSERT ON organization.notification_instance_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5409 (class 2620 OID 12193358)
-- Name: organization_feedback_updates_default after_insert_organization_feedback_updates_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_organization_feedback_updates_default AFTER INSERT ON organization.organization_feedback_updates_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5410 (class 2620 OID 12193359)
-- Name: organization_feedbacks_default after_insert_organization_feedbacks_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_organization_feedbacks_default AFTER INSERT ON organization.organization_feedbacks_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5413 (class 2620 OID 12193360)
-- Name: ppermission_history_default after_insert_ppermission_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_ppermission_history_default AFTER INSERT ON organization.ppermission_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5419 (class 2620 OID 12193361)
-- Name: status_sensor_logs_default after_insert_status_sensor_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_status_sensor_logs_default AFTER INSERT ON organization.status_sensor_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5420 (class 2620 OID 12193362)
-- Name: system_status_logs_default after_insert_system_status_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_system_status_logs_default AFTER INSERT ON organization.system_status_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5421 (class 2620 OID 12193363)
-- Name: tamper_switch_logs_default after_insert_tamper_switch_logs_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_tamper_switch_logs_default AFTER INSERT ON organization.tamper_switch_logs_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5423 (class 2620 OID 12193364)
-- Name: terminalChanges after_insert_terminal_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_terminal_change AFTER INSERT ON organization."terminalChanges" FOR EACH ROW EXECUTE FUNCTION organization.after_insert_terminal_change();


--
-- TOC entry 5422 (class 2620 OID 12193365)
-- Name: terminalChangeTransactions after_insert_terminal_transaction; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_terminal_transaction AFTER INSERT ON organization."terminalChangeTransactions" FOR EACH ROW EXECUTE FUNCTION organization.after_insert_terminal_transaction();


--
-- TOC entry 5425 (class 2620 OID 12193366)
-- Name: transaction_default after_insert_transaction_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_transaction_default AFTER INSERT ON organization.transaction_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5426 (class 2620 OID 12193367)
-- Name: upload_log_history_default after_insert_upload_log_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_upload_log_history_default AFTER INSERT ON organization.upload_log_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5437 (class 2620 OID 12193368)
-- Name: user_action_history_default after_insert_user_action_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_action_history_default AFTER INSERT ON organization.user_action_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5438 (class 2620 OID 12193369)
-- Name: user_monthly_summary_history_default after_insert_user_monthly_summary_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_monthly_summary_history_default AFTER INSERT ON organization.user_monthly_summary_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5439 (class 2620 OID 12193370)
-- Name: user_ticket_transaction_history_default after_insert_user_ticket_transaction_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_user_ticket_transaction_history_default AFTER INSERT ON organization.user_ticket_transaction_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5442 (class 2620 OID 12193371)
-- Name: visit_history_default after_insert_visit_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_visit_history_default AFTER INSERT ON organization.visit_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5443 (class 2620 OID 12193372)
-- Name: visitor_preregistration_history_default after_insert_visitor_preregistration_history_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_visitor_preregistration_history_default AFTER INSERT ON organization.visitor_preregistration_history_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5444 (class 2620 OID 12193373)
-- Name: zz_notification_access_default after_insert_zz_notification_access_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_access_default AFTER INSERT ON organization.zz_notification_access_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5445 (class 2620 OID 12193374)
-- Name: zz_notification_default after_insert_zz_notification_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_default AFTER INSERT ON organization.zz_notification_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5446 (class 2620 OID 12193375)
-- Name: zz_notification_sensor_default after_insert_zz_notification_sensor_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_notification_sensor_default AFTER INSERT ON organization.zz_notification_sensor_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5447 (class 2620 OID 12193376)
-- Name: zz_pacs_notification_scheduled_job_default after_insert_zz_pacs_notification_scheduled_job_default; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_insert_zz_pacs_notification_scheduled_job_default AFTER INSERT ON organization.zz_pacs_notification_scheduled_job_default FOR EACH ROW EXECUTE FUNCTION public.after_insert_default();


--
-- TOC entry 5411 (class 2620 OID 12193377)
-- Name: organizations after_up_organization_settings; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER after_up_organization_settings AFTER UPDATE OF settings ON organization.organizations FOR EACH ROW EXECUTE FUNCTION organization.after_update_organization_settings();


--
-- TOC entry 5424 (class 2620 OID 12193378)
-- Name: terminalChanges before_insert_terminal_change; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_insert_terminal_change BEFORE INSERT ON organization."terminalChanges" FOR EACH ROW EXECUTE FUNCTION organization.before_insert_terminal_change();


--
-- TOC entry 5418 (class 2620 OID 12193379)
-- Name: regions before_up_del_regions; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_regions BEFORE DELETE OR UPDATE ON organization.regions FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_regions();


--
-- TOC entry 5440 (class 2620 OID 12193380)
-- Name: users before_up_del_user; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_user BEFORE DELETE OR UPDATE ON organization.users FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_user();


--
-- TOC entry 5433 (class 2620 OID 12193381)
-- Name: userOrganizations before_up_del_user_organizations; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_del_user_organizations BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.before_up_del_user_organizations();


--
-- TOC entry 5381 (class 2620 OID 12193382)
-- Name: accessControlPoints before_up_in_del_access_control_point; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_access_control_point BEFORE INSERT OR DELETE OR UPDATE ON organization."accessControlPoints" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_access_control_point();


--
-- TOC entry 5389 (class 2620 OID 12193383)
-- Name: cameras before_up_in_del_camera; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_camera BEFORE INSERT OR DELETE OR UPDATE ON organization.cameras FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_camera();


--
-- TOC entry 5388 (class 2620 OID 12193384)
-- Name: cameraActions before_up_in_del_camera_actions; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_camera_actions BEFORE INSERT OR DELETE OR UPDATE ON organization."cameraActions" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_camera_actions();


--
-- TOC entry 5391 (class 2620 OID 12193385)
-- Name: deviceDryContactInputs before_up_in_del_device_dry_contact_inputs; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_dry_contact_inputs BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceDryContactInputs" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_dry_contact_inputs();


--
-- TOC entry 5392 (class 2620 OID 12193386)
-- Name: deviceReaders before_up_in_del_device_readers; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_readers BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceReaders" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_readers();


--
-- TOC entry 5393 (class 2620 OID 12193387)
-- Name: deviceRelays before_up_in_del_device_relays; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_device_relays BEFORE INSERT OR DELETE OR UPDATE ON organization."deviceRelays" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_device_relays();


--
-- TOC entry 5402 (class 2620 OID 12193388)
-- Name: notification_access before_up_in_del_notification_access; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_notification_access BEFORE INSERT OR DELETE OR UPDATE ON organization.notification_access FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_notification_access();


--
-- TOC entry 5406 (class 2620 OID 12193389)
-- Name: notification_sensor before_up_in_del_notification_sensor; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_notification_sensor BEFORE INSERT OR DELETE OR UPDATE ON organization.notification_sensor FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_notification_sensor();


--
-- TOC entry 5408 (class 2620 OID 12193390)
-- Name: oAuthTokens before_up_in_del_o_auth_tokens; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_o_auth_tokens BEFORE INSERT OR DELETE OR UPDATE ON organization."oAuthTokens" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_o_auth_tokens();


--
-- TOC entry 5416 (class 2620 OID 12193391)
-- Name: regionAccessControlPoints before_up_in_del_region_access_control_points; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_region_access_control_points BEFORE INSERT OR DELETE OR UPDATE ON organization."regionAccessControlPoints" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_region_access_control_points();


--
-- TOC entry 5427 (class 2620 OID 12193392)
-- Name: userAccessRights before_up_in_del_user_access_rights; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_access_rights BEFORE INSERT OR DELETE OR UPDATE ON organization."userAccessRights" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_access_rights();


--
-- TOC entry 5431 (class 2620 OID 12193393)
-- Name: userOrganizationForbiddances before_up_in_del_user_forbiddances; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_forbiddances BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizationForbiddances" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_forbiddances();


--
-- TOC entry 5429 (class 2620 OID 12193394)
-- Name: userGroupUserOrganizations before_up_in_del_user_group_mapping; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_group_mapping BEFORE INSERT OR DELETE OR UPDATE ON organization."userGroupUserOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_group_mapping();


--
-- TOC entry 5430 (class 2620 OID 12193395)
-- Name: userOrganizationCredentials before_up_in_del_user_organization_credentials; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_organization_credentials BEFORE INSERT OR DELETE OR UPDATE ON organization."userOrganizationCredentials" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_organization_credentials();


--
-- TOC entry 5436 (class 2620 OID 12193396)
-- Name: userRegionTicketUnits before_up_in_del_user_region_ticket_unit; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_del_user_region_ticket_unit BEFORE INSERT OR DELETE OR UPDATE ON organization."userRegionTicketUnits" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_del_user_region_ticket_unit();


--
-- TOC entry 5383 (class 2620 OID 12193397)
-- Name: accessRuleSets before_up_in_delete_access_rule_sets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_access_rule_sets BEFORE INSERT OR DELETE OR UPDATE ON organization."accessRuleSets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_access_rule_sets();


--
-- TOC entry 5384 (class 2620 OID 12193398)
-- Name: accessRules before_up_in_delete_access_rules; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_access_rules BEFORE INSERT OR DELETE OR UPDATE ON organization."accessRules" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_access_rules();


--
-- TOC entry 5417 (class 2620 OID 12193399)
-- Name: regionTickets before_up_in_delete_region_tickets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_region_tickets BEFORE INSERT OR DELETE OR UPDATE ON organization."regionTickets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_region_tickets();


--
-- TOC entry 5428 (class 2620 OID 12193400)
-- Name: userGroupAccessRuleSets before_up_in_delete_user_group_access_rule_sets; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_delete_user_group_access_rule_sets BEFORE INSERT OR DELETE OR UPDATE ON organization."userGroupAccessRuleSets" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_delete_user_group_access_rule_sets();


--
-- TOC entry 5382 (class 2620 OID 12193401)
-- Name: accessRuleHistory before_up_in_user_rule_history; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_up_in_user_rule_history BEFORE INSERT OR UPDATE ON organization."accessRuleHistory" FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_user_rule_history();


--
-- TOC entry 5394 (class 2620 OID 12193402)
-- Name: devices before_update_devices; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER before_update_devices BEFORE UPDATE ON organization.devices FOR EACH ROW EXECUTE FUNCTION organization.before_update_devices();


--
-- TOC entry 5432 (class 2620 OID 12193403)
-- Name: userOrganizationProfiles gen_profile_text; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER gen_profile_text BEFORE INSERT OR UPDATE ON organization."userOrganizationProfiles" FOR EACH ROW EXECUTE FUNCTION organization.gen_profile_text();


--
-- TOC entry 5395 (class 2620 OID 12193404)
-- Name: employeeLiveDay notify_pacs_live_recalculation_trigger; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER notify_pacs_live_recalculation_trigger AFTER UPDATE ON organization."employeeLiveDay" REFERENCING OLD TABLE AS oldtab NEW TABLE AS newtab FOR EACH STATEMENT EXECUTE FUNCTION organization.notify_pacs_live_recalculation();


--
-- TOC entry 5415 (class 2620 OID 12193405)
-- Name: recalculateWorkQueue process_recalculate_work_queue_start_date_time; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER process_recalculate_work_queue_start_date_time BEFORE INSERT OR UPDATE ON organization."recalculateWorkQueue" FOR EACH ROW EXECUTE FUNCTION organization.process_recalculate_work_queue_start_date_time();


--
-- TOC entry 5400 (class 2620 OID 12193406)
-- Name: notification trg_99_zz_notification; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification AFTER INSERT OR DELETE OR UPDATE ON organization.notification FOR EACH ROW EXECUTE FUNCTION organization.zz_notification();


--
-- TOC entry 5403 (class 2620 OID 12193407)
-- Name: notification_access trg_99_zz_notification_access; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_access AFTER INSERT OR DELETE OR UPDATE ON organization.notification_access FOR EACH ROW EXECUTE FUNCTION organization.zz_notification_access();


--
-- TOC entry 5407 (class 2620 OID 12193408)
-- Name: notification_sensor trg_99_zz_notification_sensor; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_notification_sensor AFTER INSERT OR DELETE OR UPDATE ON organization.notification_sensor FOR EACH ROW EXECUTE FUNCTION organization.zz_notification_sensor();


--
-- TOC entry 5412 (class 2620 OID 12193409)
-- Name: pacs_notification_scheduled_job trg_99_zz_pacs_notification_scheduled_job; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_99_zz_pacs_notification_scheduled_job AFTER INSERT OR DELETE OR UPDATE ON organization.pacs_notification_scheduled_job FOR EACH ROW EXECUTE FUNCTION organization.zz_pacs_notification_scheduled_job();


--
-- TOC entry 5401 (class 2620 OID 12193410)
-- Name: notification trg_before_up_in_notification; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER trg_before_up_in_notification BEFORE INSERT OR UPDATE ON organization.notification FOR EACH ROW EXECUTE FUNCTION organization.before_up_in_notification();


--
-- TOC entry 5434 (class 2620 OID 12193411)
-- Name: userOrganizations update_terminaladmins_trigger; Type: TRIGGER; Schema: organization; Owner: armonsuper
--

CREATE TRIGGER update_terminaladmins_trigger BEFORE DELETE OR UPDATE ON organization."userOrganizations" FOR EACH ROW EXECUTE FUNCTION organization.update_terminaladmins();


--
-- TOC entry 5171 (class 2606 OID 12194514)
-- Name: accessControlPoints accessControlPoints_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT "accessControlPoints_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5173 (class 2606 OID 12194519)
-- Name: accessRuleHistory accessRuleHistory_accessRuleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_accessRuleId_fkey" FOREIGN KEY ("accessRuleId") REFERENCES organization."accessRules"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5174 (class 2606 OID 12194524)
-- Name: accessRuleHistory accessRuleHistory_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleHistory"
    ADD CONSTRAINT "accessRuleHistory_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5172 (class 2606 OID 12194529)
-- Name: accessControlPoints accesscontrolpoints_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessControlPoints"
    ADD CONSTRAINT accesscontrolpoints_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id);


--
-- TOC entry 5177 (class 2606 OID 12194534)
-- Name: accessRules accessrules_accessrulesetid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRules"
    ADD CONSTRAINT accessrules_accessrulesetid_foreign FOREIGN KEY ("accessRuleSetId") REFERENCES organization."accessRuleSets"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5175 (class 2606 OID 12194539)
-- Name: accessRuleSets accessrulesets_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT accessrulesets_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5176 (class 2606 OID 12194544)
-- Name: accessRuleSets accessrulesets_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."accessRuleSets"
    ADD CONSTRAINT accessrulesets_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5180 (class 2606 OID 12194549)
-- Name: adapters adapters_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5181 (class 2606 OID 12194554)
-- Name: adapters adapters_things_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.adapters
    ADD CONSTRAINT adapters_things_fkey FOREIGN KEY (id) REFERENCES public.things(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5186 (class 2606 OID 12194559)
-- Name: attendanceAccessControlPoints antiPassbackStates_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "antiPassbackStates_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON DELETE CASCADE;


--
-- TOC entry 5182 (class 2606 OID 12194564)
-- Name: antiPassbackStates antiPassbackStates_regionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_regionId_fkey" FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5183 (class 2606 OID 12194569)
-- Name: antiPassbackStates antiPassbackStates_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."antiPassbackStates"
    ADD CONSTRAINT "antiPassbackStates_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5178 (class 2606 OID 12194574)
-- Name: access_point_qr_code ap_qr_code_ap_id_aps_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT ap_qr_code_ap_id_aps_id_fkey FOREIGN KEY ("accessPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5179 (class 2606 OID 12194579)
-- Name: access_point_qr_code ap_qr_code_remote_relay_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.access_point_qr_code
    ADD CONSTRAINT ap_qr_code_remote_relay_id_fkey FOREIGN KEY ("remoteRelayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5184 (class 2606 OID 12194584)
-- Name: aperioLocks aperiolocks_hubdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT aperiolocks_hubdeviceid_foreign FOREIGN KEY ("hubDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5185 (class 2606 OID 12194589)
-- Name: aperioLocks aperiolocks_lockdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."aperioLocks"
    ADD CONSTRAINT aperiolocks_lockdeviceid_foreign FOREIGN KEY ("lockDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5187 (class 2606 OID 12194594)
-- Name: attendanceAccessControlPoints attendanceAccessControlPoints_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."attendanceAccessControlPoints"
    ADD CONSTRAINT "attendanceAccessControlPoints_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- TOC entry 5188 (class 2606 OID 12194599)
-- Name: cameraActions cameraactions_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5189 (class 2606 OID 12194604)
-- Name: cameraActions cameraactions_cameraid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_cameraid_foreign FOREIGN KEY ("cameraId") REFERENCES organization.cameras(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5190 (class 2606 OID 12194609)
-- Name: cameraActions cameraactions_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."cameraActions"
    ADD CONSTRAINT cameraactions_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5191 (class 2606 OID 12194614)
-- Name: cameras cameras_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT "cameras_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- TOC entry 5192 (class 2606 OID 12194619)
-- Name: cameras cameras_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.cameras
    ADD CONSTRAINT "cameras_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5193 (class 2606 OID 12194624)
-- Name: controlPanelESeriesSettings controlpaneleseriessettings_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT controlpaneleseriessettings_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5194 (class 2606 OID 12194629)
-- Name: controlPanelESeriesSettings controlpaneleseriessettings_maincontrolpanelid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelESeriesSettings"
    ADD CONSTRAINT controlpaneleseriessettings_maincontrolpanelid_foreign FOREIGN KEY ("mainControlPanelId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5195 (class 2606 OID 12194634)
-- Name: controlPanelMSeriesAnalogInputs controlpanelmseriesanaloginputs_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesAnalogInputs"
    ADD CONSTRAINT controlpanelmseriesanaloginputs_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5196 (class 2606 OID 12194639)
-- Name: controlPanelMSeriesSettings controlpanelmseriesextensionsettings_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."controlPanelMSeriesSettings"
    ADD CONSTRAINT controlpanelmseriesextensionsettings_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5229 (class 2606 OID 12194644)
-- Name: notification created_by_user_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT created_by_user_id_fk FOREIGN KEY ("createdByUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5197 (class 2606 OID 12194649)
-- Name: customReports custom_reports_user_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."customReports"
    ADD CONSTRAINT custom_reports_user_filter_id_user_filter_id_fk FOREIGN KEY ("userFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5198 (class 2606 OID 12194654)
-- Name: deviceDryContactInputs devicedrycontactinputs_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT devicedrycontactinputs_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5199 (class 2606 OID 12194659)
-- Name: deviceDryContactInputs devicedrycontactinputs_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceDryContactInputs"
    ADD CONSTRAINT devicedrycontactinputs_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5200 (class 2606 OID 12194664)
-- Name: deviceIntegrations deviceintegrations_integrateddeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT deviceintegrations_integrateddeviceid_foreign FOREIGN KEY ("integratedDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5201 (class 2606 OID 12194669)
-- Name: deviceIntegrations deviceintegrations_integratingdeviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceIntegrations"
    ADD CONSTRAINT deviceintegrations_integratingdeviceid_foreign FOREIGN KEY ("integratingDeviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5202 (class 2606 OID 12194674)
-- Name: deviceReaders devicereaders_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5203 (class 2606 OID 12194679)
-- Name: deviceReaders devicereaders_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5204 (class 2606 OID 12194684)
-- Name: deviceReaders devicereaders_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceReaders"
    ADD CONSTRAINT devicereaders_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5205 (class 2606 OID 12194689)
-- Name: deviceRelays devicerelays_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT devicerelays_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5206 (class 2606 OID 12194694)
-- Name: deviceRelays devicerelays_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceRelays"
    ADD CONSTRAINT devicerelays_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5211 (class 2606 OID 12194699)
-- Name: devices devices_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5212 (class 2606 OID 12194704)
-- Name: devices devices_things_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.devices
    ADD CONSTRAINT devices_things_fkey FOREIGN KEY (id) REFERENCES public.things(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5207 (class 2606 OID 12194709)
-- Name: deviceUpdateStatus deviceupdatestatus_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceUpdateStatus"
    ADD CONSTRAINT deviceupdatestatus_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5208 (class 2606 OID 12194714)
-- Name: deviceWiegandReaders devicewiegandreaders_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5209 (class 2606 OID 12194719)
-- Name: deviceWiegandReaders devicewiegandreaders_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5210 (class 2606 OID 12194724)
-- Name: deviceWiegandReaders devicewiegandreaders_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."deviceWiegandReaders"
    ADD CONSTRAINT devicewiegandreaders_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5215 (class 2606 OID 12194729)
-- Name: employeeLiveDay employeeLiveDay_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5216 (class 2606 OID 12194734)
-- Name: employeeLiveDay employeeLiveDay_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeLiveDay"
    ADD CONSTRAINT "employeeLiveDay_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5217 (class 2606 OID 12194739)
-- Name: employeeMonths employeeMonths_UpdatedByUserId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_UpdatedByUserId_fkey" FOREIGN KEY ("updatedByUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5218 (class 2606 OID 12194744)
-- Name: employeeMonths employeeMonths_monthlyReportId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_monthlyReportId_fkey" FOREIGN KEY ("monthlyReportId") REFERENCES organization."monthlySummaryReports"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5219 (class 2606 OID 12194749)
-- Name: employeeMonths employeeMonths_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5220 (class 2606 OID 12194754)
-- Name: employeeMonths employeeMonths_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeMonths"
    ADD CONSTRAINT "employeeMonths_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5288 (class 2606 OID 12194759)
-- Name: recalculateWorkQueue fk_organization_id_organization_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT fk_organization_id_organization_id FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5289 (class 2606 OID 12194764)
-- Name: recalculateWorkQueue fk_user_id_user_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."recalculateWorkQueue"
    ADD CONSTRAINT fk_user_id_user_id FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5221 (class 2606 OID 12194769)
-- Name: floorPlans floorplans_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."floorPlans"
    ADD CONSTRAINT floorplans_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5222 (class 2606 OID 12194774)
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5223 (class 2606 OID 12194779)
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5224 (class 2606 OID 12194784)
-- Name: hikVisionLicencePlateCameraLanes hikvisionlicenceplatecameralanes_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."hikVisionLicencePlateCameraLanes"
    ADD CONSTRAINT hikvisionlicenceplatecameralanes_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5225 (class 2606 OID 12194789)
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_accesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_accesscontrolpointid_foreign FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5226 (class 2606 OID 12194794)
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_deviceid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_deviceid_foreign FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5227 (class 2606 OID 12194799)
-- Name: impinjSpeedWayGateWayAntennas impinjspeedwaygatewayantennas_relayid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."impinjSpeedWayGateWayAntennas"
    ADD CONSTRAINT impinjspeedwaygatewayantennas_relayid_foreign FOREIGN KEY ("relayId") REFERENCES organization."deviceRelays"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5228 (class 2606 OID 12194804)
-- Name: monthlySummaryReports monthlySummaryReports_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."monthlySummaryReports"
    ADD CONSTRAINT "monthlySummaryReports_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5231 (class 2606 OID 12194809)
-- Name: notification_access notification_access_region_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_region_id_fkey FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5232 (class 2606 OID 12194814)
-- Name: notification_access notification_access_target_user_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_access_target_user_id_fkey FOREIGN KEY ("targetUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5234 (class 2606 OID 12194819)
-- Name: notification_event notification_event_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_event
    ADD CONSTRAINT notification_event_filter_id_user_filter_id_fk FOREIGN KEY ("receiverFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5235 (class 2606 OID 12194831)
-- Name: notification_event notification_event_notification_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_event
    ADD CONSTRAINT notification_event_notification_id_fk FOREIGN KEY ("notificationId") REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5239 (class 2606 OID 12194843)
-- Name: notification_sensor notification_fk_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_fk_id FOREIGN KEY (id) REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5233 (class 2606 OID 12194848)
-- Name: notification_access notification_fk_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_access
    ADD CONSTRAINT notification_fk_id FOREIGN KEY (id) REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5236 (class 2606 OID 12194853)
-- Name: notification_instance notification_instance_event_id_notification_event_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_event_id_notification_event_id_fk FOREIGN KEY ("eventId", "createdT") REFERENCES organization.notification_event(id, "createdT") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5237 (class 2606 OID 12194866)
-- Name: notification_instance notification_instance_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_id_fk FOREIGN KEY (id, "createdT") REFERENCES public.notification_instance(id, "createdT") ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5238 (class 2606 OID 12194879)
-- Name: notification_instance notification_instance_notification_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE organization.notification_instance
    ADD CONSTRAINT notification_instance_notification_id_fk FOREIGN KEY ("notificationId") REFERENCES organization.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5230 (class 2606 OID 12194885)
-- Name: notification notification_receiver_filter_id_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification
    ADD CONSTRAINT notification_receiver_filter_id_user_filter_id_fk FOREIGN KEY ("receiverFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5240 (class 2606 OID 12194890)
-- Name: notification_sensor notification_sensor_access_control_point_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_access_control_point_id_fkey FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5241 (class 2606 OID 12194895)
-- Name: notification_sensor notification_sensor_device_dry_contact_input_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.notification_sensor
    ADD CONSTRAINT notification_sensor_device_dry_contact_input_id_fkey FOREIGN KEY ("deviceDryContactInputId") REFERENCES organization."deviceDryContactInputs"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5242 (class 2606 OID 12194900)
-- Name: oAuthTokens oAuthTokens_oAuthClientId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_oAuthClientId_fkey" FOREIGN KEY ("oAuthClientId") REFERENCES organization."oAuthClients"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5243 (class 2606 OID 12194905)
-- Name: oAuthTokens oAuthTokens_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."oAuthTokens"
    ADD CONSTRAINT "oAuthTokens_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5244 (class 2606 OID 12194910)
-- Name: organizationActiveVisits organizationActiveVisits_escortUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey" FOREIGN KEY ("escortUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- TOC entry 5245 (class 2606 OID 12194915)
-- Name: organizationActiveVisits organizationActiveVisits_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5246 (class 2606 OID 12194920)
-- Name: organizationActiveVisits organizationActiveVisits_organizationVisitorProfileId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_organizationVisitorProfileId_fkey" FOREIGN KEY ("organizationVisitorProfileId") REFERENCES organization."organizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5247 (class 2606 OID 12194925)
-- Name: organizationActiveVisits organizationActiveVisits_visitedOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey" FOREIGN KEY ("visitedOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- TOC entry 5248 (class 2606 OID 12194930)
-- Name: organizationActiveVisits organizationActiveVisits_visitedUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey" FOREIGN KEY ("visitedUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- TOC entry 5253 (class 2606 OID 12194935)
-- Name: organizationForms organizationForms_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationForms"
    ADD CONSTRAINT "organizationForms_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5254 (class 2606 OID 12194940)
-- Name: organizationModules organizationModules_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationModules"
    ADD CONSTRAINT "organizationModules_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5255 (class 2606 OID 12194945)
-- Name: organizationPACSModuleSettings organizationPACSModuleSettings_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationPACSModuleSettings"
    ADD CONSTRAINT "organizationPACSModuleSettings_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5256 (class 2606 OID 12194950)
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlP_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- TOC entry 5257 (class 2606 OID 12194955)
-- Name: organizationUnitDefaultAccessControlPoints organizationUnitDefaultAccessControlPoi_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnitDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationUnitDefaultAccessControlPoi_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5258 (class 2606 OID 12194960)
-- Name: organizationUnits organizationUnits_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_id_fkey" FOREIGN KEY (id) REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE;


--
-- TOC entry 5259 (class 2606 OID 12194965)
-- Name: organizationUnits organizationUnits_managerUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_managerUserOrganizationId_fkey" FOREIGN KEY ("managerUserOrganizationId") REFERENCES organization."userOrganizations"(id);


--
-- TOC entry 5260 (class 2606 OID 12194970)
-- Name: organizationUnits organizationUnits_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5261 (class 2606 OID 12194975)
-- Name: organizationUnits organizationUnits_parentId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_parentId_fkey" FOREIGN KEY ("parentId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 5262 (class 2606 OID 12194980)
-- Name: organizationUnits organizationUnits_users_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT "organizationUnits_users_fkey" FOREIGN KEY ("managerUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5267 (class 2606 OID 12194985)
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessContr_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessContr_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5268 (class 2606 OID 12194990)
-- Name: organizationVisitorDefaultAccessControlPoints organizationVisitorDefaultAccessControlPoin_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorDefaultAccessControlPoints"
    ADD CONSTRAINT "organizationVisitorDefaultAccessControlPoin_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5269 (class 2606 OID 12194995)
-- Name: organizationVisitorModuleSettings organizationVisitorModuleSettings_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorModuleSettings"
    ADD CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5270 (class 2606 OID 12195000)
-- Name: organizationVisitorProfiles organizationVisitorProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorProfiles"
    ADD CONSTRAINT "organizationVisitorProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5213 (class 2606 OID 12195005)
-- Name: employeeDays organization_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT organization_id FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5249 (class 2606 OID 12195010)
-- Name: organizationActiveVisits organizationactivevisits_visitorregistrationpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationActiveVisits"
    ADD CONSTRAINT organizationactivevisits_visitorregistrationpointid_foreign FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5250 (class 2606 OID 12195015)
-- Name: organizationEmailTemplates organizationemailtemplates_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationEmailTemplates"
    ADD CONSTRAINT organizationemailtemplates_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5251 (class 2606 OID 12195020)
-- Name: organizationFeedbacks organizationfeedbacks_createdby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT organizationfeedbacks_createdby_foreign FOREIGN KEY ("createdBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5252 (class 2606 OID 12195025)
-- Name: organizationFeedbacks organizationfeedbacks_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationFeedbacks"
    ADD CONSTRAINT organizationfeedbacks_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5274 (class 2606 OID 12195030)
-- Name: organizations organizations_organizationList_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.organizations
    ADD CONSTRAINT "organizations_organizationList_fkey" FOREIGN KEY (id) REFERENCES public."organizationList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5265 (class 2606 OID 12195035)
-- Name: organizationUserDefinedLists organizationuserdefinedlists_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedLists"
    ADD CONSTRAINT organizationuserdefinedlists_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5264 (class 2606 OID 12195040)
-- Name: organizationUserDefinedListValues organizationuserdefinedlistvalues_userdefinedlistid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserDefinedListValues"
    ADD CONSTRAINT organizationuserdefinedlistvalues_userdefinedlistid_foreign FOREIGN KEY ("userDefinedListId") REFERENCES organization."organizationUserDefinedLists"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5266 (class 2606 OID 12195045)
-- Name: organizationUserSync organizationusersync_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUserSync"
    ADD CONSTRAINT organizationusersync_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5271 (class 2606 OID 12195050)
-- Name: organizationVisitorStates organizationvisitorstates_createdby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_createdby_foreign FOREIGN KEY ("createdBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5272 (class 2606 OID 12195055)
-- Name: organizationVisitorStates organizationvisitorstates_deletedby_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_deletedby_foreign FOREIGN KEY ("deletedBy") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5273 (class 2606 OID 12195060)
-- Name: organizationVisitorStates organizationvisitorstates_organizationvisitorprofileid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationVisitorStates"
    ADD CONSTRAINT organizationvisitorstates_organizationvisitorprofileid_foreign FOREIGN KEY ("organizationVisitorProfileId") REFERENCES organization."organizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5263 (class 2606 OID 12195065)
-- Name: organizationUnits orgunit_type_id_orguserdefinedlistvalues_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."organizationUnits"
    ADD CONSTRAINT orgunit_type_id_orguserdefinedlistvalues_id FOREIGN KEY ("typeId") REFERENCES organization."organizationUserDefinedListValues"(id);


--
-- TOC entry 5275 (class 2606 OID 12195070)
-- Name: pacs_notification_scheduled_job pacs_notification_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT pacs_notification_user_filter_id_fk FOREIGN KEY ("subjectedEmployeesFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5277 (class 2606 OID 12195075)
-- Name: ppermissionAttachments ppermissionAttachments_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionAttachments"
    ADD CONSTRAINT "ppermissionAttachments_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5278 (class 2606 OID 12195080)
-- Name: ppermissionClaims ppermissionClaims_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5279 (class 2606 OID 12195085)
-- Name: ppermissionClaims ppermissionClaims_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5280 (class 2606 OID 12195090)
-- Name: ppermissionClaims ppermissionClaims_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionClaims"
    ADD CONSTRAINT "ppermissionClaims_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5281 (class 2606 OID 12195095)
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5282 (class 2606 OID 12195100)
-- Name: ppermissionTypeApprovements ppermissionTypeApprovements_rootOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypeApprovements"
    ADD CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey" FOREIGN KEY ("rootOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- TOC entry 5283 (class 2606 OID 12195105)
-- Name: ppermissionTypes ppermissionTypes_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."ppermissionTypes"
    ADD CONSTRAINT "ppermissionTypes_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5284 (class 2606 OID 12195110)
-- Name: ppermissions ppermissions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT "ppermissions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5285 (class 2606 OID 12195115)
-- Name: ppermissions ppermissions_ppermissionTypeId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.ppermissions
    ADD CONSTRAINT "ppermissions_ppermissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId") REFERENCES organization."ppermissionTypes"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5286 (class 2606 OID 12195120)
-- Name: preparedReports prepared_reports_filter_user_filter_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preparedReports"
    ADD CONSTRAINT prepared_reports_filter_user_filter_id_fk FOREIGN KEY ("userFilterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5287 (class 2606 OID 12195125)
-- Name: preregisterDailySummaries preregisterdailysummaries_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."preregisterDailySummaries"
    ADD CONSTRAINT preregisterdailysummaries_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5290 (class 2606 OID 12195130)
-- Name: regionAccessControlPoints regionAccessControlPoints_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5291 (class 2606 OID 12195135)
-- Name: regionAccessControlPoints regionAccessControlPoints_regionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionAccessControlPoints"
    ADD CONSTRAINT "regionAccessControlPoints_regionId_fkey" FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5294 (class 2606 OID 12195140)
-- Name: regions regions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.regions
    ADD CONSTRAINT "regions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5292 (class 2606 OID 12195145)
-- Name: regionTickets regiontickets_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT regiontickets_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5293 (class 2606 OID 12195150)
-- Name: regionTickets regiontickets_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."regionTickets"
    ADD CONSTRAINT regiontickets_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5295 (class 2606 OID 12195155)
-- Name: report_scheduled_job report_scheduled_job_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_scheduled_job
    ADD CONSTRAINT report_scheduled_job_id_fk FOREIGN KEY (id) REFERENCES public.scheduled_job(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5276 (class 2606 OID 12195160)
-- Name: pacs_notification_scheduled_job report_scheduled_job_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.pacs_notification_scheduled_job
    ADD CONSTRAINT report_scheduled_job_id_fk FOREIGN KEY (id) REFERENCES public.scheduled_job(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5296 (class 2606 OID 12195165)
-- Name: report_templates report_templates_custom_report_id_custom_reports_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT report_templates_custom_report_id_custom_reports_id FOREIGN KEY ("customReportId") REFERENCES organization."customReports"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5298 (class 2606 OID 12195170)
-- Name: roles roles_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.roles
    ADD CONSTRAINT "roles_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5299 (class 2606 OID 12195175)
-- Name: stickerAccessControlPointMappings stickerAccessControlPointMappings_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."stickerAccessControlPointMappings"
    ADD CONSTRAINT "stickerAccessControlPointMappings_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5300 (class 2606 OID 12195180)
-- Name: terminalAdministrators terminalAdministrators_terminalId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_terminalId_fkey" FOREIGN KEY ("terminalId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5301 (class 2606 OID 12195185)
-- Name: terminalAdministrators terminalAdministrators_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalAdministrators"
    ADD CONSTRAINT "terminalAdministrators_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5302 (class 2606 OID 12195190)
-- Name: terminalChangeTransactions terminalChangeTransactions_deviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChangeTransactions"
    ADD CONSTRAINT "terminalChangeTransactions_deviceId_fkey" FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5303 (class 2606 OID 12195195)
-- Name: terminalChanges terminalChanges_deviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."terminalChanges"
    ADD CONSTRAINT "terminalChanges_deviceId_fkey" FOREIGN KEY ("deviceId") REFERENCES organization.devices(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5304 (class 2606 OID 12195200)
-- Name: userAccessRights userAccessRights_accessControlPointId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5305 (class 2606 OID 12195205)
-- Name: userAccessRights userAccessRights_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userAccessRights"
    ADD CONSTRAINT "userAccessRights_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5308 (class 2606 OID 12195210)
-- Name: userGroupUserOrganizations userGroupUserOrganizations_userGroupId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey" FOREIGN KEY ("userGroupId") REFERENCES organization."userGroups"(id);


--
-- TOC entry 5309 (class 2606 OID 12195215)
-- Name: userGroupUserOrganizations userGroupUserOrganizations_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupUserOrganizations"
    ADD CONSTRAINT "userGroupUserOrganizations_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5310 (class 2606 OID 12195220)
-- Name: userGroups userGroups_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5311 (class 2606 OID 12195225)
-- Name: userGroups userGroups_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroups"
    ADD CONSTRAINT "userGroups_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5312 (class 2606 OID 12195230)
-- Name: userOrganizationCredentials userOrganizationCredentials_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5313 (class 2606 OID 12195235)
-- Name: userOrganizationCredentials userOrganizationCredentials_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationCredentials"
    ADD CONSTRAINT "userOrganizationCredentials_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5314 (class 2606 OID 12195240)
-- Name: userOrganizationDeputies userOrganizationDeputies_deputyUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_deputyUserOrganizationId_fkey" FOREIGN KEY ("deputyUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5315 (class 2606 OID 12195245)
-- Name: userOrganizationDeputies userOrganizationDeputies_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- TOC entry 5316 (class 2606 OID 12195250)
-- Name: userOrganizationDeputies userOrganizationDeputies_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id);


--
-- TOC entry 5317 (class 2606 OID 12195255)
-- Name: userOrganizationDeputies userOrganizationDeputies_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationDeputies"
    ADD CONSTRAINT "userOrganizationDeputies_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5321 (class 2606 OID 12195260)
-- Name: userOrganizationLeaves userOrganizationLeaves_updatedByUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_updatedByUserOrganizationId_fkey" FOREIGN KEY ("updatedByUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5322 (class 2606 OID 12195265)
-- Name: userOrganizationLeaves userOrganizationLeaves_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationLeaves"
    ADD CONSTRAINT "userOrganizationLeaves_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5323 (class 2606 OID 12195270)
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5324 (class 2606 OID 12195275)
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_roleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey" FOREIGN KEY ("roleId") REFERENCES organization.roles(id);


--
-- TOC entry 5325 (class 2606 OID 12195280)
-- Name: userOrganizationOrganizationUnits userOrganizationOrganizationUnits_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationOrganizationUnits"
    ADD CONSTRAINT "userOrganizationOrganizationUnits_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5326 (class 2606 OID 12195285)
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5327 (class 2606 OID 12195290)
-- Name: userOrganizationProfilePhotos userOrganizationProfilePhotos_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfilePhotos"
    ADD CONSTRAINT "userOrganizationProfilePhotos_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5328 (class 2606 OID 12195295)
-- Name: userOrganizationProfiles userOrganizationProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5329 (class 2606 OID 12195300)
-- Name: userOrganizationProfiles userOrganizationProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationProfiles"
    ADD CONSTRAINT "userOrganizationProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5330 (class 2606 OID 12195305)
-- Name: userOrganizationSettings userOrganizationSettings_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationSettings"
    ADD CONSTRAINT "userOrganizationSettings_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5331 (class 2606 OID 12195310)
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5332 (class 2606 OID 12195315)
-- Name: userOrganizationVisitorProfiles userOrganizationVisitorProfiles_userOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisitorProfiles"
    ADD CONSTRAINT "userOrganizationVisitorProfiles_userOrganizationId_fkey" FOREIGN KEY ("userOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5333 (class 2606 OID 12195320)
-- Name: userOrganizationVisits userOrganizationVisits_userOrganizationVisitorProfileId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_userOrganizationVisitorProfileId_fkey" FOREIGN KEY ("userOrganizationVisitorProfileId") REFERENCES organization."userOrganizationVisitorProfiles"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5334 (class 2606 OID 12195325)
-- Name: userOrganizationVisits userOrganizationVisits_visitSupervisedByUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitSupervisedByUserOrganizationId_fkey" FOREIGN KEY ("visitSupervisedByUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5335 (class 2606 OID 12195330)
-- Name: userOrganizationVisits userOrganizationVisits_visitingOrganizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitingOrganizationUnitId_fkey" FOREIGN KEY ("visitingOrganizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- TOC entry 5336 (class 2606 OID 12195335)
-- Name: userOrganizationVisits userOrganizationVisits_visitingUserOrganizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationVisits"
    ADD CONSTRAINT "userOrganizationVisits_visitingUserOrganizationId_fkey" FOREIGN KEY ("visitingUserOrganizationId") REFERENCES organization."userOrganizations"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5337 (class 2606 OID 12195340)
-- Name: userOrganizations userOrganizations_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5338 (class 2606 OID 12195345)
-- Name: userOrganizations userOrganizations_roleId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_roleId_fkey" FOREIGN KEY ("roleId") REFERENCES organization.roles(id);


--
-- TOC entry 5339 (class 2606 OID 12195350)
-- Name: userOrganizations userOrganizations_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5340 (class 2606 OID 12195355)
-- Name: userOrganizations userOrganizations_userOrganizationMapping_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizations"
    ADD CONSTRAINT "userOrganizations_userOrganizationMapping_fkey" FOREIGN KEY (id) REFERENCES public."userOrganizationMapping"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5341 (class 2606 OID 12195360)
-- Name: userPPermissionApprovements userPPermissionApprovements_approverUserId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_approverUserId_fkey" FOREIGN KEY ("approverUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5342 (class 2606 OID 12195365)
-- Name: userPPermissionApprovements userPPermissionApprovements_organizationUnitId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey" FOREIGN KEY ("organizationUnitId") REFERENCES organization."organizationUnits"(id);


--
-- TOC entry 5343 (class 2606 OID 12195370)
-- Name: userPPermissionApprovements userPPermissionApprovements_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5344 (class 2606 OID 12195375)
-- Name: userPPermissionApprovements userPPermissionApprovements_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissionApprovements"
    ADD CONSTRAINT "userPPermissionApprovements_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5345 (class 2606 OID 12195380)
-- Name: userPPermissions userPPermissions_ppermissionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userPPermissions"
    ADD CONSTRAINT "userPPermissions_ppermissionId_fkey" FOREIGN KEY ("ppermissionId") REFERENCES organization.ppermissions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5346 (class 2606 OID 12195385)
-- Name: userProfiles userProfiles_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userProfiles"
    ADD CONSTRAINT "userProfiles_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5351 (class 2606 OID 12195390)
-- Name: userSelectionSessionActions userSelectionSessionActions_sessionId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_sessionId_fkey" FOREIGN KEY ("sessionId") REFERENCES organization."userSelectionSessions"(id) ON DELETE CASCADE;


--
-- TOC entry 5352 (class 2606 OID 12195395)
-- Name: userSelectionSessionActions userSelectionSessionActions_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessionActions"
    ADD CONSTRAINT "userSelectionSessionActions_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5353 (class 2606 OID 12195400)
-- Name: userSelectionSessions userSelectionSessions_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5354 (class 2606 OID 12195405)
-- Name: userSelectionSessions userSelectionSessions_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userSelectionSessions"
    ADD CONSTRAINT "userSelectionSessions_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5355 (class 2606 OID 12195410)
-- Name: userWorkPlans userWorkPlans_userId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_userId_fkey" FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5356 (class 2606 OID 12195415)
-- Name: userWorkPlans userWorkPlans_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userWorkPlans"
    ADD CONSTRAINT "userWorkPlans_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5357 (class 2606 OID 12195420)
-- Name: user_filter_group user_filter_group_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5358 (class 2606 OID 12195425)
-- Name: user_filter_group user_filter_group_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_group
    ADD CONSTRAINT user_filter_group_id_fkey FOREIGN KEY ("groupId") REFERENCES organization."userGroups"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5359 (class 2606 OID 12195430)
-- Name: user_filter_organization_role user_filter_organization_role_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5360 (class 2606 OID 12195435)
-- Name: user_filter_organization_role user_filter_organization_role_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_organization_role
    ADD CONSTRAINT user_filter_organization_role_id_fkey FOREIGN KEY ("roleId") REFERENCES organization.roles(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5361 (class 2606 OID 12195440)
-- Name: user_filter_unit user_filter_unit_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5363 (class 2606 OID 12195445)
-- Name: user_filter_unit_role user_filter_unit_role_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5364 (class 2606 OID 12195450)
-- Name: user_filter_unit_role user_filter_unit_role_role_id_role_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_role_id_role_id_fkey FOREIGN KEY ("roleId") REFERENCES organization.roles(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5365 (class 2606 OID 12195455)
-- Name: user_filter_unit_role user_filter_unit_role_unit_id_organization_unit_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit_role
    ADD CONSTRAINT user_filter_unit_role_unit_id_organization_unit_id_fkey FOREIGN KEY ("unitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5362 (class 2606 OID 12195460)
-- Name: user_filter_unit user_filter_unit_unit_id_organization_unit_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_unit
    ADD CONSTRAINT user_filter_unit_unit_id_organization_unit_id_fkey FOREIGN KEY ("unitId") REFERENCES organization."organizationUnits"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5366 (class 2606 OID 12195465)
-- Name: user_filter_user user_filter_user_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5367 (class 2606 OID 12195470)
-- Name: user_filter_user user_filter_user_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_user
    ADD CONSTRAINT user_filter_user_id_fkey FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5368 (class 2606 OID 12195475)
-- Name: user_filter_work_plan user_filter_work_plan_filter_id_user_filter_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_filter_id_user_filter_id_fkey FOREIGN KEY ("filterId") REFERENCES organization.user_filter(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5369 (class 2606 OID 12195480)
-- Name: user_filter_work_plan user_filter_work_plan_id_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.user_filter_work_plan
    ADD CONSTRAINT user_filter_work_plan_id_fkey FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5214 (class 2606 OID 12195485)
-- Name: employeeDays user_id; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."employeeDays"
    ADD CONSTRAINT user_id FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5297 (class 2606 OID 12195490)
-- Name: report_templates user_id_fk; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.report_templates
    ADD CONSTRAINT user_id_fk FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5306 (class 2606 OID 12195495)
-- Name: userGroupAccessRuleSets usergroupaccessrulesets_accessrulesetid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT usergroupaccessrulesets_accessrulesetid_foreign FOREIGN KEY ("accessRuleSetId") REFERENCES organization."accessRuleSets"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5307 (class 2606 OID 12195500)
-- Name: userGroupAccessRuleSets usergroupaccessrulesets_usergroupid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userGroupAccessRuleSets"
    ADD CONSTRAINT usergroupaccessrulesets_usergroupid_foreign FOREIGN KEY ("userGroupId") REFERENCES organization."userGroups"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5318 (class 2606 OID 12195505)
-- Name: userOrganizationForbiddances userorganizationforbiddances_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5319 (class 2606 OID 12195510)
-- Name: userOrganizationForbiddances userorganizationforbiddances_regionid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_regionid_foreign FOREIGN KEY ("regionId") REFERENCES organization.regions(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5320 (class 2606 OID 12195515)
-- Name: userOrganizationForbiddances userorganizationforbiddances_userid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userOrganizationForbiddances"
    ADD CONSTRAINT userorganizationforbiddances_userid_foreign FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5347 (class 2606 OID 12195520)
-- Name: userRegionTicketUnits userregionticketunits_lastupdateaccesscontrolpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_lastupdateaccesscontrolpointid_foreign FOREIGN KEY ("lastUpdateAccessControlPointId") REFERENCES organization."accessControlPoints"(id);


--
-- TOC entry 5348 (class 2606 OID 12195525)
-- Name: userRegionTicketUnits userregionticketunits_lastupdateuserid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_lastupdateuserid_foreign FOREIGN KEY ("lastUpdateUserId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5349 (class 2606 OID 12195530)
-- Name: userRegionTicketUnits userregionticketunits_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5350 (class 2606 OID 12195535)
-- Name: userRegionTicketUnits userregionticketunits_userid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."userRegionTicketUnits"
    ADD CONSTRAINT userregionticketunits_userid_foreign FOREIGN KEY ("userId") REFERENCES organization.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5370 (class 2606 OID 12195540)
-- Name: users users_userList_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.users
    ADD CONSTRAINT "users_userList_fkey" FOREIGN KEY (id) REFERENCES public."userList"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5373 (class 2606 OID 12195545)
-- Name: vacations vacations_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization.vacations
    ADD CONSTRAINT "vacations_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5378 (class 2606 OID 12195550)
-- Name: visitorRegistrationPoints visitorRegistrationPoints_tabletDeviceId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey" FOREIGN KEY ("tabletDeviceId") REFERENCES organization.devices(id);


--
-- TOC entry 5374 (class 2606 OID 12195555)
-- Name: visitorDailySummaries visitordailysummaries_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorDailySummaries"
    ADD CONSTRAINT visitordailysummaries_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id);


--
-- TOC entry 5375 (class 2606 OID 12195560)
-- Name: visitorDailySummaries visitordailysummaries_visitorregistrationpointid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorDailySummaries"
    ADD CONSTRAINT visitordailysummaries_visitorregistrationpointid_foreign FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id);


--
-- TOC entry 5376 (class 2606 OID 12195565)
-- Name: visitorRegistrationPointAccessControlPoints visitorregistrationpointaccesscontrolpoints_accesscontrolpointi; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT visitorregistrationpointaccesscontrolpoints_accesscontrolpointi FOREIGN KEY ("accessControlPointId") REFERENCES organization."accessControlPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5377 (class 2606 OID 12195570)
-- Name: visitorRegistrationPointAccessControlPoints visitorregistrationpointaccesscontrolpoints_visitorregistration; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPointAccessControlPoints"
    ADD CONSTRAINT visitorregistrationpointaccesscontrolpoints_visitorregistration FOREIGN KEY ("visitorRegistrationPointId") REFERENCES organization."visitorRegistrationPoints"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5379 (class 2606 OID 12195575)
-- Name: visitorRegistrationPoints visitorregistrationpoints_organizationid_foreign; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."visitorRegistrationPoints"
    ADD CONSTRAINT visitorregistrationpoints_organizationid_foreign FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5380 (class 2606 OID 12195580)
-- Name: workPlanNotifications workPlanNotifications_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanNotifications"
    ADD CONSTRAINT "workPlanNotifications_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5371 (class 2606 OID 12195585)
-- Name: workPlanPeriods workPlanPeriods_workPlanId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlanPeriods"
    ADD CONSTRAINT "workPlanPeriods_workPlanId_fkey" FOREIGN KEY ("workPlanId") REFERENCES organization."workPlans"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5372 (class 2606 OID 12195590)
-- Name: workPlans workPlans_organizationId_fkey; Type: FK CONSTRAINT; Schema: organization; Owner: armonsuper
--

ALTER TABLE ONLY organization."workPlans"
    ADD CONSTRAINT "workPlans_organizationId_fkey" FOREIGN KEY ("organizationId") REFERENCES organization.organizations(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 5591 (class 0 OID 0)
-- Dependencies: 10
-- Name: SCHEMA organization; Type: ACL; Schema: -; Owner: armonsuper
--

GRANT USAGE ON SCHEMA organization TO armonapi;


--
-- TOC entry 5592 (class 0 OID 0)
-- Dependencies: 787
-- Name: FUNCTION add_recalculate_records_for_ppermission_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_ppermission_change() TO armonapi;


--
-- TOC entry 5593 (class 0 OID 0)
-- Dependencies: 686
-- Name: FUNCTION add_recalculate_records_for_user_ppermission_add_delete(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_user_ppermission_add_delete() TO armonapi;


--
-- TOC entry 5594 (class 0 OID 0)
-- Dependencies: 745
-- Name: FUNCTION add_recalculate_records_for_vacation_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.add_recalculate_records_for_vacation_change() TO armonapi;


--
-- TOC entry 5595 (class 0 OID 0)
-- Dependencies: 746
-- Name: FUNCTION after_in_up_del_anti_passback_state(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_in_up_del_anti_passback_state() TO armonapi;


--
-- TOC entry 5596 (class 0 OID 0)
-- Dependencies: 747
-- Name: FUNCTION after_insert_terminal_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_insert_terminal_change() TO armonapi;


--
-- TOC entry 5597 (class 0 OID 0)
-- Dependencies: 748
-- Name: FUNCTION after_insert_terminal_transaction(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_insert_terminal_transaction() TO armonapi;


--
-- TOC entry 5598 (class 0 OID 0)
-- Dependencies: 749
-- Name: FUNCTION after_update_organization_settings(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.after_update_organization_settings() TO armonapi;


--
-- TOC entry 5599 (class 0 OID 0)
-- Dependencies: 731
-- Name: FUNCTION before_insert_terminal_change(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_insert_terminal_change() TO armonapi;


--
-- TOC entry 5600 (class 0 OID 0)
-- Dependencies: 751
-- Name: FUNCTION before_up_del_regions(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_regions() TO armonapi;


--
-- TOC entry 5601 (class 0 OID 0)
-- Dependencies: 752
-- Name: FUNCTION before_up_del_user(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_user() TO armonapi;


--
-- TOC entry 5602 (class 0 OID 0)
-- Dependencies: 754
-- Name: FUNCTION before_up_del_user_organizations(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_del_user_organizations() TO armonapi;


--
-- TOC entry 5603 (class 0 OID 0)
-- Dependencies: 755
-- Name: FUNCTION before_up_in_del_access_control_point(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_access_control_point() TO armonapi;


--
-- TOC entry 5604 (class 0 OID 0)
-- Dependencies: 756
-- Name: FUNCTION before_up_in_del_camera(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_camera() TO armonapi;


--
-- TOC entry 5605 (class 0 OID 0)
-- Dependencies: 757
-- Name: FUNCTION before_up_in_del_camera_actions(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_camera_actions() TO armonapi;


--
-- TOC entry 5606 (class 0 OID 0)
-- Dependencies: 758
-- Name: FUNCTION before_up_in_del_device_dry_contact_inputs(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_dry_contact_inputs() TO armonapi;


--
-- TOC entry 5607 (class 0 OID 0)
-- Dependencies: 741
-- Name: FUNCTION before_up_in_del_device_readers(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_readers() TO armonapi;


--
-- TOC entry 5608 (class 0 OID 0)
-- Dependencies: 761
-- Name: FUNCTION before_up_in_del_device_relays(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_device_relays() TO armonapi;


--
-- TOC entry 5609 (class 0 OID 0)
-- Dependencies: 762
-- Name: FUNCTION before_up_in_del_notification_access(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_notification_access() TO armonapi;


--
-- TOC entry 5610 (class 0 OID 0)
-- Dependencies: 763
-- Name: FUNCTION before_up_in_del_notification_sensor(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_notification_sensor() TO armonapi;


--
-- TOC entry 5611 (class 0 OID 0)
-- Dependencies: 764
-- Name: FUNCTION before_up_in_del_o_auth_tokens(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_o_auth_tokens() TO armonapi;


--
-- TOC entry 5612 (class 0 OID 0)
-- Dependencies: 765
-- Name: FUNCTION before_up_in_del_region_access_control_points(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_region_access_control_points() TO armonapi;


--
-- TOC entry 5613 (class 0 OID 0)
-- Dependencies: 766
-- Name: FUNCTION before_up_in_del_user_access_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_access_notification() TO armonapi;


--
-- TOC entry 5614 (class 0 OID 0)
-- Dependencies: 767
-- Name: FUNCTION before_up_in_del_user_access_rights(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_access_rights() TO armonapi;


--
-- TOC entry 5615 (class 0 OID 0)
-- Dependencies: 759
-- Name: FUNCTION before_up_in_del_user_forbiddances(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_forbiddances() TO armonapi;


--
-- TOC entry 5616 (class 0 OID 0)
-- Dependencies: 768
-- Name: FUNCTION before_up_in_del_user_group_mapping(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_group_mapping() TO armonapi;


--
-- TOC entry 5617 (class 0 OID 0)
-- Dependencies: 769
-- Name: FUNCTION before_up_in_del_user_organization_credentials(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_organization_credentials() TO armonapi;


--
-- TOC entry 5618 (class 0 OID 0)
-- Dependencies: 770
-- Name: FUNCTION before_up_in_del_user_organization_sensor_notifications(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_organization_sensor_notifications() TO armonapi;


--
-- TOC entry 5619 (class 0 OID 0)
-- Dependencies: 771
-- Name: FUNCTION before_up_in_del_user_region_ticket_unit(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_del_user_region_ticket_unit() TO armonapi;


--
-- TOC entry 5620 (class 0 OID 0)
-- Dependencies: 772
-- Name: FUNCTION before_up_in_delete_access_rule_sets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_access_rule_sets() TO armonapi;


--
-- TOC entry 5621 (class 0 OID 0)
-- Dependencies: 773
-- Name: FUNCTION before_up_in_delete_access_rules(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_access_rules() TO armonapi;


--
-- TOC entry 5622 (class 0 OID 0)
-- Dependencies: 774
-- Name: FUNCTION before_up_in_delete_region_tickets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_region_tickets() TO armonapi;


--
-- TOC entry 5623 (class 0 OID 0)
-- Dependencies: 687
-- Name: FUNCTION before_up_in_delete_user_group_access_rule_sets(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_delete_user_group_access_rule_sets() TO armonapi;


--
-- TOC entry 5624 (class 0 OID 0)
-- Dependencies: 753
-- Name: FUNCTION before_up_in_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_notification() TO armonapi;


--
-- TOC entry 5625 (class 0 OID 0)
-- Dependencies: 775
-- Name: FUNCTION before_up_in_user_rule_history(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_up_in_user_rule_history() TO armonapi;


--
-- TOC entry 5626 (class 0 OID 0)
-- Dependencies: 776
-- Name: FUNCTION before_update_devices(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.before_update_devices() TO armonapi;


--
-- TOC entry 5627 (class 0 OID 0)
-- Dependencies: 777
-- Name: FUNCTION fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fauthorizeuserfor(organization_id uuid, user_id uuid, organization_unit_ids uuid[], access_control_point_ids uuid[], user_ids uuid[], user_group_ids uuid[]) TO armonapi;


--
-- TOC entry 5628 (class 0 OID 0)
-- Dependencies: 778
-- Name: FUNCTION fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fcollectusersforaccessreportfilter(organization_id uuid, organization_unit_ids uuid[], filter_organization_unit_members_hierarchically boolean, user_ids uuid[], user_group_ids uuid[]) TO armonapi;


--
-- TOC entry 5629 (class 0 OID 0)
-- Dependencies: 779
-- Name: FUNCTION fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.fgetorganizationunitdetailed(organization_id uuid, organization_unit_id uuid, is_system_administrator boolean, user_id uuid) TO armonapi;


--
-- TOC entry 5630 (class 0 OID 0)
-- Dependencies: 780
-- Name: FUNCTION gen_profile_text(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.gen_profile_text() TO armonapi;


--
-- TOC entry 5631 (class 0 OID 0)
-- Dependencies: 760
-- Name: FUNCTION json_append(data json, insert_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_append(data json, insert_data json) TO armonapi;


--
-- TOC entry 5632 (class 0 OID 0)
-- Dependencies: 681
-- Name: FUNCTION json_delete(data json, keys text[]); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_delete(data json, keys text[]) TO armonapi;


--
-- TOC entry 5633 (class 0 OID 0)
-- Dependencies: 682
-- Name: FUNCTION json_merge(data json, merge_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_merge(data json, merge_data json) TO armonapi;


--
-- TOC entry 5634 (class 0 OID 0)
-- Dependencies: 685
-- Name: FUNCTION json_update(data json, update_data json); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.json_update(data json, update_data json) TO armonapi;


--
-- TOC entry 5635 (class 0 OID 0)
-- Dependencies: 688
-- Name: FUNCTION notify_pacs_live_recalculation(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.notify_pacs_live_recalculation() TO armonapi;


--
-- TOC entry 5636 (class 0 OID 0)
-- Dependencies: 781
-- Name: FUNCTION process_recalculate_work_queue_start_date_time(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.process_recalculate_work_queue_start_date_time() TO armonapi;


--
-- TOC entry 5637 (class 0 OID 0)
-- Dependencies: 782
-- Name: FUNCTION update_terminaladmins(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.update_terminaladmins() TO armonapi;


--
-- TOC entry 5638 (class 0 OID 0)
-- Dependencies: 783
-- Name: FUNCTION zz_notification(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification() TO armonapi;


--
-- TOC entry 5639 (class 0 OID 0)
-- Dependencies: 784
-- Name: FUNCTION zz_notification_access(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification_access() TO armonapi;


--
-- TOC entry 5640 (class 0 OID 0)
-- Dependencies: 750
-- Name: FUNCTION zz_notification_sensor(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_notification_sensor() TO armonapi;


--
-- TOC entry 5641 (class 0 OID 0)
-- Dependencies: 785
-- Name: FUNCTION zz_pacs_notification_scheduled_job(); Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT ALL ON FUNCTION organization.zz_pacs_notification_scheduled_job() TO armonapi;


--
-- TOC entry 5642 (class 0 OID 0)
-- Dependencies: 427
-- Name: TABLE "accessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessControlPoints" TO armonapi;


--
-- TOC entry 5643 (class 0 OID 0)
-- Dependencies: 428
-- Name: TABLE "accessRuleHistory"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRuleHistory" TO armonapi;


--
-- TOC entry 5644 (class 0 OID 0)
-- Dependencies: 429
-- Name: TABLE "accessRuleSets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRuleSets" TO armonapi;


--
-- TOC entry 5645 (class 0 OID 0)
-- Dependencies: 430
-- Name: TABLE "accessRules"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."accessRules" TO armonapi;


--
-- TOC entry 5646 (class 0 OID 0)
-- Dependencies: 431
-- Name: TABLE access_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_logs TO armonapi;


--
-- TOC entry 5647 (class 0 OID 0)
-- Dependencies: 432
-- Name: TABLE access_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_logs_default TO armonapi;


--
-- TOC entry 5648 (class 0 OID 0)
-- Dependencies: 433
-- Name: TABLE access_point_qr_code; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_point_qr_code TO armonapi;


--
-- TOC entry 5649 (class 0 OID 0)
-- Dependencies: 434
-- Name: TABLE access_snapshots; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_snapshots TO armonapi;


--
-- TOC entry 5650 (class 0 OID 0)
-- Dependencies: 435
-- Name: TABLE access_snapshots_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.access_snapshots_default TO armonapi;


--
-- TOC entry 5651 (class 0 OID 0)
-- Dependencies: 436
-- Name: TABLE adapters; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.adapters TO armonapi;


--
-- TOC entry 5652 (class 0 OID 0)
-- Dependencies: 437
-- Name: TABLE "antiPassbackStates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."antiPassbackStates" TO armonapi;


--
-- TOC entry 5653 (class 0 OID 0)
-- Dependencies: 438
-- Name: TABLE "aperioLocks"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."aperioLocks" TO armonapi;


--
-- TOC entry 5654 (class 0 OID 0)
-- Dependencies: 439
-- Name: TABLE "attendanceAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."attendanceAccessControlPoints" TO armonapi;


--
-- TOC entry 5655 (class 0 OID 0)
-- Dependencies: 440
-- Name: TABLE "cameraActions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."cameraActions" TO armonapi;


--
-- TOC entry 5656 (class 0 OID 0)
-- Dependencies: 441
-- Name: TABLE cameras; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.cameras TO armonapi;


--
-- TOC entry 5657 (class 0 OID 0)
-- Dependencies: 442
-- Name: TABLE "controlPanelESeriesSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelESeriesSettings" TO armonapi;


--
-- TOC entry 5658 (class 0 OID 0)
-- Dependencies: 443
-- Name: TABLE "controlPanelMSeriesAnalogInputs"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelMSeriesAnalogInputs" TO armonapi;


--
-- TOC entry 5659 (class 0 OID 0)
-- Dependencies: 444
-- Name: TABLE "controlPanelMSeriesSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."controlPanelMSeriesSettings" TO armonapi;


--
-- TOC entry 5660 (class 0 OID 0)
-- Dependencies: 445
-- Name: TABLE counter_sensor_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.counter_sensor_logs TO armonapi;


--
-- TOC entry 5661 (class 0 OID 0)
-- Dependencies: 446
-- Name: TABLE counter_sensor_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.counter_sensor_logs_default TO armonapi;


--
-- TOC entry 5662 (class 0 OID 0)
-- Dependencies: 447
-- Name: TABLE "customReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."customReports" TO armonapi;


--
-- TOC entry 5663 (class 0 OID 0)
-- Dependencies: 448
-- Name: TABLE "deviceCurrentVersions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceCurrentVersions" TO armonapi;


--
-- TOC entry 5664 (class 0 OID 0)
-- Dependencies: 449
-- Name: TABLE "deviceDryContactInputs"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceDryContactInputs" TO armonapi;


--
-- TOC entry 5665 (class 0 OID 0)
-- Dependencies: 450
-- Name: TABLE "deviceIntegrations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceIntegrations" TO armonapi;


--
-- TOC entry 5666 (class 0 OID 0)
-- Dependencies: 451
-- Name: TABLE "deviceReaders"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceReaders" TO armonapi;


--
-- TOC entry 5667 (class 0 OID 0)
-- Dependencies: 452
-- Name: TABLE "deviceRelays"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceRelays" TO armonapi;


--
-- TOC entry 5668 (class 0 OID 0)
-- Dependencies: 453
-- Name: TABLE "deviceUpdateStatus"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceUpdateStatus" TO armonapi;


--
-- TOC entry 5669 (class 0 OID 0)
-- Dependencies: 454
-- Name: TABLE "deviceWiegandReaders"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."deviceWiegandReaders" TO armonapi;


--
-- TOC entry 5670 (class 0 OID 0)
-- Dependencies: 455
-- Name: TABLE devices; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.devices TO armonapi;


--
-- TOC entry 5671 (class 0 OID 0)
-- Dependencies: 456
-- Name: TABLE "employeeDays"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeDays" TO armonapi;


--
-- TOC entry 5672 (class 0 OID 0)
-- Dependencies: 457
-- Name: TABLE "employeeLiveDay"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeLiveDay" TO armonapi;


--
-- TOC entry 5673 (class 0 OID 0)
-- Dependencies: 458
-- Name: TABLE "employeeMonths"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."employeeMonths" TO armonapi;


--
-- TOC entry 5674 (class 0 OID 0)
-- Dependencies: 459
-- Name: TABLE employee_day_segments; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.employee_day_segments TO armonapi;


--
-- TOC entry 5675 (class 0 OID 0)
-- Dependencies: 460
-- Name: TABLE employee_day_segments_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.employee_day_segments_default TO armonapi;


--
-- TOC entry 5676 (class 0 OID 0)
-- Dependencies: 461
-- Name: TABLE "floorPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."floorPlans" TO armonapi;


--
-- TOC entry 5677 (class 0 OID 0)
-- Dependencies: 462
-- Name: TABLE "hikVisionLicencePlateCameraLanes"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."hikVisionLicencePlateCameraLanes" TO armonapi;


--
-- TOC entry 5678 (class 0 OID 0)
-- Dependencies: 463
-- Name: TABLE "impinjSpeedWayGateWayAntennas"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."impinjSpeedWayGateWayAntennas" TO armonapi;


--
-- TOC entry 5679 (class 0 OID 0)
-- Dependencies: 464
-- Name: TABLE log_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_history TO armonapi;


--
-- TOC entry 5680 (class 0 OID 0)
-- Dependencies: 465
-- Name: TABLE log_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_history_default TO armonapi;


--
-- TOC entry 5681 (class 0 OID 0)
-- Dependencies: 466
-- Name: TABLE log_process_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_process_history TO armonapi;


--
-- TOC entry 5682 (class 0 OID 0)
-- Dependencies: 467
-- Name: TABLE log_process_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.log_process_history_default TO armonapi;


--
-- TOC entry 5683 (class 0 OID 0)
-- Dependencies: 468
-- Name: TABLE medium_sms; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.medium_sms TO armonapi;


--
-- TOC entry 5684 (class 0 OID 0)
-- Dependencies: 469
-- Name: TABLE medium_smtp; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.medium_smtp TO armonapi;


--
-- TOC entry 5685 (class 0 OID 0)
-- Dependencies: 470
-- Name: SEQUENCE migrations_id_seq; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT ON SEQUENCE organization.migrations_id_seq TO armonapi;


--
-- TOC entry 5686 (class 0 OID 0)
-- Dependencies: 471
-- Name: TABLE "monthlySummaryReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."monthlySummaryReports" TO armonapi;


--
-- TOC entry 5687 (class 0 OID 0)
-- Dependencies: 472
-- Name: TABLE monthly_summary_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.monthly_summary_history TO armonapi;


--
-- TOC entry 5688 (class 0 OID 0)
-- Dependencies: 473
-- Name: TABLE monthly_summary_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.monthly_summary_history_default TO armonapi;


--
-- TOC entry 5689 (class 0 OID 0)
-- Dependencies: 474
-- Name: TABLE notification; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification TO armonapi;


--
-- TOC entry 5690 (class 0 OID 0)
-- Dependencies: 475
-- Name: TABLE "notificationAttachments"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."notificationAttachments" TO armonapi;


--
-- TOC entry 5691 (class 0 OID 0)
-- Dependencies: 476
-- Name: TABLE notification_access; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_access TO armonapi;


--
-- TOC entry 5692 (class 0 OID 0)
-- Dependencies: 477
-- Name: TABLE notification_event; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event TO armonapi;


--
-- TOC entry 5693 (class 0 OID 0)
-- Dependencies: 478
-- Name: TABLE notification_event_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event_default TO armonapi;


--
-- TOC entry 5694 (class 0 OID 0)
-- Dependencies: 479
-- Name: TABLE notification_event_p202101; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event_p202101 TO armonapi;


--
-- TOC entry 5695 (class 0 OID 0)
-- Dependencies: 480
-- Name: TABLE notification_event_p202102; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_event_p202102 TO armonapi;


--
-- TOC entry 5696 (class 0 OID 0)
-- Dependencies: 481
-- Name: TABLE notification_instance; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_instance TO armonapi;


--
-- TOC entry 5697 (class 0 OID 0)
-- Dependencies: 482
-- Name: TABLE notification_instance_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_instance_default TO armonapi;


--
-- TOC entry 5698 (class 0 OID 0)
-- Dependencies: 483
-- Name: TABLE notification_sensor; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.notification_sensor TO armonapi;


--
-- TOC entry 5699 (class 0 OID 0)
-- Dependencies: 484
-- Name: TABLE "oAuthClients"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."oAuthClients" TO armonapi;


--
-- TOC entry 5700 (class 0 OID 0)
-- Dependencies: 485
-- Name: TABLE "oAuthTokens"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."oAuthTokens" TO armonapi;


--
-- TOC entry 5701 (class 0 OID 0)
-- Dependencies: 486
-- Name: TABLE "organizationActiveVisits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationActiveVisits" TO armonapi;


--
-- TOC entry 5702 (class 0 OID 0)
-- Dependencies: 487
-- Name: TABLE "organizationEmailTemplates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationEmailTemplates" TO armonapi;


--
-- TOC entry 5703 (class 0 OID 0)
-- Dependencies: 488
-- Name: TABLE "organizationFeedbacks"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationFeedbacks" TO armonapi;


--
-- TOC entry 5704 (class 0 OID 0)
-- Dependencies: 489
-- Name: TABLE "organizationForms"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationForms" TO armonapi;


--
-- TOC entry 5705 (class 0 OID 0)
-- Dependencies: 490
-- Name: TABLE "organizationModules"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationModules" TO armonapi;


--
-- TOC entry 5706 (class 0 OID 0)
-- Dependencies: 491
-- Name: TABLE "organizationPACSModuleSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationPACSModuleSettings" TO armonapi;


--
-- TOC entry 5707 (class 0 OID 0)
-- Dependencies: 492
-- Name: TABLE "organizationUnitDefaultAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUnitDefaultAccessControlPoints" TO armonapi;


--
-- TOC entry 5708 (class 0 OID 0)
-- Dependencies: 493
-- Name: TABLE "organizationUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUnits" TO armonapi;


--
-- TOC entry 5709 (class 0 OID 0)
-- Dependencies: 494
-- Name: TABLE "organizationUserDefinedListValues"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserDefinedListValues" TO armonapi;


--
-- TOC entry 5710 (class 0 OID 0)
-- Dependencies: 495
-- Name: TABLE "organizationUserDefinedLists"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserDefinedLists" TO armonapi;


--
-- TOC entry 5711 (class 0 OID 0)
-- Dependencies: 496
-- Name: TABLE "organizationUserSync"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationUserSync" TO armonapi;


--
-- TOC entry 5712 (class 0 OID 0)
-- Dependencies: 497
-- Name: TABLE "organizationVisitorDefaultAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorDefaultAccessControlPoints" TO armonapi;


--
-- TOC entry 5713 (class 0 OID 0)
-- Dependencies: 498
-- Name: TABLE "organizationVisitorModuleSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorModuleSettings" TO armonapi;


--
-- TOC entry 5714 (class 0 OID 0)
-- Dependencies: 499
-- Name: TABLE "organizationVisitorProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorProfiles" TO armonapi;


--
-- TOC entry 5715 (class 0 OID 0)
-- Dependencies: 500
-- Name: TABLE "organizationVisitorStates"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."organizationVisitorStates" TO armonapi;


--
-- TOC entry 5716 (class 0 OID 0)
-- Dependencies: 501
-- Name: TABLE organization_feedback_updates; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedback_updates TO armonapi;


--
-- TOC entry 5717 (class 0 OID 0)
-- Dependencies: 502
-- Name: TABLE organization_feedback_updates_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedback_updates_default TO armonapi;


--
-- TOC entry 5718 (class 0 OID 0)
-- Dependencies: 503
-- Name: TABLE organization_feedbacks; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedbacks TO armonapi;


--
-- TOC entry 5719 (class 0 OID 0)
-- Dependencies: 504
-- Name: TABLE organization_feedbacks_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organization_feedbacks_default TO armonapi;


--
-- TOC entry 5720 (class 0 OID 0)
-- Dependencies: 505
-- Name: TABLE organizations; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.organizations TO armonapi;


--
-- TOC entry 5721 (class 0 OID 0)
-- Dependencies: 506
-- Name: TABLE pacs_notification_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.pacs_notification_scheduled_job TO armonapi;


--
-- TOC entry 5722 (class 0 OID 0)
-- Dependencies: 507
-- Name: TABLE "ppermissionAttachments"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionAttachments" TO armonapi;


--
-- TOC entry 5723 (class 0 OID 0)
-- Dependencies: 508
-- Name: TABLE "ppermissionClaims"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionClaims" TO armonapi;


--
-- TOC entry 5724 (class 0 OID 0)
-- Dependencies: 509
-- Name: TABLE "ppermissionTypeApprovements"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionTypeApprovements" TO armonapi;


--
-- TOC entry 5725 (class 0 OID 0)
-- Dependencies: 510
-- Name: TABLE "ppermissionTypes"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."ppermissionTypes" TO armonapi;


--
-- TOC entry 5726 (class 0 OID 0)
-- Dependencies: 511
-- Name: TABLE ppermission_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermission_history TO armonapi;


--
-- TOC entry 5727 (class 0 OID 0)
-- Dependencies: 512
-- Name: TABLE ppermission_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermission_history_default TO armonapi;


--
-- TOC entry 5728 (class 0 OID 0)
-- Dependencies: 513
-- Name: TABLE ppermissions; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.ppermissions TO armonapi;


--
-- TOC entry 5729 (class 0 OID 0)
-- Dependencies: 514
-- Name: TABLE "preparedReports"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."preparedReports" TO armonapi;


--
-- TOC entry 5730 (class 0 OID 0)
-- Dependencies: 515
-- Name: TABLE "preregisterDailySummaries"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."preregisterDailySummaries" TO armonapi;


--
-- TOC entry 5731 (class 0 OID 0)
-- Dependencies: 516
-- Name: TABLE "recalculateWorkQueue"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."recalculateWorkQueue" TO armonapi;


--
-- TOC entry 5732 (class 0 OID 0)
-- Dependencies: 517
-- Name: TABLE "regionAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."regionAccessControlPoints" TO armonapi;


--
-- TOC entry 5733 (class 0 OID 0)
-- Dependencies: 518
-- Name: TABLE "regionTickets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."regionTickets" TO armonapi;


--
-- TOC entry 5734 (class 0 OID 0)
-- Dependencies: 519
-- Name: TABLE regions; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.regions TO armonapi;


--
-- TOC entry 5735 (class 0 OID 0)
-- Dependencies: 520
-- Name: TABLE report_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.report_scheduled_job TO armonapi;


--
-- TOC entry 5736 (class 0 OID 0)
-- Dependencies: 521
-- Name: TABLE report_templates; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.report_templates TO armonapi;


--
-- TOC entry 5737 (class 0 OID 0)
-- Dependencies: 522
-- Name: TABLE roles; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.roles TO armonapi;


--
-- TOC entry 5738 (class 0 OID 0)
-- Dependencies: 523
-- Name: TABLE softwares; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.softwares TO armonapi;


--
-- TOC entry 5739 (class 0 OID 0)
-- Dependencies: 524
-- Name: TABLE status_sensor_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.status_sensor_logs TO armonapi;


--
-- TOC entry 5740 (class 0 OID 0)
-- Dependencies: 525
-- Name: TABLE status_sensor_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.status_sensor_logs_default TO armonapi;


--
-- TOC entry 5741 (class 0 OID 0)
-- Dependencies: 526
-- Name: TABLE "stickerAccessControlPointMappings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."stickerAccessControlPointMappings" TO armonapi;


--
-- TOC entry 5742 (class 0 OID 0)
-- Dependencies: 527
-- Name: TABLE system_status_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.system_status_logs TO armonapi;


--
-- TOC entry 5743 (class 0 OID 0)
-- Dependencies: 528
-- Name: TABLE system_status_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.system_status_logs_default TO armonapi;


--
-- TOC entry 5744 (class 0 OID 0)
-- Dependencies: 529
-- Name: TABLE tamper_switch_logs; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.tamper_switch_logs TO armonapi;


--
-- TOC entry 5745 (class 0 OID 0)
-- Dependencies: 530
-- Name: TABLE tamper_switch_logs_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.tamper_switch_logs_default TO armonapi;


--
-- TOC entry 5746 (class 0 OID 0)
-- Dependencies: 531
-- Name: TABLE "terminalAdministrators"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalAdministrators" TO armonapi;


--
-- TOC entry 5747 (class 0 OID 0)
-- Dependencies: 532
-- Name: TABLE "terminalChangeTransactions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalChangeTransactions" TO armonapi;


--
-- TOC entry 5748 (class 0 OID 0)
-- Dependencies: 533
-- Name: TABLE "terminalChanges"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."terminalChanges" TO armonapi;


--
-- TOC entry 5749 (class 0 OID 0)
-- Dependencies: 534
-- Name: TABLE transaction; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.transaction TO armonapi;


--
-- TOC entry 5750 (class 0 OID 0)
-- Dependencies: 535
-- Name: TABLE transaction_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.transaction_default TO armonapi;


--
-- TOC entry 5751 (class 0 OID 0)
-- Dependencies: 536
-- Name: TABLE upload_log_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.upload_log_history TO armonapi;


--
-- TOC entry 5752 (class 0 OID 0)
-- Dependencies: 537
-- Name: TABLE upload_log_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.upload_log_history_default TO armonapi;


--
-- TOC entry 5753 (class 0 OID 0)
-- Dependencies: 538
-- Name: TABLE "userAccessRights"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userAccessRights" TO armonapi;


--
-- TOC entry 5754 (class 0 OID 0)
-- Dependencies: 539
-- Name: TABLE "userGroupAccessRuleSets"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroupAccessRuleSets" TO armonapi;


--
-- TOC entry 5755 (class 0 OID 0)
-- Dependencies: 540
-- Name: TABLE "userGroupUserOrganizations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroupUserOrganizations" TO armonapi;


--
-- TOC entry 5756 (class 0 OID 0)
-- Dependencies: 541
-- Name: TABLE "userGroups"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userGroups" TO armonapi;


--
-- TOC entry 5757 (class 0 OID 0)
-- Dependencies: 542
-- Name: TABLE "userOrganizationCredentials"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationCredentials" TO armonapi;


--
-- TOC entry 5758 (class 0 OID 0)
-- Dependencies: 543
-- Name: TABLE "userOrganizationDeputies"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationDeputies" TO armonapi;


--
-- TOC entry 5759 (class 0 OID 0)
-- Dependencies: 544
-- Name: TABLE "userOrganizationForbiddances"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationForbiddances" TO armonapi;


--
-- TOC entry 5760 (class 0 OID 0)
-- Dependencies: 545
-- Name: TABLE "userOrganizationLeaves"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationLeaves" TO armonapi;


--
-- TOC entry 5761 (class 0 OID 0)
-- Dependencies: 546
-- Name: TABLE "userOrganizationOrganizationUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationOrganizationUnits" TO armonapi;


--
-- TOC entry 5762 (class 0 OID 0)
-- Dependencies: 547
-- Name: TABLE "userOrganizationProfilePhotos"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationProfilePhotos" TO armonapi;


--
-- TOC entry 5763 (class 0 OID 0)
-- Dependencies: 548
-- Name: TABLE "userOrganizationProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationProfiles" TO armonapi;


--
-- TOC entry 5764 (class 0 OID 0)
-- Dependencies: 549
-- Name: TABLE "userOrganizationSettings"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationSettings" TO armonapi;


--
-- TOC entry 5765 (class 0 OID 0)
-- Dependencies: 550
-- Name: TABLE "userOrganizationVisitorProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationVisitorProfiles" TO armonapi;


--
-- TOC entry 5766 (class 0 OID 0)
-- Dependencies: 551
-- Name: TABLE "userOrganizationVisits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizationVisits" TO armonapi;


--
-- TOC entry 5767 (class 0 OID 0)
-- Dependencies: 552
-- Name: TABLE "userOrganizations"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userOrganizations" TO armonapi;


--
-- TOC entry 5768 (class 0 OID 0)
-- Dependencies: 553
-- Name: TABLE "userPPermissionApprovements"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userPPermissionApprovements" TO armonapi;


--
-- TOC entry 5769 (class 0 OID 0)
-- Dependencies: 554
-- Name: TABLE "userPPermissions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userPPermissions" TO armonapi;


--
-- TOC entry 5770 (class 0 OID 0)
-- Dependencies: 555
-- Name: TABLE "userProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userProfiles" TO armonapi;


--
-- TOC entry 5771 (class 0 OID 0)
-- Dependencies: 556
-- Name: TABLE "userRegionTicketUnits"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userRegionTicketUnits" TO armonapi;


--
-- TOC entry 5772 (class 0 OID 0)
-- Dependencies: 557
-- Name: TABLE "userSelectionSessionActions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userSelectionSessionActions" TO armonapi;


--
-- TOC entry 5773 (class 0 OID 0)
-- Dependencies: 558
-- Name: TABLE "userSelectionSessions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userSelectionSessions" TO armonapi;


--
-- TOC entry 5774 (class 0 OID 0)
-- Dependencies: 559
-- Name: TABLE "userWorkPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."userWorkPlans" TO armonapi;


--
-- TOC entry 5775 (class 0 OID 0)
-- Dependencies: 560
-- Name: TABLE user_action_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_action_history TO armonapi;


--
-- TOC entry 5776 (class 0 OID 0)
-- Dependencies: 561
-- Name: TABLE user_action_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_action_history_default TO armonapi;


--
-- TOC entry 5777 (class 0 OID 0)
-- Dependencies: 562
-- Name: TABLE user_filter; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter TO armonapi;


--
-- TOC entry 5778 (class 0 OID 0)
-- Dependencies: 563
-- Name: TABLE user_filter_group; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_group TO armonapi;


--
-- TOC entry 5779 (class 0 OID 0)
-- Dependencies: 564
-- Name: TABLE user_filter_organization_role; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_organization_role TO armonapi;


--
-- TOC entry 5780 (class 0 OID 0)
-- Dependencies: 565
-- Name: TABLE user_filter_unit; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_unit TO armonapi;


--
-- TOC entry 5781 (class 0 OID 0)
-- Dependencies: 566
-- Name: TABLE user_filter_unit_role; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_unit_role TO armonapi;


--
-- TOC entry 5782 (class 0 OID 0)
-- Dependencies: 567
-- Name: TABLE user_filter_user; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_user TO armonapi;


--
-- TOC entry 5783 (class 0 OID 0)
-- Dependencies: 568
-- Name: TABLE user_filter_work_plan; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_filter_work_plan TO armonapi;


--
-- TOC entry 5784 (class 0 OID 0)
-- Dependencies: 569
-- Name: TABLE user_monthly_summary_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_monthly_summary_history TO armonapi;


--
-- TOC entry 5785 (class 0 OID 0)
-- Dependencies: 570
-- Name: TABLE user_monthly_summary_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_monthly_summary_history_default TO armonapi;


--
-- TOC entry 5786 (class 0 OID 0)
-- Dependencies: 571
-- Name: TABLE user_ticket_transaction_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_ticket_transaction_history TO armonapi;


--
-- TOC entry 5787 (class 0 OID 0)
-- Dependencies: 572
-- Name: TABLE user_ticket_transaction_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.user_ticket_transaction_history_default TO armonapi;


--
-- TOC entry 5788 (class 0 OID 0)
-- Dependencies: 573
-- Name: TABLE users; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.users TO armonapi;


--
-- TOC entry 5789 (class 0 OID 0)
-- Dependencies: 574
-- Name: TABLE "vW_CredentialUserProfiles"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_CredentialUserProfiles" TO armonapi;


--
-- TOC entry 5790 (class 0 OID 0)
-- Dependencies: 575
-- Name: TABLE "vW_SearchPPermissions"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_SearchPPermissions" TO armonapi;


--
-- TOC entry 5791 (class 0 OID 0)
-- Dependencies: 576
-- Name: TABLE "vW_UserOrganizationUnitHierarchys"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_UserOrganizationUnitHierarchys" TO armonapi;


--
-- TOC entry 5792 (class 0 OID 0)
-- Dependencies: 577
-- Name: TABLE "vW_UserHierarchys"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_UserHierarchys" TO armonapi;


--
-- TOC entry 5793 (class 0 OID 0)
-- Dependencies: 578
-- Name: TABLE "workPlanPeriods"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlanPeriods" TO armonapi;


--
-- TOC entry 5794 (class 0 OID 0)
-- Dependencies: 579
-- Name: TABLE "workPlans"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlans" TO armonapi;


--
-- TOC entry 5795 (class 0 OID 0)
-- Dependencies: 580
-- Name: TABLE "vW_WorkPlanPeriodTstzrange"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."vW_WorkPlanPeriodTstzrange" TO armonapi;


--
-- TOC entry 5796 (class 0 OID 0)
-- Dependencies: 581
-- Name: TABLE vacations; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.vacations TO armonapi;


--
-- TOC entry 5797 (class 0 OID 0)
-- Dependencies: 582
-- Name: TABLE visit_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visit_history TO armonapi;


--
-- TOC entry 5798 (class 0 OID 0)
-- Dependencies: 583
-- Name: TABLE visit_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visit_history_default TO armonapi;


--
-- TOC entry 5799 (class 0 OID 0)
-- Dependencies: 584
-- Name: TABLE "visitorDailySummaries"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorDailySummaries" TO armonapi;


--
-- TOC entry 5800 (class 0 OID 0)
-- Dependencies: 585
-- Name: TABLE "visitorRegistrationPointAccessControlPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorRegistrationPointAccessControlPoints" TO armonapi;


--
-- TOC entry 5801 (class 0 OID 0)
-- Dependencies: 586
-- Name: TABLE "visitorRegistrationPoints"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."visitorRegistrationPoints" TO armonapi;


--
-- TOC entry 5802 (class 0 OID 0)
-- Dependencies: 587
-- Name: TABLE visitor_preregistration_history; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visitor_preregistration_history TO armonapi;


--
-- TOC entry 5803 (class 0 OID 0)
-- Dependencies: 588
-- Name: TABLE visitor_preregistration_history_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.visitor_preregistration_history_default TO armonapi;


--
-- TOC entry 5804 (class 0 OID 0)
-- Dependencies: 589
-- Name: TABLE vw_user_filter; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.vw_user_filter TO armonapi;


--
-- TOC entry 5805 (class 0 OID 0)
-- Dependencies: 590
-- Name: TABLE "workPlanNotifications"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workPlanNotifications" TO armonapi;


--
-- TOC entry 5806 (class 0 OID 0)
-- Dependencies: 591
-- Name: TABLE "workingHoursScheduleUnrestricteds"; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization."workingHoursScheduleUnrestricteds" TO armonapi;


--
-- TOC entry 5807 (class 0 OID 0)
-- Dependencies: 592
-- Name: TABLE zz_notification; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification TO armonapi;


--
-- TOC entry 5808 (class 0 OID 0)
-- Dependencies: 593
-- Name: TABLE zz_notification_access; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_access TO armonapi;


--
-- TOC entry 5809 (class 0 OID 0)
-- Dependencies: 594
-- Name: TABLE zz_notification_access_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_access_default TO armonapi;


--
-- TOC entry 5810 (class 0 OID 0)
-- Dependencies: 595
-- Name: TABLE zz_notification_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_default TO armonapi;


--
-- TOC entry 5811 (class 0 OID 0)
-- Dependencies: 596
-- Name: TABLE zz_notification_sensor; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_sensor TO armonapi;


--
-- TOC entry 5812 (class 0 OID 0)
-- Dependencies: 597
-- Name: TABLE zz_notification_sensor_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_notification_sensor_default TO armonapi;


--
-- TOC entry 5813 (class 0 OID 0)
-- Dependencies: 598
-- Name: TABLE zz_pacs_notification_scheduled_job; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_pacs_notification_scheduled_job TO armonapi;


--
-- TOC entry 5814 (class 0 OID 0)
-- Dependencies: 599
-- Name: TABLE zz_pacs_notification_scheduled_job_default; Type: ACL; Schema: organization; Owner: armonsuper
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE organization.zz_pacs_notification_scheduled_job_default TO armonapi;


--
-- TOC entry 3494 (class 826 OID 12265828)
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON SEQUENCES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT SELECT ON SEQUENCES  TO armonapi;


--
-- TOC entry 3495 (class 826 OID 12265829)
-- Name: DEFAULT PRIVILEGES FOR FUNCTIONS; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON FUNCTIONS  FROM PUBLIC;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON FUNCTIONS  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT ALL ON FUNCTIONS  TO armonapi;


--
-- TOC entry 3493 (class 826 OID 12265827)
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: organization; Owner: armonsuper
--

ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization REVOKE ALL ON TABLES  FROM armonsuper;
ALTER DEFAULT PRIVILEGES FOR ROLE armonsuper IN SCHEMA organization GRANT SELECT,INSERT,DELETE,UPDATE ON TABLES  TO armonapi;

--
-- TOC entry 6349 (class 0 OID 11922270)
-- Dependencies: 1022
-- Data for Name: migration; Type: TABLE DATA; Schema: public; Owner: armonapi
--

INSERT INTO public.migration (name, "migratedAt") VALUES ('20210101.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210121.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210125.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210203.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210210.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210211.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210212.js', now());
INSERT INTO public.migration (name, "migratedAt") VALUES ('20210213.js', now());

-- Completed on 2021-02-08 11:00:43

--
-- PostgreSQL database dump complete
--