"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startTimeServer = void 0;
const app_logs_1 = require("./app.logs");
const util_1 = require("util");
function startTimeServer(localNtpPort, remoteNtpServerDomain, remoteNtpServerPort) {
    var dgram = require("dgram");
    var server = dgram.createSocket("udp4");
    var dns = require("dns");
    var time_server_domain = remoteNtpServerDomain;
    var time_diff = 0;
    var client_pool = [];
    var time_server_ip = "";
    var prev_checktime = 0;
    var ttl = 10000;
    server.on("message", function (msg, rinfo) {
        if (time_server_domain) {
            var serverMessageHandler = function () {
                app_logs_1.logger.debug("[app.timeServer.ts] " + ["  message from ", rinfo.address, ":", rinfo.port].join(""));
                if (rinfo.address != time_server_ip) {
                    app_logs_1.logger.debug("[app.timeServer.ts]" + rinfo.address + " is different with " + time_server_ip);
                    client_pool.push({
                        address: rinfo.address,
                        port: rinfo.port,
                    });
                    server.send(msg, 0, msg.length, remoteNtpServerPort || 123, time_server_ip, function (err, bytes) {
                        if (err)
                            throw err;
                        app_logs_1.logger.debug("[app.timeServer.ts] Ask to sent to " + time_server_domain);
                    });
                }
                else {
                    let noFail = true;
                    try {
                        var time_standard = msg.readUInt32BE(32);
                        msg.writeUInt32BE(time_standard + time_diff, msg.length - 16);
                        msg.writeUInt32BE(time_standard + time_diff, msg.length - 8);
                    }
                    catch (err) {
                        app_logs_1.logger.error(err);
                        app_logs_1.logger.error("Extra info: " + client_pool[0].address + ":" + client_pool[0].port + " msg: " + (msg && (0, util_1.isObject)(msg) ? JSON.stringify(msg) : "undefined"));
                        noFail = false;
                    }
                    if (noFail) {
                        while (client_pool.length != 0) {
                            (function (to_ip, to_port) {
                                server.send(msg, 0, msg.length, to_port, to_ip, function (err, bytes) {
                                    if (err)
                                        throw err;
                                    app_logs_1.logger.debug("[app.timeServer.ts] Net server proxied response to " + rinfo.address + ":" + rinfo.port);
                                });
                            })(client_pool[0].address, client_pool[0].port);
                            client_pool.splice(0, 1);
                        }
                    }
                }
            };
            if (prev_checktime + ttl < new Date().getTime()) {
                console.log("\n\nTTL Expired " + prev_checktime + " " + new Date().getTime() + ". Relookup " + time_server_domain);
                dns.lookup(time_server_domain, 4, function (err, ip, ipv) {
                    if (err) {
                        app_logs_1.logger.error("[app.timeServer.ts] Error in DNS Lookup " + err);
                        return;
                    }
                    time_server_ip = ip;
                    prev_checktime = new Date().getTime();
                    app_logs_1.logger.debug("[app.timeServer.ts] Prev Checktime is " + prev_checktime + "Got ip address: " + ip);
                    serverMessageHandler();
                });
            }
            else {
                serverMessageHandler();
            }
        }
        else {
            var milliseconds = new Date().valueOf() / 1000 + 2208988800;
            if (msg.length == 48) {
                var time_standard = msg.readUInt32BE(32);
                msg.writeUInt32BE(time_standard + milliseconds, msg.length - 16);
                msg.writeUInt32BE(time_standard + milliseconds, msg.length - 8);
                server.send(msg, 0, msg.length, rinfo.port, rinfo.address, function (err, bytes) {
                    if (err) {
                        app_logs_1.logger.error(err);
                        throw err;
                    }
                });
            }
            else {
                app_logs_1.logger.debug(`[app.timeServer.ts] msg length: ${msg.length} from ${rinfo.address}:${rinfo.port}`);
            }
        }
    });
    server.on("listening", function () {
        var address = server.address();
        app_logs_1.logger.debug("[app.timeServer.ts] NTP Server Listening " +
            address.address +
            ":" +
            address.port +
            (remoteNtpServerDomain ? " via proxy " + remoteNtpServerPort + ":" + (remoteNtpServerPort || 123) : ""));
    });
    server.bind(localNtpPort || 123);
}
exports.startTimeServer = startTimeServer;
