"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.permissions = void 0;
class Permissions {
    constructor() {
        this.considerPermissions = considerPermissions;
    }
}
exports.permissions = new Permissions();
function considerPermissions(permissions) {
    var claim = compileClaim.apply(null, arguments);
    Object.defineProperty(claim, "isPermitted", { value: isPermitted });
    Object.defineProperty(claim, "findMissingPermissions", { value: findMissingPermissions });
    Object.defineProperty(claim, "findPresentPermissions", { value: findPresentPermissions });
    return claim;
}
function coalescePermissions() {
    var permissions = [], i;
    for (i = 0; i < arguments.length; i++) {
        if (arguments[i] != null && arguments[i] != undefined) {
            permissions = permissions.concat(arguments[i]);
        }
    }
    return permissions;
}
function isPermitted() {
    var permissions = coalescePermissions.apply(null, arguments);
    if (permissions.length == 0)
        return false;
    for (var i = 0; i < permissions.length; i++) {
        if (!this.test(permissions[i]))
            return false;
    }
    return true;
}
function findPresentPermissions() {
    var permissions = coalescePermissions.apply(null, arguments);
    let presentPermissions = [];
    if (permissions.length == 0)
        return [];
    for (var i = 0; i < permissions.length; i++) {
        let arr = this.exec(permissions[i]);
        if (arr !== null) {
            presentPermissions.push(permissions[i]);
        }
    }
    return presentPermissions;
}
function findMissingPermissions() {
    var permissions = coalescePermissions.apply(null, arguments);
    let missingPermissions = [];
    if (permissions.length == 0)
        return [];
    for (var i = 0; i < permissions.length; i++) {
        let arr = this.exec(permissions[i]);
        if (arr === null) {
            missingPermissions.push(permissions[i]);
        }
    }
    return missingPermissions;
}
function compileClaim() {
    var permissions = coalescePermissions.apply(null, arguments);
    if (permissions.length == 0)
        return new RegExp("$false^");
    function compilePermission(permission) {
        permission = permission.replace(/(\:\*)+$/, "");
        return permission.split(":").map(function (part) {
            var list = part.split(",").map(function (part) {
                return compilePart(part);
            });
            switch (list.length) {
                case 0: return "";
                case 1: return list[0];
                default: return "(" + list.join("|") + ")";
            }
        }).join(":");
    }
    function compilePart(part) {
        var special = "\\^$*+?.()|{}[]";
        var exp = [];
        for (var i = 0; i < part.length; ++i) {
            var c = part.charAt(i);
            if (c == '?') {
                exp.push("[^:]");
            }
            else if (c == '*') {
                exp.push("[^:]*");
            }
            else {
                if (special.indexOf(c) >= 0) {
                    exp.push("\\");
                }
                exp.push(c);
            }
        }
        return exp.join("");
    }
    var statements = [];
    for (var i = 0; i < permissions.length; i++) {
        statements.push(compilePermission(permissions[i]));
    }
    var result = statements.join("|");
    if (statements.length > 1)
        result = "(" + result + ")";
    return new RegExp("^" + result + "(\\:.*)*$");
}
