"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.invokeMiddleware = void 0;
const lodash_1 = __importDefault(require("lodash"));
const q_1 = __importDefault(require("q"));
async function invokeMiddleware(middlewares, request, response) {
    var promise = lodash_1.default
        .flattenDeep([middlewares])
        .reduce((chain, handler) => {
        if (handler.length === 4) {
            var tail = chain.catch((error) => {
                return invokeHandler(handler, [request, response, error]);
            });
        }
        else if (handler.length === 3) {
            var tail = chain.then(() => {
                return invokeHandler(handler, [request, response]);
            });
        }
        else {
            var tail = chain;
        }
        return tail;
    }, q_1.default.when());
    return promise;
    function invokeHandler(handler, handlerArgs) {
        var deferred = q_1.default.defer();
        handler.call(null, ...handlerArgs, deferred.makeNodeResolver());
        return deferred.promise;
    }
}
exports.invokeMiddleware = invokeMiddleware;
