"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileSystem = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const api_error_1 = require("./api/api.error");
const app_config_1 = require("./app.config");
const app_enums_1 = require("./app.enums");
const app_logs_1 = require("./app.logs");
class FileSystem {
    constructor() { }
    deleteFile(oid, photoName) {
        try {
            fs_1.default.unlinkSync(path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid, photoName));
        }
        catch (err) {
            app_logs_1.logger.info("photo deleted : %s", photoName);
            return Promise.reject((0, api_error_1.generateApiError)({
                code: app_enums_1.enums.ArmonApiErrorCode.UNHANDLED_ERROR,
                message: "Error while deleting file",
            }));
        }
        return Promise.resolve(true);
    }
    addFile(oid, photoName, photo) {
        const sep = path_1.default.sep;
        let targetDir = path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid);
        const initDir = path_1.default.isAbsolute(targetDir) ? sep : "";
        targetDir.split(sep).reduce((parentDir, childDir) => {
            const curDir = path_1.default.resolve(parentDir, childDir);
            if (!fs_1.default.existsSync(curDir)) {
                fs_1.default.mkdirSync(curDir);
            }
            return curDir;
        }, initDir);
        try {
            fs_1.default.writeFileSync(path_1.default.resolve(targetDir, photoName), photo.buffer);
        }
        catch (err) {
            return Promise.reject((0, api_error_1.generateApiError)({
                code: app_enums_1.enums.ArmonApiErrorCode.UNHANDLED_ERROR,
                message: "Error while saving file",
            }));
        }
        return Promise.resolve(true);
    }
    getFileData(oid, photoName, encoding) {
        if (fs_1.default.existsSync(path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid, photoName))) {
            let data = fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid, photoName), encoding);
            return Promise.resolve(data);
        }
        else {
            return Promise.resolve(null);
        }
    }
    getReadStream(oid, photoName) {
        if (fs_1.default.existsSync(path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid, photoName))) {
            let stream = fs_1.default.createReadStream(path_1.default.join(app_config_1.appConfig.organizationalFileStorageDirectory, oid, photoName));
            return Promise.resolve(stream);
        }
        else {
            return Promise.resolve(null);
        }
    }
}
exports.fileSystem = new FileSystem();
