"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.appExtensions = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const app_logs_1 = require("./app.logs");
const app_config_1 = require("./app.config");
const app_constants_1 = require("./app.constants");
class AppExtensionManager {
    constructor() {
        this.onPreDalReady = async (dbConfig) => {
            if (this._onPreDalReady) {
                try {
                    await this._onPreDalReady(dbConfig);
                }
                catch (error) {
                    app_logs_1.logger.error(error);
                    return Promise.reject(error);
                }
            }
            else {
                return Promise.resolve();
            }
        };
        this.onHttpRequest = (req, res, next) => {
            if (this._onHttpRequest) {
                try {
                    this._onHttpRequest(req, res, next);
                }
                catch (error) {
                    app_logs_1.logger.warn(error);
                    next();
                }
            }
            else {
                next();
            }
        };
    }
    init() {
        try {
            app_logs_1.logger.info("server based hook initializing");
            let serverBasedHookScriptsFilePath = path_1.default.join(app_config_1.appConfig.serverBasedHookDirectory, app_constants_1.constFileNames.serverBasedHookScriptsFileName);
            app_logs_1.logger.info("server based hook file path " + serverBasedHookScriptsFilePath);
            if (fs_1.default.existsSync(serverBasedHookScriptsFilePath)) {
                let h = require(serverBasedHookScriptsFilePath);
                if (h.onHttpRequest) {
                    app_logs_1.logger.info("onHttpRequest binded");
                    this._onHttpRequest = h.onHttpRequest;
                }
                if (h.onPreDalReady) {
                    app_logs_1.logger.info("onPreDalReady binded");
                    this._onPreDalReady = h.onPreDalReady;
                    this.onPreDalReady.bind(this);
                }
                if (h.addCustomEndPoints) {
                    app_logs_1.logger.info("addCustomEndPoints binded");
                    this._addCustomEndpoints = h.addCustomEndPoints;
                }
            }
            else {
                app_logs_1.logger.info("no server based scripts file not found");
            }
        }
        catch (error) {
            app_logs_1.logger.error(error);
            process.exit(1);
        }
    }
    addCustomEndPoints(app) {
        if (this._addCustomEndpoints) {
            this._addCustomEndpoints(app);
        }
    }
}
exports.appExtensions = new AppExtensionManager();
