"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestVisitorApiV1 = void 0;
const luxon_1 = require("luxon");
const moment_1 = __importDefault(require("moment"));
const app_enums_1 = require("../../../app.enums");
const dal_access_error_1 = require("../../../dal/access/dal.access.error");
const dal_access_models_1 = require("../../../dal/access/dal.access.models");
const dal_constants_1 = require("../../../dal/dal.constants");
const business_visitor_1 = require("../../../business/visitor/business.visitor");
var RestVisitorApiV1;
(function (RestVisitorApiV1) {
    class ListUnterminatedVisitorsRequestFilter {
    }
    RestVisitorApiV1.ListUnterminatedVisitorsRequestFilter = ListUnterminatedVisitorsRequestFilter;
    class SelfListUnterminatedVisitorsRequest {
        constructor(raw, validator, settings) {
            if (raw.sortField && raw.sortField !== "startUtc") {
                let sortFieldValid = false;
                for (const field of settings.visitFormFields) {
                    if (field.reportable && field.name === raw.sortField) {
                        sortFieldValid = true;
                        this.sortVisitFormField = field;
                        break;
                    }
                }
                if (!sortFieldValid) {
                    for (const field of settings.visitorProfileFormFields) {
                        if (field.reportable && field.name === raw.sortField) {
                            sortFieldValid = true;
                            this.sortProfileFormField = field;
                            break;
                        }
                    }
                }
                if (!sortFieldValid) {
                    validator.addFieldNotFoundError(raw.sortField, "Sortfield is not found");
                }
            }
            if (raw.filter && raw.filter.profileFields && raw.filter.profileFields.length > 0) {
                let field = null;
                for (const profileFilterField of raw.filter.profileFields) {
                    for (const profileField of settings.visitorProfileFormFields) {
                        if (profileField.reportable && profileField.name === profileFilterField.name) {
                            field = profileField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(profileFilterField.name, "The field, " + profileFilterField.name + " is not found or it is not reportable");
                    }
                    else {
                        validator.validateFormFieldValue(profileFilterField.value, field);
                    }
                }
            }
            if (raw.filter && raw.filter.visitFields && raw.filter.visitFields.length > 0) {
                let field = null;
                for (const visitFilterField of raw.filter.visitFields) {
                    for (const visitField of settings.visitFormFields) {
                        if (visitField.reportable && visitField.name === visitFilterField.name) {
                            field = visitField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(visitFilterField.name, "The field, " + visitFilterField.name + " is not found or it is not reportable");
                    }
                    else {
                        validator.validateFormFieldValue(visitFilterField.value, field);
                    }
                }
            }
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.sortField = raw.sortField;
            this.sortAscending = raw.sortAscending === true;
            this.filter = !raw.filter
                ? null
                : {
                    profileFields: raw.filter.profileFields.map((f) => {
                        return {
                            name: f.name,
                            value: f.value,
                        };
                    }),
                    visitFields: raw.filter.visitFields.map((f) => {
                        return {
                            name: f.name,
                            value: f.value,
                        };
                    }),
                    state: raw.filter.state,
                };
        }
    }
    RestVisitorApiV1.SelfListUnterminatedVisitorsRequest = SelfListUnterminatedVisitorsRequest;
    class ListUnterminatedVisitorsRequest {
        constructor(raw, validator, settings) {
            if (raw.sortField && raw.sortField !== "startUtc") {
                let sortFieldValid = false;
                for (const field of settings.visitFormFields) {
                    if (field.reportable && field.name === raw.sortField) {
                        sortFieldValid = true;
                        this.sortVisitFormField = field;
                        break;
                    }
                }
                if (!sortFieldValid) {
                    for (const field of settings.visitorProfileFormFields) {
                        if (field.reportable && field.name === raw.sortField) {
                            sortFieldValid = true;
                            this.sortProfileFormField = field;
                            break;
                        }
                    }
                }
                if (!sortFieldValid) {
                    validator.addFieldNotFoundError(raw.sortField, "Sortfield is not found");
                }
            }
            if (raw.filter && raw.filter.profileFields && raw.filter.profileFields.length > 0) {
                let field = null;
                for (const profileFilterField of raw.filter.profileFields) {
                    for (const profileField of settings.visitorProfileFormFields) {
                        if (profileField.reportable && profileField.name === profileFilterField.name) {
                            field = profileField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(profileFilterField.name, "The field, " + profileFilterField.name + " is not found or it is not reportable");
                    }
                }
            }
            if (raw.filter && raw.filter.visitFields && raw.filter.visitFields.length > 0) {
                let field = null;
                for (const visitFilterField of raw.filter.visitFields) {
                    for (const visitField of settings.visitFormFields) {
                        if (visitField.reportable && visitField.name === visitFilterField.name) {
                            field = visitField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(visitFilterField.name, "The field, " + visitFilterField.name + " is not found or it is not reportable");
                    }
                }
            }
            if (raw.filter) {
                validator.validateUUID("visitorRegistrationPointId", false, raw.filter.visitorRegistrationPointId);
            }
            validator.finalize();
            this.visitorRegistrationPointId = !raw.filter ? null : raw.filter.visitorRegistrationPointId;
            this.take = raw.take;
            this.skip = raw.skip;
            this.sortField = raw.sortField;
            this.sortAscending = raw.sortAscending === true;
            this.filter = !raw.filter
                ? null
                : {
                    profileFields: raw.filter.profileFields.map((f) => {
                        return {
                            name: f.name,
                            value: f.value,
                        };
                    }),
                    visitFields: raw.filter.visitFields.map((f) => {
                        return {
                            name: f.name,
                            value: f.value,
                        };
                    }),
                    state: raw.filter.state,
                };
        }
    }
    RestVisitorApiV1.ListUnterminatedVisitorsRequest = ListUnterminatedVisitorsRequest;
    class ListUnterminatedVisitsResponseItem {
    }
    RestVisitorApiV1.ListUnterminatedVisitsResponseItem = ListUnterminatedVisitsResponseItem;
    class FieldSearchRequest {
        isTextFieldIsSearchField(textField) {
            return true;
        }
        isSelectFieldIsSearchField(selectField) {
            return true;
        }
        constructor(raw, validator, settings) {
            for (const field of settings) {
                if (field.name === raw.fieldName) {
                    switch (field.type) {
                        case app_enums_1.enums.FormFieldType.Text:
                            if (this.isTextFieldIsSearchField(field)) {
                                this.formField = field;
                            }
                            break;
                        case app_enums_1.enums.FormFieldType.Select:
                            if (this.isSelectFieldIsSearchField(field)) {
                                this.formField = field;
                            }
                            break;
                        case app_enums_1.enums.FormFieldType.Number:
                            this.formField = field;
                            break;
                        default:
                            break;
                    }
                    if (this.formField) {
                        break;
                    }
                }
            }
            if (!this.formField) {
                validator.addFieldNotFoundError(raw.fieldName, "The field, " + raw.fieldName + " is not found or it is not a search field");
            }
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.fieldName = raw.fieldName;
            this.filter = raw.filter;
        }
    }
    RestVisitorApiV1.FieldSearchRequest = FieldSearchRequest;
    class FormSearchRequest {
        constructor(raw, validator, forProfile, settings) {
            this.fields = [];
            if (raw.fields && raw.fields.length > 0) {
                let formFields = forProfile ? settings.visitorProfileFormFields : settings.visitFormFields;
                for (const field of raw.fields) {
                    let mappedField = null;
                    for (const formField of formFields) {
                        if (formField.reportable && formField.name === field.fieldName) {
                            mappedField = formField;
                            break;
                        }
                    }
                    if (!mappedField) {
                        validator.addFieldNotFoundError(field.fieldName, "The field, " + field.fieldName + " is not found or it is not reportable");
                    }
                    else {
                        validator.validateFormFieldValue(field.filter, field);
                        this.fields.push({
                            fieldName: field.fieldName,
                            filter: field.filter,
                            formField: mappedField,
                        });
                    }
                }
            }
            else {
                validator.addArrayMustNotBeEmptyError("fields");
            }
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
        }
    }
    RestVisitorApiV1.FormSearchRequest = FormSearchRequest;
    class GenericSearchRequest {
        constructor(raw) {
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
        }
    }
    RestVisitorApiV1.GenericSearchRequest = GenericSearchRequest;
    class VisitorProfileListRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("visitorProfileIds", false, raw.visitorProfileIds);
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.visitorProfileIds = raw.visitorProfileIds;
            this.state = raw.state;
        }
    }
    RestVisitorApiV1.VisitorProfileListRequest = VisitorProfileListRequest;
    class GenericSearchRequestWithVisitState {
        constructor(raw) {
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
            this.state = raw.state;
        }
    }
    RestVisitorApiV1.GenericSearchRequestWithVisitState = GenericSearchRequestWithVisitState;
    class UpsertPreregisteredVisitRequest {
        constructor(raw, validator, settings) {
            validator.validateUUID("visitId", true, raw.visitId);
            validator.validateUUID("visitorProfileId", true, raw.visitorProfileId);
            this.visitId = raw.visitId;
            this.force = raw.force ?? false;
            if (!raw.visitorProfileFields && !raw.visitorProfileId) {
                validator.errors.push({
                    code: app_enums_1.enums.ValidationErrorCode.REQUIRED,
                    fields: ["visitorProfileFields", "visitorProfileId"],
                    message: "At least one them is required",
                });
            }
            else {
                if (raw.visitorProfileFields) {
                    let fields = raw.visitorProfileFields;
                    if (fields && fields.length > 0) {
                        for (const field of fields) {
                            let settingsField = null;
                            for (const profileField of settings.visitorProfileFormFields) {
                                if (profileField.name === field.name) {
                                    settingsField = profileField;
                                    break;
                                }
                            }
                            if (!settingsField) {
                                validator.addFieldNotFoundError(field.name, "The field, " + field.name + " is not found");
                            }
                            else {
                                if (field.preRegistrationFieldSettings) {
                                    settingsField.required = field.preRegistrationFieldSettings.required;
                                }
                                else {
                                    settingsField.required = false;
                                }
                                validator.validateFormFieldValue(field.value, settingsField);
                            }
                        }
                    }
                }
                for (const field of raw.visitFields) {
                    let settingsField = null;
                    for (const visitField of settings.visitFormFields) {
                        if (visitField.name === field.name) {
                            settingsField = visitField;
                            break;
                        }
                    }
                    if (!settingsField) {
                        validator.addFieldNotFoundError(field.name, "The field, " + field.name + " is not found");
                    }
                    else {
                        if (field.preRegistrationFieldSettings) {
                            settingsField.required = field.preRegistrationFieldSettings.required;
                        }
                        else {
                            settingsField.required = false;
                        }
                        validator.validateFormFieldValue(field.value, settingsField);
                    }
                }
            }
            validator.finalize();
            this.visitorProfileId = raw.visitorProfileId;
            if (raw.visitorProfileFields) {
                transformFields(raw.visitorProfileFields, settings.visitorProfileFormFields);
                this.visitorProfileFields = raw.visitorProfileFields.map((t) => {
                    return {
                        name: t.name,
                        value: t.value,
                    };
                });
            }
            transformFields(raw.visitFields, settings.visitFormFields);
            this.visitFields = raw.visitFields.map((t) => {
                return {
                    name: t.name,
                    value: t.value,
                };
            });
            const visitFormFields = settings.visitFormFields.find((f) => f.name == dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate);
            if (visitFormFields) {
                const dateRangeFormFieldOpts = visitFormFields.options;
                let expectedDate = this.visitFields.find((f) => f.name == dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate);
                if (!expectedDate) {
                    validator.addFieldNotFoundError(dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate, "The field, " + dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate + " is not found");
                }
                if (dateRangeFormFieldOpts.maxStartDynamicDate && dateRangeFormFieldOpts.maxStartDynamicDate === dal_constants_1.DalConstants.DateDynamicValue.EndOfDayAfterFiveDays) {
                    const maxStartOfPreRegistrationDay = luxon_1.DateTime.now().startOf("day").plus({ days: 5 }).setZone("UTC").toString();
                    if (expectedDate.value.startDate > maxStartOfPreRegistrationDay) {
                        validator.addRangeError([dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate], "The field, " + dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate + " range can not be bigger than : 5 days");
                    }
                }
            }
            if (settings.maxExpectedDayCount && settings.maxExpectedDayCount > 0) {
                let expectedDate = this.visitFields.find((f) => f.name == dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate);
                if (!expectedDate)
                    validator.addFieldNotFoundError(dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate, "The field, " + dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate + " is not found");
                else {
                    let dateRange = expectedDate.value;
                    if (!dateRange.startDate) {
                        validator.addFieldNotFoundError("expectedStartDate", "The field expectedStartDate is not found");
                    }
                    if (!dateRange.endDate) {
                        validator.addFieldNotFoundError("expectedEndDate", "The field expectedEndDate is not found");
                    }
                    let diff = Math.abs((0, moment_1.default)(dateRange.startDate).diff(dateRange.endDate, "day"));
                    if (diff < settings.maxExpectedDayCount) {
                        validator.addRangeError([dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate], "The field, " + dal_access_models_1.DbAccessModel.PredefinedVisitFormFields.expectedDate + " range can not be less than :" + settings.maxExpectedDayCount + " days");
                    }
                }
            }
        }
    }
    RestVisitorApiV1.UpsertPreregisteredVisitRequest = UpsertPreregisteredVisitRequest;
    function transformFields(nameValuePair, fields) {
        for (const field of fields) {
            let nvp = nameValuePair.find((t) => t.name == field.name);
            if (nvp && nvp.value) {
                nvp.value = transformText(nvp.value, field);
            }
        }
    }
    RestVisitorApiV1.transformFields = transformFields;
    function transformText(fieldValue, field) {
        if (!(field.type == app_enums_1.enums.FormFieldType.Text || field.type == app_enums_1.enums.FormFieldType.Textarea)) {
            return fieldValue;
        }
        let options = field.options;
        if (options.textTransform && options.textTransform != app_enums_1.enums.TextFormFieldTypeTransform.Default) {
            switch (options.textTransform) {
                case app_enums_1.enums.TextFormFieldTypeTransform.LowerCase:
                    return fieldValue.toLocaleLowerCase();
                case app_enums_1.enums.TextFormFieldTypeTransform.UpperCase:
                    return fieldValue.toLocaleUpperCase();
                case app_enums_1.enums.TextFormFieldTypeTransform.TitleCase:
                    return fieldValue
                        .split(" ")
                        .map((w) => w[0].toLocaleUpperCase() + w.substr(1).toLocaleLowerCase())
                        .join(" ");
                case app_enums_1.enums.TextFormFieldTypeTransform.Default:
                default:
                    return fieldValue;
            }
        }
        return fieldValue;
    }
    RestVisitorApiV1.transformText = transformText;
    class NewVisitRequest {
        constructor(raw, validator, settings) {
            validator.validateUUID("visitorProfileId", true, raw.visitorProfileId);
            validator.validateUUID("replacedVisitorProfileId", true, raw.replacedVisitorProfileId);
            validator.validateUUID("visitId", true, raw.visitId);
            validator.validateUUID("visitorRegistrationPointId", true, raw.visitorRegistrationPointId);
            if (!raw.visitorProfileFields && !raw.visitorProfileId) {
                validator.errors.push({
                    code: app_enums_1.enums.ValidationErrorCode.REQUIRED,
                    fields: ["visitorProfileFields", "visitorProfileId"],
                    message: "At least one them is required",
                });
            }
            else {
                if (raw.visitorProfileFields) {
                    let fields = raw.visitorProfileFields;
                    if (fields && fields.length > 0) {
                        for (const field of fields) {
                            let settingsField = null;
                            for (const profileField of settings.visitorProfileFormFields) {
                                if (profileField.name === field.name) {
                                    settingsField = profileField;
                                    break;
                                }
                            }
                            if (!settingsField) {
                                validator.addFieldNotFoundError(field.name, "The field, " + field.name + " is not found");
                            }
                            else {
                                validator.validateFormFieldValue(field.value, settingsField);
                            }
                        }
                    }
                }
                for (const field of raw.visitFields) {
                    let settingsField = null;
                    for (const visitField of settings.visitFormFields) {
                        if (visitField.name === field.name) {
                            settingsField = visitField;
                            break;
                        }
                    }
                    if (!settingsField) {
                        validator.addFieldNotFoundError(field.name, "The field, " + field.name + " is not found");
                    }
                    else {
                        validator.validateFormFieldValue(field.value, settingsField);
                    }
                }
            }
            const acpIdsRequired = (0, business_visitor_1.isAccessControlPointIdsRequired)(settings);
            if (raw.accessControlPointIds && raw.accessControlPointIds.length) {
                validator.validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds);
            }
            else if (acpIdsRequired) {
                validator.errors.push(validator.generateRequiredError("accessControlPointIds"));
            }
            const credentialsRequired = (0, business_visitor_1.isCredentialsRequired)(settings);
            if (raw.credentials && raw.credentials.length) {
                for (const credential of raw.credentials) {
                    validator
                        .validateEnum("credential.type", false, app_enums_1.enums.CredentialType, credential.type)
                        .validateString({
                        field: "credential.data",
                        optional: false,
                        input: credential.data,
                        minLength: 3,
                        maxLength: 1023,
                    })
                        .validateString({
                        field: "credential.credentialNumber",
                        optional: true,
                        input: credential.credentialNumber,
                        maxLength: 31,
                    })
                        .validateDate("credential.expirationUtc", true, credential.expirationUtc);
                }
            }
            else if (credentialsRequired) {
                validator.errors.push(validator.generateRequiredError("credentials"));
            }
            this.force = raw.force ?? false;
            this.visitorRegistrationPointId = raw.visitorRegistrationPointId;
            this.visitId = raw.visitId;
            this.visitorProfileId = raw.visitorProfileId;
            this.replacedVisitorProfileId = raw.replacedVisitorProfileId;
            if (!this.visitorProfileId && raw.replacedVisitorProfileId) {
                validator.errors.push({
                    code: app_enums_1.enums.ValidationErrorCode.INVALID_TYPE,
                    fields: ["visitorProfileId", "replacedVisitorProfileId"],
                    message: "Replaced visitor profile id must come with visitor profile id",
                });
            }
            if (raw.visitorProfileFields) {
                transformFields(raw.visitorProfileFields, settings.visitorProfileFormFields);
                this.visitorProfileFields = raw.visitorProfileFields.map((t) => {
                    return {
                        name: t.name,
                        value: t.value,
                    };
                });
            }
            validator.finalize();
            this.accessControlPointIds = raw.accessControlPointIds
                ? Array.from(new Set(raw.accessControlPointIds))
                : null;
            this.credentials = !raw.credentials
                ? null
                : raw.credentials.map((t) => {
                    return {
                        type: t.type,
                        data: t.data,
                        number: t.number,
                        expirationUtc: t.expirationUtc,
                    };
                });
            this.processTime = raw.processTime;
            transformFields(raw.visitFields, settings.visitFormFields);
            this.visitFields = raw.visitFields.map((t) => {
                return {
                    name: t.name,
                    value: t.value,
                };
            });
        }
    }
    RestVisitorApiV1.NewVisitRequest = NewVisitRequest;
    class UpsertVisitorProfileRequest {
        constructor(raw, validator, settings) {
            validator.validateUUID("id", true, raw.id);
            let fields = raw.fields;
            if (fields && fields.length > 0) {
                for (const field of fields) {
                    let settingsField = null;
                    for (const profileField of settings.visitorProfileFormFields) {
                        if (profileField.name === field.name) {
                            settingsField = profileField;
                            break;
                        }
                    }
                    if (!settingsField) {
                        validator.addFieldNotFoundError(field.name, "The field, " + field.name + " is not found");
                    }
                    else {
                        validator.validateFormFieldValue(field.value, settingsField);
                    }
                }
            }
            validator.finalize();
            transformFields(raw.fields, settings.visitorProfileFormFields);
            this.id = raw.id;
            this.fields = raw.fields.map((t) => {
                return {
                    name: t.name,
                    value: t.value,
                };
            });
        }
    }
    RestVisitorApiV1.UpsertVisitorProfileRequest = UpsertVisitorProfileRequest;
    class ListTerminatedVisitsAsExcelRequest {
        constructor(raw, validator, settings, sensitiveFieldSettings) {
            validator.validateUUID("visitorRegistrationPointId", true, raw.visitorRegistrationPointId);
            if (raw.visitorProfileFilterFields && raw.visitorProfileFilterFields.length > 0) {
                let field = null;
                for (const visitorProfileFilterField of raw.visitorProfileFilterFields) {
                    for (const settingsField of settings.visitorProfileFormFields) {
                        if (settingsField.reportable && settingsField.name === visitorProfileFilterField.name) {
                            field = settingsField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(visitorProfileFilterField.name, "The field, " + visitorProfileFilterField.name + " is not found or it is not reportable");
                    }
                }
            }
            if (raw.visitFilterFields && raw.visitFilterFields.length > 0) {
                let field = null;
                for (const visitFilterField of raw.visitFilterFields) {
                    for (const visitField of settings.visitFormFields) {
                        if (visitField.reportable && visitField.name === visitFilterField.name) {
                            field = visitField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(visitFilterField.name, "The field, " + visitFilterField.name + " is not found or it is not reportable");
                    }
                }
            }
            validator.finalize();
            this.visitorRegistrationPointId = raw.visitorRegistrationPointId;
            this.sortStartUtcAsc = raw.sortStartUtcAsc === true;
            this.startUtc = raw.startUtc ? new Date(raw.startUtc) : null;
            this.endUtc = raw.endUtc ? new Date(raw.endUtc) : null;
            this.visitorProfileIds = raw.visitorProfileIds;
            this.type = raw.type || app_enums_1.enums.ListVisitState.All;
            this.visitorProfileFilterFields = !raw.visitorProfileFilterFields
                ? null
                : raw.visitorProfileFilterFields.map((f) => {
                    return {
                        name: f.name,
                        value: f.value,
                    };
                });
            this.visitFilterFields = !raw.visitFilterFields
                ? null
                : raw.visitFilterFields.map((f) => {
                    return {
                        name: f.name,
                        value: f.value,
                    };
                });
            this.sensitiveFields = sensitiveFieldSettings
                ? {
                    visitFields: sensitiveFieldSettings.visitFields,
                    visitorFields: sensitiveFieldSettings.visitorFields,
                    hideUniqueIdForVisitor: sensitiveFieldSettings.hideUniqueIdForVisitor,
                    showNumberOfInitial: sensitiveFieldSettings.showNumberOfInitial,
                    showNumberOfLast: sensitiveFieldSettings.showNumberOfLast,
                }
                : null;
        }
    }
    RestVisitorApiV1.ListTerminatedVisitsAsExcelRequest = ListTerminatedVisitsAsExcelRequest;
    class ListTerminatedVisitsRequest extends ListTerminatedVisitsAsExcelRequest {
        constructor(raw, validator, settings) {
            super(raw, validator, settings);
            this.take = raw.take;
            this.skip = raw.skip;
        }
    }
    RestVisitorApiV1.ListTerminatedVisitsRequest = ListTerminatedVisitsRequest;
    class ListTerminatedVisitsResponseItem {
    }
    RestVisitorApiV1.ListTerminatedVisitsResponseItem = ListTerminatedVisitsResponseItem;
    class FindActiveVisitByUniqueFieldRequest {
        constructor(raw, validator, settings) {
            this.name = raw.nameValuePair.name;
            this.value = raw.nameValuePair.value;
            this.visitorRegistrationPointId = raw.visitorRegistrationPointId;
            let field = settings.visitFormFields.find((f) => f.name === this.name);
            if (!field) {
                validator.addFieldNotFoundError(this.name, "The field, " + this.name + " is not found");
            }
            else if (!field.unique) {
                validator.addFieldMustBeUniqueFieldError(this.name);
            }
            validator.validateFormFieldValue(this.value, field);
            validator.validateUUID("visitorRegistrationPointId", true, raw.visitorRegistrationPointId);
            validator.finalize();
        }
    }
    RestVisitorApiV1.FindActiveVisitByUniqueFieldRequest = FindActiveVisitByUniqueFieldRequest;
    class UpsertVisitorRegistrationPointRequest {
        constructor(raw, validator) {
            validator.validateUUID("id", true, raw.id);
            validator.validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds);
            validator.finalize();
            this.accessControlPointIds = raw.accessControlPointIds;
            this.id = raw.id;
            this.name = raw.name;
        }
    }
    RestVisitorApiV1.UpsertVisitorRegistrationPointRequest = UpsertVisitorRegistrationPointRequest;
    class ListVisitorRegistrationPointRequest {
        constructor(raw, validator) {
            this.pagination = {
                take: raw.take,
                skip: raw.skip,
            };
            this.filter = raw.filter;
        }
    }
    RestVisitorApiV1.ListVisitorRegistrationPointRequest = ListVisitorRegistrationPointRequest;
    class UpsertBlackListInfo {
        constructor(raw, validator) {
            validator.validateDate("startUtc", false, raw.startUtc);
            validator.validateDate("endUtc", true, raw.endUtc);
            validator.finalize();
            this.note = raw.note;
            this.startUtc = raw.startUtc;
            this.endUtc = raw.endUtc;
        }
    }
    RestVisitorApiV1.UpsertBlackListInfo = UpsertBlackListInfo;
    class UpsertTemporalPermissionInfo {
        constructor(raw, validator) {
            validator.validateDate("startUtc", false, raw.startUtc);
            validator.validateDate("endUtc", true, raw.endUtc);
            validator.finalize();
            this.note = raw.note;
            this.startUtc = raw.startUtc;
            this.endUtc = raw.endUtc;
        }
    }
    RestVisitorApiV1.UpsertTemporalPermissionInfo = UpsertTemporalPermissionInfo;
    class ListVisitorsRequestBase {
        constructor(raw, validator, settings, sensitiveFieldSettings) {
            if (raw.visitorProfileFilterFields && raw.visitorProfileFilterFields.length > 0) {
                let field = null;
                for (const visitorProfileFilterField of raw.visitorProfileFilterFields) {
                    for (const settingsField of settings.visitorProfileFormFields) {
                        if (settingsField.reportable && settingsField.name === visitorProfileFilterField.name) {
                            field = settingsField;
                            break;
                        }
                    }
                    if (!field) {
                        validator.addFieldNotFoundError(visitorProfileFilterField.name, "The field, " + visitorProfileFilterField.name + " is not found or it is not reportable");
                    }
                }
            }
            this.visitorProfileId = raw.visitorProfileId;
            this.visitorProfileFilterFields = !raw.visitorProfileFilterFields
                ? null
                : raw.visitorProfileFilterFields.map((f) => {
                    return {
                        name: f.name,
                        value: f.value,
                    };
                });
            this.showOnlyBlacklist = raw.showOnlyBlacklist;
            this.showOnlyTemporaryPermitted = raw.showOnlyTemporaryPermitted;
            this.sensitiveFields = sensitiveFieldSettings ?? null;
        }
    }
    RestVisitorApiV1.ListVisitorsRequestBase = ListVisitorsRequestBase;
    class ListVisitorsRequestApi extends ListVisitorsRequestBase {
        constructor(raw, validator, settings, sensitiveFieldSettings) {
            super(raw, validator, settings, sensitiveFieldSettings);
            validator.validateUUID("visitorProfileId", true, raw.visitorProfileId).validatePaginationRequest("pagination", { take: raw.take, skip: raw.skip }, false, 200).finalize();
            this.take = raw.take;
            this.skip = raw.skip;
        }
    }
    RestVisitorApiV1.ListVisitorsRequestApi = ListVisitorsRequestApi;
    class VisitorDashboardInfoRequest {
        constructor(raw, validator) {
            validator.validateUUID("visitorRegistrationPointId", true, raw.visitorRegistrationPointId);
            validator.validateDate("date", false, raw.date);
            validator.finalize();
            this.date = raw.date;
            this.visitorRegistrationPointId = raw.visitorRegistrationPointId;
        }
    }
    RestVisitorApiV1.VisitorDashboardInfoRequest = VisitorDashboardInfoRequest;
    class VisitAnalysisFilter {
        constructor(raw, validator) {
            validator.validateUUID("visitorRegistrationPointId", true, raw.visitorRegistrationPointId);
            validator.validateDate("startDate", false, raw.startDate);
            validator.validateDate("endDate", false, raw.endDate);
            validator.finalize();
            this.startDate = new Date(raw.startDate);
            this.endDate = new Date(raw.endDate);
            this.visitorRegistrationPointId = raw.visitorRegistrationPointId;
            this.reason = raw.reason;
            this.segmentType = raw.segmentType;
            let days = Math.abs((0, moment_1.default)(this.startDate).diff(this.endDate, "day"));
            switch (this.segmentType) {
                case app_enums_1.enums.SegmentType.Day:
                    if (days > 31)
                        (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)("ERRORS.GENERAL.DAYRANGEERROR", { day: 30 });
                    break;
                case app_enums_1.enums.SegmentType.Week:
                    if (days > 180)
                        (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)("ERRORS.GENERAL.WEEKRANGEERROR", { week: 26 });
                    break;
                case app_enums_1.enums.SegmentType.Month:
                    if (days > 360)
                        (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)("ERRORS.GENERAL.MONTHRANGEERROR", { month: 12 });
                    break;
                default:
                    break;
            }
        }
    }
    RestVisitorApiV1.VisitAnalysisFilter = VisitAnalysisFilter;
    class VisitAnalysisGenericFilter {
        constructor(raw, validator) {
            validator.validateEnum("filterType", false, app_enums_1.enums.VisitAnalysisVisitCountGenericFilterType, raw.filterType);
            if (raw.filterType === app_enums_1.enums.VisitAnalysisVisitCountGenericFilterType.ByVisitedPersonId || raw.filterType === app_enums_1.enums.VisitAnalysisVisitCountGenericFilterType.ByVisitorId) {
                validator.validateUUID("filterValue", true, raw.filterValue);
            }
            validator.validateDate("startDay", true, raw.startDay);
            validator.validateDate("endDay", true, raw.endDay);
            validator.finalize();
            this.pagination = {
                take: raw.pagination.take,
                skip: raw.pagination.skip,
            };
            this.filterType = raw.filterType;
            this.filterValue = raw.filterValue ? raw.filterValue : null;
            this.startDay = raw.startDay ? new Date(raw.startDay) : null;
            this.endDay = raw.endDay ? new Date(raw.endDay) : null;
        }
    }
    RestVisitorApiV1.VisitAnalysisGenericFilter = VisitAnalysisGenericFilter;
})(RestVisitorApiV1 = exports.RestVisitorApiV1 || (exports.RestVisitorApiV1 = {}));
