"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateAcpUserFilterMappingsRequestSchema = exports.UpdateUserFilterAcpMappingsRequestSchema = exports.UserFilterResultRequestSchema = exports.ListUserFilterByIdsRequestSchema = exports.ListUserFilterRequestSchema = exports.SearchUserFilterRequestSchema = exports.UserFilterV2Schema = exports.UserFilterV2SchemaBasic = exports.PaginationRequestSchema = void 0;
const joi_1 = __importDefault(require("joi"));
const restapi_1 = require("../../../../lib/es/models/restapi");
const UserFilterCombinatorSchema = joi_1.default.string().valid(...Object.values(restapi_1.UserFilterCombinator));
const UserFilterUsageTypeSchema = joi_1.default.string().valid(...Object.values(restapi_1.UserFilterUsageType));
const UserFilterSettingsBaseSchema = joi_1.default.object({
    roleIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
    userIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
    groupIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
    workPlanIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
});
const UserFilterSettingsSchema = UserFilterSettingsBaseSchema.keys({
    units: joi_1.default.array()
        .items(joi_1.default.object({
        id: joi_1.default.string().uuid().required(),
        roleIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
        hierarchically: joi_1.default.boolean().optional(),
    }))
        .unique("id")
        .optional(),
});
const ListUserFilterSettingsSchema = UserFilterSettingsBaseSchema.keys({
    unitIds: joi_1.default.array().items(joi_1.default.string().uuid()).optional(),
});
exports.PaginationRequestSchema = joi_1.default.object({
    take: joi_1.default.number().default(20).required(),
    skip: joi_1.default.number().default(0).required(),
});
exports.UserFilterV2SchemaBasic = joi_1.default.object({
    id: joi_1.default.string().uuid().optional(),
    name: joi_1.default.string().min(3).max(255).optional(),
    description: joi_1.default.string().optional(),
    combinator: UserFilterCombinatorSchema.required(),
    allIncluded: joi_1.default.boolean().required(),
    settings: UserFilterSettingsSchema.optional(),
});
exports.UserFilterV2Schema = exports.UserFilterV2SchemaBasic.append({
    usageType: UserFilterUsageTypeSchema.required(),
});
exports.SearchUserFilterRequestSchema = joi_1.default.object({
    name: joi_1.default.string().optional(),
    usageType: UserFilterUsageTypeSchema.optional(),
    pagination: exports.PaginationRequestSchema.required(),
});
exports.ListUserFilterRequestSchema = joi_1.default.object({
    pagination: exports.PaginationRequestSchema.required(),
    name: joi_1.default.string().optional(),
    description: joi_1.default.string().optional(),
    usageType: joi_1.default.array().items(UserFilterUsageTypeSchema).optional(),
    allIncluded: joi_1.default.boolean().optional(),
    settings: ListUserFilterSettingsSchema.optional(),
});
exports.ListUserFilterByIdsRequestSchema = joi_1.default.object({
    pagination: exports.PaginationRequestSchema.required(),
    ids: joi_1.default.array().items(joi_1.default.string().uuid()).required(),
});
exports.UserFilterResultRequestSchema = joi_1.default.object({
    pagination: exports.PaginationRequestSchema.required(),
    userFilter: exports.UserFilterV2SchemaBasic.append({
        usageType: UserFilterUsageTypeSchema.optional(),
    }).required(),
});
exports.UpdateUserFilterAcpMappingsRequestSchema = joi_1.default.object({
    items: joi_1.default.array()
        .items(joi_1.default.object({
        id: joi_1.default.string().uuid().required(),
        read: joi_1.default.boolean().required(),
        access: joi_1.default.boolean().required(),
        remoteAccess: joi_1.default.boolean().required(),
        grant: joi_1.default.boolean().required(),
        config: joi_1.default.boolean().required(),
        snapshot: joi_1.default.boolean().required(),
    }))
        .required(),
});
exports.UpdateAcpUserFilterMappingsRequestSchema = exports.UpdateUserFilterAcpMappingsRequestSchema;
