"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
const predefined_permissions_1 = require("../../../../dal/db/predefined/predefined.permissions");
const messageBroker_server_to_app_pub_1 = require("../../../../messageBroker/messageBroker.server-to-app.pub");
const ws_usernsp_1 = require("../../../../ws/ws.usernsp");
const messageBroker_server_to_app_sub_1 = require("../../../../messageBroker/messageBroker.server-to-app.sub");
const dal_access_psql_organization_1 = require("../../../../dal/access/psql/dal.access.psql.organization");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const api_error_1 = require("../../../api.error");
const app_enums_1 = require("../../../../app.enums");
module.exports.listRoles = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let roles = await dal_manager_1.dbManager.accessUser.listRolesOfOrganization(organizationId);
    res.json({
        items: roles,
    });
});
module.exports.updateRole = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let roleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "roleId");
    let jwt = (0, api_securityhelper_1.authorizeForWriteRole)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.UpdateRoleRequest(req.body);
    let dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessUser.updateRole(organizationId, roleId, request.name, request.permissions, trx);
    }, jwt.userId, organizationId);
    await messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(organizationId + "." + ws_usernsp_1.room.systemStatus + ".*", {
        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.organizationroleschanged,
        p: {},
    });
    res.json(dbResult);
});
module.exports.updateTypedRole = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let roleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "roleId");
    let jwt = (0, api_securityhelper_1.authorizeForWriteRole)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.UpdateTypedRoleRequest(req.body);
    let dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessUser.updateTypedRole(organizationId, roleId, request.permissions, trx);
    }, jwt.userId, organizationId);
    await messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(organizationId + "." + ws_usernsp_1.room.systemStatus + ".*", {
        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.organizationroleschanged,
        p: {},
    });
    res.json(dbResult);
});
module.exports.removeRole = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let roleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "roleId");
    let transferRoleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.tid.value, "transferRoleId");
    let jwt = (0, api_securityhelper_1.authorizeForWriteRole)(req, organizationId);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        const isUserFilterAccessRightActivated = await (0, dal_access_psql_organization_1.getOrganizationUserFilterAccessRightActivationStatus)(organizationId, trx);
        if (isUserFilterAccessRightActivated) {
            const userFilters = (await trx.query(`
						SELECT uf.*
						FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilter}" uf
						LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilterOrganizationRole}" as ufor
							ON uf.id = ufor."filterId"
						LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilterUnitRole}" ufur
							ON uf.id = ufur."filterId"
						WHERE (ufor."roleId" =  $1 OR ufur."roleId" = $1)
							AND (ufor."filterId" IS NOT NULL OR ufur."filterId" IS NOT NULL)
						`, [roleId])).rows;
            if (userFilters.length > 0) {
                throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.USER_FILTER.USER_FILTER_USAGE_ROLE", { userFilterNames: userFilters.map((elem) => elem.name).join(", ") }, true, true);
            }
        }
        return dal_manager_1.dbManager.accessUser.removeRole(organizationId, roleId, transferRoleId, trx);
    }, jwt.userId, organizationId);
    await messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(organizationId + "." + ws_usernsp_1.room.systemStatus + ".*", {
        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.organizationroleschanged,
        p: {},
    });
    res.json({});
});
module.exports.addRole = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let jwt = (0, api_securityhelper_1.authorizeForWriteRole)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.AddRoleRequest(req.body);
    if (request.permissions.indexOf(predefined_permissions_1.Permissions.user.getUser()) < 0) {
        request.permissions.push(predefined_permissions_1.Permissions.user.getUser());
    }
    let dbResult = await dal_manager_1.dbManager.accessUser.addRole(organizationId, request);
    await messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(organizationId + "." + ws_usernsp_1.room.systemStatus + ".*", {
        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.organizationroleschanged,
        p: {},
    });
    res.json(dbResult);
});
