"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const i18n_1 = __importDefault(require("i18n"));
const app_enums_1 = require("../../../../app.enums");
const business_common_1 = require("../../../../business/business.common");
const dal_access_error_1 = require("../../../../dal/access/dal.access.error");
const dal_manager_1 = require("../../../../dal/dal.manager");
const predefined_permissions_1 = require("../../../../dal/db/predefined/predefined.permissions");
const api_error_1 = require("../../../api.error");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
const dal_access_psql_organization_1 = require("../../../../dal/access/psql/dal.access.psql.organization");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
module.exports.getOrganizationUnitsAtRootLevel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = new api_validatorhelper_1.ValidatorHelper().validateUUIDAndFinalize("organizationId", false, req.swagger.params.oid.value);
    const { userId } = (0, api_securityhelper_1.authorizeForGetOrganizationUnitsInOrganizationWide)(req, organizationId);
    const organizationUnitsAtRootLevel = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitsAtRootLevel({ organizationId, trx });
    }, userId, organizationId);
    res.json(organizationUnitsAtRootLevel
        ? organizationUnitsAtRootLevel.map((o) => {
            return {
                id: o.id,
                name: o.name,
                ancestorIds: o.ancestorIds,
                typeDefinition: o.typeDefinition,
                typeId: o.typeId,
                manager: o.manager,
                shortCode: o.shortCode,
            };
        })
        : {});
});
module.exports.getDetailedOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let ids = new api_validatorhelper_1.ValidatorHelper().validateUUIDsAndFinalize([
        { field: "organizationId", optional: false, input: req.swagger.params.oid.value },
        { field: "organizationUnitId", optional: false, input: req.swagger.params.id.value },
    ]);
    let authResult = (0, api_securityhelper_1.authorizeForGetDetailedOrganizationUnit)(req, ids.organizationId);
    let unit = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitDetailed(ids.organizationId, ids.organizationUnitId, authResult.hasOrganizationWide, authResult.jwt.userId);
    res.json({
        id: unit.id,
        name: unit.name,
        typeId: unit.typeId,
        typeDefinition: unit.typeDefinition,
        dynamicFormData: unit.dynamicFormData,
        parent: !unit.parent
            ? undefined
            : {
                id: unit.parent.id,
                name: unit.parent.name,
                typeId: unit.parent.typeId,
                typeDefinition: unit.parent.typeDefinition,
                parentId: unit.parent.parentId,
                dynamicFormData: unit.dynamicFormData,
                ancestorIds: unit.parent.ancestorIds,
                shortCode: unit.parent.shortCode,
            },
        ancestorIds: unit.ancestorIds,
        shortCode: unit.shortCode,
        defaultAccessControlPoints: unit.defaultAccessControlPoints.map((acp) => {
            return {
                id: acp.id,
                name: acp.name,
                location: acp.location,
                remoteAvailable: acp.remoteAvailable,
                isRemoteDefault: acp.isRemoteDefault,
                type: acp.type,
                managable: acp.managable,
                defaultPrivileges: acp.defaultPrivileges,
            };
        }),
        manager: unit.manager,
        deputy: unit.deputy,
        deputyStartDateTime: unit.deputyStartDateTime,
        deputyEndDateTime: unit.deputyEndDateTime,
    });
});
module.exports.changeDefaultAccessControlPoints = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let request = new api_user_v1_models_1.RestUserApiV1.OrganizationUnitDefaultAccessControlPointChanges(req.body, new api_validatorhelper_1.ValidatorHelper().validateUUID("organizationId", false, req.swagger.params.oid.value).validateUUID("organizationUnitId", false, req.swagger.params.id.value));
    let organizationId = req.swagger.params.oid.value;
    let organizationUnitId = req.swagger.params.id.value;
    let authResult = (0, api_securityhelper_1.authorizeForChangeOrganizationUnitDefaultAccessControlPoints)(req, organizationId, request.applyToMembers);
    await dal_manager_1.dbManager.accessOrganizationUnit.changeOrganizationUnitDefaultAccessControlPoints(organizationId, organizationUnitId, request.addedAccessControlPoints, request.removedAccessControlPointIds, request.applyToMembers, request.applyHierarchically, authResult.hasOrganizationWide, authResult.jwt.userId);
    res.json({});
});
module.exports.genericSearchOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForReadOrganizationUnitBasic)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.GenericSearchRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessOrganizationUnit.genericSearchOrganizationUnit(organizationId, {
        take: request.take,
        skip: request.skip,
        filter: request.filter,
    }, authResult.permittedUnitIds);
    res.json({
        total: dbResult.total,
        take: request.take,
        skip: request.skip,
        items: dbResult.items.map((t) => {
            return {
                id: t.id,
                captionLines: t.captionLines,
                matchItem: t.matchItem,
            };
        }),
    });
});
module.exports.listOrganizationUnits = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForReadOrganizationUnitBasic)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.ListOrganizationUnitsRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessOrganizationUnit.listOrganizationUnits(organizationId, {
        take: request.take,
        skip: request.skip,
        organizationUnitIds: request.organizationUnitIds,
    });
    res.json({
        total: dbResult.total,
        take: request.take,
        skip: request.skip,
        items: dbResult.items.map((t) => {
            return {
                id: t.id,
                captionLines: t.captionLines,
            };
        }),
    });
});
module.exports.getOrganizationUnitBasic = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const organizationUnitId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "organizationUnitId");
    const authResult = (0, api_securityhelper_1.authorizeForReadOrganizationUnitBasic)(req, organizationId);
    const organizationUnitBasic = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitBasic({ organizationId, organizationUnitId, trx });
    }, authResult.jwt.userId, organizationId);
    res.json(organizationUnitBasic);
});
module.exports.upsertOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForOrganizationUnitWrite)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.UpsertOrganizationUnit(req.body, new api_validatorhelper_1.ValidatorHelper());
    const formValidation = await business_common_1.BusinessCommon.validateDynamicForm({
        organizationId: organizationId,
        dynamicFormId: request.dynamicFormId,
        dynamicFormData: request.dynamicFormData,
    });
    if (formValidation?.length > 0) {
        let errors = "Error(s): ";
        for (const err of formValidation) {
            errors += err.message;
        }
        (0, dal_access_error_1.throwDbAccessConflictError)(errors);
    }
    const dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessOrganizationUnit.upsertOrganizationUnit(organizationId, authResult.jwt.userId, {
            id: request.id,
            typeId: request.typeId,
            name: request.name,
            shortCode: request.shortCode,
            parentId: request.parentId,
            managerUserId: request.managerUserId,
            dynamicFormData: request.dynamicFormData,
        }, trx);
    }, authResult.jwt.userId, organizationId);
    res.json({
        id: dbResult,
    });
});
module.exports.getChildrenOfOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const ids = new api_validatorhelper_1.ValidatorHelper().validateUUIDsAndFinalize([
        { field: "organizationId", optional: false, input: req.swagger.params.oid.value },
        { field: "organizationUnitId", optional: false, input: req.swagger.params.id.value },
    ]);
    const authResult = (0, api_securityhelper_1.authorizeForGetChildrenOfOrganizationUnit)(req, ids.organizationId);
    const dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessOrganizationUnit.getChildrenOfOrganizationUnit({ organizationId: ids.organizationId, organizationUnitId: ids.organizationUnitId, trx });
    }, authResult.jwt.userId, ids.organizationId);
    res.json(dbResult
        ? dbResult.map((o) => {
            return {
                id: o.id,
                name: o.name,
                ancestorIds: o.ancestorIds,
                typeId: o.typeId,
                typeDefinition: o.typeDefinition,
                manager: o.manager,
                shortCode: o.shortCode,
            };
        })
        : {});
});
module.exports.getSiblingsOfOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let ids = new api_validatorhelper_1.ValidatorHelper().validateUUIDsAndFinalize([
        { field: "organizationId", optional: false, input: req.swagger.params.oid.value },
        { field: "organizationUnitId", optional: false, input: req.swagger.params.id.value },
    ]);
    let authResult = (0, api_securityhelper_1.authorizeForGetOrganizationUnitsInOrganizationWide)(req, ids.organizationId);
    let dbResult = await dal_manager_1.dbManager.accessOrganizationUnit.getSiblingsOfOrganizationUnit(ids.organizationId, ids.organizationUnitId);
    res.json({
        self: {
            id: dbResult.id,
            name: dbResult.name,
            typeId: dbResult.typeId,
            typeDefinition: dbResult.typeDefinition,
            ancestorIds: dbResult.ancestorIds,
            parentId: dbResult.parentId,
            manager: dbResult.manager
                ? {
                    id: dbResult.manager.id,
                    fullname: dbResult.manager.fullname,
                    uniqueId: dbResult.manager.uniqueId,
                    captionLines: dbResult.manager.captionLines,
                }
                : {},
            deputy: dbResult.deputy
                ? {
                    id: dbResult.deputy.id,
                    fullname: dbResult.deputy.fullname,
                    uniqueId: dbResult.deputy.uniqueId,
                    captionLines: dbResult.deputy.captionLines,
                }
                : {},
            deputyStartDateTime: dbResult.deputyStartDateTime,
            deputyEndDateTime: dbResult.deputyEndDateTime,
        },
        ancestors: dbResult.ancestors.map((a) => {
            return {
                id: a.id,
                name: a.name,
                typeId: a.typeId,
                typeDefinition: a.typeDefinition,
                ancestorIds: a.ancestorIds,
                parentId: a.parentId,
                manager: a.manager
                    ? {
                        id: a.manager.id,
                        fullname: a.manager.fullname,
                        uniqueId: a.manager.uniqueId,
                        captionLines: a.manager.captionLines,
                    }
                    : {},
                deputy: a.deputy
                    ? {
                        id: a.deputy.id,
                        fullname: a.deputy.fullname,
                        uniqueId: a.deputy.uniqueId,
                        captionLines: a.deputy.captionLines,
                    }
                    : {},
                deputyStartDateTime: a.deputyStartDateTime,
                deputyEndDateTime: a.deputyEndDateTime,
            };
        }),
        siblings: dbResult.siblings.map((s) => {
            return {
                id: s.id,
                name: s.name,
                ancestorIds: s.ancestorIds,
                parentId: s.parentId,
                typeId: s.typeId,
                typeDefinition: s.typeDefinition,
                manager: s.manager
                    ? {
                        id: s.manager.id,
                        fullname: s.manager.fullname,
                        uniqueId: s.manager.uniqueId,
                        captionLines: s.manager.captionLines,
                    }
                    : {},
                deputy: s.deputy
                    ? {
                        id: s.deputy.id,
                        fullname: s.deputy.fullname,
                        uniqueId: s.deputy.uniqueId,
                        captionLines: s.deputy.captionLines,
                    }
                    : {},
                deputyStartDateTime: s.deputyStartDateTime,
                deputyEndDateTime: s.deputyEndDateTime,
            };
        }),
    });
});
module.exports.removeOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const organizationUnitId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "organizationUnitId");
    const request = new api_user_v1_models_1.RestUserApiV1.RemoveOrganizationUnitRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const auth = (0, api_securityhelper_1.authorizeForRemoveOrganizationUnit)(req, organizationId, request.action);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        const isUserFilterAccessRightActivated = await (0, dal_access_psql_organization_1.getOrganizationUserFilterAccessRightActivationStatus)(organizationId, trx);
        if (isUserFilterAccessRightActivated) {
            const userFilters = (await trx.query(`
								SELECT uf.*
								FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilter}" uf
								INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilterUnit}" as ufu
									ON uf.id = ufu."filterId"
								WHERE ufu."unitId" = $1
								`, [organizationUnitId])).rows;
            if (userFilters.length > 0) {
                throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.USER_FILTER.USER_FILTER_USAGE_UNIT", { userFilterNames: userFilters.map((elem) => elem.name).join(", ") }, true, true);
            }
        }
        await dal_manager_1.dbManager.accessOrganizationUnit.removeOrganizationUnit(organizationId, organizationUnitId, request.action, auth.jwt.userId, trx);
    }, auth.jwt.userId, organizationId);
    res.json();
});
module.exports.obtainUserSelectionSessionForOrganizationUnitUsers = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const organizationUnitId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "organizationUnitId");
    const force = (0, api_validatorhelper_1.validateIsBoolean)(req.swagger.params.force.value, "force");
    const auth = (0, api_securityhelper_1.authorizeForObtainUserSelectionSessionForUserOrganizationUnit)(req, organizationId, organizationUnitId);
    const userSelectionSession = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        if (!auth.hasOrganizationWide) {
            for (const ouid of auth.permittedOrganizationUnitIds) {
                const successorsOfAuthorizedOrganizationUnits = (await dal_manager_1.dbManager.accessOrganizationUnit.getAllSuccessorOrganizationUnitsBasic(organizationId, [ouid], trx)).map((organizationUnit) => organizationUnit.id);
                auth.permittedOrganizationUnitIds.push(...successorsOfAuthorizedOrganizationUnits);
            }
            if (!auth.permittedOrganizationUnitIds.includes(organizationUnitId)) {
                const requiredPermissions = [predefined_permissions_1.Permissions.organizationUnit.getReadBasic(), predefined_permissions_1.Permissions.identity.getReadBasic(), predefined_permissions_1.Permissions.identity.getHierarchy()];
                const locale = (await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: auth.jwt.userId, trx })).l;
                (0, api_securityhelper_1.throwAuthError)(i18n_1.default.__({ phrase: "ERRORS.AUTH.NOT_AUTH_FOR_UNIT", locale }), requiredPermissions, requiredPermissions);
            }
        }
        return dal_manager_1.dbManager.accessUser.obtainUserSelectionSession(organizationId, {
            requestUserId: auth.jwt.userId,
            type: app_enums_1.enums.UserSelectionSessionType.AddUsersToOrganizationUnit,
            relatedItemId: organizationUnitId,
            forceToCreate: force,
            isAuthorizedForAllUsers: auth.hasOrganizationWide,
            authorizedOrganizationUnitIds: auth.permittedOrganizationUnitIds ?? null,
        }, trx);
    }, auth.jwt.userId, organizationId);
    if (!userSelectionSession.upserted) {
        throw (0, api_error_1.generateConflictError)({
            message: "There is already a session for that organization unit. Please see details.",
            details: userSelectionSession.overwritten,
        });
    }
    const result = {
        sessionId: userSelectionSession.sessionId,
        expirationUtc: userSelectionSession.expirationUtc,
        justRefreshed: userSelectionSession.justRefreshed,
        overwritten: userSelectionSession.overwritten
            ? {
                ownerUserId: userSelectionSession.overwritten.ownerUserId,
                sessionId: userSelectionSession.overwritten.sessionId,
                expirationUtc: userSelectionSession.overwritten.expirationUtc,
                captionLines: userSelectionSession.overwritten.captionLines,
            }
            : undefined,
    };
    res.json(result);
});
module.exports.applyUserSelectionSessionWithUnitRole = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const sessionId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.sid.value, "sessionId");
    const request = new api_user_v1_models_1.RestUserApiV1.ApplyUserSelectionSessionWithUnitRole(req.body, new api_validatorhelper_1.ValidatorHelper());
    const auth = (0, api_securityhelper_1.authorizeForObtainUserSelectionSessionForUserOrganizationUnit)(req, organizationId);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        if (!auth.hasOrganizationWide) {
            const targetSession = await dal_manager_1.dbManager.accessUser.validateUserSelectionSession(organizationId, auth.jwt.userId, sessionId, trx);
            if (!auth.permittedOrganizationUnitIds.includes(targetSession.relatedItemId)) {
                const childsOfAuthorizedOrganizationUnits = (await dal_manager_1.dbManager.accessOrganizationUnit.getAllSuccessorOrganizationUnitsBasic(organizationId, auth.permittedOrganizationUnitIds, trx)).map((organizationUnit) => organizationUnit.id);
                if (!childsOfAuthorizedOrganizationUnits.includes(targetSession.relatedItemId)) {
                    const requiredPermissions = [predefined_permissions_1.Permissions.organizationUnit.getReadBasic(), predefined_permissions_1.Permissions.identity.getReadBasic(), predefined_permissions_1.Permissions.identity.getHierarchy()];
                    const locale = (await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: auth.jwt.userId, trx })).l;
                    (0, api_securityhelper_1.throwAuthError)(i18n_1.default.__({ phrase: "ERRORS.AUTH.NOT_AUTH_FOR_UNIT", locale }), requiredPermissions, requiredPermissions);
                }
            }
        }
        await dal_manager_1.dbManager.accessOrganizationUnit.applyUserSelectionSessionWithOrganizationUnitRoleAndPrivileges(organizationId, auth.jwt.userId, {
            hasOrganizationWideReadDetailedOrganizationUnit: auth.hasOrganizationWide,
            sessionId,
            roleId: request.roleId,
            acpAuthorize: request.acpAuthorize,
            removeDefaultAccessRights: request.removeDefaultAccessRights,
        }, trx);
    }, auth.jwt.userId, organizationId);
    res.json({});
});
