"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
module.exports.upsertCamera = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    let request = new api_user_v1_models_1.RestUserApiV1.UpsertCameraRequest(req.body, new api_validatorhelper_1.ValidatorHelper);
    let dbResult = await dal_manager_1.dbManager.accessCamera.upsertCamera(organizationId, request);
    res.json(dbResult);
});
module.exports.listCameras = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForSystemRead)(req, organizationId);
    let dbResult = await dal_manager_1.dbManager.accessCamera.listCameras(organizationId, {
        take: req.body.take,
        skip: req.body.skip,
        name: req.body.name
    });
    let result = {
        take: dbResult.take,
        skip: dbResult.skip,
        total: dbResult.total,
        items: dbResult.items || []
    };
    res.json(result);
});
module.exports.getCamera = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let cameraId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.cid.value, "cameraId");
    let dbResult = await dal_manager_1.dbManager.accessCamera.getCamera(organizationId, cameraId);
    res.json(dbResult);
});
module.exports.removeCamera = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let cameraId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.cid.value, "cameraId");
    await dal_manager_1.dbManager.accessCamera.removeCamera(organizationId, cameraId);
    res.json();
});
