"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const app_enums_1 = require("../../../../app.enums");
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_user_v1_models_1 = require("../api.user.v1.models");
module.exports.upsertAccessRuleSet = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.AccessRuleSetUpsertRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const accessRuleSet = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.upsertAccessRuleSet({
            organizationId,
            requesterUserId: authResult.userId,
            ruleset: request,
            trx,
        });
    }, authResult.userId, organizationId);
    res.json(accessRuleSet);
});
module.exports.listAccessRuleSet = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.GenericSearchRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const accessRuleSetList = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.listAccessRuleSets({ organizationId, request, requesterUserId: authResult.userId, trx });
    }, authResult.userId, organizationId);
    res.json(accessRuleSetList);
});
module.exports.assignAccessRuleSet = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const accessRuleSetId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.rid.value, "accessRuleSetId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.AccessRuleSetAssignRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessAccessLog.assignUserGroupsToRuleSet({ organizationId, requesterUserId: authResult.userId, accessRuleSetId, userGroupIds: request.userGroupIds, trx });
    }, authResult.userId, organizationId);
    res.json({});
});
module.exports.getAccessRuleSet = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const accessRuleSetId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.rid.value, "accessRuleSetId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const accessRuleSet = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.getAccessRuleSet({ organizationId, requesterUserId: authResult.userId, accessRuleSetId, trx });
    }, authResult.userId, organizationId);
    res.json(accessRuleSet);
});
module.exports.removeAccessRuleSet = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const accessRuleSetId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.rid.value, "accessRuleSetId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.removeAccessRuleSet({ organizationId, requesterUserId: authResult.userId, rulesetId: accessRuleSetId, trx });
    }, authResult.userId, organizationId);
    res.json();
});
module.exports.upsertAccessRule = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const accessRuleSetId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.rid.value, "accessRuleSetId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const request = new api_user_v1_models_1.RestUserApiV1.AccessRuleUpsertRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const accessRule = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.upsertAccessRule({
            organizationId,
            requesterUserId: authResult.userId,
            rule: {
                id: request.id,
                accessRuleSetId: accessRuleSetId,
                type: request.type,
                acceptStatus: request.acceptStatus,
                parameters: request.parameters,
                direction: request.direction,
            },
            trx,
        });
    }, authResult.userId, organizationId);
    res.json(accessRule);
});
module.exports.listAccessRules = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const accessRuleSetId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.rid.value, "accessRuleSetId");
    const auth = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const request = req.body;
    const accessRules = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.listAccessRules({ organizationId, accessRuleSetId, pagination: request, trx });
    }, auth.userId, organizationId);
    for (const ar of accessRules.items) {
        if (ar.type === app_enums_1.enums.AccessRuleType.CapacityBased) {
            ar.parameters = {
                capacityItems: ar.parameters,
            };
        }
    }
    res.json(accessRules);
});
module.exports.getAccessRule = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const ruleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "ruleId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    const accessRule = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessAccessLog.getAccessRule({ organizationId, requesterUserId: authResult.userId, accessRuleId: ruleId, trx });
    }, authResult.userId, organizationId);
    if (accessRule.type === app_enums_1.enums.AccessRuleType.CapacityBased) {
        accessRule.parameters = {
            capacityItems: accessRule.parameters,
        };
    }
    res.json(accessRule);
});
module.exports.removeAccessRule = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const ruleId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.id.value, "ruleId");
    const authResult = (0, api_securityhelper_1.authorizeForWriteSystem)(req, organizationId);
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        await dal_manager_1.dbManager.accessAccessLog.removeAccessRule({ organizationId, requesterUserId: authResult.userId, ruleId, trx });
    }, authResult.userId, organizationId);
    res.json();
});
