"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestUserApiV1 = void 0;
const app_constants_1 = require("../../../app.constants");
const app_enums_1 = require("../../../app.enums");
const dal_access_error_1 = require("../../../dal/access/dal.access.error");
const dal_constants_1 = require("../../../dal/dal.constants");
const restapi_1 = require("../../../lib/es/models/restapi");
const api_error_1 = require("../../api.error");
const api_models_common_1 = require("../../api.models.common");
const api_validatorhelper_1 = require("../../api.validatorhelper");
var RestUserApiV1;
(function (RestUserApiV1) {
    class AccessLogsFilter {
        constructor(raw, validator) {
            validator
                .validateDate("startUtc", true, raw.startUtc)
                .validateDate("endUtc", true, raw.endUtc)
                .validateDateRange(["startUtc", "endUtc"], {
                start: raw.startUtc,
                end: raw.endUtc,
                startOptional: true,
                endOptional: true,
            })
                .validateEnum("accessResult", true, app_enums_1.enums.AccessReportFilterAccessResultType, raw.accessResult)
                .validateEnum("direction", true, app_enums_1.enums.AccessDirection, raw.direction)
                .validateEnumArray("credentialTypes", true, app_enums_1.enums.CredentialType, raw.credentialTypes)
                .validateUUIDArray("organizationUnitIds", true, raw.credentialOwnerIds)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateUUID("manualRecordCreatorUserId", true, raw.manualRecordCreatorUserId)
                .finalize();
            this.startUtc = raw.startUtc ? new Date(raw.startUtc) : null;
            this.endUtc = raw.endUtc ? new Date(raw.endUtc) : null;
            this.userIds = raw.userIds;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.take = raw.take;
            this.skip = raw.skip;
            this.returnTotalCount = raw.returnTotalCount === true;
            this.accessResult = raw.accessResult;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically === true;
            this.userGroupIds = raw.userGroupIds;
            this.sortDateDesc = raw.sortDateDesc === true;
            this.showOnlyVisitors = raw.showOnlyVisitors === true;
            this.direction = raw.direction;
            this.showOnlyRemoteAccess = raw.showOnlyRemoteAccess === true;
            this.showOnlyManuallyInserted = raw.showOnlyManuallyInserted === true;
            this.showOnlyExitButtons = raw.showOnlyExitButtons === true;
            this.reasons = raw.reasons ? raw.reasons : null;
            this.credentialData = raw.credentialData ? raw.credentialData : null;
            this.credentialTypes = raw.credentialTypes && raw.credentialTypes.length > 0 ? raw.credentialTypes : null;
            this.manualRecordCreatorUserId = raw.manualRecordCreatorUserId ? raw.manualRecordCreatorUserId : null;
        }
    }
    RestUserApiV1.AccessLogsFilter = AccessLogsFilter;
    class ArventoAccessLogsFilter {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator
                .validateDate("startUtc", true, raw.startUtc)
                .validateDate("endUtc", true, raw.endUtc)
                .validateDateRange(["startUtc", "endUtc"], {
                start: raw.startUtc,
                end: raw.endUtc,
                startOptional: true,
                endOptional: true,
            })
                .validateUUIDArray("organizationUnitIds", true, raw.credentialOwnerIds)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateString({
                field: "region",
                optional: true,
                input: raw.region,
                minLength: 1,
                maxLength: 255,
            })
                .validateString({
                field: "licencePlate",
                optional: true,
                input: raw.licencePlate,
                minLength: 1,
                maxLength: 255,
            })
                .validateEnum("type", true, restapi_1.ArventoAccessLogType, raw.type)
                .validateIsBoolean("isSynchronized", true, raw.isSynchronized)
                .finalize();
            this.startUtc = raw.startUtc ? new Date(raw.startUtc) : null;
            this.endUtc = raw.endUtc ? new Date(raw.endUtc) : null;
            this.userIds = raw.userIds;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.region = raw.region;
            this.licencePlate = raw.licencePlate;
            this.type = raw.type;
            this.isSynchronized = raw.isSynchronized;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically === true;
            this.userGroupIds = raw.userGroupIds;
        }
    }
    RestUserApiV1.ArventoAccessLogsFilter = ArventoAccessLogsFilter;
    class SensorEventsFilter {
        constructor(raw, validator) {
            this.dateRange = raw.dateRange ? raw.dateRange : null;
            this.sensorIds = raw.sensorIds ? raw.sensorIds : null;
            this.type = raw.type !== null ? raw.type : null;
            this.state = raw.state !== null ? raw.state : null;
            this.reason = raw.reason !== null ? raw.reason : null;
            this.terminalDeviceIds = raw.terminalDeviceIds ? raw.terminalDeviceIds : null;
            this.pagination = null;
        }
    }
    RestUserApiV1.SensorEventsFilter = SensorEventsFilter;
    class AccessControlPointSummaryReportFilter {
        constructor(raw, validator) {
            validator
                .validateObject("startDt", false, raw.startDt, new api_validatorhelper_1.ValidatorHelper()
                .validateInteger({
                field: "startDt.year",
                optional: false,
                input: raw.startDt ? raw.startDt.year : null,
                min: 2000,
                max: 3000,
            })
                .validateInteger({
                field: "startDt.month",
                optional: false,
                input: raw.startDt ? raw.startDt.month : null,
                min: 1,
                max: 12,
            })
                .validateInteger({
                field: "startDt.day",
                optional: false,
                input: raw.startDt ? raw.startDt.day : null,
                min: 1,
                max: 31,
            })
                .validateInteger({
                field: "startDt.hours",
                optional: false,
                input: raw.startDt ? raw.startDt.hours : null,
                min: 0,
                max: 24,
            })
                .validateInteger({
                field: "startDt.minutes",
                optional: false,
                input: raw.startDt ? raw.startDt.minutes : null,
                min: 0,
                max: 59,
            })
                .validateInteger({
                field: "startDt.seconds",
                optional: false,
                input: raw.startDt ? raw.startDt.hours : null,
                min: 0,
                max: 59,
            }))
                .validateObject("endDt", false, raw.endDt, new api_validatorhelper_1.ValidatorHelper()
                .validateInteger({
                field: "endDt.year",
                optional: false,
                input: raw.endDt ? raw.endDt.year : null,
                min: 2000,
                max: 3000,
            })
                .validateInteger({
                field: "endDt.month",
                optional: false,
                input: raw.endDt ? raw.endDt.month : null,
                min: 1,
                max: 12,
            })
                .validateInteger({
                field: "endDt.day",
                optional: false,
                input: raw.endDt ? raw.endDt.day : null,
                min: 1,
                max: 31,
            })
                .validateInteger({
                field: "endDt.hours",
                optional: false,
                input: raw.endDt ? raw.endDt.hours : null,
                min: 0,
                max: 24,
            })
                .validateInteger({
                field: "endDt.minutes",
                optional: false,
                input: raw.endDt ? raw.endDt.minutes : null,
                min: 0,
                max: 59,
            })
                .validateInteger({
                field: "endDt.seconds",
                optional: false,
                input: raw.endDt ? raw.endDt.hours : null,
                min: 0,
                max: 59,
            }))
                .finalize();
            this.startDt = {
                year: raw.startDt.year,
                month: raw.startDt.month,
                day: raw.startDt.day,
                hours: raw.startDt.hours,
                minutes: raw.startDt.minutes,
                seconds: raw.startDt.seconds,
            };
            this.endDt = {
                year: raw.endDt.year,
                month: raw.endDt.month,
                day: raw.endDt.day,
                hours: raw.endDt.hours,
                minutes: raw.endDt.minutes,
                seconds: raw.endDt.seconds,
            };
            this.statusSensorLogs = raw.statusSensorLogs === true;
            this.exitButtonAccessLogs = raw.exitButtonAccessLogs === true;
            this.counterSensorLogs = raw.counterSensorLogs === true;
            this.readerAccessLogs = raw.readerAccessLogs === true;
            this.remoteAccessLogs = raw.remoteAccessLogs === true;
        }
    }
    RestUserApiV1.AccessControlPointSummaryReportFilter = AccessControlPointSummaryReportFilter;
    class VisitorAccessLogsFilter {
        constructor(raw, validator) {
            validator
                .validateDate("startUtc", true, raw.startUtc)
                .validateDate("endUtc", true, raw.endUtc)
                .validateDateRange(["startUtc", "endUtc"], {
                start: raw.startUtc,
                end: raw.endUtc,
                startOptional: true,
                endOptional: true,
            })
                .validateEnum("accessResult", true, app_enums_1.enums.AccessReportFilterAccessResultType, raw.accessResult)
                .validateEnum("direction", true, app_enums_1.enums.AccessDirection, raw.direction)
                .validateEnumArray("credentialTypes", true, app_enums_1.enums.CredentialType, raw.credentialTypes)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validatePaginationRequest("pagination", { take: raw.take, skip: raw.skip }, false, 20)
                .finalize();
            this.startUtc = raw.startUtc ? new Date(raw.startUtc) : null;
            this.endUtc = raw.endUtc ? new Date(raw.endUtc) : null;
            this.userIds = raw.userIds;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.take = raw.take;
            this.skip = raw.skip;
            this.returnTotalCount = raw.returnTotalCount === true;
            this.accessResult = raw.accessResult;
            this.sortDateDesc = raw.sortDateDesc === true;
            this.direction = raw.direction;
            this.showOnlyRemoteAccess = raw.showOnlyRemoteAccess === true;
            this.showOnlyManuallyInserted = raw.showOnlyManuallyInserted === true;
            this.showOnlyExitButtons = raw.showOnlyExitButtons === true;
            this.reasons = raw.reasons ? raw.reasons : null;
            this.credentialData = raw.credentialData ? raw.credentialData : null;
            this.credentialTypes = raw.credentialTypes && raw.credentialTypes.length > 0 ? raw.credentialTypes : null;
        }
    }
    RestUserApiV1.VisitorAccessLogsFilter = VisitorAccessLogsFilter;
    class MyAccessLogsFilter {
        constructor(raw, validator) {
            validator
                .validateDate("startUtc", true, raw.startUtc)
                .validateDate("endUtc", true, raw.endUtc)
                .validateDateRange(["startUtc", "endUtc"], {
                start: raw.startUtc,
                end: raw.endUtc,
                startOptional: true,
                endOptional: true,
            })
                .validateEnum("accessResult", true, app_enums_1.enums.AccessReportFilterAccessResultType, raw.accessResult)
                .validateEnum("direction", true, app_enums_1.enums.AccessDirection, raw.direction)
                .validateEnumArray("credentialTypes", true, app_enums_1.enums.CredentialType, raw.credentialTypes)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateEnumArray("reasons", true, dal_constants_1.DalConstants.AccessLogReason, raw.reasons)
                .finalize();
            this.startUtc = raw.startUtc ? new Date(raw.startUtc) : null;
            this.endUtc = raw.endUtc ? new Date(raw.endUtc) : null;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.take = raw.take;
            this.skip = raw.skip;
            this.returnTotalCount = raw.returnTotalCount === true;
            this.accessResult = raw.accessResult;
            this.sortDateDesc = raw.sortDateDesc === true;
            this.direction = raw.direction;
            this.showOnlyRemoteAccess = raw.showOnlyRemoteAccess === true;
            this.showOnlyManuallyInserted = raw.showOnlyManuallyInserted === true;
            this.reasons = raw.reasons;
            this.credentialTypes = raw.credentialTypes && raw.credentialTypes.length > 0 ? raw.credentialTypes : null;
        }
    }
    RestUserApiV1.MyAccessLogsFilter = MyAccessLogsFilter;
    class UpsertOrganizationUnit {
        constructor(raw, validator) {
            validator
                .validateUUID("id", true, raw.id)
                .validateUUID("parentId", true, raw.parentId)
                .validateUUID("managerUserId", true, raw.managerUserId)
                .validateUUID("typeId", false, raw.typeId)
                .validateString({
                field: "name",
                optional: false,
                input: raw.name,
                minLength: 1,
                maxLength: 255,
            })
                .validateString({
                field: "shortCode",
                optional: true,
                input: raw.shortCode,
                minLength: 1,
                maxLength: 255,
            })
                .finalize();
            this.id = raw.id;
            this.parentId = raw.parentId;
            this.typeId = raw.typeId;
            this.name = raw.name;
            this.shortCode = raw.shortCode;
            this.managerUserId = raw.managerUserId;
            this.dynamicFormId = raw.dynamicFormId;
            this.dynamicFormData = raw.dynamicFormData;
        }
    }
    RestUserApiV1.UpsertOrganizationUnit = UpsertOrganizationUnit;
    class OrganizationUnitDefaultAccessControlPointChanges {
        constructor(raw, validator) {
            validator.validateUUIDArray("removedAccessControlPointIds", false, raw.removedAccessControlPointIds).finalize();
            this.applyToMembers = raw.applyToMembers === true;
            this.applyHierarchically = raw.applyHierarchically === true;
            this.addedAccessControlPoints = raw.addedAccessControlPoints;
            this.removedAccessControlPointIds = raw.removedAccessControlPointIds;
            for (const accessRight of this.addedAccessControlPoints) {
                if (accessRight.config && accessRight.grant && !accessRight.read) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
                if (!accessRight.read && !accessRight.grant && !accessRight.access && !accessRight.config && !accessRight.remoteAccess && !accessRight.snapshot) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
            }
        }
    }
    RestUserApiV1.OrganizationUnitDefaultAccessControlPointChanges = OrganizationUnitDefaultAccessControlPointChanges;
    class ApplyUserSelectionSessionWithPrivilegesRequest {
        constructor(raw, validator) {
            validator
                .validateObject("accessRights", false, raw.accessRights, new api_validatorhelper_1.ValidatorHelper()
                .validateIsBoolean("accessRights.read", false, raw.accessRights ? raw.accessRights.read : false)
                .validateIsBoolean("accessRights.grant", false, raw.accessRights ? raw.accessRights.grant : false)
                .validateIsBoolean("accessRights.access", false, raw.accessRights ? raw.accessRights.access : false)
                .validateIsBoolean("accessRights.config", false, raw.accessRights ? raw.accessRights.config : false)
                .validateIsBoolean("accessRights.remoteAccess", false, raw.accessRights ? raw.accessRights.remoteAccess : false)
                .validateIsBoolean("accessRights.snapshot", false, raw.accessRights ? raw.accessRights.snapshot : false))
                .validateEnum("scope", false, app_enums_1.enums.UserSelectionSessionAccessControlPointRightScope, raw.scope)
                .finalize();
            this.accessRights = raw.accessRights;
            this.scope = raw.scope;
            if (!this.accessRights.read && (this.accessRights.snapshot || this.accessRights.grant || this.accessRights.config)) {
                throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
            }
            if (!this.accessRights.read &&
                !this.accessRights.grant &&
                !this.accessRights.access &&
                !this.accessRights.config &&
                !this.accessRights.remoteAccess &&
                !this.accessRights.snapshot) {
                throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
            }
        }
    }
    RestUserApiV1.ApplyUserSelectionSessionWithPrivilegesRequest = ApplyUserSelectionSessionWithPrivilegesRequest;
    class RemoveOrganizationUnitRequest {
        constructor(raw, validator) {
            validator.validateEnum("action", false, app_enums_1.enums.RemoveOrganizationUnitAction, raw.action);
            this.action = raw.action;
        }
    }
    RestUserApiV1.RemoveOrganizationUnitRequest = RemoveOrganizationUnitRequest;
    class ListAccessControlPointRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator
                .validateUUIDArray("accessControlPointIds", false, raw.accessControlPointIds)
                .validateIsBoolean("read", true, raw.read)
                .validateIsBoolean("access", true, raw.access)
                .validateIsBoolean("remoteAccess", true, raw.remoteAccess)
                .validateIsBoolean("config", true, raw.config)
                .validateIsBoolean("grant", true, raw.grant)
                .validateIsBoolean("snapshot", true, raw.snapshot);
            this.accessControlPointIds = raw.accessControlPointIds;
            this.read = raw.read;
            this.access = raw.access;
            this.remoteAccess = raw.remoteAccess;
            this.config = raw.config;
            this.grant = raw.grant;
            this.snapshot = raw.snapshot;
        }
    }
    RestUserApiV1.ListAccessControlPointRequest = ListAccessControlPointRequest;
    class ListRegionRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("regionIds", false, raw.regionIds);
            this.regionIds = raw.regionIds;
            validator.finalize();
        }
    }
    RestUserApiV1.ListRegionRequest = ListRegionRequest;
    class ListAccessControlPointPrivilegesRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds);
            this.accessControlPointIds = raw.accessControlPointIds;
            validator.finalize();
        }
    }
    RestUserApiV1.ListAccessControlPointPrivilegesRequest = ListAccessControlPointPrivilegesRequest;
    class GenericListTerminalsRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("terminalIds", false, raw.terminalIds);
            this.terminalIds = raw.terminalIds;
        }
    }
    RestUserApiV1.GenericListTerminalsRequest = GenericListTerminalsRequest;
    class GenericListSensorsRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("sensorIds", false, raw.sensorIds);
            this.sensorIds = raw.sensorIds;
        }
    }
    RestUserApiV1.GenericListSensorsRequest = GenericListSensorsRequest;
    class ListDryContactInputRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("dryContactInputIds", false, raw.dryContactInputIds);
            this.dryContactInputIds = raw.dryContactInputIds;
        }
    }
    RestUserApiV1.ListDryContactInputRequest = ListDryContactInputRequest;
    class ListOrganizationUnitsRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            validator.validateUUIDArray("organizationUnitIds", false, raw.organizationUnitIds);
            this.organizationUnitIds = raw.organizationUnitIds;
        }
    }
    RestUserApiV1.ListOrganizationUnitsRequest = ListOrganizationUnitsRequest;
    class ListUserGroupsRequest {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.validateUUIDArray("userGroupIds", true, raw.userGroupIds);
            validator.validateString({ field: "filter", optional: true, input: raw.filter, maxLength: 20, minLength: 3 });
            validator.finalize();
            this.userGroupIds = raw.userGroupIds;
            this.filter = raw.filter;
        }
    }
    RestUserApiV1.ListUserGroupsRequest = ListUserGroupsRequest;
    class GenericSearchRequest {
        constructor(raw, validatorHelper) {
            validatorHelper.validatePaginationRequest("pagination", { take: raw.take, skip: raw.skip }, false, 1000);
            validatorHelper.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
        }
    }
    RestUserApiV1.GenericSearchRequest = GenericSearchRequest;
    class GenericSearchRequestWithPrivileges {
        constructor(raw) {
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
            this.access = raw.access;
            this.grant = raw.grant;
            this.read = raw.read;
            this.config = raw.config;
            this.snapshot = raw.snapshot;
            this.remoteAccess = raw.remoteAccess;
        }
    }
    RestUserApiV1.GenericSearchRequestWithPrivileges = GenericSearchRequestWithPrivileges;
    class UpsertCameraRequest {
        constructor(raw, validator) {
            this.id = raw.id;
            this.name = raw.name;
            this.userName = raw.userName;
            this.password = raw.password;
            this.mappings = raw.mappings;
            this.snapshotUrl = raw.snapshotUrl;
            this.proxyTerminalId = raw.proxyTerminalId;
            if (raw.accessControlPoint) {
                validator.validateUUID("accessControlPointId", true, raw.accessControlPoint.id);
                validator.validateUUIDArray("readerIds", true, raw.accessControlPoint.readerIds);
                validator.validateUUIDArray("dryContactInputIds", true, raw.accessControlPoint.dryContactInputIds);
            }
            validator.finalize();
        }
    }
    RestUserApiV1.UpsertCameraRequest = UpsertCameraRequest;
    class IRegionDetailed {
        constructor(raw, validator) {
            validator
                .validateUUID("id", true, raw.id)
                .validateString({ field: "name", optional: false, input: raw.name })
                .validateIsBoolean("antiPassback", true, raw.antiPassback)
                .validateInteger({ field: "antiPassbackLockDuration", optional: true, input: raw.antiPassbackLockDuration })
                .validateIsBoolean("visitorAccess", true, raw.visitorAccess)
                .validateIsBoolean("terminateVisitOnExit", true, raw.terminateVisitOnExit)
                .validateIsBoolean("deliverDeviceEmergencyToRegionDevices", true, raw.deliverDeviceEmergencyToRegionDevices)
                .validateEnum("emergencyState", true, app_enums_1.enums.EmergencyState, raw.emergencyState);
            validator.finalize();
            this.id = raw.id;
            this.name = raw.name;
            this.antiPassback = raw.antiPassback;
            this.antiPassbackLockDuration = raw.antiPassbackLockDuration;
            this.visitorAccess = raw.visitorAccess ?? true;
            this.terminateVisitOnExit = raw.terminateVisitOnExit ?? false;
            this.deliverDeviceEmergencyToRegionDevices = raw.deliverDeviceEmergencyToRegionDevices ?? false;
            this.emergencyState = raw.emergencyState ?? app_enums_1.enums.EmergencyState.Normal;
        }
    }
    RestUserApiV1.IRegionDetailed = IRegionDetailed;
    class InitialDataRequest {
        constructor(raw) {
            this.systemHealth = raw.systemHealth === true;
            this.organizationRoles = raw.organizationRoles === true;
            this.remoteAccessGrantedAccessControlPointFilter = raw.remoteAccessGrantedAccessControlPointFilter;
            this.cards = raw.cards;
        }
    }
    RestUserApiV1.InitialDataRequest = InitialDataRequest;
    class FirstAndLastAccessLogsFilter {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            this.userIds = raw.userIds;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically === true;
            this.userGroupIds = raw.userGroupIds;
            this.status = raw.status;
            this.hasOrganizationWide = raw.hasOrganizationWide;
        }
    }
    RestUserApiV1.FirstAndLastAccessLogsFilter = FirstAndLastAccessLogsFilter;
    class EntryByUnitFilter {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            validator.finalize();
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationId = raw.organizationId;
            this.requesterUserId = raw.requesterUserId;
        }
    }
    RestUserApiV1.EntryByUnitFilter = EntryByUnitFilter;
    class FirstAndLastAccessLogsForSingleUserFilter {
        constructor(raw, validator) {
            validator
                .validateUUID("userId", false, raw.userId)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.userId = raw.userId;
        }
    }
    RestUserApiV1.FirstAndLastAccessLogsForSingleUserFilter = FirstAndLastAccessLogsForSingleUserFilter;
    class FirstAndLastAccessLogsForSingleUserFilterForExcel {
        constructor(raw, validator) {
            validator
                .validateUUID("userId", false, raw.userId)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            validator.finalize();
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.userId = raw.userId;
        }
    }
    RestUserApiV1.FirstAndLastAccessLogsForSingleUserFilterForExcel = FirstAndLastAccessLogsForSingleUserFilterForExcel;
    class FirstAndLastAccessLogsFilterExcel {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds)
                .validateUUIDArray("regionIds", true, raw.regionIds)
                .validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            validator.finalize();
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            this.userIds = raw.userIds;
            this.accessControlPointIds = raw.accessControlPointIds;
            this.regionIds = raw.regionIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically === true;
            this.userGroupIds = raw.userGroupIds;
            this.status = raw.status;
        }
    }
    RestUserApiV1.FirstAndLastAccessLogsFilterExcel = FirstAndLastAccessLogsFilterExcel;
    class SearchGrantedAccessControlPointsByAuthFilter {
        constructor(raw, validator) {
            validator.validatePaginationRequest("pagination", { take: raw.take, skip: raw.skip }, false);
            validator.finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
            this.onlyMarkedAsFavorites = raw.onlyMarkedAsFavorites;
            this.accessControlPointType = raw.accessControlPointType;
            this.authenticationFactors = raw.authenticationFactors;
            this.remoteAvailable = raw.remoteAvailable;
        }
    }
    RestUserApiV1.SearchGrantedAccessControlPointsByAuthFilter = SearchGrantedAccessControlPointsByAuthFilter;
    class UpdateTypedRoleRequest {
        constructor(raw) {
            let permissions = raw.permissions;
            this.permissions = permissions;
        }
    }
    RestUserApiV1.UpdateTypedRoleRequest = UpdateTypedRoleRequest;
    class UpdateRoleRequest {
        constructor(raw) {
            this.name = raw.name;
            let permissions = raw.permissions;
            this.permissions = permissions;
        }
    }
    RestUserApiV1.UpdateRoleRequest = UpdateRoleRequest;
    class AddRoleRequest {
        constructor(raw) {
            this.name = raw.name;
            let permissions = raw.permissions;
            this.permissions = permissions;
            this.isOrganizationWide = raw.isOrganizationWide === true;
        }
    }
    RestUserApiV1.AddRoleRequest = AddRoleRequest;
    class RegionStateReportRequestBody {
        constructor(raw, validator) {
            if (raw.pagination) {
                this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 20, validator);
                this.nestedPagination = true;
            }
            else {
                validator.validateInteger({
                    field: "take",
                    optional: false,
                    input: raw.take,
                    max: 100,
                });
                validator.validateInteger({
                    field: "skip",
                    optional: true,
                    input: raw.skip,
                });
                this.pagination = {
                    take: raw.take ? parseInt(raw.take) : 100,
                    skip: raw.skip ? parseInt(raw.skip) : 0,
                };
                this.nestedPagination = false;
            }
            validator
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateIsBoolean("applyOrganizationUnitFilterHierarchically", true, raw.applyOrganizationUnitFilterHierarchically)
                .validateEnumArray("state", true, app_enums_1.enums.AntiPassbackState, raw.state)
                .validateEnum("status", true, app_enums_1.enums.IdentityStatusType, raw.status)
                .validateIsBoolean("includeUserCaptions", true, raw.includeUserCaptions);
            validator.finalize();
            this.userIds = raw.userIds ?? [];
            this.organizationUnitIds = raw.organizationUnitIds ?? [];
            this.applyOrganizationUnitFilterHierarchically = raw.applyOrganizationUnitFilterHierarchically ?? false;
            this.state = raw.state ?? [app_enums_1.enums.AntiPassbackState.In, app_enums_1.enums.AntiPassbackState.Out, app_enums_1.enums.AntiPassbackState.Unknown];
            this.status = raw.status ?? app_enums_1.enums.IdentityStatusType.Enabled;
            this.userGroupIds = raw.userGroupIds ?? [];
            this.includeUserCaptions = raw.includeUserCaptions ?? true;
            this.sortOrder = raw.sortOrder ?? "DESC";
            this.sortType = raw.sortType ?? app_enums_1.enums.RegionReportSortType.NameSurname;
        }
    }
    RestUserApiV1.RegionStateReportRequestBody = RegionStateReportRequestBody;
    class DurationInRegionReportOverviewFilter {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateIsBoolean("applyOrganizationUnitFilterHierarchically", true, raw.applyOrganizationUnitFilterHierarchically)
                .validateDateRange(["range.start", "range.end"], {
                start: raw.range?.start,
                startOptional: false,
                end: raw.range?.end,
                endOptional: false,
            })
                .validateIsBoolean("includePasses", true, raw.includePasses)
                .validateEnum("sortField", true, app_enums_1.enums.DurationInRegionSortType)
                .validateEnum("sortType", true, app_enums_1.enums.SortType);
            this.userIds = raw.userIds ?? [];
            this.userGroupIds = raw.userGroupIds ?? [];
            this.organizationUnitIds = raw.organizationUnitIds ?? [];
            this.applyOrganizationUnitFilterHierarchically = raw.applyOrganizationUnitFilterHierarchically ?? false;
            this.range = {
                start: new Date(raw.range.start),
                end: new Date(raw.range.end),
            };
            this.includePasses = raw.includePasses ?? false;
            this.sortField = raw.sortField === app_enums_1.enums.DurationInRegionSortType.UserName ? app_enums_1.enums.DurationInRegionSortType.UserName : app_enums_1.enums.DurationInRegionSortType.Duration;
            this.sortType = raw.sortType === app_enums_1.enums.SortType.Ascending ? app_enums_1.enums.SortType.Ascending : app_enums_1.enums.SortType.Descending;
        }
    }
    RestUserApiV1.DurationInRegionReportOverviewFilter = DurationInRegionReportOverviewFilter;
    class DurationInRegionReportDetailFilter {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator
                .validateDateRange(["range.start", "range.end"], {
                start: raw.range?.start,
                startOptional: false,
                end: raw.range?.end,
                endOptional: false,
            })
                .validateIsBoolean("includePasses", true, raw.includePasses)
                .validateEnum("sortField", true, app_enums_1.enums.DurationInRegionDetailSortType)
                .validateEnum("sortType", true, app_enums_1.enums.SortType);
            this.range = {
                start: new Date(raw.range.start),
                end: new Date(raw.range.end),
            };
            this.includePasses = raw.includePasses ?? false;
            this.sortField = raw.sortField === app_enums_1.enums.DurationInRegionDetailSortType.Date ? app_enums_1.enums.DurationInRegionDetailSortType.Date : app_enums_1.enums.DurationInRegionDetailSortType.Duration;
            this.sortType = raw.sortType === app_enums_1.enums.SortType.Ascending ? app_enums_1.enums.SortType.Ascending : app_enums_1.enums.SortType.Descending;
        }
    }
    RestUserApiV1.DurationInRegionReportDetailFilter = DurationInRegionReportDetailFilter;
    class CustomReportFilterRequest {
        constructor(raw, validator) {
            validator.validateEnum("format", false, app_enums_1.enums.ReportFormat, raw.format);
            validator.validateObjectArray("filters", false, raw.filters);
            validator.finalize();
            this.format = raw.format;
            this.filters = raw.filters;
        }
    }
    RestUserApiV1.CustomReportFilterRequest = CustomReportFilterRequest;
    class AccessControlPointFilter {
        constructor(raw, validatorHelper) {
            validatorHelper
                .validateString({
                field: "filter",
                optional: true,
                input: raw.filter,
                minLength: 3,
                maxLength: 20,
            })
                .validateInteger({
                field: "take",
                optional: true,
                input: raw.take,
                max: 100,
            })
                .validateInteger({ field: "skip", optional: true, input: raw.skip })
                .validateEnum("accessControlPointType", true, app_enums_1.enums.AccessControlPointType, raw.accessControlPointType)
                .finalize();
            this.take = raw.take;
            this.skip = raw.skip;
            this.filter = raw.filter;
            this.returnTotalCount = raw.returnTotalCount;
            this.accessControlPointType = raw.accessControlPointType;
        }
    }
    RestUserApiV1.AccessControlPointFilter = AccessControlPointFilter;
    class InsertIdentityRequest {
        validate(raw, validator) {
            validator
                .validateObject("organizationProfile", false, raw.organizationProfile, new api_validatorhelper_1.ValidatorHelper()
                .validateString({
                field: "organizationProfile.uniqueId",
                optional: false,
                input: raw.organizationProfile ? raw.organizationProfile.uniqueId : null,
                maxLength: 64,
            })
                .validateUUID("organizationProfile.roleId", false, raw.organizationProfile ? raw.organizationProfile.roleId : null)
                .validateString({
                field: "organizationProfile.name",
                optional: false,
                input: raw.organizationProfile ? raw.organizationProfile.name : null,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.surname",
                optional: false,
                input: raw.organizationProfile ? raw.organizationProfile.surname : null,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.email",
                optional: true,
                input: raw.organizationProfile ? raw.organizationProfile.email : null,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.phoneNumber",
                optional: true,
                input: raw.organizationProfile ? raw.organizationProfile.phoneNumber : null,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.address",
                optional: true,
                input: raw.organizationProfile ? raw.organizationProfile.address : null,
                maxLength: 512,
            })
                .validateDate("organizationProfile.employmentStartUtc", true, raw.organizationProfile ? raw.organizationProfile.employmentStartUtc : null)
                .validateDate("organizationProfile.employmentEndUtc", true, raw.organizationProfile ? raw.organizationProfile.employmentEndUtc : null)
                .validateDate("organizationProfile.birthDateUtc", true, raw.organizationProfile ? raw.organizationProfile.birthDateUtc : null)
                .validateIsArrayOfString("organizationProfile.extraPermissions", true, raw.organizationProfile ? raw.organizationProfile.extraPermissions : null))
                .validateObject("userAccount", true, raw.userAccount, new api_validatorhelper_1.ValidatorHelper()
                .validateString({
                field: "userAccount.username",
                optional: false,
                input: raw.userAccount ? raw.userAccount.username : null,
                maxLength: 127,
                minLength: 3,
            })
                .validateString({
                field: "userAccount.password",
                optional: false,
                input: raw.userAccount ? raw.userAccount.password : null,
                maxLength: app_constants_1.ACCOUNT_PASSWORD_MAX_LENGTH,
                minLength: app_constants_1.ACCOUNT_PASSWORD_MIN_LENGTH,
            }))
                .validateObjectArray("organizationUnits", true, raw.organizationUnits)
                .validateObjectArray("credentials", true, raw.credentials)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validateIsBoolean("addDefaultAccessRightsOfUnits", true, raw.addDefaultAccessRightsOfUnits)
                .validateEnum("source", true, dal_constants_1.DalConstants.SourceType, raw.source)
                .validateUUID("sourceId", true, raw.sourceId);
            if (raw.organizationUnits) {
                for (let i = 0; i < raw.organizationUnits.length; i++) {
                    let organizationUnit = raw.organizationUnits[i];
                    validator.validateObject("organizationUnit", false, organizationUnit, new api_validatorhelper_1.ValidatorHelper()
                        .validateUUID("organizationUnit.organizationUnitId", false, organizationUnit.organizationUnitId)
                        .validateUUID("organizationUnit.roleId", false, organizationUnit.roleId)
                        .validateIsArrayOfString("organizationUnit.extraPermissions", true, organizationUnit.extraPermissions));
                }
            }
            if (raw.accessRights) {
                for (let i = 0; i < raw.accessRights.length; i++) {
                    let accessRight = raw.accessRights[i];
                    validator.validateObject("accessRights", false, accessRight, new api_validatorhelper_1.ValidatorHelper().validateUUID("accessRight.accessControlPointId", false, accessRight.accessControlPointId));
                }
            }
            if (raw.credentials) {
                for (let i = 0; i < raw.credentials.length; i++) {
                    let credential = raw.credentials[i];
                    validator.validateObject("credentials", false, credential, new api_validatorhelper_1.ValidatorHelper()
                        .validateEnum("credential.type", false, app_enums_1.enums.CredentialType, credential.type)
                        .validateString({
                        field: "credential.data",
                        optional: false,
                        input: credential.data,
                        minLength: 3,
                        maxLength: 1023,
                    })
                        .validateString({
                        field: "credential.credentialNumber",
                        optional: true,
                        input: credential.credentialNumber,
                        maxLength: 31,
                    })
                        .validateDate("credential.expirationUtc", true, credential.expirationUtc)
                        .validateInteger({
                        field: "credential.groupNumber",
                        optional: true,
                        input: credential.groupNumber,
                    }));
                }
            }
            validator.finalize();
            let result = {
                organizationProfile: {
                    uniqueId: raw.organizationProfile.uniqueId,
                    roleId: raw.organizationProfile.roleId,
                    extraPermissions: raw.organizationProfile.extraPermissions,
                    isDisabled: raw.organizationProfile.isDisabled === true,
                    name: raw.organizationProfile.name,
                    surname: raw.organizationProfile.surname,
                    email: raw.organizationProfile.email,
                    phoneNumber: raw.organizationProfile.phoneNumber,
                    address: raw.organizationProfile.address,
                    extensionFields: raw.organizationProfile.extensionFields,
                    employmentStartUtc: raw.organizationProfile.employmentStartUtc ? new Date(raw.organizationProfile.employmentStartUtc) : null,
                    employmentEndUtc: raw.organizationProfile.employmentEndUtc ? new Date(raw.organizationProfile.employmentEndUtc) : null,
                    previousServiceDuration: raw.organizationProfile.previousServiceDuration,
                    pacsEnabledRemainedAnnualPPermission: raw.organizationProfile.pacsEnabledRemainedAnnualPPermission,
                    birthDateUtc: raw.organizationProfile.birthDateUtc,
                },
                organizationUnits: raw.organizationUnits
                    ? raw.organizationUnits.map((m) => {
                        return {
                            organizationUnitId: m.organizationUnitId,
                            roleId: m.roleId,
                            extraPermissions: m.extraPermissions,
                        };
                    })
                    : [],
                accessRights: raw.accessRights
                    ? raw.accessRights.map((m) => {
                        return {
                            accessControlPointId: m.accessControlPointId,
                            remoteAccess: m.remoteAccess === true,
                            access: m.access,
                            config: m.config,
                            grant: m.grant,
                            read: m.read,
                            snapshot: m.snapshot,
                        };
                    })
                    : [],
                credentials: raw.credentials
                    ? raw.credentials.map((m) => {
                        return {
                            type: m.type,
                            data: m.data.trim(),
                            credentialNumber: m.credentialNumber,
                            expirationUtc: m.expirationUtc ? new Date(m.expirationUtc) : null,
                            extensionFields: m.extensionFields ? m.extensionFields : null,
                            customFields: m.customFields ? m.customFields : null,
                            note: m.note ? m.note : null,
                            groupNumber: m.groupNumber,
                        };
                    })
                    : [],
                userAccount: raw.userAccount
                    ? {
                        username: raw.userAccount.username,
                        password: raw.userAccount.password,
                    }
                    : null,
                userGroupIds: raw.userGroupIds ?? [],
                addDefaultAccessRightsOfUnits: raw.addDefaultAccessRightsOfUnits,
                source: raw.source,
                sourceId: raw.sourceId,
            };
            let allAccessRights = result.accessRights;
            for (const accessRight of allAccessRights) {
                if (accessRight.config && accessRight.grant && !accessRight.read) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
                if (!accessRight.read && !accessRight.grant && !accessRight.access && !accessRight.config && !accessRight.remoteAccess && !accessRight.snapshot) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
            }
            return result;
        }
    }
    RestUserApiV1.InsertIdentityRequest = InsertIdentityRequest;
    class UpdateIdentityRequest {
        validate(raw, validator) {
            validator
                .validateUUID("id", false, raw.id)
                .validateObject("organizationProfile", true, raw.organizationProfile, new api_validatorhelper_1.ValidatorHelper()
                .validateString({
                field: "organizationProfile.uniqueId",
                optional: false,
                input: raw.organizationProfile.uniqueId,
                maxLength: 64,
            })
                .validateUUID("organizationProfile.roleId", false, raw.organizationProfile.roleId)
                .validateString({
                field: "organizationProfile.name",
                optional: false,
                input: raw.organizationProfile.name,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.surname",
                optional: false,
                input: raw.organizationProfile.surname,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.email",
                optional: true,
                input: raw.organizationProfile.email,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.phoneNumber",
                optional: true,
                input: raw.organizationProfile.phoneNumber,
                maxLength: 255,
            })
                .validateString({
                field: "organizationProfile.address",
                optional: true,
                input: raw.organizationProfile.address,
                maxLength: 512,
            })
                .validateDate("organizationProfile.employmentStartUtc", true, raw.organizationProfile.employmentStartUtc)
                .validateDate("organizationProfile.employmentEndUtc", true, raw.organizationProfile.employmentEndUtc)
                .validateInteger({
                field: "organizationProfile.previousServiceDuration",
                optional: true,
                input: raw.organizationProfile.previousServiceDuration,
            })
                .validateFloat("organizationProfile.pacsEnabledRemainedAnnualPPermission", true, raw.organizationProfile.pacsEnabledRemainedAnnualPPermission)
                .validateDate("organizationProfile.birthDateUtc", true, raw.organizationProfile.birthDateUtc)
                .validateIsArrayOfString("organizationProfile.extraPermissions", true, raw.organizationProfile.extraPermissions))
                .validateObject("userAccount", true, raw.userAccount, new api_validatorhelper_1.ValidatorHelper()
                .validateString({
                field: "userAccount.username",
                optional: false,
                input: raw.userAccount ? raw.userAccount.username : null,
                maxLength: 127,
                minLength: 3,
            })
                .validateString({
                field: "userAccount.password",
                optional: false,
                input: raw.userAccount ? raw.userAccount.password : null,
                maxLength: app_constants_1.ACCOUNT_PASSWORD_MAX_LENGTH,
                minLength: app_constants_1.ACCOUNT_PASSWORD_MIN_LENGTH,
            }))
                .validateObjectArray("addedOrganizationUnits", true, raw.addedOrganizationUnits)
                .validateObjectArray("addedAccessRights", true, raw.addedAccessRights)
                .validateObjectArray("addedCredentials", true, raw.addedCredentials)
                .validateUUIDArray("addedUserGroupIds", true, raw.addedUserGroupIds)
                .validateObjectArray("updatedOrganizationUnits", true, raw.updatedOrganizationUnits)
                .validateObjectArray("updatedAccessRights", true, raw.updatedAccessRights)
                .validateObjectArray("updatedCredentials", true, raw.updatedCredentials)
                .validateUUIDArray("removedOrganizationUnitIds", true, raw.removedOrganizationUnitIds)
                .validateUUIDArray("removedAccessControlPointIds", true, raw.removedAccessControlPointIds)
                .validateUUIDArray("removedCredentialIds", true, raw.removedCredentialIds)
                .validateUUIDArray("removedUserGroupIds", true, raw.removedUserGroupIds)
                .validateIsBoolean("addDefaultAccessRightsOfUnits", true, raw.addDefaultAccessRightsOfUnits)
                .validateIsBoolean("removeDefaultAccessRightsOfUnits", true, raw.removeDefaultAccessRightsOfUnits)
                .validateEnum("source", true, dal_constants_1.DalConstants.SourceType, raw.source)
                .validateUUID("sourceId", true, raw.sourceId);
            if (raw.addedOrganizationUnits) {
                for (let i = 0; i < raw.addedOrganizationUnits.length; i++) {
                    let organizationUnit = raw.addedOrganizationUnits[i];
                    validator.validateObject("addedOrganizationUnit", false, organizationUnit, new api_validatorhelper_1.ValidatorHelper()
                        .validateUUID("organizationUnit.organizationUnitId", false, organizationUnit.organizationUnitId)
                        .validateUUID("organizationUnit.roleId", false, organizationUnit.roleId)
                        .validateIsArrayOfString("organizationUnit.extraPermissions", true, organizationUnit.extraPermissions));
                }
            }
            if (raw.updatedOrganizationUnits) {
                for (let i = 0; i < raw.updatedOrganizationUnits.length; i++) {
                    let organizationUnit = raw.updatedOrganizationUnits[i];
                    validator.validateObject("updatedOrganizationUnit", false, organizationUnit, new api_validatorhelper_1.ValidatorHelper()
                        .validateUUID("organizationUnit.organizationUnitId", false, organizationUnit.organizationUnitId)
                        .validateUUID("organizationUnit.roleId", false, organizationUnit.roleId)
                        .validateIsArrayOfString("organizationUnit.extraPermissions", true, organizationUnit.extraPermissions));
                }
            }
            if (raw.addedAccessRights) {
                for (let i = 0; i < raw.addedAccessRights.length; i++) {
                    let accessRight = raw.addedAccessRights[i];
                    validator.validateObject("addedAccessRight", false, accessRight, new api_validatorhelper_1.ValidatorHelper().validateUUID("accessRight.accessControlPointId", false, accessRight.accessControlPointId));
                }
            }
            if (raw.updatedAccessRights) {
                for (let i = 0; i < raw.updatedAccessRights.length; i++) {
                    let accessRight = raw.updatedAccessRights[i];
                    validator.validateObject("updatedAccessRight", false, accessRight, new api_validatorhelper_1.ValidatorHelper().validateUUID("accessRight.accessControlPointId", false, accessRight.accessControlPointId));
                }
            }
            if (raw.addedCredentials) {
                for (let i = 0; i < raw.addedCredentials.length; i++) {
                    let credential = raw.addedCredentials[i];
                    validator.validateObject("addedCredentials", false, credential, new api_validatorhelper_1.ValidatorHelper()
                        .validateEnum("credential.type", false, app_enums_1.enums.CredentialType, credential.type)
                        .validateString({
                        field: "credential.data",
                        optional: false,
                        input: credential.data,
                        minLength: 3,
                        maxLength: 1023,
                    })
                        .validateString({
                        field: "credential.credentialNumber",
                        optional: true,
                        input: credential.credentialNumber,
                        maxLength: 31,
                    })
                        .validateDate("credential.expirationUtc", true, credential.expirationUtc)
                        .validateInteger({
                        field: "credential.groupNumber",
                        optional: true,
                        input: credential.groupNumber,
                    }));
                }
            }
            if (raw.updatedCredentials && raw.updatedCredentials.length) {
                for (let i = 0; i < raw.updatedCredentials.length; i++) {
                    let credential = raw.updatedCredentials[i];
                    validator.validateObject("updatedCredentials", false, credential, new api_validatorhelper_1.ValidatorHelper()
                        .validateString({
                        field: "credential.credentialNumber",
                        optional: true,
                        input: credential.credentialNumber,
                        maxLength: 31,
                    })
                        .validateDate("credential.expirationUtc", true, credential.expirationUtc)
                        .validateString({
                        field: "credential.note",
                        optional: true,
                        input: credential.note,
                        maxLength: 512,
                    })
                        .validateInteger({
                        field: "credential.groupNumber",
                        optional: true,
                        input: credential.groupNumber,
                    }));
                }
            }
            validator.finalize();
            let result = {
                id: raw.id,
                organizationProfile: !raw.organizationProfile
                    ? undefined
                    : {
                        uniqueId: raw.organizationProfile.uniqueId,
                        roleId: raw.organizationProfile.roleId,
                        extraPermissions: raw.organizationProfile.extraPermissions,
                        isDisabled: raw.organizationProfile.isDisabled === true,
                        name: raw.organizationProfile.name,
                        surname: raw.organizationProfile.surname,
                        email: raw.organizationProfile.email,
                        phoneNumber: raw.organizationProfile.phoneNumber,
                        address: raw.organizationProfile.address,
                        extensionFields: raw.organizationProfile.extensionFields,
                        employmentStartUtc: raw.organizationProfile.employmentStartUtc
                            ? new Date(raw.organizationProfile.employmentStartUtc)
                            : raw.organizationProfile.employmentStartUtc === null || raw.organizationProfile.employmentStartUtc === ""
                                ? null
                                : undefined,
                        employmentEndUtc: raw.organizationProfile.employmentEndUtc
                            ? new Date(raw.organizationProfile.employmentEndUtc)
                            : raw.organizationProfile.employmentEndUtc === null || raw.organizationProfile.employmentEndUtc === ""
                                ? null
                                : undefined,
                        previousServiceDuration: raw.organizationProfile.previousServiceDuration,
                        pacsEnabledRemainedAnnualPPermission: raw.organizationProfile.pacsEnabledRemainedAnnualPPermission,
                        birthDateUtc: raw.organizationProfile.birthDateUtc
                            ? new Date(raw.organizationProfile.birthDateUtc)
                            : raw.organizationProfile.birthDateUtc === null || raw.organizationProfile.birthDateUtc === ""
                                ? null
                                : undefined,
                        locale: raw.organizationProfile.locale,
                    },
                userAccount: raw.userAccount
                    ? {
                        username: raw.userAccount.username.trim(),
                        password: raw.userAccount.password,
                    }
                    : null,
                addedOrganizationUnits: !raw.addedOrganizationUnits
                    ? []
                    : raw.addedOrganizationUnits.map((m) => {
                        return {
                            organizationUnitId: m.organizationUnitId,
                            roleId: m.roleId,
                            extraPermissions: m.extraPermissions,
                        };
                    }),
                updatedOrganizationUnits: !raw.updatedOrganizationUnits
                    ? []
                    : raw.updatedOrganizationUnits.map((m) => {
                        return {
                            organizationUnitId: m.organizationUnitId,
                            roleId: m.roleId,
                            extraPermissions: m.extraPermissions,
                        };
                    }),
                removedOrganizationUnitIds: raw.removedOrganizationUnitIds ?? [],
                addedAccessRights: !raw.addedAccessRights
                    ? []
                    : raw.addedAccessRights.map((m) => {
                        return {
                            accessControlPointId: m.accessControlPointId,
                            remoteAccess: m.remoteAccess === true,
                            access: m.access,
                            config: m.config,
                            grant: m.grant,
                            read: m.read,
                            snapshot: m.snapshot,
                        };
                    }),
                updatedAccessRights: !raw.updatedAccessRights
                    ? []
                    : raw.updatedAccessRights.map((m) => {
                        return {
                            accessControlPointId: m.accessControlPointId,
                            remoteAccess: m.remoteAccess === true,
                            access: m.access,
                            config: m.config,
                            grant: m.grant,
                            read: m.read,
                            snapshot: m.snapshot,
                        };
                    }),
                removedAccessControlPointIds: raw.removedAccessControlPointIds ?? [],
                removedCredentialIds: raw.removedCredentialIds ?? [],
                addedCredentials: !raw.addedCredentials
                    ? []
                    : raw.addedCredentials.map((m) => {
                        return {
                            type: m.type,
                            data: m.data.trim(),
                            credentialNumber: m.credentialNumber,
                            expirationUtc: m.expirationUtc ? new Date(m.expirationUtc) : null,
                            extensionFields: m.extensionFields ? m.extensionFields : null,
                            customFields: m.customFields ? m.customFields : null,
                            note: m.note ? m.note : null,
                            groupNumber: m.groupNumber ? m.groupNumber : null,
                        };
                    }),
                updatedCredentials: !raw.updatedCredentials
                    ? []
                    : raw.updatedCredentials.map((m) => {
                        return {
                            id: m.id,
                            credentialNumber: m.credentialNumber,
                            expirationUtc: m.expirationUtc ? new Date(m.expirationUtc) : null,
                            extensionFields: m.extensionFields ? m.extensionFields : null,
                            note: m.note ? m.note : null,
                            customFields: m.customFields ? m.customFields : null,
                            groupNumber: m.groupNumber ? m.groupNumber : null,
                        };
                    }),
                addedUserGroupIds: raw.addedUserGroupIds ?? [],
                removedUserGroupIds: raw.removedUserGroupIds ?? [],
                addDefaultAccessRightsOfUnits: raw.addDefaultAccessRightsOfUnits ?? false,
                removeDefaultAccessRightsOfUnits: raw.removeDefaultAccessRightsOfUnits ?? false,
                source: raw.source,
                sourceId: raw.sourceId,
            };
            let allAccessRights = result.addedAccessRights?.concat(result.updatedAccessRights);
            if (allAccessRights) {
                for (const accessRight of allAccessRights) {
                    if (accessRight.config && accessRight.grant && !accessRight.read) {
                        throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                    }
                    if (!accessRight.read && !accessRight.grant && !accessRight.access && !accessRight.config && !accessRight.remoteAccess && !accessRight.snapshot) {
                        throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                    }
                }
            }
            return result;
        }
    }
    RestUserApiV1.UpdateIdentityRequest = UpdateIdentityRequest;
    class CollectUserIdsByFieldSelectRequest {
        constructor(raw, validator) {
            validator = validator
                .validateString({
                field: "fieldName",
                optional: false,
                input: raw.fieldName,
                maxLength: 255,
                minLength: 2,
            })
                .validateIsArrayOfString("parameters", false, raw.parameters)
                .validateEnum("fieldType", false, app_enums_1.enums.DataFieldType, raw.fieldType);
            this.fieldName = raw.fieldName;
            this.fieldType = raw.fieldType;
            this.isExtensionField = raw.isExtensionField === true;
            this.parameters = [];
            switch (this.fieldType) {
                case app_enums_1.enums.DataFieldType.String:
                    validator.finalize();
                    this.parameters = raw.parameters;
                    break;
                case app_enums_1.enums.DataFieldType.Integer:
                    try {
                        for (let ii = 0; ii < raw.parameters.length; ii++) {
                            this.parameters.push(parseInt(raw.parameters[ii]));
                        }
                    }
                    catch (error) {
                        validator.errors.push({
                            code: app_enums_1.enums.ValidationErrorCode.INVALID_TYPE,
                            fields: ["parameters"],
                            message: "Contains not an integer value",
                        });
                        validator.finalize();
                    }
                    break;
                case app_enums_1.enums.DataFieldType.Date:
                    try {
                        for (let di = 0; di < raw.parameters.length; di++) {
                            this.parameters.push(new Date(raw.parameters[di]));
                        }
                    }
                    catch (error) {
                        validator.errors.push({
                            code: app_enums_1.enums.ValidationErrorCode.INVALID_TYPE,
                            fields: ["parameters"],
                            message: "Contains not a valid date value",
                        });
                        validator.finalize();
                    }
                    break;
                case app_enums_1.enums.DataFieldType.Boolean:
                    try {
                        for (let bi = 0; bi < raw.parameters.length; bi++) {
                            this.parameters.push(raw.parameters[bi] === "true");
                        }
                    }
                    catch (error) {
                        validator.errors.push({
                            code: app_enums_1.enums.ValidationErrorCode.INVALID_TYPE,
                            fields: ["parameters"],
                            message: "Contains not a boolean value",
                        });
                        validator.finalize();
                    }
                    break;
                default:
                    break;
            }
        }
    }
    RestUserApiV1.CollectUserIdsByFieldSelectRequest = CollectUserIdsByFieldSelectRequest;
    class InsertManualLogRequest {
        constructor(raw, validator) {
            validator.validateDate("accessDateTime", false, raw.actionUtc);
            validator.validateUUID("accessControlPointId", false, raw.accessControlPointId);
            validator.validateUUID("wiegandReaderId", true, raw.wiegandReaderId);
            validator.validateUUID("credentialId", true, raw.credentialId);
            validator.validateUUID("userId", false, raw.userId);
            validator.validateEnum("direction", false, app_enums_1.enums.AccessDirection, raw.direction);
            this.userId = raw.userId;
            this.credentialId = raw.credentialId;
            this.wiegandReaderId = raw.wiegandReaderId;
            this.accessControlPointId = raw.accessControlPointId;
            this.actionUtc = new Date(raw.actionUtc);
            this.direction = raw.direction;
            validator.finalize();
        }
    }
    RestUserApiV1.InsertManualLogRequest = InsertManualLogRequest;
    class InsertMultipleManualLogRequest {
        constructor(raw, validator) {
            for (const dt of raw.ranges) {
                validator.validateDate("startDateTime", false, dt.startDateTime);
                validator.validateDate("endDateTime", false, dt.endDateTime);
            }
            validator.validateUUID("entrance.accessControlPointId", false, raw.entrance.accessControlPointId);
            validator.validateUUID("entrance.wiegandReaderId", false, raw.entrance.wiegandReaderId);
            validator.validateUUID("exit.accessControlPointId", false, raw.exit.accessControlPointId);
            validator.validateUUID("exit.wiegandReaderId", false, raw.exit.wiegandReaderId);
            validator.validateUUID("credentialId", false, raw.credentialId);
            validator.validateUUID("userId", false, raw.userId);
            this.userId = raw.userId;
            this.credentialId = raw.credentialId;
            this.entrance = {
                accessControlPointId: raw.entrance.accessControlPointId,
                wiegandReaderId: raw.entrance.wiegandReaderId,
            };
            this.exit = {
                accessControlPointId: raw.exit.accessControlPointId,
                wiegandReaderId: raw.exit.wiegandReaderId,
            };
            this.ranges = [];
            for (const dt of raw.ranges) {
                this.ranges.push({
                    startDateTime: new Date(dt.startDateTime),
                    endDateTime: new Date(dt.endDateTime),
                });
            }
            validator.finalize();
        }
    }
    RestUserApiV1.InsertMultipleManualLogRequest = InsertMultipleManualLogRequest;
    class CounterSensorReportFilter {
        constructor(raw, validator) {
            validator.validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            validator.validateUUIDArray("accessControlPointIds", true, raw.accessControlPointIds);
            validator.validateUUIDArray("userIds", true, raw.userIds);
            this.pagination = raw.pagination;
            this.filterEvents = raw.filterEvents;
            this.dateRange = {
                startDateTime: new Date(raw.dateRange.startDateTime),
                endDateTime: new Date(raw.dateRange.endDateTime),
            };
            if (!raw.sortType) {
                this.sortType = app_enums_1.enums.SortType.Descending;
            }
            else {
                this.sortType = raw.sortType;
            }
            if (!raw.sortField) {
                this.sortField = app_enums_1.enums.SortField.Date;
            }
            else {
                this.sortField = raw.sortField;
            }
            validator.finalize();
        }
    }
    RestUserApiV1.CounterSensorReportFilter = CounterSensorReportFilter;
    class InsertFeedbackRequest {
        constructor(raw, validator) {
            validator.validateEnum("type", false, app_enums_1.enums.OrganizationFeedbackType, raw.type);
            validator.validateEnum("origin", false, app_enums_1.enums.OrganizationFeedbackOrigin, raw.origin);
            validator.validateRegex("title", raw.title, false, /^[a-zıçşöüğA-ZİÇŞÖÜĞ\d_\s@.]+$/gi);
            validator.validateRegex("body", raw.body, false, /^[a-zıçşöüğA-ZİÇŞÖÜĞ\d_\s@.]+$/gi);
            validator.finalize();
            this.title = raw.title;
            this.body = raw.body;
            this.type = raw.type;
            this.screenshot = raw.screenshot;
            this.data = raw.data;
            this.origin = raw.origin;
        }
    }
    RestUserApiV1.InsertFeedbackRequest = InsertFeedbackRequest;
    class DriverQrScanRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "qrCodeContent",
                optional: true,
                input: raw.qrCodeContent,
                minLength: 1,
                maxLength: 20,
            })
                .validateFloat("latitude", true, raw.latitude)
                .validateFloat("longitude", true, raw.longitude)
                .validateDate("timestamp", true, raw.timestamp);
            validator.finalize();
            this.qrCodeContent = raw.qrCodeContent;
            this.latitude = raw.latitude;
            this.longitude = raw.longitude;
            this.timestamp = new Date(raw.timestamp);
        }
    }
    RestUserApiV1.DriverQrScanRequest = DriverQrScanRequest;
    class FeedbackUpdateRequest {
        constructor(raw, validator) {
            validator.validateEnum("type", false, app_enums_1.enums.OrganizationFeedbackType, raw.type);
            validator.validateEnum("status", false, app_enums_1.enums.OrganizationFeedbackStatus, raw.status);
            validator.finalize();
            this.type = raw.type;
            this.status = raw.status;
            this.note = raw.note;
        }
    }
    RestUserApiV1.FeedbackUpdateRequest = FeedbackUpdateRequest;
    class ListSelfFeedbackRequest {
        constructor(raw, validator) {
            validator.validateEnum("type", true, app_enums_1.enums.OrganizationFeedbackType, raw.type);
            validator.validateEnum("status", true, app_enums_1.enums.OrganizationFeedbackStatus, raw.status);
            validator.validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                end: raw.dateRange.endDateTime,
                startOptional: false,
                endOptional: false,
            });
            validator.finalize();
            this.type = raw.type;
            this.status = raw.status;
            this.caption = raw.caption;
            this.pagination = raw.pagination;
            this.dateRange = raw.dateRange;
        }
    }
    RestUserApiV1.ListSelfFeedbackRequest = ListSelfFeedbackRequest;
    class ListFeedbackRequest extends ListSelfFeedbackRequest {
        constructor(raw, validator) {
            super(raw, validator);
            validator.validateUUID("requestUserId", true, raw.requestUserId);
            validator.finalize();
            this.requestUserId = raw.requestUserId;
        }
    }
    RestUserApiV1.ListFeedbackRequest = ListFeedbackRequest;
    class AccessControlPointRemoteOrderState {
        constructor(raw, validator) {
            validator.validateUUID("accessControlPointId", false, raw.accessControlPointId);
            validator.finalize();
            this.stateList = raw.stateList;
            this.accessControlPointId = raw.accessControlPointId;
        }
    }
    RestUserApiV1.AccessControlPointRemoteOrderState = AccessControlPointRemoteOrderState;
    class OrganizationUserDefinedListRequest {
        constructor(raw, validator) {
            validator.validateUUID("relatedValueId", true, raw.relatedValueId);
            validator.finalize();
            this.type = raw.type;
            this.relatedValueId = raw.relatedValueId;
        }
    }
    RestUserApiV1.OrganizationUserDefinedListRequest = OrganizationUserDefinedListRequest;
    class OrganizationUpsertUserDefinedListValueRequest {
        constructor(raw, validator) {
            validator.validateUUID("id", true, raw.id);
            validator.finalize();
            this.id = raw.id;
            this.value = raw.value;
            this.relatedValueId = raw.relatedValueId;
        }
    }
    RestUserApiV1.OrganizationUpsertUserDefinedListValueRequest = OrganizationUpsertUserDefinedListValueRequest;
    class FloorPlanListFilter {
        constructor(raw, validator) {
            validator.validateString({
                field: "name",
                optional: true,
                input: raw.name,
                minLength: 1,
                maxLength: 255,
            });
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
            this.name = raw.name;
        }
    }
    RestUserApiV1.FloorPlanListFilter = FloorPlanListFilter;
    class AddForbiddenStatusRequest {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateUUID("regionId", true, raw.regionId);
            validator.validateUUIDArray("credentialIds", true, raw.credentialIds);
            validator.finalize();
            this.regionId = raw.regionId;
            this.startUtc = raw.startUtc;
            this.endUtc = raw.endUtc;
            this.userId = raw.userId;
            this.note = raw.note;
            this.credentialIds = raw.credentialIds;
        }
    }
    RestUserApiV1.AddForbiddenStatusRequest = AddForbiddenStatusRequest;
    class UpdateForbiddenStatusRequest {
        constructor(raw, validator) {
            validator.validateUUID("regionId", true, raw.regionId);
            validator.validateUUIDArray("credentialIds", true, raw.credentialIds);
            validator.finalize();
            this.regionId = raw.regionId;
            this.startUtc = raw.startUtc;
            this.endUtc = raw.endUtc;
            this.note = raw.note;
            this.credentialIds = raw.credentialIds;
        }
    }
    RestUserApiV1.UpdateForbiddenStatusRequest = UpdateForbiddenStatusRequest;
    class ForbiddenListRequest {
        constructor(raw, validator) {
            validator.validateUUID("userId", true, raw.userId);
            validator.validateUUID("regionId", true, raw.regionId);
            validator.finalize();
            this.regionId = raw.regionId;
            this.startUtc = raw.startUtc;
            this.endUtc = raw.endUtc;
            this.userId = raw.userId;
            this.pagination = raw.pagination;
            this.note = raw.note;
            this.credentialData = raw.credentialData;
            this.searchMethod = raw.searchMethod;
            this.hasOrganizationWideRight = false;
            this.permittedUnitIds = [];
        }
    }
    RestUserApiV1.ForbiddenListRequest = ForbiddenListRequest;
    class AddUserGroupRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "name",
                optional: false,
                input: raw.name,
                maxLength: 255,
            })
                .validateString({
                field: "colorCode",
                optional: false,
                input: raw.colorCode,
                minLength: 6,
                maxLength: 8,
            })
                .validateUUID("organizationUnitId", true, raw.organizationUnitId)
                .finalize();
            this.name = raw.name;
            this.colorCode = raw.colorCode;
            this.organizationUnitId = raw.organizationUnitId;
        }
    }
    RestUserApiV1.AddUserGroupRequest = AddUserGroupRequest;
    class UpdateUserGroupRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "name",
                optional: false,
                input: raw.name,
                maxLength: 255,
            })
                .validateString({
                field: "colorCode",
                optional: false,
                input: raw.colorCode,
                minLength: 6,
                maxLength: 8,
            })
                .validateUUID("organizationUnitId", true, raw.organizationUnitId)
                .validateInteger({ field: "capacity", optional: true, input: raw.capacity })
                .finalize();
            this.name = raw.name;
            this.colorCode = raw.colorCode;
            this.organizationUnitId = raw.organizationUnitId;
            this.capacity = raw.capacity;
        }
    }
    RestUserApiV1.UpdateUserGroupRequest = UpdateUserGroupRequest;
    class UpdateUserGroupUserMappingsRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("addedUserIds", false, raw.addedUserIds).validateUUIDArray("removedUserIds", false, raw.removedUserIds).finalize();
            this.addedUserIds = raw.addedUserIds;
            this.removedUserIds = raw.removedUserIds;
        }
    }
    RestUserApiV1.UpdateUserGroupUserMappingsRequest = UpdateUserGroupUserMappingsRequest;
    class ChangePasswordOfIdentity {
        constructor(raw, validator) {
            validator
                .validateUUID("id", false, raw.id)
                .validateString({
                field: "password",
                optional: false,
                input: raw.password,
                minLength: 6,
                maxLength: 32,
            })
                .finalize();
            this.id = raw.id;
            this.password = raw.password;
        }
    }
    RestUserApiV1.ChangePasswordOfIdentity = ChangePasswordOfIdentity;
    class ChangeMyPasswordRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "oldPassword",
                optional: false,
                input: raw.oldPassword,
                minLength: 6,
                maxLength: 32,
            })
                .validateString({
                field: "newPassword",
                optional: false,
                input: raw.newPassword,
                minLength: 6,
                maxLength: 32,
            })
                .finalize();
            this.newPassword = raw.newPassword;
            this.oldPassword = raw.oldPassword;
        }
    }
    RestUserApiV1.ChangeMyPasswordRequest = ChangeMyPasswordRequest;
    class UpdateUsernameRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "username",
                optional: false,
                input: raw.username,
                minLength: 3,
                maxLength: 127,
            })
                .finalize();
            this.username = raw.username;
        }
    }
    RestUserApiV1.UpdateUsernameRequest = UpdateUsernameRequest;
    class RemoteControlCommand {
        constructor(raw, validatorHelper) {
            validatorHelper.validateUUID("accessControlPointId", false, raw.accessControlPointId);
            validatorHelper.validateUUID("userId", true, raw.userId);
            validatorHelper.validateEnum("direction", true, app_enums_1.enums.AccessDirection, raw.direction);
            validatorHelper.validateIsBoolean("qr", true, raw.qr);
            this.accessControlPointId = raw.accessControlPointId;
            this.direction = raw.direction || app_enums_1.enums.AccessDirection.All;
            this.qr = raw.qr || false;
            this.userId = raw.userId;
        }
    }
    RestUserApiV1.RemoteControlCommand = RemoteControlCommand;
    class AddAccessPointRequest {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "name",
                optional: false,
                input: raw.name,
                minLength: 3,
                maxLength: 255,
            })
                .validateString({
                field: "location",
                optional: true,
                input: raw.location,
                maxLength: 255,
            })
                .validateEnum("accessControlPointType", false, app_enums_1.enums.AccessControlPointType, raw.accessControlPointType)
                .validateUUID("deviceId", true, raw.deviceId)
                .validateObject("typedGeoLocation", true, raw.typedGeoLocation, new api_validatorhelper_1.ValidatorHelper()
                .validateEnum("typedGeoLocation.type", false, app_enums_1.enums.GeoLocationType, raw.typedGeoLocation?.type)
                .validateFloat("typedGeoLocation.latitude", true, raw.typedGeoLocation?.latitude)
                .validateFloat("typedGeoLocation.longitude", true, raw.typedGeoLocation?.longitude)
                .validateFloat("typedGeoLocation.radius", true, raw.typedGeoLocation?.radius)
                .validateObjectArray("typedGeoLocation.points", true, raw.typedGeoLocation?.points));
            this.deviceId = raw.deviceId ? raw.deviceId : null;
            this.name = raw.name;
            this.location = raw.location ? raw.location : null;
            this.remoteAvailable = raw.remoteAvailable === true;
            this.isRemoteDefault = raw.isRemoteDefault === true;
            this.accessControlPointType = raw.accessControlPointType;
            this.authenticationFactors = raw.authenticationFactors ? raw.authenticationFactors : null;
            this.defaultPrivileges = raw.defaultPrivileges;
            this.typedGeoLocation = raw.typedGeoLocation;
            if (this.defaultPrivileges) {
                if (this.defaultPrivileges.config && this.defaultPrivileges.grant && !this.defaultPrivileges.read) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
                if (!this.defaultPrivileges.read &&
                    !this.defaultPrivileges.grant &&
                    !this.defaultPrivileges.access &&
                    !this.defaultPrivileges.config &&
                    !this.defaultPrivileges.remoteAccess &&
                    !this.defaultPrivileges.snapshot) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.BAD_REQUEST, "ERRORS.GENERAL.ACCESSRIGHTERROR");
                }
            }
        }
    }
    RestUserApiV1.AddAccessPointRequest = AddAccessPointRequest;
    class UpdateAccessPointRequest extends AddAccessPointRequest {
        constructor(raw, validator) {
            super(raw, validator);
            validator.validateUUID("id", false, raw.id);
            this.id = raw.id;
            validator.finalize();
        }
    }
    RestUserApiV1.UpdateAccessPointRequest = UpdateAccessPointRequest;
    function updateAccessControlPointMappingRequest(raw, validator) {
        validator
            .validateUUIDArray("mappedRelayIds", false, raw.mappedRelayIds)
            .validateUUIDArray("mappedRelayIds", false, raw.mappedRelayIds)
            .validateUUIDArray("unmappedRelayIds", false, raw.unmappedRelayIds)
            .validateUUIDArray("mappedStatusSensorIds", false, raw.mappedStatusSensorIds)
            .validateUUIDArray("unmappedStatusSensorIds", false, raw.unmappedStatusSensorIds)
            .validateUUIDArray("mappedExitButtonIds", false, raw.mappedExitButtonIds)
            .validateUUIDArray("unmappedExitButtonIds", false, raw.unmappedExitButtonIds)
            .validateUUIDArray("mappedWiegandReaderIds", false, raw.mappedWiegandReaderIds)
            .validateUUIDArray("unmappedWiegandReaderIds", false, raw.unmappedWiegandReaderIds)
            .validateUUIDArray("mappedCounterSensorIds", false, raw.mappedCounterSensorIds)
            .validateUUIDArray("unmappedCounterSensorIds", false, raw.unmappedCounterSensorIds)
            .validateUUIDArray("mappedHikVisionLicencePlateReaderLaneId", false, raw.unmappedCounterSensorIds)
            .validateUUIDArray("unmappedHikVisionLicencePlateReaderLaneId", false, raw.unmappedCounterSensorIds)
            .validateUUIDArray("mappedImpinjSpeedWayGateWayAntennaId", false, raw.unmappedCounterSensorIds)
            .validateUUIDArray("unmappedImpinjSpeedWayGateWayAntennaId", false, raw.unmappedCounterSensorIds)
            .finalize();
        return {
            mappedRelayIds: raw.mappedRelayIds,
            unmappedRelayIds: raw.unmappedRelayIds,
            mappedStatusSensorIds: raw.mappedStatusSensorIds,
            unmappedStatusSensorIds: raw.unmappedStatusSensorIds,
            mappedExitButtonIds: raw.mappedExitButtonIds,
            unmappedExitButtonIds: raw.unmappedExitButtonIds,
            mappedWiegandReaderIds: raw.mappedWiegandReaderIds,
            unmappedWiegandReaderIds: raw.unmappedWiegandReaderIds,
            mappedCounterSensorIds: raw.mappedCounterSensorIds,
            unmappedCounterSensorIds: raw.unmappedCounterSensorIds,
            mappedHikVisionLicencePlateReaderLaneId: raw.mappedHikVisionLicencePlateReaderLaneId,
            unmappedHikVisionLicencePlateReaderLaneId: raw.unmappedHikVisionLicencePlateReaderLaneId,
            mappedImpinjSpeedWayGateWayAntennaId: raw.mappedImpinjSpeedWayGateWayAntennaId,
            unmappedImpinjSpeedWayGateWayAntennaId: raw.unmappedImpinjSpeedWayGateWayAntennaId,
        };
    }
    RestUserApiV1.updateAccessControlPointMappingRequest = updateAccessControlPointMappingRequest;
    function updateStatusSensorRequest(raw, validator) {
        validator
            .validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        })
            .validateInteger({
            field: "timeOut",
            optional: true,
            input: raw.timeOut,
            min: 1,
            max: 3600,
        })
            .finalize();
        return {
            name: raw.name,
            timeOut: raw.timeOut,
        };
    }
    RestUserApiV1.updateStatusSensorRequest = updateStatusSensorRequest;
    function updateRelayRequest(raw, validator) {
        validator
            .validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        })
            .validateInteger({
            field: "driveDuration",
            optional: false,
            input: raw.driveDuration,
            min: 1,
            max: 1155,
        })
            .finalize();
        return {
            name: raw.name,
            driveDuration: raw.driveDuration,
        };
    }
    RestUserApiV1.updateRelayRequest = updateRelayRequest;
    function UpdateImpinjSpeedWayGateWayAntennaRequest(raw, validator) {
        validator
            .validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        })
            .validateInteger({
            field: "number",
            optional: false,
            input: raw.number,
            min: 1,
            max: 255,
        })
            .validateInteger({
            field: "recurrentAttemptTimeout",
            optional: false,
            input: raw.recurrentAttemptTimeout,
            min: 1,
            max: 1155,
        })
            .finalize();
        return {
            name: raw.name,
            number: raw.number,
            recurrentAttemptTimeout: raw.recurrentAttemptTimeout,
        };
    }
    RestUserApiV1.UpdateImpinjSpeedWayGateWayAntennaRequest = UpdateImpinjSpeedWayGateWayAntennaRequest;
    function UpdateHikVisionLicensePlateCameraLaneRequest(raw, validator) {
        validator
            .validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        })
            .validateInteger({
            field: "number",
            optional: false,
            input: raw.number,
            min: 1,
            max: 255,
        })
            .validateInteger({
            field: "recurrentAttemptTimeout",
            optional: false,
            input: raw.recurrentAttemptTimeout,
            min: 1,
            max: 1155,
        })
            .finalize();
        return {
            name: raw.name,
            number: raw.number,
            recurrentAttemptTimeout: raw.recurrentAttemptTimeout,
        };
    }
    RestUserApiV1.UpdateHikVisionLicensePlateCameraLaneRequest = UpdateHikVisionLicensePlateCameraLaneRequest;
    function updateWiegandReaderRequest(raw, validator) {
        validator
            .validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        })
            .validateString({
            field: "location",
            optional: true,
            input: raw.location,
            maxLength: 255,
        });
        return {
            name: raw.name,
            location: raw.location,
            recurrentAttemptTimeout: raw.recurrentAttemptTimeout,
        };
    }
    RestUserApiV1.updateWiegandReaderRequest = updateWiegandReaderRequest;
    function updateCounterSensorRequest(raw, validator) {
        validator.validateString({
            field: "name",
            optional: false,
            input: raw.name,
            maxLength: 255,
        });
        return {
            name: raw.name,
        };
    }
    RestUserApiV1.updateCounterSensorRequest = updateCounterSensorRequest;
    class AccessRuleSetUpsertRequest {
        constructor(raw, validator) {
            validator.validateUUID("id", true, raw.id);
            validator.validateDate("startUtc", true, raw.startUtc);
            validator.validateDate("endUtc", true, raw.endUtc);
            validator.validateObject("region", false, raw.region, validator.validateUUID("region.id", false, raw.region.id));
            validator.validateDateRange(["startUtc", "endUtc"], {
                endOptional: true,
                startOptional: true,
                end: raw.endUtc,
                start: raw.startUtc,
            });
            validator.finalize();
            this.id = raw.id;
            this.name = raw.name;
            this.regionId = raw.region.id;
            this.uncoveredAccessStatus = raw.uncoveredAccessStatus;
            this.isActive = raw.isActive;
            this.startUtc = raw.startUtc ? raw.startUtc : null;
            this.endUtc = raw.endUtc ? raw.endUtc : null;
            this.note = raw.note ? raw.note : null;
        }
    }
    RestUserApiV1.AccessRuleSetUpsertRequest = AccessRuleSetUpsertRequest;
    class AccessRuleUpsertRequest {
        constructor(raw, validator) {
            validator
                .validateUUID("id", true, raw.id)
                .validateEnum("direction", false, app_enums_1.enums.AccessDirection, raw.direction)
                .validateEnum("type", false, app_enums_1.enums.AccessRuleType, raw.type)
                .validateEnum("acceptStatus", false, app_enums_1.enums.AccessRuleAcceptStatus, raw.acceptStatus);
            this.id = raw.id;
            this.direction = raw.direction;
            this.type = raw.type;
            this.acceptStatus = raw.acceptStatus;
            if (this.type == app_enums_1.enums.AccessRuleType.CountBased) {
                this.parameters = {
                    maximumAccessCount: raw.parameters.maximumAccessCount,
                };
            }
            else if (this.type === app_enums_1.enums.AccessRuleType.CapacityBased) {
                validator.validateObjectArray("parameters.capacityItems", false, raw.parameters.capacityItems);
                if (this.direction !== app_enums_1.enums.AccessDirection.All) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.CONFLICT, "ERRORS.ACCESS_RULE.ACCESS_DIRECTION_SELECTION_NOT_VALID");
                }
                if (this.acceptStatus !== app_enums_1.enums.AccessRuleAcceptStatus.Accept) {
                    throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.CONFLICT, "ERRORS.ACCESS_RULE.ACCEPT_STATUS_SELECTION_NOT_VALID");
                }
                this.parameters = raw.parameters.capacityItems;
            }
            else if (this.type === app_enums_1.enums.AccessRuleType.TimeBased) {
                validator.validateDateWithFormat("endTime", true, "HH:mm", raw.parameters.endTime);
                validator.validateDateWithFormat("startTime", true, "HH:mm", raw.parameters.startTime);
                validator.validateEnumArray("days", true, dal_constants_1.DalConstants.DayOfWeekForWorking, raw.parameters.days);
                this.parameters = {
                    days: raw.parameters.days,
                    endTime: raw.parameters.endTime,
                    startTime: raw.parameters.startTime,
                };
                if (!raw.parameters.startTime || !raw.parameters.endTime) {
                    (0, dal_access_error_1.throwDbAccessBadRequestError)("no date found on parameters");
                }
            }
            else {
                validator.validateDateWithFormat("endTime", true, "HH:mm", raw.parameters.endTime);
                validator.validateDateWithFormat("startTime", true, "HH:mm", raw.parameters.startTime);
                validator.validateEnumArray("days", true, dal_constants_1.DalConstants.DayOfWeekForWorking, raw.parameters.days);
                this.parameters = {
                    days: raw.parameters.days,
                    endTime: raw.parameters.endTime,
                    startTime: raw.parameters.startTime,
                    maximumAccessCount: raw.parameters.maximumAccessCount,
                };
                if (!raw.parameters.startTime || !raw.parameters.endTime) {
                    (0, dal_access_error_1.throwDbAccessBadRequestError)("no date found on parameters");
                }
            }
            validator.finalize();
        }
    }
    RestUserApiV1.AccessRuleUpsertRequest = AccessRuleUpsertRequest;
    class AccessRuleSetAssignRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("userGroupIds", false, raw.userGroupIds);
            validator.finalize();
            this.userGroupIds = raw.userGroupIds ?? [];
        }
    }
    RestUserApiV1.AccessRuleSetAssignRequest = AccessRuleSetAssignRequest;
    class GenericDeviceInfoResponse {
    }
    RestUserApiV1.GenericDeviceInfoResponse = GenericDeviceInfoResponse;
    class DeviceInfoUpdateRequest {
    }
    RestUserApiV1.DeviceInfoUpdateRequest = DeviceInfoUpdateRequest;
    class ListTerminalsRequest {
        constructor(raw, validator) {
            validator.validateEnum("brand", true, raw.brand);
            validator.validateUUIDArray("deviceIds", true, raw.deviceIds);
            validator.finalize();
            this.pagination = raw.pagination;
            this.brand = raw.brand;
            this.model = raw.model;
            this.name = raw.name;
            this.deviceIds = raw.deviceIds;
            this.warningLevel = raw.warningLevel;
            this.connectionStatus = raw.connectionStatus;
        }
    }
    RestUserApiV1.ListTerminalsRequest = ListTerminalsRequest;
    class ListAdaptersRequest {
        constructor(raw, validator) {
            this.pagination = raw.pagination;
            this.type = raw.type;
            this.number = raw.number;
        }
    }
    RestUserApiV1.ListAdaptersRequest = ListAdaptersRequest;
    class SearchIdentityExactRequest {
        constructor(raw, validator) {
            if (raw.userOrganization) {
                validator.validateUUID("roleId", true, raw.userOrganization.roleId);
            }
            this.user = raw.user;
            this.userOrganization = raw.userOrganization;
            this.userOrganizationProfile = raw.userOrganizationProfile;
            this.userOrganizationCredential = raw.userOrganizationCredential;
            this.userGroup = raw.userGroup;
            this.organizationUnit = raw.organizationUnit;
            this.createdDate = raw.createdDate;
            this.workplan = raw.workplan;
            this.take = raw.take;
            this.skip = raw.skip;
        }
    }
    RestUserApiV1.SearchIdentityExactRequest = SearchIdentityExactRequest;
    class TerminalEventsReportRequest {
        constructor(raw, validator) {
            validator.validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                startOptional: false,
                end: raw.dateRange.endDateTime,
                endOptional: false,
            });
            validator.validatePaginationRequest("pagination", raw.pagination, false);
            validator.validateEnum("event", false, app_enums_1.enums.TerminalEventType, raw.event);
            validator.finalize();
            this.pagination = raw.pagination;
            this.event = raw.event;
            this.dateRange = raw.dateRange;
            this.terminalIds = raw.terminalIds;
        }
    }
    RestUserApiV1.TerminalEventsReportRequest = TerminalEventsReportRequest;
    class SensorEventsReportRequest {
        constructor(raw, validator) {
            validator.validateDateRange(["startDateTime", "endDateTime"], {
                start: raw.dateRange.startDateTime,
                startOptional: false,
                end: raw.dateRange.endDateTime,
                endOptional: false,
            });
            validator.validatePaginationRequest("pagination", raw.pagination, false);
            validator.validateUUIDArray("sensorIds", true, raw.sensorIds);
            validator.validateUUIDArray("terminalDeviceIds", true, raw.terminalDeviceIds);
            validator.finalize();
            this.pagination = raw.pagination;
            this.terminalDeviceIds = raw.terminalDeviceIds;
            this.sensorIds = raw.sensorIds;
            this.dateRange = raw.dateRange;
            this.type = raw.type;
            this.state = raw.state;
            this.reason = raw.reason;
        }
    }
    RestUserApiV1.SensorEventsReportRequest = SensorEventsReportRequest;
    class SensorInformationReportRequest {
        constructor(raw, validator) {
            validator.validatePaginationRequest("pagination", raw.pagination, false);
            validator.validateUUIDArray("sensorIds", true, raw.sensorIds);
            validator.validateUUIDArray("terminalDeviceIds", true, raw.terminalDeviceIds);
            validator.validateUUIDArray("regionIds", true, raw.regionIds);
            validator.finalize();
            this.pagination = raw.pagination;
            this.terminalDeviceIds = raw.terminalDeviceIds;
            this.sensorIds = raw.sensorIds;
            this.regionIds = raw.regionIds;
            this.type = raw.type;
            this.state = raw.state;
            this.reason = raw.reason;
        }
    }
    RestUserApiV1.SensorInformationReportRequest = SensorInformationReportRequest;
    class SendMessageRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("attachmentIds", true, raw.attachmentIds);
            validator.finalize();
            this.subject = raw.subject;
            this.body = raw.body;
            this.attachmentIds = raw.attachmentIds;
        }
    }
    RestUserApiV1.SendMessageRequest = SendMessageRequest;
    class SearchCredentialRequest {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds)
                .validateUUIDArray("userIds", true, raw.userIds)
                .validateUUIDArray("userGroupIds", true, raw.userGroupIds)
                .validatePaginationRequest("pagination", raw.pagination, false);
            if (raw.dateRange) {
                validator.validateDateRange(["startDateTime", "endDateTime"], {
                    start: raw.dateRange.startDateTime,
                    end: raw.dateRange.endDateTime,
                    startOptional: true,
                    endOptional: true,
                });
            }
            this.pagination = raw.pagination;
            this.userIds = raw.userIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.userGroupIds = raw.userGroupIds;
            this.data = raw.data;
            this.credentialType = raw.credentialType;
            this.dateRange = raw.dateRange;
            this.filterUsersHierarchically = raw.filterUsersHierarchically;
            this.searchMethod = raw.searchMethod || app_enums_1.enums.SearchMethod.Exact;
            this.userOrganizationStatus = raw.userOrganizationStatus || app_enums_1.enums.IdentityStatusType.All;
            validator.finalize();
        }
    }
    RestUserApiV1.SearchCredentialRequest = SearchCredentialRequest;
    class ListPrivilegedUsersRequest {
        constructor(raw, validator) {
            this.take = raw.take;
            this.skip = raw.skip;
            this.grant = raw.grant;
            this.read = raw.read;
            this.config = raw.config;
            this.snapshot = raw.snapshot;
            this.remoteAccess = raw.remoteAccess;
        }
    }
    RestUserApiV1.ListPrivilegedUsersRequest = ListPrivilegedUsersRequest;
    class AddAccessRightForUserRequest {
        constructor(raw, validator) {
            this.addedAccessRights = raw.addedAccessRights;
        }
    }
    RestUserApiV1.AddAccessRightForUserRequest = AddAccessRightForUserRequest;
    class AddAccessRightForUserResponse {
    }
    RestUserApiV1.AddAccessRightForUserResponse = AddAccessRightForUserResponse;
    class UpsertAdministrator {
        constructor(raw, validator) {
            this.userId = raw.userId;
            this.userRights = raw.userRights;
        }
    }
    RestUserApiV1.UpsertAdministrator = UpsertAdministrator;
    class TerminalAdministratorsList {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
        }
    }
    RestUserApiV1.TerminalAdministratorsList = TerminalAdministratorsList;
    class ListRegionAdministratorsRequest {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
        }
    }
    RestUserApiV1.ListRegionAdministratorsRequest = ListRegionAdministratorsRequest;
    class AuditIdentityActionHistory {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            this.dateRange = raw.dateRange;
            this.actionUserIds = raw.actionUserIds;
            this.modifiedUserIds = raw.modifiedUserIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically;
            this.actionType = raw.actionType;
            validator.finalize();
        }
    }
    RestUserApiV1.AuditIdentityActionHistory = AuditIdentityActionHistory;
    class AuditAccessControlPointActionHistory {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            this.dateRange = raw.dateRange;
            this.actionUserIds = raw.actionUserIds;
            this.acpIds = raw.acpIds;
            this.actionType = raw.actionType;
            this.regionIds = raw.regionIds;
            validator.finalize();
        }
    }
    RestUserApiV1.AuditAccessControlPointActionHistory = AuditAccessControlPointActionHistory;
    class AuditTerminalActionHistory {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            this.dateRange = raw.dateRange;
            this.actionUserIds = raw.actionUserIds;
            this.terminalIds = raw.terminalIds;
            this.actionType = raw.actionType;
            validator.finalize();
        }
    }
    RestUserApiV1.AuditTerminalActionHistory = AuditTerminalActionHistory;
    class RegionList {
        constructor(raw, validator) {
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            validator.finalize();
            this.filter = raw.filter;
        }
    }
    RestUserApiV1.RegionList = RegionList;
    class MobileAccess {
        constructor(raw, validator) {
            validator
                .validateString({
                field: "credentialData",
                optional: true,
                input: raw.credentialData,
            })
                .validateEnum("direction", false, app_enums_1.enums.AccessDirection, raw.direction)
                .validateIsBoolean("isvisitor", true, raw.isVisitor)
                .validateUUID("userId", true, raw.userId)
                .finalize();
            this.credentialData = raw.credentialData;
            this.direction = raw.direction;
            this.isVisitor = raw.isVisitor;
            this.userId = raw.userId;
        }
    }
    RestUserApiV1.MobileAccess = MobileAccess;
    class UpdateUserSettingsRequestVal {
        constructor(raw, validator) {
            validator.validateString({ field: "locale", optional: true, input: raw.actionUtc, maxLength: 2 });
            validator.validateIsBoolean("notification.mediumSettings.general.email", true, raw.notification?.mediumSettings?.general?.email);
            validator.validateIsBoolean("notification.mediumSettings.general.sms", true, raw.notification?.mediumSettings?.general?.sms);
            validator.validateIsBoolean("notification.mediumSettings.general.web", true, raw.notification?.mediumSettings?.general?.web);
            validator.validateIsBoolean("notification.mediumSettings.general.pushNotification", true, raw.notification?.mediumSettings?.general?.pushNotification);
            validator.validateEnum("notification.mediumSettings.custom.type", true, restapi_1.NotificationType, raw.notification?.mediumSettings?.custom?.type);
            validator.validateIsBoolean("notification.mediumSettings.custom.mediums.email", true, raw.notification?.mediumSettings?.custom?.mediums?.email);
            validator.validateIsBoolean("notification.mediumSettings.custom.mediums.sms", true, raw.notification?.mediumSettings?.custom?.mediums?.sms);
            validator.validateIsBoolean("notification.mediumSettings.custom.mediums.web", true, raw.notification?.mediumSettings?.custom?.mediums?.web);
            validator.validateIsBoolean("notification.mediumSettings.custom.mediums.pushNotification", true, raw.notification?.mediumSettings?.custom?.mediums?.pushNotification);
            this.locale = raw.locale;
            this.notification = raw.notification;
            validator.finalize();
        }
    }
    RestUserApiV1.UpdateUserSettingsRequestVal = UpdateUserSettingsRequestVal;
    class ApplyUserSelectionSessionWithUnitRole {
        constructor(raw, validator) {
            validator.validateUUID("roleId", true, raw.roleId);
            validator.validateObject("acpAuthorize", true, raw.acpAuthorize, validator);
            validator.validateIsBoolean("removeDefaultAccessRights", true, raw.removeDefaultAccessRights);
            if (raw.acpAuthorize) {
                validator
                    .validateObjectArray("acpAuthorize.accessRights", false, raw.acpAuthorize.accessRights)
                    .validateEnum("acpAuthorize.scope", false, app_enums_1.enums.UserSelectionSessionAccessControlPointRightScope, raw.acpAuthorize.scope);
                for (const item of raw.acpAuthorize.accessRights) {
                    validator
                        .validateIsBoolean("acpAuthorize.accessRights.read", false, item.read)
                        .validateIsBoolean("acpAuthorize.accessRights.grant", false, item.grant)
                        .validateIsBoolean("acpAuthorize.accessRights.access", false, item.access)
                        .validateIsBoolean("acpAuthorize.accessRights.config", false, item.config)
                        .validateIsBoolean("acpAuthorize.accessRights.remoteAccess", false, item.remoteAccess)
                        .validateIsBoolean("acpAuthorize.accessRights.snapshot", false, item.snapshot)
                        .validateUUID("acpAuthorize.accessRights.id", false, item.id);
                }
            }
            validator.finalize();
            this.roleId = raw.roleId;
            this.acpAuthorize = raw.acpAuthorize;
            this.removeDefaultAccessRights = raw.removeDefaultAccessRights;
        }
    }
    RestUserApiV1.ApplyUserSelectionSessionWithUnitRole = ApplyUserSelectionSessionWithUnitRole;
    class AddAccessRightsToUser {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("accessPointIds", false, raw.accessPointIds)
                .validateIsBoolean("force", true, raw.force)
                .validateObject("accessRight", false, raw.accessRight, new api_validatorhelper_1.ValidatorHelper()
                .validateIsBoolean("accessRight.access", true, raw.accessRight.access)
                .validateIsBoolean("accessRight.remoteAccess", true, raw.accessRight.remoteAccess)
                .validateIsBoolean("accessRight.read", true, raw.accessRight.read)
                .validateIsBoolean("accessRight.grant", true, raw.accessRight.grant)
                .validateIsBoolean("accessRight.config", true, raw.accessRight.config)
                .validateIsBoolean("accessRight.snapshot", true, raw.accessRight.snapshot));
            validator.finalize();
            if (!(raw.accessRight.access || raw.accessRight.remoteAccess || raw.accessRight.read || raw.accessRight.grant || raw.accessRight.config || raw.accessRight.snapshot)) {
                (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)(`ERRORS.IDENTITY.AT_LEAST_ONE_ACCESS_RIGHT`);
            }
            else if ((raw.accessRight.grant || raw.accessRight.config || raw.accessRight.snapshot) && !raw.accessRight.read) {
                (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)(`ERRORS.IDENTITY.NEED_READ_PERMISSION`);
            }
            this.accessRight = raw.accessRight;
            this.accessPointIds = raw.accessPointIds;
        }
    }
    RestUserApiV1.AddAccessRightsToUser = AddAccessRightsToUser;
    class UpdateAccessRightsToUser {
        constructor(raw, validator) {
            validator
                .validateUUIDArray("accessPointIds", false, raw.accessPointIds)
                .validateIsBoolean("force", true, raw.force)
                .validateObject("accessRight", false, raw.accessRight, new api_validatorhelper_1.ValidatorHelper()
                .validateIsBoolean("accessRight.access", true, raw.accessRight.access)
                .validateIsBoolean("accessRight.remoteAccess", true, raw.accessRight.remoteAccess)
                .validateIsBoolean("accessRight.read", true, raw.accessRight.read)
                .validateIsBoolean("accessRight.grant", true, raw.accessRight.grant)
                .validateIsBoolean("accessRight.config", true, raw.accessRight.config)
                .validateIsBoolean("accessRight.snapshot", true, raw.accessRight.snapshot));
            validator.finalize();
            if (raw.accessRight.access === undefined &&
                raw.accessRight.remoteAccess === undefined &&
                raw.accessRight.read === undefined &&
                raw.accessRight.grant === undefined &&
                raw.accessRight.config === undefined &&
                raw.accessRight.snapshot === undefined) {
                (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)(`ERRORS.IDENTITY.AT_LEAST_ONE_ACCESS_RIGHT`);
            }
            else if ((raw.accessRight.grant || raw.accessRight.config || raw.accessRight.snapshot) && raw.accessRight.read === false) {
                (0, dal_access_error_1.throwDbAccessBadRequestErrorTr)(`ERRORS.IDENTITY.NEED_READ_PERMISSION`);
            }
            this.accessRight = raw.accessRight;
            this.accessPointIds = raw.accessPointIds;
        }
    }
    RestUserApiV1.UpdateAccessRightsToUser = UpdateAccessRightsToUser;
    class DeleteAccessRightsToUser {
        constructor(raw, validator) {
            validator.validateUUIDArray("accessPointIds", false, raw.accessPointIds);
            validator.finalize();
            this.accessPointIds = raw.accessPointIds;
        }
    }
    RestUserApiV1.DeleteAccessRightsToUser = DeleteAccessRightsToUser;
    class ListTerminalChangesRequest {
        constructor(raw, validator) {
            validator.validatePaginationRequest("pagination", raw.pagination, true);
            validator.finalize();
            this.pagination = raw.pagination;
        }
    }
    RestUserApiV1.ListTerminalChangesRequest = ListTerminalChangesRequest;
    class SyncTerminalsRequest {
        constructor(raw, validator) {
            validator.validateIsBoolean("applyToAll", false, raw.applyToAll);
            this.applyToAll = raw.applyToAll;
            if (!this.applyToAll) {
                validator.validateUUIDArray("terminalIds", false, raw.terminalIds);
                validator.validateArrayLength("terminalIds", false, 1, 10000, raw.terminalIds);
                this.terminalIds = raw.terminalIds;
            }
            validator.finalize();
        }
    }
    RestUserApiV1.SyncTerminalsRequest = SyncTerminalsRequest;
    class CheckUserRightsRequest {
        constructor(raw, validator) {
            validator.validateIsArrayOfString("permissions", false, raw.permissions);
            validator.finalize();
            this.permissions = raw.permissions;
        }
    }
    RestUserApiV1.CheckUserRightsRequest = CheckUserRightsRequest;
    class InsertUsersIntoGroup {
        constructor(raw, validator) {
            validator.validateUUIDArray("userIds", false, raw.userIds).finalize();
            this.userIds = raw.userIds;
        }
    }
    RestUserApiV1.InsertUsersIntoGroup = InsertUsersIntoGroup;
    class AssignCredentialToUser {
        constructor(raw, validator) {
            validator.validateObjectArray("credentials", false, raw.credentials).finalize();
            for (const credential of raw.credentials) {
                validator.validateObject("credentials", false, credential, new api_validatorhelper_1.ValidatorHelper()
                    .validateEnum("credential.type", false, app_enums_1.enums.CredentialType, credential.type)
                    .validateString({
                    field: "credential.data",
                    optional: false,
                    input: credential.data,
                    minLength: 3,
                    maxLength: 1023,
                })
                    .validateString({
                    field: "credential.credentialNumber",
                    optional: true,
                    input: credential.credentialNumber,
                    maxLength: 31,
                })
                    .validateDate("credential.expirationUtc", true, credential.expirationUtc));
            }
            this.credentials = raw.credentials;
        }
    }
    RestUserApiV1.AssignCredentialToUser = AssignCredentialToUser;
    class UnassignCredentialToUser {
        constructor(raw, validator) {
            validator.validateUUID("credentialIds", false, raw.credentialIds).finalize();
            this.credentialIds = raw.credentialIds;
        }
    }
    RestUserApiV1.UnassignCredentialToUser = UnassignCredentialToUser;
    class ListCheckInTabletApprovements {
        constructor(raw, validator) {
            validator
                .validatePaginationRequest("pagination", { take: raw.pagination.take, skip: raw.pagination.skip }, false, 100)
                .validateEnum("status", false, restapi_1.TabletApprovementStatus, raw.status)
                .validateString({
                field: "filter",
                optional: true,
                input: raw.filter,
                maxLength: 64,
                minLength: 3,
            })
                .finalize();
            this.pagination = raw.pagination;
            this.filter = raw.filter;
            this.status = raw.status;
        }
    }
    RestUserApiV1.ListCheckInTabletApprovements = ListCheckInTabletApprovements;
    class ApprovePendingTablet {
        constructor(raw, validator) {
            validator
                .validateUUID("id", false, raw.id)
                .validateString({ field: "referenceCode", optional: false, input: raw.referenceCode, maxLength: 32 })
                .validateString({ field: "approvementCode", optional: true, input: raw.approvementCode, maxLength: 32 })
                .finalize();
            this.id = raw.id;
            this.referenceCode = raw.referenceCode;
            this.approvementCode = raw.approvementCode;
        }
    }
    RestUserApiV1.ApprovePendingTablet = ApprovePendingTablet;
})(RestUserApiV1 = exports.RestUserApiV1 || (exports.RestUserApiV1 = {}));
