"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerminalModelsV1 = void 0;
const app_enums_1 = require("../../../app.enums");
var TerminalModelsV1;
(function (TerminalModelsV1) {
    class ActionSnapshotRequest {
        constructor(raw, validator) {
            validator.validateUUID("sid", false, raw.sid);
            validator.finalize();
            this.sid = raw.sid;
            this.image = raw.image;
        }
    }
    TerminalModelsV1.ActionSnapshotRequest = ActionSnapshotRequest;
    class FingerPrintRegistryItem {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateUUID("credentialId", false, raw.credentialId);
            validator.validateEnum("finger", false, app_enums_1.enums.FingerIndex, raw.finger);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.finger = raw.finger;
            this.type = raw.type;
            this.specialData = raw.specialData;
            this.credentialId = raw.credentialId;
            this.specialDataSecondary = raw.specialDataSecondary;
        }
    }
    TerminalModelsV1.FingerPrintRegistryItem = FingerPrintRegistryItem;
    class RemoveFingerPrint {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateEnum("finger", false, app_enums_1.enums.FingerIndex, raw.finger);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.finger = raw.finger;
            this.type = raw.type;
        }
    }
    TerminalModelsV1.RemoveFingerPrint = RemoveFingerPrint;
    class AddNewFaceRecogniseCredentialRequest {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateUUID("credentialId", false, raw.credentialId);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.type = raw.type;
            this.specialData = raw.specialData;
            this.credentialId = raw.credentialId;
            this.specialDataSecondary = raw.specialDataSecondary;
        }
    }
    TerminalModelsV1.AddNewFaceRecogniseCredentialRequest = AddNewFaceRecogniseCredentialRequest;
    class InsertNewCredentialRequest {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateUUID("credentialId", false, raw.credentialId);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.type = raw.type;
            this.specialData = raw.specialData;
            this.credentialId = raw.credentialId;
            this.specialDataSecondary = raw.specialDataSecondary;
            this.data = raw.data;
            this.finger = raw.finger;
        }
    }
    TerminalModelsV1.InsertNewCredentialRequest = InsertNewCredentialRequest;
    class RemoveFaceRecogniseCredentialRequest {
        constructor(raw, validator) {
            validator.validateUUID("userId", false, raw.userId);
            validator.validateEnum("type", false, app_enums_1.enums.CredentialType, raw.type);
            this.userId = raw.userId;
            this.type = raw.type;
        }
    }
    TerminalModelsV1.RemoveFaceRecogniseCredentialRequest = RemoveFaceRecogniseCredentialRequest;
})(TerminalModelsV1 = exports.TerminalModelsV1 || (exports.TerminalModelsV1 = {}));
