"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.refreshUsersSummaryForToday = void 0;
const fs = __importStar(require("fs"));
const moment_1 = __importDefault(require("moment"));
const moment_range_1 = require("moment-range");
const app_config_1 = require("../../../../app.config");
const app_enums_1 = require("../../../../app.enums");
const app_logs_1 = require("../../../../app.logs");
const business_pacs_claim_1 = require("../../../../business/pacs/business.pacs.claim");
const report_util_1 = require("../../../../business/report/report.util");
const dal_manager_1 = require("../../../../dal/dal.manager");
const messageBroker_server_to_pacs_pub_1 = require("../../../../messageBroker/messageBroker.server-to-pacs.pub");
const messageBroker_server_to_report_pub_1 = require("../../../../messageBroker/messageBroker.server-to-report.pub");
const api_error_1 = require("../../../api.error");
const api_models_common_1 = require("../../../api.models.common");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_pacs_v1_models_1 = require("../../v1/api.pacs.v1.models");
const api_pacs_v2_models_1 = require("../api.pacs.v2.models");
const luxon_1 = require("luxon");
const refreshUsersSummaryForToday = async function (params) {
    return new Promise(async (resolve, reject) => {
        await (0, messageBroker_server_to_pacs_pub_1.sendToPacsRpcQueue)({
            message: {
                i: "",
                v: "1",
                a: 0,
                n: app_enums_1.enums.AmqpMessageCode.RelcalculateFilteredPACSEmployees,
                o: params.organizationId,
                d: {
                    r: params.requesterUserId,
                    a: params.applyOrganizationUnitFilterHierarchically,
                    g: params.userGroupIds,
                    o: params.organizationId,
                    n: params.organizationUnitIds,
                    s: params.userOrganizationStatus,
                    u: params.userIds,
                    p: params.requiredOrganizationWidePermissions,
                    pu: params.requiredOrganizationUnitWidePermissions,
                },
            },
            expiration: 10000,
            callback: () => resolve(),
        });
    });
};
exports.refreshUsersSummaryForToday = refreshUsersSummaryForToday;
module.exports.getEmployeeWorkPlan = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== userId) {
        (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    const request = new api_pacs_v1_models_1.RestPacsApiV1.DateRange(req.body, new api_validatorhelper_1.ValidatorHelper());
    const result = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        request.endDateTime = (0, moment_1.default)(request.endDateTime).add(1, "day").toDate();
        return await dal_manager_1.dbManager.accessPacs2.getEmployeeWorkPlan(trx, organizationId, userId, request);
    }, requesterUserId, organizationId);
    res.json(result);
});
module.exports.getPlanningCalendar = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.PlanningCalendarRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    const dbResult = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return await dal_manager_1.dbManager.accessPacs2.getPlanningCalendar(trx, organizationId, authResult.userId, {
            pagination: request.pagination,
            range: {
                startDateTime: request.range.startDateTime,
                endDateTime: request.range.endDateTime,
            },
            userIds: request.userIds,
            workPlanIds: request.workPlanIds,
            userGroupIds: request.userGroupIds,
            organizationUnitIds: request.organizationUnitIds,
            applyOrganizationUnitFilterHierarchically: request.applyOrganizationUnitFilterHierarchically,
        });
    }, authResult.userId, organizationId);
    res.json(dbResult);
});
module.exports.getPlanningCalendarExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.PlanningCalendarRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        const reportResult = await new Promise((resolve, reject) => {
            delete request.pagination;
            const options = request;
            options.range = request.range;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsPlanningCalendar,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, "Çalışma_Takvimi_" + (0, moment_1.default)(request.range.startDateTime).format("YYYY_MM_DD") + "_" + (0, moment_1.default)(request.range.endDateTime).format("YYYY_MM_DD") + ".xlsx", (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getCumulativeStatisticsOfOrganizationUnit = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let organizationUnitId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.ouid.value, "organizationUnitId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.DateRange(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.cumulativeStatisticsOfOrganizationUnit(authResult.userId, organizationId, organizationUnitId, request);
    res.json(result);
});
module.exports.getListofDistributedEmployeesAtDateTime = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.ListOfDistributedEmployeesAtDateTimeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.listOfDistributedEmployeesAtDateTime(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.getListofDistributedEmployeesAtDateTimeExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.ListOfDistributedEmployeesAtDateTimeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        const reportResult = await new Promise((resolve, reject) => {
            delete request.paginationRequest;
            const options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.InstantAttendanceStatus,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, "Çalışma_Raporu_" + (0, moment_1.default)(request.dateTime).format("YYYY_MM_DD") + ".xlsx", (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getListofCumulativeEmployeesAtDateTime = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.ListOfCumulativeEmployeesAtDateTimeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.listOfCumulativeEmployeesAtDateTime(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.getScoreStatisticsOfEmployeesInDateRange = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.ScoreStatisticsOfEmployeesInDateRangeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.scoreStatisticsOfEmployeesInDateRange(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.getCumulativeStatsOfEmployeesAtDate = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.CumulativeStatisticsOfEmployeesAtDateRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.cumulativeStatisticsOfEmployeesAtDate(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.workingDetailsOfFilteredEmployeesAtDateExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkingDetailsOfFilteredEmployeesRequest(req.body, app_config_1.appConfig.reportExportRowLimit, new api_validatorhelper_1.ValidatorHelper());
    try {
        if ((0, moment_1.default)(request.date).isSame((0, moment_1.default)(), "day")) {
            await (0, exports.refreshUsersSummaryForToday)({
                requesterUserId: authResult.userId,
                applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
                userGroupIds: request.userFilter.userGroupIds,
                organizationId: organizationId,
                organizationUnitIds: request.userFilter.organizationUnitIds,
                userIds: request.userFilter.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                userOrganizationStatus: request.userFilter.userOrganizationStatus,
            });
        }
        let reportResult = await new Promise((resolve, reject) => {
            delete request.paginationRequest;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsDailyWorkingHours,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, "Çalışma_Raporu_" + (0, moment_1.default)(request.date).format("YYYY_MM_DD") + ".xlsx", (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.workingDetailsOfFilteredEmployeesAtDatePdf = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkingDetailsOfFilteredEmployeesRequest(req.body, app_config_1.appConfig.reportExportRowLimit, new api_validatorhelper_1.ValidatorHelper());
    try {
        if ((0, moment_1.default)(request.date).isSame((0, moment_1.default)(), "day")) {
            await (0, exports.refreshUsersSummaryForToday)({
                requesterUserId: authResult.userId,
                applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
                userGroupIds: request.userFilter.userGroupIds,
                organizationId: organizationId,
                organizationUnitIds: request.userFilter.organizationUnitIds,
                userIds: request.userFilter.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                userOrganizationStatus: request.userFilter.userOrganizationStatus,
            });
        }
        let reportResult = await new Promise((resolve, reject) => {
            delete request.paginationRequest;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsDailyWorkingHours,
                format: app_enums_1.enums.ReportFormat.Pdf,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, "Çalışma_Raporu_" + (0, moment_1.default)(request.date).format("YYYY_MM_DD") + ".xlsx", (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.workingDetailsOfFilteredEmployeesAtDate = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkingDetailsOfFilteredEmployeesRequest(req.body, 100, new api_validatorhelper_1.ValidatorHelper());
    if ((0, moment_1.default)(request.date).isSame((0, moment_1.default)(), "day")) {
        try {
            await (0, exports.refreshUsersSummaryForToday)({
                requesterUserId: authResult.userId,
                applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
                userGroupIds: request.userFilter.userGroupIds,
                organizationId: organizationId,
                organizationUnitIds: request.userFilter.organizationUnitIds,
                userIds: request.userFilter.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                userOrganizationStatus: request.userFilter.userOrganizationStatus,
            });
        }
        catch (error) {
            res.status(500).send();
            return;
        }
    }
    let result = await dal_manager_1.dbManager.accessPacs2.workSummaryOfFilteredEmployeesAtDate(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.getWorkingDetailsSummaryForUsers = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReportForAny)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.DateRangeSummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    if ((0, moment_1.default)(request.dateRange.endDateTime).isSame((0, moment_1.default)(), "day")) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.jwt.userId,
            applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter.organizationUnitIds,
            userIds: request.userFilter.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    let result = await dal_manager_1.dbManager.accessPacs2.getFirstInLastOutSummaryForUsers(organizationId, authResult.jwt.userId, {
        startDate: request.dateRange.startDateTime,
        endDate: request.dateRange.endDateTime,
        organizationUnitIds: request.userFilter.organizationUnitIds,
        organizationUnitHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
        userGroupIds: request.userFilter.userGroupIds,
        userIds: request.userFilter.userIds,
        workPlanIds: request.userFilter.workPlanIds,
        status: request.userFilter.userOrganizationStatus,
        sortType: request.sortType,
        sortOrder: request.sortOrder,
        workStatusFilter: request.userFilter.workStatusFilter,
        take: request.pagination?.take,
        skip: request.pagination?.skip,
    });
    res.json(result);
});
module.exports.getWorkingDetailsSummaryForUsersExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReportForAny)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.DateRangeSummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    if ((0, moment_1.default)(request.dateRange.endDateTime).isSame((0, moment_1.default)(), "day")) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.jwt.userId,
            applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter.organizationUnitIds,
            userIds: request.userFilter.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    try {
        let reportResult = await new Promise((resolve, reject) => {
            delete request.pagination;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsFirstInLastOutSummaryMultipleUsers,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.jwt.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report daily first in last out summary excel report is ready in " + reportResult.duration + " ms.");
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.workingDetailsOfEmployeeInDateRangeExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkingDetailsOfEmployeeRequestExcel(req.body, new api_validatorhelper_1.ValidatorHelper());
    if (new moment_range_1.DateRange(request.dateRange.startDateTime, request.dateRange.endDateTime).contains((0, moment_1.default)().startOf("day"))) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.userId,
            organizationId: organizationId,
            userIds: [request.userId],
        });
    }
    try {
        let reportResult = await new Promise((resolve, reject) => {
            delete request.pagination;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsEmployeeWorkingHoursSummary,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, "Çalışan_Çalışma_Raporu.xlsx", (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.workingDetailsOfEmployeeInDateRange = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkSummaryOfEmployeeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    let authResult;
    if (requesterUserId !== request.userId) {
        authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    else {
        authResult = (0, api_securityhelper_1.authorizeForAccessSelfReports)(req, organizationId).jwt;
    }
    if (new moment_range_1.DateRange(request.dateRange.startDateTime, request.dateRange.endDateTime).contains((0, moment_1.default)().startOf("day"))) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.userId,
            organizationId: organizationId,
            userIds: [request.userId],
        });
    }
    let result = await dal_manager_1.dbManager.accessPacs2.workSummaryOfEmployeeInDateRange(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.workSummaryOfFilteredEmployeesInDateRange = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReportForAny)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.DateRangeSummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    if ((0, moment_1.default)(request.dateRange.endDateTime).isSame((0, moment_1.default)(), "day")) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.jwt.userId,
            applyOrganizationUnitFilterHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter.organizationUnitIds,
            userIds: request.userFilter.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    let result = await dal_manager_1.dbManager.accessPacs2.workSummaryOfFilteredEmployeesInDateRange(organizationId, authResult.jwt.userId, {
        startDate: request.dateRange.startDateTime,
        endDate: request.dateRange.endDateTime,
        organizationUnitIds: request.userFilter.organizationUnitIds,
        organizationUnitHierarchically: request.userFilter.applyOrganizationUnitFilterHierarchically,
        userGroupIds: request.userFilter.userGroupIds,
        userIds: request.userFilter.userIds,
        workPlanIds: request.userFilter.workPlanIds,
        status: request.userFilter.userOrganizationStatus,
        sortType: request.sortType,
        sortOrder: request.sortOrder,
        workStatusFilter: request.userFilter.workStatusFilter,
        take: request.pagination?.take,
        skip: request.pagination?.skip,
        userFilter: request.userFilter,
        extFieldKey: request.customSearch ? Object.keys(request.customSearch)[0] : null,
        extFieldValue: request.customSearch ? Object.values(request.customSearch)[0] : null,
    });
    res.json(result);
});
module.exports.employeeDayDetailed = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let request = new api_pacs_v2_models_1.RestPacsApiV2.EmployeeDayDetailedRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== request.userId) {
        (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    let result = await dal_manager_1.dbManager.accessPacs2.employeeDayDetailed(requesterUserId, organizationId, request.userId, request.date);
    res.json(result);
});
module.exports.employeeDayDetailedOld = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let request = new api_pacs_v2_models_1.RestPacsApiV2.EmployeeDayDetailedRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== request.userId) {
        (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    let result = await dal_manager_1.dbManager.accessPacs2.employeeDayDetailed(requesterUserId, organizationId, request.userId, request.date);
    res.json(result);
});
module.exports.getCurrentStateForUser = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== userId) {
        let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    let result = await dal_manager_1.dbManager.accessPacs2.employeeCurrentState(requesterUserId, organizationId, userId, new Date());
    res.json(result);
});
module.exports.getCurrentStateForUserAtTime = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let request = new api_pacs_v1_models_1.RestPacsApiV1.EmployeeStateRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== userId) {
        let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    request.timestamp = new Date();
    let result = await dal_manager_1.dbManager.accessPacs2.employeeCurrentState(requesterUserId, organizationId, userId, request.timestamp);
    res.json(result);
});
module.exports.getDistributionOfEmployeesAtDateTime = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.DistributionOfEmployeesAtDateTimeRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = await dal_manager_1.dbManager.accessPacs2.getDistributionOfEmployeesAtDateTime(authResult.userId, organizationId, request);
    res.json(result);
});
module.exports.getPPermissionClaimInfoOfEmployeeExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    let authResult;
    if (requesterUserId !== userId) {
        authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    try {
        let request = new api_pacs_v2_models_1.RestPacsApiV2.PPermissionClaimInfoOfEmployeeRequest(req.body, userId, new api_validatorhelper_1.ValidatorHelper());
        let reportResult = await new Promise(async (resolve, reject) => {
            delete request.pagination;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.EmployeePermissionUsage,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult?.userId || userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getPPermissionClaimInfoOfEmployee = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (requesterUserId !== userId) {
        let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    let request = new api_pacs_v2_models_1.RestPacsApiV2.PPermissionClaimInfoOfEmployeeRequest(req.body, userId, new api_validatorhelper_1.ValidatorHelper());
    let ppermissionTypes = (await dal_manager_1.dbManager.accessPacs.listPPermissionTypes(organizationId, {
        take: 1000,
        skip: 0,
    })).items;
    let result = {
        pagination: {
            take: request.pagination.take,
            skip: request.pagination.skip,
            total: 0,
        },
        ppermissionInfo: null,
        items: [],
    };
    let userEmploymentInfo;
    if (!request.startDay) {
        userEmploymentInfo = await dal_manager_1.dbManager.accessUser.getUserOrganizationProfileEmploymentInfo(organizationId, userId);
        if (!userEmploymentInfo.employmentStartUtc) {
            let modules = await dal_manager_1.dbManager.accessOrganization.listOrganizationModules(organizationId);
            let pacsModule = modules.find((m) => m.module === app_enums_1.enums.ArmonApplicationModule.PACS);
            if (!pacsModule) {
                res.json("pacs module is not enabled");
            }
            userEmploymentInfo.employmentStartUtc = pacsModule.enableUtc || new Date();
        }
        request.startDay = (0, moment_1.default)(userEmploymentInfo.employmentStartUtc).toDate();
    }
    if (!request.endDay) {
        request.endDay = new Date();
    }
    if (!userEmploymentInfo) {
        userEmploymentInfo = await dal_manager_1.dbManager.accessUser.getUserOrganizationProfileEmploymentInfo(organizationId, userId);
    }
    let ppt = ppermissionTypes.find((permissionType) => permissionType.id === request.ppermissionTypeId);
    let usage = await (0, business_pacs_claim_1.getPPermissionTypeUsageOfUserBetweenDates)(organizationId, userId, ppt.id, request.startDay, request.endDay);
    let factor = ppt.isDailyScheduled ? app_enums_1.enums.PPermissionUsageFactor.DailyPermissionUsageFactor : app_enums_1.enums.PPermissionUsageFactor.HourlyPermissionUsageFactor;
    result.ppermissionInfo = ppt;
    result.pagination.total = usage.periods.length;
    if (usage && usage.periods && usage.periods.length > 0) {
        usage.periods.sort(function (a, b) {
            if (a["startDate"] > b["startDate"])
                return 1;
            else if (a["startDate"] < b["startDate"])
                return -1;
            return 0;
        });
        let skipCounter = 0;
        let filterRange = new moment_range_1.DateRange(request.startDay, request.endDay);
        for (const iterator of usage.periods) {
            if (skipCounter != request.pagination.skip) {
                skipCounter++;
                continue;
            }
            let itemToPush = {
                usage: iterator.usage !== null ? iterator.usage / factor : null,
                rollOverToNextPeriod: iterator.remaining !== null ? iterator.remaining / factor : null,
                newlyClaimed: iterator.claim !== null ? iterator.claim / factor : null,
                leftFromPreviousPeriod: iterator.fromPreviousPeriod !== null ? iterator.fromPreviousPeriod / factor : null,
                startDate: iterator.periodStart,
                endDate: iterator.periodEnd,
            };
            if (ppt.type === app_enums_1.enums.PredefinedPPermissionType.Annual) {
                let now = (0, moment_1.default)();
                if ((0, moment_1.default)(iterator.periodStart) < now && (0, moment_1.default)(iterator.periodEnd) > now) {
                    result.annualPermissionCurrentStatus = {
                        leftOverPermissionCount: usage.ppermissionClaimProfile === app_enums_1.enums.PPermissionClaimProfile.Manual ? userEmploymentInfo.manuallyRemainedAnnualPermission : iterator.remaining,
                        nextPeriodStartDate: (0, moment_1.default)(iterator.periodStart).add(1, "year").add(iterator.unpaidLeaveOffset, "day").toDate(),
                        nextPeriodClaim: iterator.nextClaim,
                        ppermissionClaimProfile: usage.ppermissionClaimProfile,
                    };
                }
            }
            let periodRange = new moment_range_1.DateRange(iterator.periodStart, iterator.periodEnd);
            if (periodRange.overlaps(filterRange) && result.items.length < request.pagination.take)
                result.items.push(itemToPush);
        }
    }
    res.json(result);
});
module.exports.ppermissionClaimInfoReportForEmployees = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.EmployeesPPermissionClaimReportRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let result = {
        pagination: {
            take: request.pagination.take,
            skip: request.pagination.skip,
            total: 0,
        },
        ppermissionInfo: null,
        items: [],
    };
    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        const users = await dal_manager_1.dbManager.accessUser.getFilteredUserIds(organizationId, {
            pagination: request.pagination,
            ppermissionTypeId: request.ppermissionTypeId,
            userGroupIds: request.userGroupIds,
            organizationUnitIds: request.organizationUnitIds,
            userIds: request.userIds,
            applyOrganizationUnitFilterHierarchically: request.applyOrganizationUnitFilterHierarchically,
            userOrganizationStatus: request.userOrganizationStatus,
        }, trx);
        const getUserCaptionsLines = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(organizationId, users.items.map((elem) => elem.id));
        const ppermissionTypeUsage = await (0, business_pacs_claim_1.getUsersPPermissionsTypeUsageOfBetweenDates)(organizationId, users.items.map((elem) => elem.id), request.ppermissionTypeId, trx);
        let factor = ppermissionTypeUsage.permissionTypeInfo.isDailyScheduled
            ? app_enums_1.enums.PPermissionUsageFactor.DailyPermissionUsageFactor
            : app_enums_1.enums.PPermissionUsageFactor.HourlyPermissionUsageFactor;
        result.ppermissionInfo = ppermissionTypeUsage.permissionTypeInfo;
        result.pagination = users.pagination;
        for (const userPeriods of ppermissionTypeUsage.userPeriods) {
            const user = users.items.find((elem) => elem.id === userPeriods.userId);
            const basicUserInfo = {
                id: user.id,
                fullname: user.fullname,
                uniqueId: user.uniqueId,
                userCaptions: getUserCaptionsLines.find((elem) => elem.id === user.id).captionLines,
                orgTitle: user.orgTitle,
            };
            if (ppermissionTypeUsage.permissionTypeInfo.type === app_enums_1.enums.PredefinedPPermissionType.Annual) {
                if (userPeriods.periods.length > 0) {
                    const lastPeriod = userPeriods.periods[0];
                    result.items.push({
                        user: basicUserInfo,
                        permissionClaimInfo: {
                            usage: lastPeriod.usage !== null ? lastPeriod.usage / factor : null,
                            startDate: lastPeriod.periodStart,
                            endDate: lastPeriod.periodEnd,
                            newlyClaimed: lastPeriod.claim !== null ? lastPeriod.claim / factor : null,
                            leftFromPreviousPeriod: lastPeriod.fromPreviousPeriod !== null ? lastPeriod.fromPreviousPeriod / factor : null,
                            remaining: userPeriods.periods[0].remaining !== null ? userPeriods.periods[0].remaining / factor : null,
                            nextPeriodStartDate: (0, moment_1.default)(userPeriods.periods[0].periodStart).add(1, "year").add(userPeriods.periods[0].unpaidLeaveOffset, "day").toDate(),
                            nextPeriodClaim: userPeriods.periods[0].nextClaim,
                            ppermissionClaimProfile: ppermissionTypeUsage.ppermissionClaimProfile,
                            manuallyRemainedAnnualPermission: user.manuallyRemainedAnnualPermission,
                        },
                    });
                }
                else {
                    result.items.push({
                        user: basicUserInfo,
                    });
                }
            }
            else {
                if (userPeriods.periods.length > 0) {
                    const lastPeriod = userPeriods.periods[0];
                    result.items.push({
                        user: basicUserInfo,
                        permissionClaimInfo: {
                            usage: lastPeriod.usage !== null ? lastPeriod.usage / factor : null,
                            startDate: lastPeriod.periodStart,
                            endDate: lastPeriod.periodEnd,
                            newlyClaimed: lastPeriod.claim !== null ? lastPeriod.claim / factor : null,
                            leftFromPreviousPeriod: lastPeriod.fromPreviousPeriod !== null ? lastPeriod.fromPreviousPeriod / factor : null,
                            remaining: userPeriods.periods[0].remaining !== null ? userPeriods.periods[0].remaining / factor : null,
                            manuallyRemainedAnnualPermission: user.manuallyRemainedAnnualPermission,
                        },
                    });
                }
                else {
                    result.items.push({
                        user: basicUserInfo,
                    });
                }
            }
        }
        result.items.sort((userName, userNameSec) => {
            const nameA = userName.user.fullname.toUpperCase();
            const nameB = userNameSec.user.fullname.toUpperCase();
            if (nameA < nameB) {
                return -1;
            }
            if (nameA > nameB) {
                return 1;
            }
            return 0;
        });
        res.json(result);
    });
});
module.exports.ppermissionClaimInfoReportForEmployeesExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.EmployeesPPermissionClaimReportRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        let reportResult = await new Promise(async (resolve, reject) => {
            delete request.pagination;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PermissionClaimUsagesForEmployees,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: request,
                organizationId: organizationId,
                requesterUserId: authResult?.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getWorksForUsers = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    const request = new api_pacs_v2_models_1.RestPacsApiV2.WorksOfUsersRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        const missingWorkUsers = await dal_manager_1.dbManager.accessPacs2.getWorksForUsers(organizationId, authResult.userId, {
            filterOrganizationUnitMembersHierarchically: request.filterOrganizationUnitMembersHierarchically,
            pagination: request.pagination,
            userIds: request.userIds,
            range: request.range,
            workPlanIds: request.workPlanIds,
            userGroupIds: request.userGroupIds,
            organizationUnitIds: request.organizationUnitIds,
            type: request.type,
        });
        res.json(missingWorkUsers);
    }
    catch (error) {
        res.status(500).json({
            message: error.message || error,
        });
    }
});
module.exports.getWorkSegmentsOfUser = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorksOfUsersRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        if (new moment_range_1.DateRange(request.range.startDateTime, request.range.endDateTime).contains((0, moment_1.default)().startOf("day"))) {
            await (0, exports.refreshUsersSummaryForToday)({
                requesterUserId: authResult.userId,
                organizationId: organizationId,
                userIds: [userId],
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            });
        }
        let result = await dal_manager_1.dbManager.accessPacs2.getUserWorkSegments(organizationId, userId, request.type, request.pagination, request.range);
        return res.json(result);
    }
    catch (error) {
        res.status(500).json({
            message: error.message || error,
        });
    }
});
module.exports.getHistoryOfMonthlyReportOfOrganization = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let year = req.swagger.params.year.value;
    let month = req.swagger.params.month.value;
    let paginationRequest = new api_models_common_1.ApiModelsCommon.PaginationRequest(req.body.pagination, 100, new api_validatorhelper_1.ValidatorHelper(), true);
    if (!paginationRequest || paginationRequest.skip === null || paginationRequest.take === null) {
        throw new Error("Request must contain pagination");
    }
    let dbResult = await dal_manager_1.dbManager.accessLogPacs.getHistoryOfMonthlyReportOfOrganization(organizationId, year, month, paginationRequest);
    res.json({
        pagination: dbResult.pagination,
        items: dbResult.items.map((i) => {
            return {
                isFinalized: i.isFinalized,
                updatedBy: i.updatedBy
                    ? {
                        id: i.updatedBy.id,
                        fullname: i.updatedBy.fullname,
                        uniqueId: i.updatedBy.uniqueId,
                        captionLines: i.updatedBy.captionLines,
                    }
                    : {},
                updatedDateTime: i.updateDateTime,
                note: i.note,
            };
        }),
    });
});
module.exports.getApprovementOfMonthlyReportOfOrganization = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let year = req.swagger.params.year.value;
    let month = req.swagger.params.month.value;
    let dbResult = await dal_manager_1.dbManager.accessLogPacs.getApprovementOfMonthlyReportOfOrganization(organizationId, year, month);
    res.status(200).json(dbResult);
});
module.exports.finalizeMonthlyReportOfOrganization = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendancePlanWrite)(req, organizationId);
    let year = req.swagger.params.year.value;
    let month = req.swagger.params.month.value;
    let dbResult = await dal_manager_1.dbManager.accessPacs.finalizeMonthlyReportOfOrganization(organizationId, year, month, authResult.jwt.userId, req.body.note);
    if (!dbResult) {
        next((0, api_error_1.generateNotFoundApiError)({ message: "could not finalize report" }));
        return;
    }
    res.status(200).json();
});
module.exports.updateMonthlyReportOfUser = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendancePlanWrite)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.UpdateMonthlyReportOfUserRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    let dbResult = await dal_manager_1.dbManager.accessPacs2.updateMonthlyReportOfUser(organizationId, request.year, request.month, request.userId, {
        checked: request.checked,
        note: request.note,
        missedWorkDuration: request.working.missedWorkDuration,
        extraWorkDuration: request.working.extraWorkDuration,
        normalWorkDuration: request.working.normalWorkDuration,
        updateUserId: authResult.jwt.userId,
    });
    if (!dbResult) {
        next((0, api_error_1.generateNotFoundApiError)({ message: "could not update user monthly report" }));
        return;
    }
    res.json();
});
module.exports.listMonthlyReport = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let validatorHelper = new api_validatorhelper_1.ValidatorHelper();
    const request = new api_pacs_v2_models_1.RestPacsApiV2.MonthlySummaryFilter(req.body, validatorHelper);
    validatorHelper.finalize();
    const requesterUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    if (!(request.userFilter?.userIds?.length === 1 && request.userFilter?.userIds[0] === requesterUserId)) {
        (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    }
    let begin;
    let end;
    const dateFilter = request.dateFilter;
    if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Annually && dateFilter.year) {
        begin = luxon_1.DateTime.fromObject({ year: dateFilter.year, month: 1, day: 1 }).startOf("year");
        end = begin.endOf("year");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly && dateFilter.month) {
        begin = luxon_1.DateTime.fromObject({ year: dateFilter.year, month: dateFilter.month, day: 1 }).startOf("month");
        end = begin.endOf("month");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Whole && dateFilter.range?.startDateTime && dateFilter.range?.endDateTime) {
        begin = luxon_1.DateTime.fromJSDate(new Date(dateFilter.range.startDateTime)).startOf("day");
        end = luxon_1.DateTime.fromJSDate(new Date(dateFilter.range.endDateTime)).endOf("day");
    }
    if (luxon_1.Interval.fromDateTimes(begin, end).contains(luxon_1.DateTime.now())) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: requesterUserId,
            applyOrganizationUnitFilterHierarchically: request.userFilter?.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter?.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter?.organizationUnitIds,
            userIds: request.userFilter?.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    const result = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        return await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysDateRangeFilteredWithoutCursor(organizationId, requesterUserId, {
            startDate: begin,
            endDate: end,
            workPlanIds: request.userFilter?.workPlanIds,
            userIds: request.userFilter?.userIds,
            userGroupIds: request.userFilter?.userGroupIds,
            organizationUnitIds: request.userFilter?.organizationUnitIds,
            organizationUnitHierarchically: request.userFilter?.applyOrganizationUnitFilterHierarchically,
            status: request.userFilter?.userOrganizationStatus,
        }, request.pagination, request.sortOrder, request.sortType, trx);
    }, requesterUserId, organizationId);
    res.json(result);
});
module.exports.getEmployeeMonthlyReportHistory = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.EmployeeMonthlyReportHistoryRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    if (!request.pagination || request.pagination.skip === null || request.pagination.take === null) {
        throw new Error("Request must contain pagination");
    }
    else if (request.pagination.take > 100) {
        request.pagination.take = 100;
    }
    let dbResult = await dal_manager_1.dbManager.accessPacs2.getEmployeeMonthlyReportHistory(organizationId, request.year, request.month, request.userId, request.pagination);
    res.json(dbResult);
});
module.exports.getMonthlyReportExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.MonthlySummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    let begin;
    let end;
    let dateFilter = request.dateFilter;
    if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Annually && dateFilter.year) {
        begin = (0, moment_1.default)().startOf("year").year(dateFilter.year);
        end = begin.clone().endOf("year");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly && dateFilter.month) {
        begin = (0, moment_1.default)()
            .startOf("month")
            .year(dateFilter.year)
            .month(dateFilter.month - 1);
        end = begin.clone().endOf("month");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Whole && dateFilter.range && dateFilter.range.startDateTime && dateFilter.range.endDateTime) {
        begin = (0, moment_1.default)(dateFilter.range.startDateTime);
        end = (0, moment_1.default)(dateFilter.range.endDateTime);
    }
    else
        return;
    if (new moment_range_1.DateRange(begin, end).contains((0, moment_1.default)())) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.userId,
            applyOrganizationUnitFilterHierarchically: request.userFilter?.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter?.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter?.organizationUnitIds,
            userIds: request.userFilter?.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    try {
        let reportResult = await new Promise((resolve, reject) => {
            delete request.pagination;
            let options = request;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsMonthlyWorkingHoursSummary,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report Monthly Report is ready in " + reportResult.duration + "ms");
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getMonthlyExtraWorkReportExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v2_models_1.RestPacsApiV2.MonthlySummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    let begin;
    let end;
    let dateFilter = request.dateFilter;
    if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Annually && dateFilter.year) {
        begin = (0, moment_1.default)().startOf("year").year(dateFilter.year);
        end = begin.clone().endOf("year");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly && dateFilter.month) {
        begin = (0, moment_1.default)()
            .startOf("month")
            .year(dateFilter.year)
            .month(dateFilter.month - 1);
        end = begin.clone().endOf("month");
    }
    else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Whole && dateFilter.range && dateFilter.range.startDateTime && dateFilter.range.endDateTime) {
        begin = (0, moment_1.default)(dateFilter.range.startDateTime);
        end = (0, moment_1.default)(dateFilter.range.endDateTime);
    }
    else
        return;
    if (new moment_range_1.DateRange(begin, end).contains((0, moment_1.default)())) {
        await (0, exports.refreshUsersSummaryForToday)({
            requesterUserId: authResult.userId,
            applyOrganizationUnitFilterHierarchically: request.userFilter?.applyOrganizationUnitFilterHierarchically,
            userGroupIds: request.userFilter?.userGroupIds,
            organizationId: organizationId,
            organizationUnitIds: request.userFilter?.organizationUnitIds,
            userIds: request.userFilter?.userIds,
            requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
        });
    }
    try {
        let reportResult = await new Promise((resolve, reject) => {
            let options = request;
            options.dateFilter = request.dateFilter;
            options.sortOrder = request.sortOrder;
            options.sortType = request.sortType;
            options.userFilter = request.userFilter;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsMonthlyWorkingHoursSummaryExtraWork,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report montly work summary extra work excel report is ready in " + reportResult.duration + " ms");
        if (fs.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
