"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestPacsApiV2 = void 0;
const api_models_common_1 = require("../../api.models.common");
const app_enums_1 = require("../../../app.enums");
const api_validatorhelper_1 = require("../../api.validatorhelper");
const moment_1 = __importDefault(require("moment"));
var RestPacsApiV2;
(function (RestPacsApiV2) {
    class PlanningCalendarRequest {
        constructor(raw, validator) {
            validator.validateUUIDArray("userIds", true, raw.userIds);
            validator.validateUUIDArray("workPlanIds", true, raw.workPlanIds);
            validator.validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds);
            validator.validateUUIDArray("userGroupIds", true, raw.userGroupIds);
            validator.validateIsBoolean("applyOrganizationUnitFilterHierarchically", true, raw.applyOrganizationUnitFilterHierarchically);
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            this.userIds = raw.userIds;
            this.workPlanIds = raw.workPlanIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.applyOrganizationUnitFilterHierarchically = raw.applyOrganizationUnitFilterHierarchically;
            this.userGroupIds = raw.userGroupIds;
            this.range = new api_models_common_1.ApiModelsCommon.DateRange(raw.range, validator);
            validator.finalize();
        }
    }
    RestPacsApiV2.PlanningCalendarRequest = PlanningCalendarRequest;
    class WorkSummaryRequest {
        constructor(raw, max, validator, finalize) {
            validator.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.paginationRequest = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.paginationRequest, 100, validator);
            this.sortOrder = raw.sortOrder;
            this.sortType = raw.sortType ? raw.sortType : app_enums_1.enums.WorkSummarySortType.Date;
            if (finalize) {
                validator.finalize();
            }
        }
    }
    RestPacsApiV2.WorkSummaryRequest = WorkSummaryRequest;
    class WorkingDetailsOfFilteredEmployeesRequest extends WorkSummaryRequest {
        constructor(raw, maxPaginationItem, validatorHelper) {
            super(raw, maxPaginationItem, validatorHelper);
            this.userFilter = new IdBasedUserFilter(raw.userFilter, validatorHelper);
            this.date = (0, moment_1.default)(raw.date).toDate();
            validatorHelper.finalize();
        }
    }
    RestPacsApiV2.WorkingDetailsOfFilteredEmployeesRequest = WorkingDetailsOfFilteredEmployeesRequest;
    class WorkSummaryOfEmployeeRequest extends WorkSummaryRequest {
        constructor(raw, validatorHelper) {
            super(raw, 100, validatorHelper);
            this.dateRange = new api_models_common_1.ApiModelsCommon.DateRange(raw.dateRange, validatorHelper);
            this.userId = raw.userId;
            this.userOrganizationStatus = this.userOrganizationStatus ? raw.userOrganizationStatus : app_enums_1.enums.IdentityStatusType.Enabled;
            this.workStatusFilter = raw.workStatusFilter ? raw.workStatusFilter : [];
            this.onlyWorkingDays = raw.onlyWorkingDays;
            validatorHelper.finalize();
        }
    }
    RestPacsApiV2.WorkSummaryOfEmployeeRequest = WorkSummaryOfEmployeeRequest;
    class WorkingDetailsOfEmployeeRequestExcel {
        constructor(raw, validatorHelper) {
            validatorHelper.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.dateRange = new api_models_common_1.ApiModelsCommon.DateRange(raw.dateRange, validatorHelper);
            this.userId = raw.userId;
            this.sortOrder = raw.sortOrder ? raw.sortOrder : "DESC";
            this.sortType = raw.sortType;
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validatorHelper);
            this.userOrganizationStatus = this.userOrganizationStatus ? raw.userOrganizationStatus : app_enums_1.enums.IdentityStatusType.Enabled;
            this.workStatusFilter = raw.workStatusFilter ? raw.workStatusFilter : [];
            this.onlyWorkingDays = raw.onlyWorkingDays;
        }
    }
    RestPacsApiV2.WorkingDetailsOfEmployeeRequestExcel = WorkingDetailsOfEmployeeRequestExcel;
    class EmployeeDayDetailedRequest {
        constructor(raw, validatorHelper) {
            this.date = new Date(raw.date);
            this.userId = raw.userId;
            validatorHelper.finalize();
        }
    }
    RestPacsApiV2.EmployeeDayDetailedRequest = EmployeeDayDetailedRequest;
    class DistributionOfEmployeesAtDateTimeRequest {
        constructor(raw, validatorHelper, finalize) {
            this.workPlanIds = raw.workPlanIds;
            this.idBasedUserFilter = new IdBasedUserFilter(raw.idBasedUserFilter, validatorHelper);
            this.dateTime = (0, moment_1.default)(raw.dateTime).toDate();
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.DistributionOfEmployeesAtDateTimeRequest = DistributionOfEmployeesAtDateTimeRequest;
    class IdBasedUserFilter {
        constructor(raw, validatorHelper, finalize) {
            this.userIds = raw.userIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.applyOrganizationUnitFilterHierarchically = raw.applyOrganizationUnitFilterHierarchically === true;
            this.userOrganizationStatus = raw.userOrganizationStatus;
            this.workPlanIds = raw.workPlanIds;
            this.workStatusFilter = raw.workStatusFilter;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.IdBasedUserFilter = IdBasedUserFilter;
    class DateRangeSummaryFilter {
        constructor(raw, validator) {
            validator.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.dateRange = new api_models_common_1.ApiModelsCommon.DateRange(raw.dateRange, validator);
            this.pagination = raw.paginationRequest;
            this.sortType = raw.sortType || app_enums_1.enums.WorkSummarySortType.Name;
            this.userFilter = new IdBasedUserFilter(raw.userFilter, validator);
            this.sortOrder = raw.sortOrder ? raw.sortOrder : "DESC";
            this.customSearch = raw.customSearch;
        }
    }
    RestPacsApiV2.DateRangeSummaryFilter = DateRangeSummaryFilter;
    class ListOfDistributedEmployeesAtDateTimeRequest {
        constructor(raw, validatorHelper, finalize) {
            validatorHelper.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.idBasedUserFilter = new IdBasedUserFilter(raw.idBasedUserFilter, validatorHelper);
            this.paginationRequest = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.paginationRequest, 100, validatorHelper);
            this.employeeStatusAtSegment = new EmployeeStatusAtSegment(raw.employeeStatusAtSegment, validatorHelper);
            this.dateTime = raw.dateTime ? new Date(raw.dateTime) : new Date();
            this.workPlanIds = raw.workPlanIds;
            this.sortOrder = raw.sortOrder;
            this.sortType = raw.sortType;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.ListOfDistributedEmployeesAtDateTimeRequest = ListOfDistributedEmployeesAtDateTimeRequest;
    class EmployeeStatusAtSegment {
        constructor(raw, validatorHelper, finalize) {
            this.inRegion = raw.inRegion;
            this.working = raw.working;
            this.status = raw.status;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.EmployeeStatusAtSegment = EmployeeStatusAtSegment;
    class ScoreStatisticsOfEmployeesInDateRangeRequest {
        constructor(raw, validatorHelper, finalize) {
            this.idBasedUserFilter = new IdBasedUserFilter(raw.idBasedUserFilter, validatorHelper);
            this.paginationRequest = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.paginationRequest, 100, validatorHelper);
            this.workPlanIds = raw.workPlanIds;
            this.dateRange = new api_models_common_1.ApiModelsCommon.DateRange(raw.dateRange, validatorHelper);
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.ScoreStatisticsOfEmployeesInDateRangeRequest = ScoreStatisticsOfEmployeesInDateRangeRequest;
    class CumulativeStatisticsOfEmployeesAtDateRequest {
        constructor(raw, validatorHelper, finalize) {
            this.idBasedUserFilter = new IdBasedUserFilter(raw.idBasedUserFilter, validatorHelper);
            this.date = new Date(raw.date);
            this.workPlanIds = raw.workPlanIds;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.CumulativeStatisticsOfEmployeesAtDateRequest = CumulativeStatisticsOfEmployeesAtDateRequest;
    class ListOfCumulativeEmployeesAtDateTimeRequest {
        constructor(raw, validatorHelper, finalize) {
            validatorHelper.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.idBasedUserFilter = new IdBasedUserFilter(raw.idBasedUserFilter, validatorHelper);
            this.paginationRequest = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.paginationRequest, 100, validatorHelper);
            this.dateTime = raw.dateTime ? new Date(raw.dateTime) : new Date();
            this.workPlanIds = raw.workPlanIds;
            this.sortOrder = raw.sortOrder;
            this.sortType = raw.sortType;
            this.existing = raw.existing;
            this.binaryType = raw.binaryType;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.ListOfCumulativeEmployeesAtDateTimeRequest = ListOfCumulativeEmployeesAtDateTimeRequest;
    class PPermissionClaimInfoOfEmployeeRequest {
        constructor(raw, userId, validatorHelper) {
            validatorHelper.validateUUID("ppermissionTypeId", false, raw.ppermissionTypeId);
            validatorHelper.validateDate("startDay", true, raw.startDay);
            validatorHelper.validateDate("endDay", true, raw.endDay);
            validatorHelper.validateUUID("userId", false, userId);
            validatorHelper.finalize();
            this.ppermissionTypeId = raw.ppermissionTypeId;
            this.userId = userId;
            this.pagination = {
                take: raw.pagination.take,
                skip: raw.pagination.skip,
            };
            this.startDay = raw.startDay ? raw.startDay : null;
            this.endDay = raw.endDay ? raw.endDay : null;
        }
    }
    RestPacsApiV2.PPermissionClaimInfoOfEmployeeRequest = PPermissionClaimInfoOfEmployeeRequest;
    class EmployeesPPermissionClaimReportRequest {
        constructor(raw, validatorHelper) {
            validatorHelper.validateUUID("ppermissionTypeId", false, raw.ppermissionTypeId);
            validatorHelper.validateUUIDArray("userGroupIds", true, raw.userGroupIds);
            validatorHelper.validateUUIDArray("organizationUnitIds", true, raw.organizationUnitIds);
            validatorHelper.validateUUIDArray("userIds", true, raw.userIds);
            validatorHelper.validateIsBoolean("applyOrganizationUnitFilterHierarchically", true, raw.applyOrganizationUnitFilterHierarchically);
            validatorHelper.validateEnum("userOrganizationStatus", false, app_enums_1.enums.IdentityStatusType, raw.userOrganizationStatus);
            this.pagination = {
                take: raw.pagination.take,
                skip: raw.pagination.skip,
            };
            this.ppermissionTypeId = raw.ppermissionTypeId;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.userIds = raw.userIds;
            this.applyOrganizationUnitFilterHierarchically = raw.applyOrganizationUnitFilterHierarchically;
            this.userOrganizationStatus = raw.userOrganizationStatus;
        }
    }
    RestPacsApiV2.EmployeesPPermissionClaimReportRequest = EmployeesPPermissionClaimReportRequest;
    class EmployeeMonthlyReportHistoryRequest {
        constructor(raw, validatorHelper) {
            validatorHelper.validateUUID("userId", false, raw.userId);
            validatorHelper.finalize();
            this.userId = raw.userId;
            this.pagination = {
                take: raw.pagination?.take,
                skip: raw.pagination?.skip,
            };
            this.month = raw.month ? raw.month : null;
            this.year = raw.year ? raw.year : null;
        }
    }
    RestPacsApiV2.EmployeeMonthlyReportHistoryRequest = EmployeeMonthlyReportHistoryRequest;
    class WorksOfUsersRequest {
        constructor(raw, validatorHelper, finalize) {
            this.userIds = raw.userIds;
            this.range = raw.range;
            this.workPlanIds = raw.workPlanIds;
            this.userGroupIds = raw.userGroupIds;
            this.organizationUnitIds = raw.organizationUnitIds;
            this.filterOrganizationUnitMembersHierarchically = raw.filterOrganizationUnitMembersHierarchically;
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validatorHelper);
            this.type = raw.type;
            if (finalize) {
                validatorHelper.finalize();
            }
        }
    }
    RestPacsApiV2.WorksOfUsersRequest = WorksOfUsersRequest;
    class MonthlySummaryFilter {
        constructor(raw, validator) {
            validator.validateRegex("sortOrder", raw.sortOrder, true, /(^ASC$)|(^DESC$)/);
            this.pagination = new api_models_common_1.ApiModelsCommon.PaginationRequest(raw.pagination, 100, validator);
            this.sortOrder = raw.sortOrder;
            this.sortType = raw.sortType;
            this.userFilter = raw.userFilter ? new IdBasedUserFilter(raw.userFilter, validator) : null;
            validator.validateObject("dateFilter", false, raw.dateFilter, new api_validatorhelper_1.ValidatorHelper().validateEnum("group", false, app_enums_1.enums.MonthlySummaryReportDateFilterGroup, raw.dateFilter.group));
            switch (raw.dateFilter.group) {
                case app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Annually:
                    validator.validateInteger({
                        field: "year",
                        optional: false,
                        input: raw.dateFilter.year,
                    });
                    break;
                case app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly:
                    validator.validateInteger({
                        field: "year",
                        optional: false,
                        input: raw.dateFilter.year,
                    });
                    validator.validateInteger({
                        field: "month",
                        optional: false,
                        input: raw.dateFilter.month,
                    });
                    break;
                case app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Whole:
                    validator.validateDateRange(["startDateTime", "endDateTime"], {
                        start: raw.dateFilter.range.startDateTime,
                        end: raw.dateFilter.range.endDateTime,
                        startOptional: false,
                        endOptional: false,
                    });
                    break;
            }
            this.dateFilter = raw.dateFilter && raw.dateFilter.group ? raw.dateFilter : null;
        }
    }
    RestPacsApiV2.MonthlySummaryFilter = MonthlySummaryFilter;
})(RestPacsApiV2 = exports.RestPacsApiV2 || (exports.RestPacsApiV2 = {}));
