"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const moment_1 = __importDefault(require("moment"));
const moment_range_1 = require("moment-range");
const app_config_1 = require("../../../../app.config");
const app_enums_1 = require("../../../../app.enums");
const app_logs_1 = require("../../../../app.logs");
const report_util_1 = require("../../../../business/report/report.util");
const dal_manager_1 = require("../../../../dal/dal.manager");
const messageBroker_server_to_pacs_pub_1 = require("../../../../messageBroker/messageBroker.server-to-pacs.pub");
const messageBroker_server_to_report_pub_1 = require("../../../../messageBroker/messageBroker.server-to-report.pub");
const api_securityhelper_1 = require("../../../api.securityhelper");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_pacs_v2_models_1 = require("../../v2/api.pacs.v2.models");
const api_pacs_v1_models_1 = require("../api.pacs.v1.models");
const refreshUsersSummaryForToday = async function (params) {
    return new Promise(async (resolve, reject) => {
        await (0, messageBroker_server_to_pacs_pub_1.sendToPacsRpcQueue)({
            message: {
                i: "",
                v: "1",
                a: 0,
                n: app_enums_1.enums.AmqpMessageCode.RelcalculateFilteredPACSEmployees,
                o: params.organizationId,
                d: {
                    r: params.requesterUserId,
                    a: params.applyOrganizationUnitFilterHierarchically,
                    g: params.userGroupIds,
                    o: params.organizationId,
                    n: params.organizationUnitIds,
                    s: params.userOrganizationStatus,
                    u: params.userIds,
                    p: params.requiredOrganizationWidePermissions,
                    pu: params.requiredOrganizationUnitWidePermissions,
                },
            },
            expiration: 10000,
            callback: () => resolve(),
        });
    });
};
module.exports.getDailyFirstInLastOutReportForUser = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    let request = new api_pacs_v2_models_1.RestPacsApiV2.WorkingDetailsOfEmployeeRequestExcel(req.body, new api_validatorhelper_1.ValidatorHelper());
    if (new moment_range_1.DateRange(request.dateRange.startDateTime, request.dateRange.endDateTime).contains((0, moment_1.default)().startOf("day"))) {
        await refreshUsersSummaryForToday({
            requesterUserId: authResult.userId,
            organizationId: organizationId,
            userIds: [userId],
        });
    }
    let result = await dal_manager_1.dbManager.accessPacs2.getDailySummaryReportForSingleUser(organizationId, userId, request);
    res.json(result);
});
module.exports.getDailyFirstInLastOutReportForUsersExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReportForAny)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.DailySummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        if ((0, moment_1.default)(request.date).isSame((0, moment_1.default)(), "day")) {
            await refreshUsersSummaryForToday({
                requesterUserId: authResult.jwt.userId,
                applyOrganizationUnitFilterHierarchically: request.applyOrganizationUnitFilterHierarchically,
                userGroupIds: request.userGroupIds,
                organizationId: organizationId,
                organizationUnitIds: request.organizationUnitIds,
                userIds: request.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            });
        }
        let reportResult = await new Promise((resolve, reject) => {
            delete request.pagination;
            let options = request;
            options.hasOrganizationWide = authResult.hasOrganizationWide;
            options.permittedUnitIds = authResult.permittedUnitIds;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsFirstInLastOut,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.jwt.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report getDailyFirstInLastOutReportForUsersExcel is ready in " + reportResult.duration + "ms");
        if (fs_1.default.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs_1.default.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getDailyFirstInLastOutReportForUsersPdf = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReportForAny)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.DailySummaryFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    try {
        if ((0, moment_1.default)(request.date).isSame((0, moment_1.default)(), "day")) {
            await refreshUsersSummaryForToday({
                requesterUserId: authResult.jwt.userId,
                applyOrganizationUnitFilterHierarchically: request.applyOrganizationUnitFilterHierarchically,
                userGroupIds: request.userGroupIds,
                organizationId: organizationId,
                organizationUnitIds: request.organizationUnitIds,
                userIds: request.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            });
        }
        let reportResult = await new Promise((resolve, reject) => {
            let options = request;
            options.hasOrganizationWide = authResult.hasOrganizationWide;
            options.permittedUnitIds = authResult.permittedUnitIds;
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.PacsFirstInLastOut,
                format: app_enums_1.enums.ReportFormat.Pdf,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.jwt.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report getDailyFirstInLastOutReportForUsersPdf is ready in " + reportResult.duration + "ms");
        if (fs_1.default.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs_1.default.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
module.exports.getPPermissionUsageExcel = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    let organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    let authResult = (0, api_securityhelper_1.authorizeForAttendanceControlReport)(req, organizationId);
    let request = new api_pacs_v1_models_1.RestPacsApiV1.UserFilter(req.body, new api_validatorhelper_1.ValidatorHelper());
    request.organizationUnitHierarchically = true;
    try {
        let reportResult = await new Promise((resolve, reject) => {
            let options = {
                endDateTime: request.dateRange.endDateTime,
                startDateTime: request.dateRange.startDateTime,
            };
            messageBroker_server_to_report_pub_1.amqpServerToReportPub.sendInstantReportRequest({
                code: app_enums_1.enums.ReportCode.EmployeePermissionUsage,
                format: app_enums_1.enums.ReportFormat.Excel,
                filter: options,
                organizationId: organizationId,
                requesterUserId: authResult.userId,
            }, app_config_1.appConfig.reportPdfExcelTimeoutInSeconds * 1000, (error, result) => {
                if (error) {
                    return reject(error);
                }
                resolve(result);
            });
        });
        app_logs_1.logger.info("Report Permission Usage is ready in " + reportResult.duration + "ms");
        if (fs_1.default.existsSync(reportResult.filePath)) {
            res.download(reportResult.filePath, (err) => {
                if (err) {
                    throw err;
                }
                fs_1.default.unlinkSync(reportResult.filePath);
            });
        }
        else {
            throw new Error("Timeout");
        }
    }
    catch (error) {
        app_logs_1.logger.error(error.message || error);
        (0, report_util_1.throwDbReportError)(error.message, res);
    }
});
