"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dal_manager_1 = require("../../../../dal/dal.manager");
const api_util_1 = require("../../../api.util");
const api_validatorhelper_1 = require("../../../api.validatorhelper");
const api_pacs_v1_models_1 = require("../api.pacs.v1.models");
const dal_constants_1 = require("../../../../dal/dal.constants");
const api_securityhelper_1 = require("../../../api.securityhelper");
const dal_access_error_1 = require("../../../../dal/access/dal.access.error");
const enums_1 = require("../../../../lib/access-model/v2/enums");
const dal_access_psql_log_1 = require("../../../../dal/access/psql/dal.access.psql.log");
module.exports.startMobileCheckinForUser = (0, api_util_1.globalRouteHandler)(async (req, res, next) => {
    const organizationId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.oid.value, "organizationId");
    const userId = (0, api_validatorhelper_1.validateUUID)(req.swagger.params.uid.value, "userId");
    const isCheckin = (0, api_validatorhelper_1.validateIsBoolean)(req.swagger.params.ischeckin.value, "isCheckin");
    const requestUserId = (0, api_securityhelper_1.getUserIdFromToken)(req);
    const request = new api_pacs_v1_models_1.RestPacsApiV1.MobileCheckinRequest(req.body, new api_validatorhelper_1.ValidatorHelper());
    request.timestamp = new Date();
    const userAcpInfo = await dal_manager_1.dbManager.accessAccessControlPoint.getUserMobileCheckinInformation(organizationId, userId, request.accessControlPointId);
    if (!userAcpInfo.accessControlPointId) {
        (0, dal_access_error_1.throwDbAccessNotFoundErrorTr)("ERRORS.PACS.MOBILECHECKINACPNOTFOUND");
    }
    if (!userAcpInfo.hasAccessRight) {
        (0, dal_access_error_1.throwDbAccessAuthorizationErrorTr)("ERRORS.PACS.MOBILECHECKINUNAUTHORIZED");
    }
    if (userAcpInfo.accessControlPointId === dal_constants_1.DalConstants.defaultMobileAcpId && !userAcpInfo.hasMobileWp) {
        (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.PACS.MOBILECHECKINNOMOBILEWP");
    }
    let addedLogId;
    await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
        addedLogId = await dal_manager_1.dbManager.accessLog.addMobileCheckinAccessLog({
            organizationId,
            logRequest: {
                accessControlPointId: userAcpInfo.accessControlPointId,
                accessControlPointName: userAcpInfo.accessControlPointName,
                reason: dal_constants_1.DalConstants.AccessLogReason.Success,
                userId,
                userRoleId: userAcpInfo.userRoleId,
                accessRightId: userAcpInfo.accessRightId,
                direction: isCheckin ? dal_constants_1.DalConstants.AccessDirection.Entrance : dal_constants_1.DalConstants.AccessDirection.Exit,
                actionUtc: request.timestamp,
                location: {
                    latitude: request.latitude,
                    longitude: request.longitude,
                    isReliable: request.isLocationReliable,
                },
                isQrTriggered: userAcpInfo.accessControlPointId !== dal_constants_1.DalConstants.defaultMobileAcpId,
            },
            trx,
        });
        await dal_manager_1.dbManager.accessPacs2.onEmployeeMobileCheckin({ organizationId, userId, date: request.timestamp, trx });
    }, requestUserId, organizationId);
    if (addedLogId && (isCheckin ? dal_constants_1.DalConstants.AccessDirection.Entrance : dal_constants_1.DalConstants.AccessDirection.Exit) === enums_1.EnumsV2.AccessDirection.Entrance) {
        await (0, dal_access_psql_log_1.assignAutoShift)(organizationId, {
            credentialOwnerUserId: userId,
            generationTime: request.timestamp.toISOString(),
            redisCache: dal_manager_1.dbManager.accessRedisCache,
            logId: addedLogId,
        });
    }
    res.sendStatus(200);
});
