"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiHikVisionAdapterControllerV1 = void 0;
const express_1 = __importDefault(require("express"));
const dal_manager_1 = require("../../../dal/dal.manager");
const api_auth_1 = require("../../api.auth");
const api_util_1 = require("../../api.util");
class ApiHikVisionAdapterControllerV1 {
    constructor(app) {
        this.getAdapterConfig = async (req, res) => {
            let config = await dal_manager_1.dbManager.accessDevice.getHikVisionAdapterConfigurationAndSettings(req.organizationId, req.adapterId);
            (0, api_auth_1.sendZippedJsonResponse)(config, res);
        };
        this.updateAdapterConfig = async (req, res) => {
            let request = req.body;
            let config = await dal_manager_1.dbManager.accessDevice.updateHikVisionAdapterConfigurationAndSettings(req.organizationId, req.adapterId, request);
            (0, api_auth_1.sendZippedJsonResponse)(config, res);
        };
        this.getTerminalConfig = async (req, res) => {
            let request = req.body;
            let config = await dal_manager_1.dbManager.accessDevice.getHikVisionTerminalConfigurationAndSettings(req.organizationId, req.deviceId, request.configurationAndSettings);
            (0, api_auth_1.sendZippedJsonResponse)(config, res);
        };
        this._router = express_1.default.Router();
        this._router.get("/adapter/config", api_auth_1.adapterAuthorize, (0, api_util_1.globalRouteHandler)(this.getAdapterConfig));
        this._router.post("/adapter/config", api_auth_1.adapterAuthorize, (0, api_util_1.globalRouteHandler)(this.updateAdapterConfig));
        this._router.post("/terminal/config", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.getTerminalConfig));
        app.use("/hv/v1", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiHikVisionAdapterControllerV1 = ApiHikVisionAdapterControllerV1;
