"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiControlPanelControllerV3 = void 0;
const express_1 = __importDefault(require("express"));
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const api_auth_1 = require("../../api.auth");
const api_models_common_1 = require("../../api.models.common");
const api_util_1 = require("../../api.util");
const api_validatorhelper_1 = require("../../api.validatorhelper");
class ApiControlPanelControllerV3 {
    constructor(app) {
        this.askDeviceData = async (req, res) => {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            let request = new api_models_common_1.ApiModelsCommon.AskDeviceDataZip(req.body, validator);
            validator.finalize();
            app_logs_1.logger.info("device request " + req.deviceId);
            let dbResult = await dal_manager_1.dbManager.accessDevice.getDataWithUsersForControlPanelMSeriesV2(req.organizationId, req.deviceId, request.configurationAndSettings);
            app_logs_1.logger.info(" db result " + req.deviceId);
            (0, api_auth_1.sendZippedJsonResponse)(dbResult, res);
        };
        this.updateControlPanelSettingsAndConfiguration = async (req, res) => {
            let request = req.body;
            try {
                let dbResult = await dal_manager_1.dbManager.accessDevice.updateControlPanelMSeriesDeviceConfigurationAndSettingsV2(req.deviceId, req.organizationId, request);
                res.json(dbResult);
            }
            catch (error) {
                app_logs_1.logger.error(error);
                res.status(400).json({ error: error });
            }
        };
        this._router = express_1.default.Router();
        this._router.post("/askdevicedata", api_auth_1.controlPanelAuthorize, (0, api_util_1.globalRouteHandler)(this.askDeviceData));
        this._router.post("/settingsandconfigurations", api_auth_1.controlPanelAuthorize, (0, api_util_1.globalRouteHandler)(this.updateControlPanelSettingsAndConfiguration));
        app.use("/cp/v3", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiControlPanelControllerV3 = ApiControlPanelControllerV3;
