"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasDuplicateUuids = exports.globalRouteHandler = void 0;
const dal_access_error_1 = require("../dal/access/dal.access.error");
const api_error_1 = require("./api.error");
function globalRouteHandler(fn) {
    return (req, res, next) => {
        const routePromise = fn(req, res, next);
        if (routePromise.catch) {
            routePromise.catch((error) => {
                if (error instanceof dal_access_error_1.DbAccessErrorTr) {
                    error = (0, api_error_1.generateTranslatedError)(error.errorCode, error.phrase, error.replacements, error.noReport, error.showAsModal);
                }
                else if (error instanceof dal_access_error_1.DbAccessError) {
                    res.status(error.errorCode || dal_access_error_1.DbAccessErrorCode.INTERNAL_ERROR).json({
                        message: error.message,
                    });
                }
                next(error);
            });
        }
    };
}
exports.globalRouteHandler = globalRouteHandler;
function hasDuplicateUuids(uuids) {
    if (!uuids || uuids.length === 0)
        return false;
    const validUuids = uuids.filter((uuid) => uuid != null);
    return new Set(validUuids).size !== validUuids.length;
}
exports.hasDuplicateUuids = hasDuplicateUuids;
