"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authorizeForVisitorPreregisterOrVisitorWriteRequest = exports.authorizeForListVisitorWriteRequest = exports.authorizeForSearchVisitorRequest = exports.authorizeForListVisitorReadRequest = exports.authorizeForVisitorFilterRequest = exports.authorizeForGetUserByCredentialRequest = exports.authorizeForManualLogDelete = exports.authorizeForManualLogInsert = exports.authorizeForCollectUserIdsByFieldSelect = exports.authorizeForGetVisitorByCredentialRequest = exports.authorizeForGetVisitorByIdRequest = exports.authorizeForTerminateVisitRequest = exports.authorizeForWriteRole = exports.authorizeForNewVisitRequest = exports.authorizeForManageNotifications = exports.authorizeForUserHierarchy = exports.authorizeForInsertIdentity = exports.authorizeForSystemFeedbackWrite = exports.authorizeForSystemWrite = exports.authorizeForSystemEmergency = exports.authorizeForSystemFeedbackRead = exports.authorizeForSystemRead = exports.authorizeForListUsersForUserGroup = exports.authorizeForObtainUserSelectionSessionForGeneric = exports.authorizeForObtainUserSelectionSessionForAccessControlPointGrant = exports.authorizeForObtainUserSelectionSessionForUserGroup = exports.authorizeForIdentityForbidRead = exports.authorizeForIdentityForbidEdit = exports.authorizeForSearchIdentity = exports.authorizeForGetIdentityBasic = exports.authorizeForGetIdentityDetailed = exports.authorizeForOrganizationSettings = exports.authorizeForSetEmergencyState = exports.authorizeForControlPanel = exports.authorizeForVisitorHistoryReport = exports.authorizeForAttendanceReport = exports.authorizeForAccessControlPointSummaryReport = exports.authorizeForAccessNotifications = exports.authorizeForSensorNotifications = exports.authorizeForVisitorAccessReport = exports.authorizeForSensorEvents = exports.authorizeForScheduledJobsWrite = exports.authorizeForScheduledJobsRead = exports.authorizeForAccessSelfReports = exports.authorizeForAccessReport = exports.authorizeForGetDeviceDetails = exports.authorizeForGetControlPanelDetails = exports.authorizeForInitializeClientAppRequestSystemHealth = exports.getUserIdFromToken = exports.throwAuthError = void 0;
exports.hasVisitorRead = exports.hasPermissionReadForAnyUnit = exports.hasHRRead = exports.hasHRApprovement = exports.authorizeForPPermissionHRApprovement = exports.authorizeForPPermissionReadAll = exports.authorizeForPPermissionRead = exports.authorizeForManualPPermissionWrite = exports.authorizeForPPermissionWrite = exports.authorizeForAttendancePlanWriteForAny = exports.authorizeForAttendancePlanWrite = exports.authorizeForAttendancePlanAssign = exports.authorizeForAttendanceControlReportForAny = exports.authorizeForAttendanceControlReport = exports.authorizeForAttendancePlanRead = exports.authorizeForListAvailableRoles = exports.authorizeForWriteSystem = exports.authorizeForReadSystem = exports.authorizeForSearchRemoteAccessGrantedAccessControlPoints = exports.authorizeForGetAccessControlPointDetailes = exports.authorizeForReadOrganizationUnitBasic = exports.authorizeForChangeOrganizationUnitDefaultAccessControlPoints = exports.authorizeForGetDetailedOrganizationUnit = exports.authorizeForSearchOrganizationUnit = exports.authorizeForGetChildrenOfOrganizationUnit = exports.authorizeForUpsertRegionAccessControlPoints = exports.authorizeForGetAccessControlPointsOfRegion = exports.authorizeForWriteRegion = exports.authorizeForRegionStateReport = exports.authorizeForGetRegions = exports.authorizeForGetOrganizationUnitsInOrganizationWide = exports.authorizeForRemoveOrganizationUnit = exports.authorizeForOrganizationUnitWrite = exports.authorizeForIdentityAccountUpdate = exports.authorizeForUpdateIdentity = exports.authorizeForRemoveUserGroup = exports.authorizeForReadLeave = exports.authorizeForWriteLeave = exports.authorizeForListWorkingHoursSchedule = exports.authorizeForListUserGroups = exports.authorizeForUpdateUserGroupUserMappings = exports.authorizeForUpdateUserGroup = exports.authorizeForAddUserGroup = exports.authorizeForVisitorViewAllVisitors = exports.authorizeForVisitorBlackList = exports.authorizeForVisitorTemporaryPermit = exports.authorizeForVisitorPreregisterForOthersRequest = exports.authorizeForVisitorPreregisterDelete = exports.authorizeForVisitorPreregisterSelfRequest = exports.authorizeForVisitorPreregisterOrVisitorReadRequest = void 0;
exports.authorizeForObtainUserSelectionSessionForUserOrganizationUnit = exports.authorizeForCustomReport = exports.authorizeForSocialRead = exports.authorizeForSocialWrite = exports.hasIdentityFullWrite = exports.hasIdentityBasicRead = exports.hasVisitorWrite = void 0;
const app_auth_1 = require("../app.auth");
const predefined_permissions_1 = require("../dal/db/predefined/predefined.permissions");
const app_enums_1 = require("../app.enums");
function throwAuthError(message, missingPermissions, requiredPermissions, isRoleChange) {
    throw {
        statusCode: app_enums_1.enums.HttpStatusCode.UNAUTHORIZED_ACCESS,
        body: {
            code: app_enums_1.enums.ArmonApiErrorCode.UNAUTHORIZED_API_ACCESS,
            message: message || "Your permissions are not enough!",
            missingPermissions: missingPermissions || [],
            requiredPermissions: requiredPermissions || [],
            isRoleChange: isRoleChange ? true : false,
        },
    };
}
exports.throwAuthError = throwAuthError;
function getUserIdFromToken(req) {
    const isPermitted = false;
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        return req.auth_token.userId;
    }
    throwAuthError();
}
exports.getUserIdFromToken = getUserIdFromToken;
function authorizeForInitializeClientAppRequestSystemHealth(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, predefined_permissions_1.Permissions.system.getRead(), false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForInitializeClientAppRequestSystemHealth = authorizeForInitializeClientAppRequestSystemHealth;
function authorizeForGetControlPanelDetails(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, predefined_permissions_1.Permissions.system.getRead(), false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetControlPanelDetails = authorizeForGetControlPanelDetails;
function authorizeForGetDeviceDetails(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, predefined_permissions_1.Permissions.system.getRead(), false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetDeviceDetails = authorizeForGetDeviceDetails;
function authorizeForAccessReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.accessLog.getReportDetailed())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.accessLog.getReportDetailed());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.accessLog.getReportDetailed()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.accessLog.getReportDetailed()]);
    }
    throwAuthError();
}
exports.authorizeForAccessReport = authorizeForAccessReport;
function authorizeForAccessSelfReports(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getIdentityReportRead()];
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return { jwt, hasOrganizationWide: true };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForAccessSelfReports = authorizeForAccessSelfReports;
function authorizeForScheduledJobsRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.scheduled_job.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.scheduled_job.getRead());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.scheduled_job.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.scheduled_job.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForScheduledJobsRead = authorizeForScheduledJobsRead;
function authorizeForScheduledJobsWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.scheduled_job.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.scheduled_job.getWrite());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.scheduled_job.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.scheduled_job.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForScheduledJobsWrite = authorizeForScheduledJobsWrite;
function authorizeForSensorEvents(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.accessLog.getReportDetailed())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.accessLog.getReportDetailed());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, predefined_permissions_1.Permissions.accessLog.getReportDetailed(), true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.accessLog.getReportDetailed()]);
    }
    throwAuthError();
}
exports.authorizeForSensorEvents = authorizeForSensorEvents;
function authorizeForVisitorAccessReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.accessLog.getReportDetailed(), predefined_permissions_1.Permissions.visitor.getRead()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.accessLog.getReportDetailed(), predefined_permissions_1.Permissions.visitor.getRead()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.accessLog.getReportDetailed(), predefined_permissions_1.Permissions.visitor.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.accessLog.getReportDetailed(), predefined_permissions_1.Permissions.visitor.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorAccessReport = authorizeForVisitorAccessReport;
function authorizeForSensorNotifications(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.identity.getAccessNotifications(), predefined_permissions_1.Permissions.system.getRead()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.identity.getAccessNotifications(), predefined_permissions_1.Permissions.system.getRead()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getAccessNotifications(), predefined_permissions_1.Permissions.system.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getAccessNotifications(), predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForSensorNotifications = authorizeForSensorNotifications;
function authorizeForAccessNotifications(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getAccessNotifications(), predefined_permissions_1.Permissions.system.getRead(), predefined_permissions_1.Permissions.accessLog.getReportSummary()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForAccessNotifications = authorizeForAccessNotifications;
function authorizeForAccessControlPointSummaryReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = predefined_permissions_1.Permissions.accessLog.getReportSummary();
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, [requiredPermissions]);
    }
    throwAuthError();
}
exports.authorizeForAccessControlPointSummaryReport = authorizeForAccessControlPointSummaryReport;
function authorizeForAttendanceReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.attendanceControl.getReport()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForAttendanceReport = authorizeForAttendanceReport;
function authorizeForVisitorHistoryReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.visitor.getRead()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForVisitorHistoryReport = authorizeForVisitorHistoryReport;
function authorizeForControlPanel(req) {
    let isPermitted = false;
    if (req.auth_token && req.auth_token instanceof app_auth_1.ControlPanelJwtPayload && req.auth_token.organizationId) {
        isPermitted = true;
    }
    if (!isPermitted) {
        throwAuthError();
    }
    return req.auth_token;
}
exports.authorizeForControlPanel = authorizeForControlPanel;
function authorizeForSetEmergencyState(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.system.getWrite()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForSetEmergencyState = authorizeForSetEmergencyState;
function authorizeForOrganizationSettings(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.organization.getEdit()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForOrganizationSettings = authorizeForOrganizationSettings;
function authorizeForGetIdentityDetailed(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getReadDetailed()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForGetIdentityDetailed = authorizeForGetIdentityDetailed;
function authorizeForGetIdentityBasic(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getReadBasic()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForGetIdentityBasic = authorizeForGetIdentityBasic;
function authorizeForSearchIdentity(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getReadBasic()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForSearchIdentity = authorizeForSearchIdentity;
function authorizeForIdentityForbidEdit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getIdentityForbiddenEdit()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForIdentityForbidEdit = authorizeForIdentityForbidEdit;
function authorizeForIdentityForbidRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getIdentityForbiddenView(), predefined_permissions_1.Permissions.identity.getReadBasic()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForIdentityForbidRead = authorizeForIdentityForbidRead;
function authorizeForObtainUserSelectionSessionForUserGroup(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getEdit()])) {
            return {
                jwt: jwt,
                hasOrganizationWideReadBasic: true,
                hasOrganizationWideWriteUserGroup: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            const result = {
                jwt: jwt,
                hasOrganizationWideWriteUserGroup: false,
                hasOrganizationWideReadBasic: jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getEdit()),
                readBasicOrganizationUnitIds: null,
            };
            if (!result.hasOrganizationWideReadBasic) {
                result.readBasicOrganizationUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.identity.getEdit());
                if (result.readBasicOrganizationUnitIds && result.readBasicOrganizationUnitIds.length > 0) {
                    return result;
                }
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getEdit()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getEdit()]);
    }
    throwAuthError();
}
exports.authorizeForObtainUserSelectionSessionForUserGroup = authorizeForObtainUserSelectionSessionForUserGroup;
function authorizeForObtainUserSelectionSessionForAccessControlPointGrant(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.identity.getEdit()])) {
            return {
                jwt: jwt,
                hasOrganizationWideIdentityEdit: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.identity.getEdit())) {
            const result = {
                jwt: jwt,
                hasOrganizationWideIdentityEdit: jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getEdit()),
                readBasicOrganizationUnitIds: null,
            };
            if (!result.hasOrganizationWideIdentityEdit) {
                result.readBasicOrganizationUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.identity.getEdit());
                if (result.readBasicOrganizationUnitIds && result.readBasicOrganizationUnitIds.length > 0) {
                    return result;
                }
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getEdit()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getEdit()]);
    }
    throwAuthError();
}
exports.authorizeForObtainUserSelectionSessionForAccessControlPointGrant = authorizeForObtainUserSelectionSessionForAccessControlPointGrant;
function authorizeForObtainUserSelectionSessionForGeneric(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.identity.getReadBasic()])) {
            return {
                jwt: jwt,
                hasOrganizationWideReadBasic: true,
                hasOrganizationWideWritePPermission: true,
            };
        }
        else {
            const result = {
                jwt: jwt,
                hasOrganizationWideWritePPermission: false,
                hasOrganizationWideReadBasic: jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getReadBasic()),
                readBasicOrganizationUnitIds: null,
            };
            if (!result.hasOrganizationWideReadBasic) {
                result.readBasicOrganizationUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.identity.getReadBasic());
                if (result.readBasicOrganizationUnitIds && result.readBasicOrganizationUnitIds.length > 0) {
                    return result;
                }
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getReadBasic()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForObtainUserSelectionSessionForGeneric = authorizeForObtainUserSelectionSessionForGeneric;
function authorizeForListUsersForUserGroup(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.userGroup.getRead(), predefined_permissions_1.Permissions.identity.getEdit()])) {
            return {
                jwt: jwt,
                hasOrganizationWideReadBasic: true,
                hasOrganizationWideReadUserGroup: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getRead())) {
            const result = {
                jwt: jwt,
                hasOrganizationWideReadUserGroup: false,
                hasOrganizationWideReadBasic: jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getEdit()),
                readBasicOrganizationUnitIds: null,
            };
            if (!result.hasOrganizationWideReadBasic) {
                result.readBasicOrganizationUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.identity.getEdit());
                if (result.readBasicOrganizationUnitIds && result.readBasicOrganizationUnitIds.length > 0) {
                    return result;
                }
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getRead(), predefined_permissions_1.Permissions.identity.getEdit()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getRead(), predefined_permissions_1.Permissions.identity.getEdit()]);
    }
    throwAuthError();
}
exports.authorizeForListUsersForUserGroup = authorizeForListUsersForUserGroup;
function authorizeForSystemRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForSystemRead = authorizeForSystemRead;
function authorizeForSystemFeedbackRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getFeedbackRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getFeedbackRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getFeedbackRead()]);
    }
    throwAuthError();
}
exports.authorizeForSystemFeedbackRead = authorizeForSystemFeedbackRead;
function authorizeForSystemEmergency(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getEmergency())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getEmergency()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getEmergency()]);
    }
    throwAuthError();
}
exports.authorizeForSystemEmergency = authorizeForSystemEmergency;
function authorizeForSystemWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForSystemWrite = authorizeForSystemWrite;
function authorizeForSystemFeedbackWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getFeedbackWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getFeedbackWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getFeedbackWrite()]);
    }
    throwAuthError();
}
exports.authorizeForSystemFeedbackWrite = authorizeForSystemFeedbackWrite;
function authorizeForInsertIdentity(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getCreate()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.identity.getCreate())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getCreate()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getCreate()]);
    }
    throwAuthError();
}
exports.authorizeForInsertIdentity = authorizeForInsertIdentity;
function authorizeForUserHierarchy(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const requiredPermissions = [predefined_permissions_1.Permissions.identity.getHierarchy()];
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForUserHierarchy = authorizeForUserHierarchy;
function authorizeForManageNotifications(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.user.getUser()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.user.getUser())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.user.getUser()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.user.getUser()]);
    }
    throwAuthError();
}
exports.authorizeForManageNotifications = authorizeForManageNotifications;
function authorizeForNewVisitRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForNewVisitRequest = authorizeForNewVisitRequest;
function authorizeForWriteRole(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.role.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.role.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.role.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForWriteRole = authorizeForWriteRole;
function authorizeForTerminateVisitRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForTerminateVisitRequest = authorizeForTerminateVisitRequest;
function authorizeForGetVisitorByIdRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetVisitorByIdRequest = authorizeForGetVisitorByIdRequest;
function authorizeForGetVisitorByCredentialRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetVisitorByCredentialRequest = authorizeForGetVisitorByCredentialRequest;
function authorizeForCollectUserIdsByFieldSelect(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getReadDetailed())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getReadDetailed()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getReadDetailed()]);
    }
    throwAuthError();
}
exports.authorizeForCollectUserIdsByFieldSelect = authorizeForCollectUserIdsByFieldSelect;
function authorizeForManualLogInsert(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const requiredPermissions = [predefined_permissions_1.Permissions.accessLog.getInsertManual()];
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForManualLogInsert = authorizeForManualLogInsert;
function authorizeForManualLogDelete(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const requiredPermissions = [predefined_permissions_1.Permissions.accessLog.getDeleteManual()];
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForManualLogDelete = authorizeForManualLogDelete;
function authorizeForGetUserByCredentialRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getReadBasic())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getReadBasic()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForGetUserByCredentialRequest = authorizeForGetUserByCredentialRequest;
function authorizeForVisitorFilterRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorFilterRequest = authorizeForVisitorFilterRequest;
function authorizeForListVisitorReadRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getRead()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForListVisitorReadRequest = authorizeForListVisitorReadRequest;
function authorizeForSearchVisitorRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getSearchAll()) || jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.user.getUser())) {
            return jwt;
        }
        let missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getSearchAll()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getSearchAll()]);
        }
        missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.user.getUser()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.user.getUser()]);
        }
    }
    throwAuthError();
}
exports.authorizeForSearchVisitorRequest = authorizeForSearchVisitorRequest;
function authorizeForListVisitorWriteRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForListVisitorWriteRequest = authorizeForListVisitorWriteRequest;
function authorizeForVisitorPreregisterOrVisitorWriteRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getPreregister()) || jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getWrite())) {
            return jwt;
        }
        let missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getPreregister()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getPreregister()]);
        }
        missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getWrite()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getWrite()]);
        }
    }
    throwAuthError();
}
exports.authorizeForVisitorPreregisterOrVisitorWriteRequest = authorizeForVisitorPreregisterOrVisitorWriteRequest;
function authorizeForVisitorPreregisterOrVisitorReadRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const result = {
            jwt: jwt,
            hasOrganizationWide: false,
        };
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getRead())) {
            result.hasOrganizationWide = true;
            return result;
        }
        else if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getPreregister())) {
            return result;
        }
        let missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getRead()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getRead()]);
        }
        missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getPreregister()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getPreregister()]);
        }
    }
    throwAuthError();
}
exports.authorizeForVisitorPreregisterOrVisitorReadRequest = authorizeForVisitorPreregisterOrVisitorReadRequest;
function authorizeForVisitorPreregisterSelfRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const requiredPermissions = [predefined_permissions_1.Permissions.visitor.getPreregister()];
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return { jwt, hasOrganizationWide: true };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions);
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, false);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForVisitorPreregisterSelfRequest = authorizeForVisitorPreregisterSelfRequest;
function authorizeForVisitorPreregisterDelete(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getDeletePreregister())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getDeletePreregister()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getDeletePreregister()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorPreregisterDelete = authorizeForVisitorPreregisterDelete;
function authorizeForVisitorPreregisterForOthersRequest(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getPreregister()) || jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getWrite())) {
            return jwt;
        }
        let missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getPreregister()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getPreregister()]);
        }
        missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getPreregister()], false);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getPreregister()]);
        }
    }
    throwAuthError();
}
exports.authorizeForVisitorPreregisterForOthersRequest = authorizeForVisitorPreregisterForOthersRequest;
function authorizeForVisitorTemporaryPermit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getTemporaryPermit()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getTemporaryPermit())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getTemporaryPermit()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getTemporaryPermit()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorTemporaryPermit = authorizeForVisitorTemporaryPermit;
function authorizeForVisitorBlackList(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getForbidden()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getForbidden())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getForbidden()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getForbidden()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorBlackList = authorizeForVisitorBlackList;
function authorizeForVisitorViewAllVisitors(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.visitor.getViewVisitors()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getViewVisitors())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.visitor.getViewVisitors()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.visitor.getViewVisitors()]);
    }
    throwAuthError();
}
exports.authorizeForVisitorViewAllVisitors = authorizeForVisitorViewAllVisitors;
function authorizeForAddUserGroup(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForAddUserGroup = authorizeForAddUserGroup;
function authorizeForUpdateUserGroup(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForUpdateUserGroup = authorizeForUpdateUserGroup;
function authorizeForUpdateUserGroupUserMappings(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getReadBasic()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getReadBasic()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getReadBasic()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getWrite(), predefined_permissions_1.Permissions.identity.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForUpdateUserGroupUserMappings = authorizeForUpdateUserGroupUserMappings;
function authorizeForListUserGroups(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.userGroup.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForListUserGroups = authorizeForListUserGroups;
function authorizeForListWorkingHoursSchedule(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendanceControl.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendanceControl.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendanceControl.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendanceControl.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForListWorkingHoursSchedule = authorizeForListWorkingHoursSchedule;
function authorizeForWriteLeave(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendanceControl.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendanceControl.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendanceControl.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendanceControl.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForWriteLeave = authorizeForWriteLeave;
function authorizeForReadLeave(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendanceControl.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendanceControl.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendanceControl.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendanceControl.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForReadLeave = authorizeForReadLeave;
function authorizeForRemoveUserGroup(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.userGroup.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.userGroup.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.userGroup.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForRemoveUserGroup = authorizeForRemoveUserGroup;
function authorizeForUpdateIdentity(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getEdit()) ||
            jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.identity.getReadDetailed(), predefined_permissions_1.Permissions.identity.getCredentialWrite()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.identity.getEdit()) ||
            jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.identity.getReadDetailed(), predefined_permissions_1.Permissions.identity.getCredentialWrite()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, [predefined_permissions_1.Permissions.identity.getReadDetailed(), predefined_permissions_1.Permissions.identity.getCredentialWrite()]),
            };
        }
        let missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getEdit()], true);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getEdit()]);
        }
        missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getReadDetailed(), predefined_permissions_1.Permissions.identity.getCredentialWrite()], true);
        if (missingPermissions.length > 0) {
            throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getReadDetailed(), predefined_permissions_1.Permissions.identity.getCredentialWrite()]);
        }
    }
    throwAuthError();
}
exports.authorizeForUpdateIdentity = authorizeForUpdateIdentity;
function authorizeForIdentityAccountUpdate(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getUserAccount())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.identity.getUserAccount())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.identity.getUserAccount()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.identity.getUserAccount()]);
    }
    throwAuthError();
}
exports.authorizeForIdentityAccountUpdate = authorizeForIdentityAccountUpdate;
function authorizeForOrganizationUnitWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.organizationUnit.getWrite()),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForOrganizationUnitWrite = authorizeForOrganizationUnitWrite;
function authorizeForRemoveOrganizationUnit(req, organizationId, action) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (action === app_enums_1.enums.RemoveOrganizationUnitAction.RemoveAccessRights && !jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getAccessRight())) {
            throwAuthError("identity:access_right permission is required to apply changes to the members", [predefined_permissions_1.Permissions.identity.getAccessRight()], [predefined_permissions_1.Permissions.identity.getAccessRight()]);
            return;
        }
        else if (action === app_enums_1.enums.RemoveOrganizationUnitAction.MakeUsersPassive && !jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getFullWrite())) {
            throwAuthError("identity:full_write permission is required to apply changes to the members", [predefined_permissions_1.Permissions.identity.getFullWrite()], [predefined_permissions_1.Permissions.identity.getFullWrite()]);
            return;
        }
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForRemoveOrganizationUnit = authorizeForRemoveOrganizationUnit;
function authorizeForGetOrganizationUnitsInOrganizationWide(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForGetOrganizationUnitsInOrganizationWide = authorizeForGetOrganizationUnitsInOrganizationWide;
function authorizeForGetRegions(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.region.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.region.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.region.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.region.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetRegions = authorizeForGetRegions;
function authorizeForRegionStateReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.region.getRead(), predefined_permissions_1.Permissions.accessLog.getReportSummary(), predefined_permissions_1.Permissions.identity.getReadBasic()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.region.getRead(), predefined_permissions_1.Permissions.accessLog.getReportSummary(), predefined_permissions_1.Permissions.identity.getReadBasic()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.region.getRead(), predefined_permissions_1.Permissions.accessLog.getReportSummary(), predefined_permissions_1.Permissions.identity.getReadBasic()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.region.getRead(), predefined_permissions_1.Permissions.accessLog.getReportSummary(), predefined_permissions_1.Permissions.identity.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForRegionStateReport = authorizeForRegionStateReport;
function authorizeForWriteRegion(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.region.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.region.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.region.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForWriteRegion = authorizeForWriteRegion;
function authorizeForGetAccessControlPointsOfRegion(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.region.getRead()])) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.region.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.region.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetAccessControlPointsOfRegion = authorizeForGetAccessControlPointsOfRegion;
function authorizeForUpsertRegionAccessControlPoints(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.region.getWrite()])) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.region.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.region.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForUpsertRegionAccessControlPoints = authorizeForUpsertRegionAccessControlPoints;
function authorizeForGetChildrenOfOrganizationUnit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForGetChildrenOfOrganizationUnit = authorizeForGetChildrenOfOrganizationUnit;
function authorizeForSearchOrganizationUnit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForSearchOrganizationUnit = authorizeForSearchOrganizationUnit;
function authorizeForGetDetailedOrganizationUnit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadDetailed())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadDetailed())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getReadDetailed()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getReadDetailed()]);
    }
    throwAuthError();
}
exports.authorizeForGetDetailedOrganizationUnit = authorizeForGetDetailedOrganizationUnit;
function authorizeForChangeOrganizationUnitDefaultAccessControlPoints(req, organizationId, applyToMembers) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (applyToMembers && !jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getAccessRight())) {
            throwAuthError("identity:access_right permission is required to apply changes to the members", [predefined_permissions_1.Permissions.identity.getAccessRight()], [predefined_permissions_1.Permissions.identity.getAccessRight()]);
            return;
        }
        if (jwt.isPermittedForOrganization(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getWrite()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getWrite()])) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForChangeOrganizationUnitDefaultAccessControlPoints = authorizeForChangeOrganizationUnitDefaultAccessControlPoints;
function authorizeForReadOrganizationUnitBasic(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.organizationUnit.getReadBasic()),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.organizationUnit.getReadBasic()]);
    }
    throwAuthError();
}
exports.authorizeForReadOrganizationUnitBasic = authorizeForReadOrganizationUnitBasic;
function authorizeForGetAccessControlPointDetailes(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForGetAccessControlPointDetailes = authorizeForGetAccessControlPointDetailes;
function authorizeForSearchRemoteAccessGrantedAccessControlPoints(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.user.getUser())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.user.getUser()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.user.getUser()]);
    }
    throwAuthError();
}
exports.authorizeForSearchRemoteAccessGrantedAccessControlPoints = authorizeForSearchRemoteAccessGrantedAccessControlPoints;
function authorizeForReadSystem(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.system.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getRead()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForReadSystem = authorizeForReadSystem;
function authorizeForWriteSystem(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (predefined_permissions_1.Permissions.system.getWrite()) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.system.getWrite()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.system.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForWriteSystem = authorizeForWriteSystem;
function authorizeForListAvailableRoles(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.user.getUser())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.user.getUser()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.user.getUser()]);
    }
    throwAuthError();
}
exports.authorizeForListAvailableRoles = authorizeForListAvailableRoles;
function authorizeForAttendancePlanRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendancePlan.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.attendancePlan.getRead());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendancePlan.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendancePlan.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForAttendancePlanRead = authorizeForAttendancePlanRead;
function authorizeForAttendanceControlReport(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendanceControl.getReport()) ||
            jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendanceControl.getReport())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendanceControl.getReport()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendanceControl.getReport()]);
    }
    throwAuthError();
}
exports.authorizeForAttendanceControlReport = authorizeForAttendanceControlReport;
function authorizeForAttendanceControlReportForAny(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendanceControl.getReport())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendanceControl.getReport())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.attendanceControl.getReport()),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendanceControl.getReport()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendanceControl.getReport()]);
    }
    throwAuthError();
}
exports.authorizeForAttendanceControlReportForAny = authorizeForAttendanceControlReportForAny;
function authorizeForAttendancePlanAssign(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendancePlan.getAssign())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.attendancePlan.getAssign());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendancePlan.getAssign()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendancePlan.getAssign()]);
    }
    throwAuthError();
}
exports.authorizeForAttendancePlanAssign = authorizeForAttendancePlanAssign;
function authorizeForAttendancePlanWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else {
            const permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite());
            if (permittedUnitIds.length > 0) {
                return {
                    jwt: jwt,
                    hasOrganizationWide: false,
                    permittedUnitIds: permittedUnitIds,
                };
            }
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendancePlan.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendancePlan.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForAttendancePlanWrite = authorizeForAttendancePlanWrite;
function authorizeForAttendancePlanWriteForAny(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.attendancePlan.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.attendancePlan.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.attendancePlan.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForAttendancePlanWriteForAny = authorizeForAttendancePlanWriteForAny;
function authorizeForPPermissionWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getWrite()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getWrite())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForPPermissionWrite = authorizeForPPermissionWrite;
function authorizeForManualPPermissionWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getManuallyWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getManuallyWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.ppermission.getManuallyWrite()),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getManuallyWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getManuallyWrite()]);
    }
    throwAuthError();
}
exports.authorizeForManualPPermissionWrite = authorizeForManualPPermissionWrite;
function authorizeForPPermissionRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getRead()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getRead())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForPPermissionRead = authorizeForPPermissionRead;
function authorizeForPPermissionReadAll(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getReadAll()) || jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getReadAll())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getReadAll()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getReadAll()]);
    }
    throwAuthError();
}
exports.authorizeForPPermissionReadAll = authorizeForPPermissionReadAll;
function authorizeForPPermissionHRApprovement(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getHRApprovement())) {
            return jwt;
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getHRApprovement())) {
            return jwt;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getHRApprovement()], false);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getHRApprovement()]);
    }
    throwAuthError();
}
exports.authorizeForPPermissionHRApprovement = authorizeForPPermissionHRApprovement;
function hasHRApprovement(req, organizationId) {
    const result = {
        isHR: false,
        isUnitManager: false,
        permittedUnitIds: [],
    };
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getHRApprovement())) {
            result.isHR = true;
            return result;
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getWrite())) {
            result.isUnitManager = true;
            result.permittedUnitIds = jwt.getPermittedUnitIdsFor(organizationId, predefined_permissions_1.Permissions.ppermission.getWrite());
            return result;
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.ppermission.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.ppermission.getWrite()]);
    }
    throwAuthError();
}
exports.hasHRApprovement = hasHRApprovement;
function hasHRRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.ppermission.getRead());
    }
    return false;
}
exports.hasHRRead = hasHRRead;
function hasPermissionReadForAnyUnit(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.ppermission.getRead());
    }
    return false;
}
exports.hasPermissionReadForAnyUnit = hasPermissionReadForAnyUnit;
function hasVisitorRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.hasPermissionForOrganizationOrAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getRead());
    }
    return false;
}
exports.hasVisitorRead = hasVisitorRead;
function hasVisitorWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.hasPermissionForOrganizationOrAnyUnit(organizationId, predefined_permissions_1.Permissions.visitor.getWrite());
    }
    return false;
}
exports.hasVisitorWrite = hasVisitorWrite;
function hasIdentityBasicRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.hasPermissionForOrganizationOrAnyUnit(organizationId, predefined_permissions_1.Permissions.identity.getReadBasic());
    }
    return false;
}
exports.hasIdentityBasicRead = hasIdentityBasicRead;
function hasIdentityFullWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        return jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.identity.getFullWrite());
    }
    return false;
}
exports.hasIdentityFullWrite = hasIdentityFullWrite;
function authorizeForSocialWrite(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.social.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.social.getWrite())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.social.getWrite()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.social.getWrite()]);
    }
    throwAuthError();
}
exports.authorizeForSocialWrite = authorizeForSocialWrite;
function authorizeForSocialRead(req, organizationId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, predefined_permissions_1.Permissions.social.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, predefined_permissions_1.Permissions.social.getRead())) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, [predefined_permissions_1.Permissions.social.getRead()], true);
        throwAuthError(null, missingPermissions, [predefined_permissions_1.Permissions.social.getRead()]);
    }
    throwAuthError();
}
exports.authorizeForSocialRead = authorizeForSocialRead;
function authorizeForCustomReport(req, organizationId, minimumPermissions) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        if (jwt.isPermittedForOrganization(organizationId, minimumPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, minimumPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedUnitIds: jwt.getPermittedUnitIdsFor(organizationId, minimumPermissions),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, minimumPermissions, true);
        throwAuthError(null, missingPermissions, minimumPermissions);
    }
    throwAuthError();
}
exports.authorizeForCustomReport = authorizeForCustomReport;
function authorizeForObtainUserSelectionSessionForUserOrganizationUnit(req, organizationId, organizationUnitId) {
    if (req.auth_token && req.auth_token instanceof app_auth_1.UserJwtPayload) {
        const jwt = req.auth_token;
        const requiredPermissions = [predefined_permissions_1.Permissions.organizationUnit.getReadBasic(), predefined_permissions_1.Permissions.identity.getReadBasic(), predefined_permissions_1.Permissions.identity.getHierarchy()];
        if (jwt.isPermittedForOrganization(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: true,
            };
        }
        else if (jwt.isPermittedForAnyUnit(organizationId, requiredPermissions)) {
            return {
                jwt: jwt,
                hasOrganizationWide: false,
                permittedOrganizationUnitIds: jwt.getPermittedUnitIdsFor(organizationId, requiredPermissions),
            };
        }
        const missingPermissions = jwt.getMissingPermissions(organizationId, requiredPermissions, true);
        throwAuthError(null, missingPermissions, requiredPermissions);
    }
    throwAuthError();
}
exports.authorizeForObtainUserSelectionSessionForUserOrganizationUnit = authorizeForObtainUserSelectionSessionForUserOrganizationUnit;
