"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiModelsCommon = void 0;
const app_enums_1 = require("../app.enums");
const moment_1 = __importDefault(require("moment"));
var ApiModelsCommon;
(function (ApiModelsCommon) {
    class PaginationRequest {
        constructor(raw, max, validator, finalize) {
            validator.validateInteger({
                field: "take",
                optional: false,
                input: raw?.take,
                max: max,
            });
            validator.validateInteger({
                field: "skip",
                optional: true,
                input: raw?.skip,
            });
            this.take = raw?.take ? parseInt(raw.take) : 100;
            this.skip = raw?.skip ? parseInt(raw.skip) : 0;
            if (finalize) {
                validator.finalize();
            }
        }
    }
    ApiModelsCommon.PaginationRequest = PaginationRequest;
    class DateRange {
        constructor(reqBody, validator, finalize) {
            this.startDateTime = (0, moment_1.default)(reqBody.startDateTime).toDate();
            this.endDateTime = (0, moment_1.default)(reqBody.endDateTime).toDate();
            if (finalize) {
                validator.finalize();
            }
        }
    }
    ApiModelsCommon.DateRange = DateRange;
    class AskUsersWithPaginationRequest extends PaginationRequest {
        constructor(raw, validator) {
            super(raw, 10000, validator);
            this.sessionId = raw.sessionId;
        }
    }
    ApiModelsCommon.AskUsersWithPaginationRequest = AskUsersWithPaginationRequest;
    class AskDeviceDataRequest {
        constructor(raw, validator) {
            validator.validateIsBoolean("configurationAndSettings", true, raw.configurationAndSettings);
            this.configurationAndSettings = raw.configurationAndSettings === true;
        }
    }
    ApiModelsCommon.AskDeviceDataRequest = AskDeviceDataRequest;
    class AskDeviceDataZip extends AskDeviceDataRequest {
        constructor(raw, validator) {
            super(raw, validator);
            validator.validateIsBoolean("users", true, raw.users);
            validator.validateEnumArray("credentialTypes", true, app_enums_1.enums.CredentialType, raw.credentialTypes);
            validator.validateIsBoolean("accessNotificationEvents", true, raw.accessNotificationEvents);
            this.users = raw.users === true;
            this.credentialTypes = raw.credentialTypes;
            this.currentSoftwareVersion = raw.currentSoftwareVersion;
            this.accessNotificationEvents = raw.accessNotificationEvents === true;
        }
    }
    ApiModelsCommon.AskDeviceDataZip = AskDeviceDataZip;
})(ApiModelsCommon = exports.ApiModelsCommon || (exports.ApiModelsCommon = {}));
