"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiAperioAdapterControllerV3 = void 0;
const express_1 = __importDefault(require("express"));
const dal_manager_1 = require("../../../dal/dal.manager");
const api_auth_1 = require("../../api.auth");
const api_util_1 = require("../../api.util");
class ApiAperioAdapterControllerV3 {
    constructor(app) {
        this.getAdapterConfig = async (req, res) => {
            let hubConfig = await dal_manager_1.dbManager.accessDevice.getAperioAdapterConfigurationAndSettingsV2(req.organizationId, req.adapterId);
            (0, api_auth_1.sendZippedJsonResponse)(hubConfig, res);
        };
        this.getAperioHubConfig = async (req, res) => {
            let request = req.body;
            let config = await dal_manager_1.dbManager.accessDevice.getAperioHubConfigurationAndSettingsV2(req.organizationId, req.deviceId, request.configurationAndSettings);
            (0, api_auth_1.sendZippedJsonResponse)(config, res);
        };
        this._router = express_1.default.Router();
        this._router.post("/adapter/config", api_auth_1.adapterAuthorize, (0, api_util_1.globalRouteHandler)(this.getAdapterConfig));
        this._router.post("/hub/config", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.getAperioHubConfig));
        app.use("/p1/v3", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiAperioAdapterControllerV3 = ApiAperioAdapterControllerV3;
