"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AperioApiModelsV1 = void 0;
const api_validatorhelper_1 = require("../../api.validatorhelper");
var AperioApiModelsV1;
(function (AperioApiModelsV1) {
    class AskAdapterDataRequest {
        constructor(raw, validator) {
            validator.validateIsBoolean("configurationAndSettings", true, raw.configurationAndSettings);
            this.configurationAndSettings = raw.configurationAndSettings === true;
        }
    }
    AperioApiModelsV1.AskAdapterDataRequest = AskAdapterDataRequest;
    class UpdateAperioHubConfig {
        constructor(raw, validator) {
            validator.validateUUID("lockIds", true, raw.lockIds);
            this.lockIds = raw.lockIds;
        }
    }
    AperioApiModelsV1.UpdateAperioHubConfig = UpdateAperioHubConfig;
    class UploadLogRequest {
        constructor(raw) {
            let validator = new api_validatorhelper_1.ValidatorHelper();
            validator.validateUUID("uploadId", false, raw.uploadId);
            validator.finalize();
            this.uploadId = raw.uploadId;
            this.accessLogs = raw.accessLogs;
        }
    }
    AperioApiModelsV1.UploadLogRequest = UploadLogRequest;
})(AperioApiModelsV1 = exports.AperioApiModelsV1 || (exports.AperioApiModelsV1 = {}));
