"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiAperioAdapterController = void 0;
const express_1 = __importDefault(require("express"));
const dal_manager_1 = require("../../../dal/dal.manager");
const api_auth_1 = require("../../api.auth");
const api_util_1 = require("../../api.util");
const api_validatorhelper_1 = require("../../api.validatorhelper");
const api_aperio_model_1 = require("./api.aperio.model");
class ApiAperioAdapterController {
    constructor(app) {
        this.getAdapterConfig = async (req, res) => {
            let devices = await dal_manager_1.dbManager.accessDevice.getDevicesOfAdapter(req.organizationId, req.adapterId);
            (0, api_auth_1.sendZippedJsonResponse)(devices, res);
        };
        this.getAperioHubConfig = async (req, res) => {
            let config = await dal_manager_1.dbManager.accessDevice.getAperioHubConfigurationAndSettings(req.organizationId, req.deviceId);
            (0, api_auth_1.sendZippedJsonResponse)(config, res);
        };
        this.updateAperioHubConfig = async (req, res) => {
            let request = new api_aperio_model_1.AperioApiModelsV1.UpdateAperioHubConfig(req.body, new api_validatorhelper_1.ValidatorHelper());
            let result = await dal_manager_1.dbManager.accessDevice.updateAperioHubConfigurationAndSettings(req.organizationId, req.deviceId, request.lockIds);
            (0, api_auth_1.sendZippedJsonResponse)(result, res);
        };
        this._router = express_1.default.Router();
        this._router.get("/adapter/config", api_auth_1.adapterAuthorize, (0, api_util_1.globalRouteHandler)(this.getAdapterConfig));
        this._router.get("/hub/config", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.getAperioHubConfig));
        this._router.post("/hub/config", api_auth_1.terminalAuthorize, (0, api_util_1.globalRouteHandler)(this.updateAperioHubConfig));
        app.use("/p1/v1", express_1.default.json({ limit: "100mb" }), this._router);
    }
}
exports.ApiAperioAdapterController = ApiAperioAdapterController;
